// third_party/blink/public/mojom/interest_group/interest_group_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class InterestGroupAdDataView;

class SellerCapabilitiesDataView;

class AuctionServerRequestFlagsDataView;

class AdKeywordReplacementDataView;

class InterestGroupDataView;

class PreviousWinDataView;

class ViewOrClickCountsDataView;

class ViewAndClickCountsDataView;

class BiddingBrowserSignalsDataView;

class StorageInterestGroupDataView;

class DirectFromSellerSignalsSubresourceDataView;

class DirectFromSellerSignalsDataView;

class AuctionAdConfigBuyerTimeoutsDataView;

class AdCurrencyDataView;

class AuctionAdConfigBuyerCurrenciesDataView;

class AuctionAdServerResponseConfigDataView;

class AuctionReportBuyerDebugModeConfigDataView;

class AuctionReportBuyersConfigDataView;

class AuctionAdConfigNonSharedParamsDataView;

class AuctionAdConfigDataView;

class AuctionDataBuyerConfigDataView;

class AuctionDataConfigDataView;

class AdAuctionPerSellerRequestDataView;

class AuctionAdConfigMaybePromiseJsonDataView;
class AuctionAdConfigMaybePromisePerBuyerSignalsDataView;
class AuctionAdConfigMaybePromiseBuyerTimeoutsDataView;
class AuctionAdConfigMaybePromiseBuyerCurrenciesDataView;
class AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView;
class AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView;
class AdAuctionRequestOrErrorDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::InterestGroupAdDataView> {
  using Data = ::blink::mojom::internal::InterestGroupAd_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SellerCapabilitiesDataView> {
  using Data = ::blink::mojom::internal::SellerCapabilities_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionServerRequestFlagsDataView> {
  using Data = ::blink::mojom::internal::AuctionServerRequestFlags_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdKeywordReplacementDataView> {
  using Data = ::blink::mojom::internal::AdKeywordReplacement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InterestGroupDataView> {
  using Data = ::blink::mojom::internal::InterestGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PreviousWinDataView> {
  using Data = ::blink::mojom::internal::PreviousWin_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ViewOrClickCountsDataView> {
  using Data = ::blink::mojom::internal::ViewOrClickCounts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ViewAndClickCountsDataView> {
  using Data = ::blink::mojom::internal::ViewAndClickCounts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BiddingBrowserSignalsDataView> {
  using Data = ::blink::mojom::internal::BiddingBrowserSignals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StorageInterestGroupDataView> {
  using Data = ::blink::mojom::internal::StorageInterestGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DirectFromSellerSignalsSubresourceDataView> {
  using Data = ::blink::mojom::internal::DirectFromSellerSignalsSubresource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DirectFromSellerSignalsDataView> {
  using Data = ::blink::mojom::internal::DirectFromSellerSignals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigBuyerTimeouts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdCurrencyDataView> {
  using Data = ::blink::mojom::internal::AdCurrency_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigBuyerCurrencies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdServerResponseConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionAdServerResponseConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionReportBuyerDebugModeConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionReportBuyerDebugModeConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionReportBuyersConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionReportBuyersConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigNonSharedParamsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigNonSharedParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionDataBuyerConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionDataBuyerConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionDataConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionDataConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdAuctionPerSellerRequestDataView> {
  using Data = ::blink::mojom::internal::AdAuctionPerSellerRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseJson_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdAuctionRequestOrErrorDataView> {
  using Data = ::blink::mojom::internal::AdAuctionRequestOrError_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class InterestGroup_ExecutionMode : int32_t {
  
  kCompatibilityMode = 0,
  
  kGroupedByOriginMode = 1,
  
  kFrozenContext = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, InterestGroup_ExecutionMode value);
inline bool IsKnownEnumValue(InterestGroup_ExecutionMode value) {
  return internal::InterestGroup_ExecutionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline InterestGroup_ExecutionMode ToKnownEnumValue(InterestGroup_ExecutionMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return InterestGroup_ExecutionMode::kDefaultValue;
}


enum class InterestGroup_TrustedBiddingSignalsSlotSizeMode : int32_t {
  
  kNone = 0,
  
  kSlotSize = 1,
  
  kAllSlotsRequestedSizes = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, InterestGroup_TrustedBiddingSignalsSlotSizeMode value);
inline bool IsKnownEnumValue(InterestGroup_TrustedBiddingSignalsSlotSizeMode value) {
  return internal::InterestGroup_TrustedBiddingSignalsSlotSizeMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline InterestGroup_TrustedBiddingSignalsSlotSizeMode ToKnownEnumValue(InterestGroup_TrustedBiddingSignalsSlotSizeMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return InterestGroup_TrustedBiddingSignalsSlotSizeMode::kDefaultValue;
}


enum class AuctionAdConfigNonSharedParams_BuyerReportType : int32_t {
  
  kInterestGroupCount = 0,
  
  kBidCount = 1,
  
  kTotalGenerateBidLatency = 2,
  
  kTotalSignalsFetchLatency = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AuctionAdConfigNonSharedParams_BuyerReportType value);
inline bool IsKnownEnumValue(AuctionAdConfigNonSharedParams_BuyerReportType value) {
  return internal::AuctionAdConfigNonSharedParams_BuyerReportType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AuctionAdConfigNonSharedParams_RealTimeReportingType : int32_t {
  
  kDefaultLocalReporting = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AuctionAdConfigNonSharedParams_RealTimeReportingType value);
inline bool IsKnownEnumValue(AuctionAdConfigNonSharedParams_RealTimeReportingType value) {
  return internal::AuctionAdConfigNonSharedParams_RealTimeReportingType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class InterestGroupAdDataView {
 public:
  InterestGroupAdDataView() = default;

  InterestGroupAdDataView(
      internal::InterestGroupAd_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRenderUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRenderUrl(UserType* output) {
    
    auto* pointer = data_->render_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSizeGroupDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeGroup(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `size_group` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSizeGroup` instead "
    "of `ReadSizeGroup if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size_group.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `buyer_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBuyerReportingId` instead "
    "of `ReadBuyerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buyer_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBuyerAndSellerReportingId` instead "
    "of `ReadBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectableBuyerAndSellerReportingIdsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectableBuyerAndSellerReportingIds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `selectable_buyer_and_seller_reporting_ids` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelectableBuyerAndSellerReportingIds` instead "
    "of `ReadSelectableBuyerAndSellerReportingIds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->selectable_buyer_and_seller_reporting_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMetadata` instead "
    "of `ReadMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdRenderIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdRenderId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `ad_render_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdRenderId` instead "
    "of `ReadAdRenderId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_render_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAllowedReportingOriginsDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedReportingOrigins(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::url::mojom::OriginDataView>, UserType>(),
    "Attempting to read the optional `allowed_reporting_origins` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllowedReportingOrigins` instead "
    "of `ReadAllowedReportingOrigins if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->allowed_reporting_origins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, message_);
  }
  inline void GetCreativeScanningMetadataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreativeScanningMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `creative_scanning_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCreativeScanningMetadata` instead "
    "of `ReadCreativeScanningMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->creative_scanning_metadata.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::InterestGroupAd_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SellerCapabilitiesDataView {
 public:
  SellerCapabilitiesDataView() = default;

  SellerCapabilitiesDataView(
      internal::SellerCapabilities_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allows_interest_group_counts() const {
    return data_->allows_interest_group_counts;
  }
  bool allows_latency_stats() const {
    return data_->allows_latency_stats;
  }
 private:
  internal::SellerCapabilities_Data* data_ = nullptr;
};


class AuctionServerRequestFlagsDataView {
 public:
  AuctionServerRequestFlagsDataView() = default;

  AuctionServerRequestFlagsDataView(
      internal::AuctionServerRequestFlags_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool omit_ads() const {
    return data_->omit_ads;
  }
  bool include_full_ads() const {
    return data_->include_full_ads;
  }
  bool omit_user_bidding_signals() const {
    return data_->omit_user_bidding_signals;
  }
 private:
  internal::AuctionServerRequestFlags_Data* data_ = nullptr;
};


class AdKeywordReplacementDataView {
 public:
  AdKeywordReplacementDataView() = default;

  AdKeywordReplacementDataView(
      internal::AdKeywordReplacement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMatchDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatch(UserType* output) {
    
    auto* pointer = data_->match.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetReplacementDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplacement(UserType* output) {
    
    auto* pointer = data_->replacement.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdKeywordReplacement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InterestGroupDataView {
 public:
  InterestGroupDataView() = default;

  InterestGroupDataView(
      internal::InterestGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExpiryDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiry(UserType* output) {
    
    auto* pointer = data_->expiry.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetOwnerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOwner(UserType* output) {
    
    auto* pointer = data_->owner.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double priority() const {
    return data_->priority;
  }
  bool enable_bidding_signals_prioritization() const {
    return data_->enable_bidding_signals_prioritization;
  }
  inline void GetPriorityVectorDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPriorityVector(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, double>, UserType>(),
    "Attempting to read the optional `priority_vector` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPriorityVector` instead "
    "of `ReadPriorityVector if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->priority_vector.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  inline void GetPrioritySignalsOverridesDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrioritySignalsOverrides(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, double>, UserType>(),
    "Attempting to read the optional `priority_signals_overrides` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrioritySignalsOverrides` instead "
    "of `ReadPrioritySignalsOverrides if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->priority_signals_overrides.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  inline void GetSellerCapabilitiesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, SellerCapabilitiesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerCapabilities(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::SellerCapabilitiesDataView>, UserType>(),
    "Attempting to read the optional `seller_capabilities` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerCapabilities` instead "
    "of `ReadSellerCapabilities if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_capabilities.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::SellerCapabilitiesDataView>>(
        pointer, output, message_);
  }
  inline void GetAllSellersCapabilitiesDataView(
      SellerCapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllSellersCapabilities(UserType* output) {
    
    auto* pointer = data_->all_sellers_capabilities.Get();
    return mojo::internal::Deserialize<::blink::mojom::SellerCapabilitiesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadExecutionMode(UserType* output) const {
    auto data_value = data_->execution_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_ExecutionMode>(
        data_value, output);
  }
  InterestGroup_ExecutionMode execution_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_ExecutionMode>(data_->execution_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsSlotSizeMode(UserType* output) const {
    auto data_value = data_->trusted_bidding_signals_slot_size_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(
        data_value, output);
  }
  InterestGroup_TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(data_->trusted_bidding_signals_slot_size_mode));
  }
  inline void GetBiddingUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiddingUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `bidding_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiddingUrl` instead "
    "of `ReadBiddingUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bidding_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetBiddingWasmHelperUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiddingWasmHelperUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `bidding_wasm_helper_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiddingWasmHelperUrl` instead "
    "of `ReadBiddingWasmHelperUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bidding_wasm_helper_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `update_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUpdateUrl` instead "
    "of `ReadUpdateUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->update_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedBiddingSignalsUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsUrl` instead "
    "of `ReadTrustedBiddingSignalsUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedBiddingSignalsKeysDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsKeys` instead "
    "of `ReadTrustedBiddingSignalsKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  int32_t max_trusted_bidding_signals_url_length() const {
    return data_->max_trusted_bidding_signals_url_length;
  }
  inline void GetTrustedBiddingSignalsCoordinatorDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsCoordinator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_coordinator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsCoordinator` instead "
    "of `ReadTrustedBiddingSignalsCoordinator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_coordinator.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetViewAndClickCountsProvidersDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewAndClickCountsProviders(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::url::mojom::OriginDataView>, UserType>(),
    "Attempting to read the optional `view_and_click_counts_providers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewAndClickCountsProviders` instead "
    "of `ReadViewAndClickCountsProviders if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_and_click_counts_providers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, message_);
  }
  inline void GetUserBiddingSignalsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserBiddingSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `user_bidding_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserBiddingSignals` instead "
    "of `ReadUserBiddingSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_bidding_signals.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdsDataView(
      mojo::ArrayDataView<InterestGroupAdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, UserType>(),
    "Attempting to read the optional `ads` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAds` instead "
    "of `ReadAds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ads.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        pointer, output, message_);
  }
  inline void GetAdComponentsDataView(
      mojo::ArrayDataView<InterestGroupAdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdComponents(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, UserType>(),
    "Attempting to read the optional `ad_components` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdComponents` instead "
    "of `ReadAdComponents if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_components.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        pointer, output, message_);
  }
  inline void GetAdSizesDataView(
      mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdSizes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>, UserType>(),
    "Attempting to read the optional `ad_sizes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdSizes` instead "
    "of `ReadAdSizes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_sizes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>>(
        pointer, output, message_);
  }
  inline void GetSizeGroupsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeGroups(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>, UserType>(),
    "Attempting to read the optional `size_groups` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSizeGroups` instead "
    "of `ReadSizeGroups if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size_groups.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, message_);
  }
  inline void GetAuctionServerRequestFlagsDataView(
      AuctionServerRequestFlagsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionServerRequestFlags(UserType* output) {
    
    auto* pointer = data_->auction_server_request_flags.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionServerRequestFlagsDataView>(
        pointer, output, message_);
  }
  inline void GetAdditionalBidKeyDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalBidKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `additional_bid_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdditionalBidKey` instead "
    "of `ReadAdditionalBidKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->additional_bid_key.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetAggregationCoordinatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `aggregation_coordinator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregationCoordinatorOrigin` instead "
    "of `ReadAggregationCoordinatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::InterestGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PreviousWinDataView {
 public:
  PreviousWinDataView() = default;

  PreviousWinDataView(
      internal::PreviousWin_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetAdJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdJson(UserType* output) {
    
    auto* pointer = data_->ad_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PreviousWin_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ViewOrClickCountsDataView {
 public:
  ViewOrClickCountsDataView() = default;

  ViewOrClickCountsDataView(
      internal::ViewOrClickCounts_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t past_hour() const {
    return data_->past_hour;
  }
  int32_t past_day() const {
    return data_->past_day;
  }
  int32_t past_week() const {
    return data_->past_week;
  }
  int32_t past_30_days() const {
    return data_->past_30_days;
  }
  int32_t past_90_days() const {
    return data_->past_90_days;
  }
 private:
  internal::ViewOrClickCounts_Data* data_ = nullptr;
};


class ViewAndClickCountsDataView {
 public:
  ViewAndClickCountsDataView() = default;

  ViewAndClickCountsDataView(
      internal::ViewAndClickCounts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetViewCountsDataView(
      ViewOrClickCountsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewCounts(UserType* output) {
    
    auto* pointer = data_->view_counts.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewOrClickCountsDataView>(
        pointer, output, message_);
  }
  inline void GetClickCountsDataView(
      ViewOrClickCountsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClickCounts(UserType* output) {
    
    auto* pointer = data_->click_counts.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewOrClickCountsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ViewAndClickCounts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BiddingBrowserSignalsDataView {
 public:
  BiddingBrowserSignalsDataView() = default;

  BiddingBrowserSignalsDataView(
      internal::BiddingBrowserSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t join_count() const {
    return data_->join_count;
  }
  int32_t bid_count() const {
    return data_->bid_count;
  }
  inline void GetPrevWinsDataView(
      mojo::ArrayDataView<PreviousWinDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrevWins(UserType* output) {
    
    auto* pointer = data_->prev_wins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PreviousWinDataView>>(
        pointer, output, message_);
  }
  bool for_debugging_only_in_cooldown_or_lockout() const {
    return data_->for_debugging_only_in_cooldown_or_lockout;
  }
  inline void GetViewAndClickCountsDataView(
      ViewAndClickCountsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewAndClickCounts(UserType* output) {
    
    auto* pointer = data_->view_and_click_counts.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewAndClickCountsDataView>(
        pointer, output, message_);
  }
 private:
  internal::BiddingBrowserSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StorageInterestGroupDataView {
 public:
  StorageInterestGroupDataView() = default;

  StorageInterestGroupDataView(
      internal::StorageInterestGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInterestGroupDataView(
      InterestGroupDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroup(UserType* output) {
    
    auto* pointer = data_->interest_group.Get();
    return mojo::internal::Deserialize<::blink::mojom::InterestGroupDataView>(
        pointer, output, message_);
  }
  inline void GetBiddingBrowserSignalsDataView(
      BiddingBrowserSignalsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiddingBrowserSignals(UserType* output) {
    
    auto* pointer = data_->bidding_browser_signals.Get();
    return mojo::internal::Deserialize<::blink::mojom::BiddingBrowserSignalsDataView>(
        pointer, output, message_);
  }
  inline void GetJoiningOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJoiningOrigin(UserType* output) {
    
    auto* pointer = data_->joining_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetJoinTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJoinTime(UserType* output) {
    
    auto* pointer = data_->join_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastUpdatedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUpdated(UserType* output) {
    
    auto* pointer = data_->last_updated.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetNextUpdateAfterDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNextUpdateAfter(UserType* output) {
    
    auto* pointer = data_->next_update_after.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  uint64_t estimated_size() const {
    return data_->estimated_size;
  }
 private:
  internal::StorageInterestGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DirectFromSellerSignalsSubresourceDataView {
 public:
  DirectFromSellerSignalsSubresourceDataView() = default;

  DirectFromSellerSignalsSubresourceDataView(
      internal::DirectFromSellerSignalsSubresource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBundleUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBundleUrl(UserType* output) {
    
    auto* pointer = data_->bundle_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::DirectFromSellerSignalsSubresource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DirectFromSellerSignalsDataView {
 public:
  DirectFromSellerSignalsDataView() = default;

  DirectFromSellerSignalsDataView(
      internal::DirectFromSellerSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrefixDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrefix(UserType* output) {
    
    auto* pointer = data_->prefix.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerSignalsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, DirectFromSellerSignalsSubresourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerSignals(UserType* output) {
    
    auto* pointer = data_->per_buyer_signals.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::DirectFromSellerSignalsSubresourceDataView>>(
        pointer, output, message_);
  }
  inline void GetSellerSignalsDataView(
      DirectFromSellerSignalsSubresourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DirectFromSellerSignalsSubresourceDataView, UserType>(),
    "Attempting to read the optional `seller_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerSignals` instead "
    "of `ReadSellerSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_signals.Get();
    return mojo::internal::Deserialize<::blink::mojom::DirectFromSellerSignalsSubresourceDataView>(
        pointer, output, message_);
  }
  inline void GetAuctionSignalsDataView(
      DirectFromSellerSignalsSubresourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DirectFromSellerSignalsSubresourceDataView, UserType>(),
    "Attempting to read the optional `auction_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionSignals` instead "
    "of `ReadAuctionSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_signals.Get();
    return mojo::internal::Deserialize<::blink::mojom::DirectFromSellerSignalsSubresourceDataView>(
        pointer, output, message_);
  }
 private:
  internal::DirectFromSellerSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigBuyerTimeoutsDataView {
 public:
  AuctionAdConfigBuyerTimeoutsDataView() = default;

  AuctionAdConfigBuyerTimeoutsDataView(
      internal::AuctionAdConfigBuyerTimeouts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllBuyersTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllBuyersTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `all_buyers_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllBuyersTimeout` instead "
    "of `ReadAllBuyersTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_buyers_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerTimeoutsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerTimeouts(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>, UserType>(),
    "Attempting to read the optional `per_buyer_timeouts` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerTimeouts` instead "
    "of `ReadPerBuyerTimeouts if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_timeouts.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AuctionAdConfigBuyerTimeouts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdCurrencyDataView {
 public:
  AdCurrencyDataView() = default;

  AdCurrencyDataView(
      internal::AdCurrency_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCurrencyCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrencyCode(UserType* output) {
    
    auto* pointer = data_->currency_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdCurrency_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigBuyerCurrenciesDataView {
 public:
  AuctionAdConfigBuyerCurrenciesDataView() = default;

  AuctionAdConfigBuyerCurrenciesDataView(
      internal::AuctionAdConfigBuyerCurrencies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllBuyersCurrencyDataView(
      AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllBuyersCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `all_buyers_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllBuyersCurrency` instead "
    "of `ReadAllBuyersCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_buyers_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerCurrenciesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, AdCurrencyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerCurrencies(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AdCurrencyDataView>, UserType>(),
    "Attempting to read the optional `per_buyer_currencies` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerCurrencies` instead "
    "of `ReadPerBuyerCurrencies if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_currencies.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AdCurrencyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AuctionAdConfigBuyerCurrencies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdServerResponseConfigDataView {
 public:
  AuctionAdServerResponseConfigDataView() = default;

  AuctionAdServerResponseConfigDataView(
      internal::AuctionAdServerResponseConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestIdDataView(
      ::mojo_base::mojom::UuidDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UuidDataView>(
        pointer, output, message_);
  }
 private:
  internal::AuctionAdServerResponseConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionReportBuyerDebugModeConfigDataView {
 public:
  AuctionReportBuyerDebugModeConfigDataView() = default;

  AuctionReportBuyerDebugModeConfigDataView(
      internal::AuctionReportBuyerDebugModeConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  std::optional<uint64_t> debug_key() const {

    return data_->debug_key_$flag
        ? std::make_optional(data_->debug_key_$value)
        : std::nullopt;
  }
 private:
  internal::AuctionReportBuyerDebugModeConfig_Data* data_ = nullptr;
};


class AuctionReportBuyersConfigDataView {
 public:
  AuctionReportBuyersConfigDataView() = default;

  AuctionReportBuyersConfigDataView(
      internal::AuctionReportBuyersConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBucketDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBucket(UserType* output) {
    
    auto* pointer = data_->bucket.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  double scale() const {
    return data_->scale;
  }
 private:
  internal::AuctionReportBuyersConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigNonSharedParamsDataView {
 public:
  AuctionAdConfigNonSharedParamsDataView() = default;

  AuctionAdConfigNonSharedParamsDataView(
      internal::AuctionAdConfigNonSharedParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInterestGroupBuyersDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroupBuyers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::url::mojom::OriginDataView>, UserType>(),
    "Attempting to read the optional `interest_group_buyers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterestGroupBuyers` instead "
    "of `ReadInterestGroupBuyers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interest_group_buyers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, message_);
  }
  inline void GetAuctionSignalsDataView(
      AuctionAdConfigMaybePromiseJsonDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionSignals(UserType* output) {
    
    auto* pointer = !data_->auction_signals.is_null() ? &data_->auction_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView>(
        pointer, output, message_);
  }
  inline void GetSellerSignalsDataView(
      AuctionAdConfigMaybePromiseJsonDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerSignals(UserType* output) {
    
    auto* pointer = !data_->seller_signals.is_null() ? &data_->seller_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView>(
        pointer, output, message_);
  }
  inline void GetSellerTkvSignalsDataView(
      AuctionAdConfigMaybePromiseJsonDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerTkvSignals(UserType* output) {
    
    auto* pointer = !data_->seller_tkv_signals.is_null() ? &data_->seller_tkv_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView>(
        pointer, output, message_);
  }
  inline void GetSellerTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `seller_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerTimeout` instead "
    "of `ReadSellerTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerSignalsDataView(
      AuctionAdConfigMaybePromisePerBuyerSignalsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerSignals(UserType* output) {
    
    auto* pointer = !data_->per_buyer_signals.is_null() ? &data_->per_buyer_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerTkvSignalsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, AuctionAdConfigMaybePromiseJsonDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerTkvSignals(UserType* output) {
    
    auto* pointer = data_->per_buyer_tkv_signals.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView>>(
        pointer, output, message_);
  }
  inline void GetBuyerTimeoutsDataView(
      AuctionAdConfigMaybePromiseBuyerTimeoutsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerTimeouts(UserType* output) {
    
    auto* pointer = !data_->buyer_timeouts.is_null() ? &data_->buyer_timeouts : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView>(
        pointer, output, message_);
  }
  inline void GetReportingTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `reporting_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingTimeout` instead "
    "of `ReadReportingTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetSellerCurrencyDataView(
      AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `seller_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerCurrency` instead "
    "of `ReadSellerCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerCurrenciesDataView(
      AuctionAdConfigMaybePromiseBuyerCurrenciesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerCurrencies(UserType* output) {
    
    auto* pointer = !data_->buyer_currencies.is_null() ? &data_->buyer_currencies : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerCumulativeTimeoutsDataView(
      AuctionAdConfigMaybePromiseBuyerTimeoutsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerCumulativeTimeouts(UserType* output) {
    
    auto* pointer = !data_->buyer_cumulative_timeouts.is_null() ? &data_->buyer_cumulative_timeouts : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerGroupLimitsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerGroupLimits(UserType* output) {
    
    auto* pointer = data_->per_buyer_group_limits.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        pointer, output, message_);
  }
  inline void GetPerBuyerPrioritySignalsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerPrioritySignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>, UserType>(),
    "Attempting to read the optional `per_buyer_priority_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerPrioritySignals` instead "
    "of `ReadPerBuyerPrioritySignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_priority_signals.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>>(
        pointer, output, message_);
  }
  inline void GetAllBuyersPrioritySignalsDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllBuyersPrioritySignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, double>, UserType>(),
    "Attempting to read the optional `all_buyers_priority_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllBuyersPrioritySignals` instead "
    "of `ReadAllBuyersPrioritySignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_buyers_priority_signals.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  uint16_t all_buyers_group_limit() const {
    return data_->all_buyers_group_limit;
  }
  inline void GetAuctionReportBuyerKeysDataView(
      mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionReportBuyerKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>, UserType>(),
    "Attempting to read the optional `auction_report_buyer_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionReportBuyerKeys` instead "
    "of `ReadAuctionReportBuyerKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_report_buyer_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>>(
        pointer, output, message_);
  }
  inline void GetAuctionReportBuyersDataView(
      mojo::MapDataView<AuctionAdConfigNonSharedParams_BuyerReportType, AuctionReportBuyersConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionReportBuyers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType, ::blink::mojom::AuctionReportBuyersConfigDataView>, UserType>(),
    "Attempting to read the optional `auction_report_buyers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionReportBuyers` instead "
    "of `ReadAuctionReportBuyers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_report_buyers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType, ::blink::mojom::AuctionReportBuyersConfigDataView>>(
        pointer, output, message_);
  }
  inline void GetAuctionReportBuyerDebugModeConfigDataView(
      AuctionReportBuyerDebugModeConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionReportBuyerDebugModeConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuctionReportBuyerDebugModeConfigDataView, UserType>(),
    "Attempting to read the optional `auction_report_buyer_debug_mode_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionReportBuyerDebugModeConfig` instead "
    "of `ReadAuctionReportBuyerDebugModeConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_report_buyer_debug_mode_config.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionReportBuyerDebugModeConfigDataView>(
        pointer, output, message_);
  }
  inline void GetRequiredSellerCapabilitiesDataView(
      SellerCapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequiredSellerCapabilities(UserType* output) {
    
    auto* pointer = data_->required_seller_capabilities.Get();
    return mojo::internal::Deserialize<::blink::mojom::SellerCapabilitiesDataView>(
        pointer, output, message_);
  }
  inline void GetRequestedSizeDataView(
      ::blink::mojom::AdSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdSizeDataView, UserType>(),
    "Attempting to read the optional `requested_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestedSize` instead "
    "of `ReadRequestedSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->requested_size.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdSizeDataView>(
        pointer, output, message_);
  }
  inline void GetAllSlotsRequestedSizesDataView(
      mojo::ArrayDataView<::blink::mojom::AdSizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllSlotsRequestedSizes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AdSizeDataView>, UserType>(),
    "Attempting to read the optional `all_slots_requested_sizes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllSlotsRequestedSizes` instead "
    "of `ReadAllSlotsRequestedSizes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_slots_requested_sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AdSizeDataView>>(
        pointer, output, message_);
  }
  inline void GetPerBuyerMultiBidLimitsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerMultiBidLimits(UserType* output) {
    
    auto* pointer = data_->per_buyer_multi_bid_limits.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        pointer, output, message_);
  }
  uint16_t all_buyers_multi_bid_limit() const {
    return data_->all_buyers_multi_bid_limit;
  }
  inline void GetAuctionNonceDataView(
      ::mojo_base::mojom::UuidDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UuidDataView, UserType>(),
    "Attempting to read the optional `auction_nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionNonce` instead "
    "of `ReadAuctionNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UuidDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSellerRealTimeReportingType(UserType* output) const {
    if (!data_->seller_real_time_reporting_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>(
        data_->seller_real_time_reporting_type_$value, &output->emplace());
  }
  std::optional<AuctionAdConfigNonSharedParams_RealTimeReportingType> seller_real_time_reporting_type() const {
    if (!data_->seller_real_time_reporting_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>(data_->seller_real_time_reporting_type_$value));
  }
  inline void GetPerBuyerRealTimeReportingTypesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, AuctionAdConfigNonSharedParams_RealTimeReportingType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerRealTimeReportingTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>, UserType>(),
    "Attempting to read the optional `per_buyer_real_time_reporting_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerRealTimeReportingTypes` instead "
    "of `ReadPerBuyerRealTimeReportingTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_real_time_reporting_types.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>>(
        pointer, output, message_);
  }
  inline void GetComponentAuctionsDataView(
      mojo::ArrayDataView<AuctionAdConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComponentAuctions(UserType* output) {
    
    auto* pointer = data_->component_auctions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AuctionAdConfigDataView>>(
        pointer, output, message_);
  }
  inline void GetDeprecatedRenderUrlReplacementsDataView(
      AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedRenderUrlReplacements(UserType* output) {
    
    auto* pointer = !data_->deprecated_render_url_replacements.is_null() ? &data_->deprecated_render_url_replacements : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView>(
        pointer, output, message_);
  }
  int32_t max_trusted_scoring_signals_url_length() const {
    return data_->max_trusted_scoring_signals_url_length;
  }
  inline void GetTrustedScoringSignalsCoordinatorDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedScoringSignalsCoordinator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `trusted_scoring_signals_coordinator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedScoringSignalsCoordinator` instead "
    "of `ReadTrustedScoringSignalsCoordinator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_scoring_signals_coordinator.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadExecutionMode(UserType* output) const {
    auto data_value = data_->execution_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_ExecutionMode>(
        data_value, output);
  }
  InterestGroup_ExecutionMode execution_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_ExecutionMode>(data_->execution_mode));
  }
 private:
  internal::AuctionAdConfigNonSharedParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigDataView {
 public:
  AuctionAdConfigDataView() = default;

  AuctionAdConfigDataView(
      internal::AuctionAdConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSellerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeller(UserType* output) {
    
    auto* pointer = data_->seller.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetServerResponseDataView(
      AuctionAdServerResponseConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuctionAdServerResponseConfigDataView, UserType>(),
    "Attempting to read the optional `server_response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServerResponse` instead "
    "of `ReadServerResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->server_response.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdServerResponseConfigDataView>(
        pointer, output, message_);
  }
  inline void GetDecisionLogicUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecisionLogicUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `decision_logic_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecisionLogicUrl` instead "
    "of `ReadDecisionLogicUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decision_logic_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedScoringSignalsUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedScoringSignalsUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `trusted_scoring_signals_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedScoringSignalsUrl` instead "
    "of `ReadTrustedScoringSignalsUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_scoring_signals_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAuctionAdConfigNonSharedParamsDataView(
      AuctionAdConfigNonSharedParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionAdConfigNonSharedParams(UserType* output) {
    
    auto* pointer = data_->auction_ad_config_non_shared_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigNonSharedParamsDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSignalsDataView(
      AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSignals(UserType* output) {
    
    auto* pointer = !data_->direct_from_seller_signals.is_null() ? &data_->direct_from_seller_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView>(
        pointer, output, message_);
  }
  bool expects_direct_from_seller_signals_header_ad_slot() const {
    return data_->expects_direct_from_seller_signals_header_ad_slot;
  }
  std::optional<uint16_t> seller_experiment_group_id() const {

    return data_->seller_experiment_group_id_$flag
        ? std::make_optional(data_->seller_experiment_group_id_$value)
        : std::nullopt;
  }
  std::optional<uint16_t> all_buyer_experiment_group_id() const {

    return data_->all_buyer_experiment_group_id_$flag
        ? std::make_optional(data_->all_buyer_experiment_group_id_$value)
        : std::nullopt;
  }
  inline void GetPerBuyerExperimentGroupIdsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerExperimentGroupIds(UserType* output) {
    
    auto* pointer = data_->per_buyer_experiment_group_ids.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        pointer, output, message_);
  }
  bool expects_additional_bids() const {
    return data_->expects_additional_bids;
  }
  inline void GetAggregationCoordinatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `aggregation_coordinator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregationCoordinatorOrigin` instead "
    "of `ReadAggregationCoordinatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  std::optional<bool> send_creative_scanning_metadata() const {

    return data_->send_creative_scanning_metadata_$flag
        ? std::make_optional(!!data_->send_creative_scanning_metadata_$value)
        : std::nullopt;
  }
 private:
  internal::AuctionAdConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionDataBuyerConfigDataView {
 public:
  AuctionDataBuyerConfigDataView() = default;

  AuctionDataBuyerConfigDataView(
      internal::AuctionDataBuyerConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  std::optional<uint32_t> target_size() const {

    return data_->target_size_$flag
        ? std::make_optional(data_->target_size_$value)
        : std::nullopt;
  }
 private:
  internal::AuctionDataBuyerConfig_Data* data_ = nullptr;
};


class AuctionDataConfigDataView {
 public:
  AuctionDataConfigDataView() = default;

  AuctionDataConfigDataView(
      internal::AuctionDataConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPerBuyerConfigsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, AuctionDataBuyerConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerConfigs(UserType* output) {
    
    auto* pointer = data_->per_buyer_configs.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionDataBuyerConfigDataView>>(
        pointer, output, message_);
  }
  std::optional<uint32_t> request_size() const {

    return data_->request_size_$flag
        ? std::make_optional(data_->request_size_$value)
        : std::nullopt;
  }
 private:
  internal::AuctionDataConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdAuctionPerSellerRequestDataView {
 public:
  AdAuctionPerSellerRequestDataView() = default;

  AdAuctionPerSellerRequestDataView(
      internal::AdAuctionPerSellerRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSellerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeller(UserType* output) {
    
    auto* pointer = data_->seller.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      AdAuctionRequestOrErrorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AdAuctionRequestOrErrorDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdAuctionPerSellerRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigMaybePromiseJsonDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseJson_Data::AuctionAdConfigMaybePromiseJson_Tag;

  AuctionAdConfigMaybePromiseJsonDataView() = default;

  AuctionAdConfigMaybePromiseJsonDataView(
      internal::AuctionAdConfigMaybePromiseJson_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    CHECK(is_value());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseJson_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromisePerBuyerSignalsDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data::AuctionAdConfigMaybePromisePerBuyerSignals_Tag;

  AuctionAdConfigMaybePromisePerBuyerSignalsDataView() = default;

  AuctionAdConfigMaybePromisePerBuyerSignalsDataView(
      internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    CHECK(is_value());
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromiseBuyerTimeoutsDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data::AuctionAdConfigMaybePromiseBuyerTimeouts_Tag;

  AuctionAdConfigMaybePromiseBuyerTimeoutsDataView() = default;

  AuctionAdConfigMaybePromiseBuyerTimeoutsDataView(
      internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      AuctionAdConfigBuyerTimeoutsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
    CHECK(is_value());
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromiseBuyerCurrenciesDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data::AuctionAdConfigMaybePromiseBuyerCurrencies_Tag;

  AuctionAdConfigMaybePromiseBuyerCurrenciesDataView() = default;

  AuctionAdConfigMaybePromiseBuyerCurrenciesDataView(
      internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      AuctionAdConfigBuyerCurrenciesDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
    CHECK(is_value());
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Tag;

  AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView() = default;

  AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView(
      internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      DirectFromSellerSignalsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DirectFromSellerSignalsDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    CHECK(is_value());
    return mojo::internal::Deserialize<::blink::mojom::DirectFromSellerSignalsDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Tag;

  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView() = default;

  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView(
      internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      mojo::ArrayDataView<AdKeywordReplacementDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
    CHECK(is_value());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AdKeywordReplacementDataView>>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AdAuctionRequestOrErrorDataView {
 public:
  using Tag = internal::AdAuctionRequestOrError_Data::AdAuctionRequestOrError_Tag;

  AdAuctionRequestOrErrorDataView() = default;

  AdAuctionRequestOrErrorDataView(
      internal::AdAuctionRequestOrError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_request() const { return data_->tag == Tag::kRequest; }
  inline void GetRequestDataView(
      ::mojo_base::mojom::BigBufferDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) const {
    
    CHECK(is_request());
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        data_->data.f_request.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::AdAuctionRequestOrError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_DATA_VIEW_H_