// third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"




#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::AdSize_LengthUnit>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AdSize_LengthUnit> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdSize_LengthUnit, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AdSize_LengthUnit, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AdSize_LengthUnit>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdSizeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdSizeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdSize_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->width = Traits::width(input);

    
    mojo::internal::Serialize<::blink::mojom::AdSize_LengthUnit>(
      Traits::width_units(input),
      &fragment->width_units);

    fragment->height = Traits::height(input);

    
    mojo::internal::Serialize<::blink::mojom::AdSize_LengthUnit>(
      Traits::height_units(input),
      &fragment->height_units);
  }

  static bool Deserialize(::blink::mojom::internal::AdSize_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdSizeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in AdDescriptor struct");

    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AdSizeDataView>(
      in_size,
      size_fragment);

    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AdDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void AdDescriptorDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AdDescriptorDataView::GetSizeDataView(
    AdSizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = AdSizeDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AdSize_LengthUnit> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AdSize_LengthUnit value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_SHARED_H_