// third_party/blink/public/mojom/interest_group/ad_auction_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  Uuid as mojoBase_mojom_Uuid,
  UuidSpec as mojoBase_mojom_UuidSpec
} from '../../../../../mojo/public/mojom/base/uuid.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  FencedFrameConfig as blink_mojom_FencedFrameConfig,
  FencedFrameConfigSpec as blink_mojom_FencedFrameConfigSpec
} from '../fenced_frame/fenced_frame_config.mojom.m.js';

import {
  AdRequestConfig as blink_mojom_AdRequestConfig,
  AdRequestConfigSpec as blink_mojom_AdRequestConfigSpec
} from '../parakeet/ad_request.mojom.m.js';

import {
  AdAuctionPerSellerRequest as blink_mojom_AdAuctionPerSellerRequest,
  AdAuctionPerSellerRequestSpec as blink_mojom_AdAuctionPerSellerRequestSpec,
  AdKeywordReplacement as blink_mojom_AdKeywordReplacement,
  AdKeywordReplacementSpec as blink_mojom_AdKeywordReplacementSpec,
  AuctionAdConfig as blink_mojom_AuctionAdConfig,
  AuctionAdConfigSpec as blink_mojom_AuctionAdConfigSpec,
  AuctionAdConfigBuyerCurrencies as blink_mojom_AuctionAdConfigBuyerCurrencies,
  AuctionAdConfigBuyerCurrenciesSpec as blink_mojom_AuctionAdConfigBuyerCurrenciesSpec,
  AuctionAdConfigBuyerTimeouts as blink_mojom_AuctionAdConfigBuyerTimeouts,
  AuctionAdConfigBuyerTimeoutsSpec as blink_mojom_AuctionAdConfigBuyerTimeoutsSpec,
  AuctionDataConfig as blink_mojom_AuctionDataConfig,
  AuctionDataConfigSpec as blink_mojom_AuctionDataConfigSpec,
  DirectFromSellerSignals as blink_mojom_DirectFromSellerSignals,
  DirectFromSellerSignalsSpec as blink_mojom_DirectFromSellerSignalsSpec,
  InterestGroup as blink_mojom_InterestGroup,
  InterestGroupSpec as blink_mojom_InterestGroupSpec
} from './interest_group_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AuctionAdConfigFieldSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AuctionAdConfigField = {
  
  kAuctionSignals: 0,
  kSellerSignals: 1,
  kSellerTKVSignals: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AuctionAdConfigBuyerTimeoutFieldSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AuctionAdConfigBuyerTimeoutField = {
  
  kPerBuyerTimeouts: 0,
  kPerBuyerCumulativeTimeouts: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AbortableAdAuctionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AbortableAdAuction', scope);
  }
}

/** @interface */
export class AbortableAdAuctionInterface {
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !AuctionAdConfigField } field
   * @param { ?string } jsonValue
   */

  resolvedPromiseParam(auction, field, jsonValue) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { ?Map<!url_mojom_Origin, !string> } perBuyerSignals
   */

  resolvedPerBuyerSignalsPromise(auction, perBuyerSignals) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !url_mojom_Origin } buyer
   * @param { ?string } jsonValue
   */

  resolvedBuyerTkvSignalsPromise(auction, buyer, jsonValue) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !AuctionAdConfigBuyerTimeoutField } field
   * @param { !blink_mojom_AuctionAdConfigBuyerTimeouts } buyerTimeouts
   */

  resolvedBuyerTimeoutsPromise(auction, field, buyerTimeouts) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !blink_mojom_AuctionAdConfigBuyerCurrencies } perBuyerCurrencies
   */

  resolvedBuyerCurrenciesPromise(auction, perBuyerCurrencies) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { ?blink_mojom_DirectFromSellerSignals } directFromSellerSignals
   */

  resolvedDirectFromSellerSignalsPromise(auction, directFromSellerSignals) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { ?string } directFromSellerSignalsHeaderAdSlot
   */

  resolvedDirectFromSellerSignalsHeaderAdSlotPromise(auction, directFromSellerSignalsHeaderAdSlot) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !Array<!blink_mojom_AdKeywordReplacement> } deprecatedRenderUrlReplacements
   */

  resolvedDeprecatedRenderURLReplacementsPromise(auction, deprecatedRenderUrlReplacements) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !mojoBase_mojom_BigBuffer } result
   */

  resolvedAuctionAdResponsePromise(auction, result) {}
  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   */

  resolvedAdditionalBids(auction) {}
  
  /**
   */

  abort() {}
}

/**
 * @implements { AbortableAdAuctionInterface }
 */
export class AbortableAdAuctionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AbortableAdAuctionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AbortableAdAuctionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AbortableAdAuctionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !AuctionAdConfigField } field
   * @param { ?string } jsonValue
   */

  resolvedPromiseParam(
      auction,
      field,
      jsonValue) {
    this.proxy.sendMessage(
        0,
        AbortableAdAuction_ResolvedPromiseParam_ParamsSpec.$,
        null,
        [
          auction,
          field,
          jsonValue
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { ?Map<!url_mojom_Origin, !string> } perBuyerSignals
   */

  resolvedPerBuyerSignalsPromise(
      auction,
      perBuyerSignals) {
    this.proxy.sendMessage(
        1,
        AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec.$,
        null,
        [
          auction,
          perBuyerSignals
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !url_mojom_Origin } buyer
   * @param { ?string } jsonValue
   */

  resolvedBuyerTkvSignalsPromise(
      auction,
      buyer,
      jsonValue) {
    this.proxy.sendMessage(
        2,
        AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec.$,
        null,
        [
          auction,
          buyer,
          jsonValue
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !AuctionAdConfigBuyerTimeoutField } field
   * @param { !blink_mojom_AuctionAdConfigBuyerTimeouts } buyerTimeouts
   */

  resolvedBuyerTimeoutsPromise(
      auction,
      field,
      buyerTimeouts) {
    this.proxy.sendMessage(
        3,
        AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec.$,
        null,
        [
          auction,
          field,
          buyerTimeouts
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !blink_mojom_AuctionAdConfigBuyerCurrencies } perBuyerCurrencies
   */

  resolvedBuyerCurrenciesPromise(
      auction,
      perBuyerCurrencies) {
    this.proxy.sendMessage(
        4,
        AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec.$,
        null,
        [
          auction,
          perBuyerCurrencies
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { ?blink_mojom_DirectFromSellerSignals } directFromSellerSignals
   */

  resolvedDirectFromSellerSignalsPromise(
      auction,
      directFromSellerSignals) {
    this.proxy.sendMessage(
        5,
        AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec.$,
        null,
        [
          auction,
          directFromSellerSignals
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { ?string } directFromSellerSignalsHeaderAdSlot
   */

  resolvedDirectFromSellerSignalsHeaderAdSlotPromise(
      auction,
      directFromSellerSignalsHeaderAdSlot) {
    this.proxy.sendMessage(
        6,
        AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec.$,
        null,
        [
          auction,
          directFromSellerSignalsHeaderAdSlot
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !Array<!blink_mojom_AdKeywordReplacement> } deprecatedRenderUrlReplacements
   */

  resolvedDeprecatedRenderURLReplacementsPromise(
      auction,
      deprecatedRenderUrlReplacements) {
    this.proxy.sendMessage(
        7,
        AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec.$,
        null,
        [
          auction,
          deprecatedRenderUrlReplacements
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   * @param { !mojoBase_mojom_BigBuffer } result
   */

  resolvedAuctionAdResponsePromise(
      auction,
      result) {
    this.proxy.sendMessage(
        8,
        AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec.$,
        null,
        [
          auction,
          result
        ],
        false);
  }

  
  /**
   * @param { !AuctionAdConfigAuctionId } auction
   */

  resolvedAdditionalBids(
      auction) {
    this.proxy.sendMessage(
        9,
        AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec.$,
        null,
        [
          auction
        ],
        false);
  }

  
  /**
   */

  abort() {
    this.proxy.sendMessage(
        10,
        AbortableAdAuction_Abort_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AbortableAdAuction
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AbortableAdAuctionReceiver {
  /**
   * @param {!AbortableAdAuctionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AbortableAdAuctionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AbortableAdAuctionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AbortableAdAuctionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AbortableAdAuction_ResolvedPromiseParam_ParamsSpec.$,
        null,
        impl.resolvedPromiseParam.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec.$,
        null,
        impl.resolvedPerBuyerSignalsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec.$,
        null,
        impl.resolvedBuyerTkvSignalsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec.$,
        null,
        impl.resolvedBuyerTimeoutsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec.$,
        null,
        impl.resolvedBuyerCurrenciesPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec.$,
        null,
        impl.resolvedDirectFromSellerSignalsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec.$,
        null,
        impl.resolvedDirectFromSellerSignalsHeaderAdSlotPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec.$,
        null,
        impl.resolvedDeprecatedRenderURLReplacementsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec.$,
        null,
        impl.resolvedAuctionAdResponsePromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec.$,
        null,
        impl.resolvedAdditionalBids.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        AbortableAdAuction_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AbortableAdAuction {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AbortableAdAuction";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AbortableAdAuctionRemote}
   */
  static getRemote() {
    let remote = new AbortableAdAuctionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AbortableAdAuction
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AbortableAdAuctionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AbortableAdAuctionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AbortableAdAuctionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedPromiseParam =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AbortableAdAuction_ResolvedPromiseParam_ParamsSpec.$,
        null,
        this.resolvedPromiseParam.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedPerBuyerSignalsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec.$,
        null,
        this.resolvedPerBuyerSignalsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedBuyerTkvSignalsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec.$,
        null,
        this.resolvedBuyerTkvSignalsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedBuyerTimeoutsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec.$,
        null,
        this.resolvedBuyerTimeoutsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedBuyerCurrenciesPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec.$,
        null,
        this.resolvedBuyerCurrenciesPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedDirectFromSellerSignalsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec.$,
        null,
        this.resolvedDirectFromSellerSignalsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedDirectFromSellerSignalsHeaderAdSlotPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec.$,
        null,
        this.resolvedDirectFromSellerSignalsHeaderAdSlotPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedDeprecatedRenderURLReplacementsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec.$,
        null,
        this.resolvedDeprecatedRenderURLReplacementsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedAuctionAdResponsePromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec.$,
        null,
        this.resolvedAuctionAdResponsePromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedAdditionalBids =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec.$,
        null,
        this.resolvedAdditionalBids.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        AbortableAdAuction_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AdAuctionServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AdAuctionService', scope);
  }
}

/** @interface */
export class AdAuctionServiceInterface {
  
  /**
   * @param { !blink_mojom_AdRequestConfig } config
   * @return {!Promise<{
        adsGuid: ?string,
   *  }>}
   */

  createAdRequest(config) {}
  
  /**
   * @param { !string } adsGuid
   * @param { !blink_mojom_AuctionAdConfig } config
   * @return {!Promise<{
        adDisplayUrl: ?url_mojom_Url,
   *  }>}
   */

  finalizeAd(adsGuid, config) {}
  
  /**
   * @param { !blink_mojom_AuctionAdConfig } config
   * @param { ?AbortableAdAuctionPendingReceiver } abortReceiver
   * @return {!Promise<{
        abortedByScript: !boolean,
        config: ?blink_mojom_FencedFrameConfig,
   *  }>}
   */

  runAdAuction(config, abortReceiver) {}
  
  /**
   * @param { !blink_mojom_InterestGroup } group
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  joinInterestGroup(group) {}
  
  /**
   * @param { !url_mojom_Origin } owner
   * @param { !string } name
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  leaveInterestGroup(owner, name) {}
  
  /**
   */

  leaveInterestGroupForDocument() {}
  
  /**
   * @param { !url_mojom_Origin } owner
   * @param { !Array<!string> } interestGroupsToKeep
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  clearOriginJoinedInterestGroups(owner, interestGroupsToKeep) {}
  
  /**
   */

  updateAdInterestGroups() {}
  
  /**
   * @param { !url_mojom_Url } uuidUrl
   * @param { !boolean } sendReports
   * @return {!Promise<{
        decodedUrl: ?url_mojom_Url,
   *  }>}
   */

  deprecatedGetURLFromURN(uuidUrl, sendReports) {}
  
  /**
   * @param { !url_mojom_Url } uuidUrl
   * @param { !Array<!blink_mojom_AdKeywordReplacement> } replacements
   * @return {!Promise}
   */

  deprecatedReplaceInURN(uuidUrl, replacements) {}
  
  /**
   * @param { !Map<!url_mojom_Origin, ?url_mojom_Origin> } sellers
   * @param { !blink_mojom_AuctionDataConfig } config
   * @return {!Promise<{
        requests: !Array<!blink_mojom_AdAuctionPerSellerRequest>,
        requestId: ?mojoBase_mojom_Uuid,
   *  }>}
   */

  getInterestGroupAdAuctionData(sellers, config) {}
}

/**
 * @implements { AdAuctionServiceInterface }
 */
export class AdAuctionServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AdAuctionServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AdAuctionServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AdAuctionServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_AdRequestConfig } config
   * @return {!Promise<{
        adsGuid: ?string,
   *  }>}
   */

  createAdRequest(
      config) {
    return this.proxy.sendMessage(
        0,
        AdAuctionService_CreateAdRequest_ParamsSpec.$,
        AdAuctionService_CreateAdRequest_ResponseParamsSpec.$,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !string } adsGuid
   * @param { !blink_mojom_AuctionAdConfig } config
   * @return {!Promise<{
        adDisplayUrl: ?url_mojom_Url,
   *  }>}
   */

  finalizeAd(
      adsGuid,
      config) {
    return this.proxy.sendMessage(
        1,
        AdAuctionService_FinalizeAd_ParamsSpec.$,
        AdAuctionService_FinalizeAd_ResponseParamsSpec.$,
        [
          adsGuid,
          config
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AuctionAdConfig } config
   * @param { ?AbortableAdAuctionPendingReceiver } abortReceiver
   * @return {!Promise<{
        abortedByScript: !boolean,
        config: ?blink_mojom_FencedFrameConfig,
   *  }>}
   */

  runAdAuction(
      config,
      abortReceiver) {
    return this.proxy.sendMessage(
        2,
        AdAuctionService_RunAdAuction_ParamsSpec.$,
        AdAuctionService_RunAdAuction_ResponseParamsSpec.$,
        [
          config,
          abortReceiver
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_InterestGroup } group
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  joinInterestGroup(
      group) {
    return this.proxy.sendMessage(
        3,
        AdAuctionService_JoinInterestGroup_ParamsSpec.$,
        AdAuctionService_JoinInterestGroup_ResponseParamsSpec.$,
        [
          group
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } owner
   * @param { !string } name
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  leaveInterestGroup(
      owner,
      name) {
    return this.proxy.sendMessage(
        4,
        AdAuctionService_LeaveInterestGroup_ParamsSpec.$,
        AdAuctionService_LeaveInterestGroup_ResponseParamsSpec.$,
        [
          owner,
          name
        ],
        false);
  }

  
  /**
   */

  leaveInterestGroupForDocument() {
    this.proxy.sendMessage(
        5,
        AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } owner
   * @param { !Array<!string> } interestGroupsToKeep
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  clearOriginJoinedInterestGroups(
      owner,
      interestGroupsToKeep) {
    return this.proxy.sendMessage(
        6,
        AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec.$,
        AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec.$,
        [
          owner,
          interestGroupsToKeep
        ],
        false);
  }

  
  /**
   */

  updateAdInterestGroups() {
    this.proxy.sendMessage(
        7,
        AdAuctionService_UpdateAdInterestGroups_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } uuidUrl
   * @param { !boolean } sendReports
   * @return {!Promise<{
        decodedUrl: ?url_mojom_Url,
   *  }>}
   */

  deprecatedGetURLFromURN(
      uuidUrl,
      sendReports) {
    return this.proxy.sendMessage(
        8,
        AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec.$,
        AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec.$,
        [
          uuidUrl,
          sendReports
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } uuidUrl
   * @param { !Array<!blink_mojom_AdKeywordReplacement> } replacements
   * @return {!Promise}
   */

  deprecatedReplaceInURN(
      uuidUrl,
      replacements) {
    return this.proxy.sendMessage(
        9,
        AdAuctionService_DeprecatedReplaceInURN_ParamsSpec.$,
        AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec.$,
        [
          uuidUrl,
          replacements
        ],
        false);
  }

  
  /**
   * @param { !Map<!url_mojom_Origin, ?url_mojom_Origin> } sellers
   * @param { !blink_mojom_AuctionDataConfig } config
   * @return {!Promise<{
        requests: !Array<!blink_mojom_AdAuctionPerSellerRequest>,
        requestId: ?mojoBase_mojom_Uuid,
   *  }>}
   */

  getInterestGroupAdAuctionData(
      sellers,
      config) {
    return this.proxy.sendMessage(
        10,
        AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec.$,
        AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec.$,
        [
          sellers,
          config
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AdAuctionService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AdAuctionServiceReceiver {
  /**
   * @param {!AdAuctionServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AdAuctionServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AdAuctionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AdAuctionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AdAuctionService_CreateAdRequest_ParamsSpec.$,
        AdAuctionService_CreateAdRequest_ResponseParamsSpec.$,
        impl.createAdRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AdAuctionService_FinalizeAd_ParamsSpec.$,
        AdAuctionService_FinalizeAd_ResponseParamsSpec.$,
        impl.finalizeAd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AdAuctionService_RunAdAuction_ParamsSpec.$,
        AdAuctionService_RunAdAuction_ResponseParamsSpec.$,
        impl.runAdAuction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AdAuctionService_JoinInterestGroup_ParamsSpec.$,
        AdAuctionService_JoinInterestGroup_ResponseParamsSpec.$,
        impl.joinInterestGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AdAuctionService_LeaveInterestGroup_ParamsSpec.$,
        AdAuctionService_LeaveInterestGroup_ResponseParamsSpec.$,
        impl.leaveInterestGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec.$,
        null,
        impl.leaveInterestGroupForDocument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec.$,
        AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec.$,
        impl.clearOriginJoinedInterestGroups.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        AdAuctionService_UpdateAdInterestGroups_ParamsSpec.$,
        null,
        impl.updateAdInterestGroups.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec.$,
        AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec.$,
        impl.deprecatedGetURLFromURN.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        AdAuctionService_DeprecatedReplaceInURN_ParamsSpec.$,
        AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec.$,
        impl.deprecatedReplaceInURN.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec.$,
        AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec.$,
        impl.getInterestGroupAdAuctionData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AdAuctionService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AdAuctionService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AdAuctionServiceRemote}
   */
  static getRemote() {
    let remote = new AdAuctionServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AdAuctionService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AdAuctionServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AdAuctionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AdAuctionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAdRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AdAuctionService_CreateAdRequest_ParamsSpec.$,
        AdAuctionService_CreateAdRequest_ResponseParamsSpec.$,
        this.createAdRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.finalizeAd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AdAuctionService_FinalizeAd_ParamsSpec.$,
        AdAuctionService_FinalizeAd_ResponseParamsSpec.$,
        this.finalizeAd.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runAdAuction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AdAuctionService_RunAdAuction_ParamsSpec.$,
        AdAuctionService_RunAdAuction_ResponseParamsSpec.$,
        this.runAdAuction.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.joinInterestGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AdAuctionService_JoinInterestGroup_ParamsSpec.$,
        AdAuctionService_JoinInterestGroup_ResponseParamsSpec.$,
        this.joinInterestGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.leaveInterestGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AdAuctionService_LeaveInterestGroup_ParamsSpec.$,
        AdAuctionService_LeaveInterestGroup_ResponseParamsSpec.$,
        this.leaveInterestGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.leaveInterestGroupForDocument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec.$,
        null,
        this.leaveInterestGroupForDocument.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearOriginJoinedInterestGroups =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec.$,
        AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec.$,
        this.clearOriginJoinedInterestGroups.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateAdInterestGroups =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        AdAuctionService_UpdateAdInterestGroups_ParamsSpec.$,
        null,
        this.updateAdInterestGroups.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deprecatedGetURLFromURN =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec.$,
        AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec.$,
        this.deprecatedGetURLFromURN.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deprecatedReplaceInURN =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        AdAuctionService_DeprecatedReplaceInURN_ParamsSpec.$,
        AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec.$,
        this.deprecatedReplaceInURN.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInterestGroupAdAuctionData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec.$,
        AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec.$,
        this.getInterestGroupAdAuctionData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedPromiseParam_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AbortableAdAuction_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_CreateAdRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_CreateAdRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_FinalizeAd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_FinalizeAd_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_RunAdAuction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_RunAdAuction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_JoinInterestGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_JoinInterestGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_LeaveInterestGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_LeaveInterestGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_UpdateAdInterestGroups_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_DeprecatedReplaceInURN_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AuctionAdConfigAuctionIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AbortableAdAuction_ResolvedPromiseParam_ParamsSpec.$,
    'AbortableAdAuction_ResolvedPromiseParam_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'field', 16,
        0,
        AuctionAdConfigFieldSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'jsonValue', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedPromiseParam_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { !AuctionAdConfigField } */
    this.field;
    /** @type { (string|undefined) } */
    this.jsonValue;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerSignals', 16,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { (Map<!url_mojom_Origin, !string>|undefined) } */
    this.perBuyerSignals;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buyer', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'jsonValue', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { !url_mojom_Origin } */
    this.buyer;
    /** @type { (string|undefined) } */
    this.jsonValue;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'field', 16,
        0,
        AuctionAdConfigBuyerTimeoutFieldSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buyerTimeouts', 24,
        0,
        blink_mojom_AuctionAdConfigBuyerTimeoutsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { !AuctionAdConfigBuyerTimeoutField } */
    this.field;
    /** @type { !blink_mojom_AuctionAdConfigBuyerTimeouts } */
    this.buyerTimeouts;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerCurrencies', 16,
        0,
        blink_mojom_AuctionAdConfigBuyerCurrenciesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { !blink_mojom_AuctionAdConfigBuyerCurrencies } */
    this.perBuyerCurrencies;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directFromSellerSignals', 16,
        0,
        blink_mojom_DirectFromSellerSignalsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { (blink_mojom_DirectFromSellerSignals|undefined) } */
    this.directFromSellerSignals;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directFromSellerSignalsHeaderAdSlot', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { (string|undefined) } */
    this.directFromSellerSignalsHeaderAdSlot;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deprecatedRenderUrlReplacements', 16,
        0,
        mojo.internal.Array(blink_mojom_AdKeywordReplacementSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { !Array<!blink_mojom_AdKeywordReplacement> } */
    this.deprecatedRenderUrlReplacements;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 16,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.result;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec.$,
    'AbortableAdAuction_ResolvedAdditionalBids_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        AuctionAdConfigAuctionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AbortableAdAuction_ResolvedAdditionalBids_Params {
  constructor() {
    /** @type { !AuctionAdConfigAuctionId } */
    this.auction;
  }
}



mojo.internal.Struct(
    AbortableAdAuction_Abort_ParamsSpec.$,
    'AbortableAdAuction_Abort_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AbortableAdAuction_Abort_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AdAuctionService_CreateAdRequest_ParamsSpec.$,
    'AdAuctionService_CreateAdRequest_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        blink_mojom_AdRequestConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdAuctionService_CreateAdRequest_Params {
  constructor() {
    /** @type { !blink_mojom_AdRequestConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    AdAuctionService_CreateAdRequest_ResponseParamsSpec.$,
    'AdAuctionService_CreateAdRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'adsGuid', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdAuctionService_CreateAdRequest_ResponseParams {
  constructor() {
    /** @type { (string|undefined) } */
    this.adsGuid;
  }
}



mojo.internal.Struct(
    AdAuctionService_FinalizeAd_ParamsSpec.$,
    'AdAuctionService_FinalizeAd_Params',
    [
      mojo.internal.StructField(
        'adsGuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        blink_mojom_AuctionAdConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_FinalizeAd_Params {
  constructor() {
    /** @type { !string } */
    this.adsGuid;
    /** @type { !blink_mojom_AuctionAdConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    AdAuctionService_FinalizeAd_ResponseParamsSpec.$,
    'AdAuctionService_FinalizeAd_ResponseParams',
    [
      mojo.internal.StructField(
        'adDisplayUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdAuctionService_FinalizeAd_ResponseParams {
  constructor() {
    /** @type { (url_mojom_Url|undefined) } */
    this.adDisplayUrl;
  }
}



mojo.internal.Struct(
    AdAuctionService_RunAdAuction_ParamsSpec.$,
    'AdAuctionService_RunAdAuction_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        blink_mojom_AuctionAdConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'abortReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(AbortableAdAuctionPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_RunAdAuction_Params {
  constructor() {
    /** @type { !blink_mojom_AuctionAdConfig } */
    this.config;
    /** @type { (AbortableAdAuctionPendingReceiver|undefined) } */
    this.abortReceiver;
  }
}



mojo.internal.Struct(
    AdAuctionService_RunAdAuction_ResponseParamsSpec.$,
    'AdAuctionService_RunAdAuction_ResponseParams',
    [
      mojo.internal.StructField(
        'abortedByScript', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        blink_mojom_FencedFrameConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_RunAdAuction_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.abortedByScript;
    /** @type { (blink_mojom_FencedFrameConfig|undefined) } */
    this.config;
  }
}



mojo.internal.Struct(
    AdAuctionService_JoinInterestGroup_ParamsSpec.$,
    'AdAuctionService_JoinInterestGroup_Params',
    [
      mojo.internal.StructField(
        'group', 0,
        0,
        blink_mojom_InterestGroupSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdAuctionService_JoinInterestGroup_Params {
  constructor() {
    /** @type { !blink_mojom_InterestGroup } */
    this.group;
  }
}



mojo.internal.Struct(
    AdAuctionService_JoinInterestGroup_ResponseParamsSpec.$,
    'AdAuctionService_JoinInterestGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'failedWellKnownCheck', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdAuctionService_JoinInterestGroup_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.failedWellKnownCheck;
  }
}



mojo.internal.Struct(
    AdAuctionService_LeaveInterestGroup_ParamsSpec.$,
    'AdAuctionService_LeaveInterestGroup_Params',
    [
      mojo.internal.StructField(
        'owner', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_LeaveInterestGroup_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.owner;
    /** @type { !string } */
    this.name;
  }
}



mojo.internal.Struct(
    AdAuctionService_LeaveInterestGroup_ResponseParamsSpec.$,
    'AdAuctionService_LeaveInterestGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'failedWellKnownCheck', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdAuctionService_LeaveInterestGroup_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.failedWellKnownCheck;
  }
}



mojo.internal.Struct(
    AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec.$,
    'AdAuctionService_LeaveInterestGroupForDocument_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AdAuctionService_LeaveInterestGroupForDocument_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec.$,
    'AdAuctionService_ClearOriginJoinedInterestGroups_Params',
    [
      mojo.internal.StructField(
        'owner', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interestGroupsToKeep', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_ClearOriginJoinedInterestGroups_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.owner;
    /** @type { !Array<!string> } */
    this.interestGroupsToKeep;
  }
}



mojo.internal.Struct(
    AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec.$,
    'AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams',
    [
      mojo.internal.StructField(
        'failedWellKnownCheck', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.failedWellKnownCheck;
  }
}



mojo.internal.Struct(
    AdAuctionService_UpdateAdInterestGroups_ParamsSpec.$,
    'AdAuctionService_UpdateAdInterestGroups_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AdAuctionService_UpdateAdInterestGroups_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec.$,
    'AdAuctionService_DeprecatedGetURLFromURN_Params',
    [
      mojo.internal.StructField(
        'uuidUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendReports', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_DeprecatedGetURLFromURN_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.uuidUrl;
    /** @type { !boolean } */
    this.sendReports;
  }
}



mojo.internal.Struct(
    AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec.$,
    'AdAuctionService_DeprecatedGetURLFromURN_ResponseParams',
    [
      mojo.internal.StructField(
        'decodedUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdAuctionService_DeprecatedGetURLFromURN_ResponseParams {
  constructor() {
    /** @type { (url_mojom_Url|undefined) } */
    this.decodedUrl;
  }
}



mojo.internal.Struct(
    AdAuctionService_DeprecatedReplaceInURN_ParamsSpec.$,
    'AdAuctionService_DeprecatedReplaceInURN_Params',
    [
      mojo.internal.StructField(
        'uuidUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'replacements', 8,
        0,
        mojo.internal.Array(blink_mojom_AdKeywordReplacementSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_DeprecatedReplaceInURN_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.uuidUrl;
    /** @type { !Array<!blink_mojom_AdKeywordReplacement> } */
    this.replacements;
  }
}



mojo.internal.Struct(
    AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec.$,
    'AdAuctionService_DeprecatedReplaceInURN_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AdAuctionService_DeprecatedReplaceInURN_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec.$,
    'AdAuctionService_GetInterestGroupAdAuctionData_Params',
    [
      mojo.internal.StructField(
        'sellers', 0,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, url_mojom_OriginSpec.$, true),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        blink_mojom_AuctionDataConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_GetInterestGroupAdAuctionData_Params {
  constructor() {
    /** @type { !Map<!url_mojom_Origin, ?url_mojom_Origin> } */
    this.sellers;
    /** @type { !blink_mojom_AuctionDataConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec.$,
    'AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams',
    [
      mojo.internal.StructField(
        'requests', 0,
        0,
        mojo.internal.Array(blink_mojom_AdAuctionPerSellerRequestSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestId', 8,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams {
  constructor() {
    /** @type { !Array<!blink_mojom_AdAuctionPerSellerRequest> } */
    this.requests;
    /** @type { (mojoBase_mojom_Uuid|undefined) } */
    this.requestId;
  }
}

mojo.internal.Union(
    AuctionAdConfigAuctionIdSpec.$, 'AuctionAdConfigAuctionId',
    {
      'mainAuction': {
        'ordinal': 0,
        'type': mojo.internal.Uint32,
      },
      'componentAuction': {
        'ordinal': 1,
        'type': mojo.internal.Uint32,
      },
    });

/**
 * @typedef { {
 *   mainAuction: (!number|undefined),
 *   componentAuction: (!number|undefined),
 * } }
 */
export const AuctionAdConfigAuctionId = {};
