// third_party/blink/public/mojom/input/touch_event.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/touch_event.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/touch_event.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/touch_event.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT TouchEventConsumers {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TouchEventConsumers, T>::value>;
  using DataView = TouchEventConsumersDataView;
  using Data_ = internal::TouchEventConsumers_Data;

  template <typename... Args>
  static TouchEventConsumersPtr New(Args&&... args) {
    return TouchEventConsumersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TouchEventConsumersPtr From(const U& u) {
    return mojo::TypeConverter<TouchEventConsumersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TouchEventConsumers>::Convert(*this);
  }


  TouchEventConsumers();

  TouchEventConsumers(
      bool has_touch_event_handlers,
      bool has_hit_testable_scrollbar);


  ~TouchEventConsumers();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TouchEventConsumersPtr>
  TouchEventConsumersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchEventConsumers::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchEventConsumers::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TouchEventConsumers::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TouchEventConsumers_UnserializedMessageContext<
            UserType, TouchEventConsumers::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TouchEventConsumers::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TouchEventConsumers::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TouchEventConsumers_UnserializedMessageContext<
            UserType, TouchEventConsumers::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TouchEventConsumers::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_touch_event_handlers;
  
  bool has_hit_testable_scrollbar;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
TouchEventConsumersPtr TouchEventConsumers::Clone() const {
  return New(
      mojo::Clone(has_touch_event_handlers),
      mojo::Clone(has_hit_testable_scrollbar)
  );
}

template <typename T, TouchEventConsumers::EnableIfSame<T>*>
bool TouchEventConsumers::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_touch_event_handlers, other_struct.has_touch_event_handlers))
    return false;
  if (!mojo::Equals(this->has_hit_testable_scrollbar, other_struct.has_hit_testable_scrollbar))
    return false;
  return true;
}

template <typename T, TouchEventConsumers::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_touch_event_handlers < rhs.has_touch_event_handlers)
    return true;
  if (rhs.has_touch_event_handlers < lhs.has_touch_event_handlers)
    return false;
  if (lhs.has_hit_testable_scrollbar < rhs.has_hit_testable_scrollbar)
    return true;
  if (rhs.has_hit_testable_scrollbar < lhs.has_hit_testable_scrollbar)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::TouchEventConsumers::DataView,
                                         ::blink::mojom::TouchEventConsumersPtr> {
  static bool IsNull(const ::blink::mojom::TouchEventConsumersPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::TouchEventConsumersPtr* output) { output->reset(); }

  static decltype(::blink::mojom::TouchEventConsumers::has_touch_event_handlers) has_touch_event_handlers(
      const ::blink::mojom::TouchEventConsumersPtr& input) {
    return input->has_touch_event_handlers;
  }

  static decltype(::blink::mojom::TouchEventConsumers::has_hit_testable_scrollbar) has_hit_testable_scrollbar(
      const ::blink::mojom::TouchEventConsumersPtr& input) {
    return input->has_hit_testable_scrollbar;
  }

  static bool Read(::blink::mojom::TouchEventConsumers::DataView input, ::blink::mojom::TouchEventConsumersPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_H_