// third_party/blink/public/mojom/input/input_messages.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.TextSuggestionBackendPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.TextSuggestionBackend.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.TextSuggestionBackendInterface }
 */
blink.mojom.TextSuggestionBackendRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.TextSuggestionBackendPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.TextSuggestionBackendPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.TextSuggestionBackendPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } suggestion
   */

  applySpellCheckSuggestion(
      suggestion) {
    this.proxy.sendMessage(
        0,
        blink.mojom.TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec.$,
        null,
        [
          suggestion
        ],
        false);
  }

  
  /**
   * @param { !number } markerTag
   * @param { !number } suggestionIndex
   */

  applyTextSuggestion(
      markerTag,
      suggestionIndex) {
    this.proxy.sendMessage(
        1,
        blink.mojom.TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec.$,
        null,
        [
          markerTag,
          suggestionIndex
        ],
        false);
  }

  
  /**
   */

  deleteActiveSuggestionRange() {
    this.proxy.sendMessage(
        2,
        blink.mojom.TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } suggestion
   */

  onNewWordAddedToDictionary(
      suggestion) {
    this.proxy.sendMessage(
        3,
        blink.mojom.TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec.$,
        null,
        [
          suggestion
        ],
        false);
  }

  
  /**
   */

  onSuggestionMenuClosed() {
    this.proxy.sendMessage(
        4,
        blink.mojom.TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } maxNumberOfSuggestions
   */

  suggestionMenuTimeoutCallback(
      maxNumberOfSuggestions) {
    this.proxy.sendMessage(
        5,
        blink.mojom.TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec.$,
        null,
        [
          maxNumberOfSuggestions
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextSuggestionBackend
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.TextSuggestionBackendReceiver = class {
  /**
   * @param {!blink.mojom.TextSuggestionBackendInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.TextSuggestionBackendRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.TextSuggestionBackendRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TextSuggestionBackendRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec.$,
        null,
        impl.applySpellCheckSuggestion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec.$,
        null,
        impl.applyTextSuggestion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec.$,
        null,
        impl.deleteActiveSuggestionRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec.$,
        null,
        impl.onNewWordAddedToDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec.$,
        null,
        impl.onSuggestionMenuClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec.$,
        null,
        impl.suggestionMenuTimeoutCallback.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.TextSuggestionBackend = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TextSuggestionBackend";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.TextSuggestionBackendRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.TextSuggestionBackendRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextSuggestionBackend
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.TextSuggestionBackendCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.TextSuggestionBackendRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TextSuggestionBackendRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.applySpellCheckSuggestion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec.$,
        null,
        this.applySpellCheckSuggestion.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.applyTextSuggestion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec.$,
        null,
        this.applyTextSuggestion.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteActiveSuggestionRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec.$,
        null,
        this.deleteActiveSuggestionRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNewWordAddedToDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec.$,
        null,
        this.onNewWordAddedToDictionary.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSuggestionMenuClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec.$,
        null,
        this.onSuggestionMenuClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suggestionMenuTimeoutCallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec.$,
        null,
        this.suggestionMenuTimeoutCallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec.$,
    'TextSuggestionBackend_ApplySpellCheckSuggestion_Params',
    [
      mojo.internal.StructField(
        'suggestion', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.TextSuggestionBackend_ApplySpellCheckSuggestion_Params = class {
  constructor() {
    /** @export { !string } */
    this.suggestion;
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec.$,
    'TextSuggestionBackend_ApplyTextSuggestion_Params',
    [
      mojo.internal.StructField(
        'markerTag', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestionIndex', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.TextSuggestionBackend_ApplyTextSuggestion_Params = class {
  constructor() {
    /** @export { !number } */
    this.markerTag;
    /** @export { !number } */
    this.suggestionIndex;
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec.$,
    'TextSuggestionBackend_DeleteActiveSuggestionRange_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.TextSuggestionBackend_DeleteActiveSuggestionRange_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec.$,
    'TextSuggestionBackend_OnNewWordAddedToDictionary_Params',
    [
      mojo.internal.StructField(
        'suggestion', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.TextSuggestionBackend_OnNewWordAddedToDictionary_Params = class {
  constructor() {
    /** @export { !string } */
    this.suggestion;
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec.$,
    'TextSuggestionBackend_OnSuggestionMenuClosed_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.TextSuggestionBackend_OnSuggestionMenuClosed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec.$,
    'TextSuggestionBackend_SuggestionMenuTimeoutCallback_Params',
    [
      mojo.internal.StructField(
        'maxNumberOfSuggestions', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.TextSuggestionBackend_SuggestionMenuTimeoutCallback_Params = class {
  constructor() {
    /** @export { !number } */
    this.maxNumberOfSuggestions;
  }
};

