// third_party/blink/public/mojom/input/input_handler.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/input/input_handler.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var browser_controls_offset_tag_modifications$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/browser_controls_offset_tag_modifications.mojom', '../../../../../cc/mojom/browser_controls_offset_tag_modifications.mojom.js');
  }
  var browser_controls_state$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/browser_controls_state.mojom', '../../../../../cc/mojom/browser_controls_state.mojom.js');
  }
  var overscroll_behavior$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/overscroll_behavior.mojom', '../../../../../cc/mojom/overscroll_behavior.mojom.js');
  }
  var touch_action$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/touch_action.mojom', '../../../../../cc/mojom/touch_action.mojom.js');
  }
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var gesture_event$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/gesture_event.mojom', 'gesture_event.mojom.js');
  }
  var handwriting_gesture_result$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/handwriting_gesture_result.mojom', 'handwriting_gesture_result.mojom.js');
  }
  var input_event$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/input_event.mojom', 'input_event.mojom.js');
  }
  var input_event_result$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/input_event_result.mojom', 'input_event_result.mojom.js');
  }
  var pointer_lock_context$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/pointer_lock_context.mojom', 'pointer_lock_context.mojom.js');
  }
  var pointer_lock_result$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/pointer_lock_result.mojom', 'pointer_lock_result.mojom.js');
  }
  var stylus_writing_gesture$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/stylus_writing_gesture.mojom', 'stylus_writing_gesture.mojom.js');
  }
  var touch_event$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/touch_event.mojom', 'touch_event.mojom.js');
  }
  var selection_menu_behavior$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/selection_menu/selection_menu_behavior.mojom', '../selection_menu/selection_menu_behavior.mojom.js');
  }
  var ime_types$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/ime/mojom/ime_types.mojom', '../../../../../ui/base/ime/mojom/ime_types.mojom.js');
  }
  var event$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/events/mojom/event.mojom', '../../../../../ui/events/mojom/event.mojom.js');
  }
  var event_constants$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/events/mojom/event_constants.mojom', '../../../../../ui/events/mojom/event_constants.mojom.js');
  }
  var event_latency_metadata$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/events/mojom/event_latency_metadata.mojom', '../../../../../ui/events/mojom/event_latency_metadata.mojom.js');
  }
  var scroll_granularity$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/events/mojom/scroll_granularity.mojom', '../../../../../ui/events/mojom/scroll_granularity.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var range$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/range/mojom/range.mojom', '../../../../../ui/gfx/range/mojom/range.mojom.js');
  }
  var latency_info$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/latency/mojom/latency_info.mojom', '../../../../../ui/latency/mojom/latency_info.mojom.js');
  }


  var SelectionGranularity = {};
  SelectionGranularity.kWord = 0;
  SelectionGranularity.kSentence = 1;
  SelectionGranularity.MIN_VALUE = 0;
  SelectionGranularity.MAX_VALUE = 1;

  SelectionGranularity.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SelectionGranularity.toKnownEnumValue = function(value) {
    return value;
  };

  SelectionGranularity.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PanAction = {};
  PanAction.kNone = 0;
  PanAction.kScroll = 1;
  PanAction.kMoveCursorOrScroll = 2;
  PanAction.kStylusWritable = 3;
  PanAction.MIN_VALUE = 0;
  PanAction.MAX_VALUE = 3;

  PanAction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  PanAction.toKnownEnumValue = function(value) {
    return value;
  };

  PanAction.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FocusState = {};
  FocusState.kFocused = 0;
  FocusState.kNotFocusedAndActive = 1;
  FocusState.kNotFocusedAndNotActive = 2;
  FocusState.MIN_VALUE = 0;
  FocusState.MAX_VALUE = 2;

  FocusState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  FocusState.toKnownEnumValue = function(value) {
    return value;
  };

  FocusState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function KeyData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KeyData.prototype.initDefaults_ = function() {
    this.domKey = 0;
    this.domCode = 0;
    this.windowsKeyCode = 0;
    this.nativeKeyCode = 0;
    this.isSystemKey = false;
    this.isBrowserShortcut = false;
    this.text = null;
    this.unmodifiedText = null;
  };
  KeyData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KeyData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;








    // validate KeyData.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeyData.unmodifiedText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KeyData.encodedSize = codec.kStructHeaderSize + 40;

  KeyData.decode = function(decoder) {
    var packed;
    var val = new KeyData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.domKey =
        decoder.decodeStruct(codec.Int32);
    val.domCode =
        decoder.decodeStruct(codec.Int32);
    val.windowsKeyCode =
        decoder.decodeStruct(codec.Int32);
    val.nativeKeyCode =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.isSystemKey = (packed >> 0) & 1 ? true : false;
    val.isBrowserShortcut = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    val.unmodifiedText =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  KeyData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KeyData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.domKey);
    encoder.encodeStruct(codec.Int32, val.domCode);
    encoder.encodeStruct(codec.Int32, val.windowsKeyCode);
    encoder.encodeStruct(codec.Int32, val.nativeKeyCode);
    packed = 0;
    packed |= (val.isSystemKey & 1) << 0
    packed |= (val.isBrowserShortcut & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string16$.String16, val.text);
    encoder.encodeStructPointer(string16$.String16, val.unmodifiedText);
  };
  function PointerData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PointerData.prototype.initDefaults_ = function() {
    this.pointerId = 0;
    this.force = 0;
    this.tiltX = 0;
    this.tiltY = 0;
    this.tangentialPressure = 0;
    this.twist = 0;
    this.button = 0;
    this.pointerType = 0;
    this.movementX = 0;
    this.movementY = 0;
    this.isRawMovementEvent = false;
    this.deviceId = 0;
    this.widgetPosition = null;
    this.screenPosition = null;
    this.mouseData = null;
  };
  PointerData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PointerData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;








    // validate PointerData.button
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, input_event$.Button);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PointerData.pointerType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, event_constants$.EventPointerType);
    if (err !== validator.validationError.NONE)
        return err;





    // validate PointerData.widgetPosition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PointerData.screenPosition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PointerData.mouseData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, MouseData, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PointerData.encodedSize = codec.kStructHeaderSize + 80;

  PointerData.decode = function(decoder) {
    var packed;
    var val = new PointerData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointerId =
        decoder.decodeStruct(codec.Int32);
    val.force =
        decoder.decodeStruct(codec.Float);
    val.tiltX =
        decoder.decodeStruct(codec.Double);
    val.tiltY =
        decoder.decodeStruct(codec.Double);
    val.tangentialPressure =
        decoder.decodeStruct(codec.Float);
    val.twist =
        decoder.decodeStruct(codec.Int32);
    val.button =
        decoder.decodeStruct(new codec.Enum(input_event$.Button));
    val.pointerType =
        decoder.decodeStruct(new codec.Enum(event_constants$.EventPointerType));
    val.movementX =
        decoder.decodeStruct(codec.Int32);
    val.movementY =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.isRawMovementEvent = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.deviceId =
        decoder.decodeStruct(codec.Int32);
    val.widgetPosition =
        decoder.decodeStructPointer(geometry$.PointF);
    val.screenPosition =
        decoder.decodeStructPointer(geometry$.PointF);
    val.mouseData =
        decoder.decodeStructPointer(MouseData);
    return val;
  };

  PointerData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PointerData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.pointerId);
    encoder.encodeStruct(codec.Float, val.force);
    encoder.encodeStruct(codec.Double, val.tiltX);
    encoder.encodeStruct(codec.Double, val.tiltY);
    encoder.encodeStruct(codec.Float, val.tangentialPressure);
    encoder.encodeStruct(codec.Int32, val.twist);
    encoder.encodeStruct(codec.Int32, val.button);
    encoder.encodeStruct(codec.Int32, val.pointerType);
    encoder.encodeStruct(codec.Int32, val.movementX);
    encoder.encodeStruct(codec.Int32, val.movementY);
    packed = 0;
    packed |= (val.isRawMovementEvent & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.deviceId);
    encoder.encodeStructPointer(geometry$.PointF, val.widgetPosition);
    encoder.encodeStructPointer(geometry$.PointF, val.screenPosition);
    encoder.encodeStructPointer(MouseData, val.mouseData);
  };
  function WheelData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WheelData.prototype.initDefaults_ = function() {
    this.deltaX = 0;
    this.deltaY = 0;
    this.wheelTicksX = 0;
    this.wheelTicksY = 0;
    this.accelerationRatioX = 0;
    this.accelerationRatioY = 0;
    this.phase = 0;
    this.momentumPhase = 0;
    this.eventAction = 0;
    this.deltaUnits = 0;
    this.cancelable = 0;
    this.railsMode = 0;
  };
  WheelData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WheelData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;










    // validate WheelData.cancelable
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, input_event$.DispatchType);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  WheelData.encodedSize = codec.kStructHeaderSize + 40;

  WheelData.decode = function(decoder) {
    var packed;
    var val = new WheelData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deltaX =
        decoder.decodeStruct(codec.Float);
    val.deltaY =
        decoder.decodeStruct(codec.Float);
    val.wheelTicksX =
        decoder.decodeStruct(codec.Float);
    val.wheelTicksY =
        decoder.decodeStruct(codec.Float);
    val.accelerationRatioX =
        decoder.decodeStruct(codec.Float);
    val.accelerationRatioY =
        decoder.decodeStruct(codec.Float);
    val.phase =
        decoder.decodeStruct(codec.Uint8);
    val.momentumPhase =
        decoder.decodeStruct(codec.Uint8);
    val.eventAction =
        decoder.decodeStruct(codec.Uint8);
    val.deltaUnits =
        decoder.decodeStruct(codec.Uint8);
    val.cancelable =
        decoder.decodeStruct(new codec.Enum(input_event$.DispatchType));
    val.railsMode =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WheelData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WheelData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.deltaX);
    encoder.encodeStruct(codec.Float, val.deltaY);
    encoder.encodeStruct(codec.Float, val.wheelTicksX);
    encoder.encodeStruct(codec.Float, val.wheelTicksY);
    encoder.encodeStruct(codec.Float, val.accelerationRatioX);
    encoder.encodeStruct(codec.Float, val.accelerationRatioY);
    encoder.encodeStruct(codec.Uint8, val.phase);
    encoder.encodeStruct(codec.Uint8, val.momentumPhase);
    encoder.encodeStruct(codec.Uint8, val.eventAction);
    encoder.encodeStruct(codec.Uint8, val.deltaUnits);
    encoder.encodeStruct(codec.Int32, val.cancelable);
    encoder.encodeStruct(codec.Int32, val.railsMode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MouseData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MouseData.prototype.initDefaults_ = function() {
    this.clickCount = 0;
    this.wheelData = null;
  };
  MouseData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MouseData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MouseData.wheelData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, WheelData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MouseData.encodedSize = codec.kStructHeaderSize + 16;

  MouseData.decode = function(decoder) {
    var packed;
    var val = new MouseData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.clickCount =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.wheelData =
        decoder.decodeStructPointer(WheelData);
    return val;
  };

  MouseData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MouseData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.clickCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(WheelData, val.wheelData);
  };
  function ScrollData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ScrollData.prototype.initDefaults_ = function() {
    this.deltaX = 0;
    this.deltaY = 0;
    this.deltaUnits = 0;
    this.targetViewport = false;
    this.synthetic = false;
    this.cursorControl = false;
    this.inertialPhase = 0;
    this.pointerCount = 0;
  };
  ScrollData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ScrollData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ScrollData.deltaUnits
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, scroll_granularity$.ScrollGranularity);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ScrollData.inertialPhase
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, gesture_event$.InertialPhaseState);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  ScrollData.encodedSize = codec.kStructHeaderSize + 24;

  ScrollData.decode = function(decoder) {
    var packed;
    var val = new ScrollData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deltaX =
        decoder.decodeStruct(codec.Float);
    val.deltaY =
        decoder.decodeStruct(codec.Float);
    val.deltaUnits =
        decoder.decodeStruct(new codec.Enum(scroll_granularity$.ScrollGranularity));
    packed = decoder.readUint8();
    val.targetViewport = (packed >> 0) & 1 ? true : false;
    val.synthetic = (packed >> 1) & 1 ? true : false;
    val.cursorControl = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.inertialPhase =
        decoder.decodeStruct(new codec.Enum(gesture_event$.InertialPhaseState));
    val.pointerCount =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  ScrollData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ScrollData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.deltaX);
    encoder.encodeStruct(codec.Float, val.deltaY);
    encoder.encodeStruct(codec.Int32, val.deltaUnits);
    packed = 0;
    packed |= (val.targetViewport & 1) << 0
    packed |= (val.synthetic & 1) << 1
    packed |= (val.cursorControl & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.inertialPhase);
    encoder.encodeStruct(codec.Int32, val.pointerCount);
  };
  function PinchBeginData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PinchBeginData.prototype.initDefaults_ = function() {
    this.needsWheelEvent = false;
  };
  PinchBeginData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PinchBeginData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PinchBeginData.encodedSize = codec.kStructHeaderSize + 8;

  PinchBeginData.decode = function(decoder) {
    var packed;
    var val = new PinchBeginData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.needsWheelEvent = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PinchBeginData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PinchBeginData.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.needsWheelEvent & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PinchUpdateData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PinchUpdateData.prototype.initDefaults_ = function() {
    this.scale = 0;
    this.zoomDisabled = false;
    this.needsWheelEvent = false;
  };
  PinchUpdateData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PinchUpdateData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  PinchUpdateData.encodedSize = codec.kStructHeaderSize + 8;

  PinchUpdateData.decode = function(decoder) {
    var packed;
    var val = new PinchUpdateData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scale =
        decoder.decodeStruct(codec.Float);
    packed = decoder.readUint8();
    val.zoomDisabled = (packed >> 0) & 1 ? true : false;
    val.needsWheelEvent = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PinchUpdateData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PinchUpdateData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.scale);
    packed = 0;
    packed |= (val.zoomDisabled & 1) << 0
    packed |= (val.needsWheelEvent & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PinchEndData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PinchEndData.prototype.initDefaults_ = function() {
    this.needsWheelEvent = false;
  };
  PinchEndData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PinchEndData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PinchEndData.encodedSize = codec.kStructHeaderSize + 8;

  PinchEndData.decode = function(decoder) {
    var packed;
    var val = new PinchEndData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.needsWheelEvent = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PinchEndData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PinchEndData.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.needsWheelEvent & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FlingData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FlingData.prototype.initDefaults_ = function() {
    this.velocityX = 0;
    this.velocityY = 0;
    this.targetViewport = false;
    this.preventBoosting = false;
  };
  FlingData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FlingData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  FlingData.encodedSize = codec.kStructHeaderSize + 16;

  FlingData.decode = function(decoder) {
    var packed;
    var val = new FlingData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.velocityX =
        decoder.decodeStruct(codec.Float);
    val.velocityY =
        decoder.decodeStruct(codec.Float);
    packed = decoder.readUint8();
    val.targetViewport = (packed >> 0) & 1 ? true : false;
    val.preventBoosting = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FlingData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FlingData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.velocityX);
    encoder.encodeStruct(codec.Float, val.velocityY);
    packed = 0;
    packed |= (val.targetViewport & 1) << 0
    packed |= (val.preventBoosting & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TapData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TapData.prototype.initDefaults_ = function() {
    this.tapCount = 0;
    this.needsWheelEvent = false;
  };
  TapData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TapData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  TapData.encodedSize = codec.kStructHeaderSize + 8;

  TapData.decode = function(decoder) {
    var packed;
    var val = new TapData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tapCount =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.needsWheelEvent = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TapData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TapData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.tapCount);
    packed = 0;
    packed |= (val.needsWheelEvent & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TapDownData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TapDownData.prototype.initDefaults_ = function() {
    this.tapDownCount = 0;
  };
  TapDownData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TapDownData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TapDownData.encodedSize = codec.kStructHeaderSize + 8;

  TapDownData.decode = function(decoder) {
    var packed;
    var val = new TapDownData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tapDownCount =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TapDownData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TapDownData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.tapDownCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GestureData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GestureData.prototype.initDefaults_ = function() {
    this.screenPosition = null;
    this.widgetPosition = null;
    this.sourceDevice = 0;
    this.isSourceTouchEventSetBlocking = false;
    this.primaryPointerType = 0;
    this.primaryUniqueTouchEventId = 0;
    this.uniqueTouchEventId = 0;
    this.contactSize = null;
    this.scrollData = null;
    this.pinchBeginData = null;
    this.pinchUpdateData = null;
    this.pinchEndData = null;
    this.tapData = null;
    this.tapDownData = null;
    this.flingData = null;
  };
  GestureData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GestureData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 112}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.screenPosition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.widgetPosition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.sourceDevice
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, gesture_event$.GestureDevice);
    if (err !== validator.validationError.NONE)
        return err;



    // validate GestureData.primaryPointerType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, event_constants$.EventPointerType);
    if (err !== validator.validationError.NONE)
        return err;




    // validate GestureData.contactSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Size, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.scrollData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, ScrollData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.pinchBeginData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, PinchBeginData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.pinchUpdateData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, PinchUpdateData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.pinchEndData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, PinchEndData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.tapData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, TapData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.tapDownData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, TapDownData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GestureData.flingData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, FlingData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GestureData.encodedSize = codec.kStructHeaderSize + 104;

  GestureData.decode = function(decoder) {
    var packed;
    var val = new GestureData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.screenPosition =
        decoder.decodeStructPointer(geometry$.PointF);
    val.widgetPosition =
        decoder.decodeStructPointer(geometry$.PointF);
    val.sourceDevice =
        decoder.decodeStruct(new codec.Enum(gesture_event$.GestureDevice));
    packed = decoder.readUint8();
    val.isSourceTouchEventSetBlocking = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.primaryPointerType =
        decoder.decodeStruct(new codec.Enum(event_constants$.EventPointerType));
    val.primaryUniqueTouchEventId =
        decoder.decodeStruct(codec.Int32);
    val.uniqueTouchEventId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.contactSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.scrollData =
        decoder.decodeStructPointer(ScrollData);
    val.pinchBeginData =
        decoder.decodeStructPointer(PinchBeginData);
    val.pinchUpdateData =
        decoder.decodeStructPointer(PinchUpdateData);
    val.pinchEndData =
        decoder.decodeStructPointer(PinchEndData);
    val.tapData =
        decoder.decodeStructPointer(TapData);
    val.tapDownData =
        decoder.decodeStructPointer(TapDownData);
    val.flingData =
        decoder.decodeStructPointer(FlingData);
    return val;
  };

  GestureData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GestureData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.PointF, val.screenPosition);
    encoder.encodeStructPointer(geometry$.PointF, val.widgetPosition);
    encoder.encodeStruct(codec.Int32, val.sourceDevice);
    packed = 0;
    packed |= (val.isSourceTouchEventSetBlocking & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.primaryPointerType);
    encoder.encodeStruct(codec.Int32, val.primaryUniqueTouchEventId);
    encoder.encodeStruct(codec.Int32, val.uniqueTouchEventId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Size, val.contactSize);
    encoder.encodeStructPointer(ScrollData, val.scrollData);
    encoder.encodeStructPointer(PinchBeginData, val.pinchBeginData);
    encoder.encodeStructPointer(PinchUpdateData, val.pinchUpdateData);
    encoder.encodeStructPointer(PinchEndData, val.pinchEndData);
    encoder.encodeStructPointer(TapData, val.tapData);
    encoder.encodeStructPointer(TapDownData, val.tapDownData);
    encoder.encodeStructPointer(FlingData, val.flingData);
  };
  function TouchPoint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TouchPoint.prototype.initDefaults_ = function() {
    this.state = 0;
    this.radiusX = 0;
    this.radiusY = 0;
    this.rotationAngle = 0;
    this.pointerData = null;
  };
  TouchPoint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TouchPoint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TouchPoint.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, touch_event$.TouchState);
    if (err !== validator.validationError.NONE)
        return err;





    // validate TouchPoint.pointerData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, PointerData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TouchPoint.encodedSize = codec.kStructHeaderSize + 24;

  TouchPoint.decode = function(decoder) {
    var packed;
    var val = new TouchPoint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStruct(new codec.Enum(touch_event$.TouchState));
    val.radiusX =
        decoder.decodeStruct(codec.Float);
    val.radiusY =
        decoder.decodeStruct(codec.Float);
    val.rotationAngle =
        decoder.decodeStruct(codec.Float);
    val.pointerData =
        decoder.decodeStructPointer(PointerData);
    return val;
  };

  TouchPoint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TouchPoint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.encodeStruct(codec.Float, val.radiusX);
    encoder.encodeStruct(codec.Float, val.radiusY);
    encoder.encodeStruct(codec.Float, val.rotationAngle);
    encoder.encodeStructPointer(PointerData, val.pointerData);
  };
  function TouchData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TouchData.prototype.initDefaults_ = function() {
    this.cancelable = 0;
    this.movedBeyondSlopRegion = false;
    this.touchStartOrFirstMove = false;
    this.hovering = false;
    this.uniqueTouchEventId = 0;
    this.touches = null;
  };
  TouchData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TouchData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TouchData.cancelable
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, input_event$.DispatchType);
    if (err !== validator.validationError.NONE)
        return err;






    // validate TouchData.touches
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(TouchPoint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TouchData.encodedSize = codec.kStructHeaderSize + 24;

  TouchData.decode = function(decoder) {
    var packed;
    var val = new TouchData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cancelable =
        decoder.decodeStruct(new codec.Enum(input_event$.DispatchType));
    packed = decoder.readUint8();
    val.movedBeyondSlopRegion = (packed >> 0) & 1 ? true : false;
    val.touchStartOrFirstMove = (packed >> 1) & 1 ? true : false;
    val.hovering = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.uniqueTouchEventId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.touches =
        decoder.decodeArrayPointer(new codec.PointerTo(TouchPoint));
    return val;
  };

  TouchData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TouchData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.cancelable);
    packed = 0;
    packed |= (val.movedBeyondSlopRegion & 1) << 0
    packed |= (val.touchStartOrFirstMove & 1) << 1
    packed |= (val.hovering & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.uniqueTouchEventId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(TouchPoint), val.touches);
  };
  function Event(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Event.prototype.initDefaults_ = function() {
    this.type = 0;
    this.modifiers = 0;
    this.timestamp = null;
    this.latency = null;
    this.eventLatencyMetadata = null;
    this.keyData = null;
    this.pointerData = null;
    this.gestureData = null;
    this.touchData = null;
    this.inputSource = 0;
  };
  Event.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Event.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Event.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, input_event$.EventType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Event.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Event.latency
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, latency_info$.LatencyInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Event.eventLatencyMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, event_latency_metadata$.EventLatencyMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Event.keyData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, KeyData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Event.pointerData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, PointerData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Event.gestureData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, GestureData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Event.touchData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, TouchData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Event.inputSource
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 64, input_event$.InputSource);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Event.encodedSize = codec.kStructHeaderSize + 72;

  Event.decode = function(decoder) {
    var packed;
    var val = new Event();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(input_event$.EventType));
    val.modifiers =
        decoder.decodeStruct(codec.Int32);
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.latency =
        decoder.decodeStructPointer(latency_info$.LatencyInfo);
    val.eventLatencyMetadata =
        decoder.decodeStructPointer(event_latency_metadata$.EventLatencyMetadata);
    val.keyData =
        decoder.decodeStructPointer(KeyData);
    val.pointerData =
        decoder.decodeStructPointer(PointerData);
    val.gestureData =
        decoder.decodeStructPointer(GestureData);
    val.touchData =
        decoder.decodeStructPointer(TouchData);
    val.inputSource =
        decoder.decodeStruct(new codec.Enum(input_event$.InputSource));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Event.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Event.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.modifiers);
    encoder.encodeStructPointer(time$.TimeTicks, val.timestamp);
    encoder.encodeStructPointer(latency_info$.LatencyInfo, val.latency);
    encoder.encodeStructPointer(event_latency_metadata$.EventLatencyMetadata, val.eventLatencyMetadata);
    encoder.encodeStructPointer(KeyData, val.keyData);
    encoder.encodeStructPointer(PointerData, val.pointerData);
    encoder.encodeStructPointer(GestureData, val.gestureData);
    encoder.encodeStructPointer(TouchData, val.touchData);
    encoder.encodeStruct(codec.Int32, val.inputSource);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DidOverscrollParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DidOverscrollParams.prototype.initDefaults_ = function() {
    this.accumulatedOverscroll = null;
    this.latestOverscrollDelta = null;
    this.currentFlingVelocity = null;
    this.causalEventViewportPoint = null;
    this.overscrollBehavior = null;
    this.sourceDevice = 0;
  };
  DidOverscrollParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DidOverscrollParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DidOverscrollParams.accumulatedOverscroll
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DidOverscrollParams.latestOverscrollDelta
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DidOverscrollParams.currentFlingVelocity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DidOverscrollParams.causalEventViewportPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DidOverscrollParams.overscrollBehavior
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, overscroll_behavior$.OverscrollBehavior, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DidOverscrollParams.sourceDevice
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, gesture_event$.GestureDevice);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DidOverscrollParams.encodedSize = codec.kStructHeaderSize + 48;

  DidOverscrollParams.decode = function(decoder) {
    var packed;
    var val = new DidOverscrollParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.accumulatedOverscroll =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.latestOverscrollDelta =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.currentFlingVelocity =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.causalEventViewportPoint =
        decoder.decodeStructPointer(geometry$.PointF);
    val.overscrollBehavior =
        decoder.decodeStructPointer(overscroll_behavior$.OverscrollBehavior);
    val.sourceDevice =
        decoder.decodeStruct(new codec.Enum(gesture_event$.GestureDevice));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DidOverscrollParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DidOverscrollParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.accumulatedOverscroll);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.latestOverscrollDelta);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.currentFlingVelocity);
    encoder.encodeStructPointer(geometry$.PointF, val.causalEventViewportPoint);
    encoder.encodeStructPointer(overscroll_behavior$.OverscrollBehavior, val.overscrollBehavior);
    encoder.encodeStruct(codec.Int32, val.sourceDevice);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TouchActionOptional(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TouchActionOptional.prototype.initDefaults_ = function() {
    this.touchAction = 0;
  };
  TouchActionOptional.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TouchActionOptional.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TouchActionOptional.touchAction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, touch_action$.TouchAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TouchActionOptional.encodedSize = codec.kStructHeaderSize + 8;

  TouchActionOptional.decode = function(decoder) {
    var packed;
    var val = new TouchActionOptional();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.touchAction =
        decoder.decodeStruct(new codec.Enum(touch_action$.TouchAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TouchActionOptional.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TouchActionOptional.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.touchAction);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EditCommand(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditCommand.prototype.initDefaults_ = function() {
    this.name = null;
    this.value = null;
  };
  EditCommand.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditCommand.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditCommand.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditCommand.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditCommand.encodedSize = codec.kStructHeaderSize + 16;

  EditCommand.decode = function(decoder) {
    var packed;
    var val = new EditCommand();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EditCommand.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditCommand.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.value);
  };
  function SelectAroundCaretResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SelectAroundCaretResult.prototype.initDefaults_ = function() {
    this.extendedStartAdjust = 0;
    this.extendedEndAdjust = 0;
    this.wordStartAdjust = 0;
    this.wordEndAdjust = 0;
  };
  SelectAroundCaretResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SelectAroundCaretResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  SelectAroundCaretResult.encodedSize = codec.kStructHeaderSize + 16;

  SelectAroundCaretResult.decode = function(decoder) {
    var packed;
    var val = new SelectAroundCaretResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extendedStartAdjust =
        decoder.decodeStruct(codec.Int32);
    val.extendedEndAdjust =
        decoder.decodeStruct(codec.Int32);
    val.wordStartAdjust =
        decoder.decodeStruct(codec.Int32);
    val.wordEndAdjust =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  SelectAroundCaretResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SelectAroundCaretResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.extendedStartAdjust);
    encoder.encodeStruct(codec.Int32, val.extendedEndAdjust);
    encoder.encodeStruct(codec.Int32, val.wordStartAdjust);
    encoder.encodeStruct(codec.Int32, val.wordEndAdjust);
  };
  function WidgetInputHandlerHost_SetTouchActionFromMain_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_SetTouchActionFromMain_Params.prototype.initDefaults_ = function() {
    this.touchAction = 0;
  };
  WidgetInputHandlerHost_SetTouchActionFromMain_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_SetTouchActionFromMain_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandlerHost_SetTouchActionFromMain_Params.touchAction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, touch_action$.TouchAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_SetTouchActionFromMain_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandlerHost_SetTouchActionFromMain_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_SetTouchActionFromMain_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.touchAction =
        decoder.decodeStruct(new codec.Enum(touch_action$.TouchAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandlerHost_SetTouchActionFromMain_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_SetTouchActionFromMain_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.touchAction);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandlerHost_SetPanAction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_SetPanAction_Params.prototype.initDefaults_ = function() {
    this.panAction = 0;
  };
  WidgetInputHandlerHost_SetPanAction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_SetPanAction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandlerHost_SetPanAction_Params.panAction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PanAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_SetPanAction_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandlerHost_SetPanAction_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_SetPanAction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.panAction =
        decoder.decodeStruct(new codec.Enum(PanAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandlerHost_SetPanAction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_SetPanAction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.panAction);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandlerHost_DidOverscroll_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_DidOverscroll_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  WidgetInputHandlerHost_DidOverscroll_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_DidOverscroll_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandlerHost_DidOverscroll_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DidOverscrollParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_DidOverscroll_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandlerHost_DidOverscroll_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_DidOverscroll_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(DidOverscrollParams);
    return val;
  };

  WidgetInputHandlerHost_DidOverscroll_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_DidOverscroll_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DidOverscrollParams, val.params);
  };
  function WidgetInputHandlerHost_DidStartScrollingViewport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_DidStartScrollingViewport_Params.prototype.initDefaults_ = function() {
  };
  WidgetInputHandlerHost_DidStartScrollingViewport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_DidStartScrollingViewport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_DidStartScrollingViewport_Params.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandlerHost_DidStartScrollingViewport_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_DidStartScrollingViewport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandlerHost_DidStartScrollingViewport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_DidStartScrollingViewport_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandlerHost_ImeCancelComposition_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_ImeCancelComposition_Params.prototype.initDefaults_ = function() {
  };
  WidgetInputHandlerHost_ImeCancelComposition_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_ImeCancelComposition_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_ImeCancelComposition_Params.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandlerHost_ImeCancelComposition_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_ImeCancelComposition_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandlerHost_ImeCancelComposition_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_ImeCancelComposition_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandlerHost_ImeCompositionRangeChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.prototype.initDefaults_ = function() {
    this.range = null;
    this.characterBounds = null;
  };
  WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.range
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, range$.Range, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.characterBounds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(geometry$.Rect), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.encodedSize = codec.kStructHeaderSize + 16;

  WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_ImeCompositionRangeChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.range =
        decoder.decodeStructPointer(range$.Range);
    val.characterBounds =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Rect));
    return val;
  };

  WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(range$.Range, val.range);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Rect), val.characterBounds);
  };
  function WidgetInputHandlerHost_SetMouseCapture_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_SetMouseCapture_Params.prototype.initDefaults_ = function() {
    this.capture = false;
  };
  WidgetInputHandlerHost_SetMouseCapture_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_SetMouseCapture_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_SetMouseCapture_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandlerHost_SetMouseCapture_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_SetMouseCapture_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.capture = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandlerHost_SetMouseCapture_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_SetMouseCapture_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.capture & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params.prototype.initDefaults_ = function() {
    this.autoscrollSelection = false;
  };
  WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.autoscrollSelection = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.autoscrollSelection & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandlerHost_RequestMouseLock_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_RequestMouseLock_Params.prototype.initDefaults_ = function() {
    this.fromUserGesture = false;
    this.unadjustedMovement = false;
  };
  WidgetInputHandlerHost_RequestMouseLock_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_RequestMouseLock_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_RequestMouseLock_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandlerHost_RequestMouseLock_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_RequestMouseLock_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.fromUserGesture = (packed >> 0) & 1 ? true : false;
    val.unadjustedMovement = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandlerHost_RequestMouseLock_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_RequestMouseLock_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.fromUserGesture & 1) << 0
    packed |= (val.unadjustedMovement & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandlerHost_RequestMouseLock_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandlerHost_RequestMouseLock_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.context = new pointer_lock_context$.PointerLockContextPtr();
  };
  WidgetInputHandlerHost_RequestMouseLock_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandlerHost_RequestMouseLock_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandlerHost_RequestMouseLock_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, pointer_lock_result$.PointerLockResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandlerHost_RequestMouseLock_ResponseParams.context
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandlerHost_RequestMouseLock_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  WidgetInputHandlerHost_RequestMouseLock_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandlerHost_RequestMouseLock_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(pointer_lock_result$.PointerLockResult));
    val.context =
        decoder.decodeStruct(new codec.NullableInterface(pointer_lock_context$.PointerLockContextPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandlerHost_RequestMouseLock_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandlerHost_RequestMouseLock_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.encodeStruct(new codec.NullableInterface(pointer_lock_context$.PointerLockContextPtr), val.context);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.prototype.initDefaults_ = function() {
    this.start = 0;
    this.end = 0;
    this.imeTextSpans = null;
  };
  FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.imeTextSpans
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(ime_types$.ImeTextSpan), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStruct(codec.Uint32);
    val.end =
        decoder.decodeStruct(codec.Uint32);
    val.imeTextSpans =
        decoder.decodeArrayPointer(new codec.PointerTo(ime_types$.ImeTextSpan));
    return val;
  };

  FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.start);
    encoder.encodeStruct(codec.Uint32, val.end);
    encoder.encodeArrayPointer(new codec.PointerTo(ime_types$.ImeTextSpan), val.imeTextSpans);
  };
  function FrameWidgetInputHandler_ClearImeTextSpansByType_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_ClearImeTextSpansByType_Params.prototype.initDefaults_ = function() {
    this.start = 0;
    this.end = 0;
    this.type = 0;
  };
  FrameWidgetInputHandler_ClearImeTextSpansByType_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_ClearImeTextSpansByType_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FrameWidgetInputHandler_ClearImeTextSpansByType_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ime_types$.ImeTextSpanType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_ClearImeTextSpansByType_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidgetInputHandler_ClearImeTextSpansByType_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_ClearImeTextSpansByType_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStruct(codec.Uint32);
    val.end =
        decoder.decodeStruct(codec.Uint32);
    val.type =
        decoder.decodeStruct(new codec.Enum(ime_types$.ImeTextSpanType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidgetInputHandler_ClearImeTextSpansByType_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_ClearImeTextSpansByType_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.start);
    encoder.encodeStruct(codec.Uint32, val.end);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_SetCompositionFromExistingText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_SetCompositionFromExistingText_Params.prototype.initDefaults_ = function() {
    this.start = 0;
    this.end = 0;
    this.imeTextSpans = null;
  };
  FrameWidgetInputHandler_SetCompositionFromExistingText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_SetCompositionFromExistingText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FrameWidgetInputHandler_SetCompositionFromExistingText_Params.imeTextSpans
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(ime_types$.ImeTextSpan), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_SetCompositionFromExistingText_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidgetInputHandler_SetCompositionFromExistingText_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_SetCompositionFromExistingText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStruct(codec.Int32);
    val.end =
        decoder.decodeStruct(codec.Int32);
    val.imeTextSpans =
        decoder.decodeArrayPointer(new codec.PointerTo(ime_types$.ImeTextSpan));
    return val;
  };

  FrameWidgetInputHandler_SetCompositionFromExistingText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_SetCompositionFromExistingText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.start);
    encoder.encodeStruct(codec.Int32, val.end);
    encoder.encodeArrayPointer(new codec.PointerTo(ime_types$.ImeTextSpan), val.imeTextSpans);
  };
  function FrameWidgetInputHandler_ExtendSelectionAndDelete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_ExtendSelectionAndDelete_Params.prototype.initDefaults_ = function() {
    this.before = 0;
    this.after = 0;
  };
  FrameWidgetInputHandler_ExtendSelectionAndDelete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_ExtendSelectionAndDelete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_ExtendSelectionAndDelete_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_ExtendSelectionAndDelete_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_ExtendSelectionAndDelete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.before =
        decoder.decodeStruct(codec.Int32);
    val.after =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  FrameWidgetInputHandler_ExtendSelectionAndDelete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_ExtendSelectionAndDelete_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.before);
    encoder.encodeStruct(codec.Int32, val.after);
  };
  function FrameWidgetInputHandler_ExtendSelectionAndReplace_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.prototype.initDefaults_ = function() {
    this.before = 0;
    this.after = 0;
    this.replacementText = null;
  };
  FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.replacementText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_ExtendSelectionAndReplace_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.before =
        decoder.decodeStruct(codec.Uint32);
    val.after =
        decoder.decodeStruct(codec.Uint32);
    val.replacementText =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.before);
    encoder.encodeStruct(codec.Uint32, val.after);
    encoder.encodeStructPointer(string16$.String16, val.replacementText);
  };
  function FrameWidgetInputHandler_DeleteSurroundingText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_DeleteSurroundingText_Params.prototype.initDefaults_ = function() {
    this.before = 0;
    this.after = 0;
  };
  FrameWidgetInputHandler_DeleteSurroundingText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_DeleteSurroundingText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_DeleteSurroundingText_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_DeleteSurroundingText_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_DeleteSurroundingText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.before =
        decoder.decodeStruct(codec.Int32);
    val.after =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  FrameWidgetInputHandler_DeleteSurroundingText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_DeleteSurroundingText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.before);
    encoder.encodeStruct(codec.Int32, val.after);
  };
  function FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params.prototype.initDefaults_ = function() {
    this.before = 0;
    this.after = 0;
  };
  FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.before =
        decoder.decodeStruct(codec.Int32);
    val.after =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.before);
    encoder.encodeStruct(codec.Int32, val.after);
  };
  function FrameWidgetInputHandler_SetEditableSelectionOffsets_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_SetEditableSelectionOffsets_Params.prototype.initDefaults_ = function() {
    this.start = 0;
    this.end = 0;
  };
  FrameWidgetInputHandler_SetEditableSelectionOffsets_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_SetEditableSelectionOffsets_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_SetEditableSelectionOffsets_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_SetEditableSelectionOffsets_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_SetEditableSelectionOffsets_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStruct(codec.Int32);
    val.end =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  FrameWidgetInputHandler_SetEditableSelectionOffsets_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_SetEditableSelectionOffsets_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.start);
    encoder.encodeStruct(codec.Int32, val.end);
  };
  function FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.prototype.initDefaults_ = function() {
    this.gestureData = null;
  };
  FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.gestureData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, stylus_writing_gesture$.StylusWritingGestureData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.gestureData =
        decoder.decodeStructPointer(stylus_writing_gesture$.StylusWritingGestureData);
    return val;
  };

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(stylus_writing_gesture$.StylusWritingGestureData, val.gestureData);
  };
  function FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, handwriting_gesture_result$.HandwritingGestureResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(handwriting_gesture_result$.HandwritingGestureResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_ExecuteEditCommand_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_ExecuteEditCommand_Params.prototype.initDefaults_ = function() {
    this.command = null;
    this.value = null;
  };
  FrameWidgetInputHandler_ExecuteEditCommand_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_ExecuteEditCommand_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_ExecuteEditCommand_Params.command
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_ExecuteEditCommand_Params.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_ExecuteEditCommand_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidgetInputHandler_ExecuteEditCommand_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_ExecuteEditCommand_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.command =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  FrameWidgetInputHandler_ExecuteEditCommand_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_ExecuteEditCommand_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.command);
    encoder.encodeStructPointer(string16$.String16, val.value);
  };
  function FrameWidgetInputHandler_Undo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_Undo_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_Undo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_Undo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_Undo_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_Undo_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_Undo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_Undo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_Undo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_Redo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_Redo_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_Redo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_Redo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_Redo_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_Redo_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_Redo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_Redo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_Redo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_Cut_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_Cut_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_Cut_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_Cut_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_Cut_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_Cut_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_Cut_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_Cut_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_Cut_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_Copy_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_Copy_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_Copy_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_Copy_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_Copy_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_Copy_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_Copy_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_Copy_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_Copy_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_CopyToFindPboard_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_CopyToFindPboard_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_CopyToFindPboard_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_CopyToFindPboard_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_CopyToFindPboard_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_CopyToFindPboard_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_CopyToFindPboard_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_CopyToFindPboard_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_CopyToFindPboard_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_CenterSelection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_CenterSelection_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_CenterSelection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_CenterSelection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_CenterSelection_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_CenterSelection_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_CenterSelection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_CenterSelection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_CenterSelection_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_Paste_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_Paste_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_Paste_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_Paste_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_Paste_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_Paste_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_Paste_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_Paste_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_Paste_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_PasteAndMatchStyle_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_PasteAndMatchStyle_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_PasteAndMatchStyle_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_PasteAndMatchStyle_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_PasteAndMatchStyle_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_PasteAndMatchStyle_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_PasteAndMatchStyle_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_PasteAndMatchStyle_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_PasteAndMatchStyle_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_Delete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_Delete_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_Delete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_Delete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_Delete_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_Delete_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_Delete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_Delete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_Delete_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_SelectAll_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_SelectAll_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_SelectAll_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_SelectAll_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_SelectAll_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_SelectAll_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_SelectAll_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_SelectAll_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_SelectAll_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_CollapseSelection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_CollapseSelection_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_CollapseSelection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_CollapseSelection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_CollapseSelection_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_CollapseSelection_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_CollapseSelection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_CollapseSelection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_CollapseSelection_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_CopyWithConfirmation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_CopyWithConfirmation_Params.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  FrameWidgetInputHandler_CopyWithConfirmation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_CopyWithConfirmation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_CopyWithConfirmation_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_CopyWithConfirmation_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_CopyWithConfirmation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidgetInputHandler_CopyWithConfirmation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_CopyWithConfirmation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_PasteWithConfirmation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_PasteWithConfirmation_Params.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  FrameWidgetInputHandler_PasteWithConfirmation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_PasteWithConfirmation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_PasteWithConfirmation_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_PasteWithConfirmation_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_PasteWithConfirmation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidgetInputHandler_PasteWithConfirmation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_PasteWithConfirmation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_Replace_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_Replace_Params.prototype.initDefaults_ = function() {
    this.word = null;
  };
  FrameWidgetInputHandler_Replace_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_Replace_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_Replace_Params.word
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_Replace_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_Replace_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_Replace_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.word =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  FrameWidgetInputHandler_Replace_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_Replace_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.word);
  };
  function FrameWidgetInputHandler_ReplaceMisspelling_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_ReplaceMisspelling_Params.prototype.initDefaults_ = function() {
    this.word = null;
  };
  FrameWidgetInputHandler_ReplaceMisspelling_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_ReplaceMisspelling_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_ReplaceMisspelling_Params.word
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_ReplaceMisspelling_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_ReplaceMisspelling_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_ReplaceMisspelling_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.word =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  FrameWidgetInputHandler_ReplaceMisspelling_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_ReplaceMisspelling_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.word);
  };
  function FrameWidgetInputHandler_SelectRange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_SelectRange_Params.prototype.initDefaults_ = function() {
    this.base = null;
    this.extent = null;
  };
  FrameWidgetInputHandler_SelectRange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_SelectRange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_SelectRange_Params.base
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_SelectRange_Params.extent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_SelectRange_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidgetInputHandler_SelectRange_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_SelectRange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.base =
        decoder.decodeStructPointer(geometry$.Point);
    val.extent =
        decoder.decodeStructPointer(geometry$.Point);
    return val;
  };

  FrameWidgetInputHandler_SelectRange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_SelectRange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Point, val.base);
    encoder.encodeStructPointer(geometry$.Point, val.extent);
  };
  function FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.prototype.initDefaults_ = function() {
    this.start = 0;
    this.end = 0;
    this.behavior = 0;
  };
  FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.behavior
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, selection_menu_behavior$.SelectionMenuBehavior);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStruct(codec.Int32);
    val.end =
        decoder.decodeStruct(codec.Int32);
    val.behavior =
        decoder.decodeStruct(new codec.Enum(selection_menu_behavior$.SelectionMenuBehavior));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.start);
    encoder.encodeStruct(codec.Int32, val.end);
    encoder.encodeStruct(codec.Int32, val.behavior);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_SelectAroundCaret_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_SelectAroundCaret_Params.prototype.initDefaults_ = function() {
    this.granularity = 0;
    this.shouldShowHandle = false;
    this.shouldShowContextMenu = false;
  };
  FrameWidgetInputHandler_SelectAroundCaret_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_SelectAroundCaret_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_SelectAroundCaret_Params.granularity
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SelectionGranularity);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_SelectAroundCaret_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_SelectAroundCaret_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_SelectAroundCaret_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.granularity =
        decoder.decodeStruct(new codec.Enum(SelectionGranularity));
    packed = decoder.readUint8();
    val.shouldShowHandle = (packed >> 0) & 1 ? true : false;
    val.shouldShowContextMenu = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidgetInputHandler_SelectAroundCaret_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_SelectAroundCaret_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.granularity);
    packed = 0;
    packed |= (val.shouldShowHandle & 1) << 0
    packed |= (val.shouldShowContextMenu & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidgetInputHandler_SelectAroundCaret_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SelectAroundCaretResult, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_SelectAroundCaret_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(SelectAroundCaretResult);
    return val;
  };

  FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SelectAroundCaretResult, val.result);
  };
  function FrameWidgetInputHandler_MoveRangeSelectionExtent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.prototype.initDefaults_ = function() {
    this.extent = null;
  };
  FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.extent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_MoveRangeSelectionExtent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extent =
        decoder.decodeStructPointer(geometry$.Point);
    return val;
  };

  FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Point, val.extent);
  };
  function FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams.prototype.initDefaults_ = function() {
  };
  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetInputHandler_MoveCaret_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetInputHandler_MoveCaret_Params.prototype.initDefaults_ = function() {
    this.point = null;
  };
  FrameWidgetInputHandler_MoveCaret_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetInputHandler_MoveCaret_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetInputHandler_MoveCaret_Params.point
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetInputHandler_MoveCaret_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetInputHandler_MoveCaret_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetInputHandler_MoveCaret_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.point =
        decoder.decodeStructPointer(geometry$.Point);
    return val;
  };

  FrameWidgetInputHandler_MoveCaret_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetInputHandler_MoveCaret_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Point, val.point);
  };
  function WidgetInputHandler_SetFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_SetFocus_Params.prototype.initDefaults_ = function() {
    this.state = 0;
  };
  WidgetInputHandler_SetFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_SetFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_SetFocus_Params.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FocusState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_SetFocus_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandler_SetFocus_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_SetFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStruct(new codec.Enum(FocusState));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandler_SetFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_SetFocus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandler_MouseCaptureLost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_MouseCaptureLost_Params.prototype.initDefaults_ = function() {
  };
  WidgetInputHandler_MouseCaptureLost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_MouseCaptureLost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_MouseCaptureLost_Params.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandler_MouseCaptureLost_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_MouseCaptureLost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandler_MouseCaptureLost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_MouseCaptureLost_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.prototype.initDefaults_ = function() {
    this.commands = null;
  };
  WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.commands
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(EditCommand), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.commands =
        decoder.decodeArrayPointer(new codec.PointerTo(EditCommand));
    return val;
  };

  WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(EditCommand), val.commands);
  };
  function WidgetInputHandler_CursorVisibilityChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_CursorVisibilityChanged_Params.prototype.initDefaults_ = function() {
    this.visible = false;
  };
  WidgetInputHandler_CursorVisibilityChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_CursorVisibilityChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WidgetInputHandler_CursorVisibilityChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandler_CursorVisibilityChanged_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_CursorVisibilityChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.visible = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandler_CursorVisibilityChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_CursorVisibilityChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.visible & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandler_ImeSetComposition_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_ImeSetComposition_Params.prototype.initDefaults_ = function() {
    this.text = null;
    this.imeTextSpans = null;
    this.range = null;
    this.start = 0;
    this.end = 0;
  };
  WidgetInputHandler_ImeSetComposition_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_ImeSetComposition_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_ImeSetComposition_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_ImeSetComposition_Params.imeTextSpans
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(ime_types$.ImeTextSpan), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_ImeSetComposition_Params.range
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, range$.Range, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WidgetInputHandler_ImeSetComposition_Params.encodedSize = codec.kStructHeaderSize + 32;

  WidgetInputHandler_ImeSetComposition_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_ImeSetComposition_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    val.imeTextSpans =
        decoder.decodeArrayPointer(new codec.PointerTo(ime_types$.ImeTextSpan));
    val.range =
        decoder.decodeStructPointer(range$.Range);
    val.start =
        decoder.decodeStruct(codec.Int32);
    val.end =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  WidgetInputHandler_ImeSetComposition_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_ImeSetComposition_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.text);
    encoder.encodeArrayPointer(new codec.PointerTo(ime_types$.ImeTextSpan), val.imeTextSpans);
    encoder.encodeStructPointer(range$.Range, val.range);
    encoder.encodeStruct(codec.Int32, val.start);
    encoder.encodeStruct(codec.Int32, val.end);
  };
  function WidgetInputHandler_ImeSetComposition_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_ImeSetComposition_ResponseParams.prototype.initDefaults_ = function() {
  };
  WidgetInputHandler_ImeSetComposition_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_ImeSetComposition_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_ImeSetComposition_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandler_ImeSetComposition_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_ImeSetComposition_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandler_ImeSetComposition_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_ImeSetComposition_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandler_ImeCommitText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_ImeCommitText_Params.prototype.initDefaults_ = function() {
    this.text = null;
    this.imeTextSpans = null;
    this.range = null;
    this.relativeCursorPosition = 0;
  };
  WidgetInputHandler_ImeCommitText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_ImeCommitText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_ImeCommitText_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_ImeCommitText_Params.imeTextSpans
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(ime_types$.ImeTextSpan), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_ImeCommitText_Params.range
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, range$.Range, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WidgetInputHandler_ImeCommitText_Params.encodedSize = codec.kStructHeaderSize + 32;

  WidgetInputHandler_ImeCommitText_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_ImeCommitText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    val.imeTextSpans =
        decoder.decodeArrayPointer(new codec.PointerTo(ime_types$.ImeTextSpan));
    val.range =
        decoder.decodeStructPointer(range$.Range);
    val.relativeCursorPosition =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandler_ImeCommitText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_ImeCommitText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.text);
    encoder.encodeArrayPointer(new codec.PointerTo(ime_types$.ImeTextSpan), val.imeTextSpans);
    encoder.encodeStructPointer(range$.Range, val.range);
    encoder.encodeStruct(codec.Int32, val.relativeCursorPosition);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandler_ImeCommitText_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_ImeCommitText_ResponseParams.prototype.initDefaults_ = function() {
  };
  WidgetInputHandler_ImeCommitText_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_ImeCommitText_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_ImeCommitText_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandler_ImeCommitText_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_ImeCommitText_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandler_ImeCommitText_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_ImeCommitText_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandler_ImeFinishComposingText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_ImeFinishComposingText_Params.prototype.initDefaults_ = function() {
    this.keepSelection = false;
  };
  WidgetInputHandler_ImeFinishComposingText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_ImeFinishComposingText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WidgetInputHandler_ImeFinishComposingText_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandler_ImeFinishComposingText_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_ImeFinishComposingText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.keepSelection = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandler_ImeFinishComposingText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_ImeFinishComposingText_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.keepSelection & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandler_RequestTextInputStateUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_RequestTextInputStateUpdate_Params.prototype.initDefaults_ = function() {
  };
  WidgetInputHandler_RequestTextInputStateUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_RequestTextInputStateUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_RequestTextInputStateUpdate_Params.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandler_RequestTextInputStateUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_RequestTextInputStateUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandler_RequestTextInputStateUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_RequestTextInputStateUpdate_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandler_RequestCompositionUpdates_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_RequestCompositionUpdates_Params.prototype.initDefaults_ = function() {
    this.immediateRequest = false;
    this.monitorRequest = false;
  };
  WidgetInputHandler_RequestCompositionUpdates_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_RequestCompositionUpdates_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WidgetInputHandler_RequestCompositionUpdates_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandler_RequestCompositionUpdates_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_RequestCompositionUpdates_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.immediateRequest = (packed >> 0) & 1 ? true : false;
    val.monitorRequest = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandler_RequestCompositionUpdates_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_RequestCompositionUpdates_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.immediateRequest & 1) << 0
    packed |= (val.monitorRequest & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandler_DispatchEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_DispatchEvent_Params.prototype.initDefaults_ = function() {
    this.event = null;
    this.originalEventForGesture = null;
  };
  WidgetInputHandler_DispatchEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_DispatchEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_DispatchEvent_Params.event
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, Event, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_DispatchEvent_Params.originalEventForGesture
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, Event, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_DispatchEvent_Params.encodedSize = codec.kStructHeaderSize + 16;

  WidgetInputHandler_DispatchEvent_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_DispatchEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStructPointer(Event);
    val.originalEventForGesture =
        decoder.decodeStructPointer(Event);
    return val;
  };

  WidgetInputHandler_DispatchEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_DispatchEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(Event, val.event);
    encoder.encodeStructPointer(Event, val.originalEventForGesture);
  };
  function WidgetInputHandler_DispatchEvent_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_DispatchEvent_ResponseParams.prototype.initDefaults_ = function() {
    this.source = 0;
    this.state = 0;
    this.updatedLatency = null;
    this.overscroll = null;
    this.touchAction = null;
  };
  WidgetInputHandler_DispatchEvent_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_DispatchEvent_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_DispatchEvent_ResponseParams.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, input_event_result$.InputEventResultSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_DispatchEvent_ResponseParams.updatedLatency
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, latency_info$.LatencyInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_DispatchEvent_ResponseParams.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, input_event_result$.InputEventResultState);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_DispatchEvent_ResponseParams.overscroll
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, DidOverscrollParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_DispatchEvent_ResponseParams.touchAction
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, TouchActionOptional, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_DispatchEvent_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  WidgetInputHandler_DispatchEvent_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_DispatchEvent_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.source =
        decoder.decodeStruct(new codec.Enum(input_event_result$.InputEventResultSource));
    val.state =
        decoder.decodeStruct(new codec.Enum(input_event_result$.InputEventResultState));
    val.updatedLatency =
        decoder.decodeStructPointer(latency_info$.LatencyInfo);
    val.overscroll =
        decoder.decodeStructPointer(DidOverscrollParams);
    val.touchAction =
        decoder.decodeStructPointer(TouchActionOptional);
    return val;
  };

  WidgetInputHandler_DispatchEvent_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_DispatchEvent_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.encodeStructPointer(latency_info$.LatencyInfo, val.updatedLatency);
    encoder.encodeStructPointer(DidOverscrollParams, val.overscroll);
    encoder.encodeStructPointer(TouchActionOptional, val.touchAction);
  };
  function WidgetInputHandler_DispatchNonBlockingEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_DispatchNonBlockingEvent_Params.prototype.initDefaults_ = function() {
    this.event = null;
  };
  WidgetInputHandler_DispatchNonBlockingEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_DispatchNonBlockingEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_DispatchNonBlockingEvent_Params.event
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, Event, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_DispatchNonBlockingEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandler_DispatchNonBlockingEvent_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_DispatchNonBlockingEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStructPointer(Event);
    return val;
  };

  WidgetInputHandler_DispatchNonBlockingEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_DispatchNonBlockingEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(Event, val.event);
  };
  function WidgetInputHandler_WaitForInputProcessed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_WaitForInputProcessed_Params.prototype.initDefaults_ = function() {
  };
  WidgetInputHandler_WaitForInputProcessed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_WaitForInputProcessed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_WaitForInputProcessed_Params.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandler_WaitForInputProcessed_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_WaitForInputProcessed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandler_WaitForInputProcessed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_WaitForInputProcessed_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandler_WaitForInputProcessed_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_WaitForInputProcessed_ResponseParams.prototype.initDefaults_ = function() {
  };
  WidgetInputHandler_WaitForInputProcessed_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_WaitForInputProcessed_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_WaitForInputProcessed_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandler_WaitForInputProcessed_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_WaitForInputProcessed_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandler_WaitForInputProcessed_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_WaitForInputProcessed_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandler_PingMainThread_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_PingMainThread_Params.prototype.initDefaults_ = function() {
  };
  WidgetInputHandler_PingMainThread_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_PingMainThread_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_PingMainThread_Params.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandler_PingMainThread_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_PingMainThread_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandler_PingMainThread_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_PingMainThread_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandler_PingMainThread_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_PingMainThread_ResponseParams.prototype.initDefaults_ = function() {
  };
  WidgetInputHandler_PingMainThread_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_PingMainThread_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_PingMainThread_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  WidgetInputHandler_PingMainThread_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_PingMainThread_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetInputHandler_PingMainThread_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_PingMainThread_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetInputHandler_GetFrameWidgetInputHandler_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_GetFrameWidgetInputHandler_Params.prototype.initDefaults_ = function() {
    this.interfaceRequest = new associatedBindings.AssociatedInterfaceRequest();
  };
  WidgetInputHandler_GetFrameWidgetInputHandler_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_GetFrameWidgetInputHandler_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_GetFrameWidgetInputHandler_Params.interfaceRequest
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_GetFrameWidgetInputHandler_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetInputHandler_GetFrameWidgetInputHandler_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_GetFrameWidgetInputHandler_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.interfaceRequest =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetInputHandler_GetFrameWidgetInputHandler_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_GetFrameWidgetInputHandler_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.interfaceRequest);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetInputHandler_UpdateBrowserControlsState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetInputHandler_UpdateBrowserControlsState_Params.prototype.initDefaults_ = function() {
    this.constraints = 0;
    this.current = 0;
    this.animate = false;
    this.offsetTagModifications = null;
  };
  WidgetInputHandler_UpdateBrowserControlsState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetInputHandler_UpdateBrowserControlsState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_UpdateBrowserControlsState_Params.constraints
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, browser_controls_state$.BrowserControlsState);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetInputHandler_UpdateBrowserControlsState_Params.current
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, browser_controls_state$.BrowserControlsState);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WidgetInputHandler_UpdateBrowserControlsState_Params.offsetTagModifications
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, browser_controls_offset_tag_modifications$.BrowserControlsOffsetTagModifications, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetInputHandler_UpdateBrowserControlsState_Params.encodedSize = codec.kStructHeaderSize + 24;

  WidgetInputHandler_UpdateBrowserControlsState_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetInputHandler_UpdateBrowserControlsState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.constraints =
        decoder.decodeStruct(new codec.Enum(browser_controls_state$.BrowserControlsState));
    val.current =
        decoder.decodeStruct(new codec.Enum(browser_controls_state$.BrowserControlsState));
    packed = decoder.readUint8();
    val.animate = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.offsetTagModifications =
        decoder.decodeStructPointer(browser_controls_offset_tag_modifications$.BrowserControlsOffsetTagModifications);
    return val;
  };

  WidgetInputHandler_UpdateBrowserControlsState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetInputHandler_UpdateBrowserControlsState_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.constraints);
    encoder.encodeStruct(codec.Int32, val.current);
    packed = 0;
    packed |= (val.animate & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(browser_controls_offset_tag_modifications$.BrowserControlsOffsetTagModifications, val.offsetTagModifications);
  };
  var kWidgetInputHandlerHost_SetTouchActionFromMain_Name = 0;
  var kWidgetInputHandlerHost_SetPanAction_Name = 1;
  var kWidgetInputHandlerHost_DidOverscroll_Name = 2;
  var kWidgetInputHandlerHost_DidStartScrollingViewport_Name = 3;
  var kWidgetInputHandlerHost_ImeCancelComposition_Name = 4;
  var kWidgetInputHandlerHost_ImeCompositionRangeChanged_Name = 5;
  var kWidgetInputHandlerHost_SetMouseCapture_Name = 6;
  var kWidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Name = 7;
  var kWidgetInputHandlerHost_RequestMouseLock_Name = 8;

  function WidgetInputHandlerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WidgetInputHandlerHost,
                                                   handleOrPtrInfo);
  }

  function WidgetInputHandlerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WidgetInputHandlerHost, associatedInterfacePtrInfo);
  }

  WidgetInputHandlerHostAssociatedPtr.prototype =
      Object.create(WidgetInputHandlerHostPtr.prototype);
  WidgetInputHandlerHostAssociatedPtr.prototype.constructor =
      WidgetInputHandlerHostAssociatedPtr;

  function WidgetInputHandlerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  WidgetInputHandlerHostPtr.prototype.setTouchActionFromMain = function() {
    return WidgetInputHandlerHostProxy.prototype.setTouchActionFromMain
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.setTouchActionFromMain = function(touchAction) {
    var params_ = new WidgetInputHandlerHost_SetTouchActionFromMain_Params();
    params_.touchAction = touchAction;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandlerHost_SetTouchActionFromMain_Name,
        codec.align(WidgetInputHandlerHost_SetTouchActionFromMain_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandlerHost_SetTouchActionFromMain_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerHostPtr.prototype.setPanAction = function() {
    return WidgetInputHandlerHostProxy.prototype.setPanAction
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.setPanAction = function(panAction) {
    var params_ = new WidgetInputHandlerHost_SetPanAction_Params();
    params_.panAction = panAction;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandlerHost_SetPanAction_Name,
        codec.align(WidgetInputHandlerHost_SetPanAction_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandlerHost_SetPanAction_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerHostPtr.prototype.didOverscroll = function() {
    return WidgetInputHandlerHostProxy.prototype.didOverscroll
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.didOverscroll = function(params) {
    var params_ = new WidgetInputHandlerHost_DidOverscroll_Params();
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandlerHost_DidOverscroll_Name,
        codec.align(WidgetInputHandlerHost_DidOverscroll_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandlerHost_DidOverscroll_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerHostPtr.prototype.didStartScrollingViewport = function() {
    return WidgetInputHandlerHostProxy.prototype.didStartScrollingViewport
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.didStartScrollingViewport = function() {
    var params_ = new WidgetInputHandlerHost_DidStartScrollingViewport_Params();
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandlerHost_DidStartScrollingViewport_Name,
        codec.align(WidgetInputHandlerHost_DidStartScrollingViewport_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandlerHost_DidStartScrollingViewport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerHostPtr.prototype.imeCancelComposition = function() {
    return WidgetInputHandlerHostProxy.prototype.imeCancelComposition
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.imeCancelComposition = function() {
    var params_ = new WidgetInputHandlerHost_ImeCancelComposition_Params();
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandlerHost_ImeCancelComposition_Name,
        codec.align(WidgetInputHandlerHost_ImeCancelComposition_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandlerHost_ImeCancelComposition_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerHostPtr.prototype.imeCompositionRangeChanged = function() {
    return WidgetInputHandlerHostProxy.prototype.imeCompositionRangeChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.imeCompositionRangeChanged = function(range, characterBounds) {
    var params_ = new WidgetInputHandlerHost_ImeCompositionRangeChanged_Params();
    params_.range = range;
    params_.characterBounds = characterBounds;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandlerHost_ImeCompositionRangeChanged_Name,
        codec.align(WidgetInputHandlerHost_ImeCompositionRangeChanged_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandlerHost_ImeCompositionRangeChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerHostPtr.prototype.setMouseCapture = function() {
    return WidgetInputHandlerHostProxy.prototype.setMouseCapture
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.setMouseCapture = function(capture) {
    var params_ = new WidgetInputHandlerHost_SetMouseCapture_Params();
    params_.capture = capture;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandlerHost_SetMouseCapture_Name,
        codec.align(WidgetInputHandlerHost_SetMouseCapture_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandlerHost_SetMouseCapture_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerHostPtr.prototype.setAutoscrollSelectionActiveInMainFrame = function() {
    return WidgetInputHandlerHostProxy.prototype.setAutoscrollSelectionActiveInMainFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.setAutoscrollSelectionActiveInMainFrame = function(autoscrollSelection) {
    var params_ = new WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params();
    params_.autoscrollSelection = autoscrollSelection;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Name,
        codec.align(WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerHostPtr.prototype.requestMouseLock = function() {
    return WidgetInputHandlerHostProxy.prototype.requestMouseLock
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerHostProxy.prototype.requestMouseLock = function(fromUserGesture, unadjustedMovement) {
    var params_ = new WidgetInputHandlerHost_RequestMouseLock_Params();
    params_.fromUserGesture = fromUserGesture;
    params_.unadjustedMovement = unadjustedMovement;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidgetInputHandlerHost_RequestMouseLock_Name,
          codec.align(WidgetInputHandlerHost_RequestMouseLock_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WidgetInputHandlerHost_RequestMouseLock_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WidgetInputHandlerHost_RequestMouseLock_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function WidgetInputHandlerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  WidgetInputHandlerHostStub.prototype.setTouchActionFromMain = function(touchAction) {
    return this.delegate_ && this.delegate_.setTouchActionFromMain && this.delegate_.setTouchActionFromMain(touchAction);
  }
  WidgetInputHandlerHostStub.prototype.setPanAction = function(panAction) {
    return this.delegate_ && this.delegate_.setPanAction && this.delegate_.setPanAction(panAction);
  }
  WidgetInputHandlerHostStub.prototype.didOverscroll = function(params) {
    return this.delegate_ && this.delegate_.didOverscroll && this.delegate_.didOverscroll(params);
  }
  WidgetInputHandlerHostStub.prototype.didStartScrollingViewport = function() {
    return this.delegate_ && this.delegate_.didStartScrollingViewport && this.delegate_.didStartScrollingViewport();
  }
  WidgetInputHandlerHostStub.prototype.imeCancelComposition = function() {
    return this.delegate_ && this.delegate_.imeCancelComposition && this.delegate_.imeCancelComposition();
  }
  WidgetInputHandlerHostStub.prototype.imeCompositionRangeChanged = function(range, characterBounds) {
    return this.delegate_ && this.delegate_.imeCompositionRangeChanged && this.delegate_.imeCompositionRangeChanged(range, characterBounds);
  }
  WidgetInputHandlerHostStub.prototype.setMouseCapture = function(capture) {
    return this.delegate_ && this.delegate_.setMouseCapture && this.delegate_.setMouseCapture(capture);
  }
  WidgetInputHandlerHostStub.prototype.setAutoscrollSelectionActiveInMainFrame = function(autoscrollSelection) {
    return this.delegate_ && this.delegate_.setAutoscrollSelectionActiveInMainFrame && this.delegate_.setAutoscrollSelectionActiveInMainFrame(autoscrollSelection);
  }
  WidgetInputHandlerHostStub.prototype.requestMouseLock = function(fromUserGesture, unadjustedMovement) {
    return this.delegate_ && this.delegate_.requestMouseLock && this.delegate_.requestMouseLock(fromUserGesture, unadjustedMovement);
  }

  WidgetInputHandlerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWidgetInputHandlerHost_SetTouchActionFromMain_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_SetTouchActionFromMain_Params);
      this.setTouchActionFromMain(params.touchAction);
      return true;
    case kWidgetInputHandlerHost_SetPanAction_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_SetPanAction_Params);
      this.setPanAction(params.panAction);
      return true;
    case kWidgetInputHandlerHost_DidOverscroll_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_DidOverscroll_Params);
      this.didOverscroll(params.params);
      return true;
    case kWidgetInputHandlerHost_DidStartScrollingViewport_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_DidStartScrollingViewport_Params);
      this.didStartScrollingViewport();
      return true;
    case kWidgetInputHandlerHost_ImeCancelComposition_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_ImeCancelComposition_Params);
      this.imeCancelComposition();
      return true;
    case kWidgetInputHandlerHost_ImeCompositionRangeChanged_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_ImeCompositionRangeChanged_Params);
      this.imeCompositionRangeChanged(params.range, params.characterBounds);
      return true;
    case kWidgetInputHandlerHost_SetMouseCapture_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_SetMouseCapture_Params);
      this.setMouseCapture(params.capture);
      return true;
    case kWidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params);
      this.setAutoscrollSelectionActiveInMainFrame(params.autoscrollSelection);
      return true;
    default:
      return false;
    }
  };

  WidgetInputHandlerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWidgetInputHandlerHost_RequestMouseLock_Name:
      var params = reader.decodeStruct(WidgetInputHandlerHost_RequestMouseLock_Params);
      this.requestMouseLock(params.fromUserGesture, params.unadjustedMovement).then(function(response) {
        var responseParams =
            new WidgetInputHandlerHost_RequestMouseLock_ResponseParams();
        responseParams.result = response.result;
        responseParams.context = response.context;
        var builder = new codec.MessageV1Builder(
            kWidgetInputHandlerHost_RequestMouseLock_Name,
            codec.align(WidgetInputHandlerHost_RequestMouseLock_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WidgetInputHandlerHost_RequestMouseLock_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWidgetInputHandlerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWidgetInputHandlerHost_SetTouchActionFromMain_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandlerHost_SetTouchActionFromMain_Params;
      break;
      case kWidgetInputHandlerHost_SetPanAction_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandlerHost_SetPanAction_Params;
      break;
      case kWidgetInputHandlerHost_DidOverscroll_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandlerHost_DidOverscroll_Params;
      break;
      case kWidgetInputHandlerHost_DidStartScrollingViewport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandlerHost_DidStartScrollingViewport_Params;
      break;
      case kWidgetInputHandlerHost_ImeCancelComposition_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandlerHost_ImeCancelComposition_Params;
      break;
      case kWidgetInputHandlerHost_ImeCompositionRangeChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandlerHost_ImeCompositionRangeChanged_Params;
      break;
      case kWidgetInputHandlerHost_SetMouseCapture_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandlerHost_SetMouseCapture_Params;
      break;
      case kWidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params;
      break;
      case kWidgetInputHandlerHost_RequestMouseLock_Name:
        if (message.expectsResponse())
          paramsClass = WidgetInputHandlerHost_RequestMouseLock_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWidgetInputHandlerHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWidgetInputHandlerHost_RequestMouseLock_Name:
        if (message.isResponse())
          paramsClass = WidgetInputHandlerHost_RequestMouseLock_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WidgetInputHandlerHost = {
    name: 'blink.mojom.WidgetInputHandlerHost',
    kVersion: 0,
    ptrClass: WidgetInputHandlerHostPtr,
    proxyClass: WidgetInputHandlerHostProxy,
    stubClass: WidgetInputHandlerHostStub,
    validateRequest: validateWidgetInputHandlerHostRequest,
    validateResponse: validateWidgetInputHandlerHostResponse,
  };
  WidgetInputHandlerHostStub.prototype.validator = validateWidgetInputHandlerHostRequest;
  WidgetInputHandlerHostProxy.prototype.validator = validateWidgetInputHandlerHostResponse;
  var kFrameWidgetInputHandler_AddImeTextSpansToExistingText_Name = 0;
  var kFrameWidgetInputHandler_ClearImeTextSpansByType_Name = 1;
  var kFrameWidgetInputHandler_SetCompositionFromExistingText_Name = 2;
  var kFrameWidgetInputHandler_ExtendSelectionAndDelete_Name = 3;
  var kFrameWidgetInputHandler_ExtendSelectionAndReplace_Name = 4;
  var kFrameWidgetInputHandler_DeleteSurroundingText_Name = 5;
  var kFrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Name = 6;
  var kFrameWidgetInputHandler_SetEditableSelectionOffsets_Name = 7;
  var kFrameWidgetInputHandler_HandleStylusWritingGestureAction_Name = 8;
  var kFrameWidgetInputHandler_ExecuteEditCommand_Name = 9;
  var kFrameWidgetInputHandler_Undo_Name = 10;
  var kFrameWidgetInputHandler_Redo_Name = 11;
  var kFrameWidgetInputHandler_Cut_Name = 12;
  var kFrameWidgetInputHandler_Copy_Name = 13;
  var kFrameWidgetInputHandler_CopyToFindPboard_Name = 14;
  var kFrameWidgetInputHandler_CenterSelection_Name = 15;
  var kFrameWidgetInputHandler_Paste_Name = 16;
  var kFrameWidgetInputHandler_PasteAndMatchStyle_Name = 17;
  var kFrameWidgetInputHandler_Delete_Name = 18;
  var kFrameWidgetInputHandler_SelectAll_Name = 19;
  var kFrameWidgetInputHandler_CollapseSelection_Name = 20;
  var kFrameWidgetInputHandler_CopyWithConfirmation_Name = 21;
  var kFrameWidgetInputHandler_PasteWithConfirmation_Name = 22;
  var kFrameWidgetInputHandler_Replace_Name = 23;
  var kFrameWidgetInputHandler_ReplaceMisspelling_Name = 24;
  var kFrameWidgetInputHandler_SelectRange_Name = 25;
  var kFrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Name = 26;
  var kFrameWidgetInputHandler_SelectAroundCaret_Name = 27;
  var kFrameWidgetInputHandler_MoveRangeSelectionExtent_Name = 28;
  var kFrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Name = 29;
  var kFrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Name = 30;
  var kFrameWidgetInputHandler_MoveCaret_Name = 31;

  function FrameWidgetInputHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FrameWidgetInputHandler,
                                                   handleOrPtrInfo);
  }

  function FrameWidgetInputHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FrameWidgetInputHandler, associatedInterfacePtrInfo);
  }

  FrameWidgetInputHandlerAssociatedPtr.prototype =
      Object.create(FrameWidgetInputHandlerPtr.prototype);
  FrameWidgetInputHandlerAssociatedPtr.prototype.constructor =
      FrameWidgetInputHandlerAssociatedPtr;

  function FrameWidgetInputHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  FrameWidgetInputHandlerPtr.prototype.addImeTextSpansToExistingText = function() {
    return FrameWidgetInputHandlerProxy.prototype.addImeTextSpansToExistingText
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.addImeTextSpansToExistingText = function(start, end, imeTextSpans) {
    var params_ = new FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params();
    params_.start = start;
    params_.end = end;
    params_.imeTextSpans = imeTextSpans;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_AddImeTextSpansToExistingText_Name,
        codec.align(FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.clearImeTextSpansByType = function() {
    return FrameWidgetInputHandlerProxy.prototype.clearImeTextSpansByType
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.clearImeTextSpansByType = function(start, end, type) {
    var params_ = new FrameWidgetInputHandler_ClearImeTextSpansByType_Params();
    params_.start = start;
    params_.end = end;
    params_.type = type;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_ClearImeTextSpansByType_Name,
        codec.align(FrameWidgetInputHandler_ClearImeTextSpansByType_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_ClearImeTextSpansByType_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.setCompositionFromExistingText = function() {
    return FrameWidgetInputHandlerProxy.prototype.setCompositionFromExistingText
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.setCompositionFromExistingText = function(start, end, imeTextSpans) {
    var params_ = new FrameWidgetInputHandler_SetCompositionFromExistingText_Params();
    params_.start = start;
    params_.end = end;
    params_.imeTextSpans = imeTextSpans;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_SetCompositionFromExistingText_Name,
        codec.align(FrameWidgetInputHandler_SetCompositionFromExistingText_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_SetCompositionFromExistingText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.extendSelectionAndDelete = function() {
    return FrameWidgetInputHandlerProxy.prototype.extendSelectionAndDelete
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.extendSelectionAndDelete = function(before, after) {
    var params_ = new FrameWidgetInputHandler_ExtendSelectionAndDelete_Params();
    params_.before = before;
    params_.after = after;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_ExtendSelectionAndDelete_Name,
        codec.align(FrameWidgetInputHandler_ExtendSelectionAndDelete_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_ExtendSelectionAndDelete_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.extendSelectionAndReplace = function() {
    return FrameWidgetInputHandlerProxy.prototype.extendSelectionAndReplace
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.extendSelectionAndReplace = function(before, after, replacementText) {
    var params_ = new FrameWidgetInputHandler_ExtendSelectionAndReplace_Params();
    params_.before = before;
    params_.after = after;
    params_.replacementText = replacementText;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_ExtendSelectionAndReplace_Name,
        codec.align(FrameWidgetInputHandler_ExtendSelectionAndReplace_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_ExtendSelectionAndReplace_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.deleteSurroundingText = function() {
    return FrameWidgetInputHandlerProxy.prototype.deleteSurroundingText
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.deleteSurroundingText = function(before, after) {
    var params_ = new FrameWidgetInputHandler_DeleteSurroundingText_Params();
    params_.before = before;
    params_.after = after;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_DeleteSurroundingText_Name,
        codec.align(FrameWidgetInputHandler_DeleteSurroundingText_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_DeleteSurroundingText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.deleteSurroundingTextInCodePoints = function() {
    return FrameWidgetInputHandlerProxy.prototype.deleteSurroundingTextInCodePoints
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.deleteSurroundingTextInCodePoints = function(before, after) {
    var params_ = new FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params();
    params_.before = before;
    params_.after = after;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Name,
        codec.align(FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.setEditableSelectionOffsets = function() {
    return FrameWidgetInputHandlerProxy.prototype.setEditableSelectionOffsets
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.setEditableSelectionOffsets = function(start, end) {
    var params_ = new FrameWidgetInputHandler_SetEditableSelectionOffsets_Params();
    params_.start = start;
    params_.end = end;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_SetEditableSelectionOffsets_Name,
        codec.align(FrameWidgetInputHandler_SetEditableSelectionOffsets_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_SetEditableSelectionOffsets_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.handleStylusWritingGestureAction = function() {
    return FrameWidgetInputHandlerProxy.prototype.handleStylusWritingGestureAction
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.handleStylusWritingGestureAction = function(gestureData) {
    var params_ = new FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params();
    params_.gestureData = gestureData;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidgetInputHandler_HandleStylusWritingGestureAction_Name,
          codec.align(FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetInputHandlerPtr.prototype.executeEditCommand = function() {
    return FrameWidgetInputHandlerProxy.prototype.executeEditCommand
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.executeEditCommand = function(command, value) {
    var params_ = new FrameWidgetInputHandler_ExecuteEditCommand_Params();
    params_.command = command;
    params_.value = value;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_ExecuteEditCommand_Name,
        codec.align(FrameWidgetInputHandler_ExecuteEditCommand_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_ExecuteEditCommand_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.undo = function() {
    return FrameWidgetInputHandlerProxy.prototype.undo
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.undo = function() {
    var params_ = new FrameWidgetInputHandler_Undo_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_Undo_Name,
        codec.align(FrameWidgetInputHandler_Undo_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_Undo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.redo = function() {
    return FrameWidgetInputHandlerProxy.prototype.redo
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.redo = function() {
    var params_ = new FrameWidgetInputHandler_Redo_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_Redo_Name,
        codec.align(FrameWidgetInputHandler_Redo_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_Redo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.cut = function() {
    return FrameWidgetInputHandlerProxy.prototype.cut
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.cut = function() {
    var params_ = new FrameWidgetInputHandler_Cut_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_Cut_Name,
        codec.align(FrameWidgetInputHandler_Cut_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_Cut_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.copy = function() {
    return FrameWidgetInputHandlerProxy.prototype.copy
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.copy = function() {
    var params_ = new FrameWidgetInputHandler_Copy_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_Copy_Name,
        codec.align(FrameWidgetInputHandler_Copy_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_Copy_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.copyToFindPboard = function() {
    return FrameWidgetInputHandlerProxy.prototype.copyToFindPboard
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.copyToFindPboard = function() {
    var params_ = new FrameWidgetInputHandler_CopyToFindPboard_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_CopyToFindPboard_Name,
        codec.align(FrameWidgetInputHandler_CopyToFindPboard_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_CopyToFindPboard_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.centerSelection = function() {
    return FrameWidgetInputHandlerProxy.prototype.centerSelection
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.centerSelection = function() {
    var params_ = new FrameWidgetInputHandler_CenterSelection_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_CenterSelection_Name,
        codec.align(FrameWidgetInputHandler_CenterSelection_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_CenterSelection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.paste = function() {
    return FrameWidgetInputHandlerProxy.prototype.paste
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.paste = function() {
    var params_ = new FrameWidgetInputHandler_Paste_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_Paste_Name,
        codec.align(FrameWidgetInputHandler_Paste_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_Paste_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.pasteAndMatchStyle = function() {
    return FrameWidgetInputHandlerProxy.prototype.pasteAndMatchStyle
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.pasteAndMatchStyle = function() {
    var params_ = new FrameWidgetInputHandler_PasteAndMatchStyle_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_PasteAndMatchStyle_Name,
        codec.align(FrameWidgetInputHandler_PasteAndMatchStyle_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_PasteAndMatchStyle_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.delete = function() {
    return FrameWidgetInputHandlerProxy.prototype.delete
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.delete = function() {
    var params_ = new FrameWidgetInputHandler_Delete_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_Delete_Name,
        codec.align(FrameWidgetInputHandler_Delete_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_Delete_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.selectAll = function() {
    return FrameWidgetInputHandlerProxy.prototype.selectAll
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.selectAll = function() {
    var params_ = new FrameWidgetInputHandler_SelectAll_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_SelectAll_Name,
        codec.align(FrameWidgetInputHandler_SelectAll_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_SelectAll_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.collapseSelection = function() {
    return FrameWidgetInputHandlerProxy.prototype.collapseSelection
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.collapseSelection = function() {
    var params_ = new FrameWidgetInputHandler_CollapseSelection_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_CollapseSelection_Name,
        codec.align(FrameWidgetInputHandler_CollapseSelection_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_CollapseSelection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.copyWithConfirmation = function() {
    return FrameWidgetInputHandlerProxy.prototype.copyWithConfirmation
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.copyWithConfirmation = function(token) {
    var params_ = new FrameWidgetInputHandler_CopyWithConfirmation_Params();
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidgetInputHandler_CopyWithConfirmation_Name,
          codec.align(FrameWidgetInputHandler_CopyWithConfirmation_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidgetInputHandler_CopyWithConfirmation_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetInputHandlerPtr.prototype.pasteWithConfirmation = function() {
    return FrameWidgetInputHandlerProxy.prototype.pasteWithConfirmation
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.pasteWithConfirmation = function(token) {
    var params_ = new FrameWidgetInputHandler_PasteWithConfirmation_Params();
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidgetInputHandler_PasteWithConfirmation_Name,
          codec.align(FrameWidgetInputHandler_PasteWithConfirmation_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidgetInputHandler_PasteWithConfirmation_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetInputHandlerPtr.prototype.replace = function() {
    return FrameWidgetInputHandlerProxy.prototype.replace
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.replace = function(word) {
    var params_ = new FrameWidgetInputHandler_Replace_Params();
    params_.word = word;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_Replace_Name,
        codec.align(FrameWidgetInputHandler_Replace_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_Replace_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.replaceMisspelling = function() {
    return FrameWidgetInputHandlerProxy.prototype.replaceMisspelling
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.replaceMisspelling = function(word) {
    var params_ = new FrameWidgetInputHandler_ReplaceMisspelling_Params();
    params_.word = word;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_ReplaceMisspelling_Name,
        codec.align(FrameWidgetInputHandler_ReplaceMisspelling_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_ReplaceMisspelling_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.selectRange = function() {
    return FrameWidgetInputHandlerProxy.prototype.selectRange
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.selectRange = function(base, extent) {
    var params_ = new FrameWidgetInputHandler_SelectRange_Params();
    params_.base = base;
    params_.extent = extent;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_SelectRange_Name,
        codec.align(FrameWidgetInputHandler_SelectRange_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_SelectRange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.adjustSelectionByCharacterOffset = function() {
    return FrameWidgetInputHandlerProxy.prototype.adjustSelectionByCharacterOffset
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.adjustSelectionByCharacterOffset = function(start, end, behavior) {
    var params_ = new FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params();
    params_.start = start;
    params_.end = end;
    params_.behavior = behavior;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Name,
        codec.align(FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.selectAroundCaret = function() {
    return FrameWidgetInputHandlerProxy.prototype.selectAroundCaret
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.selectAroundCaret = function(granularity, shouldShowHandle, shouldShowContextMenu) {
    var params_ = new FrameWidgetInputHandler_SelectAroundCaret_Params();
    params_.granularity = granularity;
    params_.shouldShowHandle = shouldShowHandle;
    params_.shouldShowContextMenu = shouldShowContextMenu;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidgetInputHandler_SelectAroundCaret_Name,
          codec.align(FrameWidgetInputHandler_SelectAroundCaret_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidgetInputHandler_SelectAroundCaret_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidgetInputHandler_SelectAroundCaret_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetInputHandlerPtr.prototype.moveRangeSelectionExtent = function() {
    return FrameWidgetInputHandlerProxy.prototype.moveRangeSelectionExtent
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.moveRangeSelectionExtent = function(extent) {
    var params_ = new FrameWidgetInputHandler_MoveRangeSelectionExtent_Params();
    params_.extent = extent;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_MoveRangeSelectionExtent_Name,
        codec.align(FrameWidgetInputHandler_MoveRangeSelectionExtent_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_MoveRangeSelectionExtent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.scrollFocusedEditableNodeIntoView = function() {
    return FrameWidgetInputHandlerProxy.prototype.scrollFocusedEditableNodeIntoView
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.scrollFocusedEditableNodeIntoView = function() {
    var params_ = new FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Name,
        codec.align(FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetInputHandlerPtr.prototype.waitForPageScaleAnimationForTesting = function() {
    return FrameWidgetInputHandlerProxy.prototype.waitForPageScaleAnimationForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.waitForPageScaleAnimationForTesting = function() {
    var params_ = new FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Name,
          codec.align(FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetInputHandlerPtr.prototype.moveCaret = function() {
    return FrameWidgetInputHandlerProxy.prototype.moveCaret
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetInputHandlerProxy.prototype.moveCaret = function(point) {
    var params_ = new FrameWidgetInputHandler_MoveCaret_Params();
    params_.point = point;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetInputHandler_MoveCaret_Name,
        codec.align(FrameWidgetInputHandler_MoveCaret_Params.encodedSize));
    builder.encodeStruct(FrameWidgetInputHandler_MoveCaret_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FrameWidgetInputHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  FrameWidgetInputHandlerStub.prototype.addImeTextSpansToExistingText = function(start, end, imeTextSpans) {
    return this.delegate_ && this.delegate_.addImeTextSpansToExistingText && this.delegate_.addImeTextSpansToExistingText(start, end, imeTextSpans);
  }
  FrameWidgetInputHandlerStub.prototype.clearImeTextSpansByType = function(start, end, type) {
    return this.delegate_ && this.delegate_.clearImeTextSpansByType && this.delegate_.clearImeTextSpansByType(start, end, type);
  }
  FrameWidgetInputHandlerStub.prototype.setCompositionFromExistingText = function(start, end, imeTextSpans) {
    return this.delegate_ && this.delegate_.setCompositionFromExistingText && this.delegate_.setCompositionFromExistingText(start, end, imeTextSpans);
  }
  FrameWidgetInputHandlerStub.prototype.extendSelectionAndDelete = function(before, after) {
    return this.delegate_ && this.delegate_.extendSelectionAndDelete && this.delegate_.extendSelectionAndDelete(before, after);
  }
  FrameWidgetInputHandlerStub.prototype.extendSelectionAndReplace = function(before, after, replacementText) {
    return this.delegate_ && this.delegate_.extendSelectionAndReplace && this.delegate_.extendSelectionAndReplace(before, after, replacementText);
  }
  FrameWidgetInputHandlerStub.prototype.deleteSurroundingText = function(before, after) {
    return this.delegate_ && this.delegate_.deleteSurroundingText && this.delegate_.deleteSurroundingText(before, after);
  }
  FrameWidgetInputHandlerStub.prototype.deleteSurroundingTextInCodePoints = function(before, after) {
    return this.delegate_ && this.delegate_.deleteSurroundingTextInCodePoints && this.delegate_.deleteSurroundingTextInCodePoints(before, after);
  }
  FrameWidgetInputHandlerStub.prototype.setEditableSelectionOffsets = function(start, end) {
    return this.delegate_ && this.delegate_.setEditableSelectionOffsets && this.delegate_.setEditableSelectionOffsets(start, end);
  }
  FrameWidgetInputHandlerStub.prototype.handleStylusWritingGestureAction = function(gestureData) {
    return this.delegate_ && this.delegate_.handleStylusWritingGestureAction && this.delegate_.handleStylusWritingGestureAction(gestureData);
  }
  FrameWidgetInputHandlerStub.prototype.executeEditCommand = function(command, value) {
    return this.delegate_ && this.delegate_.executeEditCommand && this.delegate_.executeEditCommand(command, value);
  }
  FrameWidgetInputHandlerStub.prototype.undo = function() {
    return this.delegate_ && this.delegate_.undo && this.delegate_.undo();
  }
  FrameWidgetInputHandlerStub.prototype.redo = function() {
    return this.delegate_ && this.delegate_.redo && this.delegate_.redo();
  }
  FrameWidgetInputHandlerStub.prototype.cut = function() {
    return this.delegate_ && this.delegate_.cut && this.delegate_.cut();
  }
  FrameWidgetInputHandlerStub.prototype.copy = function() {
    return this.delegate_ && this.delegate_.copy && this.delegate_.copy();
  }
  FrameWidgetInputHandlerStub.prototype.copyToFindPboard = function() {
    return this.delegate_ && this.delegate_.copyToFindPboard && this.delegate_.copyToFindPboard();
  }
  FrameWidgetInputHandlerStub.prototype.centerSelection = function() {
    return this.delegate_ && this.delegate_.centerSelection && this.delegate_.centerSelection();
  }
  FrameWidgetInputHandlerStub.prototype.paste = function() {
    return this.delegate_ && this.delegate_.paste && this.delegate_.paste();
  }
  FrameWidgetInputHandlerStub.prototype.pasteAndMatchStyle = function() {
    return this.delegate_ && this.delegate_.pasteAndMatchStyle && this.delegate_.pasteAndMatchStyle();
  }
  FrameWidgetInputHandlerStub.prototype.delete = function() {
    return this.delegate_ && this.delegate_.delete && this.delegate_.delete();
  }
  FrameWidgetInputHandlerStub.prototype.selectAll = function() {
    return this.delegate_ && this.delegate_.selectAll && this.delegate_.selectAll();
  }
  FrameWidgetInputHandlerStub.prototype.collapseSelection = function() {
    return this.delegate_ && this.delegate_.collapseSelection && this.delegate_.collapseSelection();
  }
  FrameWidgetInputHandlerStub.prototype.copyWithConfirmation = function(token) {
    return this.delegate_ && this.delegate_.copyWithConfirmation && this.delegate_.copyWithConfirmation(token);
  }
  FrameWidgetInputHandlerStub.prototype.pasteWithConfirmation = function(token) {
    return this.delegate_ && this.delegate_.pasteWithConfirmation && this.delegate_.pasteWithConfirmation(token);
  }
  FrameWidgetInputHandlerStub.prototype.replace = function(word) {
    return this.delegate_ && this.delegate_.replace && this.delegate_.replace(word);
  }
  FrameWidgetInputHandlerStub.prototype.replaceMisspelling = function(word) {
    return this.delegate_ && this.delegate_.replaceMisspelling && this.delegate_.replaceMisspelling(word);
  }
  FrameWidgetInputHandlerStub.prototype.selectRange = function(base, extent) {
    return this.delegate_ && this.delegate_.selectRange && this.delegate_.selectRange(base, extent);
  }
  FrameWidgetInputHandlerStub.prototype.adjustSelectionByCharacterOffset = function(start, end, behavior) {
    return this.delegate_ && this.delegate_.adjustSelectionByCharacterOffset && this.delegate_.adjustSelectionByCharacterOffset(start, end, behavior);
  }
  FrameWidgetInputHandlerStub.prototype.selectAroundCaret = function(granularity, shouldShowHandle, shouldShowContextMenu) {
    return this.delegate_ && this.delegate_.selectAroundCaret && this.delegate_.selectAroundCaret(granularity, shouldShowHandle, shouldShowContextMenu);
  }
  FrameWidgetInputHandlerStub.prototype.moveRangeSelectionExtent = function(extent) {
    return this.delegate_ && this.delegate_.moveRangeSelectionExtent && this.delegate_.moveRangeSelectionExtent(extent);
  }
  FrameWidgetInputHandlerStub.prototype.scrollFocusedEditableNodeIntoView = function() {
    return this.delegate_ && this.delegate_.scrollFocusedEditableNodeIntoView && this.delegate_.scrollFocusedEditableNodeIntoView();
  }
  FrameWidgetInputHandlerStub.prototype.waitForPageScaleAnimationForTesting = function() {
    return this.delegate_ && this.delegate_.waitForPageScaleAnimationForTesting && this.delegate_.waitForPageScaleAnimationForTesting();
  }
  FrameWidgetInputHandlerStub.prototype.moveCaret = function(point) {
    return this.delegate_ && this.delegate_.moveCaret && this.delegate_.moveCaret(point);
  }

  FrameWidgetInputHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFrameWidgetInputHandler_AddImeTextSpansToExistingText_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params);
      this.addImeTextSpansToExistingText(params.start, params.end, params.imeTextSpans);
      return true;
    case kFrameWidgetInputHandler_ClearImeTextSpansByType_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_ClearImeTextSpansByType_Params);
      this.clearImeTextSpansByType(params.start, params.end, params.type);
      return true;
    case kFrameWidgetInputHandler_SetCompositionFromExistingText_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_SetCompositionFromExistingText_Params);
      this.setCompositionFromExistingText(params.start, params.end, params.imeTextSpans);
      return true;
    case kFrameWidgetInputHandler_ExtendSelectionAndDelete_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_ExtendSelectionAndDelete_Params);
      this.extendSelectionAndDelete(params.before, params.after);
      return true;
    case kFrameWidgetInputHandler_ExtendSelectionAndReplace_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_ExtendSelectionAndReplace_Params);
      this.extendSelectionAndReplace(params.before, params.after, params.replacementText);
      return true;
    case kFrameWidgetInputHandler_DeleteSurroundingText_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_DeleteSurroundingText_Params);
      this.deleteSurroundingText(params.before, params.after);
      return true;
    case kFrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params);
      this.deleteSurroundingTextInCodePoints(params.before, params.after);
      return true;
    case kFrameWidgetInputHandler_SetEditableSelectionOffsets_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_SetEditableSelectionOffsets_Params);
      this.setEditableSelectionOffsets(params.start, params.end);
      return true;
    case kFrameWidgetInputHandler_ExecuteEditCommand_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_ExecuteEditCommand_Params);
      this.executeEditCommand(params.command, params.value);
      return true;
    case kFrameWidgetInputHandler_Undo_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_Undo_Params);
      this.undo();
      return true;
    case kFrameWidgetInputHandler_Redo_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_Redo_Params);
      this.redo();
      return true;
    case kFrameWidgetInputHandler_Cut_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_Cut_Params);
      this.cut();
      return true;
    case kFrameWidgetInputHandler_Copy_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_Copy_Params);
      this.copy();
      return true;
    case kFrameWidgetInputHandler_CopyToFindPboard_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_CopyToFindPboard_Params);
      this.copyToFindPboard();
      return true;
    case kFrameWidgetInputHandler_CenterSelection_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_CenterSelection_Params);
      this.centerSelection();
      return true;
    case kFrameWidgetInputHandler_Paste_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_Paste_Params);
      this.paste();
      return true;
    case kFrameWidgetInputHandler_PasteAndMatchStyle_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_PasteAndMatchStyle_Params);
      this.pasteAndMatchStyle();
      return true;
    case kFrameWidgetInputHandler_Delete_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_Delete_Params);
      this.delete();
      return true;
    case kFrameWidgetInputHandler_SelectAll_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_SelectAll_Params);
      this.selectAll();
      return true;
    case kFrameWidgetInputHandler_CollapseSelection_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_CollapseSelection_Params);
      this.collapseSelection();
      return true;
    case kFrameWidgetInputHandler_Replace_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_Replace_Params);
      this.replace(params.word);
      return true;
    case kFrameWidgetInputHandler_ReplaceMisspelling_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_ReplaceMisspelling_Params);
      this.replaceMisspelling(params.word);
      return true;
    case kFrameWidgetInputHandler_SelectRange_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_SelectRange_Params);
      this.selectRange(params.base, params.extent);
      return true;
    case kFrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params);
      this.adjustSelectionByCharacterOffset(params.start, params.end, params.behavior);
      return true;
    case kFrameWidgetInputHandler_MoveRangeSelectionExtent_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_MoveRangeSelectionExtent_Params);
      this.moveRangeSelectionExtent(params.extent);
      return true;
    case kFrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params);
      this.scrollFocusedEditableNodeIntoView();
      return true;
    case kFrameWidgetInputHandler_MoveCaret_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_MoveCaret_Params);
      this.moveCaret(params.point);
      return true;
    default:
      return false;
    }
  };

  FrameWidgetInputHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFrameWidgetInputHandler_HandleStylusWritingGestureAction_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params);
      this.handleStylusWritingGestureAction(params.gestureData).then(function(response) {
        var responseParams =
            new FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFrameWidgetInputHandler_HandleStylusWritingGestureAction_Name,
            codec.align(FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidgetInputHandler_CopyWithConfirmation_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_CopyWithConfirmation_Params);
      this.copyWithConfirmation(params.token).then(function(response) {
        var responseParams =
            new FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams();
        responseParams.token = response.token;
        var builder = new codec.MessageV1Builder(
            kFrameWidgetInputHandler_CopyWithConfirmation_Name,
            codec.align(FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidgetInputHandler_PasteWithConfirmation_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_PasteWithConfirmation_Params);
      this.pasteWithConfirmation(params.token).then(function(response) {
        var responseParams =
            new FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams();
        responseParams.token = response.token;
        var builder = new codec.MessageV1Builder(
            kFrameWidgetInputHandler_PasteWithConfirmation_Name,
            codec.align(FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidgetInputHandler_SelectAroundCaret_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_SelectAroundCaret_Params);
      this.selectAroundCaret(params.granularity, params.shouldShowHandle, params.shouldShowContextMenu).then(function(response) {
        var responseParams =
            new FrameWidgetInputHandler_SelectAroundCaret_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFrameWidgetInputHandler_SelectAroundCaret_Name,
            codec.align(FrameWidgetInputHandler_SelectAroundCaret_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidgetInputHandler_SelectAroundCaret_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Name:
      var params = reader.decodeStruct(FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params);
      this.waitForPageScaleAnimationForTesting().then(function(response) {
        var responseParams =
            new FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kFrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Name,
            codec.align(FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFrameWidgetInputHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFrameWidgetInputHandler_AddImeTextSpansToExistingText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params;
      break;
      case kFrameWidgetInputHandler_ClearImeTextSpansByType_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_ClearImeTextSpansByType_Params;
      break;
      case kFrameWidgetInputHandler_SetCompositionFromExistingText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_SetCompositionFromExistingText_Params;
      break;
      case kFrameWidgetInputHandler_ExtendSelectionAndDelete_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_ExtendSelectionAndDelete_Params;
      break;
      case kFrameWidgetInputHandler_ExtendSelectionAndReplace_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_ExtendSelectionAndReplace_Params;
      break;
      case kFrameWidgetInputHandler_DeleteSurroundingText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_DeleteSurroundingText_Params;
      break;
      case kFrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params;
      break;
      case kFrameWidgetInputHandler_SetEditableSelectionOffsets_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_SetEditableSelectionOffsets_Params;
      break;
      case kFrameWidgetInputHandler_HandleStylusWritingGestureAction_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params;
      break;
      case kFrameWidgetInputHandler_ExecuteEditCommand_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_ExecuteEditCommand_Params;
      break;
      case kFrameWidgetInputHandler_Undo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_Undo_Params;
      break;
      case kFrameWidgetInputHandler_Redo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_Redo_Params;
      break;
      case kFrameWidgetInputHandler_Cut_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_Cut_Params;
      break;
      case kFrameWidgetInputHandler_Copy_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_Copy_Params;
      break;
      case kFrameWidgetInputHandler_CopyToFindPboard_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_CopyToFindPboard_Params;
      break;
      case kFrameWidgetInputHandler_CenterSelection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_CenterSelection_Params;
      break;
      case kFrameWidgetInputHandler_Paste_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_Paste_Params;
      break;
      case kFrameWidgetInputHandler_PasteAndMatchStyle_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_PasteAndMatchStyle_Params;
      break;
      case kFrameWidgetInputHandler_Delete_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_Delete_Params;
      break;
      case kFrameWidgetInputHandler_SelectAll_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_SelectAll_Params;
      break;
      case kFrameWidgetInputHandler_CollapseSelection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_CollapseSelection_Params;
      break;
      case kFrameWidgetInputHandler_CopyWithConfirmation_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidgetInputHandler_CopyWithConfirmation_Params;
      break;
      case kFrameWidgetInputHandler_PasteWithConfirmation_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidgetInputHandler_PasteWithConfirmation_Params;
      break;
      case kFrameWidgetInputHandler_Replace_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_Replace_Params;
      break;
      case kFrameWidgetInputHandler_ReplaceMisspelling_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_ReplaceMisspelling_Params;
      break;
      case kFrameWidgetInputHandler_SelectRange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_SelectRange_Params;
      break;
      case kFrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params;
      break;
      case kFrameWidgetInputHandler_SelectAroundCaret_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidgetInputHandler_SelectAroundCaret_Params;
      break;
      case kFrameWidgetInputHandler_MoveRangeSelectionExtent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_MoveRangeSelectionExtent_Params;
      break;
      case kFrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params;
      break;
      case kFrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params;
      break;
      case kFrameWidgetInputHandler_MoveCaret_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetInputHandler_MoveCaret_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFrameWidgetInputHandlerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFrameWidgetInputHandler_HandleStylusWritingGestureAction_Name:
        if (message.isResponse())
          paramsClass = FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams;
        break;
      case kFrameWidgetInputHandler_CopyWithConfirmation_Name:
        if (message.isResponse())
          paramsClass = FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams;
        break;
      case kFrameWidgetInputHandler_PasteWithConfirmation_Name:
        if (message.isResponse())
          paramsClass = FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams;
        break;
      case kFrameWidgetInputHandler_SelectAroundCaret_Name:
        if (message.isResponse())
          paramsClass = FrameWidgetInputHandler_SelectAroundCaret_ResponseParams;
        break;
      case kFrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Name:
        if (message.isResponse())
          paramsClass = FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FrameWidgetInputHandler = {
    name: 'blink.mojom.FrameWidgetInputHandler',
    kVersion: 0,
    ptrClass: FrameWidgetInputHandlerPtr,
    proxyClass: FrameWidgetInputHandlerProxy,
    stubClass: FrameWidgetInputHandlerStub,
    validateRequest: validateFrameWidgetInputHandlerRequest,
    validateResponse: validateFrameWidgetInputHandlerResponse,
  };
  FrameWidgetInputHandlerStub.prototype.validator = validateFrameWidgetInputHandlerRequest;
  FrameWidgetInputHandlerProxy.prototype.validator = validateFrameWidgetInputHandlerResponse;
  var kWidgetInputHandler_SetFocus_Name = 0;
  var kWidgetInputHandler_MouseCaptureLost_Name = 1;
  var kWidgetInputHandler_SetEditCommandsForNextKeyEvent_Name = 2;
  var kWidgetInputHandler_CursorVisibilityChanged_Name = 3;
  var kWidgetInputHandler_ImeSetComposition_Name = 4;
  var kWidgetInputHandler_ImeCommitText_Name = 5;
  var kWidgetInputHandler_ImeFinishComposingText_Name = 6;
  var kWidgetInputHandler_RequestTextInputStateUpdate_Name = 7;
  var kWidgetInputHandler_RequestCompositionUpdates_Name = 8;
  var kWidgetInputHandler_DispatchEvent_Name = 9;
  var kWidgetInputHandler_DispatchNonBlockingEvent_Name = 10;
  var kWidgetInputHandler_WaitForInputProcessed_Name = 11;
  var kWidgetInputHandler_PingMainThread_Name = 12;
  var kWidgetInputHandler_GetFrameWidgetInputHandler_Name = 13;
  var kWidgetInputHandler_UpdateBrowserControlsState_Name = 14;

  function WidgetInputHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WidgetInputHandler,
                                                   handleOrPtrInfo);
  }

  function WidgetInputHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WidgetInputHandler, associatedInterfacePtrInfo);
  }

  WidgetInputHandlerAssociatedPtr.prototype =
      Object.create(WidgetInputHandlerPtr.prototype);
  WidgetInputHandlerAssociatedPtr.prototype.constructor =
      WidgetInputHandlerAssociatedPtr;

  function WidgetInputHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  WidgetInputHandlerPtr.prototype.setFocus = function() {
    return WidgetInputHandlerProxy.prototype.setFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.setFocus = function(state) {
    var params_ = new WidgetInputHandler_SetFocus_Params();
    params_.state = state;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_SetFocus_Name,
        codec.align(WidgetInputHandler_SetFocus_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_SetFocus_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.mouseCaptureLost = function() {
    return WidgetInputHandlerProxy.prototype.mouseCaptureLost
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.mouseCaptureLost = function() {
    var params_ = new WidgetInputHandler_MouseCaptureLost_Params();
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_MouseCaptureLost_Name,
        codec.align(WidgetInputHandler_MouseCaptureLost_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_MouseCaptureLost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.setEditCommandsForNextKeyEvent = function() {
    return WidgetInputHandlerProxy.prototype.setEditCommandsForNextKeyEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.setEditCommandsForNextKeyEvent = function(commands) {
    var params_ = new WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params();
    params_.commands = commands;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_SetEditCommandsForNextKeyEvent_Name,
        codec.align(WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.cursorVisibilityChanged = function() {
    return WidgetInputHandlerProxy.prototype.cursorVisibilityChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.cursorVisibilityChanged = function(visible) {
    var params_ = new WidgetInputHandler_CursorVisibilityChanged_Params();
    params_.visible = visible;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_CursorVisibilityChanged_Name,
        codec.align(WidgetInputHandler_CursorVisibilityChanged_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_CursorVisibilityChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.imeSetComposition = function() {
    return WidgetInputHandlerProxy.prototype.imeSetComposition
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.imeSetComposition = function(text, imeTextSpans, range, start, end) {
    var params_ = new WidgetInputHandler_ImeSetComposition_Params();
    params_.text = text;
    params_.imeTextSpans = imeTextSpans;
    params_.range = range;
    params_.start = start;
    params_.end = end;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidgetInputHandler_ImeSetComposition_Name,
          codec.align(WidgetInputHandler_ImeSetComposition_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WidgetInputHandler_ImeSetComposition_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WidgetInputHandler_ImeSetComposition_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WidgetInputHandlerPtr.prototype.imeCommitText = function() {
    return WidgetInputHandlerProxy.prototype.imeCommitText
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.imeCommitText = function(text, imeTextSpans, range, relativeCursorPosition) {
    var params_ = new WidgetInputHandler_ImeCommitText_Params();
    params_.text = text;
    params_.imeTextSpans = imeTextSpans;
    params_.range = range;
    params_.relativeCursorPosition = relativeCursorPosition;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidgetInputHandler_ImeCommitText_Name,
          codec.align(WidgetInputHandler_ImeCommitText_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WidgetInputHandler_ImeCommitText_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WidgetInputHandler_ImeCommitText_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WidgetInputHandlerPtr.prototype.imeFinishComposingText = function() {
    return WidgetInputHandlerProxy.prototype.imeFinishComposingText
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.imeFinishComposingText = function(keepSelection) {
    var params_ = new WidgetInputHandler_ImeFinishComposingText_Params();
    params_.keepSelection = keepSelection;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_ImeFinishComposingText_Name,
        codec.align(WidgetInputHandler_ImeFinishComposingText_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_ImeFinishComposingText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.requestTextInputStateUpdate = function() {
    return WidgetInputHandlerProxy.prototype.requestTextInputStateUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.requestTextInputStateUpdate = function() {
    var params_ = new WidgetInputHandler_RequestTextInputStateUpdate_Params();
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_RequestTextInputStateUpdate_Name,
        codec.align(WidgetInputHandler_RequestTextInputStateUpdate_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_RequestTextInputStateUpdate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.requestCompositionUpdates = function() {
    return WidgetInputHandlerProxy.prototype.requestCompositionUpdates
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.requestCompositionUpdates = function(immediateRequest, monitorRequest) {
    var params_ = new WidgetInputHandler_RequestCompositionUpdates_Params();
    params_.immediateRequest = immediateRequest;
    params_.monitorRequest = monitorRequest;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_RequestCompositionUpdates_Name,
        codec.align(WidgetInputHandler_RequestCompositionUpdates_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_RequestCompositionUpdates_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.dispatchEvent = function() {
    return WidgetInputHandlerProxy.prototype.dispatchEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.dispatchEvent = function(event, originalEventForGesture) {
    var params_ = new WidgetInputHandler_DispatchEvent_Params();
    params_.event = event;
    params_.originalEventForGesture = originalEventForGesture;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidgetInputHandler_DispatchEvent_Name,
          codec.align(WidgetInputHandler_DispatchEvent_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WidgetInputHandler_DispatchEvent_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WidgetInputHandler_DispatchEvent_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WidgetInputHandlerPtr.prototype.dispatchNonBlockingEvent = function() {
    return WidgetInputHandlerProxy.prototype.dispatchNonBlockingEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.dispatchNonBlockingEvent = function(event) {
    var params_ = new WidgetInputHandler_DispatchNonBlockingEvent_Params();
    params_.event = event;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_DispatchNonBlockingEvent_Name,
        codec.align(WidgetInputHandler_DispatchNonBlockingEvent_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_DispatchNonBlockingEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.waitForInputProcessed = function() {
    return WidgetInputHandlerProxy.prototype.waitForInputProcessed
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.waitForInputProcessed = function() {
    var params_ = new WidgetInputHandler_WaitForInputProcessed_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidgetInputHandler_WaitForInputProcessed_Name,
          codec.align(WidgetInputHandler_WaitForInputProcessed_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WidgetInputHandler_WaitForInputProcessed_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WidgetInputHandler_WaitForInputProcessed_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WidgetInputHandlerPtr.prototype.pingMainThread = function() {
    return WidgetInputHandlerProxy.prototype.pingMainThread
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.pingMainThread = function() {
    var params_ = new WidgetInputHandler_PingMainThread_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidgetInputHandler_PingMainThread_Name,
          codec.align(WidgetInputHandler_PingMainThread_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WidgetInputHandler_PingMainThread_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WidgetInputHandler_PingMainThread_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WidgetInputHandlerPtr.prototype.getFrameWidgetInputHandler = function() {
    return WidgetInputHandlerProxy.prototype.getFrameWidgetInputHandler
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.getFrameWidgetInputHandler = function(interfaceRequest) {
    var params_ = new WidgetInputHandler_GetFrameWidgetInputHandler_Params();
    params_.interfaceRequest = interfaceRequest;
    var builder = new codec.MessageV2Builder(
        kWidgetInputHandler_GetFrameWidgetInputHandler_Name,
        codec.align(WidgetInputHandler_GetFrameWidgetInputHandler_Params.encodedSize));
    builder.setPayload(WidgetInputHandler_GetFrameWidgetInputHandler_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetInputHandlerPtr.prototype.updateBrowserControlsState = function() {
    return WidgetInputHandlerProxy.prototype.updateBrowserControlsState
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetInputHandlerProxy.prototype.updateBrowserControlsState = function(constraints, current, animate, offsetTagModifications) {
    var params_ = new WidgetInputHandler_UpdateBrowserControlsState_Params();
    params_.constraints = constraints;
    params_.current = current;
    params_.animate = animate;
    params_.offsetTagModifications = offsetTagModifications;
    var builder = new codec.MessageV0Builder(
        kWidgetInputHandler_UpdateBrowserControlsState_Name,
        codec.align(WidgetInputHandler_UpdateBrowserControlsState_Params.encodedSize));
    builder.encodeStruct(WidgetInputHandler_UpdateBrowserControlsState_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WidgetInputHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  WidgetInputHandlerStub.prototype.setFocus = function(state) {
    return this.delegate_ && this.delegate_.setFocus && this.delegate_.setFocus(state);
  }
  WidgetInputHandlerStub.prototype.mouseCaptureLost = function() {
    return this.delegate_ && this.delegate_.mouseCaptureLost && this.delegate_.mouseCaptureLost();
  }
  WidgetInputHandlerStub.prototype.setEditCommandsForNextKeyEvent = function(commands) {
    return this.delegate_ && this.delegate_.setEditCommandsForNextKeyEvent && this.delegate_.setEditCommandsForNextKeyEvent(commands);
  }
  WidgetInputHandlerStub.prototype.cursorVisibilityChanged = function(visible) {
    return this.delegate_ && this.delegate_.cursorVisibilityChanged && this.delegate_.cursorVisibilityChanged(visible);
  }
  WidgetInputHandlerStub.prototype.imeSetComposition = function(text, imeTextSpans, range, start, end) {
    return this.delegate_ && this.delegate_.imeSetComposition && this.delegate_.imeSetComposition(text, imeTextSpans, range, start, end);
  }
  WidgetInputHandlerStub.prototype.imeCommitText = function(text, imeTextSpans, range, relativeCursorPosition) {
    return this.delegate_ && this.delegate_.imeCommitText && this.delegate_.imeCommitText(text, imeTextSpans, range, relativeCursorPosition);
  }
  WidgetInputHandlerStub.prototype.imeFinishComposingText = function(keepSelection) {
    return this.delegate_ && this.delegate_.imeFinishComposingText && this.delegate_.imeFinishComposingText(keepSelection);
  }
  WidgetInputHandlerStub.prototype.requestTextInputStateUpdate = function() {
    return this.delegate_ && this.delegate_.requestTextInputStateUpdate && this.delegate_.requestTextInputStateUpdate();
  }
  WidgetInputHandlerStub.prototype.requestCompositionUpdates = function(immediateRequest, monitorRequest) {
    return this.delegate_ && this.delegate_.requestCompositionUpdates && this.delegate_.requestCompositionUpdates(immediateRequest, monitorRequest);
  }
  WidgetInputHandlerStub.prototype.dispatchEvent = function(event, originalEventForGesture) {
    return this.delegate_ && this.delegate_.dispatchEvent && this.delegate_.dispatchEvent(event, originalEventForGesture);
  }
  WidgetInputHandlerStub.prototype.dispatchNonBlockingEvent = function(event) {
    return this.delegate_ && this.delegate_.dispatchNonBlockingEvent && this.delegate_.dispatchNonBlockingEvent(event);
  }
  WidgetInputHandlerStub.prototype.waitForInputProcessed = function() {
    return this.delegate_ && this.delegate_.waitForInputProcessed && this.delegate_.waitForInputProcessed();
  }
  WidgetInputHandlerStub.prototype.pingMainThread = function() {
    return this.delegate_ && this.delegate_.pingMainThread && this.delegate_.pingMainThread();
  }
  WidgetInputHandlerStub.prototype.getFrameWidgetInputHandler = function(interfaceRequest) {
    return this.delegate_ && this.delegate_.getFrameWidgetInputHandler && this.delegate_.getFrameWidgetInputHandler(interfaceRequest);
  }
  WidgetInputHandlerStub.prototype.updateBrowserControlsState = function(constraints, current, animate, offsetTagModifications) {
    return this.delegate_ && this.delegate_.updateBrowserControlsState && this.delegate_.updateBrowserControlsState(constraints, current, animate, offsetTagModifications);
  }

  WidgetInputHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWidgetInputHandler_SetFocus_Name:
      var params = reader.decodeStruct(WidgetInputHandler_SetFocus_Params);
      this.setFocus(params.state);
      return true;
    case kWidgetInputHandler_MouseCaptureLost_Name:
      var params = reader.decodeStruct(WidgetInputHandler_MouseCaptureLost_Params);
      this.mouseCaptureLost();
      return true;
    case kWidgetInputHandler_SetEditCommandsForNextKeyEvent_Name:
      var params = reader.decodeStruct(WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params);
      this.setEditCommandsForNextKeyEvent(params.commands);
      return true;
    case kWidgetInputHandler_CursorVisibilityChanged_Name:
      var params = reader.decodeStruct(WidgetInputHandler_CursorVisibilityChanged_Params);
      this.cursorVisibilityChanged(params.visible);
      return true;
    case kWidgetInputHandler_ImeFinishComposingText_Name:
      var params = reader.decodeStruct(WidgetInputHandler_ImeFinishComposingText_Params);
      this.imeFinishComposingText(params.keepSelection);
      return true;
    case kWidgetInputHandler_RequestTextInputStateUpdate_Name:
      var params = reader.decodeStruct(WidgetInputHandler_RequestTextInputStateUpdate_Params);
      this.requestTextInputStateUpdate();
      return true;
    case kWidgetInputHandler_RequestCompositionUpdates_Name:
      var params = reader.decodeStruct(WidgetInputHandler_RequestCompositionUpdates_Params);
      this.requestCompositionUpdates(params.immediateRequest, params.monitorRequest);
      return true;
    case kWidgetInputHandler_DispatchNonBlockingEvent_Name:
      var params = reader.decodeStruct(WidgetInputHandler_DispatchNonBlockingEvent_Params);
      this.dispatchNonBlockingEvent(params.event);
      return true;
    case kWidgetInputHandler_GetFrameWidgetInputHandler_Name:
      var params = reader.decodeStruct(WidgetInputHandler_GetFrameWidgetInputHandler_Params);
      this.getFrameWidgetInputHandler(params.interfaceRequest);
      return true;
    case kWidgetInputHandler_UpdateBrowserControlsState_Name:
      var params = reader.decodeStruct(WidgetInputHandler_UpdateBrowserControlsState_Params);
      this.updateBrowserControlsState(params.constraints, params.current, params.animate, params.offsetTagModifications);
      return true;
    default:
      return false;
    }
  };

  WidgetInputHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWidgetInputHandler_ImeSetComposition_Name:
      var params = reader.decodeStruct(WidgetInputHandler_ImeSetComposition_Params);
      this.imeSetComposition(params.text, params.imeTextSpans, params.range, params.start, params.end).then(function(response) {
        var responseParams =
            new WidgetInputHandler_ImeSetComposition_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWidgetInputHandler_ImeSetComposition_Name,
            codec.align(WidgetInputHandler_ImeSetComposition_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WidgetInputHandler_ImeSetComposition_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWidgetInputHandler_ImeCommitText_Name:
      var params = reader.decodeStruct(WidgetInputHandler_ImeCommitText_Params);
      this.imeCommitText(params.text, params.imeTextSpans, params.range, params.relativeCursorPosition).then(function(response) {
        var responseParams =
            new WidgetInputHandler_ImeCommitText_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWidgetInputHandler_ImeCommitText_Name,
            codec.align(WidgetInputHandler_ImeCommitText_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WidgetInputHandler_ImeCommitText_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWidgetInputHandler_DispatchEvent_Name:
      var params = reader.decodeStruct(WidgetInputHandler_DispatchEvent_Params);
      this.dispatchEvent(params.event, params.originalEventForGesture).then(function(response) {
        var responseParams =
            new WidgetInputHandler_DispatchEvent_ResponseParams();
        responseParams.source = response.source;
        responseParams.updatedLatency = response.updatedLatency;
        responseParams.state = response.state;
        responseParams.overscroll = response.overscroll;
        responseParams.touchAction = response.touchAction;
        var builder = new codec.MessageV1Builder(
            kWidgetInputHandler_DispatchEvent_Name,
            codec.align(WidgetInputHandler_DispatchEvent_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WidgetInputHandler_DispatchEvent_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWidgetInputHandler_WaitForInputProcessed_Name:
      var params = reader.decodeStruct(WidgetInputHandler_WaitForInputProcessed_Params);
      this.waitForInputProcessed().then(function(response) {
        var responseParams =
            new WidgetInputHandler_WaitForInputProcessed_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWidgetInputHandler_WaitForInputProcessed_Name,
            codec.align(WidgetInputHandler_WaitForInputProcessed_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WidgetInputHandler_WaitForInputProcessed_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWidgetInputHandler_PingMainThread_Name:
      var params = reader.decodeStruct(WidgetInputHandler_PingMainThread_Params);
      this.pingMainThread().then(function(response) {
        var responseParams =
            new WidgetInputHandler_PingMainThread_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWidgetInputHandler_PingMainThread_Name,
            codec.align(WidgetInputHandler_PingMainThread_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WidgetInputHandler_PingMainThread_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWidgetInputHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWidgetInputHandler_SetFocus_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_SetFocus_Params;
      break;
      case kWidgetInputHandler_MouseCaptureLost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_MouseCaptureLost_Params;
      break;
      case kWidgetInputHandler_SetEditCommandsForNextKeyEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params;
      break;
      case kWidgetInputHandler_CursorVisibilityChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_CursorVisibilityChanged_Params;
      break;
      case kWidgetInputHandler_ImeSetComposition_Name:
        if (message.expectsResponse())
          paramsClass = WidgetInputHandler_ImeSetComposition_Params;
      break;
      case kWidgetInputHandler_ImeCommitText_Name:
        if (message.expectsResponse())
          paramsClass = WidgetInputHandler_ImeCommitText_Params;
      break;
      case kWidgetInputHandler_ImeFinishComposingText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_ImeFinishComposingText_Params;
      break;
      case kWidgetInputHandler_RequestTextInputStateUpdate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_RequestTextInputStateUpdate_Params;
      break;
      case kWidgetInputHandler_RequestCompositionUpdates_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_RequestCompositionUpdates_Params;
      break;
      case kWidgetInputHandler_DispatchEvent_Name:
        if (message.expectsResponse())
          paramsClass = WidgetInputHandler_DispatchEvent_Params;
      break;
      case kWidgetInputHandler_DispatchNonBlockingEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_DispatchNonBlockingEvent_Params;
      break;
      case kWidgetInputHandler_WaitForInputProcessed_Name:
        if (message.expectsResponse())
          paramsClass = WidgetInputHandler_WaitForInputProcessed_Params;
      break;
      case kWidgetInputHandler_PingMainThread_Name:
        if (message.expectsResponse())
          paramsClass = WidgetInputHandler_PingMainThread_Params;
      break;
      case kWidgetInputHandler_GetFrameWidgetInputHandler_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_GetFrameWidgetInputHandler_Params;
      break;
      case kWidgetInputHandler_UpdateBrowserControlsState_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetInputHandler_UpdateBrowserControlsState_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWidgetInputHandlerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWidgetInputHandler_ImeSetComposition_Name:
        if (message.isResponse())
          paramsClass = WidgetInputHandler_ImeSetComposition_ResponseParams;
        break;
      case kWidgetInputHandler_ImeCommitText_Name:
        if (message.isResponse())
          paramsClass = WidgetInputHandler_ImeCommitText_ResponseParams;
        break;
      case kWidgetInputHandler_DispatchEvent_Name:
        if (message.isResponse())
          paramsClass = WidgetInputHandler_DispatchEvent_ResponseParams;
        break;
      case kWidgetInputHandler_WaitForInputProcessed_Name:
        if (message.isResponse())
          paramsClass = WidgetInputHandler_WaitForInputProcessed_ResponseParams;
        break;
      case kWidgetInputHandler_PingMainThread_Name:
        if (message.isResponse())
          paramsClass = WidgetInputHandler_PingMainThread_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WidgetInputHandler = {
    name: 'blink.mojom.WidgetInputHandler',
    kVersion: 0,
    ptrClass: WidgetInputHandlerPtr,
    proxyClass: WidgetInputHandlerProxy,
    stubClass: WidgetInputHandlerStub,
    validateRequest: validateWidgetInputHandlerRequest,
    validateResponse: validateWidgetInputHandlerResponse,
  };
  WidgetInputHandlerStub.prototype.validator = validateWidgetInputHandlerRequest;
  WidgetInputHandlerProxy.prototype.validator = validateWidgetInputHandlerResponse;
  exports.SelectionGranularity = SelectionGranularity;
  exports.PanAction = PanAction;
  exports.FocusState = FocusState;
  exports.KeyData = KeyData;
  exports.PointerData = PointerData;
  exports.WheelData = WheelData;
  exports.MouseData = MouseData;
  exports.ScrollData = ScrollData;
  exports.PinchBeginData = PinchBeginData;
  exports.PinchUpdateData = PinchUpdateData;
  exports.PinchEndData = PinchEndData;
  exports.FlingData = FlingData;
  exports.TapData = TapData;
  exports.TapDownData = TapDownData;
  exports.GestureData = GestureData;
  exports.TouchPoint = TouchPoint;
  exports.TouchData = TouchData;
  exports.Event = Event;
  exports.DidOverscrollParams = DidOverscrollParams;
  exports.TouchActionOptional = TouchActionOptional;
  exports.EditCommand = EditCommand;
  exports.SelectAroundCaretResult = SelectAroundCaretResult;
  exports.WidgetInputHandlerHost = WidgetInputHandlerHost;
  exports.WidgetInputHandlerHostPtr = WidgetInputHandlerHostPtr;
  exports.WidgetInputHandlerHostAssociatedPtr = WidgetInputHandlerHostAssociatedPtr;
  exports.FrameWidgetInputHandler = FrameWidgetInputHandler;
  exports.FrameWidgetInputHandlerPtr = FrameWidgetInputHandlerPtr;
  exports.FrameWidgetInputHandlerAssociatedPtr = FrameWidgetInputHandlerAssociatedPtr;
  exports.WidgetInputHandler = WidgetInputHandler;
  exports.WidgetInputHandlerPtr = WidgetInputHandlerPtr;
  exports.WidgetInputHandlerAssociatedPtr = WidgetInputHandlerAssociatedPtr;
})();