// third_party/blink/public/mojom/input/input_handler.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/input/input_handler.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-shared.h"
#include "cc/mojom/browser_controls_state.mojom-shared.h"
#include "cc/mojom/overscroll_behavior.mojom-shared.h"
#include "cc/mojom/touch_action.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/input/gesture_event.mojom-shared.h"
#include "third_party/blink/public/mojom/input/handwriting_gesture_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-shared.h"
#include "third_party/blink/public/mojom/input/pointer_lock_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-shared.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-shared.h"
#include "third_party/blink/public/mojom/selection_menu/selection_menu_behavior.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/event_latency_metadata.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "ui/latency/mojom/latency_info.mojom-shared.h"


namespace blink::mojom {
class KeyDataDataView;

class PointerDataDataView;

class WheelDataDataView;

class MouseDataDataView;

class ScrollDataDataView;

class PinchBeginDataDataView;

class PinchUpdateDataDataView;

class PinchEndDataDataView;

class FlingDataDataView;

class TapDataDataView;

class TapDownDataDataView;

class GestureDataDataView;

class TouchPointDataView;

class TouchDataDataView;

class EventDataView;

class DidOverscrollParamsDataView;

class TouchActionOptionalDataView;

class EditCommandDataView;

class SelectAroundCaretResultDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::KeyDataDataView> {
  using Data = ::blink::mojom::internal::KeyData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PointerDataDataView> {
  using Data = ::blink::mojom::internal::PointerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WheelDataDataView> {
  using Data = ::blink::mojom::internal::WheelData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MouseDataDataView> {
  using Data = ::blink::mojom::internal::MouseData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ScrollDataDataView> {
  using Data = ::blink::mojom::internal::ScrollData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchBeginDataDataView> {
  using Data = ::blink::mojom::internal::PinchBeginData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchUpdateDataDataView> {
  using Data = ::blink::mojom::internal::PinchUpdateData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchEndDataDataView> {
  using Data = ::blink::mojom::internal::PinchEndData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FlingDataDataView> {
  using Data = ::blink::mojom::internal::FlingData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TapDataDataView> {
  using Data = ::blink::mojom::internal::TapData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TapDownDataDataView> {
  using Data = ::blink::mojom::internal::TapDownData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GestureDataDataView> {
  using Data = ::blink::mojom::internal::GestureData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchPointDataView> {
  using Data = ::blink::mojom::internal::TouchPoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchDataDataView> {
  using Data = ::blink::mojom::internal::TouchData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EventDataView> {
  using Data = ::blink::mojom::internal::Event_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DidOverscrollParamsDataView> {
  using Data = ::blink::mojom::internal::DidOverscrollParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchActionOptionalDataView> {
  using Data = ::blink::mojom::internal::TouchActionOptional_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EditCommandDataView> {
  using Data = ::blink::mojom::internal::EditCommand_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SelectAroundCaretResultDataView> {
  using Data = ::blink::mojom::internal::SelectAroundCaretResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class SelectionGranularity : int32_t {
  
  kWord = 0,
  
  kSentence = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SelectionGranularity value);
inline bool IsKnownEnumValue(SelectionGranularity value) {
  return internal::SelectionGranularity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PanAction : int32_t {
  
  kNone = 0,
  
  kScroll = 1,
  
  kMoveCursorOrScroll = 2,
  
  kStylusWritable = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PanAction value);
inline bool IsKnownEnumValue(PanAction value) {
  return internal::PanAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FocusState : int32_t {
  
  kFocused = 0,
  
  kNotFocusedAndActive = 1,
  
  kNotFocusedAndNotActive = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FocusState value);
inline bool IsKnownEnumValue(FocusState value) {
  return internal::FocusState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WidgetInputHandlerHostInterfaceBase {};

using WidgetInputHandlerHostPtrDataView =
    mojo::InterfacePtrDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostRequestDataView =
    mojo::InterfaceRequestDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WidgetInputHandlerHostInterfaceBase>;
class FrameWidgetInputHandlerInterfaceBase {};

using FrameWidgetInputHandlerPtrDataView =
    mojo::InterfacePtrDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerRequestDataView =
    mojo::InterfaceRequestDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameWidgetInputHandlerInterfaceBase>;
class WidgetInputHandlerInterfaceBase {};

using WidgetInputHandlerPtrDataView =
    mojo::InterfacePtrDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerRequestDataView =
    mojo::InterfaceRequestDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WidgetInputHandlerInterfaceBase>;


class KeyDataDataView {
 public:
  KeyDataDataView() = default;

  KeyDataDataView(
      internal::KeyData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t dom_key() const {
    return data_->dom_key;
  }
  int32_t dom_code() const {
    return data_->dom_code;
  }
  int32_t windows_key_code() const {
    return data_->windows_key_code;
  }
  int32_t native_key_code() const {
    return data_->native_key_code;
  }
  bool is_system_key() const {
    return data_->is_system_key;
  }
  bool is_browser_shortcut() const {
    return data_->is_browser_shortcut;
  }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUnmodifiedTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnmodifiedText(UserType* output) {
    
    auto* pointer = data_->unmodified_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::KeyData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PointerDataDataView {
 public:
  PointerDataDataView() = default;

  PointerDataDataView(
      internal::PointerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t pointer_id() const {
    return data_->pointer_id;
  }
  float force() const {
    return data_->force;
  }
  double tilt_x() const {
    return data_->tilt_x;
  }
  double tilt_y() const {
    return data_->tilt_y;
  }
  float tangential_pressure() const {
    return data_->tangential_pressure;
  }
  int32_t twist() const {
    return data_->twist;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadButton(UserType* output) const {
    auto data_value = data_->button;
    return mojo::internal::Deserialize<::blink::mojom::Button>(
        data_value, output);
  }
  ::blink::mojom::Button button() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Button>(data_->button));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPointerType(UserType* output) const {
    auto data_value = data_->pointer_type;
    return mojo::internal::Deserialize<::ui::mojom::EventPointerType>(
        data_value, output);
  }
  ::ui::mojom::EventPointerType pointer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventPointerType>(data_->pointer_type));
  }
  int32_t movement_x() const {
    return data_->movement_x;
  }
  int32_t movement_y() const {
    return data_->movement_y;
  }
  bool is_raw_movement_event() const {
    return data_->is_raw_movement_event;
  }
  inline void GetWidgetPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetPosition(UserType* output) {
    
    auto* pointer = data_->widget_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetScreenPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenPosition(UserType* output) {
    
    auto* pointer = data_->screen_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetMouseDataDataView(
      MouseDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMouseData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MouseDataDataView, UserType>(),
    "Attempting to read the optional `mouse_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMouseData` instead "
    "of `ReadMouseData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mouse_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::MouseDataDataView>(
        pointer, output, message_);
  }
  int32_t device_id() const {
    return data_->device_id;
  }
 private:
  internal::PointerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WheelDataDataView {
 public:
  WheelDataDataView() = default;

  WheelDataDataView(
      internal::WheelData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float delta_x() const {
    return data_->delta_x;
  }
  float delta_y() const {
    return data_->delta_y;
  }
  float wheel_ticks_x() const {
    return data_->wheel_ticks_x;
  }
  float wheel_ticks_y() const {
    return data_->wheel_ticks_y;
  }
  float acceleration_ratio_x() const {
    return data_->acceleration_ratio_x;
  }
  float acceleration_ratio_y() const {
    return data_->acceleration_ratio_y;
  }
  uint8_t phase() const {
    return data_->phase;
  }
  uint8_t momentum_phase() const {
    return data_->momentum_phase;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCancelable(UserType* output) const {
    auto data_value = data_->cancelable;
    return mojo::internal::Deserialize<::blink::mojom::DispatchType>(
        data_value, output);
  }
  ::blink::mojom::DispatchType cancelable() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DispatchType>(data_->cancelable));
  }
  uint8_t event_action() const {
    return data_->event_action;
  }
  uint8_t delta_units() const {
    return data_->delta_units;
  }
  int32_t rails_mode() const {
    return data_->rails_mode;
  }
 private:
  internal::WheelData_Data* data_ = nullptr;
};


class MouseDataDataView {
 public:
  MouseDataDataView() = default;

  MouseDataDataView(
      internal::MouseData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t click_count() const {
    return data_->click_count;
  }
  inline void GetWheelDataDataView(
      WheelDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWheelData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WheelDataDataView, UserType>(),
    "Attempting to read the optional `wheel_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWheelData` instead "
    "of `ReadWheelData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wheel_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::WheelDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::MouseData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollDataDataView {
 public:
  ScrollDataDataView() = default;

  ScrollDataDataView(
      internal::ScrollData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float delta_x() const {
    return data_->delta_x;
  }
  float delta_y() const {
    return data_->delta_y;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeltaUnits(UserType* output) const {
    auto data_value = data_->delta_units;
    return mojo::internal::Deserialize<::ui::mojom::ScrollGranularity>(
        data_value, output);
  }
  ::ui::mojom::ScrollGranularity delta_units() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ScrollGranularity>(data_->delta_units));
  }
  bool target_viewport() const {
    return data_->target_viewport;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInertialPhase(UserType* output) const {
    auto data_value = data_->inertial_phase;
    return mojo::internal::Deserialize<::blink::mojom::InertialPhaseState>(
        data_value, output);
  }
  ::blink::mojom::InertialPhaseState inertial_phase() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InertialPhaseState>(data_->inertial_phase));
  }
  bool synthetic() const {
    return data_->synthetic;
  }
  int32_t pointer_count() const {
    return data_->pointer_count;
  }
  bool cursor_control() const {
    return data_->cursor_control;
  }
 private:
  internal::ScrollData_Data* data_ = nullptr;
};


class PinchBeginDataDataView {
 public:
  PinchBeginDataDataView() = default;

  PinchBeginDataDataView(
      internal::PinchBeginData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchBeginData_Data* data_ = nullptr;
};


class PinchUpdateDataDataView {
 public:
  PinchUpdateDataDataView() = default;

  PinchUpdateDataDataView(
      internal::PinchUpdateData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float scale() const {
    return data_->scale;
  }
  bool zoom_disabled() const {
    return data_->zoom_disabled;
  }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchUpdateData_Data* data_ = nullptr;
};


class PinchEndDataDataView {
 public:
  PinchEndDataDataView() = default;

  PinchEndDataDataView(
      internal::PinchEndData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchEndData_Data* data_ = nullptr;
};


class FlingDataDataView {
 public:
  FlingDataDataView() = default;

  FlingDataDataView(
      internal::FlingData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float velocity_x() const {
    return data_->velocity_x;
  }
  float velocity_y() const {
    return data_->velocity_y;
  }
  bool target_viewport() const {
    return data_->target_viewport;
  }
  bool prevent_boosting() const {
    return data_->prevent_boosting;
  }
 private:
  internal::FlingData_Data* data_ = nullptr;
};


class TapDataDataView {
 public:
  TapDataDataView() = default;

  TapDataDataView(
      internal::TapData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t tap_count() const {
    return data_->tap_count;
  }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::TapData_Data* data_ = nullptr;
};


class TapDownDataDataView {
 public:
  TapDownDataDataView() = default;

  TapDownDataDataView(
      internal::TapDownData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t tap_down_count() const {
    return data_->tap_down_count;
  }
 private:
  internal::TapDownData_Data* data_ = nullptr;
};


class GestureDataDataView {
 public:
  GestureDataDataView() = default;

  GestureDataDataView(
      internal::GestureData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScreenPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenPosition(UserType* output) {
    
    auto* pointer = data_->screen_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetWidgetPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetPosition(UserType* output) {
    
    auto* pointer = data_->widget_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceDevice(UserType* output) const {
    auto data_value = data_->source_device;
    return mojo::internal::Deserialize<::blink::mojom::GestureDevice>(
        data_value, output);
  }
  ::blink::mojom::GestureDevice source_device() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::GestureDevice>(data_->source_device));
  }
  bool is_source_touch_event_set_blocking() const {
    return data_->is_source_touch_event_set_blocking;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryPointerType(UserType* output) const {
    auto data_value = data_->primary_pointer_type;
    return mojo::internal::Deserialize<::ui::mojom::EventPointerType>(
        data_value, output);
  }
  ::ui::mojom::EventPointerType primary_pointer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventPointerType>(data_->primary_pointer_type));
  }
  int32_t primary_unique_touch_event_id() const {
    return data_->primary_unique_touch_event_id;
  }
  int32_t unique_touch_event_id() const {
    return data_->unique_touch_event_id;
  }
  inline void GetContactSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContactSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `contact_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContactSize` instead "
    "of `ReadContactSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->contact_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetScrollDataDataView(
      ScrollDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ScrollDataDataView, UserType>(),
    "Attempting to read the optional `scroll_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollData` instead "
    "of `ReadScrollData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scroll_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScrollDataDataView>(
        pointer, output, message_);
  }
  inline void GetPinchBeginDataDataView(
      PinchBeginDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinchBeginData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchBeginDataDataView, UserType>(),
    "Attempting to read the optional `pinch_begin_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchBeginData` instead "
    "of `ReadPinchBeginData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_begin_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchBeginDataDataView>(
        pointer, output, message_);
  }
  inline void GetPinchUpdateDataDataView(
      PinchUpdateDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinchUpdateData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchUpdateDataDataView, UserType>(),
    "Attempting to read the optional `pinch_update_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchUpdateData` instead "
    "of `ReadPinchUpdateData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_update_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchUpdateDataDataView>(
        pointer, output, message_);
  }
  inline void GetPinchEndDataDataView(
      PinchEndDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinchEndData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchEndDataDataView, UserType>(),
    "Attempting to read the optional `pinch_end_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchEndData` instead "
    "of `ReadPinchEndData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_end_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchEndDataDataView>(
        pointer, output, message_);
  }
  inline void GetTapDataDataView(
      TapDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTapData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TapDataDataView, UserType>(),
    "Attempting to read the optional `tap_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTapData` instead "
    "of `ReadTapData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tap_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::TapDataDataView>(
        pointer, output, message_);
  }
  inline void GetTapDownDataDataView(
      TapDownDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTapDownData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TapDownDataDataView, UserType>(),
    "Attempting to read the optional `tap_down_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTapDownData` instead "
    "of `ReadTapDownData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tap_down_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::TapDownDataDataView>(
        pointer, output, message_);
  }
  inline void GetFlingDataDataView(
      FlingDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFlingData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FlingDataDataView, UserType>(),
    "Attempting to read the optional `fling_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFlingData` instead "
    "of `ReadFlingData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fling_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::FlingDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::GestureData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchPointDataView {
 public:
  TouchPointDataView() = default;

  TouchPointDataView(
      internal::TouchPoint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::blink::mojom::TouchState>(
        data_value, output);
  }
  ::blink::mojom::TouchState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::TouchState>(data_->state));
  }
  float radius_x() const {
    return data_->radius_x;
  }
  float radius_y() const {
    return data_->radius_y;
  }
  float rotation_angle() const {
    return data_->rotation_angle;
  }
  inline void GetPointerDataDataView(
      PointerDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerData(UserType* output) {
    
    auto* pointer = data_->pointer_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PointerDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::TouchPoint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchDataDataView {
 public:
  TouchDataDataView() = default;

  TouchDataDataView(
      internal::TouchData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCancelable(UserType* output) const {
    auto data_value = data_->cancelable;
    return mojo::internal::Deserialize<::blink::mojom::DispatchType>(
        data_value, output);
  }
  ::blink::mojom::DispatchType cancelable() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DispatchType>(data_->cancelable));
  }
  bool moved_beyond_slop_region() const {
    return data_->moved_beyond_slop_region;
  }
  bool touch_start_or_first_move() const {
    return data_->touch_start_or_first_move;
  }
  bool hovering() const {
    return data_->hovering;
  }
  uint32_t unique_touch_event_id() const {
    return data_->unique_touch_event_id;
  }
  inline void GetTouchesDataView(
      mojo::ArrayDataView<TouchPointDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTouches(UserType* output) {
    
    auto* pointer = data_->touches.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::TouchPointDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TouchData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventDataView {
 public:
  EventDataView() = default;

  EventDataView(
      internal::Event_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::EventType>(
        data_value, output);
  }
  ::blink::mojom::EventType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EventType>(data_->type));
  }
  int32_t modifiers() const {
    return data_->modifiers;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetLatencyDataView(
      ::ui::mojom::LatencyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatency(UserType* output) {
    
    auto* pointer = data_->latency.Get();
    return mojo::internal::Deserialize<::ui::mojom::LatencyInfoDataView>(
        pointer, output, message_);
  }
  inline void GetEventLatencyMetadataDataView(
      ::ui::mojom::EventLatencyMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventLatencyMetadata(UserType* output) {
    
    auto* pointer = data_->event_latency_metadata.Get();
    return mojo::internal::Deserialize<::ui::mojom::EventLatencyMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetKeyDataDataView(
      KeyDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::KeyDataDataView, UserType>(),
    "Attempting to read the optional `key_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyData` instead "
    "of `ReadKeyData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::KeyDataDataView>(
        pointer, output, message_);
  }
  inline void GetPointerDataDataView(
      PointerDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PointerDataDataView, UserType>(),
    "Attempting to read the optional `pointer_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPointerData` instead "
    "of `ReadPointerData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pointer_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PointerDataDataView>(
        pointer, output, message_);
  }
  inline void GetGestureDataDataView(
      GestureDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGestureData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GestureDataDataView, UserType>(),
    "Attempting to read the optional `gesture_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGestureData` instead "
    "of `ReadGestureData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gesture_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::GestureDataDataView>(
        pointer, output, message_);
  }
  inline void GetTouchDataDataView(
      TouchDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTouchData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TouchDataDataView, UserType>(),
    "Attempting to read the optional `touch_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTouchData` instead "
    "of `ReadTouchData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->touch_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::TouchDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInputSource(UserType* output) const {
    auto data_value = data_->input_source;
    return mojo::internal::Deserialize<::blink::mojom::InputSource>(
        data_value, output);
  }
  ::blink::mojom::InputSource input_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InputSource>(data_->input_source));
  }
 private:
  internal::Event_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidOverscrollParamsDataView {
 public:
  DidOverscrollParamsDataView() = default;

  DidOverscrollParamsDataView(
      internal::DidOverscrollParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAccumulatedOverscrollDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccumulatedOverscroll(UserType* output) {
    
    auto* pointer = data_->accumulated_overscroll.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetLatestOverscrollDeltaDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatestOverscrollDelta(UserType* output) {
    
    auto* pointer = data_->latest_overscroll_delta.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentFlingVelocityDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentFlingVelocity(UserType* output) {
    
    auto* pointer = data_->current_fling_velocity.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetCausalEventViewportPointDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCausalEventViewportPoint(UserType* output) {
    
    auto* pointer = data_->causal_event_viewport_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetOverscrollBehaviorDataView(
      ::cc::mojom::OverscrollBehaviorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverscrollBehavior(UserType* output) {
    
    auto* pointer = data_->overscroll_behavior.Get();
    return mojo::internal::Deserialize<::cc::mojom::OverscrollBehaviorDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceDevice(UserType* output) const {
    auto data_value = data_->source_device;
    return mojo::internal::Deserialize<::blink::mojom::GestureDevice>(
        data_value, output);
  }
  ::blink::mojom::GestureDevice source_device() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::GestureDevice>(data_->source_device));
  }
 private:
  internal::DidOverscrollParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchActionOptionalDataView {
 public:
  TouchActionOptionalDataView() = default;

  TouchActionOptionalDataView(
      internal::TouchActionOptional_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTouchAction(UserType* output) const {
    auto data_value = data_->touch_action;
    return mojo::internal::Deserialize<::cc::mojom::TouchAction>(
        data_value, output);
  }
  ::cc::mojom::TouchAction touch_action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::TouchAction>(data_->touch_action));
  }
 private:
  internal::TouchActionOptional_Data* data_ = nullptr;
};


class EditCommandDataView {
 public:
  EditCommandDataView() = default;

  EditCommandDataView(
      internal::EditCommand_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::EditCommand_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectAroundCaretResultDataView {
 public:
  SelectAroundCaretResultDataView() = default;

  SelectAroundCaretResultDataView(
      internal::SelectAroundCaretResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t extended_start_adjust() const {
    return data_->extended_start_adjust;
  }
  int32_t extended_end_adjust() const {
    return data_->extended_end_adjust;
  }
  int32_t word_start_adjust() const {
    return data_->word_start_adjust;
  }
  int32_t word_end_adjust() const {
    return data_->word_end_adjust;
  }
 private:
  internal::SelectAroundCaretResult_Data* data_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_DATA_VIEW_H_