// third_party/blink/public/mojom/input/ime_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  SkColor as skia_mojom_SkColor,
  SkColorSpec as skia_mojom_SkColorSpec
} from '../../../../../skia/public/mojom/skcolor.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  RectF as gfx_mojom_RectF,
  RectFSpec as gfx_mojom_RectFSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ImeRenderWidgetHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ImeRenderWidgetHost', scope);
  }
}

/** @interface */
export class ImeRenderWidgetHostInterface {
  
  /**
   * @param { !InputCursorAnchorInfo } cursorAnchorInfo
   */

  updateCursorAnchorInfo(cursorAnchorInfo) {}
}

/**
 * @implements { ImeRenderWidgetHostInterface }
 */
export class ImeRenderWidgetHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ImeRenderWidgetHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ImeRenderWidgetHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ImeRenderWidgetHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !InputCursorAnchorInfo } cursorAnchorInfo
   */

  updateCursorAnchorInfo(
      cursorAnchorInfo) {
    this.proxy.sendMessage(
        0,
        ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec.$,
        null,
        [
          cursorAnchorInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ImeRenderWidgetHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ImeRenderWidgetHostReceiver {
  /**
   * @param {!ImeRenderWidgetHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ImeRenderWidgetHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ImeRenderWidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImeRenderWidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec.$,
        null,
        impl.updateCursorAnchorInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ImeRenderWidgetHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ImeRenderWidgetHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ImeRenderWidgetHostRemote}
   */
  static getRemote() {
    let remote = new ImeRenderWidgetHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ImeRenderWidgetHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ImeRenderWidgetHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ImeRenderWidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImeRenderWidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCursorAnchorInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec.$,
        null,
        this.updateCursorAnchorInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorBoundsInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextAppearanceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputCursorAnchorInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    EditorBoundsInfoSpec.$,
    'EditorBoundsInfo',
    [
      mojo.internal.StructField(
        'editorBounds', 0,
        0,
        gfx_mojom_RectFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'handwritingBounds', 8,
        0,
        gfx_mojom_RectFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EditorBoundsInfo {
  constructor() {
    /** @type { !gfx_mojom_RectF } */
    this.editorBounds;
    /** @type { !gfx_mojom_RectF } */
    this.handwritingBounds;
  }
}



mojo.internal.Struct(
    TextAppearanceInfoSpec.$,
    'TextAppearanceInfo',
    [
      mojo.internal.StructField(
        'textColor', 0,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextAppearanceInfo {
  constructor() {
    /** @type { !skia_mojom_SkColor } */
    this.textColor;
  }
}



mojo.internal.Struct(
    InputCursorAnchorInfoSpec.$,
    'InputCursorAnchorInfo',
    [
      mojo.internal.StructField(
        'characterBounds', 0,
        0,
        mojo.internal.Array(gfx_mojom_RectSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'editorBoundsInfo', 8,
        0,
        EditorBoundsInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textAppearanceInfo', 16,
        0,
        TextAppearanceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visibleLineBounds', 24,
        0,
        mojo.internal.Array(gfx_mojom_RectSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'insertionMarker', 32,
        0,
        gfx_mojom_RectSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requested', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class InputCursorAnchorInfo {
  constructor() {
    /** @type { !Array<!gfx_mojom_Rect> } */
    this.characterBounds;
    /** @type { !EditorBoundsInfo } */
    this.editorBoundsInfo;
    /** @type { !TextAppearanceInfo } */
    this.textAppearanceInfo;
    /** @type { !Array<!gfx_mojom_Rect> } */
    this.visibleLineBounds;
    /** @type { (gfx_mojom_Rect|undefined) } */
    this.insertionMarker;
    /** @type { !boolean } */
    this.requested;
  }
}



mojo.internal.Struct(
    ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec.$,
    'ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params',
    [
      mojo.internal.StructField(
        'cursorAnchorInfo', 0,
        0,
        InputCursorAnchorInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params {
  constructor() {
    /** @type { !InputCursorAnchorInfo } */
    this.cursorAnchorInfo;
  }
}

