// third_party/blink/public/mojom/input/ime_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/ime_host.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/ime_host.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/ime_host.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolor.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ImeRenderWidgetHostProxy;

template <typename ImplRefTraits>
class ImeRenderWidgetHostStub;

class ImeRenderWidgetHostRequestValidator;


class BLINK_COMMON_EXPORT ImeRenderWidgetHost
    : public ImeRenderWidgetHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ImeRenderWidgetHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ImeRenderWidgetHostInterfaceBase;
  using Proxy_ = ImeRenderWidgetHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ImeRenderWidgetHostStub<ImplRefTraits>;

  using RequestValidator_ = ImeRenderWidgetHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateCursorAnchorInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateCursorAnchorInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ImeRenderWidgetHost() = default;

  virtual void UpdateCursorAnchorInfo(InputCursorAnchorInfoPtr cursor_anchor_info) = 0;
};



class BLINK_COMMON_EXPORT ImeRenderWidgetHostProxy
    : public ImeRenderWidgetHost {
 public:
  using InterfaceType = ImeRenderWidgetHost;

  explicit ImeRenderWidgetHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateCursorAnchorInfo(InputCursorAnchorInfoPtr cursor_anchor_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ImeRenderWidgetHostStubDispatch {
 public:
  static bool Accept(ImeRenderWidgetHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ImeRenderWidgetHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ImeRenderWidgetHost>>
class ImeRenderWidgetHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ImeRenderWidgetHostStub() = default;
  ~ImeRenderWidgetHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImeRenderWidgetHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImeRenderWidgetHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ImeRenderWidgetHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class BLINK_COMMON_EXPORT EditorBoundsInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EditorBoundsInfo, T>::value>;
  using DataView = EditorBoundsInfoDataView;
  using Data_ = internal::EditorBoundsInfo_Data;

  template <typename... Args>
  static EditorBoundsInfoPtr New(Args&&... args) {
    return EditorBoundsInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EditorBoundsInfoPtr From(const U& u) {
    return mojo::TypeConverter<EditorBoundsInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EditorBoundsInfo>::Convert(*this);
  }


  EditorBoundsInfo();

  EditorBoundsInfo(
      const ::gfx::RectF& editor_bounds,
      const ::gfx::RectF& handwriting_bounds);


  ~EditorBoundsInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EditorBoundsInfoPtr>
  EditorBoundsInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EditorBoundsInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EditorBoundsInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EditorBoundsInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EditorBoundsInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EditorBoundsInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EditorBoundsInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EditorBoundsInfo_UnserializedMessageContext<
            UserType, EditorBoundsInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EditorBoundsInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EditorBoundsInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EditorBoundsInfo_UnserializedMessageContext<
            UserType, EditorBoundsInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EditorBoundsInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::RectF editor_bounds;
  
  ::gfx::RectF handwriting_bounds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EditorBoundsInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EditorBoundsInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EditorBoundsInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EditorBoundsInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT TextAppearanceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextAppearanceInfo, T>::value>;
  using DataView = TextAppearanceInfoDataView;
  using Data_ = internal::TextAppearanceInfo_Data;

  template <typename... Args>
  static TextAppearanceInfoPtr New(Args&&... args) {
    return TextAppearanceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextAppearanceInfoPtr From(const U& u) {
    return mojo::TypeConverter<TextAppearanceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextAppearanceInfo>::Convert(*this);
  }


  TextAppearanceInfo();

  explicit TextAppearanceInfo(
      ::SkColor text_color);


  ~TextAppearanceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextAppearanceInfoPtr>
  TextAppearanceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextAppearanceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TextAppearanceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TextAppearanceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextAppearanceInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextAppearanceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextAppearanceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextAppearanceInfo_UnserializedMessageContext<
            UserType, TextAppearanceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TextAppearanceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TextAppearanceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextAppearanceInfo_UnserializedMessageContext<
            UserType, TextAppearanceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextAppearanceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColor text_color;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextAppearanceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextAppearanceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextAppearanceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextAppearanceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT InputCursorAnchorInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InputCursorAnchorInfo, T>::value>;
  using DataView = InputCursorAnchorInfoDataView;
  using Data_ = internal::InputCursorAnchorInfo_Data;

  template <typename... Args>
  static InputCursorAnchorInfoPtr New(Args&&... args) {
    return InputCursorAnchorInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InputCursorAnchorInfoPtr From(const U& u) {
    return mojo::TypeConverter<InputCursorAnchorInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InputCursorAnchorInfo>::Convert(*this);
  }


  InputCursorAnchorInfo();

  InputCursorAnchorInfo(
      std::vector<::gfx::Rect> character_bounds,
      EditorBoundsInfoPtr editor_bounds_info,
      TextAppearanceInfoPtr text_appearance_info,
      std::vector<::gfx::Rect> visible_line_bounds,
      const std::optional<::gfx::Rect>& insertion_marker,
      bool requested);

InputCursorAnchorInfo(const InputCursorAnchorInfo&) = delete;
InputCursorAnchorInfo& operator=(const InputCursorAnchorInfo&) = delete;

  ~InputCursorAnchorInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InputCursorAnchorInfoPtr>
  InputCursorAnchorInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InputCursorAnchorInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InputCursorAnchorInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InputCursorAnchorInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InputCursorAnchorInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InputCursorAnchorInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InputCursorAnchorInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InputCursorAnchorInfo_UnserializedMessageContext<
            UserType, InputCursorAnchorInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InputCursorAnchorInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InputCursorAnchorInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InputCursorAnchorInfo_UnserializedMessageContext<
            UserType, InputCursorAnchorInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InputCursorAnchorInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::gfx::Rect> character_bounds;
  
  EditorBoundsInfoPtr editor_bounds_info;
  
  TextAppearanceInfoPtr text_appearance_info;
  
  std::vector<::gfx::Rect> visible_line_bounds;
  
  std::optional<::gfx::Rect> insertion_marker;
  
  bool requested;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InputCursorAnchorInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InputCursorAnchorInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InputCursorAnchorInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InputCursorAnchorInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
EditorBoundsInfoPtr EditorBoundsInfo::Clone() const {
  return New(
      mojo::Clone(editor_bounds),
      mojo::Clone(handwriting_bounds)
  );
}

template <typename T, EditorBoundsInfo::EnableIfSame<T>*>
bool EditorBoundsInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->editor_bounds, other_struct.editor_bounds))
    return false;
  if (!mojo::Equals(this->handwriting_bounds, other_struct.handwriting_bounds))
    return false;
  return true;
}

template <typename T, EditorBoundsInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.editor_bounds < rhs.editor_bounds)
    return true;
  if (rhs.editor_bounds < lhs.editor_bounds)
    return false;
  if (lhs.handwriting_bounds < rhs.handwriting_bounds)
    return true;
  if (rhs.handwriting_bounds < lhs.handwriting_bounds)
    return false;
  return false;
}
template <typename StructPtrType>
TextAppearanceInfoPtr TextAppearanceInfo::Clone() const {
  return New(
      mojo::Clone(text_color)
  );
}

template <typename T, TextAppearanceInfo::EnableIfSame<T>*>
bool TextAppearanceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text_color, other_struct.text_color))
    return false;
  return true;
}

template <typename T, TextAppearanceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text_color < rhs.text_color)
    return true;
  if (rhs.text_color < lhs.text_color)
    return false;
  return false;
}
template <typename StructPtrType>
InputCursorAnchorInfoPtr InputCursorAnchorInfo::Clone() const {
  return New(
      mojo::Clone(character_bounds),
      mojo::Clone(editor_bounds_info),
      mojo::Clone(text_appearance_info),
      mojo::Clone(visible_line_bounds),
      mojo::Clone(insertion_marker),
      mojo::Clone(requested)
  );
}

template <typename T, InputCursorAnchorInfo::EnableIfSame<T>*>
bool InputCursorAnchorInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->character_bounds, other_struct.character_bounds))
    return false;
  if (!mojo::Equals(this->editor_bounds_info, other_struct.editor_bounds_info))
    return false;
  if (!mojo::Equals(this->text_appearance_info, other_struct.text_appearance_info))
    return false;
  if (!mojo::Equals(this->visible_line_bounds, other_struct.visible_line_bounds))
    return false;
  if (!mojo::Equals(this->insertion_marker, other_struct.insertion_marker))
    return false;
  if (!mojo::Equals(this->requested, other_struct.requested))
    return false;
  return true;
}

template <typename T, InputCursorAnchorInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.character_bounds < rhs.character_bounds)
    return true;
  if (rhs.character_bounds < lhs.character_bounds)
    return false;
  if (lhs.editor_bounds_info < rhs.editor_bounds_info)
    return true;
  if (rhs.editor_bounds_info < lhs.editor_bounds_info)
    return false;
  if (lhs.text_appearance_info < rhs.text_appearance_info)
    return true;
  if (rhs.text_appearance_info < lhs.text_appearance_info)
    return false;
  if (lhs.visible_line_bounds < rhs.visible_line_bounds)
    return true;
  if (rhs.visible_line_bounds < lhs.visible_line_bounds)
    return false;
  if (lhs.insertion_marker < rhs.insertion_marker)
    return true;
  if (rhs.insertion_marker < lhs.insertion_marker)
    return false;
  if (lhs.requested < rhs.requested)
    return true;
  if (rhs.requested < lhs.requested)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::EditorBoundsInfo::DataView,
                                         ::blink::mojom::EditorBoundsInfoPtr> {
  static bool IsNull(const ::blink::mojom::EditorBoundsInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::EditorBoundsInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::EditorBoundsInfo::editor_bounds)& editor_bounds(
      const ::blink::mojom::EditorBoundsInfoPtr& input) {
    return input->editor_bounds;
  }

  static const decltype(::blink::mojom::EditorBoundsInfo::handwriting_bounds)& handwriting_bounds(
      const ::blink::mojom::EditorBoundsInfoPtr& input) {
    return input->handwriting_bounds;
  }

  static bool Read(::blink::mojom::EditorBoundsInfo::DataView input, ::blink::mojom::EditorBoundsInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::TextAppearanceInfo::DataView,
                                         ::blink::mojom::TextAppearanceInfoPtr> {
  static bool IsNull(const ::blink::mojom::TextAppearanceInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::TextAppearanceInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::TextAppearanceInfo::text_color)& text_color(
      const ::blink::mojom::TextAppearanceInfoPtr& input) {
    return input->text_color;
  }

  static bool Read(::blink::mojom::TextAppearanceInfo::DataView input, ::blink::mojom::TextAppearanceInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::InputCursorAnchorInfo::DataView,
                                         ::blink::mojom::InputCursorAnchorInfoPtr> {
  static bool IsNull(const ::blink::mojom::InputCursorAnchorInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::InputCursorAnchorInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::InputCursorAnchorInfo::character_bounds)& character_bounds(
      const ::blink::mojom::InputCursorAnchorInfoPtr& input) {
    return input->character_bounds;
  }

  static const decltype(::blink::mojom::InputCursorAnchorInfo::editor_bounds_info)& editor_bounds_info(
      const ::blink::mojom::InputCursorAnchorInfoPtr& input) {
    return input->editor_bounds_info;
  }

  static const decltype(::blink::mojom::InputCursorAnchorInfo::text_appearance_info)& text_appearance_info(
      const ::blink::mojom::InputCursorAnchorInfoPtr& input) {
    return input->text_appearance_info;
  }

  static const decltype(::blink::mojom::InputCursorAnchorInfo::visible_line_bounds)& visible_line_bounds(
      const ::blink::mojom::InputCursorAnchorInfoPtr& input) {
    return input->visible_line_bounds;
  }

  static const decltype(::blink::mojom::InputCursorAnchorInfo::insertion_marker)& insertion_marker(
      const ::blink::mojom::InputCursorAnchorInfoPtr& input) {
    return input->insertion_marker;
  }

  static decltype(::blink::mojom::InputCursorAnchorInfo::requested) requested(
      const ::blink::mojom::InputCursorAnchorInfoPtr& input) {
    return input->requested;
  }

  static bool Read(::blink::mojom::InputCursorAnchorInfo::DataView input, ::blink::mojom::InputCursorAnchorInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_H_