// third_party/blink/public/mojom/input/ime_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ImeRenderWidgetHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ImeRenderWidgetHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ImeRenderWidgetHostInterface }
 */
blink.mojom.ImeRenderWidgetHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ImeRenderWidgetHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ImeRenderWidgetHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ImeRenderWidgetHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.InputCursorAnchorInfo } cursorAnchorInfo
   */

  updateCursorAnchorInfo(
      cursorAnchorInfo) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec.$,
        null,
        [
          cursorAnchorInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ImeRenderWidgetHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ImeRenderWidgetHostReceiver = class {
  /**
   * @param {!blink.mojom.ImeRenderWidgetHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ImeRenderWidgetHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ImeRenderWidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ImeRenderWidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec.$,
        null,
        impl.updateCursorAnchorInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ImeRenderWidgetHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ImeRenderWidgetHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ImeRenderWidgetHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ImeRenderWidgetHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ImeRenderWidgetHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ImeRenderWidgetHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ImeRenderWidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ImeRenderWidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCursorAnchorInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec.$,
        null,
        this.updateCursorAnchorInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EditorBoundsInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextAppearanceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InputCursorAnchorInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.EditorBoundsInfoSpec.$,
    'EditorBoundsInfo',
    [
      mojo.internal.StructField(
        'editorBounds', 0,
        0,
        gfx.mojom.RectFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'handwritingBounds', 8,
        0,
        gfx.mojom.RectFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.EditorBoundsInfo = class {
  constructor() {
    /** @export { !gfx.mojom.RectF } */
    this.editorBounds;
    /** @export { !gfx.mojom.RectF } */
    this.handwritingBounds;
  }
};



mojo.internal.Struct(
    blink.mojom.TextAppearanceInfoSpec.$,
    'TextAppearanceInfo',
    [
      mojo.internal.StructField(
        'textColor', 0,
        0,
        skia.mojom.SkColorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.TextAppearanceInfo = class {
  constructor() {
    /** @export { !skia.mojom.SkColor } */
    this.textColor;
  }
};



mojo.internal.Struct(
    blink.mojom.InputCursorAnchorInfoSpec.$,
    'InputCursorAnchorInfo',
    [
      mojo.internal.StructField(
        'characterBounds', 0,
        0,
        mojo.internal.Array(gfx.mojom.RectSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'editorBoundsInfo', 8,
        0,
        blink.mojom.EditorBoundsInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textAppearanceInfo', 16,
        0,
        blink.mojom.TextAppearanceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'visibleLineBounds', 24,
        0,
        mojo.internal.Array(gfx.mojom.RectSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'insertionMarker', 32,
        0,
        gfx.mojom.RectSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requested', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.InputCursorAnchorInfo = class {
  constructor() {
    /** @export { !Array<!gfx.mojom.Rect> } */
    this.characterBounds;
    /** @export { !blink.mojom.EditorBoundsInfo } */
    this.editorBoundsInfo;
    /** @export { !blink.mojom.TextAppearanceInfo } */
    this.textAppearanceInfo;
    /** @export { !Array<!gfx.mojom.Rect> } */
    this.visibleLineBounds;
    /** @export { (gfx.mojom.Rect|undefined) } */
    this.insertionMarker;
    /** @export { !boolean } */
    this.requested;
  }
};



mojo.internal.Struct(
    blink.mojom.ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsSpec.$,
    'ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params',
    [
      mojo.internal.StructField(
        'cursorAnchorInfo', 0,
        0,
        blink.mojom.InputCursorAnchorInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params = class {
  constructor() {
    /** @export { !blink.mojom.InputCursorAnchorInfo } */
    this.cursorAnchorInfo;
  }
};

