// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT IDBFactoryClientInterceptorForTesting : public IDBFactoryClient {
  virtual IDBFactoryClient* GetForwardingInterface() = 0;
  void Error(IDBException code, const ::std::u16string& message) override;
  void Blocked(int64_t existing_version) override;
  void UpgradeNeeded(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, int64_t old_version, IDBDataLoss data_loss, const std::string& data_loss_message, const ::blink::IndexedDBDatabaseMetadata& db_metadata) override;
  void OpenSuccess(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, const ::blink::IndexedDBDatabaseMetadata& metadata) override;
  void DeleteSuccess(int64_t old_version) override;
};
class BLINK_COMMON_EXPORT IDBFactoryClientAsyncWaiter {
 public:
  explicit IDBFactoryClientAsyncWaiter(IDBFactoryClient* proxy);

  IDBFactoryClientAsyncWaiter(const IDBFactoryClientAsyncWaiter&) = delete;
  IDBFactoryClientAsyncWaiter& operator=(const IDBFactoryClientAsyncWaiter&) = delete;

  ~IDBFactoryClientAsyncWaiter();

 private:
  IDBFactoryClient* const proxy_;
};


class BLINK_COMMON_EXPORT IDBDatabaseCallbacksInterceptorForTesting : public IDBDatabaseCallbacks {
  virtual IDBDatabaseCallbacks* GetForwardingInterface() = 0;
  void ForcedClose() override;
  void VersionChange(int64_t old_version, int64_t new_version) override;
  void Abort(int64_t transaction_id, IDBException code, const ::std::u16string& message) override;
  void Complete(int64_t transaction_id) override;
};
class BLINK_COMMON_EXPORT IDBDatabaseCallbacksAsyncWaiter {
 public:
  explicit IDBDatabaseCallbacksAsyncWaiter(IDBDatabaseCallbacks* proxy);

  IDBDatabaseCallbacksAsyncWaiter(const IDBDatabaseCallbacksAsyncWaiter&) = delete;
  IDBDatabaseCallbacksAsyncWaiter& operator=(const IDBDatabaseCallbacksAsyncWaiter&) = delete;

  ~IDBDatabaseCallbacksAsyncWaiter();

 private:
  IDBDatabaseCallbacks* const proxy_;
};


class BLINK_COMMON_EXPORT IDBCursorInterceptorForTesting : public IDBCursor {
  virtual IDBCursor* GetForwardingInterface() = 0;
  void Advance(uint32_t count, AdvanceCallback callback) override;
  void Continue(::blink::IndexedDBKey key, ::blink::IndexedDBKey primary_key, ContinueCallback callback) override;
  void Prefetch(int32_t count, PrefetchCallback callback) override;
  void PrefetchReset(int32_t used_prefetches) override;
};
class BLINK_COMMON_EXPORT IDBCursorAsyncWaiter {
 public:
  explicit IDBCursorAsyncWaiter(IDBCursor* proxy);

  IDBCursorAsyncWaiter(const IDBCursorAsyncWaiter&) = delete;
  IDBCursorAsyncWaiter& operator=(const IDBCursorAsyncWaiter&) = delete;

  ~IDBCursorAsyncWaiter();
  void Advance(
      uint32_t count, IDBCursorResultPtr* out_result);
  IDBCursorResultPtr Advance(uint32_t count);
  void Continue(
      ::blink::IndexedDBKey key, ::blink::IndexedDBKey primary_key, IDBCursorResultPtr* out_result);
  IDBCursorResultPtr Continue(::blink::IndexedDBKey key, ::blink::IndexedDBKey primary_key);
  void Prefetch(
      int32_t count, IDBCursorResultPtr* out_result);
  IDBCursorResultPtr Prefetch(int32_t count);

 private:
  IDBCursor* const proxy_;
};


class BLINK_COMMON_EXPORT IDBTransactionInterceptorForTesting : public IDBTransaction {
  virtual IDBTransaction* GetForwardingInterface() = 0;
  void CreateObjectStore(int64_t object_store_id, const ::std::u16string& name, const ::blink::IndexedDBKeyPath& key_path, bool auto_increment) override;
  void DeleteObjectStore(int64_t object_store_id) override;
  void Put(int64_t object_store_id, IDBValuePtr value, ::blink::IndexedDBKey key, IDBPutMode mode, std::vector<::blink::IndexedDBIndexKeys> index_keys, PutCallback callback) override;
  void SetIndexKeys(int64_t object_store_id, ::blink::IndexedDBKey primary_key, ::blink::IndexedDBIndexKeys index_keys) override;
  void SetIndexKeysDone() override;
  void Commit(int64_t num_errors_handled) override;
};
class BLINK_COMMON_EXPORT IDBTransactionAsyncWaiter {
 public:
  explicit IDBTransactionAsyncWaiter(IDBTransaction* proxy);

  IDBTransactionAsyncWaiter(const IDBTransactionAsyncWaiter&) = delete;
  IDBTransactionAsyncWaiter& operator=(const IDBTransactionAsyncWaiter&) = delete;

  ~IDBTransactionAsyncWaiter();
  void Put(
      int64_t object_store_id, IDBValuePtr value, ::blink::IndexedDBKey key, IDBPutMode mode, std::vector<::blink::IndexedDBIndexKeys> index_keys, IDBTransactionPutResultPtr* out_result);
  IDBTransactionPutResultPtr Put(int64_t object_store_id, IDBValuePtr value, ::blink::IndexedDBKey key, IDBPutMode mode, std::vector<::blink::IndexedDBIndexKeys> index_keys);

 private:
  IDBTransaction* const proxy_;
};


class BLINK_COMMON_EXPORT IDBDatabaseGetAllResultSinkInterceptorForTesting : public IDBDatabaseGetAllResultSink {
  virtual IDBDatabaseGetAllResultSink* GetForwardingInterface() = 0;
  void ReceiveResults(std::vector<IDBRecordPtr> records, bool done) override;
  void OnError(IDBErrorPtr error) override;
};
class BLINK_COMMON_EXPORT IDBDatabaseGetAllResultSinkAsyncWaiter {
 public:
  explicit IDBDatabaseGetAllResultSinkAsyncWaiter(IDBDatabaseGetAllResultSink* proxy);

  IDBDatabaseGetAllResultSinkAsyncWaiter(const IDBDatabaseGetAllResultSinkAsyncWaiter&) = delete;
  IDBDatabaseGetAllResultSinkAsyncWaiter& operator=(const IDBDatabaseGetAllResultSinkAsyncWaiter&) = delete;

  ~IDBDatabaseGetAllResultSinkAsyncWaiter();

 private:
  IDBDatabaseGetAllResultSink* const proxy_;
};


class BLINK_COMMON_EXPORT IDBDatabaseInterceptorForTesting : public IDBDatabase {
  virtual IDBDatabase* GetForwardingInterface() = 0;
  void RenameObjectStore(int64_t transaction_id, int64_t object_store_id, const ::std::u16string& new_name) override;
  void CreateTransaction(::mojo::PendingAssociatedReceiver<IDBTransaction> transaction_receiver, int64_t transaction_id, const std::vector<int64_t>& object_store_ids, IDBTransactionMode mode, IDBTransactionDurability durability) override;
  void VersionChangeIgnored() override;
  void Get(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, bool key_only, GetCallback callback) override;
  void GetAll(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBGetAllResultType result_type, uint32_t max_count, IDBCursorDirection direction, GetAllCallback callback) override;
  void OpenCursor(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type, OpenCursorCallback callback) override;
  void Count(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, CountCallback callback) override;
  void DeleteRange(int64_t transaction_id, int64_t object_store_id, ::blink::IndexedDBKeyRange key_range, DeleteRangeCallback callback) override;
  void GetKeyGeneratorCurrentNumber(int64_t transaction_id, int64_t object_store_id, GetKeyGeneratorCurrentNumberCallback callback) override;
  void Clear(int64_t transaction_id, int64_t object_store_id, ClearCallback callback) override;
  void CreateIndex(int64_t transaction_id, int64_t object_store_id, const ::blink::IndexedDBIndexMetadata& index) override;
  void DeleteIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id) override;
  void RenameIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id, const ::std::u16string& new_name) override;
  void Abort(int64_t transaction_id) override;
  void DidBecomeInactive() override;
  void UpdatePriority(int32_t new_priority) override;
};
class BLINK_COMMON_EXPORT IDBDatabaseAsyncWaiter {
 public:
  explicit IDBDatabaseAsyncWaiter(IDBDatabase* proxy);

  IDBDatabaseAsyncWaiter(const IDBDatabaseAsyncWaiter&) = delete;
  IDBDatabaseAsyncWaiter& operator=(const IDBDatabaseAsyncWaiter&) = delete;

  ~IDBDatabaseAsyncWaiter();
  void Get(
      int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, bool key_only, IDBDatabaseGetResultPtr* out_result);
  IDBDatabaseGetResultPtr Get(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, bool key_only);
  void GetAll(
      int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBGetAllResultType result_type, uint32_t max_count, IDBCursorDirection direction, ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink>* out_receiver);
  ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink> GetAll(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBGetAllResultType result_type, uint32_t max_count, IDBCursorDirection direction);
  void OpenCursor(
      int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type, IDBDatabaseOpenCursorResultPtr* out_result);
  IDBDatabaseOpenCursorResultPtr OpenCursor(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type);
  void Count(
      int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, bool* out_success, uint32_t* out_count);
  
  void DeleteRange(
      int64_t transaction_id, int64_t object_store_id, ::blink::IndexedDBKeyRange key_range, bool* out_success);
  bool DeleteRange(int64_t transaction_id, int64_t object_store_id, ::blink::IndexedDBKeyRange key_range);
  void GetKeyGeneratorCurrentNumber(
      int64_t transaction_id, int64_t object_store_id, int64_t* out_result, IDBErrorPtr* out_error);
  
  void Clear(
      int64_t transaction_id, int64_t object_store_id, bool* out_success);
  bool Clear(int64_t transaction_id, int64_t object_store_id);

 private:
  IDBDatabase* const proxy_;
};


class BLINK_COMMON_EXPORT IDBFactoryInterceptorForTesting : public IDBFactory {
  virtual IDBFactory* GetForwardingInterface() = 0;
  void GetDatabaseInfo(GetDatabaseInfoCallback callback) override;
  void Open(::mojo::PendingAssociatedRemote<IDBFactoryClient> client, ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> database_callbacks, const ::std::u16string& name, int64_t version, ::mojo::PendingAssociatedReceiver<IDBTransaction> version_change_transaction_receiver, int64_t transaction_id, int32_t priority) override;
  void DeleteDatabase(::mojo::PendingAssociatedRemote<IDBFactoryClient> client, const ::std::u16string& name, bool force_close) override;
};
class BLINK_COMMON_EXPORT IDBFactoryAsyncWaiter {
 public:
  explicit IDBFactoryAsyncWaiter(IDBFactory* proxy);

  IDBFactoryAsyncWaiter(const IDBFactoryAsyncWaiter&) = delete;
  IDBFactoryAsyncWaiter& operator=(const IDBFactoryAsyncWaiter&) = delete;

  ~IDBFactoryAsyncWaiter();
  void GetDatabaseInfo(
      std::vector<IDBNameAndVersionPtr>* out_names_and_versions, IDBErrorPtr* out_error);
  

 private:
  IDBFactory* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_TEST_UTILS_H_