// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* IDBCursorDirectionToStringHelper(IDBCursorDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBCursorDirection::Next:
      return "Next";
    case IDBCursorDirection::NextNoDuplicate:
      return "NextNoDuplicate";
    case IDBCursorDirection::Prev:
      return "Prev";
    case IDBCursorDirection::PrevNoDuplicate:
      return "PrevNoDuplicate";
    default:
      return nullptr;
  }
}

std::string IDBCursorDirectionToString(IDBCursorDirection value) {
  const char *str = IDBCursorDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBCursorDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBCursorDirection value) {
  return os << IDBCursorDirectionToString(value);
}

NOINLINE static const char* IDBDataLossToStringHelper(IDBDataLoss value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBDataLoss::None:
      return "None";
    case IDBDataLoss::Total:
      return "Total";
    default:
      return nullptr;
  }
}

std::string IDBDataLossToString(IDBDataLoss value) {
  const char *str = IDBDataLossToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBDataLoss value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBDataLoss value) {
  return os << IDBDataLossToString(value);
}

NOINLINE static const char* IDBKeyTypeToStringHelper(IDBKeyType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBKeyType::Invalid:
      return "Invalid";
    case IDBKeyType::Array:
      return "Array";
    case IDBKeyType::Binary:
      return "Binary";
    case IDBKeyType::String:
      return "String";
    case IDBKeyType::Date:
      return "Date";
    case IDBKeyType::Number:
      return "Number";
    case IDBKeyType::None:
      return "None";
    case IDBKeyType::Min:
      return "Min";
    default:
      return nullptr;
  }
}

std::string IDBKeyTypeToString(IDBKeyType value) {
  const char *str = IDBKeyTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBKeyType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBKeyType value) {
  return os << IDBKeyTypeToString(value);
}

NOINLINE static const char* IDBTransactionDurabilityToStringHelper(IDBTransactionDurability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBTransactionDurability::Default:
      return "Default";
    case IDBTransactionDurability::Strict:
      return "Strict";
    case IDBTransactionDurability::Relaxed:
      return "Relaxed";
    default:
      return nullptr;
  }
}

std::string IDBTransactionDurabilityToString(IDBTransactionDurability value) {
  const char *str = IDBTransactionDurabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBTransactionDurability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBTransactionDurability value) {
  return os << IDBTransactionDurabilityToString(value);
}

NOINLINE static const char* IDBGetAllResultTypeToStringHelper(IDBGetAllResultType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBGetAllResultType::Keys:
      return "Keys";
    case IDBGetAllResultType::Values:
      return "Values";
    case IDBGetAllResultType::Records:
      return "Records";
    default:
      return nullptr;
  }
}

std::string IDBGetAllResultTypeToString(IDBGetAllResultType value) {
  const char *str = IDBGetAllResultTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBGetAllResultType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBGetAllResultType value) {
  return os << IDBGetAllResultTypeToString(value);
}

NOINLINE static const char* IDBKeyPathTypeToStringHelper(IDBKeyPathType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBKeyPathType::Null:
      return "Null";
    case IDBKeyPathType::String:
      return "String";
    case IDBKeyPathType::Array:
      return "Array";
    default:
      return nullptr;
  }
}

std::string IDBKeyPathTypeToString(IDBKeyPathType value) {
  const char *str = IDBKeyPathTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBKeyPathType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBKeyPathType value) {
  return os << IDBKeyPathTypeToString(value);
}

NOINLINE static const char* IDBOperationTypeToStringHelper(IDBOperationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBOperationType::Add:
      return "Add";
    case IDBOperationType::Put:
      return "Put";
    case IDBOperationType::Delete:
      return "Delete";
    case IDBOperationType::Clear:
      return "Clear";
    default:
      return nullptr;
  }
}

std::string IDBOperationTypeToString(IDBOperationType value) {
  const char *str = IDBOperationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBOperationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBOperationType value) {
  return os << IDBOperationTypeToString(value);
}

NOINLINE static const char* IDBPutModeToStringHelper(IDBPutMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBPutMode::AddOrUpdate:
      return "AddOrUpdate";
    case IDBPutMode::AddOnly:
      return "AddOnly";
    case IDBPutMode::CursorUpdate:
      return "CursorUpdate";
    default:
      return nullptr;
  }
}

std::string IDBPutModeToString(IDBPutMode value) {
  const char *str = IDBPutModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBPutMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBPutMode value) {
  return os << IDBPutModeToString(value);
}

NOINLINE static const char* IDBTaskTypeToStringHelper(IDBTaskType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBTaskType::Normal:
      return "Normal";
    case IDBTaskType::Preemptive:
      return "Preemptive";
    default:
      return nullptr;
  }
}

std::string IDBTaskTypeToString(IDBTaskType value) {
  const char *str = IDBTaskTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBTaskType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBTaskType value) {
  return os << IDBTaskTypeToString(value);
}

NOINLINE static const char* IDBTransactionModeToStringHelper(IDBTransactionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBTransactionMode::ReadOnly:
      return "ReadOnly";
    case IDBTransactionMode::ReadWrite:
      return "ReadWrite";
    case IDBTransactionMode::VersionChange:
      return "VersionChange";
    default:
      return nullptr;
  }
}

std::string IDBTransactionModeToString(IDBTransactionMode value) {
  const char *str = IDBTransactionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBTransactionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBTransactionMode value) {
  return os << IDBTransactionModeToString(value);
}

NOINLINE static const char* IDBExceptionToStringHelper(IDBException value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBException::kNoError:
      return "kNoError";
    case IDBException::kIgnorableAbortError:
      return "kIgnorableAbortError";
    case IDBException::kAbortError:
      return "kAbortError";
    case IDBException::kQuotaError:
      return "kQuotaError";
    case IDBException::kTimeoutError:
      return "kTimeoutError";
    case IDBException::kUnknownError:
      return "kUnknownError";
    case IDBException::kConstraintError:
      return "kConstraintError";
    case IDBException::kDataError:
      return "kDataError";
    case IDBException::kVersionError:
      return "kVersionError";
    default:
      return nullptr;
  }
}

std::string IDBExceptionToString(IDBException value) {
  const char *str = IDBExceptionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBException value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBException value) {
  return os << IDBExceptionToString(value);
}

namespace internal {
// static
bool IDBKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBKey_Data* object = static_cast<const IDBKey_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBKey_Tag::kKeyArray: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_key_array, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& key_array_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_key_array, validation_context,
                                             &key_array_validate_params)) {
        return false;
      }
      return true;
    }
    case IDBKey_Tag::kBinary: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_binary, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& binary_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_binary, validation_context,
                                             &binary_validate_params)) {
        return false;
      }
      return true;
    }
    case IDBKey_Tag::kString: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_string, validation_context))
        return false;
      return true;
    }
    case IDBKey_Tag::kDate: {

      return true;
    }
    case IDBKey_Tag::kNumber: {

      return true;
    }
    case IDBKey_Tag::kOtherNone: {

      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBKey");
      return false;
    }
  }
}
// static
bool IDBKeyPathData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBKeyPathData_Data* object = static_cast<const IDBKeyPathData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBKeyPathData_Tag::kString: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_string, validation_context))
        return false;
      return true;
    }
    case IDBKeyPathData_Tag::kStringArray: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string_array, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& string_array_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_string_array, validation_context,
                                             &string_array_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBKeyPathData");
      return false;
    }
  }
}
// static
bool IDBExternalObject_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBExternalObject_Data* object = static_cast<const IDBExternalObject_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBExternalObject_Tag::kBlobOrFile: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_blob_or_file, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_blob_or_file, validation_context))
        return false;
      return true;
    }
    case IDBExternalObject_Tag::kFileSystemAccessToken: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_file_system_access_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_file_system_access_token,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBExternalObject");
      return false;
    }
  }
}
// static
bool IDBCursorResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBCursorResult_Data* object = static_cast<const IDBCursorResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBCursorResult_Tag::kErrorResult: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBCursorResult_Tag::kEmpty: {

      return true;
    }
    case IDBCursorResult_Tag::kValues: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_values, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_values, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBCursorResult");
      return false;
    }
  }
}
// static
bool IDBTransactionPutResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBTransactionPutResult_Data* object = static_cast<const IDBTransactionPutResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBTransactionPutResult_Tag::kErrorResult: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBTransactionPutResult_Tag::kKey: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_key, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_key,
                                                   validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBTransactionPutResult");
      return false;
    }
  }
}
// static
bool IDBDatabaseGetResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBDatabaseGetResult_Data* object = static_cast<const IDBDatabaseGetResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBDatabaseGetResult_Tag::kErrorResult: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBDatabaseGetResult_Tag::kEmpty: {

      return true;
    }
    case IDBDatabaseGetResult_Tag::kKey: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_key, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_key,
                                                   validation_context))
        return false;
      return true;
    }
    case IDBDatabaseGetResult_Tag::kValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_value, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_value, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBDatabaseGetResult");
      return false;
    }
  }
}
// static
bool IDBDatabaseOpenCursorResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBDatabaseOpenCursorResult_Data* object = static_cast<const IDBDatabaseOpenCursorResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBDatabaseOpenCursorResult_Tag::kErrorResult: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBDatabaseOpenCursorResult_Tag::kEmpty: {

      return true;
    }
    case IDBDatabaseOpenCursorResult_Tag::kValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_value, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_value, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBDatabaseOpenCursorResult");
      return false;
    }
  }
}


// static
bool IDBKeyPath_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBKeyPath_Data* object =
      static_cast<const IDBKeyPath_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

IDBKeyPath_Data::IDBKeyPath_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBKeyRange_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBKeyRange_Data* object =
      static_cast<const IDBKeyRange_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->lower, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->lower, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->upper, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->upper, validation_context))
    return false;

  return true;
}

IDBKeyRange_Data::IDBKeyRange_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBIndexMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBIndexMetadata_Data* object =
      static_cast<const IDBIndexMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  return true;
}

IDBIndexMetadata_Data::IDBIndexMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBObjectStoreMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBObjectStoreMetadata_Data* object =
      static_cast<const IDBObjectStoreMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indexes, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& indexes_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->indexes, validation_context,
                                         &indexes_validate_params)) {
    return false;
  }

  return true;
}

IDBObjectStoreMetadata_Data::IDBObjectStoreMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabaseMetadata_Data* object =
      static_cast<const IDBDatabaseMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->object_stores, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& object_stores_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->object_stores, validation_context,
                                         &object_stores_validate_params)) {
    return false;
  }

  return true;
}

IDBDatabaseMetadata_Data::IDBDatabaseMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBNameAndVersion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBNameAndVersion_Data* object =
      static_cast<const IDBNameAndVersion_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  return true;
}

IDBNameAndVersion_Data::IDBNameAndVersion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBIndexKeys_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBIndexKeys_Data* object =
      static_cast<const IDBIndexKeys_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index_keys, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& index_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->index_keys, validation_context,
                                         &index_keys_validate_params)) {
    return false;
  }

  return true;
}

IDBIndexKeys_Data::IDBIndexKeys_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFileInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFileInfo_Data* object =
      static_cast<const IDBFileInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_modified, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_modified, validation_context))
    return false;

  return true;
}

IDBFileInfo_Data::IDBFileInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBBlobInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBBlobInfo_Data* object =
      static_cast<const IDBBlobInfo_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blob, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blob,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mime_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

IDBBlobInfo_Data::IDBBlobInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBValue_Data* object =
      static_cast<const IDBValue_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->bits, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->bits, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->external_objects, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& external_objects_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->external_objects, validation_context,
                                         &external_objects_validate_params)) {
    return false;
  }

  return true;
}

IDBValue_Data::IDBValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBReturnValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBReturnValue_Data* object =
      static_cast<const IDBReturnValue_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->primary_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  return true;
}

IDBReturnValue_Data::IDBReturnValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBRecord_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBRecord_Data* object =
      static_cast<const IDBRecord_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->return_value, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->index_key, validation_context))
    return false;

  return true;
}

IDBRecord_Data::IDBRecord_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBError_Data* object =
      static_cast<const IDBError_Data*>(data);


  if (!::blink::mojom::internal::IDBException_Data
        ::Validate(object->error_code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->error_message, validation_context))
    return false;

  return true;
}

IDBError_Data::IDBError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursorValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBCursorValue_Data* object =
      static_cast<const IDBCursorValue_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_keys, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& primary_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->primary_keys, validation_context,
                                         &primary_keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->values, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->values, validation_context,
                                         &values_validate_params)) {
    return false;
  }

  return true;
}

IDBCursorValue_Data::IDBCursorValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseOpenCursorValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabaseOpenCursorValue_Data* object =
      static_cast<const IDBDatabaseOpenCursorValue_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cursor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cursor,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->primary_key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

IDBDatabaseOpenCursorValue_Data::IDBDatabaseOpenCursorValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactoryClient_Error_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactoryClient_Error_Params_Data* object =
      static_cast<const IDBFactoryClient_Error_Params_Data*>(data);


  if (!::blink::mojom::internal::IDBException_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

IDBFactoryClient_Error_Params_Data::IDBFactoryClient_Error_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactoryClient_Blocked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactoryClient_Blocked_Params_Data* object =
      static_cast<const IDBFactoryClient_Blocked_Params_Data*>(data);

  return true;
}

IDBFactoryClient_Blocked_Params_Data::IDBFactoryClient_Blocked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactoryClient_UpgradeNeeded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactoryClient_UpgradeNeeded_Params_Data* object =
      static_cast<const IDBFactoryClient_UpgradeNeeded_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_database, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_database,
                                                 validation_context)) {
    return false;
  }


  if (!::blink::mojom::internal::IDBDataLoss_Data
        ::Validate(object->data_loss, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_loss_message, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_loss_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data_loss_message, validation_context,
                                         &data_loss_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->db_metadata, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->db_metadata, validation_context))
    return false;

  return true;
}

IDBFactoryClient_UpgradeNeeded_Params_Data::IDBFactoryClient_UpgradeNeeded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactoryClient_OpenSuccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactoryClient_OpenSuccess_Params_Data* object =
      static_cast<const IDBFactoryClient_OpenSuccess_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->pending_database,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

IDBFactoryClient_OpenSuccess_Params_Data::IDBFactoryClient_OpenSuccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactoryClient_DeleteSuccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactoryClient_DeleteSuccess_Params_Data* object =
      static_cast<const IDBFactoryClient_DeleteSuccess_Params_Data*>(data);

  return true;
}

IDBFactoryClient_DeleteSuccess_Params_Data::IDBFactoryClient_DeleteSuccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseCallbacks_ForcedClose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabaseCallbacks_ForcedClose_Params_Data* object =
      static_cast<const IDBDatabaseCallbacks_ForcedClose_Params_Data*>(data);

  return true;
}

IDBDatabaseCallbacks_ForcedClose_Params_Data::IDBDatabaseCallbacks_ForcedClose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseCallbacks_VersionChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabaseCallbacks_VersionChange_Params_Data* object =
      static_cast<const IDBDatabaseCallbacks_VersionChange_Params_Data*>(data);

  return true;
}

IDBDatabaseCallbacks_VersionChange_Params_Data::IDBDatabaseCallbacks_VersionChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseCallbacks_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabaseCallbacks_Abort_Params_Data* object =
      static_cast<const IDBDatabaseCallbacks_Abort_Params_Data*>(data);


  if (!::blink::mojom::internal::IDBException_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

IDBDatabaseCallbacks_Abort_Params_Data::IDBDatabaseCallbacks_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseCallbacks_Complete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabaseCallbacks_Complete_Params_Data* object =
      static_cast<const IDBDatabaseCallbacks_Complete_Params_Data*>(data);

  return true;
}

IDBDatabaseCallbacks_Complete_Params_Data::IDBDatabaseCallbacks_Complete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Advance_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBCursor_Advance_Params_Data* object =
      static_cast<const IDBCursor_Advance_Params_Data*>(data);

  return true;
}

IDBCursor_Advance_Params_Data::IDBCursor_Advance_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Advance_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBCursor_Advance_ResponseParams_Data* object =
      static_cast<const IDBCursor_Advance_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBCursor_Advance_ResponseParams_Data::IDBCursor_Advance_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Continue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBCursor_Continue_Params_Data* object =
      static_cast<const IDBCursor_Continue_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->primary_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  return true;
}

IDBCursor_Continue_Params_Data::IDBCursor_Continue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Continue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBCursor_Continue_ResponseParams_Data* object =
      static_cast<const IDBCursor_Continue_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBCursor_Continue_ResponseParams_Data::IDBCursor_Continue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Prefetch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBCursor_Prefetch_Params_Data* object =
      static_cast<const IDBCursor_Prefetch_Params_Data*>(data);

  return true;
}

IDBCursor_Prefetch_Params_Data::IDBCursor_Prefetch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Prefetch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBCursor_Prefetch_ResponseParams_Data* object =
      static_cast<const IDBCursor_Prefetch_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBCursor_Prefetch_ResponseParams_Data::IDBCursor_Prefetch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_PrefetchReset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBCursor_PrefetchReset_Params_Data* object =
      static_cast<const IDBCursor_PrefetchReset_Params_Data*>(data);

  return true;
}

IDBCursor_PrefetchReset_Params_Data::IDBCursor_PrefetchReset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_CreateObjectStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBTransaction_CreateObjectStore_Params_Data* object =
      static_cast<const IDBTransaction_CreateObjectStore_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  return true;
}

IDBTransaction_CreateObjectStore_Params_Data::IDBTransaction_CreateObjectStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_DeleteObjectStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBTransaction_DeleteObjectStore_Params_Data* object =
      static_cast<const IDBTransaction_DeleteObjectStore_Params_Data*>(data);

  return true;
}

IDBTransaction_DeleteObjectStore_Params_Data::IDBTransaction_DeleteObjectStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_Put_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBTransaction_Put_Params_Data* object =
      static_cast<const IDBTransaction_Put_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->key, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBPutMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index_keys, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& index_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->index_keys, validation_context,
                                         &index_keys_validate_params)) {
    return false;
  }

  return true;
}

IDBTransaction_Put_Params_Data::IDBTransaction_Put_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_Put_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBTransaction_Put_ResponseParams_Data* object =
      static_cast<const IDBTransaction_Put_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBTransaction_Put_ResponseParams_Data::IDBTransaction_Put_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_SetIndexKeys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBTransaction_SetIndexKeys_Params_Data* object =
      static_cast<const IDBTransaction_SetIndexKeys_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->primary_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index_keys, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->index_keys, validation_context))
    return false;

  return true;
}

IDBTransaction_SetIndexKeys_Params_Data::IDBTransaction_SetIndexKeys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_SetIndexKeysDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBTransaction_SetIndexKeysDone_Params_Data* object =
      static_cast<const IDBTransaction_SetIndexKeysDone_Params_Data*>(data);

  return true;
}

IDBTransaction_SetIndexKeysDone_Params_Data::IDBTransaction_SetIndexKeysDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_Commit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBTransaction_Commit_Params_Data* object =
      static_cast<const IDBTransaction_Commit_Params_Data*>(data);

  return true;
}

IDBTransaction_Commit_Params_Data::IDBTransaction_Commit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data* object =
      static_cast<const IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->records, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& records_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->records, validation_context,
                                         &records_validate_params)) {
    return false;
  }

  return true;
}

IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data::IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseGetAllResultSink_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabaseGetAllResultSink_OnError_Params_Data* object =
      static_cast<const IDBDatabaseGetAllResultSink_OnError_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

IDBDatabaseGetAllResultSink_OnError_Params_Data::IDBDatabaseGetAllResultSink_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_RenameObjectStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_RenameObjectStore_Params_Data* object =
      static_cast<const IDBDatabase_RenameObjectStore_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_name, validation_context))
    return false;

  return true;
}

IDBDatabase_RenameObjectStore_Params_Data::IDBDatabase_RenameObjectStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_CreateTransaction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_CreateTransaction_Params_Data* object =
      static_cast<const IDBDatabase_CreateTransaction_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->transaction_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->transaction_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->object_store_ids, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& object_store_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->object_store_ids, validation_context,
                                         &object_store_ids_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::IDBTransactionMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBTransactionDurability_Data
        ::Validate(object->durability, validation_context))
    return false;

  return true;
}

IDBDatabase_CreateTransaction_Params_Data::IDBDatabase_CreateTransaction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_VersionChangeIgnored_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_VersionChangeIgnored_Params_Data* object =
      static_cast<const IDBDatabase_VersionChangeIgnored_Params_Data*>(data);

  return true;
}

IDBDatabase_VersionChangeIgnored_Params_Data::IDBDatabase_VersionChangeIgnored_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Get_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_Get_Params_Data* object =
      static_cast<const IDBDatabase_Get_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;

  return true;
}

IDBDatabase_Get_Params_Data::IDBDatabase_Get_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Get_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_Get_ResponseParams_Data* object =
      static_cast<const IDBDatabase_Get_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBDatabase_Get_ResponseParams_Data::IDBDatabase_Get_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_GetAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_GetAll_Params_Data* object =
      static_cast<const IDBDatabase_GetAll_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBGetAllResultType_Data
        ::Validate(object->result_type, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBCursorDirection_Data
        ::Validate(object->direction, validation_context))
    return false;

  return true;
}

IDBDatabase_GetAll_Params_Data::IDBDatabase_GetAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_GetAll_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_GetAll_ResponseParams_Data* object =
      static_cast<const IDBDatabase_GetAll_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBDatabase_GetAll_ResponseParams_Data::IDBDatabase_GetAll_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_OpenCursor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_OpenCursor_Params_Data* object =
      static_cast<const IDBDatabase_OpenCursor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBCursorDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBTaskType_Data
        ::Validate(object->task_type, validation_context))
    return false;

  return true;
}

IDBDatabase_OpenCursor_Params_Data::IDBDatabase_OpenCursor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_OpenCursor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_OpenCursor_ResponseParams_Data* object =
      static_cast<const IDBDatabase_OpenCursor_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBDatabase_OpenCursor_ResponseParams_Data::IDBDatabase_OpenCursor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Count_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_Count_Params_Data* object =
      static_cast<const IDBDatabase_Count_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;

  return true;
}

IDBDatabase_Count_Params_Data::IDBDatabase_Count_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Count_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_Count_ResponseParams_Data* object =
      static_cast<const IDBDatabase_Count_ResponseParams_Data*>(data);

  return true;
}

IDBDatabase_Count_ResponseParams_Data::IDBDatabase_Count_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_DeleteRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_DeleteRange_Params_Data* object =
      static_cast<const IDBDatabase_DeleteRange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;

  return true;
}

IDBDatabase_DeleteRange_Params_Data::IDBDatabase_DeleteRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_DeleteRange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_DeleteRange_ResponseParams_Data* object =
      static_cast<const IDBDatabase_DeleteRange_ResponseParams_Data*>(data);

  return true;
}

IDBDatabase_DeleteRange_ResponseParams_Data::IDBDatabase_DeleteRange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data* object =
      static_cast<const IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data*>(data);

  return true;
}

IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data* object =
      static_cast<const IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data::IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Clear_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_Clear_Params_Data* object =
      static_cast<const IDBDatabase_Clear_Params_Data*>(data);

  return true;
}

IDBDatabase_Clear_Params_Data::IDBDatabase_Clear_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Clear_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_Clear_ResponseParams_Data* object =
      static_cast<const IDBDatabase_Clear_ResponseParams_Data*>(data);

  return true;
}

IDBDatabase_Clear_ResponseParams_Data::IDBDatabase_Clear_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_CreateIndex_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_CreateIndex_Params_Data* object =
      static_cast<const IDBDatabase_CreateIndex_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->index, validation_context))
    return false;

  return true;
}

IDBDatabase_CreateIndex_Params_Data::IDBDatabase_CreateIndex_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_DeleteIndex_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_DeleteIndex_Params_Data* object =
      static_cast<const IDBDatabase_DeleteIndex_Params_Data*>(data);

  return true;
}

IDBDatabase_DeleteIndex_Params_Data::IDBDatabase_DeleteIndex_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_RenameIndex_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_RenameIndex_Params_Data* object =
      static_cast<const IDBDatabase_RenameIndex_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_name, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_name, validation_context))
    return false;

  return true;
}

IDBDatabase_RenameIndex_Params_Data::IDBDatabase_RenameIndex_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_Abort_Params_Data* object =
      static_cast<const IDBDatabase_Abort_Params_Data*>(data);

  return true;
}

IDBDatabase_Abort_Params_Data::IDBDatabase_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_DidBecomeInactive_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_DidBecomeInactive_Params_Data* object =
      static_cast<const IDBDatabase_DidBecomeInactive_Params_Data*>(data);

  return true;
}

IDBDatabase_DidBecomeInactive_Params_Data::IDBDatabase_DidBecomeInactive_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_UpdatePriority_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBDatabase_UpdatePriority_Params_Data* object =
      static_cast<const IDBDatabase_UpdatePriority_Params_Data*>(data);

  return true;
}

IDBDatabase_UpdatePriority_Params_Data::IDBDatabase_UpdatePriority_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_GetDatabaseInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactory_GetDatabaseInfo_Params_Data* object =
      static_cast<const IDBFactory_GetDatabaseInfo_Params_Data*>(data);

  return true;
}

IDBFactory_GetDatabaseInfo_Params_Data::IDBFactory_GetDatabaseInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_GetDatabaseInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactory_GetDatabaseInfo_ResponseParams_Data* object =
      static_cast<const IDBFactory_GetDatabaseInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->names_and_versions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& names_and_versions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->names_and_versions, validation_context,
                                         &names_and_versions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

IDBFactory_GetDatabaseInfo_ResponseParams_Data::IDBFactory_GetDatabaseInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactory_Open_Params_Data* object =
      static_cast<const IDBFactory_Open_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->database_callbacks, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->database_callbacks,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->version_change_transaction_receiver, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->version_change_transaction_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBFactory_Open_Params_Data::IDBFactory_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_DeleteDatabase_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IDBFactory_DeleteDatabase_Params_Data* object =
      static_cast<const IDBFactory_DeleteDatabase_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  return true;
}

IDBFactory_DeleteDatabase_Params_Data::IDBFactory_DeleteDatabase_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBCursorDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBCursorDirection value) {
  return std::move(context).WriteString(::blink::mojom::IDBCursorDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBDataLoss>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBDataLoss value) {
  return std::move(context).WriteString(::blink::mojom::IDBDataLossToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBKeyType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBKeyType value) {
  return std::move(context).WriteString(::blink::mojom::IDBKeyTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBTransactionDurability>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBTransactionDurability value) {
  return std::move(context).WriteString(::blink::mojom::IDBTransactionDurabilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBGetAllResultType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBGetAllResultType value) {
  return std::move(context).WriteString(::blink::mojom::IDBGetAllResultTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBKeyPathType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBKeyPathType value) {
  return std::move(context).WriteString(::blink::mojom::IDBKeyPathTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBOperationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBOperationType value) {
  return std::move(context).WriteString(::blink::mojom::IDBOperationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBPutMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBPutMode value) {
  return std::move(context).WriteString(::blink::mojom::IDBPutModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBTaskType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBTaskType value) {
  return std::move(context).WriteString(::blink::mojom::IDBTaskTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBTransactionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBTransactionMode value) {
  return std::move(context).WriteString(::blink::mojom::IDBTransactionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBException>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBException value) {
  return std::move(context).WriteString(::blink::mojom::IDBExceptionToString(value));
}

} // namespace perfetto