// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"


namespace blink::mojom {
class IDBKeyPathDataView;

class IDBKeyRangeDataView;

class IDBIndexMetadataDataView;

class IDBObjectStoreMetadataDataView;

class IDBDatabaseMetadataDataView;

class IDBNameAndVersionDataView;

class IDBIndexKeysDataView;

class IDBFileInfoDataView;

class IDBBlobInfoDataView;

class IDBValueDataView;

class IDBReturnValueDataView;

class IDBRecordDataView;

class IDBErrorDataView;

class IDBCursorValueDataView;

class IDBDatabaseOpenCursorValueDataView;

class IDBKeyDataView;
class IDBKeyPathDataDataView;
class IDBExternalObjectDataView;
class IDBCursorResultDataView;
class IDBTransactionPutResultDataView;
class IDBDatabaseGetResultDataView;
class IDBDatabaseOpenCursorResultDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::IDBKeyPathDataView> {
  using Data = ::blink::mojom::internal::IDBKeyPath_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBKeyRangeDataView> {
  using Data = ::blink::mojom::internal::IDBKeyRange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBIndexMetadataDataView> {
  using Data = ::blink::mojom::internal::IDBIndexMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBObjectStoreMetadataDataView> {
  using Data = ::blink::mojom::internal::IDBObjectStoreMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBDatabaseMetadataDataView> {
  using Data = ::blink::mojom::internal::IDBDatabaseMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBNameAndVersionDataView> {
  using Data = ::blink::mojom::internal::IDBNameAndVersion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBIndexKeysDataView> {
  using Data = ::blink::mojom::internal::IDBIndexKeys_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBFileInfoDataView> {
  using Data = ::blink::mojom::internal::IDBFileInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBBlobInfoDataView> {
  using Data = ::blink::mojom::internal::IDBBlobInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBValueDataView> {
  using Data = ::blink::mojom::internal::IDBValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBReturnValueDataView> {
  using Data = ::blink::mojom::internal::IDBReturnValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBRecordDataView> {
  using Data = ::blink::mojom::internal::IDBRecord_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBErrorDataView> {
  using Data = ::blink::mojom::internal::IDBError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBCursorValueDataView> {
  using Data = ::blink::mojom::internal::IDBCursorValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBDatabaseOpenCursorValueDataView> {
  using Data = ::blink::mojom::internal::IDBDatabaseOpenCursorValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBKeyDataView> {
  using Data = ::blink::mojom::internal::IDBKey_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBKeyPathDataDataView> {
  using Data = ::blink::mojom::internal::IDBKeyPathData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBExternalObjectDataView> {
  using Data = ::blink::mojom::internal::IDBExternalObject_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBCursorResultDataView> {
  using Data = ::blink::mojom::internal::IDBCursorResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBTransactionPutResultDataView> {
  using Data = ::blink::mojom::internal::IDBTransactionPutResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBDatabaseGetResultDataView> {
  using Data = ::blink::mojom::internal::IDBDatabaseGetResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::IDBDatabaseOpenCursorResultDataView> {
  using Data = ::blink::mojom::internal::IDBDatabaseOpenCursorResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class IDBCursorDirection : int32_t {
  
  Next = 0,
  
  NextNoDuplicate = 1,
  
  Prev = 2,
  
  PrevNoDuplicate = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBCursorDirection value);
inline bool IsKnownEnumValue(IDBCursorDirection value) {
  return internal::IDBCursorDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBDataLoss : int32_t {
  
  None = 0,
  
  Total = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBDataLoss value);
inline bool IsKnownEnumValue(IDBDataLoss value) {
  return internal::IDBDataLoss_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBKeyType : int32_t {
  
  Invalid = 0,
  
  Array = 1,
  
  Binary = 2,
  
  String = 3,
  
  Date = 4,
  
  Number = 5,
  
  None = 6,
  
  Min = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBKeyType value);
inline bool IsKnownEnumValue(IDBKeyType value) {
  return internal::IDBKeyType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBTransactionDurability : int32_t {
  
  Default = 0,
  
  Strict = 1,
  
  Relaxed = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBTransactionDurability value);
inline bool IsKnownEnumValue(IDBTransactionDurability value) {
  return internal::IDBTransactionDurability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBGetAllResultType : int32_t {
  
  Keys = 0,
  
  Values = 1,
  
  Records = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBGetAllResultType value);
inline bool IsKnownEnumValue(IDBGetAllResultType value) {
  return internal::IDBGetAllResultType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBKeyPathType : int32_t {
  
  Null = 0,
  
  String = 1,
  
  Array = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBKeyPathType value);
inline bool IsKnownEnumValue(IDBKeyPathType value) {
  return internal::IDBKeyPathType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBOperationType : int32_t {
  
  Add = 0,
  
  Put = 1,
  
  Delete = 2,
  
  Clear = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBOperationType value);
inline bool IsKnownEnumValue(IDBOperationType value) {
  return internal::IDBOperationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBPutMode : int32_t {
  
  AddOrUpdate = 0,
  
  AddOnly = 1,
  
  CursorUpdate = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBPutMode value);
inline bool IsKnownEnumValue(IDBPutMode value) {
  return internal::IDBPutMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBTaskType : int32_t {
  
  Normal = 0,
  
  Preemptive = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBTaskType value);
inline bool IsKnownEnumValue(IDBTaskType value) {
  return internal::IDBTaskType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBTransactionMode : int32_t {
  
  ReadOnly = 0,
  
  ReadWrite = 1,
  
  VersionChange = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBTransactionMode value);
inline bool IsKnownEnumValue(IDBTransactionMode value) {
  return internal::IDBTransactionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IDBException : int32_t {
  
  kNoError = 0,
  
  kUnknownError = 28,
  
  kConstraintError = 29,
  
  kDataError = 30,
  
  kVersionError = 33,
  
  kAbortError = 20,
  
  kIgnorableAbortError = 11,
  
  kQuotaError = 22,
  
  kTimeoutError = 23,
  kMinValue = 0,
  kMaxValue = 33,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IDBException value);
inline bool IsKnownEnumValue(IDBException value) {
  return internal::IDBException_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class IDBFactoryClientInterfaceBase {};

using IDBFactoryClientPtrDataView =
    mojo::InterfacePtrDataView<IDBFactoryClientInterfaceBase>;
using IDBFactoryClientRequestDataView =
    mojo::InterfaceRequestDataView<IDBFactoryClientInterfaceBase>;
using IDBFactoryClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IDBFactoryClientInterfaceBase>;
using IDBFactoryClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IDBFactoryClientInterfaceBase>;
class IDBDatabaseCallbacksInterfaceBase {};

using IDBDatabaseCallbacksPtrDataView =
    mojo::InterfacePtrDataView<IDBDatabaseCallbacksInterfaceBase>;
using IDBDatabaseCallbacksRequestDataView =
    mojo::InterfaceRequestDataView<IDBDatabaseCallbacksInterfaceBase>;
using IDBDatabaseCallbacksAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IDBDatabaseCallbacksInterfaceBase>;
using IDBDatabaseCallbacksAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IDBDatabaseCallbacksInterfaceBase>;
class IDBCursorInterfaceBase {};

using IDBCursorPtrDataView =
    mojo::InterfacePtrDataView<IDBCursorInterfaceBase>;
using IDBCursorRequestDataView =
    mojo::InterfaceRequestDataView<IDBCursorInterfaceBase>;
using IDBCursorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IDBCursorInterfaceBase>;
using IDBCursorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IDBCursorInterfaceBase>;
class IDBTransactionInterfaceBase {};

using IDBTransactionPtrDataView =
    mojo::InterfacePtrDataView<IDBTransactionInterfaceBase>;
using IDBTransactionRequestDataView =
    mojo::InterfaceRequestDataView<IDBTransactionInterfaceBase>;
using IDBTransactionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IDBTransactionInterfaceBase>;
using IDBTransactionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IDBTransactionInterfaceBase>;
class IDBDatabaseGetAllResultSinkInterfaceBase {};

using IDBDatabaseGetAllResultSinkPtrDataView =
    mojo::InterfacePtrDataView<IDBDatabaseGetAllResultSinkInterfaceBase>;
using IDBDatabaseGetAllResultSinkRequestDataView =
    mojo::InterfaceRequestDataView<IDBDatabaseGetAllResultSinkInterfaceBase>;
using IDBDatabaseGetAllResultSinkAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IDBDatabaseGetAllResultSinkInterfaceBase>;
using IDBDatabaseGetAllResultSinkAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IDBDatabaseGetAllResultSinkInterfaceBase>;
class IDBDatabaseInterfaceBase {};

using IDBDatabasePtrDataView =
    mojo::InterfacePtrDataView<IDBDatabaseInterfaceBase>;
using IDBDatabaseRequestDataView =
    mojo::InterfaceRequestDataView<IDBDatabaseInterfaceBase>;
using IDBDatabaseAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IDBDatabaseInterfaceBase>;
using IDBDatabaseAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IDBDatabaseInterfaceBase>;
class IDBFactoryInterfaceBase {};

using IDBFactoryPtrDataView =
    mojo::InterfacePtrDataView<IDBFactoryInterfaceBase>;
using IDBFactoryRequestDataView =
    mojo::InterfaceRequestDataView<IDBFactoryInterfaceBase>;
using IDBFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IDBFactoryInterfaceBase>;
using IDBFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IDBFactoryInterfaceBase>;


class IDBKeyPathDataView {
 public:
  IDBKeyPathDataView() = default;

  IDBKeyPathDataView(
      internal::IDBKeyPath_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      IDBKeyPathDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::IDBKeyPathDataDataView, UserType>(),
    "Attempting to read the optional `data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadData` instead "
    "of `ReadData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyPathDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::IDBKeyPath_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBKeyRangeDataView {
 public:
  IDBKeyRangeDataView() = default;

  IDBKeyRangeDataView(
      internal::IDBKeyRange_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLowerDataView(
      IDBKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLower(UserType* output) {
    
    auto* pointer = !data_->lower.is_null() ? &data_->lower : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        pointer, output, message_);
  }
  inline void GetUpperDataView(
      IDBKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpper(UserType* output) {
    
    auto* pointer = !data_->upper.is_null() ? &data_->upper : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        pointer, output, message_);
  }
  bool lower_open() const {
    return data_->lower_open;
  }
  bool upper_open() const {
    return data_->upper_open;
  }
 private:
  internal::IDBKeyRange_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBIndexMetadataDataView {
 public:
  IDBIndexMetadataDataView() = default;

  IDBIndexMetadataDataView(
      internal::IDBIndexMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetKeyPathDataView(
      IDBKeyPathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyPath(UserType* output) {
    
    auto* pointer = data_->key_path.Get();
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyPathDataView>(
        pointer, output, message_);
  }
  bool unique() const {
    return data_->unique;
  }
  bool multi_entry() const {
    return data_->multi_entry;
  }
 private:
  internal::IDBIndexMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBObjectStoreMetadataDataView {
 public:
  IDBObjectStoreMetadataDataView() = default;

  IDBObjectStoreMetadataDataView(
      internal::IDBObjectStoreMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetKeyPathDataView(
      IDBKeyPathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyPath(UserType* output) {
    
    auto* pointer = data_->key_path.Get();
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyPathDataView>(
        pointer, output, message_);
  }
  bool auto_increment() const {
    return data_->auto_increment;
  }
  int64_t max_index_id() const {
    return data_->max_index_id;
  }
  inline void GetIndexesDataView(
      mojo::MapDataView<int64_t, IDBIndexMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIndexes(UserType* output) {
    
    auto* pointer = data_->indexes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int64_t, ::blink::mojom::IDBIndexMetadataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IDBObjectStoreMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBDatabaseMetadataDataView {
 public:
  IDBDatabaseMetadataDataView() = default;

  IDBDatabaseMetadataDataView(
      internal::IDBDatabaseMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  int64_t version() const {
    return data_->version;
  }
  int64_t max_object_store_id() const {
    return data_->max_object_store_id;
  }
  inline void GetObjectStoresDataView(
      mojo::MapDataView<int64_t, IDBObjectStoreMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadObjectStores(UserType* output) {
    
    auto* pointer = data_->object_stores.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int64_t, ::blink::mojom::IDBObjectStoreMetadataDataView>>(
        pointer, output, message_);
  }
  bool was_cold_open() const {
    return data_->was_cold_open;
  }
  bool is_sqlite() const {
    return data_->is_sqlite;
  }
 private:
  internal::IDBDatabaseMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBNameAndVersionDataView {
 public:
  IDBNameAndVersionDataView() = default;

  IDBNameAndVersionDataView(
      internal::IDBNameAndVersion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  int64_t version() const {
    return data_->version;
  }
 private:
  internal::IDBNameAndVersion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBIndexKeysDataView {
 public:
  IDBIndexKeysDataView() = default;

  IDBIndexKeysDataView(
      internal::IDBIndexKeys_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t index_id() const {
    return data_->index_id;
  }
  inline void GetIndexKeysDataView(
      mojo::ArrayDataView<IDBKeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIndexKeys(UserType* output) {
    
    auto* pointer = data_->index_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IDBIndexKeys_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBFileInfoDataView {
 public:
  IDBFileInfoDataView() = default;

  IDBFileInfoDataView(
      internal::IDBFileInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastModified(UserType* output) {
    
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::IDBFileInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBBlobInfoDataView {
 public:
  IDBBlobInfoDataView() = default;

  IDBBlobInfoDataView(
      internal::IDBBlobInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetMimeTypeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  int64_t size() const {
    return data_->size;
  }
  inline void GetFileDataView(
      IDBFileInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::IDBFileInfoDataView, UserType>(),
    "Attempting to read the optional `file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFile` instead "
    "of `ReadFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::blink::mojom::IDBFileInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::IDBBlobInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBValueDataView {
 public:
  IDBValueDataView() = default;

  IDBValueDataView(
      internal::IDBValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitsDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBits(UserType* output) {
    
    auto* pointer = !data_->bits.is_null() ? &data_->bits : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  inline void GetExternalObjectsDataView(
      mojo::ArrayDataView<IDBExternalObjectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExternalObjects(UserType* output) {
    
    auto* pointer = data_->external_objects.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::IDBExternalObjectDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IDBValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBReturnValueDataView {
 public:
  IDBReturnValueDataView() = default;

  IDBReturnValueDataView(
      internal::IDBReturnValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      IDBValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::blink::mojom::IDBValueDataView>(
        pointer, output, message_);
  }
  inline void GetPrimaryKeyDataView(
      IDBKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryKey(UserType* output) {
    
    auto* pointer = !data_->primary_key.is_null() ? &data_->primary_key : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        pointer, output, message_);
  }
  inline void GetKeyPathDataView(
      IDBKeyPathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyPath(UserType* output) {
    
    auto* pointer = data_->key_path.Get();
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyPathDataView>(
        pointer, output, message_);
  }
 private:
  internal::IDBReturnValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBRecordDataView {
 public:
  IDBRecordDataView() = default;

  IDBRecordDataView(
      internal::IDBRecord_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrimaryKeyDataView(
      IDBKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::IDBKeyDataView, UserType>(),
    "Attempting to read the optional `primary_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrimaryKey` instead "
    "of `ReadPrimaryKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->primary_key.is_null() ? &data_->primary_key : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        pointer, output, message_);
  }
  inline void GetReturnValueDataView(
      IDBReturnValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReturnValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::IDBReturnValueDataView, UserType>(),
    "Attempting to read the optional `return_value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReturnValue` instead "
    "of `ReadReturnValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->return_value.Get();
    return mojo::internal::Deserialize<::blink::mojom::IDBReturnValueDataView>(
        pointer, output, message_);
  }
  inline void GetIndexKeyDataView(
      IDBKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIndexKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::IDBKeyDataView, UserType>(),
    "Attempting to read the optional `index_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIndexKey` instead "
    "of `ReadIndexKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->index_key.is_null() ? &data_->index_key : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        pointer, output, message_);
  }
 private:
  internal::IDBRecord_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBErrorDataView {
 public:
  IDBErrorDataView() = default;

  IDBErrorDataView(
      internal::IDBError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::blink::mojom::IDBException>(
        data_value, output);
  }
  IDBException error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::IDBException>(data_->error_code));
  }
  inline void GetErrorMessageDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::IDBError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBCursorValueDataView {
 public:
  IDBCursorValueDataView() = default;

  IDBCursorValueDataView(
      internal::IDBCursorValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeysDataView(
      mojo::ArrayDataView<IDBKeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeys(UserType* output) {
    
    auto* pointer = data_->keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
        pointer, output, message_);
  }
  inline void GetPrimaryKeysDataView(
      mojo::ArrayDataView<IDBKeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryKeys(UserType* output) {
    
    auto* pointer = data_->primary_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
        pointer, output, message_);
  }
  inline void GetValuesDataView(
      mojo::ArrayDataView<IDBValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValues(UserType* output) {
    
    auto* pointer = data_->values.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::IDBValueDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IDBCursorValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBDatabaseOpenCursorValueDataView {
 public:
  IDBDatabaseOpenCursorValueDataView() = default;

  IDBDatabaseOpenCursorValueDataView(
      internal::IDBDatabaseOpenCursorValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeCursor() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::IDBCursorAssociatedPtrInfoDataView>(
            &data_->cursor, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetKeyDataView(
      IDBKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = !data_->key.is_null() ? &data_->key : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        pointer, output, message_);
  }
  inline void GetPrimaryKeyDataView(
      IDBKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryKey(UserType* output) {
    
    auto* pointer = !data_->primary_key.is_null() ? &data_->primary_key : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      IDBValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::IDBValueDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::blink::mojom::IDBValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::IDBDatabaseOpenCursorValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IDBKeyDataView {
 public:
  using Tag = internal::IDBKey_Data::IDBKey_Tag;

  IDBKeyDataView() = default;

  IDBKeyDataView(
      internal::IDBKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_key_array() const { return data_->tag == Tag::kKeyArray; }
  inline void GetKeyArrayDataView(
      mojo::ArrayDataView<IDBKeyDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadKeyArray(UserType* output) const {
    
    CHECK(is_key_array());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
        data_->data.f_key_array.Get(), output, message_);
  }
  bool is_binary() const { return data_->tag == Tag::kBinary; }
  inline void GetBinaryDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBinary(UserType* output) const {
    
    CHECK(is_binary());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_binary.Get(), output, message_);
  }
  bool is_string() const { return data_->tag == Tag::kString; }
  inline void GetStringDataView(
      ::mojo_base::mojom::String16DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadString(UserType* output) const {
    
    CHECK(is_string());
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        data_->data.f_string.Get(), output, message_);
  }
  bool is_date() const { return data_->tag == Tag::kDate; }
  double date() const {
    CHECK(is_date());
    return data_->data.f_date;
  }
  bool is_number() const { return data_->tag == Tag::kNumber; }
  double number() const {
    CHECK(is_number());
    return data_->data.f_number;
  }
  bool is_other_none() const { return data_->tag == Tag::kOtherNone; }
  bool other_none() const {
    CHECK(is_other_none());
    return data_->data.f_other_none;
  }

 private:
  internal::IDBKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class IDBKeyPathDataDataView {
 public:
  using Tag = internal::IDBKeyPathData_Data::IDBKeyPathData_Tag;

  IDBKeyPathDataDataView() = default;

  IDBKeyPathDataDataView(
      internal::IDBKeyPathData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_string() const { return data_->tag == Tag::kString; }
  inline void GetStringDataView(
      ::mojo_base::mojom::String16DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadString(UserType* output) const {
    
    CHECK(is_string());
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        data_->data.f_string.Get(), output, message_);
  }
  bool is_string_array() const { return data_->tag == Tag::kStringArray; }
  inline void GetStringArrayDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStringArray(UserType* output) const {
    
    CHECK(is_string_array());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        data_->data.f_string_array.Get(), output, message_);
  }

 private:
  internal::IDBKeyPathData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class IDBExternalObjectDataView {
 public:
  using Tag = internal::IDBExternalObject_Data::IDBExternalObject_Tag;

  IDBExternalObjectDataView() = default;

  IDBExternalObjectDataView(
      internal::IDBExternalObject_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_blob_or_file() const { return data_->tag == Tag::kBlobOrFile; }
  inline void GetBlobOrFileDataView(
      IDBBlobInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBlobOrFile(UserType* output) const {
    
    CHECK(is_blob_or_file());
    return mojo::internal::Deserialize<::blink::mojom::IDBBlobInfoDataView>(
        data_->data.f_blob_or_file.Get(), output, message_);
  }
  bool is_file_system_access_token() const { return data_->tag == Tag::kFileSystemAccessToken; }
  template <typename UserType>
  UserType TakeFileSystemAccessToken() {
    CHECK(is_file_system_access_token());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
            &data_->data.f_file_system_access_token, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::IDBExternalObject_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class IDBCursorResultDataView {
 public:
  using Tag = internal::IDBCursorResult_Data::IDBCursorResult_Tag;

  IDBCursorResultDataView() = default;

  IDBCursorResultDataView(
      internal::IDBCursorResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_result() const { return data_->tag == Tag::kErrorResult; }
  inline void GetErrorResultDataView(
      IDBErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadErrorResult(UserType* output) const {
    
    CHECK(is_error_result());
    return mojo::internal::Deserialize<::blink::mojom::IDBErrorDataView>(
        data_->data.f_error_result.Get(), output, message_);
  }
  bool is_empty() const { return data_->tag == Tag::kEmpty; }
  bool empty() const {
    CHECK(is_empty());
    return data_->data.f_empty;
  }
  bool is_values() const { return data_->tag == Tag::kValues; }
  inline void GetValuesDataView(
      IDBCursorValueDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValues(UserType* output) const {
    
    CHECK(is_values());
    return mojo::internal::Deserialize<::blink::mojom::IDBCursorValueDataView>(
        data_->data.f_values.Get(), output, message_);
  }

 private:
  internal::IDBCursorResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class IDBTransactionPutResultDataView {
 public:
  using Tag = internal::IDBTransactionPutResult_Data::IDBTransactionPutResult_Tag;

  IDBTransactionPutResultDataView() = default;

  IDBTransactionPutResultDataView(
      internal::IDBTransactionPutResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_result() const { return data_->tag == Tag::kErrorResult; }
  inline void GetErrorResultDataView(
      IDBErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadErrorResult(UserType* output) const {
    
    CHECK(is_error_result());
    return mojo::internal::Deserialize<::blink::mojom::IDBErrorDataView>(
        data_->data.f_error_result.Get(), output, message_);
  }
  bool is_key() const { return data_->tag == Tag::kKey; }
  inline void GetKeyDataView(
      IDBKeyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) const {
    
    CHECK(is_key());
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        data_->data.f_key.Get(), output, message_);
  }

 private:
  internal::IDBTransactionPutResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class IDBDatabaseGetResultDataView {
 public:
  using Tag = internal::IDBDatabaseGetResult_Data::IDBDatabaseGetResult_Tag;

  IDBDatabaseGetResultDataView() = default;

  IDBDatabaseGetResultDataView(
      internal::IDBDatabaseGetResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_result() const { return data_->tag == Tag::kErrorResult; }
  inline void GetErrorResultDataView(
      IDBErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadErrorResult(UserType* output) const {
    
    CHECK(is_error_result());
    return mojo::internal::Deserialize<::blink::mojom::IDBErrorDataView>(
        data_->data.f_error_result.Get(), output, message_);
  }
  bool is_empty() const { return data_->tag == Tag::kEmpty; }
  bool empty() const {
    CHECK(is_empty());
    return data_->data.f_empty;
  }
  bool is_key() const { return data_->tag == Tag::kKey; }
  inline void GetKeyDataView(
      IDBKeyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) const {
    
    CHECK(is_key());
    return mojo::internal::Deserialize<::blink::mojom::IDBKeyDataView>(
        data_->data.f_key.Get(), output, message_);
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      IDBReturnValueDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
    CHECK(is_value());
    return mojo::internal::Deserialize<::blink::mojom::IDBReturnValueDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::IDBDatabaseGetResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class IDBDatabaseOpenCursorResultDataView {
 public:
  using Tag = internal::IDBDatabaseOpenCursorResult_Data::IDBDatabaseOpenCursorResult_Tag;

  IDBDatabaseOpenCursorResultDataView() = default;

  IDBDatabaseOpenCursorResultDataView(
      internal::IDBDatabaseOpenCursorResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_result() const { return data_->tag == Tag::kErrorResult; }
  inline void GetErrorResultDataView(
      IDBErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadErrorResult(UserType* output) const {
    
    CHECK(is_error_result());
    return mojo::internal::Deserialize<::blink::mojom::IDBErrorDataView>(
        data_->data.f_error_result.Get(), output, message_);
  }
  bool is_empty() const { return data_->tag == Tag::kEmpty; }
  bool empty() const {
    CHECK(is_empty());
    return data_->data.f_empty;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      IDBDatabaseOpenCursorValueDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
    CHECK(is_value());
    return mojo::internal::Deserialize<::blink::mojom::IDBDatabaseOpenCursorValueDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::IDBDatabaseOpenCursorResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_DATA_VIEW_H_