// third_party/blink/public/mojom/image_downloader/image_downloader.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ImageDownloaderProxy;

template <typename ImplRefTraits>
class ImageDownloaderStub;

class ImageDownloaderRequestValidator;
class ImageDownloaderResponseValidator;


class BLINK_COMMON_EXPORT ImageDownloader
    : public ImageDownloaderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ImageDownloader";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ImageDownloaderInterfaceBase;
  using Proxy_ = ImageDownloaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ImageDownloaderStub<ImplRefTraits>;

  using RequestValidator_ = ImageDownloaderRequestValidator;
  using ResponseValidator_ = ImageDownloaderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDownloadImageMinVersion = 0,
    kDownloadImageFromAxNodeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DownloadImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DownloadImageFromAxNode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ImageDownloader() = default;

  using DownloadImageCallback = base::OnceCallback<void(int32_t, const std::vector<::SkBitmap>&, const std::vector<::gfx::Size>&)>;
  using DownloadImageMojoCallback = base::OnceCallback<void(int32_t, const std::vector<::SkBitmap>&, const std::vector<::gfx::Size>&)>;

  virtual void DownloadImage(const ::GURL& url, bool is_favicon, const ::gfx::Size& preferred_size, uint32_t max_bitmap_size, bool bypass_cache, DownloadImageCallback callback) = 0;

  using DownloadImageFromAxNodeCallback = base::OnceCallback<void(int32_t, const std::vector<::SkBitmap>&, const std::vector<::gfx::Size>&)>;
  using DownloadImageFromAxNodeMojoCallback = base::OnceCallback<void(int32_t, const std::vector<::SkBitmap>&, const std::vector<::gfx::Size>&)>;

  virtual void DownloadImageFromAxNode(int32_t ax_node_id, const ::gfx::Size& preferred_size, uint32_t max_bitmap_size, bool bypass_cache, DownloadImageFromAxNodeCallback callback) = 0;
};



class BLINK_COMMON_EXPORT ImageDownloaderProxy
    : public ImageDownloader {
 public:
  using InterfaceType = ImageDownloader;

  explicit ImageDownloaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DownloadImage(const ::GURL& url, bool is_favicon, const ::gfx::Size& preferred_size, uint32_t max_bitmap_size, bool bypass_cache, DownloadImageCallback callback) final;
  
  void DownloadImageFromAxNode(int32_t ax_node_id, const ::gfx::Size& preferred_size, uint32_t max_bitmap_size, bool bypass_cache, DownloadImageFromAxNodeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ImageDownloaderStubDispatch {
 public:
  static bool Accept(ImageDownloader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ImageDownloader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ImageDownloader>>
class ImageDownloaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ImageDownloaderStub() = default;
  ~ImageDownloaderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageDownloaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageDownloaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ImageDownloaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ImageDownloaderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_H_