// third_party/blink/public/mojom/image_downloader/image_downloader.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ImageDownloaderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ImageDownloader.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ImageDownloaderInterface }
 */
blink.mojom.ImageDownloaderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ImageDownloaderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ImageDownloaderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ImageDownloaderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !boolean } isFavicon
   * @param { !gfx.mojom.Size } preferredSize
   * @param { !number } maxBitmapSize
   * @param { !boolean } bypassCache
   * @return {!Promise<{
        httpStatusCode: !number,
        images: !Array<!skia.mojom.BitmapN32>,
        originalImageSizes: !Array<!gfx.mojom.Size>,
   *  }>}
   */

  downloadImage(
      url,
      isFavicon,
      preferredSize,
      maxBitmapSize,
      bypassCache) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ImageDownloader_DownloadImage_ParamsSpec.$,
        blink.mojom.ImageDownloader_DownloadImage_ResponseParamsSpec.$,
        [
          url,
          isFavicon,
          preferredSize,
          maxBitmapSize,
          bypassCache
        ],
        false);
  }

  
  /**
   * @param { !number } axNodeId
   * @param { !gfx.mojom.Size } preferredSize
   * @param { !number } maxBitmapSize
   * @param { !boolean } bypassCache
   * @return {!Promise<{
        httpStatusCode: !number,
        images: !Array<!skia.mojom.BitmapN32>,
        originalImageSizes: !Array<!gfx.mojom.Size>,
   *  }>}
   */

  downloadImageFromAxNode(
      axNodeId,
      preferredSize,
      maxBitmapSize,
      bypassCache) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.ImageDownloader_DownloadImageFromAxNode_ParamsSpec.$,
        blink.mojom.ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec.$,
        [
          axNodeId,
          preferredSize,
          maxBitmapSize,
          bypassCache
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ImageDownloader
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ImageDownloaderReceiver = class {
  /**
   * @param {!blink.mojom.ImageDownloaderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ImageDownloaderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ImageDownloaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ImageDownloaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ImageDownloader_DownloadImage_ParamsSpec.$,
        blink.mojom.ImageDownloader_DownloadImage_ResponseParamsSpec.$,
        impl.downloadImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ImageDownloader_DownloadImageFromAxNode_ParamsSpec.$,
        blink.mojom.ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec.$,
        impl.downloadImageFromAxNode.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ImageDownloader = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ImageDownloader";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ImageDownloaderRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ImageDownloaderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ImageDownloader
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ImageDownloaderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ImageDownloaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ImageDownloaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ImageDownloader_DownloadImage_ParamsSpec.$,
        blink.mojom.ImageDownloader_DownloadImage_ResponseParamsSpec.$,
        this.downloadImage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadImageFromAxNode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ImageDownloader_DownloadImageFromAxNode_ParamsSpec.$,
        blink.mojom.ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec.$,
        this.downloadImageFromAxNode.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ImageDownloader_DownloadImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ImageDownloader_DownloadImage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ImageDownloader_DownloadImageFromAxNode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ImageDownloader_DownloadImage_ParamsSpec.$,
    'ImageDownloader_DownloadImage_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isFavicon', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preferredSize', 16,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxBitmapSize', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bypassCache', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ImageDownloader_DownloadImage_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !boolean } */
    this.isFavicon;
    /** @export { !gfx.mojom.Size } */
    this.preferredSize;
    /** @export { !number } */
    this.maxBitmapSize;
    /** @export { !boolean } */
    this.bypassCache;
  }
};



mojo.internal.Struct(
    blink.mojom.ImageDownloader_DownloadImage_ResponseParamsSpec.$,
    'ImageDownloader_DownloadImage_ResponseParams',
    [
      mojo.internal.StructField(
        'httpStatusCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'images', 8,
        0,
        mojo.internal.Array(skia.mojom.BitmapN32Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalImageSizes', 16,
        0,
        mojo.internal.Array(gfx.mojom.SizeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ImageDownloader_DownloadImage_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.httpStatusCode;
    /** @export { !Array<!skia.mojom.BitmapN32> } */
    this.images;
    /** @export { !Array<!gfx.mojom.Size> } */
    this.originalImageSizes;
  }
};



mojo.internal.Struct(
    blink.mojom.ImageDownloader_DownloadImageFromAxNode_ParamsSpec.$,
    'ImageDownloader_DownloadImageFromAxNode_Params',
    [
      mojo.internal.StructField(
        'axNodeId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preferredSize', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxBitmapSize', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bypassCache', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ImageDownloader_DownloadImageFromAxNode_Params = class {
  constructor() {
    /** @export { !number } */
    this.axNodeId;
    /** @export { !gfx.mojom.Size } */
    this.preferredSize;
    /** @export { !number } */
    this.maxBitmapSize;
    /** @export { !boolean } */
    this.bypassCache;
  }
};



mojo.internal.Struct(
    blink.mojom.ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec.$,
    'ImageDownloader_DownloadImageFromAxNode_ResponseParams',
    [
      mojo.internal.StructField(
        'httpStatusCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'images', 8,
        0,
        mojo.internal.Array(skia.mojom.BitmapN32Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalImageSizes', 16,
        0,
        mojo.internal.Array(gfx.mojom.SizeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ImageDownloader_DownloadImageFromAxNode_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.httpStatusCode;
    /** @export { !Array<!skia.mojom.BitmapN32> } */
    this.images;
    /** @export { !Array<!gfx.mojom.Size> } */
    this.originalImageSizes;
  }
};

