// third_party/blink/public/mojom/idle/idle_manager.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.TimeDelta');




goog.provide('blink.mojom.IdleManagerError');
goog.provide('blink.mojom.IdleManagerErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IdleManagerErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IdleManagerError = {
  
  kSuccess: 0,
  kPermissionDisabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('blink.mojom.IdleMonitor');
goog.provide('blink.mojom.IdleMonitorReceiver');
goog.provide('blink.mojom.IdleMonitorCallbackRouter');
goog.provide('blink.mojom.IdleMonitorInterface');
goog.provide('blink.mojom.IdleMonitorRemote');
goog.provide('blink.mojom.IdleMonitorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IdleMonitorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IdleMonitor.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IdleMonitorInterface = class {
  
  /**
   * @param { !blink.mojom.IdleState } state
   * @param { !boolean } isOverriddenByDevtools
   */

  update(state, isOverriddenByDevtools) {}
};

/**
 * @export
 * @implements { blink.mojom.IdleMonitorInterface }
 */
blink.mojom.IdleMonitorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IdleMonitorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IdleMonitorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IdleMonitorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.IdleState } state
   * @param { !boolean } isOverriddenByDevtools
   */

  update(
      state,
      isOverriddenByDevtools) {
    this.proxy.sendMessage(
        0,
        blink.mojom.IdleMonitor_Update_ParamsSpec.$,
        null,
        [
          state,
          isOverriddenByDevtools
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IdleMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IdleMonitorReceiver = class {
  /**
   * @param {!blink.mojom.IdleMonitorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IdleMonitorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IdleMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IdleMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IdleMonitor_Update_ParamsSpec.$,
        null,
        impl.update.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IdleMonitor = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IdleMonitor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IdleMonitorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IdleMonitorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IdleMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IdleMonitorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IdleMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IdleMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.update =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IdleMonitor_Update_ParamsSpec.$,
        null,
        this.update.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IdleManager');
goog.provide('blink.mojom.IdleManagerReceiver');
goog.provide('blink.mojom.IdleManagerCallbackRouter');
goog.provide('blink.mojom.IdleManagerInterface');
goog.provide('blink.mojom.IdleManagerRemote');
goog.provide('blink.mojom.IdleManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IdleManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IdleManager.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IdleManagerInterface = class {
  
  /**
   * @param { !blink.mojom.IdleMonitorRemote } monitor
   * @return {!Promise<{
        error: !blink.mojom.IdleManagerError,
        state: ?blink.mojom.IdleState,
   *  }>}
   */

  addMonitor(monitor) {}
};

/**
 * @export
 * @implements { blink.mojom.IdleManagerInterface }
 */
blink.mojom.IdleManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IdleManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IdleManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IdleManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.IdleMonitorRemote } monitor
   * @return {!Promise<{
        error: !blink.mojom.IdleManagerError,
        state: ?blink.mojom.IdleState,
   *  }>}
   */

  addMonitor(
      monitor) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.IdleManager_AddMonitor_ParamsSpec.$,
        blink.mojom.IdleManager_AddMonitor_ResponseParamsSpec.$,
        [
          monitor
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IdleManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IdleManagerReceiver = class {
  /**
   * @param {!blink.mojom.IdleManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IdleManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IdleManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IdleManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IdleManager_AddMonitor_ParamsSpec.$,
        blink.mojom.IdleManager_AddMonitor_ResponseParamsSpec.$,
        impl.addMonitor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IdleManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IdleManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IdleManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IdleManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IdleManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IdleManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IdleManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IdleManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMonitor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IdleManager_AddMonitor_ParamsSpec.$,
        blink.mojom.IdleManager_AddMonitor_ResponseParamsSpec.$,
        this.addMonitor.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IdleStateSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdleStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IdleMonitor_Update_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdleMonitor_Update_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IdleManager_AddMonitor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdleManager_AddMonitor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IdleManager_AddMonitor_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdleManager_AddMonitor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.IdleStateSpec.$,
    'IdleState',
    [
      mojo.internal.StructField(
        'idleTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'screenLocked', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IdleState');

/** @record */
blink.mojom.IdleState = class {
  constructor() {
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.idleTime;
    /** @export { !boolean } */
    this.screenLocked;
  }
};



mojo.internal.Struct(
    blink.mojom.IdleMonitor_Update_ParamsSpec.$,
    'IdleMonitor_Update_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.IdleStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isOverriddenByDevtools', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IdleMonitor_Update_Params');

/** @record */
blink.mojom.IdleMonitor_Update_Params = class {
  constructor() {
    /** @export { !blink.mojom.IdleState } */
    this.state;
    /** @export { !boolean } */
    this.isOverriddenByDevtools;
  }
};



mojo.internal.Struct(
    blink.mojom.IdleManager_AddMonitor_ParamsSpec.$,
    'IdleManager_AddMonitor_Params',
    [
      mojo.internal.StructField(
        'monitor', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.IdleMonitorRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IdleManager_AddMonitor_Params');

/** @record */
blink.mojom.IdleManager_AddMonitor_Params = class {
  constructor() {
    /** @export { !blink.mojom.IdleMonitorRemote } */
    this.monitor;
  }
};



mojo.internal.Struct(
    blink.mojom.IdleManager_AddMonitor_ResponseParamsSpec.$,
    'IdleManager_AddMonitor_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.IdleManagerErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'state', 8,
        0,
        blink.mojom.IdleStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IdleManager_AddMonitor_ResponseParams');

/** @record */
blink.mojom.IdleManager_AddMonitor_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.IdleManagerError } */
    this.error;
    /** @export { (blink.mojom.IdleState|undefined) } */
    this.state;
  }
};

