// third_party/blink/public/mojom/hid/hid.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/hid/hid.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-params-data.h"
#include "third_party/blink/public/mojom/hid/hid.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-import-headers.h"
#include "third_party/blink/public/mojom/hid/hid.mojom-test-utils.h"


namespace blink::mojom {
VendorAndProduct::VendorAndProduct()
    : vendor(),
      product() {}

VendorAndProduct::VendorAndProduct(
    uint16_t vendor_in,
    uint16_t product_in)
    : vendor(std::move(vendor_in)),
      product(std::move(product_in)) {}

VendorAndProduct::~VendorAndProduct() = default;
size_t VendorAndProduct::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->vendor);
  seed = mojo::internal::Hash(seed, this->product);
  return seed;
}

void VendorAndProduct::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor"), this->vendor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product"), this->product,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VendorAndProduct::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HidDeviceFilter::HidDeviceFilter()
    : device_ids(),
      usage() {}

HidDeviceFilter::HidDeviceFilter(
    DeviceIdFilterPtr device_ids_in,
    UsageFilterPtr usage_in)
    : device_ids(std::move(device_ids_in)),
      usage(std::move(usage_in)) {}

HidDeviceFilter::~HidDeviceFilter() = default;

void HidDeviceFilter::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_ids"), this->device_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DeviceIdFilterPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UsageFilterPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HidDeviceFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeviceIdFilterPtr
DeviceIdFilter::NewVendor(
    uint16_t value) {
  return DeviceIdFilterPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kVendor)>,
      std::move(value));
}

DeviceIdFilterPtr
DeviceIdFilter::NewVendorAndProduct(
    VendorAndProductPtr value) {
  return DeviceIdFilterPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kVendorAndProduct)>,
      std::move(value));
}

DeviceIdFilter::DeviceIdFilter(
    std::in_place_index_t<static_cast<size_t>(Tag::kVendor)>,
    uint16_t value)
    : tag_(Tag::kVendor),
      data_(std::in_place_index<static_cast<size_t>(Tag::kVendor)>,
            std::move(value)) {}

DeviceIdFilter::DeviceIdFilter(
    std::in_place_index_t<static_cast<size_t>(Tag::kVendorAndProduct)>,
    VendorAndProductPtr value)
    : tag_(Tag::kVendorAndProduct),
      data_(std::in_place_index<static_cast<size_t>(Tag::kVendorAndProduct)>,
            std::move(value)) {}
DeviceIdFilter::~DeviceIdFilter() {
  DestroyActive();
}

void DeviceIdFilter::set_vendor(uint16_t vendor) {
  if (tag_ != Tag::kVendor) {
    DestroyActive();
    tag_ = Tag::kVendor;
  }
  data_.vendor = vendor;
}

void DeviceIdFilter::set_vendor_and_product(VendorAndProductPtr vendor_and_product) {
  if (tag_ == Tag::kVendorAndProduct) {
    data_.vendor_and_product = std::move(vendor_and_product);
  } else {
    DestroyActive();
    tag_ = Tag::kVendorAndProduct;
    new (&data_.vendor_and_product) VendorAndProductPtr(
        std::move(vendor_and_product));
  }
}


DeviceIdFilter::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kVendor)>,
    uint16_t value)
    : vendor(std::move(value)) {}

DeviceIdFilter::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kVendorAndProduct)>,
    VendorAndProductPtr value)
    : vendor_and_product(std::move(value)) {}

void DeviceIdFilter::DestroyActive() {
  switch (tag_) {

    case Tag::kVendor:
      std::destroy_at(&data_.vendor);
      break;
    case Tag::kVendorAndProduct:
      std::destroy_at(&data_.vendor_and_product);
      break;
  }
}
size_t DeviceIdFilter::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kVendor:
      return mojo::internal::Hash(seed, data_.vendor);
    case Tag::kVendorAndProduct:
      return mojo::internal::Hash(seed, data_.vendor_and_product);
    default:
      NOTREACHED();
  }
}

bool DeviceIdFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
UsageFilterPtr
UsageFilter::NewPage(
    uint16_t value) {
  return UsageFilterPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPage)>,
      std::move(value));
}

UsageFilterPtr
UsageFilter::NewUsageAndPage(
    ::device::mojom::HidUsageAndPagePtr value) {
  return UsageFilterPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUsageAndPage)>,
      std::move(value));
}

UsageFilter::UsageFilter(
    std::in_place_index_t<static_cast<size_t>(Tag::kPage)>,
    uint16_t value)
    : tag_(Tag::kPage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPage)>,
            std::move(value)) {}

UsageFilter::UsageFilter(
    std::in_place_index_t<static_cast<size_t>(Tag::kUsageAndPage)>,
    ::device::mojom::HidUsageAndPagePtr value)
    : tag_(Tag::kUsageAndPage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUsageAndPage)>,
            std::move(value)) {}
UsageFilter::~UsageFilter() {
  DestroyActive();
}

void UsageFilter::set_page(uint16_t page) {
  if (tag_ != Tag::kPage) {
    DestroyActive();
    tag_ = Tag::kPage;
  }
  data_.page = page;
}

void UsageFilter::set_usage_and_page(::device::mojom::HidUsageAndPagePtr usage_and_page) {
  if (tag_ == Tag::kUsageAndPage) {
    data_.usage_and_page = std::move(usage_and_page);
  } else {
    DestroyActive();
    tag_ = Tag::kUsageAndPage;
    new (&data_.usage_and_page) ::device::mojom::HidUsageAndPagePtr(
        std::move(usage_and_page));
  }
}


UsageFilter::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPage)>,
    uint16_t value)
    : page(std::move(value)) {}

UsageFilter::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUsageAndPage)>,
    ::device::mojom::HidUsageAndPagePtr value)
    : usage_and_page(std::move(value)) {}

void UsageFilter::DestroyActive() {
  switch (tag_) {

    case Tag::kPage:
      std::destroy_at(&data_.page);
      break;
    case Tag::kUsageAndPage:
      std::destroy_at(&data_.usage_and_page);
      break;
  }
}
size_t UsageFilter::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kPage:
      return mojo::internal::Hash(seed, data_.page);
    case Tag::kUsageAndPage:
      return mojo::internal::Hash(seed, data_.usage_and_page);
    default:
      NOTREACHED();
  }
}

bool UsageFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

HidService::IPCStableHashFunction HidService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HidService>(message.name())) {
    case messages::HidService::kRegisterClient: {
      return &HidService::RegisterClient_Sym::IPCStableHash;
    }
    case messages::HidService::kGetDevices: {
      return &HidService::GetDevices_Sym::IPCStableHash;
    }
    case messages::HidService::kRequestDevice: {
      return &HidService::RequestDevice_Sym::IPCStableHash;
    }
    case messages::HidService::kConnect: {
      return &HidService::Connect_Sym::IPCStableHash;
    }
    case messages::HidService::kForget: {
      return &HidService::Forget_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HidService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HidService>(message.name())) {
      case messages::HidService::kRegisterClient:
            return "Receive blink::mojom::HidService::RegisterClient";
      case messages::HidService::kGetDevices:
            return "Receive blink::mojom::HidService::GetDevices";
      case messages::HidService::kRequestDevice:
            return "Receive blink::mojom::HidService::RequestDevice";
      case messages::HidService::kConnect:
            return "Receive blink::mojom::HidService::Connect";
      case messages::HidService::kForget:
            return "Receive blink::mojom::HidService::Forget";
    }
  } else {
    switch (static_cast<messages::HidService>(message.name())) {
      case messages::HidService::kRegisterClient:
            return "Receive reply blink::mojom::HidService::RegisterClient";
      case messages::HidService::kGetDevices:
            return "Receive reply blink::mojom::HidService::GetDevices";
      case messages::HidService::kRequestDevice:
            return "Receive reply blink::mojom::HidService::RequestDevice";
      case messages::HidService::kConnect:
            return "Receive reply blink::mojom::HidService::Connect";
      case messages::HidService::kForget:
            return "Receive reply blink::mojom::HidService::Forget";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HidService::RegisterClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe86edb92;  // IPCStableHash for blink::mojom::HidService::RegisterClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidService::GetDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd6b88ffb;  // IPCStableHash for blink::mojom::HidService::GetDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidService::RequestDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9868aaa;  // IPCStableHash for blink::mojom::HidService::RequestDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidService::Connect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc55019c6;  // IPCStableHash for blink::mojom::HidService::Connect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidService::Forget_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23c89796;  // IPCStableHash for blink::mojom::HidService::Forget
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HidService_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidService_GetDevices_ForwardToCallback(
      HidService::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidService_GetDevices_ForwardToCallback(const HidService_GetDevices_ForwardToCallback&) = delete;
  HidService_GetDevices_ForwardToCallback& operator=(const HidService_GetDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidService::GetDevicesCallback callback_;
};

class HidService_RequestDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidService_RequestDevice_ForwardToCallback(
      HidService::RequestDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidService_RequestDevice_ForwardToCallback(const HidService_RequestDevice_ForwardToCallback&) = delete;
  HidService_RequestDevice_ForwardToCallback& operator=(const HidService_RequestDevice_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidService::RequestDeviceCallback callback_;
};

class HidService_Connect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidService_Connect_ForwardToCallback(
      HidService::ConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidService_Connect_ForwardToCallback(const HidService_Connect_ForwardToCallback&) = delete;
  HidService_Connect_ForwardToCallback& operator=(const HidService_Connect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidService::ConnectCallback callback_;
};

class HidService_Forget_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidService_Forget_ForwardToCallback(
      HidService::ForgetCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidService_Forget_ForwardToCallback(const HidService_Forget_ForwardToCallback&) = delete;
  HidService_Forget_ForwardToCallback& operator=(const HidService_Forget_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidService::ForgetCallback callback_;
};

HidServiceProxy::HidServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HidServiceProxy::RegisterClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::HidManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::HidService::RegisterClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::device::mojom::HidManagerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kRegisterClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_RegisterClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::HidManagerClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in HidService.RegisterClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("RegisterClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HidServiceProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::HidService::GetDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidService_GetDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidServiceProxy::RequestDevice(
    std::vector<HidDeviceFilterPtr> in_filters, std::vector<HidDeviceFilterPtr> in_exclusion_filters, RequestDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::HidService::RequestDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filters"), in_filters,
                        "<value of type std::vector<HidDeviceFilterPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exclusion_filters"), in_exclusion_filters,
                        "<value of type std::vector<HidDeviceFilterPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kRequestDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_RequestDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filters)::BaseType>
      filters_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::HidDeviceFilterDataView>>(
    in_filters,
    filters_fragment,
    &filters_validate_params);

  params->filters.Set(
      filters_fragment.is_null() ? nullptr : filters_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filters.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filters in HidService.RequestDevice request");
  mojo::internal::MessageFragment<
      typename decltype(params->exclusion_filters)::BaseType>
      exclusion_filters_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& exclusion_filters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::HidDeviceFilterDataView>>(
    in_exclusion_filters,
    exclusion_filters_fragment,
    &exclusion_filters_validate_params);

  params->exclusion_filters.Set(
      exclusion_filters_fragment.is_null() ? nullptr : exclusion_filters_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->exclusion_filters.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null exclusion_filters in HidService.RequestDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("RequestDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidService_RequestDevice_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidServiceProxy::Connect(
    const std::string& in_device_guid, ::mojo::PendingRemote<::device::mojom::HidConnectionClient> in_client, ConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::HidService::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_guid"), in_device_guid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::device::mojom::HidConnectionClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_guid)::BaseType> device_guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_guid,
    device_guid_fragment);

  params->device_guid.Set(
      device_guid_fragment.is_null() ? nullptr : device_guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_guid in HidService.Connect request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::HidConnectionClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in HidService.Connect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("Connect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidService_Connect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidServiceProxy::Forget(
    ::device::mojom::HidDeviceInfoPtr in_device_info, ForgetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::HidService::Forget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type ::device::mojom::HidDeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kForget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_Forget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::HidDeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in HidService.Forget request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("Forget");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidService_Forget_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class HidService_GetDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidService::GetDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidService_GetDevices_ProxyToResponder> proxy(
        new HidService_GetDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidService_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidService_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidService_GetDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidService::GetDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::device::mojom::HidDeviceInfoPtr> in_devices);
};

bool HidService_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidService_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidService_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidService.1
  bool success = true;
  std::vector<::device::mojom::HidDeviceInfoPtr> p_devices{};
  HidService_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_devices));
  }
  return true;
}

void HidService_GetDevices_ProxyToResponder::Run(
    std::vector<::device::mojom::HidDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::HidService::GetDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type std::vector<::device::mojom::HidDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidDeviceInfoDataView>>(
    in_devices,
    devices_fragment,
    &devices_validate_params);

  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidService_RequestDevice_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidService::RequestDeviceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidService_RequestDevice_ProxyToResponder> proxy(
        new HidService_RequestDevice_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidService_RequestDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidService_RequestDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidService_RequestDevice_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidService::RequestDeviceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::device::mojom::HidDeviceInfoPtr> in_devices);
};

bool HidService_RequestDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidService_RequestDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidService_RequestDevice_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidService.2
  bool success = true;
  std::vector<::device::mojom::HidDeviceInfoPtr> p_devices{};
  HidService_RequestDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_devices));
  }
  return true;
}

void HidService_RequestDevice_ProxyToResponder::Run(
    std::vector<::device::mojom::HidDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::HidService::RequestDevice", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type std::vector<::device::mojom::HidDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kRequestDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_RequestDevice_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidDeviceInfoDataView>>(
    in_devices,
    devices_fragment,
    &devices_validate_params);

  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("RequestDevice");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidService_Connect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidService::ConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidService_Connect_ProxyToResponder> proxy(
        new HidService_Connect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidService_Connect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidService_Connect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidService_Connect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidService::ConnectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::device::mojom::HidConnection> in_connection);
};

bool HidService_Connect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidService_Connect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidService_Connect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidService.3
  bool success = true;
  ::mojo::PendingRemote<::device::mojom::HidConnection> p_connection{};
  HidService_Connect_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_connection =
        input_data_view.TakeConnection<decltype(p_connection)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_connection));
  }
  return true;
}

void HidService_Connect_ProxyToResponder::Run(
    ::mojo::PendingRemote<::device::mojom::HidConnection> in_connection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::HidService::Connect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection"), in_connection,
                        "<value of type ::mojo::PendingRemote<::device::mojom::HidConnection>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_Connect_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::HidConnectionInterfaceBase>>(
    in_connection,
    &params->connection,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("Connect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidService_Forget_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidService::ForgetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidService_Forget_ProxyToResponder> proxy(
        new HidService_Forget_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidService_Forget_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidService_Forget_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidService_Forget_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidService::ForgetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool HidService_Forget_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidService_Forget_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidService_Forget_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidService.4
  bool success = true;
  HidService_Forget_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void HidService_Forget_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::HidService::Forget");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidService::kForget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_Forget_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("Forget");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HidServiceStubDispatch::Accept(
    HidService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HidService>(message->header()->name)) {
    case messages::HidService::kRegisterClient: {
      DCHECK(message->is_serialized());
      internal::HidService_RegisterClient_Params_Data* params =
          reinterpret_cast<internal::HidService_RegisterClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HidService.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<::device::mojom::HidManagerClient> p_client{};
      HidService_RegisterClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterClient(        
        std::move(p_client));
      return true;
    }
    case messages::HidService::kGetDevices: {
      break;
    }
    case messages::HidService::kRequestDevice: {
      break;
    }
    case messages::HidService::kConnect: {
      break;
    }
    case messages::HidService::kForget: {
      break;
    }
  }
  return false;
}

// static
bool HidServiceStubDispatch::AcceptWithResponder(
    HidService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HidService>(message->header()->name)) {
    case messages::HidService::kRegisterClient: {
      break;
    }
    case messages::HidService::kGetDevices: {
      internal::HidService_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::HidService_GetDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidService.1
      bool success = true;
      HidService_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 1, false);
        return false;
      }
      auto callback =
          HidService_GetDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
    case messages::HidService::kRequestDevice: {
      internal::HidService_RequestDevice_Params_Data* params =
          reinterpret_cast<
              internal::HidService_RequestDevice_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidService.2
      bool success = true;
      std::vector<HidDeviceFilterPtr> p_filters{};
      std::vector<HidDeviceFilterPtr> p_exclusion_filters{};
      HidService_RequestDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilters(&p_filters))
        success = false;
      if (success && !input_data_view.ReadExclusionFilters(&p_exclusion_filters))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 2, false);
        return false;
      }
      auto callback =
          HidService_RequestDevice_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDevice(        
        std::move(p_filters), 
        std::move(p_exclusion_filters), std::move(callback));
      return true;
    }
    case messages::HidService::kConnect: {
      internal::HidService_Connect_Params_Data* params =
          reinterpret_cast<
              internal::HidService_Connect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidService.3
      bool success = true;
      std::string p_device_guid{};
      ::mojo::PendingRemote<::device::mojom::HidConnectionClient> p_client{};
      HidService_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceGuid(&p_device_guid))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 3, false);
        return false;
      }
      auto callback =
          HidService_Connect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_device_guid), 
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::HidService::kForget: {
      internal::HidService_Forget_Params_Data* params =
          reinterpret_cast<
              internal::HidService_Forget_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidService.4
      bool success = true;
      ::device::mojom::HidDeviceInfoPtr p_device_info{};
      HidService_Forget_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 4, false);
        return false;
      }
      auto callback =
          HidService_Forget_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Forget(        
        std::move(p_device_info), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHidServiceValidationInfo[] = {
    { &internal::HidService_RegisterClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HidService_GetDevices_Params_Data::Validate,
     &internal::HidService_GetDevices_ResponseParams_Data::Validate},
    { &internal::HidService_RequestDevice_Params_Data::Validate,
     &internal::HidService_RequestDevice_ResponseParams_Data::Validate},
    { &internal::HidService_Connect_Params_Data::Validate,
     &internal::HidService_Connect_ResponseParams_Data::Validate},
    { &internal::HidService_Forget_Params_Data::Validate,
     &internal::HidService_Forget_ResponseParams_Data::Validate},
};

bool HidServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::HidService::Name_,
    kHidServiceValidationInfo);
}

bool HidServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::HidService::Name_,
    kHidServiceValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::VendorAndProduct::DataView, ::blink::mojom::VendorAndProductPtr>::Read(
    ::blink::mojom::VendorAndProduct::DataView input,
    ::blink::mojom::VendorAndProductPtr* output) {
  bool success = true;
  ::blink::mojom::VendorAndProductPtr result(::blink::mojom::VendorAndProduct::New());
  
      if (success)
        result->vendor = input.vendor();
      if (success)
        result->product = input.product();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::HidDeviceFilter::DataView, ::blink::mojom::HidDeviceFilterPtr>::Read(
    ::blink::mojom::HidDeviceFilter::DataView input,
    ::blink::mojom::HidDeviceFilterPtr* output) {
  bool success = true;
  ::blink::mojom::HidDeviceFilterPtr result(::blink::mojom::HidDeviceFilter::New());
  
      if (success && !input.ReadDeviceIds(&result->device_ids))
        success = false;
      if (success && !input.ReadUsage(&result->usage))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::DeviceIdFilter::DataView, ::blink::mojom::DeviceIdFilterPtr>::Read(
    ::blink::mojom::DeviceIdFilter::DataView input,
    ::blink::mojom::DeviceIdFilterPtr* output) {
  using UnionType = ::blink::mojom::DeviceIdFilter;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kVendor: {
      *output = UnionType::NewVendor(input.vendor());
      break;
    }
    case Tag::kVendorAndProduct: {
      ::blink::mojom::VendorAndProductPtr result_vendor_and_product{};
      if (!input.ReadVendorAndProduct(&result_vendor_and_product))
        return false;

      *output = UnionType::NewVendorAndProduct(
          std::move(result_vendor_and_product));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::UsageFilter::DataView, ::blink::mojom::UsageFilterPtr>::Read(
    ::blink::mojom::UsageFilter::DataView input,
    ::blink::mojom::UsageFilterPtr* output) {
  using UnionType = ::blink::mojom::UsageFilter;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPage: {
      *output = UnionType::NewPage(input.page());
      break;
    }
    case Tag::kUsageAndPage: {
      ::device::mojom::HidUsageAndPagePtr result_usage_and_page{};
      if (!input.ReadUsageAndPage(&result_usage_and_page))
        return false;

      *output = UnionType::NewUsageAndPage(
          std::move(result_usage_and_page));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void HidServiceInterceptorForTesting::RegisterClient(::mojo::PendingAssociatedRemote<::device::mojom::HidManagerClient> client) {
  GetForwardingInterface()->RegisterClient(
    std::move(client)
    );
}
void HidServiceInterceptorForTesting::GetDevices(GetDevicesCallback callback) {
  GetForwardingInterface()->GetDevices(std::move(callback));
}
void HidServiceInterceptorForTesting::RequestDevice(std::vector<HidDeviceFilterPtr> filters, std::vector<HidDeviceFilterPtr> exclusion_filters, RequestDeviceCallback callback) {
  GetForwardingInterface()->RequestDevice(
    std::move(filters)
    , 
    std::move(exclusion_filters)
    , std::move(callback));
}
void HidServiceInterceptorForTesting::Connect(const std::string& device_guid, ::mojo::PendingRemote<::device::mojom::HidConnectionClient> client, ConnectCallback callback) {
  GetForwardingInterface()->Connect(
    std::move(device_guid)
    , 
    std::move(client)
    , std::move(callback));
}
void HidServiceInterceptorForTesting::Forget(::device::mojom::HidDeviceInfoPtr device_info, ForgetCallback callback) {
  GetForwardingInterface()->Forget(
    std::move(device_info)
    , std::move(callback));
}
HidServiceAsyncWaiter::HidServiceAsyncWaiter(
    HidService* proxy) : proxy_(proxy) {}

HidServiceAsyncWaiter::~HidServiceAsyncWaiter() = default;


void HidServiceAsyncWaiter::GetDevices(
    std::vector<::device::mojom::HidDeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::device::mojom::HidDeviceInfoPtr>* out_devices
,
             std::vector<::device::mojom::HidDeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

std::vector<::device::mojom::HidDeviceInfoPtr> HidServiceAsyncWaiter::GetDevices(
    ) {
  std::vector<::device::mojom::HidDeviceInfoPtr> async_wait_result;
  GetDevices(&async_wait_result);
  return async_wait_result;
}

void HidServiceAsyncWaiter::RequestDevice(
    std::vector<HidDeviceFilterPtr> filters, std::vector<HidDeviceFilterPtr> exclusion_filters, std::vector<::device::mojom::HidDeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->RequestDevice(
      std::move(filters),
      std::move(exclusion_filters),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::device::mojom::HidDeviceInfoPtr>* out_devices
,
             std::vector<::device::mojom::HidDeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

std::vector<::device::mojom::HidDeviceInfoPtr> HidServiceAsyncWaiter::RequestDevice(
    std::vector<HidDeviceFilterPtr> filters, std::vector<HidDeviceFilterPtr> exclusion_filters) {
  std::vector<::device::mojom::HidDeviceInfoPtr> async_wait_result;
  RequestDevice(std::move(filters),std::move(exclusion_filters),&async_wait_result);
  return async_wait_result;
}

void HidServiceAsyncWaiter::Connect(
    const std::string& device_guid, ::mojo::PendingRemote<::device::mojom::HidConnectionClient> client, ::mojo::PendingRemote<::device::mojom::HidConnection>* out_connection) {
  base::RunLoop loop;
  proxy_->Connect(
      std::move(device_guid),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<::device::mojom::HidConnection>* out_connection
,
             ::mojo::PendingRemote<::device::mojom::HidConnection> connection) {*out_connection = std::move(connection);
            loop->Quit();
          },
          &loop,
          out_connection));
  loop.Run();
}

::mojo::PendingRemote<::device::mojom::HidConnection> HidServiceAsyncWaiter::Connect(
    const std::string& device_guid, ::mojo::PendingRemote<::device::mojom::HidConnectionClient> client) {
  ::mojo::PendingRemote<::device::mojom::HidConnection> async_wait_result;
  Connect(std::move(device_guid),std::move(client),&async_wait_result);
  return async_wait_result;
}

void HidServiceAsyncWaiter::Forget(
    ::device::mojom::HidDeviceInfoPtr device_info) {
  base::RunLoop loop;
  proxy_->Forget(
      std::move(device_info),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif