// third_party/blink/public/mojom/hid/hid.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/hid/hid.mojom-shared-internal.h"
#include "services/device/public/mojom/hid.mojom-shared.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::VendorAndProductDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::VendorAndProductDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::VendorAndProduct_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->vendor = Traits::vendor(input);

      fragment->product = Traits::product(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::HidDeviceFilterDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HidDeviceFilterDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HidDeviceFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::device_ids(input)) in_device_ids = Traits::device_ids(input);
      mojo::internal::MessageFragment<decltype(fragment->device_ids)>
          device_ids_fragment(fragment.message());
      device_ids_fragment.Claim(&fragment->device_ids);
      
      mojo::internal::Serialize<::blink::mojom::DeviceIdFilterDataView, send_validation>(
        in_device_ids,
        device_ids_fragment,
        true);

      decltype(Traits::usage(input)) in_usage = Traits::usage(input);
      mojo::internal::MessageFragment<decltype(fragment->usage)>
          usage_fragment(fragment.message());
      usage_fragment.Claim(&fragment->usage);
      
      mojo::internal::Serialize<::blink::mojom::UsageFilterDataView, send_validation>(
        in_usage,
        usage_fragment,
        true);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DeviceIdFilterDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DeviceIdFilterDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::DeviceIdFilter_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::DeviceIdFilterDataView::Tag::kVendor: {
    decltype(Traits::vendor(input))
    in_vendor = Traits::vendor(input);
    fragment->data.f_vendor = in_vendor;
    break;
  }
  case ::blink::mojom::DeviceIdFilterDataView::Tag::kVendorAndProduct: {
    decltype(Traits::vendor_and_product(input))
    in_vendor_and_product = Traits::vendor_and_product(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_vendor_and_product)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::VendorAndProductDataView, send_validation>(
  in_vendor_and_product,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null vendor_and_product in DeviceIdFilter union");
    fragment->data.f_vendor_and_product.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::UsageFilterDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::UsageFilterDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::UsageFilter_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::UsageFilterDataView::Tag::kPage: {
    decltype(Traits::page(input))
    in_page = Traits::page(input);
    fragment->data.f_page = in_page;
    break;
  }
  case ::blink::mojom::UsageFilterDataView::Tag::kUsageAndPage: {
    decltype(Traits::usage_and_page(input))
    in_usage_and_page = Traits::usage_and_page(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_usage_and_page)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView, send_validation>(
  in_usage_and_page,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null usage_and_page in UsageFilter union");
    fragment->data.f_usage_and_page.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SEND_VALIDATION_H_