// third_party/blink/public/mojom/hid/hid.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.HidServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.HidService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.HidServiceInterface }
 */
blink.mojom.HidServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.HidServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.HidServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.HidServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   */

  registerClient(
      client) {
    this.proxy.sendMessage(
        0,
        blink.mojom.HidService_RegisterClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        devices: !Array<!device.mojom.HidDeviceInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.HidService_GetDevices_ParamsSpec.$,
        blink.mojom.HidService_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.HidDeviceFilter> } filters
   * @param { !Array<!blink.mojom.HidDeviceFilter> } exclusionFilters
   * @return {!Promise<{
        devices: !Array<!device.mojom.HidDeviceInfo>,
   *  }>}
   */

  requestDevice(
      filters,
      exclusionFilters) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.HidService_RequestDevice_ParamsSpec.$,
        blink.mojom.HidService_RequestDevice_ResponseParamsSpec.$,
        [
          filters,
          exclusionFilters
        ],
        false);
  }

  
  /**
   * @param { !string } deviceGuid
   * @param { !device.mojom.HidConnectionClientRemote } client
   * @return {!Promise<{
        connection: ?device.mojom.HidConnectionRemote,
   *  }>}
   */

  connect(
      deviceGuid,
      client) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.HidService_Connect_ParamsSpec.$,
        blink.mojom.HidService_Connect_ResponseParamsSpec.$,
        [
          deviceGuid,
          client
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.HidDeviceInfo } deviceInfo
   * @return {!Promise}
   */

  forget(
      deviceInfo) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.HidService_Forget_ParamsSpec.$,
        blink.mojom.HidService_Forget_ResponseParamsSpec.$,
        [
          deviceInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HidService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.HidServiceReceiver = class {
  /**
   * @param {!blink.mojom.HidServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.HidServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.HidServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.HidServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.HidService_RegisterClient_ParamsSpec.$,
        null,
        impl.registerClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.HidService_GetDevices_ParamsSpec.$,
        blink.mojom.HidService_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.HidService_RequestDevice_ParamsSpec.$,
        blink.mojom.HidService_RequestDevice_ResponseParamsSpec.$,
        impl.requestDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.HidService_Connect_ParamsSpec.$,
        blink.mojom.HidService_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.HidService_Forget_ParamsSpec.$,
        blink.mojom.HidService_Forget_ResponseParamsSpec.$,
        impl.forget.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.HidService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.HidService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.HidServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.HidServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HidService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.HidServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.HidServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.HidServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.HidService_RegisterClient_ParamsSpec.$,
        null,
        this.registerClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.HidService_GetDevices_ParamsSpec.$,
        blink.mojom.HidService_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.HidService_RequestDevice_ParamsSpec.$,
        blink.mojom.HidService_RequestDevice_ResponseParamsSpec.$,
        this.requestDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.HidService_Connect_ParamsSpec.$,
        blink.mojom.HidService_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.HidService_Forget_ParamsSpec.$,
        blink.mojom.HidService_Forget_ResponseParamsSpec.$,
        this.forget.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.VendorAndProductSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidDeviceFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_RegisterClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_RequestDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_RequestDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_Forget_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HidService_Forget_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.DeviceIdFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.UsageFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.VendorAndProductSpec.$,
    'VendorAndProduct',
    [
      mojo.internal.StructField(
        'vendor', 0,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'product', 2,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.VendorAndProduct = class {
  constructor() {
    /** @export { !number } */
    this.vendor;
    /** @export { !number } */
    this.product;
  }
};



mojo.internal.Struct(
    blink.mojom.HidDeviceFilterSpec.$,
    'HidDeviceFilter',
    [
      mojo.internal.StructField(
        'deviceIds', 0,
        0,
        blink.mojom.DeviceIdFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usage', 16,
        0,
        blink.mojom.UsageFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.HidDeviceFilter = class {
  constructor() {
    /** @export { (blink.mojom.DeviceIdFilter|undefined) } */
    this.deviceIds;
    /** @export { (blink.mojom.UsageFilter|undefined) } */
    this.usage;
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_RegisterClient_ParamsSpec.$,
    'HidService_RegisterClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device.mojom.HidManagerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.HidService_RegisterClient_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_GetDevices_ParamsSpec.$,
    'HidService_GetDevices_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.HidService_GetDevices_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_GetDevices_ResponseParamsSpec.$,
    'HidService_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device.mojom.HidDeviceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.HidService_GetDevices_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.HidDeviceInfo> } */
    this.devices;
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_RequestDevice_ParamsSpec.$,
    'HidService_RequestDevice_Params',
    [
      mojo.internal.StructField(
        'filters', 0,
        0,
        mojo.internal.Array(blink.mojom.HidDeviceFilterSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exclusionFilters', 8,
        0,
        mojo.internal.Array(blink.mojom.HidDeviceFilterSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.HidService_RequestDevice_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.HidDeviceFilter> } */
    this.filters;
    /** @export { !Array<!blink.mojom.HidDeviceFilter> } */
    this.exclusionFilters;
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_RequestDevice_ResponseParamsSpec.$,
    'HidService_RequestDevice_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device.mojom.HidDeviceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.HidService_RequestDevice_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.HidDeviceInfo> } */
    this.devices;
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_Connect_ParamsSpec.$,
    'HidService_Connect_Params',
    [
      mojo.internal.StructField(
        'deviceGuid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(device.mojom.HidConnectionClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.HidService_Connect_Params = class {
  constructor() {
    /** @export { !string } */
    this.deviceGuid;
    /** @export { !device.mojom.HidConnectionClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_Connect_ResponseParamsSpec.$,
    'HidService_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'connection', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.HidConnectionRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.HidService_Connect_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.HidConnectionRemote|undefined) } */
    this.connection;
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_Forget_ParamsSpec.$,
    'HidService_Forget_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device.mojom.HidDeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.HidService_Forget_Params = class {
  constructor() {
    /** @export { !device.mojom.HidDeviceInfo } */
    this.deviceInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.HidService_Forget_ResponseParamsSpec.$,
    'HidService_Forget_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.HidService_Forget_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Union(
    blink.mojom.DeviceIdFilterSpec.$, 'DeviceIdFilter',
    {
      'vendor': {
        'ordinal': 0,
        'type': mojo.internal.Uint16,
      },
      'vendorAndProduct': {
        'ordinal': 1,
        'type': blink.mojom.VendorAndProductSpec.$,
      },
    });

/**
 * @typedef { {
 *   vendor: (!number|undefined),
 *   vendorAndProduct: (!blink.mojom.VendorAndProduct|undefined),
 * } }
 */
blink.mojom.DeviceIdFilter;


mojo.internal.Union(
    blink.mojom.UsageFilterSpec.$, 'UsageFilter',
    {
      'page': {
        'ordinal': 0,
        'type': mojo.internal.Uint16,
      },
      'usageAndPage': {
        'ordinal': 1,
        'type': device.mojom.HidUsageAndPageSpec.$,
      },
    });

/**
 * @typedef { {
 *   page: (!number|undefined),
 *   usageAndPage: (!device.mojom.HidUsageAndPage|undefined),
 * } }
 */
blink.mojom.UsageFilter;
