// third_party/blink/public/mojom/handwriting/handwriting.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::handwriting::mojom::HandwritingRecognitionType>
    : public mojo::internal::EnumHashImpl<::handwriting::mojom::HandwritingRecognitionType> {};

template <>
struct hash<::handwriting::mojom::HandwritingInputType>
    : public mojo::internal::EnumHashImpl<::handwriting::mojom::HandwritingInputType> {};

template <>
struct hash<::handwriting::mojom::CreateHandwritingRecognizerResult>
    : public mojo::internal::EnumHashImpl<::handwriting::mojom::CreateHandwritingRecognizerResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingRecognitionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::handwriting::mojom::HandwritingRecognitionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::handwriting::mojom::HandwritingRecognitionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingInputType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::handwriting::mojom::HandwritingInputType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::handwriting::mojom::HandwritingInputType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::CreateHandwritingRecognizerResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::handwriting::mojom::CreateHandwritingRecognizerResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::handwriting::mojom::CreateHandwritingRecognizerResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingPointDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::HandwritingPointDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::HandwritingPoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::location(input)) in_location = Traits::location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location)::BaseType> location_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_location,
      location_fragment);

    fragment->location.Set(
        location_fragment.is_null() ? nullptr : location_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->location.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location in HandwritingPoint struct");

    decltype(Traits::t(input)) in_t = Traits::t(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->t)::BaseType> t_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_t,
      t_fragment);

    fragment->t.Set(
        t_fragment.is_null() ? nullptr : t_fragment.data());
  }

  static bool Deserialize(::handwriting::mojom::internal::HandwritingPoint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::HandwritingPointDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingStrokeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::HandwritingStrokeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::HandwritingStroke_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::points(input)) in_points = Traits::points(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->points)::BaseType>
        points_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& points_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingPointDataView>>(
      in_points,
      points_fragment,
      &points_validate_params);

    fragment->points.Set(
        points_fragment.is_null() ? nullptr : points_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->points.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null points in HandwritingStroke struct");
  }

  static bool Deserialize(::handwriting::mojom::internal::HandwritingStroke_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::HandwritingStrokeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingDrawingSegmentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::HandwritingDrawingSegmentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::HandwritingDrawingSegment_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->stroke_index = Traits::stroke_index(input);

    fragment->begin_point_index = Traits::begin_point_index(input);

    fragment->end_point_index = Traits::end_point_index(input);
  }

  static bool Deserialize(::handwriting::mojom::internal::HandwritingDrawingSegment_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::HandwritingDrawingSegmentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingSegmentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::HandwritingSegmentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::HandwritingSegment_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::grapheme(input)) in_grapheme = Traits::grapheme(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->grapheme)::BaseType> grapheme_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_grapheme,
      grapheme_fragment);

    fragment->grapheme.Set(
        grapheme_fragment.is_null() ? nullptr : grapheme_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->grapheme.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null grapheme in HandwritingSegment struct");

    fragment->begin_index = Traits::begin_index(input);

    fragment->end_index = Traits::end_index(input);

    decltype(Traits::drawing_segments(input)) in_drawing_segments = Traits::drawing_segments(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->drawing_segments)::BaseType>
        drawing_segments_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& drawing_segments_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingDrawingSegmentDataView>>(
      in_drawing_segments,
      drawing_segments_fragment,
      &drawing_segments_validate_params);

    fragment->drawing_segments.Set(
        drawing_segments_fragment.is_null() ? nullptr : drawing_segments_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->drawing_segments.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null drawing_segments in HandwritingSegment struct");
  }

  static bool Deserialize(::handwriting::mojom::internal::HandwritingSegment_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::HandwritingSegmentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingPredictionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::HandwritingPredictionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::HandwritingPrediction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in HandwritingPrediction struct");

    decltype(Traits::segmentation_result(input)) in_segmentation_result = Traits::segmentation_result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->segmentation_result)::BaseType>
        segmentation_result_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& segmentation_result_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingSegmentDataView>>(
      in_segmentation_result,
      segmentation_result_fragment,
      &segmentation_result_validate_params);

    fragment->segmentation_result.Set(
        segmentation_result_fragment.is_null() ? nullptr : segmentation_result_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->segmentation_result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null segmentation_result in HandwritingPrediction struct");
  }

  static bool Deserialize(::handwriting::mojom::internal::HandwritingPrediction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::HandwritingPredictionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingHintsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::HandwritingHintsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::HandwritingHints_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::recognition_type(input)) in_recognition_type = Traits::recognition_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recognition_type)::BaseType> recognition_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_recognition_type,
      recognition_type_fragment);

    fragment->recognition_type.Set(
        recognition_type_fragment.is_null() ? nullptr : recognition_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recognition_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recognition_type in HandwritingHints struct");

    decltype(Traits::input_type(input)) in_input_type = Traits::input_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_type)::BaseType> input_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_input_type,
      input_type_fragment);

    fragment->input_type.Set(
        input_type_fragment.is_null() ? nullptr : input_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_type in HandwritingHints struct");

    decltype(Traits::text_context(input)) in_text_context = Traits::text_context(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_context)::BaseType> text_context_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text_context,
      text_context_fragment);

    fragment->text_context.Set(
        text_context_fragment.is_null() ? nullptr : text_context_fragment.data());

    fragment->alternatives = Traits::alternatives(input);
  }

  static bool Deserialize(::handwriting::mojom::internal::HandwritingHints_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::HandwritingHintsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingHintsQueryResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::HandwritingHintsQueryResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::HandwritingHintsQueryResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::recognition_type(input)) in_recognition_type = Traits::recognition_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recognition_type)::BaseType>
        recognition_type_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& recognition_type_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::handwriting::mojom::internal::HandwritingRecognitionType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingRecognitionType>>(
      in_recognition_type,
      recognition_type_fragment,
      &recognition_type_validate_params);

    fragment->recognition_type.Set(
        recognition_type_fragment.is_null() ? nullptr : recognition_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recognition_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recognition_type in HandwritingHintsQueryResult struct");

    decltype(Traits::input_type(input)) in_input_type = Traits::input_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_type)::BaseType>
        input_type_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input_type_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::handwriting::mojom::internal::HandwritingInputType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingInputType>>(
      in_input_type,
      input_type_fragment,
      &input_type_validate_params);

    fragment->input_type.Set(
        input_type_fragment.is_null() ? nullptr : input_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_type in HandwritingHintsQueryResult struct");

    fragment->text_context = Traits::text_context(input);

    fragment->alternatives = Traits::alternatives(input);
  }

  static bool Deserialize(::handwriting::mojom::internal::HandwritingHintsQueryResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::HandwritingHintsQueryResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::QueryHandwritingRecognizerResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::QueryHandwritingRecognizerResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::QueryHandwritingRecognizerResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->text_alternatives = Traits::text_alternatives(input);

    fragment->text_segmentation = Traits::text_segmentation(input);

    decltype(Traits::hints(input)) in_hints = Traits::hints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hints)::BaseType> hints_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::handwriting::mojom::HandwritingHintsQueryResultDataView>(
      in_hints,
      hints_fragment);

    fragment->hints.Set(
        hints_fragment.is_null() ? nullptr : hints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hints in QueryHandwritingRecognizerResult struct");
  }

  static bool Deserialize(::handwriting::mojom::internal::QueryHandwritingRecognizerResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::QueryHandwritingRecognizerResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::handwriting::mojom::HandwritingModelConstraintDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::handwriting::mojom::HandwritingModelConstraintDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::handwriting::mojom::internal::HandwritingModelConstraint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::languages(input)) in_languages = Traits::languages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->languages)::BaseType>
        languages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& languages_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_languages,
      languages_fragment,
      &languages_validate_params);

    fragment->languages.Set(
        languages_fragment.is_null() ? nullptr : languages_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->languages.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null languages in HandwritingModelConstraint struct");
  }

  static bool Deserialize(::handwriting::mojom::internal::HandwritingModelConstraint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::handwriting::mojom::HandwritingModelConstraintDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace handwriting::mojom {

inline void HandwritingPointDataView::GetLocationDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->location.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void HandwritingPointDataView::GetTDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->t.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void HandwritingStrokeDataView::GetPointsDataView(
    mojo::ArrayDataView<HandwritingPointDataView>* output) {
  auto pointer = data_->points.Get();
  *output = mojo::ArrayDataView<HandwritingPointDataView>(pointer, message_);
}




inline void HandwritingSegmentDataView::GetGraphemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->grapheme.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HandwritingSegmentDataView::GetDrawingSegmentsDataView(
    mojo::ArrayDataView<HandwritingDrawingSegmentDataView>* output) {
  auto pointer = data_->drawing_segments.Get();
  *output = mojo::ArrayDataView<HandwritingDrawingSegmentDataView>(pointer, message_);
}


inline void HandwritingPredictionDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HandwritingPredictionDataView::GetSegmentationResultDataView(
    mojo::ArrayDataView<HandwritingSegmentDataView>* output) {
  auto pointer = data_->segmentation_result.Get();
  *output = mojo::ArrayDataView<HandwritingSegmentDataView>(pointer, message_);
}


inline void HandwritingHintsDataView::GetRecognitionTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->recognition_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HandwritingHintsDataView::GetInputTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->input_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HandwritingHintsDataView::GetTextContextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_context.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void HandwritingHintsQueryResultDataView::GetRecognitionTypeDataView(
    mojo::ArrayDataView<HandwritingRecognitionType>* output) {
  auto pointer = data_->recognition_type.Get();
  *output = mojo::ArrayDataView<HandwritingRecognitionType>(pointer, message_);
}
inline void HandwritingHintsQueryResultDataView::GetInputTypeDataView(
    mojo::ArrayDataView<HandwritingInputType>* output) {
  auto pointer = data_->input_type.Get();
  *output = mojo::ArrayDataView<HandwritingInputType>(pointer, message_);
}


inline void QueryHandwritingRecognizerResultDataView::GetHintsDataView(
    HandwritingHintsQueryResultDataView* output) {
  auto pointer = data_->hints.Get();
  *output = HandwritingHintsQueryResultDataView(pointer, message_);
}


inline void HandwritingModelConstraintDataView::GetLanguagesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->languages.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // handwriting::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::handwriting::mojom::HandwritingRecognitionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::handwriting::mojom::HandwritingRecognitionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::handwriting::mojom::HandwritingInputType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::handwriting::mojom::HandwritingInputType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::handwriting::mojom::CreateHandwritingRecognizerResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::handwriting::mojom::CreateHandwritingRecognizerResult value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_SHARED_H_