// third_party/blink/public/mojom/handwriting/handwriting.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace handwriting::mojom {
class HandwritingPointDataView;

class HandwritingStrokeDataView;

class HandwritingDrawingSegmentDataView;

class HandwritingSegmentDataView;

class HandwritingPredictionDataView;

class HandwritingHintsDataView;

class HandwritingHintsQueryResultDataView;

class QueryHandwritingRecognizerResultDataView;

class HandwritingModelConstraintDataView;



}  // handwriting::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::handwriting::mojom::HandwritingPointDataView> {
  using Data = ::handwriting::mojom::internal::HandwritingPoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::handwriting::mojom::HandwritingStrokeDataView> {
  using Data = ::handwriting::mojom::internal::HandwritingStroke_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::handwriting::mojom::HandwritingDrawingSegmentDataView> {
  using Data = ::handwriting::mojom::internal::HandwritingDrawingSegment_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::handwriting::mojom::HandwritingSegmentDataView> {
  using Data = ::handwriting::mojom::internal::HandwritingSegment_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::handwriting::mojom::HandwritingPredictionDataView> {
  using Data = ::handwriting::mojom::internal::HandwritingPrediction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::handwriting::mojom::HandwritingHintsDataView> {
  using Data = ::handwriting::mojom::internal::HandwritingHints_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::handwriting::mojom::HandwritingHintsQueryResultDataView> {
  using Data = ::handwriting::mojom::internal::HandwritingHintsQueryResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::handwriting::mojom::QueryHandwritingRecognizerResultDataView> {
  using Data = ::handwriting::mojom::internal::QueryHandwritingRecognizerResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::handwriting::mojom::HandwritingModelConstraintDataView> {
  using Data = ::handwriting::mojom::internal::HandwritingModelConstraint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace handwriting::mojom {


enum class HandwritingRecognitionType : int32_t {
  
  kText = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HandwritingRecognitionType value);
inline bool IsKnownEnumValue(HandwritingRecognitionType value) {
  return internal::HandwritingRecognitionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HandwritingInputType : int32_t {
  
  kMouse = 0,
  
  kStylus = 1,
  
  kTouch = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HandwritingInputType value);
inline bool IsKnownEnumValue(HandwritingInputType value) {
  return internal::HandwritingInputType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateHandwritingRecognizerResult : int32_t {
  
  kOk = 0,
  
  kError = 1,
  
  kNotSupported = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CreateHandwritingRecognizerResult value);
inline bool IsKnownEnumValue(CreateHandwritingRecognizerResult value) {
  return internal::CreateHandwritingRecognizerResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class HandwritingRecognizerInterfaceBase {};

using HandwritingRecognizerPtrDataView =
    mojo::InterfacePtrDataView<HandwritingRecognizerInterfaceBase>;
using HandwritingRecognizerRequestDataView =
    mojo::InterfaceRequestDataView<HandwritingRecognizerInterfaceBase>;
using HandwritingRecognizerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HandwritingRecognizerInterfaceBase>;
using HandwritingRecognizerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HandwritingRecognizerInterfaceBase>;
class HandwritingRecognitionServiceInterfaceBase {};

using HandwritingRecognitionServicePtrDataView =
    mojo::InterfacePtrDataView<HandwritingRecognitionServiceInterfaceBase>;
using HandwritingRecognitionServiceRequestDataView =
    mojo::InterfaceRequestDataView<HandwritingRecognitionServiceInterfaceBase>;
using HandwritingRecognitionServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HandwritingRecognitionServiceInterfaceBase>;
using HandwritingRecognitionServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HandwritingRecognitionServiceInterfaceBase>;


class HandwritingPointDataView {
 public:
  HandwritingPointDataView() = default;

  HandwritingPointDataView(
      internal::HandwritingPoint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetTDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadT(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `t` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadT` instead "
    "of `ReadT if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->t.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::HandwritingPoint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HandwritingStrokeDataView {
 public:
  HandwritingStrokeDataView() = default;

  HandwritingStrokeDataView(
      internal::HandwritingStroke_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPointsDataView(
      mojo::ArrayDataView<HandwritingPointDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoints(UserType* output) {
    
    auto* pointer = data_->points.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingPointDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HandwritingStroke_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HandwritingDrawingSegmentDataView {
 public:
  HandwritingDrawingSegmentDataView() = default;

  HandwritingDrawingSegmentDataView(
      internal::HandwritingDrawingSegment_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t stroke_index() const {
    return data_->stroke_index;
  }
  uint32_t begin_point_index() const {
    return data_->begin_point_index;
  }
  uint32_t end_point_index() const {
    return data_->end_point_index;
  }
 private:
  internal::HandwritingDrawingSegment_Data* data_ = nullptr;
};


class HandwritingSegmentDataView {
 public:
  HandwritingSegmentDataView() = default;

  HandwritingSegmentDataView(
      internal::HandwritingSegment_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGraphemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGrapheme(UserType* output) {
    
    auto* pointer = data_->grapheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t begin_index() const {
    return data_->begin_index;
  }
  uint32_t end_index() const {
    return data_->end_index;
  }
  inline void GetDrawingSegmentsDataView(
      mojo::ArrayDataView<HandwritingDrawingSegmentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDrawingSegments(UserType* output) {
    
    auto* pointer = data_->drawing_segments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingDrawingSegmentDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HandwritingSegment_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HandwritingPredictionDataView {
 public:
  HandwritingPredictionDataView() = default;

  HandwritingPredictionDataView(
      internal::HandwritingPrediction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSegmentationResultDataView(
      mojo::ArrayDataView<HandwritingSegmentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentationResult(UserType* output) {
    
    auto* pointer = data_->segmentation_result.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingSegmentDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HandwritingPrediction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HandwritingHintsDataView {
 public:
  HandwritingHintsDataView() = default;

  HandwritingHintsDataView(
      internal::HandwritingHints_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRecognitionTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecognitionType(UserType* output) {
    
    auto* pointer = data_->recognition_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInputTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputType(UserType* output) {
    
    auto* pointer = data_->input_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextContextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextContext(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `text_context` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTextContext` instead "
    "of `ReadTextContext if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text_context.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t alternatives() const {
    return data_->alternatives;
  }
 private:
  internal::HandwritingHints_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HandwritingHintsQueryResultDataView {
 public:
  HandwritingHintsQueryResultDataView() = default;

  HandwritingHintsQueryResultDataView(
      internal::HandwritingHintsQueryResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRecognitionTypeDataView(
      mojo::ArrayDataView<HandwritingRecognitionType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecognitionType(UserType* output) {
    
    auto* pointer = data_->recognition_type.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingRecognitionType>>(
        pointer, output, message_);
  }
  inline void GetInputTypeDataView(
      mojo::ArrayDataView<HandwritingInputType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputType(UserType* output) {
    
    auto* pointer = data_->input_type.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingInputType>>(
        pointer, output, message_);
  }
  bool text_context() const {
    return data_->text_context;
  }
  bool alternatives() const {
    return data_->alternatives;
  }
 private:
  internal::HandwritingHintsQueryResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class QueryHandwritingRecognizerResultDataView {
 public:
  QueryHandwritingRecognizerResultDataView() = default;

  QueryHandwritingRecognizerResultDataView(
      internal::QueryHandwritingRecognizerResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool text_alternatives() const {
    return data_->text_alternatives;
  }
  bool text_segmentation() const {
    return data_->text_segmentation;
  }
  inline void GetHintsDataView(
      HandwritingHintsQueryResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHints(UserType* output) {
    
    auto* pointer = data_->hints.Get();
    return mojo::internal::Deserialize<::handwriting::mojom::HandwritingHintsQueryResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::QueryHandwritingRecognizerResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HandwritingModelConstraintDataView {
 public:
  HandwritingModelConstraintDataView() = default;

  HandwritingModelConstraintDataView(
      internal::HandwritingModelConstraint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLanguagesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguages(UserType* output) {
    
    auto* pointer = data_->languages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HandwritingModelConstraint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // handwriting::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_DATA_VIEW_H_