// third_party/blink/public/mojom/gpu/gpu.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GpuDataManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.GpuDataManager', scope);
  }
}

/** @interface */
export class GpuDataManagerInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        blocked: !boolean,
   *  }>}
   */

  are3DAPIsBlockedForUrl(url) {}
}

/**
 * @implements { GpuDataManagerInterface }
 */
export class GpuDataManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GpuDataManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GpuDataManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GpuDataManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        blocked: !boolean,
   *  }>}
   */

  are3DAPIsBlockedForUrl(
      url) {
    return this.proxy.sendMessage(
        0,
        GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec.$,
        GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }
}

/**
 * An object which receives request messages for the GpuDataManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GpuDataManagerReceiver {
  /**
   * @param {!GpuDataManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GpuDataManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GpuDataManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GpuDataManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec.$,
        GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec.$,
        impl.are3DAPIsBlockedForUrl.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GpuDataManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.GpuDataManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GpuDataManagerRemote}
   */
  static getRemote() {
    let remote = new GpuDataManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the GpuDataManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GpuDataManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GpuDataManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GpuDataManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.are3DAPIsBlockedForUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec.$,
        GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec.$,
        this.are3DAPIsBlockedForUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec.$,
    'GpuDataManager_Are3DAPIsBlockedForUrl_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GpuDataManager_Are3DAPIsBlockedForUrl_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec.$,
    'GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams',
    [
      mojo.internal.StructField(
        'blocked', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.blocked;
  }
}

