// third_party/blink/public/mojom/frame/viewport_intersection_state.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT ViewportIntersectionState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewportIntersectionState, T>::value>;
  using DataView = ViewportIntersectionStateDataView;
  using Data_ = internal::ViewportIntersectionState_Data;

  template <typename... Args>
  static ViewportIntersectionStatePtr New(Args&&... args) {
    return ViewportIntersectionStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewportIntersectionStatePtr From(const U& u) {
    return mojo::TypeConverter<ViewportIntersectionStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewportIntersectionState>::Convert(*this);
  }


  ViewportIntersectionState();

  ViewportIntersectionState(
      const ::gfx::Rect& viewport_intersection,
      const ::gfx::Rect& main_frame_intersection,
      const ::gfx::Rect& compositor_visible_rect,
      FrameOcclusionState occlusion_state,
      const ::gfx::Size& outermost_main_frame_size,
      const ::gfx::Point& outermost_main_frame_scroll_position,
      const ::gfx::Transform& main_frame_transform);


  ~ViewportIntersectionState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewportIntersectionStatePtr>
  ViewportIntersectionStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewportIntersectionState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewportIntersectionState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewportIntersectionState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewportIntersectionState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewportIntersectionState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewportIntersectionState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewportIntersectionState_UnserializedMessageContext<
            UserType, ViewportIntersectionState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewportIntersectionState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewportIntersectionState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewportIntersectionState_UnserializedMessageContext<
            UserType, ViewportIntersectionState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewportIntersectionState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect viewport_intersection;
  
  ::gfx::Rect main_frame_intersection;
  
  ::gfx::Rect compositor_visible_rect;
  
  FrameOcclusionState occlusion_state;
  
  ::gfx::Size outermost_main_frame_size;
  
  ::gfx::Point outermost_main_frame_scroll_position;
  
  ::gfx::Transform main_frame_transform;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewportIntersectionState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewportIntersectionState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewportIntersectionState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewportIntersectionState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ViewportIntersectionStatePtr ViewportIntersectionState::Clone() const {
  return New(
      mojo::Clone(viewport_intersection),
      mojo::Clone(main_frame_intersection),
      mojo::Clone(compositor_visible_rect),
      mojo::Clone(occlusion_state),
      mojo::Clone(outermost_main_frame_size),
      mojo::Clone(outermost_main_frame_scroll_position),
      mojo::Clone(main_frame_transform)
  );
}

template <typename T, ViewportIntersectionState::EnableIfSame<T>*>
bool ViewportIntersectionState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->viewport_intersection, other_struct.viewport_intersection))
    return false;
  if (!mojo::Equals(this->main_frame_intersection, other_struct.main_frame_intersection))
    return false;
  if (!mojo::Equals(this->compositor_visible_rect, other_struct.compositor_visible_rect))
    return false;
  if (!mojo::Equals(this->occlusion_state, other_struct.occlusion_state))
    return false;
  if (!mojo::Equals(this->outermost_main_frame_size, other_struct.outermost_main_frame_size))
    return false;
  if (!mojo::Equals(this->outermost_main_frame_scroll_position, other_struct.outermost_main_frame_scroll_position))
    return false;
  if (!mojo::Equals(this->main_frame_transform, other_struct.main_frame_transform))
    return false;
  return true;
}

template <typename T, ViewportIntersectionState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.viewport_intersection < rhs.viewport_intersection)
    return true;
  if (rhs.viewport_intersection < lhs.viewport_intersection)
    return false;
  if (lhs.main_frame_intersection < rhs.main_frame_intersection)
    return true;
  if (rhs.main_frame_intersection < lhs.main_frame_intersection)
    return false;
  if (lhs.compositor_visible_rect < rhs.compositor_visible_rect)
    return true;
  if (rhs.compositor_visible_rect < lhs.compositor_visible_rect)
    return false;
  if (lhs.occlusion_state < rhs.occlusion_state)
    return true;
  if (rhs.occlusion_state < lhs.occlusion_state)
    return false;
  if (lhs.outermost_main_frame_size < rhs.outermost_main_frame_size)
    return true;
  if (rhs.outermost_main_frame_size < lhs.outermost_main_frame_size)
    return false;
  if (lhs.outermost_main_frame_scroll_position < rhs.outermost_main_frame_scroll_position)
    return true;
  if (rhs.outermost_main_frame_scroll_position < lhs.outermost_main_frame_scroll_position)
    return false;
  if (lhs.main_frame_transform < rhs.main_frame_transform)
    return true;
  if (rhs.main_frame_transform < lhs.main_frame_transform)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ViewportIntersectionState::DataView,
                                         ::blink::mojom::ViewportIntersectionStatePtr> {
  static bool IsNull(const ::blink::mojom::ViewportIntersectionStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ViewportIntersectionStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ViewportIntersectionState::viewport_intersection)& viewport_intersection(
      const ::blink::mojom::ViewportIntersectionStatePtr& input) {
    return input->viewport_intersection;
  }

  static const decltype(::blink::mojom::ViewportIntersectionState::main_frame_intersection)& main_frame_intersection(
      const ::blink::mojom::ViewportIntersectionStatePtr& input) {
    return input->main_frame_intersection;
  }

  static const decltype(::blink::mojom::ViewportIntersectionState::compositor_visible_rect)& compositor_visible_rect(
      const ::blink::mojom::ViewportIntersectionStatePtr& input) {
    return input->compositor_visible_rect;
  }

  static decltype(::blink::mojom::ViewportIntersectionState::occlusion_state) occlusion_state(
      const ::blink::mojom::ViewportIntersectionStatePtr& input) {
    return input->occlusion_state;
  }

  static const decltype(::blink::mojom::ViewportIntersectionState::outermost_main_frame_size)& outermost_main_frame_size(
      const ::blink::mojom::ViewportIntersectionStatePtr& input) {
    return input->outermost_main_frame_size;
  }

  static const decltype(::blink::mojom::ViewportIntersectionState::outermost_main_frame_scroll_position)& outermost_main_frame_scroll_position(
      const ::blink::mojom::ViewportIntersectionStatePtr& input) {
    return input->outermost_main_frame_scroll_position;
  }

  static const decltype(::blink::mojom::ViewportIntersectionState::main_frame_transform)& main_frame_transform(
      const ::blink::mojom::ViewportIntersectionStatePtr& input) {
    return input->main_frame_transform;
  }

  static bool Read(::blink::mojom::ViewportIntersectionState::DataView input, ::blink::mojom::ViewportIntersectionStatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_H_