// third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"




#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::FrameOcclusionState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FrameOcclusionState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FrameOcclusionState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FrameOcclusionState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FrameOcclusionState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewportIntersectionStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ViewportIntersectionStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ViewportIntersectionState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::viewport_intersection(input)) in_viewport_intersection = Traits::viewport_intersection(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport_intersection)::BaseType> viewport_intersection_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_viewport_intersection,
      viewport_intersection_fragment);

    fragment->viewport_intersection.Set(
        viewport_intersection_fragment.is_null() ? nullptr : viewport_intersection_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->viewport_intersection.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null viewport_intersection in ViewportIntersectionState struct");

    decltype(Traits::main_frame_intersection(input)) in_main_frame_intersection = Traits::main_frame_intersection(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_frame_intersection)::BaseType> main_frame_intersection_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_main_frame_intersection,
      main_frame_intersection_fragment);

    fragment->main_frame_intersection.Set(
        main_frame_intersection_fragment.is_null() ? nullptr : main_frame_intersection_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->main_frame_intersection.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_intersection in ViewportIntersectionState struct");

    decltype(Traits::compositor_visible_rect(input)) in_compositor_visible_rect = Traits::compositor_visible_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->compositor_visible_rect)::BaseType> compositor_visible_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_compositor_visible_rect,
      compositor_visible_rect_fragment);

    fragment->compositor_visible_rect.Set(
        compositor_visible_rect_fragment.is_null() ? nullptr : compositor_visible_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->compositor_visible_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null compositor_visible_rect in ViewportIntersectionState struct");

    
    mojo::internal::Serialize<::blink::mojom::FrameOcclusionState>(
      Traits::occlusion_state(input),
      &fragment->occlusion_state);

    decltype(Traits::outermost_main_frame_size(input)) in_outermost_main_frame_size = Traits::outermost_main_frame_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->outermost_main_frame_size)::BaseType> outermost_main_frame_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_outermost_main_frame_size,
      outermost_main_frame_size_fragment);

    fragment->outermost_main_frame_size.Set(
        outermost_main_frame_size_fragment.is_null() ? nullptr : outermost_main_frame_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->outermost_main_frame_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null outermost_main_frame_size in ViewportIntersectionState struct");

    decltype(Traits::outermost_main_frame_scroll_position(input)) in_outermost_main_frame_scroll_position = Traits::outermost_main_frame_scroll_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->outermost_main_frame_scroll_position)::BaseType> outermost_main_frame_scroll_position_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_outermost_main_frame_scroll_position,
      outermost_main_frame_scroll_position_fragment);

    fragment->outermost_main_frame_scroll_position.Set(
        outermost_main_frame_scroll_position_fragment.is_null() ? nullptr : outermost_main_frame_scroll_position_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->outermost_main_frame_scroll_position.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null outermost_main_frame_scroll_position in ViewportIntersectionState struct");

    decltype(Traits::main_frame_transform(input)) in_main_frame_transform = Traits::main_frame_transform(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_frame_transform)::BaseType> main_frame_transform_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
      in_main_frame_transform,
      main_frame_transform_fragment);

    fragment->main_frame_transform.Set(
        main_frame_transform_fragment.is_null() ? nullptr : main_frame_transform_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->main_frame_transform.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_transform in ViewportIntersectionState struct");
  }

  static bool Deserialize(::blink::mojom::internal::ViewportIntersectionState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ViewportIntersectionStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ViewportIntersectionStateDataView::GetViewportIntersectionDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->viewport_intersection.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void ViewportIntersectionStateDataView::GetMainFrameIntersectionDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->main_frame_intersection.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void ViewportIntersectionStateDataView::GetCompositorVisibleRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->compositor_visible_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void ViewportIntersectionStateDataView::GetOutermostMainFrameSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->outermost_main_frame_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void ViewportIntersectionStateDataView::GetOutermostMainFrameScrollPositionDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->outermost_main_frame_scroll_position.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void ViewportIntersectionStateDataView::GetMainFrameTransformDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->main_frame_transform.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FrameOcclusionState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FrameOcclusionState value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_SHARED_H_