// third_party/blink/public/mojom/frame/view_transition_state.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"




#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::ViewTransitionPropertyId>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ViewTransitionPropertyId> {};

template <>
struct hash<::blink::mojom::ViewTransitionElementBoxSizing>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ViewTransitionElementBoxSizing> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewTransitionPropertyId, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ViewTransitionPropertyId, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ViewTransitionPropertyId>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewTransitionElementBoxSizing, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ViewTransitionElementBoxSizing, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ViewTransitionElementBoxSizing>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewTransitionElementLayeredBoxPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ViewTransitionElementLayeredBoxPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ViewTransitionElementLayeredBoxProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::content_box(input)) in_content_box = Traits::content_box(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_box)::BaseType> content_box_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_content_box,
      content_box_fragment);

    fragment->content_box.Set(
        content_box_fragment.is_null() ? nullptr : content_box_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_box.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_box in ViewTransitionElementLayeredBoxProperties struct");

    decltype(Traits::padding_box(input)) in_padding_box = Traits::padding_box(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->padding_box)::BaseType> padding_box_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_padding_box,
      padding_box_fragment);

    fragment->padding_box.Set(
        padding_box_fragment.is_null() ? nullptr : padding_box_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->padding_box.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null padding_box in ViewTransitionElementLayeredBoxProperties struct");

    
    mojo::internal::Serialize<::blink::mojom::ViewTransitionElementBoxSizing>(
      Traits::box_sizing(input),
      &fragment->box_sizing);
  }

  static bool Deserialize(::blink::mojom::internal::ViewTransitionElementLayeredBoxProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ViewTransitionElementLayeredBoxPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewTransitionElementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ViewTransitionElementDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ViewTransitionElement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tag_name(input)) in_tag_name = Traits::tag_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tag_name)::BaseType> tag_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_tag_name,
      tag_name_fragment);

    fragment->tag_name.Set(
        tag_name_fragment.is_null() ? nullptr : tag_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tag_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tag_name in ViewTransitionElement struct");

    decltype(Traits::border_box_rect_in_enclosing_layer_css_space(input)) in_border_box_rect_in_enclosing_layer_css_space = Traits::border_box_rect_in_enclosing_layer_css_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->border_box_rect_in_enclosing_layer_css_space)::BaseType> border_box_rect_in_enclosing_layer_css_space_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_border_box_rect_in_enclosing_layer_css_space,
      border_box_rect_in_enclosing_layer_css_space_fragment);

    fragment->border_box_rect_in_enclosing_layer_css_space.Set(
        border_box_rect_in_enclosing_layer_css_space_fragment.is_null() ? nullptr : border_box_rect_in_enclosing_layer_css_space_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->border_box_rect_in_enclosing_layer_css_space.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null border_box_rect_in_enclosing_layer_css_space in ViewTransitionElement struct");

    decltype(Traits::viewport_matrix(input)) in_viewport_matrix = Traits::viewport_matrix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport_matrix)::BaseType> viewport_matrix_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
      in_viewport_matrix,
      viewport_matrix_fragment);

    fragment->viewport_matrix.Set(
        viewport_matrix_fragment.is_null() ? nullptr : viewport_matrix_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->viewport_matrix.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null viewport_matrix in ViewTransitionElement struct");

    decltype(Traits::overflow_rect_in_layout_space(input)) in_overflow_rect_in_layout_space = Traits::overflow_rect_in_layout_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->overflow_rect_in_layout_space)::BaseType> overflow_rect_in_layout_space_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_overflow_rect_in_layout_space,
      overflow_rect_in_layout_space_fragment);

    fragment->overflow_rect_in_layout_space.Set(
        overflow_rect_in_layout_space_fragment.is_null() ? nullptr : overflow_rect_in_layout_space_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->overflow_rect_in_layout_space.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null overflow_rect_in_layout_space in ViewTransitionElement struct");

    decltype(Traits::captured_rect_in_layout_space(input)) in_captured_rect_in_layout_space = Traits::captured_rect_in_layout_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->captured_rect_in_layout_space)::BaseType> captured_rect_in_layout_space_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_captured_rect_in_layout_space,
      captured_rect_in_layout_space_fragment);

    fragment->captured_rect_in_layout_space.Set(
        captured_rect_in_layout_space_fragment.is_null() ? nullptr : captured_rect_in_layout_space_fragment.data());

    decltype(Traits::snapshot_id(input)) in_snapshot_id = Traits::snapshot_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->snapshot_id)::BaseType> snapshot_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
      in_snapshot_id,
      snapshot_id_fragment);

    fragment->snapshot_id.Set(
        snapshot_id_fragment.is_null() ? nullptr : snapshot_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->snapshot_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null snapshot_id in ViewTransitionElement struct");

    fragment->paint_order = Traits::paint_order(input);

    decltype(Traits::captured_css_properties(input)) in_captured_css_properties = Traits::captured_css_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->captured_css_properties)::BaseType>
        captured_css_properties_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& captured_css_properties_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ViewTransitionPropertyId_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::ViewTransitionPropertyId, mojo::StringDataView>>(
      in_captured_css_properties,
      captured_css_properties_fragment,
      &captured_css_properties_validate_params);

    fragment->captured_css_properties.Set(
        captured_css_properties_fragment.is_null() ? nullptr : captured_css_properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->captured_css_properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null captured_css_properties in ViewTransitionElement struct");

    decltype(Traits::group_children_css_properties(input)) in_group_children_css_properties = Traits::group_children_css_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_children_css_properties)::BaseType>
        group_children_css_properties_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& group_children_css_properties_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ViewTransitionPropertyId_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::ViewTransitionPropertyId, mojo::StringDataView>>(
      in_group_children_css_properties,
      group_children_css_properties_fragment,
      &group_children_css_properties_validate_params);

    fragment->group_children_css_properties.Set(
        group_children_css_properties_fragment.is_null() ? nullptr : group_children_css_properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_children_css_properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_children_css_properties in ViewTransitionElement struct");

    decltype(Traits::border_offset(input)) in_border_offset = Traits::border_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->border_offset)::BaseType> border_offset_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
      in_border_offset,
      border_offset_fragment);

    fragment->border_offset.Set(
        border_offset_fragment.is_null() ? nullptr : border_offset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->border_offset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null border_offset in ViewTransitionElement struct");

    decltype(Traits::class_list(input)) in_class_list = Traits::class_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->class_list)::BaseType>
        class_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& class_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_class_list,
      class_list_fragment,
      &class_list_validate_params);

    fragment->class_list.Set(
        class_list_fragment.is_null() ? nullptr : class_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->class_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null class_list in ViewTransitionElement struct");

    decltype(Traits::containing_group_name(input)) in_containing_group_name = Traits::containing_group_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->containing_group_name)::BaseType> containing_group_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_containing_group_name,
      containing_group_name_fragment);

    fragment->containing_group_name.Set(
        containing_group_name_fragment.is_null() ? nullptr : containing_group_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->containing_group_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null containing_group_name in ViewTransitionElement struct");

    decltype(Traits::layered_box_properties(input)) in_layered_box_properties = Traits::layered_box_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->layered_box_properties)::BaseType> layered_box_properties_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ViewTransitionElementLayeredBoxPropertiesDataView>(
      in_layered_box_properties,
      layered_box_properties_fragment);

    fragment->layered_box_properties.Set(
        layered_box_properties_fragment.is_null() ? nullptr : layered_box_properties_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ViewTransitionElement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ViewTransitionElementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewTransitionStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ViewTransitionStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ViewTransitionState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::elements(input)) in_elements = Traits::elements(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->elements)::BaseType>
        elements_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ViewTransitionElementDataView>>(
      in_elements,
      elements_fragment,
      &elements_validate_params);

    fragment->elements.Set(
        elements_fragment.is_null() ? nullptr : elements_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->elements.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elements in ViewTransitionState struct");

    decltype(Traits::transition_token(input)) in_transition_token = Traits::transition_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transition_token)::BaseType> transition_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ViewTransitionTokenDataView>(
      in_transition_token,
      transition_token_fragment);

    fragment->transition_token.Set(
        transition_token_fragment.is_null() ? nullptr : transition_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transition_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transition_token in ViewTransitionState struct");

    decltype(Traits::snapshot_root_size_at_capture(input)) in_snapshot_root_size_at_capture = Traits::snapshot_root_size_at_capture(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->snapshot_root_size_at_capture)::BaseType> snapshot_root_size_at_capture_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_snapshot_root_size_at_capture,
      snapshot_root_size_at_capture_fragment);

    fragment->snapshot_root_size_at_capture.Set(
        snapshot_root_size_at_capture_fragment.is_null() ? nullptr : snapshot_root_size_at_capture_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->snapshot_root_size_at_capture.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null snapshot_root_size_at_capture in ViewTransitionState struct");

    fragment->device_pixel_ratio = Traits::device_pixel_ratio(input);

    fragment->next_element_resource_id = Traits::next_element_resource_id(input);

    decltype(Traits::subframe_snapshot_id(input)) in_subframe_snapshot_id = Traits::subframe_snapshot_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subframe_snapshot_id)::BaseType> subframe_snapshot_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
      in_subframe_snapshot_id,
      subframe_snapshot_id_fragment);

    fragment->subframe_snapshot_id.Set(
        subframe_snapshot_id_fragment.is_null() ? nullptr : subframe_snapshot_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subframe_snapshot_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subframe_snapshot_id in ViewTransitionState struct");

    decltype(Traits::id_to_auto_name_map(input)) in_id_to_auto_name_map = Traits::id_to_auto_name_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id_to_auto_name_map)::BaseType>
        id_to_auto_name_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& id_to_auto_name_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_id_to_auto_name_map,
      id_to_auto_name_map_fragment,
      &id_to_auto_name_map_validate_params);

    fragment->id_to_auto_name_map.Set(
        id_to_auto_name_map_fragment.is_null() ? nullptr : id_to_auto_name_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id_to_auto_name_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id_to_auto_name_map in ViewTransitionState struct");
  }

  static bool Deserialize(::blink::mojom::internal::ViewTransitionState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ViewTransitionStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ViewTransitionElementLayeredBoxPropertiesDataView::GetContentBoxDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->content_box.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void ViewTransitionElementLayeredBoxPropertiesDataView::GetPaddingBoxDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->padding_box.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}


inline void ViewTransitionElementDataView::GetTagNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tag_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ViewTransitionElementDataView::GetBorderBoxRectInEnclosingLayerCssSpaceDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->border_box_rect_in_enclosing_layer_css_space.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void ViewTransitionElementDataView::GetViewportMatrixDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->viewport_matrix.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void ViewTransitionElementDataView::GetOverflowRectInLayoutSpaceDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->overflow_rect_in_layout_space.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void ViewTransitionElementDataView::GetCapturedRectInLayoutSpaceDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->captured_rect_in_layout_space.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void ViewTransitionElementDataView::GetSnapshotIdDataView(
    ::viz::mojom::ViewTransitionElementResourceIdDataView* output) {
  auto pointer = data_->snapshot_id.Get();
  *output = ::viz::mojom::ViewTransitionElementResourceIdDataView(pointer, message_);
}
inline void ViewTransitionElementDataView::GetCapturedCssPropertiesDataView(
    mojo::MapDataView<ViewTransitionPropertyId, mojo::StringDataView>* output) {
  auto pointer = data_->captured_css_properties.Get();
  *output = mojo::MapDataView<ViewTransitionPropertyId, mojo::StringDataView>(pointer, message_);
}
inline void ViewTransitionElementDataView::GetGroupChildrenCssPropertiesDataView(
    mojo::MapDataView<ViewTransitionPropertyId, mojo::StringDataView>* output) {
  auto pointer = data_->group_children_css_properties.Get();
  *output = mojo::MapDataView<ViewTransitionPropertyId, mojo::StringDataView>(pointer, message_);
}
inline void ViewTransitionElementDataView::GetBorderOffsetDataView(
    ::gfx::mojom::Vector2dDataView* output) {
  auto pointer = data_->border_offset.Get();
  *output = ::gfx::mojom::Vector2dDataView(pointer, message_);
}
inline void ViewTransitionElementDataView::GetClassListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->class_list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ViewTransitionElementDataView::GetContainingGroupNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->containing_group_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ViewTransitionElementDataView::GetLayeredBoxPropertiesDataView(
    ViewTransitionElementLayeredBoxPropertiesDataView* output) {
  auto pointer = data_->layered_box_properties.Get();
  *output = ViewTransitionElementLayeredBoxPropertiesDataView(pointer, message_);
}


inline void ViewTransitionStateDataView::GetElementsDataView(
    mojo::ArrayDataView<ViewTransitionElementDataView>* output) {
  auto pointer = data_->elements.Get();
  *output = mojo::ArrayDataView<ViewTransitionElementDataView>(pointer, message_);
}
inline void ViewTransitionStateDataView::GetTransitionTokenDataView(
    ::blink::mojom::ViewTransitionTokenDataView* output) {
  auto pointer = data_->transition_token.Get();
  *output = ::blink::mojom::ViewTransitionTokenDataView(pointer, message_);
}
inline void ViewTransitionStateDataView::GetSnapshotRootSizeAtCaptureDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->snapshot_root_size_at_capture.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void ViewTransitionStateDataView::GetSubframeSnapshotIdDataView(
    ::viz::mojom::ViewTransitionElementResourceIdDataView* output) {
  auto pointer = data_->subframe_snapshot_id.Get();
  *output = ::viz::mojom::ViewTransitionElementResourceIdDataView(pointer, message_);
}
inline void ViewTransitionStateDataView::GetIdToAutoNameMapDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->id_to_auto_name_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ViewTransitionPropertyId> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ViewTransitionPropertyId value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ViewTransitionElementBoxSizing> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ViewTransitionElementBoxSizing value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_SHARED_H_