// third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function TextAutosizerPageInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextAutosizerPageInfo.prototype.initDefaults_ = function() {
    this.mainFrameWidth = 0;
    this.mainFrameLayoutWidth = 0;
    this.deviceScaleAdjustment = 0;
  };
  TextAutosizerPageInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextAutosizerPageInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  TextAutosizerPageInfo.encodedSize = codec.kStructHeaderSize + 16;

  TextAutosizerPageInfo.decode = function(decoder) {
    var packed;
    var val = new TextAutosizerPageInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mainFrameWidth =
        decoder.decodeStruct(codec.Int32);
    val.mainFrameLayoutWidth =
        decoder.decodeStruct(codec.Int32);
    val.deviceScaleAdjustment =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TextAutosizerPageInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextAutosizerPageInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mainFrameWidth);
    encoder.encodeStruct(codec.Int32, val.mainFrameLayoutWidth);
    encoder.encodeStruct(codec.Float, val.deviceScaleAdjustment);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.TextAutosizerPageInfo = TextAutosizerPageInfo;
})();