// third_party/blink/public/mojom/frame/remote_frame.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/remote_frame.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var render_frame_metadata$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/render_frame_metadata.mojom', '../../../../../cc/mojom/render_frame_metadata.mojom.js');
  }
  var touch_action$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/touch_action.mojom', '../../../../../cc/mojom/touch_action.mojom.js');
  }
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var source_location$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/source_location.mojom', '../../../../../services/network/public/mojom/source_location.mojom.js');
  }
  var storage_access_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/storage_access_api.mojom', '../../../../../services/network/public/mojom/storage_access_api.mojom.js');
  }
  var url_request$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_request.mojom', '../../../../../services/network/public/mojom/url_request.mojom.js');
  }
  var web_sandbox_flags$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/web_sandbox_flags.mojom', '../../../../../services/network/public/mojom/web_sandbox_flags.mojom.js');
  }
  var frame_sink_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/frame_sink_id.mojom', '../../../../../services/viz/public/mojom/compositing/frame_sink_id.mojom.js');
  }
  var blob_url_store$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob_url_store.mojom', '../blob/blob_url_store.mojom.js');
  }
  var conversions$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/conversions/conversions.mojom', '../conversions/conversions.mojom.js');
  }
  var frame_owner_properties$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/frame_owner_properties.mojom', 'frame_owner_properties.mojom.js');
  }
  var frame_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/frame_policy.mojom', 'frame_policy.mojom.js');
  }
  var navigation_initiator_activation_and_ad_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom', '../navigation/navigation_initiator_activation_and_ad_status.mojom.js');
  }
  var frame_replication_state$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/frame_replication_state.mojom', 'frame_replication_state.mojom.js');
  }
  var frame_visual_properties$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/frame_visual_properties.mojom', 'frame_visual_properties.mojom.js');
  }
  var fullscreen$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/fullscreen.mojom', 'fullscreen.mojom.js');
  }
  var intrinsic_sizing_info$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom', 'intrinsic_sizing_info.mojom.js');
  }
  var lifecycle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/lifecycle.mojom', 'lifecycle.mojom.js');
  }
  var policy_container$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/policy_container.mojom', 'policy_container.mojom.js');
  }
  var text_autosizer_page_info$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom', 'text_autosizer_page_info.mojom.js');
  }
  var tree_scope_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/tree_scope_type.mojom', 'tree_scope_type.mojom.js');
  }
  var triggering_event_info$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/triggering_event_info.mojom', 'triggering_event_info.mojom.js');
  }
  var user_activation_notification_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/user_activation_notification_type.mojom', 'user_activation_notification_type.mojom.js');
  }
  var user_activation_update_types$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/user_activation_update_types.mojom', 'user_activation_update_types.mojom.js');
  }
  var viewport_intersection_state$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/viewport_intersection_state.mojom', 'viewport_intersection_state.mojom.js');
  }
  var focus_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/focus_type.mojom', '../input/focus_type.mojom.js');
  }
  var scroll_direction$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/scroll_direction.mojom', '../input/scroll_direction.mojom.js');
  }
  var referrer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/referrer.mojom', '../loader/referrer.mojom.js');
  }
  var transferable_message$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/transferable_message.mojom', '../messaging/transferable_message.mojom.js');
  }
  var navigation_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/navigation_policy.mojom', '../navigation/navigation_policy.mojom.js');
  }
  var permissions_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy.mojom', '../../../../../services/network/public/mojom/permissions_policy/permissions_policy.mojom.js');
  }
  var scroll_into_view_params$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom', '../scroll/scroll_into_view_params.mojom.js');
  }
  var insecure_request_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/security_context/insecure_request_policy.mojom', '../security_context/insecure_request_policy.mojom.js');
  }
  var resource_timing$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/timing/resource_timing.mojom', '../timing/resource_timing.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var window_open_disposition$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/mojom/window_open_disposition.mojom', '../../../../../ui/base/mojom/window_open_disposition.mojom.js');
  }
  var scroll_granularity$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/events/mojom/scroll_granularity.mojom', '../../../../../ui/events/mojom/scroll_granularity.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function RemoteMainFrameInterfaces(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteMainFrameInterfaces.prototype.initDefaults_ = function() {
    this.mainFrameHost = new associatedBindings.AssociatedInterfacePtrInfo();
    this.mainFrame = new associatedBindings.AssociatedInterfaceRequest();
  };
  RemoteMainFrameInterfaces.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteMainFrameInterfaces.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteMainFrameInterfaces.mainFrameHost
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteMainFrameInterfaces.mainFrame
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteMainFrameInterfaces.encodedSize = codec.kStructHeaderSize + 16;

  RemoteMainFrameInterfaces.decode = function(decoder) {
    var packed;
    var val = new RemoteMainFrameInterfaces();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mainFrameHost =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.mainFrame =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteMainFrameInterfaces.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteMainFrameInterfaces.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.mainFrameHost);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.mainFrame);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrameInterfacesFromRenderer(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameInterfacesFromRenderer.prototype.initDefaults_ = function() {
    this.frame = new associatedBindings.AssociatedInterfacePtrInfo();
    this.frameHostReceiver = new associatedBindings.AssociatedInterfaceRequest();
  };
  RemoteFrameInterfacesFromRenderer.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameInterfacesFromRenderer.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameInterfacesFromRenderer.frame
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameInterfacesFromRenderer.frameHostReceiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameInterfacesFromRenderer.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrameInterfacesFromRenderer.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameInterfacesFromRenderer();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frame =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.frameHostReceiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrameInterfacesFromRenderer.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameInterfacesFromRenderer.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.frame);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.frameHostReceiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrameInterfacesFromBrowser(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameInterfacesFromBrowser.prototype.initDefaults_ = function() {
    this.frameReceiver = new associatedBindings.AssociatedInterfaceRequest();
    this.frameHost = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  RemoteFrameInterfacesFromBrowser.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameInterfacesFromBrowser.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameInterfacesFromBrowser.frameReceiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameInterfacesFromBrowser.frameHost
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameInterfacesFromBrowser.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrameInterfacesFromBrowser.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameInterfacesFromBrowser();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameReceiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.frameHost =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrameInterfacesFromBrowser.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameInterfacesFromBrowser.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.frameReceiver);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.frameHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CreateRemoteChildParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CreateRemoteChildParams.prototype.initDefaults_ = function() {
    this.token = null;
    this.openerFrameToken = null;
    this.treeScopeType = 0;
    this.isLoading = false;
    this.replicationState = null;
    this.ownerProperties = null;
    this.devtoolsFrameToken = null;
    this.frameInterfaces = null;
    this.childParams = null;
  };
  CreateRemoteChildParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CreateRemoteChildParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CreateRemoteChildParams.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.RemoteFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CreateRemoteChildParams.openerFrameToken
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, tokens$.FrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CreateRemoteChildParams.treeScopeType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, tree_scope_type$.TreeScopeType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CreateRemoteChildParams.replicationState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, frame_replication_state$.FrameReplicationState, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CreateRemoteChildParams.ownerProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, frame_owner_properties$.FrameOwnerProperties, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CreateRemoteChildParams.devtoolsFrameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CreateRemoteChildParams.frameInterfaces
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, RemoteFrameInterfacesFromBrowser, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CreateRemoteChildParams.childParams
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 64, 8, new codec.PointerTo(CreateRemoteChildParams), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CreateRemoteChildParams.encodedSize = codec.kStructHeaderSize + 72;

  CreateRemoteChildParams.decode = function(decoder) {
    var packed;
    var val = new CreateRemoteChildParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(tokens$.RemoteFrameToken);
    val.openerFrameToken =
        decoder.decodeStruct(tokens$.FrameToken);
    val.treeScopeType =
        decoder.decodeStruct(new codec.Enum(tree_scope_type$.TreeScopeType));
    packed = decoder.readUint8();
    val.isLoading = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.replicationState =
        decoder.decodeStructPointer(frame_replication_state$.FrameReplicationState);
    val.ownerProperties =
        decoder.decodeStructPointer(frame_owner_properties$.FrameOwnerProperties);
    val.devtoolsFrameToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.frameInterfaces =
        decoder.decodeStructPointer(RemoteFrameInterfacesFromBrowser);
    val.childParams =
        decoder.decodeArrayPointer(new codec.PointerTo(CreateRemoteChildParams));
    return val;
  };

  CreateRemoteChildParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CreateRemoteChildParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.RemoteFrameToken, val.token);
    encoder.encodeStruct(tokens$.FrameToken, val.openerFrameToken);
    encoder.encodeStruct(codec.Int32, val.treeScopeType);
    packed = 0;
    packed |= (val.isLoading & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(frame_replication_state$.FrameReplicationState, val.replicationState);
    encoder.encodeStructPointer(frame_owner_properties$.FrameOwnerProperties, val.ownerProperties);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolsFrameToken);
    encoder.encodeStructPointer(RemoteFrameInterfacesFromBrowser, val.frameInterfaces);
    encoder.encodeArrayPointer(new codec.PointerTo(CreateRemoteChildParams), val.childParams);
  };
  function OpenURLParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OpenURLParams.prototype.initDefaults_ = function() {
    this.url = null;
    this.initiatorOrigin = null;
    this.initiatorBaseUrl = null;
    this.actualNavigationStart = null;
    this.initiatorFrameToken = null;
    this.postBody = null;
    this.extraHeaders = null;
    this.referrer = null;
    this.isFormSubmission = false;
    this.shouldReplaceCurrentEntry = false;
    this.userGesture = false;
    this.isUnfencedTopNavigation = false;
    this.isContainerInitiated = false;
    this.hasRelOpener = false;
    this.disposition = 0;
    this.triggeringEventInfo = 0;
    this.blobUrlToken = new blob_url_store$.BlobURLTokenPtr();
    this.initiatorActivationAndAdStatus = 0;
    this.hrefTranslate = null;
    this.impression = null;
    this.downloadPolicy = null;
    this.sourceLocation = null;
    this.initiatorNavigationStateKeepAliveHandle = new NavigationStateKeepAliveHandlePtr();
    this.storageAccessApiStatus = storage_access_api$.StorageAccessApiStatus.kNone;
  };
  OpenURLParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OpenURLParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 144}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.initiatorOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.initiatorBaseUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.actualNavigationStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.initiatorFrameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, tokens$.LocalFrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.postBody
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, url_request$.URLRequestBody, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.extraHeaders
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.referrer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, referrer$.Referrer, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate OpenURLParams.disposition
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 68, window_open_disposition$.WindowOpenDisposition);
    if (err !== validator.validationError.NONE)
        return err;





    // validate OpenURLParams.triggeringEventInfo
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 72, triggering_event_info$.TriggeringEventInfo);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.blobUrlToken
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 76, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.hrefTranslate
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 88, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.impression
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, conversions$.Impression, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.downloadPolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, navigation_policy$.NavigationDownloadPolicy, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.sourceLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, source_location$.SourceLocation, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.initiatorNavigationStateKeepAliveHandle
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 120, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenURLParams.initiatorActivationAndAdStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 84, navigation_initiator_activation_and_ad_status$.NavigationInitiatorActivationAndAdStatus);
    if (err !== validator.validationError.NONE)
        return err;




    // validate OpenURLParams.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 128, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OpenURLParams.encodedSize = codec.kStructHeaderSize + 136;

  OpenURLParams.decode = function(decoder) {
    var packed;
    var val = new OpenURLParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.initiatorOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.initiatorBaseUrl =
        decoder.decodeStructPointer(url$.Url);
    val.actualNavigationStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.initiatorFrameToken =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    val.postBody =
        decoder.decodeStructPointer(url_request$.URLRequestBody);
    val.extraHeaders =
        decoder.decodeStruct(codec.String);
    val.referrer =
        decoder.decodeStructPointer(referrer$.Referrer);
    packed = decoder.readUint8();
    val.isFormSubmission = (packed >> 0) & 1 ? true : false;
    val.shouldReplaceCurrentEntry = (packed >> 1) & 1 ? true : false;
    val.userGesture = (packed >> 2) & 1 ? true : false;
    val.isUnfencedTopNavigation = (packed >> 3) & 1 ? true : false;
    val.isContainerInitiated = (packed >> 4) & 1 ? true : false;
    val.hasRelOpener = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.disposition =
        decoder.decodeStruct(new codec.Enum(window_open_disposition$.WindowOpenDisposition));
    val.triggeringEventInfo =
        decoder.decodeStruct(new codec.Enum(triggering_event_info$.TriggeringEventInfo));
    val.blobUrlToken =
        decoder.decodeStruct(new codec.NullableInterface(blob_url_store$.BlobURLTokenPtr));
    val.initiatorActivationAndAdStatus =
        decoder.decodeStruct(new codec.Enum(navigation_initiator_activation_and_ad_status$.NavigationInitiatorActivationAndAdStatus));
    val.hrefTranslate =
        decoder.decodeStruct(codec.String);
    val.impression =
        decoder.decodeStructPointer(conversions$.Impression);
    val.downloadPolicy =
        decoder.decodeStructPointer(navigation_policy$.NavigationDownloadPolicy);
    val.sourceLocation =
        decoder.decodeStructPointer(source_location$.SourceLocation);
    val.initiatorNavigationStateKeepAliveHandle =
        decoder.decodeStruct(new codec.NullableInterface(NavigationStateKeepAliveHandlePtr));
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OpenURLParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OpenURLParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(origin$.Origin, val.initiatorOrigin);
    encoder.encodeStructPointer(url$.Url, val.initiatorBaseUrl);
    encoder.encodeStructPointer(time$.TimeTicks, val.actualNavigationStart);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.initiatorFrameToken);
    encoder.encodeStructPointer(url_request$.URLRequestBody, val.postBody);
    encoder.encodeStruct(codec.String, val.extraHeaders);
    encoder.encodeStructPointer(referrer$.Referrer, val.referrer);
    packed = 0;
    packed |= (val.isFormSubmission & 1) << 0
    packed |= (val.shouldReplaceCurrentEntry & 1) << 1
    packed |= (val.userGesture & 1) << 2
    packed |= (val.isUnfencedTopNavigation & 1) << 3
    packed |= (val.isContainerInitiated & 1) << 4
    packed |= (val.hasRelOpener & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.disposition);
    encoder.encodeStruct(codec.Int32, val.triggeringEventInfo);
    encoder.encodeStruct(new codec.NullableInterface(blob_url_store$.BlobURLTokenPtr), val.blobUrlToken);
    encoder.encodeStruct(codec.Int32, val.initiatorActivationAndAdStatus);
    encoder.encodeStruct(codec.String, val.hrefTranslate);
    encoder.encodeStructPointer(conversions$.Impression, val.impression);
    encoder.encodeStructPointer(navigation_policy$.NavigationDownloadPolicy, val.downloadPolicy);
    encoder.encodeStructPointer(source_location$.SourceLocation, val.sourceLocation);
    encoder.encodeStruct(new codec.NullableInterface(NavigationStateKeepAliveHandlePtr), val.initiatorNavigationStateKeepAliveHandle);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrameHost_SetInheritedEffectiveTouchAction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.prototype.initDefaults_ = function() {
    this.touchAction = 0;
  };
  RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.touchAction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, touch_action$.TouchAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_SetInheritedEffectiveTouchAction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.touchAction =
        decoder.decodeStruct(new codec.Enum(touch_action$.TouchAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.touchAction);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrameHost_UpdateRenderThrottlingStatus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_UpdateRenderThrottlingStatus_Params.prototype.initDefaults_ = function() {
    this.isThrottled = false;
    this.subtreeThrottled = false;
    this.displayLocked = false;
  };
  RemoteFrameHost_UpdateRenderThrottlingStatus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_UpdateRenderThrottlingStatus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  RemoteFrameHost_UpdateRenderThrottlingStatus_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrameHost_UpdateRenderThrottlingStatus_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_UpdateRenderThrottlingStatus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isThrottled = (packed >> 0) & 1 ? true : false;
    val.subtreeThrottled = (packed >> 1) & 1 ? true : false;
    val.displayLocked = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrameHost_UpdateRenderThrottlingStatus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_UpdateRenderThrottlingStatus_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isThrottled & 1) << 0
    packed |= (val.subtreeThrottled & 1) << 1
    packed |= (val.displayLocked & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrameHost_VisibilityChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_VisibilityChanged_Params.prototype.initDefaults_ = function() {
    this.visibility = 0;
  };
  RemoteFrameHost_VisibilityChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_VisibilityChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_VisibilityChanged_Params.visibility
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, lifecycle$.FrameVisibility);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_VisibilityChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrameHost_VisibilityChanged_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_VisibilityChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.visibility =
        decoder.decodeStruct(new codec.Enum(lifecycle$.FrameVisibility));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrameHost_VisibilityChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_VisibilityChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.visibility);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrameHost_DidFocusFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_DidFocusFrame_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrameHost_DidFocusFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_DidFocusFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_DidFocusFrame_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrameHost_DidFocusFrame_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_DidFocusFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrameHost_DidFocusFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_DidFocusFrame_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrameHost_CheckCompleted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_CheckCompleted_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrameHost_CheckCompleted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_CheckCompleted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_CheckCompleted_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrameHost_CheckCompleted_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_CheckCompleted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrameHost_CheckCompleted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_CheckCompleted_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.prototype.initDefaults_ = function() {
    this.clipRect = null;
    this.guid = null;
  };
  RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.clipRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.guid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.clipRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.guid =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.clipRect);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.guid);
  };
  function RemoteFrameHost_SetIsInert_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_SetIsInert_Params.prototype.initDefaults_ = function() {
    this.inert = false;
  };
  RemoteFrameHost_SetIsInert_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_SetIsInert_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrameHost_SetIsInert_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrameHost_SetIsInert_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_SetIsInert_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.inert = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrameHost_SetIsInert_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_SetIsInert_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.inert & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrameHost_DidChangeOpener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_DidChangeOpener_Params.prototype.initDefaults_ = function() {
    this.openerFrame = null;
  };
  RemoteFrameHost_DidChangeOpener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_DidChangeOpener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_DidChangeOpener_Params.openerFrame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.LocalFrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_DidChangeOpener_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrameHost_DidChangeOpener_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_DidChangeOpener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.openerFrame =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    return val;
  };

  RemoteFrameHost_DidChangeOpener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_DidChangeOpener_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.openerFrame);
  };
  function RemoteFrameHost_AdvanceFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_AdvanceFocus_Params.prototype.initDefaults_ = function() {
    this.focusType = 0;
    this.sourceFrameToken = null;
  };
  RemoteFrameHost_AdvanceFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_AdvanceFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_AdvanceFocus_Params.focusType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, focus_type$.FocusType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_AdvanceFocus_Params.sourceFrameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, tokens$.LocalFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_AdvanceFocus_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrameHost_AdvanceFocus_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_AdvanceFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.focusType =
        decoder.decodeStruct(new codec.Enum(focus_type$.FocusType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sourceFrameToken =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    return val;
  };

  RemoteFrameHost_AdvanceFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_AdvanceFocus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.focusType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.sourceFrameToken);
  };
  function RemoteFrameHost_RouteMessageEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_RouteMessageEvent_Params.prototype.initDefaults_ = function() {
    this.sourceFrameToken = null;
    this.sourceOrigin = null;
    this.targetOrigin = null;
    this.message = null;
  };
  RemoteFrameHost_RouteMessageEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_RouteMessageEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_RouteMessageEvent_Params.sourceFrameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.LocalFrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_RouteMessageEvent_Params.sourceOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_RouteMessageEvent_Params.targetOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_RouteMessageEvent_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, transferable_message$.TransferableMessage, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_RouteMessageEvent_Params.encodedSize = codec.kStructHeaderSize + 32;

  RemoteFrameHost_RouteMessageEvent_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_RouteMessageEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceFrameToken =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    val.sourceOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.targetOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.message =
        decoder.decodeStructPointer(transferable_message$.TransferableMessage);
    return val;
  };

  RemoteFrameHost_RouteMessageEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_RouteMessageEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.sourceFrameToken);
    encoder.encodeStructPointer(origin$.Origin, val.sourceOrigin);
    encoder.encodeStructPointer(origin$.Origin, val.targetOrigin);
    encoder.encodeStructPointer(transferable_message$.TransferableMessage, val.message);
  };
  function RemoteFrameHost_PrintCrossProcessSubframe_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_PrintCrossProcessSubframe_Params.prototype.initDefaults_ = function() {
    this.frameContentRect = null;
    this.documentCookie = 0;
  };
  RemoteFrameHost_PrintCrossProcessSubframe_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_PrintCrossProcessSubframe_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_PrintCrossProcessSubframe_Params.frameContentRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrameHost_PrintCrossProcessSubframe_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrameHost_PrintCrossProcessSubframe_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_PrintCrossProcessSubframe_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameContentRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.documentCookie =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrameHost_PrintCrossProcessSubframe_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_PrintCrossProcessSubframe_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.frameContentRect);
    encoder.encodeStruct(codec.Int32, val.documentCookie);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrameHost_Detach_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_Detach_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrameHost_Detach_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_Detach_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_Detach_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrameHost_Detach_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_Detach_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrameHost_Detach_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_Detach_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrameHost_UpdateViewportIntersection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_UpdateViewportIntersection_Params.prototype.initDefaults_ = function() {
    this.intersectionState = null;
    this.visualProperties = null;
  };
  RemoteFrameHost_UpdateViewportIntersection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_UpdateViewportIntersection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_UpdateViewportIntersection_Params.intersectionState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, viewport_intersection_state$.ViewportIntersectionState, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_UpdateViewportIntersection_Params.visualProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, frame_visual_properties$.FrameVisualProperties, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_UpdateViewportIntersection_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrameHost_UpdateViewportIntersection_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_UpdateViewportIntersection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.intersectionState =
        decoder.decodeStructPointer(viewport_intersection_state$.ViewportIntersectionState);
    val.visualProperties =
        decoder.decodeStructPointer(frame_visual_properties$.FrameVisualProperties);
    return val;
  };

  RemoteFrameHost_UpdateViewportIntersection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_UpdateViewportIntersection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(viewport_intersection_state$.ViewportIntersectionState, val.intersectionState);
    encoder.encodeStructPointer(frame_visual_properties$.FrameVisualProperties, val.visualProperties);
  };
  function RemoteFrameHost_SynchronizeVisualProperties_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_SynchronizeVisualProperties_Params.prototype.initDefaults_ = function() {
    this.properties = null;
  };
  RemoteFrameHost_SynchronizeVisualProperties_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_SynchronizeVisualProperties_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_SynchronizeVisualProperties_Params.properties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, frame_visual_properties$.FrameVisualProperties, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_SynchronizeVisualProperties_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrameHost_SynchronizeVisualProperties_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_SynchronizeVisualProperties_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.properties =
        decoder.decodeStructPointer(frame_visual_properties$.FrameVisualProperties);
    return val;
  };

  RemoteFrameHost_SynchronizeVisualProperties_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_SynchronizeVisualProperties_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(frame_visual_properties$.FrameVisualProperties, val.properties);
  };
  function RemoteFrameHost_OpenURL_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameHost_OpenURL_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  RemoteFrameHost_OpenURL_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameHost_OpenURL_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameHost_OpenURL_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OpenURLParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameHost_OpenURL_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrameHost_OpenURL_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameHost_OpenURL_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(OpenURLParams);
    return val;
  };

  RemoteFrameHost_OpenURL_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameHost_OpenURL_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OpenURLParams, val.params);
  };
  function RemoteFrame_WillEnterFullscreen_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_WillEnterFullscreen_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  RemoteFrame_WillEnterFullscreen_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_WillEnterFullscreen_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_WillEnterFullscreen_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fullscreen$.FullscreenOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_WillEnterFullscreen_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_WillEnterFullscreen_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_WillEnterFullscreen_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(fullscreen$.FullscreenOptions);
    return val;
  };

  RemoteFrame_WillEnterFullscreen_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_WillEnterFullscreen_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fullscreen$.FullscreenOptions, val.options);
  };
  function RemoteFrame_EnforceInsecureNavigationsSet_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_EnforceInsecureNavigationsSet_Params.prototype.initDefaults_ = function() {
    this.set = null;
  };
  RemoteFrame_EnforceInsecureNavigationsSet_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_EnforceInsecureNavigationsSet_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_EnforceInsecureNavigationsSet_Params.set
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_EnforceInsecureNavigationsSet_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_EnforceInsecureNavigationsSet_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_EnforceInsecureNavigationsSet_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.set =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  RemoteFrame_EnforceInsecureNavigationsSet_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_EnforceInsecureNavigationsSet_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.set);
  };
  function RemoteFrame_SetFrameOwnerProperties_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetFrameOwnerProperties_Params.prototype.initDefaults_ = function() {
    this.properties = null;
  };
  RemoteFrame_SetFrameOwnerProperties_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetFrameOwnerProperties_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_SetFrameOwnerProperties_Params.properties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, frame_owner_properties$.FrameOwnerProperties, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_SetFrameOwnerProperties_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_SetFrameOwnerProperties_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetFrameOwnerProperties_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.properties =
        decoder.decodeStructPointer(frame_owner_properties$.FrameOwnerProperties);
    return val;
  };

  RemoteFrame_SetFrameOwnerProperties_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetFrameOwnerProperties_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(frame_owner_properties$.FrameOwnerProperties, val.properties);
  };
  function RemoteFrame_EnforceInsecureRequestPolicy_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_EnforceInsecureRequestPolicy_Params.prototype.initDefaults_ = function() {
    this.policy = 0;
  };
  RemoteFrame_EnforceInsecureRequestPolicy_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_EnforceInsecureRequestPolicy_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_EnforceInsecureRequestPolicy_Params.policy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, insecure_request_policy$.InsecureRequestPolicy);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_EnforceInsecureRequestPolicy_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_EnforceInsecureRequestPolicy_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_EnforceInsecureRequestPolicy_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.policy =
        decoder.decodeStruct(new codec.Enum(insecure_request_policy$.InsecureRequestPolicy));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrame_EnforceInsecureRequestPolicy_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_EnforceInsecureRequestPolicy_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.policy);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrame_SetReplicatedOrigin_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetReplicatedOrigin_Params.prototype.initDefaults_ = function() {
    this.origin = null;
    this.isPotentiallyTrustworthyUniqueOrigin = false;
  };
  RemoteFrame_SetReplicatedOrigin_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetReplicatedOrigin_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_SetReplicatedOrigin_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrame_SetReplicatedOrigin_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrame_SetReplicatedOrigin_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetReplicatedOrigin_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    packed = decoder.readUint8();
    val.isPotentiallyTrustworthyUniqueOrigin = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrame_SetReplicatedOrigin_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetReplicatedOrigin_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    packed = 0;
    packed |= (val.isPotentiallyTrustworthyUniqueOrigin & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrame_SetReplicatedIsAdFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetReplicatedIsAdFrame_Params.prototype.initDefaults_ = function() {
    this.isAdFrame = false;
  };
  RemoteFrame_SetReplicatedIsAdFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetReplicatedIsAdFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrame_SetReplicatedIsAdFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_SetReplicatedIsAdFrame_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetReplicatedIsAdFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isAdFrame = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrame_SetReplicatedIsAdFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetReplicatedIsAdFrame_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isAdFrame & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrame_SetReplicatedName_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetReplicatedName_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.uniqueName = null;
  };
  RemoteFrame_SetReplicatedName_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetReplicatedName_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_SetReplicatedName_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_SetReplicatedName_Params.uniqueName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_SetReplicatedName_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrame_SetReplicatedName_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetReplicatedName_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.uniqueName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RemoteFrame_SetReplicatedName_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetReplicatedName_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.uniqueName);
  };
  function RemoteFrame_DispatchLoadEventForFrameOwner_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_DispatchLoadEventForFrameOwner_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrame_DispatchLoadEventForFrameOwner_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_DispatchLoadEventForFrameOwner_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_DispatchLoadEventForFrameOwner_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrame_DispatchLoadEventForFrameOwner_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_DispatchLoadEventForFrameOwner_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrame_DispatchLoadEventForFrameOwner_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_DispatchLoadEventForFrameOwner_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrame_SetNeedsOcclusionTracking_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetNeedsOcclusionTracking_Params.prototype.initDefaults_ = function() {
    this.needsTracking = false;
  };
  RemoteFrame_SetNeedsOcclusionTracking_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetNeedsOcclusionTracking_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrame_SetNeedsOcclusionTracking_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_SetNeedsOcclusionTracking_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetNeedsOcclusionTracking_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.needsTracking = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrame_SetNeedsOcclusionTracking_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetNeedsOcclusionTracking_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.needsTracking & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrame_Collapse_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_Collapse_Params.prototype.initDefaults_ = function() {
    this.collapsed = false;
  };
  RemoteFrame_Collapse_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_Collapse_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrame_Collapse_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_Collapse_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_Collapse_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.collapsed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrame_Collapse_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_Collapse_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.collapsed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrame_Focus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_Focus_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrame_Focus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_Focus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_Focus_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrame_Focus_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_Focus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrame_Focus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_Focus_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params.prototype.initDefaults_ = function() {
    this.hasGesture = false;
  };
  RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasGesture = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasGesture & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrame_BubbleLogicalScroll_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_BubbleLogicalScroll_Params.prototype.initDefaults_ = function() {
    this.direction = 0;
    this.granularity = 0;
  };
  RemoteFrame_BubbleLogicalScroll_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_BubbleLogicalScroll_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_BubbleLogicalScroll_Params.direction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, scroll_direction$.ScrollDirection);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_BubbleLogicalScroll_Params.granularity
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, scroll_granularity$.ScrollGranularity);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_BubbleLogicalScroll_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_BubbleLogicalScroll_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_BubbleLogicalScroll_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.direction =
        decoder.decodeStruct(new codec.Enum(scroll_direction$.ScrollDirection));
    val.granularity =
        decoder.decodeStruct(new codec.Enum(scroll_granularity$.ScrollGranularity));
    return val;
  };

  RemoteFrame_BubbleLogicalScroll_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_BubbleLogicalScroll_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.direction);
    encoder.encodeStruct(codec.Int32, val.granularity);
  };
  function RemoteFrame_UpdateUserActivationState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_UpdateUserActivationState_Params.prototype.initDefaults_ = function() {
    this.stateUpdateType = 0;
    this.notificationType = 0;
  };
  RemoteFrame_UpdateUserActivationState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_UpdateUserActivationState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_UpdateUserActivationState_Params.stateUpdateType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, user_activation_update_types$.UserActivationUpdateType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_UpdateUserActivationState_Params.notificationType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, user_activation_notification_type$.UserActivationNotificationType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_UpdateUserActivationState_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_UpdateUserActivationState_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_UpdateUserActivationState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.stateUpdateType =
        decoder.decodeStruct(new codec.Enum(user_activation_update_types$.UserActivationUpdateType));
    val.notificationType =
        decoder.decodeStruct(new codec.Enum(user_activation_notification_type$.UserActivationNotificationType));
    return val;
  };

  RemoteFrame_UpdateUserActivationState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_UpdateUserActivationState_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.stateUpdateType);
    encoder.encodeStruct(codec.Int32, val.notificationType);
  };
  function RemoteFrame_SetEmbeddingToken_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetEmbeddingToken_Params.prototype.initDefaults_ = function() {
    this.embeddingToken = null;
  };
  RemoteFrame_SetEmbeddingToken_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetEmbeddingToken_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_SetEmbeddingToken_Params.embeddingToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_SetEmbeddingToken_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_SetEmbeddingToken_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetEmbeddingToken_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.embeddingToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  RemoteFrame_SetEmbeddingToken_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetEmbeddingToken_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.embeddingToken);
  };
  function RemoteFrame_SetPageFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetPageFocus_Params.prototype.initDefaults_ = function() {
    this.isFocused = false;
  };
  RemoteFrame_SetPageFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetPageFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrame_SetPageFocus_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_SetPageFocus_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetPageFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isFocused = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrame_SetPageFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetPageFocus_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isFocused & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrame_RenderFallbackContent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_RenderFallbackContent_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrame_RenderFallbackContent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_RenderFallbackContent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_RenderFallbackContent_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrame_RenderFallbackContent_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_RenderFallbackContent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrame_RenderFallbackContent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_RenderFallbackContent_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrame_AddResourceTimingFromChild_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_AddResourceTimingFromChild_Params.prototype.initDefaults_ = function() {
    this.timing = null;
  };
  RemoteFrame_AddResourceTimingFromChild_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_AddResourceTimingFromChild_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_AddResourceTimingFromChild_Params.timing
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, resource_timing$.ResourceTimingInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_AddResourceTimingFromChild_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_AddResourceTimingFromChild_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_AddResourceTimingFromChild_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.timing =
        decoder.decodeStructPointer(resource_timing$.ResourceTimingInfo);
    return val;
  };

  RemoteFrame_AddResourceTimingFromChild_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_AddResourceTimingFromChild_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(resource_timing$.ResourceTimingInfo, val.timing);
  };
  function RemoteFrame_ScrollRectToVisible_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_ScrollRectToVisible_Params.prototype.initDefaults_ = function() {
    this.rect = null;
    this.params = null;
  };
  RemoteFrame_ScrollRectToVisible_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_ScrollRectToVisible_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_ScrollRectToVisible_Params.rect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_ScrollRectToVisible_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, scroll_into_view_params$.ScrollIntoViewParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_ScrollRectToVisible_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrame_ScrollRectToVisible_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_ScrollRectToVisible_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rect =
        decoder.decodeStructPointer(geometry$.RectF);
    val.params =
        decoder.decodeStructPointer(scroll_into_view_params$.ScrollIntoViewParams);
    return val;
  };

  RemoteFrame_ScrollRectToVisible_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_ScrollRectToVisible_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.RectF, val.rect);
    encoder.encodeStructPointer(scroll_into_view_params$.ScrollIntoViewParams, val.params);
  };
  function RemoteFrame_DidStartLoading_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_DidStartLoading_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrame_DidStartLoading_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_DidStartLoading_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_DidStartLoading_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrame_DidStartLoading_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_DidStartLoading_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrame_DidStartLoading_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_DidStartLoading_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrame_DidStopLoading_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_DidStopLoading_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrame_DidStopLoading_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_DidStopLoading_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_DidStopLoading_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrame_DidStopLoading_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_DidStopLoading_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrame_DidStopLoading_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_DidStopLoading_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.prototype.initDefaults_ = function() {
    this.sizingInfo = null;
  };
  RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.sizingInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, intrinsic_sizing_info$.IntrinsicSizingInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sizingInfo =
        decoder.decodeStructPointer(intrinsic_sizing_info$.IntrinsicSizingInfo);
    return val;
  };

  RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(intrinsic_sizing_info$.IntrinsicSizingInfo, val.sizingInfo);
  };
  function RemoteFrame_DidSetFramePolicyHeaders_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_DidSetFramePolicyHeaders_Params.prototype.initDefaults_ = function() {
    this.sandboxFlags = 0;
    this.parsedPermissionsPolicy = null;
  };
  RemoteFrame_DidSetFramePolicyHeaders_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_DidSetFramePolicyHeaders_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_DidSetFramePolicyHeaders_Params.sandboxFlags
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, web_sandbox_flags$.WebSandboxFlags);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_DidSetFramePolicyHeaders_Params.parsedPermissionsPolicy
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_DidSetFramePolicyHeaders_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrame_DidSetFramePolicyHeaders_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_DidSetFramePolicyHeaders_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sandboxFlags =
        decoder.decodeStruct(new codec.Enum(web_sandbox_flags$.WebSandboxFlags));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.parsedPermissionsPolicy =
        decoder.decodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration));
    return val;
  };

  RemoteFrame_DidSetFramePolicyHeaders_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_DidSetFramePolicyHeaders_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.sandboxFlags);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), val.parsedPermissionsPolicy);
  };
  function RemoteFrame_DidUpdateFramePolicy_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_DidUpdateFramePolicy_Params.prototype.initDefaults_ = function() {
    this.framePolicy = null;
  };
  RemoteFrame_DidUpdateFramePolicy_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_DidUpdateFramePolicy_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_DidUpdateFramePolicy_Params.framePolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, frame_policy$.FramePolicy, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_DidUpdateFramePolicy_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_DidUpdateFramePolicy_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_DidUpdateFramePolicy_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.framePolicy =
        decoder.decodeStructPointer(frame_policy$.FramePolicy);
    return val;
  };

  RemoteFrame_DidUpdateFramePolicy_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_DidUpdateFramePolicy_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(frame_policy$.FramePolicy, val.framePolicy);
  };
  function RemoteFrame_UpdateOpener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_UpdateOpener_Params.prototype.initDefaults_ = function() {
    this.openerFrameToken = null;
  };
  RemoteFrame_UpdateOpener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_UpdateOpener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_UpdateOpener_Params.openerFrameToken
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, tokens$.FrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_UpdateOpener_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrame_UpdateOpener_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_UpdateOpener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.openerFrameToken =
        decoder.decodeStruct(tokens$.FrameToken);
    return val;
  };

  RemoteFrame_UpdateOpener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_UpdateOpener_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(tokens$.FrameToken, val.openerFrameToken);
  };
  function RemoteFrame_DetachAndDispose_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_DetachAndDispose_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrame_DetachAndDispose_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_DetachAndDispose_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_DetachAndDispose_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrame_DetachAndDispose_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_DetachAndDispose_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrame_DetachAndDispose_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_DetachAndDispose_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrame_EnableAutoResize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_EnableAutoResize_Params.prototype.initDefaults_ = function() {
    this.minSize = null;
    this.maxSize = null;
  };
  RemoteFrame_EnableAutoResize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_EnableAutoResize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_EnableAutoResize_Params.minSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_EnableAutoResize_Params.maxSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_EnableAutoResize_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrame_EnableAutoResize_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_EnableAutoResize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.minSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.maxSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  RemoteFrame_EnableAutoResize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_EnableAutoResize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.minSize);
    encoder.encodeStructPointer(geometry$.Size, val.maxSize);
  };
  function RemoteFrame_DisableAutoResize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_DisableAutoResize_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrame_DisableAutoResize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_DisableAutoResize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_DisableAutoResize_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrame_DisableAutoResize_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_DisableAutoResize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrame_DisableAutoResize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_DisableAutoResize_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrame_DidUpdateVisualProperties_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_DidUpdateVisualProperties_Params.prototype.initDefaults_ = function() {
    this.metadata = null;
  };
  RemoteFrame_DidUpdateVisualProperties_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_DidUpdateVisualProperties_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_DidUpdateVisualProperties_Params.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, render_frame_metadata$.RenderFrameMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_DidUpdateVisualProperties_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_DidUpdateVisualProperties_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_DidUpdateVisualProperties_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.metadata =
        decoder.decodeStructPointer(render_frame_metadata$.RenderFrameMetadata);
    return val;
  };

  RemoteFrame_DidUpdateVisualProperties_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_DidUpdateVisualProperties_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(render_frame_metadata$.RenderFrameMetadata, val.metadata);
  };
  function RemoteFrame_SetFrameSinkId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_SetFrameSinkId_Params.prototype.initDefaults_ = function() {
    this.frameSinkId = null;
    this.allowPaintHolding = false;
  };
  RemoteFrame_SetFrameSinkId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_SetFrameSinkId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_SetFrameSinkId_Params.frameSinkId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, frame_sink_id$.FrameSinkId, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteFrame_SetFrameSinkId_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrame_SetFrameSinkId_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_SetFrameSinkId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameSinkId =
        decoder.decodeStructPointer(frame_sink_id$.FrameSinkId);
    packed = decoder.readUint8();
    val.allowPaintHolding = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteFrame_SetFrameSinkId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_SetFrameSinkId_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(frame_sink_id$.FrameSinkId, val.frameSinkId);
    packed = 0;
    packed |= (val.allowPaintHolding & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteFrame_ChildProcessGone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_ChildProcessGone_Params.prototype.initDefaults_ = function() {
  };
  RemoteFrame_ChildProcessGone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_ChildProcessGone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_ChildProcessGone_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteFrame_ChildProcessGone_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_ChildProcessGone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteFrame_ChildProcessGone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_ChildProcessGone_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteFrame_CreateRemoteChild_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_CreateRemoteChild_Params.prototype.initDefaults_ = function() {
    this.token = null;
    this.openerFrameToken = null;
    this.treeScopeType = 0;
    this.isLoading = false;
    this.replicationState = null;
    this.ownerProperties = null;
    this.devtoolsFrameToken = null;
    this.remoteFrameInterfaces = null;
  };
  RemoteFrame_CreateRemoteChild_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_CreateRemoteChild_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_CreateRemoteChild_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.RemoteFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_CreateRemoteChild_Params.openerFrameToken
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, tokens$.FrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_CreateRemoteChild_Params.treeScopeType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, tree_scope_type$.TreeScopeType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_CreateRemoteChild_Params.replicationState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, frame_replication_state$.FrameReplicationState, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_CreateRemoteChild_Params.ownerProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, frame_owner_properties$.FrameOwnerProperties, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate RemoteFrame_CreateRemoteChild_Params.devtoolsFrameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_CreateRemoteChild_Params.remoteFrameInterfaces
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, RemoteFrameInterfacesFromBrowser, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_CreateRemoteChild_Params.encodedSize = codec.kStructHeaderSize + 64;

  RemoteFrame_CreateRemoteChild_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_CreateRemoteChild_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(tokens$.RemoteFrameToken);
    val.openerFrameToken =
        decoder.decodeStruct(tokens$.FrameToken);
    val.treeScopeType =
        decoder.decodeStruct(new codec.Enum(tree_scope_type$.TreeScopeType));
    packed = decoder.readUint8();
    val.isLoading = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.replicationState =
        decoder.decodeStructPointer(frame_replication_state$.FrameReplicationState);
    val.ownerProperties =
        decoder.decodeStructPointer(frame_owner_properties$.FrameOwnerProperties);
    val.devtoolsFrameToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.remoteFrameInterfaces =
        decoder.decodeStructPointer(RemoteFrameInterfacesFromBrowser);
    return val;
  };

  RemoteFrame_CreateRemoteChild_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_CreateRemoteChild_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.RemoteFrameToken, val.token);
    encoder.encodeStruct(tokens$.FrameToken, val.openerFrameToken);
    encoder.encodeStruct(codec.Int32, val.treeScopeType);
    packed = 0;
    packed |= (val.isLoading & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(frame_replication_state$.FrameReplicationState, val.replicationState);
    encoder.encodeStructPointer(frame_owner_properties$.FrameOwnerProperties, val.ownerProperties);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolsFrameToken);
    encoder.encodeStructPointer(RemoteFrameInterfacesFromBrowser, val.remoteFrameInterfaces);
  };
  function RemoteFrame_CreateRemoteChildren_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_CreateRemoteChildren_Params.prototype.initDefaults_ = function() {
    this.params = null;
    this.navigationMetricsToken = null;
  };
  RemoteFrame_CreateRemoteChildren_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_CreateRemoteChildren_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_CreateRemoteChildren_Params.params
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(CreateRemoteChildParams), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_CreateRemoteChildren_Params.navigationMetricsToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_CreateRemoteChildren_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteFrame_CreateRemoteChildren_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_CreateRemoteChildren_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeArrayPointer(new codec.PointerTo(CreateRemoteChildParams));
    val.navigationMetricsToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  RemoteFrame_CreateRemoteChildren_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_CreateRemoteChildren_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(CreateRemoteChildParams), val.params);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.navigationMetricsToken);
  };
  function RemoteFrame_ForwardFencedFrameEventToEmbedder_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.prototype.initDefaults_ = function() {
    this.eventType = null;
  };
  RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.eventType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteFrame_ForwardFencedFrameEventToEmbedder_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventType =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.eventType);
  };
  function RemoteMainFrame_UpdateTextAutosizerPageInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.prototype.initDefaults_ = function() {
    this.pageInfo = null;
  };
  RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.pageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, text_autosizer_page_info$.TextAutosizerPageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteMainFrame_UpdateTextAutosizerPageInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pageInfo =
        decoder.decodeStructPointer(text_autosizer_page_info$.TextAutosizerPageInfo);
    return val;
  };

  RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(text_autosizer_page_info$.TextAutosizerPageInfo, val.pageInfo);
  };
  function RemoteMainFrameHost_FocusPage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteMainFrameHost_FocusPage_Params.prototype.initDefaults_ = function() {
  };
  RemoteMainFrameHost_FocusPage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteMainFrameHost_FocusPage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteMainFrameHost_FocusPage_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteMainFrameHost_FocusPage_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteMainFrameHost_FocusPage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteMainFrameHost_FocusPage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteMainFrameHost_FocusPage_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteMainFrameHost_TakeFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteMainFrameHost_TakeFocus_Params.prototype.initDefaults_ = function() {
    this.reverse = false;
  };
  RemoteMainFrameHost_TakeFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteMainFrameHost_TakeFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteMainFrameHost_TakeFocus_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteMainFrameHost_TakeFocus_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteMainFrameHost_TakeFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.reverse = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteMainFrameHost_TakeFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteMainFrameHost_TakeFocus_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.reverse & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteMainFrameHost_UpdateTargetURL_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteMainFrameHost_UpdateTargetURL_Params.prototype.initDefaults_ = function() {
    this.url = null;
  };
  RemoteMainFrameHost_UpdateTargetURL_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteMainFrameHost_UpdateTargetURL_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteMainFrameHost_UpdateTargetURL_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteMainFrameHost_UpdateTargetURL_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteMainFrameHost_UpdateTargetURL_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteMainFrameHost_UpdateTargetURL_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  RemoteMainFrameHost_UpdateTargetURL_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteMainFrameHost_UpdateTargetURL_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function RemoteMainFrameHost_UpdateTargetURL_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteMainFrameHost_UpdateTargetURL_ResponseParams.prototype.initDefaults_ = function() {
  };
  RemoteMainFrameHost_UpdateTargetURL_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteMainFrameHost_UpdateTargetURL_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteMainFrameHost_UpdateTargetURL_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  RemoteMainFrameHost_UpdateTargetURL_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RemoteMainFrameHost_UpdateTargetURL_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteMainFrameHost_UpdateTargetURL_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteMainFrameHost_UpdateTargetURL_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteMainFrameHost_RouteCloseEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteMainFrameHost_RouteCloseEvent_Params.prototype.initDefaults_ = function() {
  };
  RemoteMainFrameHost_RouteCloseEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteMainFrameHost_RouteCloseEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteMainFrameHost_RouteCloseEvent_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteMainFrameHost_RouteCloseEvent_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteMainFrameHost_RouteCloseEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteMainFrameHost_RouteCloseEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteMainFrameHost_RouteCloseEvent_Params.encodedSize);
    encoder.writeUint32(0);
  };

  function NavigationStateKeepAliveHandlePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NavigationStateKeepAliveHandle,
                                                   handleOrPtrInfo);
  }

  function NavigationStateKeepAliveHandleAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NavigationStateKeepAliveHandle, associatedInterfacePtrInfo);
  }

  NavigationStateKeepAliveHandleAssociatedPtr.prototype =
      Object.create(NavigationStateKeepAliveHandlePtr.prototype);
  NavigationStateKeepAliveHandleAssociatedPtr.prototype.constructor =
      NavigationStateKeepAliveHandleAssociatedPtr;

  function NavigationStateKeepAliveHandleProxy(receiver) {
    this.receiver_ = receiver;
  }

  function NavigationStateKeepAliveHandleStub(delegate) {
    this.delegate_ = delegate;
  }

  NavigationStateKeepAliveHandleStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  NavigationStateKeepAliveHandleStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateNavigationStateKeepAliveHandleRequest(messageValidator) {
    return validator.validationError.NONE;
  }

  function validateNavigationStateKeepAliveHandleResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var NavigationStateKeepAliveHandle = {
    name: 'blink.mojom.NavigationStateKeepAliveHandle',
    kVersion: 0,
    ptrClass: NavigationStateKeepAliveHandlePtr,
    proxyClass: NavigationStateKeepAliveHandleProxy,
    stubClass: NavigationStateKeepAliveHandleStub,
    validateRequest: validateNavigationStateKeepAliveHandleRequest,
    validateResponse: null,
  };
  NavigationStateKeepAliveHandleStub.prototype.validator = validateNavigationStateKeepAliveHandleRequest;
  NavigationStateKeepAliveHandleProxy.prototype.validator = null;
  var kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name = 0;
  var kRemoteFrameHost_UpdateRenderThrottlingStatus_Name = 1;
  var kRemoteFrameHost_VisibilityChanged_Name = 2;
  var kRemoteFrameHost_DidFocusFrame_Name = 3;
  var kRemoteFrameHost_CheckCompleted_Name = 4;
  var kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name = 5;
  var kRemoteFrameHost_SetIsInert_Name = 6;
  var kRemoteFrameHost_DidChangeOpener_Name = 7;
  var kRemoteFrameHost_AdvanceFocus_Name = 8;
  var kRemoteFrameHost_RouteMessageEvent_Name = 9;
  var kRemoteFrameHost_PrintCrossProcessSubframe_Name = 10;
  var kRemoteFrameHost_Detach_Name = 11;
  var kRemoteFrameHost_UpdateViewportIntersection_Name = 12;
  var kRemoteFrameHost_SynchronizeVisualProperties_Name = 13;
  var kRemoteFrameHost_OpenURL_Name = 14;

  function RemoteFrameHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RemoteFrameHost,
                                                   handleOrPtrInfo);
  }

  function RemoteFrameHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RemoteFrameHost, associatedInterfacePtrInfo);
  }

  RemoteFrameHostAssociatedPtr.prototype =
      Object.create(RemoteFrameHostPtr.prototype);
  RemoteFrameHostAssociatedPtr.prototype.constructor =
      RemoteFrameHostAssociatedPtr;

  function RemoteFrameHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  RemoteFrameHostPtr.prototype.setInheritedEffectiveTouchAction = function() {
    return RemoteFrameHostProxy.prototype.setInheritedEffectiveTouchAction
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.setInheritedEffectiveTouchAction = function(touchAction) {
    var params_ = new RemoteFrameHost_SetInheritedEffectiveTouchAction_Params();
    params_.touchAction = touchAction;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name,
        codec.align(RemoteFrameHost_SetInheritedEffectiveTouchAction_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_SetInheritedEffectiveTouchAction_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.updateRenderThrottlingStatus = function() {
    return RemoteFrameHostProxy.prototype.updateRenderThrottlingStatus
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.updateRenderThrottlingStatus = function(isThrottled, subtreeThrottled, displayLocked) {
    var params_ = new RemoteFrameHost_UpdateRenderThrottlingStatus_Params();
    params_.isThrottled = isThrottled;
    params_.subtreeThrottled = subtreeThrottled;
    params_.displayLocked = displayLocked;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_UpdateRenderThrottlingStatus_Name,
        codec.align(RemoteFrameHost_UpdateRenderThrottlingStatus_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_UpdateRenderThrottlingStatus_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.visibilityChanged = function() {
    return RemoteFrameHostProxy.prototype.visibilityChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.visibilityChanged = function(visibility) {
    var params_ = new RemoteFrameHost_VisibilityChanged_Params();
    params_.visibility = visibility;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_VisibilityChanged_Name,
        codec.align(RemoteFrameHost_VisibilityChanged_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_VisibilityChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.didFocusFrame = function() {
    return RemoteFrameHostProxy.prototype.didFocusFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.didFocusFrame = function() {
    var params_ = new RemoteFrameHost_DidFocusFrame_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_DidFocusFrame_Name,
        codec.align(RemoteFrameHost_DidFocusFrame_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_DidFocusFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.checkCompleted = function() {
    return RemoteFrameHostProxy.prototype.checkCompleted
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.checkCompleted = function() {
    var params_ = new RemoteFrameHost_CheckCompleted_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_CheckCompleted_Name,
        codec.align(RemoteFrameHost_CheckCompleted_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_CheckCompleted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.capturePaintPreviewOfCrossProcessSubframe = function() {
    return RemoteFrameHostProxy.prototype.capturePaintPreviewOfCrossProcessSubframe
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.capturePaintPreviewOfCrossProcessSubframe = function(clipRect, guid) {
    var params_ = new RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params();
    params_.clipRect = clipRect;
    params_.guid = guid;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name,
        codec.align(RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.setIsInert = function() {
    return RemoteFrameHostProxy.prototype.setIsInert
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.setIsInert = function(inert) {
    var params_ = new RemoteFrameHost_SetIsInert_Params();
    params_.inert = inert;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_SetIsInert_Name,
        codec.align(RemoteFrameHost_SetIsInert_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_SetIsInert_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.didChangeOpener = function() {
    return RemoteFrameHostProxy.prototype.didChangeOpener
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.didChangeOpener = function(openerFrame) {
    var params_ = new RemoteFrameHost_DidChangeOpener_Params();
    params_.openerFrame = openerFrame;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_DidChangeOpener_Name,
        codec.align(RemoteFrameHost_DidChangeOpener_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_DidChangeOpener_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.advanceFocus = function() {
    return RemoteFrameHostProxy.prototype.advanceFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.advanceFocus = function(focusType, sourceFrameToken) {
    var params_ = new RemoteFrameHost_AdvanceFocus_Params();
    params_.focusType = focusType;
    params_.sourceFrameToken = sourceFrameToken;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_AdvanceFocus_Name,
        codec.align(RemoteFrameHost_AdvanceFocus_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_AdvanceFocus_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.routeMessageEvent = function() {
    return RemoteFrameHostProxy.prototype.routeMessageEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.routeMessageEvent = function(sourceFrameToken, sourceOrigin, targetOrigin, message) {
    var params_ = new RemoteFrameHost_RouteMessageEvent_Params();
    params_.sourceFrameToken = sourceFrameToken;
    params_.sourceOrigin = sourceOrigin;
    params_.targetOrigin = targetOrigin;
    params_.message = message;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_RouteMessageEvent_Name,
        codec.align(RemoteFrameHost_RouteMessageEvent_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_RouteMessageEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.printCrossProcessSubframe = function() {
    return RemoteFrameHostProxy.prototype.printCrossProcessSubframe
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.printCrossProcessSubframe = function(frameContentRect, documentCookie) {
    var params_ = new RemoteFrameHost_PrintCrossProcessSubframe_Params();
    params_.frameContentRect = frameContentRect;
    params_.documentCookie = documentCookie;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_PrintCrossProcessSubframe_Name,
        codec.align(RemoteFrameHost_PrintCrossProcessSubframe_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_PrintCrossProcessSubframe_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.detach = function() {
    return RemoteFrameHostProxy.prototype.detach
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.detach = function() {
    var params_ = new RemoteFrameHost_Detach_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_Detach_Name,
        codec.align(RemoteFrameHost_Detach_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_Detach_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.updateViewportIntersection = function() {
    return RemoteFrameHostProxy.prototype.updateViewportIntersection
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.updateViewportIntersection = function(intersectionState, visualProperties) {
    var params_ = new RemoteFrameHost_UpdateViewportIntersection_Params();
    params_.intersectionState = intersectionState;
    params_.visualProperties = visualProperties;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_UpdateViewportIntersection_Name,
        codec.align(RemoteFrameHost_UpdateViewportIntersection_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_UpdateViewportIntersection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.synchronizeVisualProperties = function() {
    return RemoteFrameHostProxy.prototype.synchronizeVisualProperties
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.synchronizeVisualProperties = function(properties) {
    var params_ = new RemoteFrameHost_SynchronizeVisualProperties_Params();
    params_.properties = properties;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_SynchronizeVisualProperties_Name,
        codec.align(RemoteFrameHost_SynchronizeVisualProperties_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_SynchronizeVisualProperties_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFrameHostPtr.prototype.openURL = function() {
    return RemoteFrameHostProxy.prototype.openURL
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameHostProxy.prototype.openURL = function(params) {
    var params_ = new RemoteFrameHost_OpenURL_Params();
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kRemoteFrameHost_OpenURL_Name,
        codec.align(RemoteFrameHost_OpenURL_Params.encodedSize));
    builder.encodeStruct(RemoteFrameHost_OpenURL_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RemoteFrameHostStub(delegate) {
    this.delegate_ = delegate;
  }
  RemoteFrameHostStub.prototype.setInheritedEffectiveTouchAction = function(touchAction) {
    return this.delegate_ && this.delegate_.setInheritedEffectiveTouchAction && this.delegate_.setInheritedEffectiveTouchAction(touchAction);
  }
  RemoteFrameHostStub.prototype.updateRenderThrottlingStatus = function(isThrottled, subtreeThrottled, displayLocked) {
    return this.delegate_ && this.delegate_.updateRenderThrottlingStatus && this.delegate_.updateRenderThrottlingStatus(isThrottled, subtreeThrottled, displayLocked);
  }
  RemoteFrameHostStub.prototype.visibilityChanged = function(visibility) {
    return this.delegate_ && this.delegate_.visibilityChanged && this.delegate_.visibilityChanged(visibility);
  }
  RemoteFrameHostStub.prototype.didFocusFrame = function() {
    return this.delegate_ && this.delegate_.didFocusFrame && this.delegate_.didFocusFrame();
  }
  RemoteFrameHostStub.prototype.checkCompleted = function() {
    return this.delegate_ && this.delegate_.checkCompleted && this.delegate_.checkCompleted();
  }
  RemoteFrameHostStub.prototype.capturePaintPreviewOfCrossProcessSubframe = function(clipRect, guid) {
    return this.delegate_ && this.delegate_.capturePaintPreviewOfCrossProcessSubframe && this.delegate_.capturePaintPreviewOfCrossProcessSubframe(clipRect, guid);
  }
  RemoteFrameHostStub.prototype.setIsInert = function(inert) {
    return this.delegate_ && this.delegate_.setIsInert && this.delegate_.setIsInert(inert);
  }
  RemoteFrameHostStub.prototype.didChangeOpener = function(openerFrame) {
    return this.delegate_ && this.delegate_.didChangeOpener && this.delegate_.didChangeOpener(openerFrame);
  }
  RemoteFrameHostStub.prototype.advanceFocus = function(focusType, sourceFrameToken) {
    return this.delegate_ && this.delegate_.advanceFocus && this.delegate_.advanceFocus(focusType, sourceFrameToken);
  }
  RemoteFrameHostStub.prototype.routeMessageEvent = function(sourceFrameToken, sourceOrigin, targetOrigin, message) {
    return this.delegate_ && this.delegate_.routeMessageEvent && this.delegate_.routeMessageEvent(sourceFrameToken, sourceOrigin, targetOrigin, message);
  }
  RemoteFrameHostStub.prototype.printCrossProcessSubframe = function(frameContentRect, documentCookie) {
    return this.delegate_ && this.delegate_.printCrossProcessSubframe && this.delegate_.printCrossProcessSubframe(frameContentRect, documentCookie);
  }
  RemoteFrameHostStub.prototype.detach = function() {
    return this.delegate_ && this.delegate_.detach && this.delegate_.detach();
  }
  RemoteFrameHostStub.prototype.updateViewportIntersection = function(intersectionState, visualProperties) {
    return this.delegate_ && this.delegate_.updateViewportIntersection && this.delegate_.updateViewportIntersection(intersectionState, visualProperties);
  }
  RemoteFrameHostStub.prototype.synchronizeVisualProperties = function(properties) {
    return this.delegate_ && this.delegate_.synchronizeVisualProperties && this.delegate_.synchronizeVisualProperties(properties);
  }
  RemoteFrameHostStub.prototype.openURL = function(params) {
    return this.delegate_ && this.delegate_.openURL && this.delegate_.openURL(params);
  }

  RemoteFrameHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name:
      var params = reader.decodeStruct(RemoteFrameHost_SetInheritedEffectiveTouchAction_Params);
      this.setInheritedEffectiveTouchAction(params.touchAction);
      return true;
    case kRemoteFrameHost_UpdateRenderThrottlingStatus_Name:
      var params = reader.decodeStruct(RemoteFrameHost_UpdateRenderThrottlingStatus_Params);
      this.updateRenderThrottlingStatus(params.isThrottled, params.subtreeThrottled, params.displayLocked);
      return true;
    case kRemoteFrameHost_VisibilityChanged_Name:
      var params = reader.decodeStruct(RemoteFrameHost_VisibilityChanged_Params);
      this.visibilityChanged(params.visibility);
      return true;
    case kRemoteFrameHost_DidFocusFrame_Name:
      var params = reader.decodeStruct(RemoteFrameHost_DidFocusFrame_Params);
      this.didFocusFrame();
      return true;
    case kRemoteFrameHost_CheckCompleted_Name:
      var params = reader.decodeStruct(RemoteFrameHost_CheckCompleted_Params);
      this.checkCompleted();
      return true;
    case kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name:
      var params = reader.decodeStruct(RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params);
      this.capturePaintPreviewOfCrossProcessSubframe(params.clipRect, params.guid);
      return true;
    case kRemoteFrameHost_SetIsInert_Name:
      var params = reader.decodeStruct(RemoteFrameHost_SetIsInert_Params);
      this.setIsInert(params.inert);
      return true;
    case kRemoteFrameHost_DidChangeOpener_Name:
      var params = reader.decodeStruct(RemoteFrameHost_DidChangeOpener_Params);
      this.didChangeOpener(params.openerFrame);
      return true;
    case kRemoteFrameHost_AdvanceFocus_Name:
      var params = reader.decodeStruct(RemoteFrameHost_AdvanceFocus_Params);
      this.advanceFocus(params.focusType, params.sourceFrameToken);
      return true;
    case kRemoteFrameHost_RouteMessageEvent_Name:
      var params = reader.decodeStruct(RemoteFrameHost_RouteMessageEvent_Params);
      this.routeMessageEvent(params.sourceFrameToken, params.sourceOrigin, params.targetOrigin, params.message);
      return true;
    case kRemoteFrameHost_PrintCrossProcessSubframe_Name:
      var params = reader.decodeStruct(RemoteFrameHost_PrintCrossProcessSubframe_Params);
      this.printCrossProcessSubframe(params.frameContentRect, params.documentCookie);
      return true;
    case kRemoteFrameHost_Detach_Name:
      var params = reader.decodeStruct(RemoteFrameHost_Detach_Params);
      this.detach();
      return true;
    case kRemoteFrameHost_UpdateViewportIntersection_Name:
      var params = reader.decodeStruct(RemoteFrameHost_UpdateViewportIntersection_Params);
      this.updateViewportIntersection(params.intersectionState, params.visualProperties);
      return true;
    case kRemoteFrameHost_SynchronizeVisualProperties_Name:
      var params = reader.decodeStruct(RemoteFrameHost_SynchronizeVisualProperties_Params);
      this.synchronizeVisualProperties(params.properties);
      return true;
    case kRemoteFrameHost_OpenURL_Name:
      var params = reader.decodeStruct(RemoteFrameHost_OpenURL_Params);
      this.openURL(params.params);
      return true;
    default:
      return false;
    }
  };

  RemoteFrameHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateRemoteFrameHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_SetInheritedEffectiveTouchAction_Params;
      break;
      case kRemoteFrameHost_UpdateRenderThrottlingStatus_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_UpdateRenderThrottlingStatus_Params;
      break;
      case kRemoteFrameHost_VisibilityChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_VisibilityChanged_Params;
      break;
      case kRemoteFrameHost_DidFocusFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_DidFocusFrame_Params;
      break;
      case kRemoteFrameHost_CheckCompleted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_CheckCompleted_Params;
      break;
      case kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params;
      break;
      case kRemoteFrameHost_SetIsInert_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_SetIsInert_Params;
      break;
      case kRemoteFrameHost_DidChangeOpener_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_DidChangeOpener_Params;
      break;
      case kRemoteFrameHost_AdvanceFocus_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_AdvanceFocus_Params;
      break;
      case kRemoteFrameHost_RouteMessageEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_RouteMessageEvent_Params;
      break;
      case kRemoteFrameHost_PrintCrossProcessSubframe_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_PrintCrossProcessSubframe_Params;
      break;
      case kRemoteFrameHost_Detach_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_Detach_Params;
      break;
      case kRemoteFrameHost_UpdateViewportIntersection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_UpdateViewportIntersection_Params;
      break;
      case kRemoteFrameHost_SynchronizeVisualProperties_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_SynchronizeVisualProperties_Params;
      break;
      case kRemoteFrameHost_OpenURL_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrameHost_OpenURL_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRemoteFrameHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var RemoteFrameHost = {
    name: 'blink.mojom.RemoteFrameHost',
    kVersion: 0,
    ptrClass: RemoteFrameHostPtr,
    proxyClass: RemoteFrameHostProxy,
    stubClass: RemoteFrameHostStub,
    validateRequest: validateRemoteFrameHostRequest,
    validateResponse: null,
  };
  RemoteFrameHostStub.prototype.validator = validateRemoteFrameHostRequest;
  RemoteFrameHostProxy.prototype.validator = null;
  var kRemoteFrame_WillEnterFullscreen_Name = 0;
  var kRemoteFrame_EnforceInsecureNavigationsSet_Name = 1;
  var kRemoteFrame_SetFrameOwnerProperties_Name = 2;
  var kRemoteFrame_EnforceInsecureRequestPolicy_Name = 3;
  var kRemoteFrame_SetReplicatedOrigin_Name = 4;
  var kRemoteFrame_SetReplicatedIsAdFrame_Name = 5;
  var kRemoteFrame_SetReplicatedName_Name = 6;
  var kRemoteFrame_DispatchLoadEventForFrameOwner_Name = 7;
  var kRemoteFrame_SetNeedsOcclusionTracking_Name = 8;
  var kRemoteFrame_Collapse_Name = 9;
  var kRemoteFrame_Focus_Name = 10;
  var kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name = 11;
  var kRemoteFrame_BubbleLogicalScroll_Name = 12;
  var kRemoteFrame_UpdateUserActivationState_Name = 13;
  var kRemoteFrame_SetEmbeddingToken_Name = 14;
  var kRemoteFrame_SetPageFocus_Name = 15;
  var kRemoteFrame_RenderFallbackContent_Name = 16;
  var kRemoteFrame_AddResourceTimingFromChild_Name = 17;
  var kRemoteFrame_ScrollRectToVisible_Name = 18;
  var kRemoteFrame_DidStartLoading_Name = 19;
  var kRemoteFrame_DidStopLoading_Name = 20;
  var kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name = 21;
  var kRemoteFrame_DidSetFramePolicyHeaders_Name = 22;
  var kRemoteFrame_DidUpdateFramePolicy_Name = 23;
  var kRemoteFrame_UpdateOpener_Name = 24;
  var kRemoteFrame_DetachAndDispose_Name = 25;
  var kRemoteFrame_EnableAutoResize_Name = 26;
  var kRemoteFrame_DisableAutoResize_Name = 27;
  var kRemoteFrame_DidUpdateVisualProperties_Name = 28;
  var kRemoteFrame_SetFrameSinkId_Name = 29;
  var kRemoteFrame_ChildProcessGone_Name = 30;
  var kRemoteFrame_CreateRemoteChild_Name = 31;
  var kRemoteFrame_CreateRemoteChildren_Name = 32;
  var kRemoteFrame_ForwardFencedFrameEventToEmbedder_Name = 33;

  function RemoteFramePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RemoteFrame,
                                                   handleOrPtrInfo);
  }

  function RemoteFrameAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RemoteFrame, associatedInterfacePtrInfo);
  }

  RemoteFrameAssociatedPtr.prototype =
      Object.create(RemoteFramePtr.prototype);
  RemoteFrameAssociatedPtr.prototype.constructor =
      RemoteFrameAssociatedPtr;

  function RemoteFrameProxy(receiver) {
    this.receiver_ = receiver;
  }
  RemoteFramePtr.prototype.willEnterFullscreen = function() {
    return RemoteFrameProxy.prototype.willEnterFullscreen
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.willEnterFullscreen = function(options) {
    var params_ = new RemoteFrame_WillEnterFullscreen_Params();
    params_.options = options;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_WillEnterFullscreen_Name,
        codec.align(RemoteFrame_WillEnterFullscreen_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_WillEnterFullscreen_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.enforceInsecureNavigationsSet = function() {
    return RemoteFrameProxy.prototype.enforceInsecureNavigationsSet
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.enforceInsecureNavigationsSet = function(set) {
    var params_ = new RemoteFrame_EnforceInsecureNavigationsSet_Params();
    params_.set = set;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_EnforceInsecureNavigationsSet_Name,
        codec.align(RemoteFrame_EnforceInsecureNavigationsSet_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_EnforceInsecureNavigationsSet_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setFrameOwnerProperties = function() {
    return RemoteFrameProxy.prototype.setFrameOwnerProperties
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setFrameOwnerProperties = function(properties) {
    var params_ = new RemoteFrame_SetFrameOwnerProperties_Params();
    params_.properties = properties;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetFrameOwnerProperties_Name,
        codec.align(RemoteFrame_SetFrameOwnerProperties_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetFrameOwnerProperties_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.enforceInsecureRequestPolicy = function() {
    return RemoteFrameProxy.prototype.enforceInsecureRequestPolicy
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.enforceInsecureRequestPolicy = function(policy) {
    var params_ = new RemoteFrame_EnforceInsecureRequestPolicy_Params();
    params_.policy = policy;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_EnforceInsecureRequestPolicy_Name,
        codec.align(RemoteFrame_EnforceInsecureRequestPolicy_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_EnforceInsecureRequestPolicy_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setReplicatedOrigin = function() {
    return RemoteFrameProxy.prototype.setReplicatedOrigin
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setReplicatedOrigin = function(origin, isPotentiallyTrustworthyUniqueOrigin) {
    var params_ = new RemoteFrame_SetReplicatedOrigin_Params();
    params_.origin = origin;
    params_.isPotentiallyTrustworthyUniqueOrigin = isPotentiallyTrustworthyUniqueOrigin;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetReplicatedOrigin_Name,
        codec.align(RemoteFrame_SetReplicatedOrigin_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetReplicatedOrigin_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setReplicatedIsAdFrame = function() {
    return RemoteFrameProxy.prototype.setReplicatedIsAdFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setReplicatedIsAdFrame = function(isAdFrame) {
    var params_ = new RemoteFrame_SetReplicatedIsAdFrame_Params();
    params_.isAdFrame = isAdFrame;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetReplicatedIsAdFrame_Name,
        codec.align(RemoteFrame_SetReplicatedIsAdFrame_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetReplicatedIsAdFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setReplicatedName = function() {
    return RemoteFrameProxy.prototype.setReplicatedName
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setReplicatedName = function(name, uniqueName) {
    var params_ = new RemoteFrame_SetReplicatedName_Params();
    params_.name = name;
    params_.uniqueName = uniqueName;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetReplicatedName_Name,
        codec.align(RemoteFrame_SetReplicatedName_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetReplicatedName_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.dispatchLoadEventForFrameOwner = function() {
    return RemoteFrameProxy.prototype.dispatchLoadEventForFrameOwner
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.dispatchLoadEventForFrameOwner = function() {
    var params_ = new RemoteFrame_DispatchLoadEventForFrameOwner_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_DispatchLoadEventForFrameOwner_Name,
        codec.align(RemoteFrame_DispatchLoadEventForFrameOwner_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_DispatchLoadEventForFrameOwner_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setNeedsOcclusionTracking = function() {
    return RemoteFrameProxy.prototype.setNeedsOcclusionTracking
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setNeedsOcclusionTracking = function(needsTracking) {
    var params_ = new RemoteFrame_SetNeedsOcclusionTracking_Params();
    params_.needsTracking = needsTracking;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetNeedsOcclusionTracking_Name,
        codec.align(RemoteFrame_SetNeedsOcclusionTracking_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetNeedsOcclusionTracking_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.collapse = function() {
    return RemoteFrameProxy.prototype.collapse
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.collapse = function(collapsed) {
    var params_ = new RemoteFrame_Collapse_Params();
    params_.collapsed = collapsed;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_Collapse_Name,
        codec.align(RemoteFrame_Collapse_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_Collapse_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.focus = function() {
    return RemoteFrameProxy.prototype.focus
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.focus = function() {
    var params_ = new RemoteFrame_Focus_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_Focus_Name,
        codec.align(RemoteFrame_Focus_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_Focus_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setHadStickyUserActivationBeforeNavigation = function() {
    return RemoteFrameProxy.prototype.setHadStickyUserActivationBeforeNavigation
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setHadStickyUserActivationBeforeNavigation = function(hasGesture) {
    var params_ = new RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params();
    params_.hasGesture = hasGesture;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name,
        codec.align(RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.bubbleLogicalScroll = function() {
    return RemoteFrameProxy.prototype.bubbleLogicalScroll
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.bubbleLogicalScroll = function(direction, granularity) {
    var params_ = new RemoteFrame_BubbleLogicalScroll_Params();
    params_.direction = direction;
    params_.granularity = granularity;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_BubbleLogicalScroll_Name,
        codec.align(RemoteFrame_BubbleLogicalScroll_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_BubbleLogicalScroll_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.updateUserActivationState = function() {
    return RemoteFrameProxy.prototype.updateUserActivationState
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.updateUserActivationState = function(stateUpdateType, notificationType) {
    var params_ = new RemoteFrame_UpdateUserActivationState_Params();
    params_.stateUpdateType = stateUpdateType;
    params_.notificationType = notificationType;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_UpdateUserActivationState_Name,
        codec.align(RemoteFrame_UpdateUserActivationState_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_UpdateUserActivationState_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setEmbeddingToken = function() {
    return RemoteFrameProxy.prototype.setEmbeddingToken
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setEmbeddingToken = function(embeddingToken) {
    var params_ = new RemoteFrame_SetEmbeddingToken_Params();
    params_.embeddingToken = embeddingToken;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetEmbeddingToken_Name,
        codec.align(RemoteFrame_SetEmbeddingToken_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetEmbeddingToken_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setPageFocus = function() {
    return RemoteFrameProxy.prototype.setPageFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setPageFocus = function(isFocused) {
    var params_ = new RemoteFrame_SetPageFocus_Params();
    params_.isFocused = isFocused;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetPageFocus_Name,
        codec.align(RemoteFrame_SetPageFocus_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetPageFocus_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.renderFallbackContent = function() {
    return RemoteFrameProxy.prototype.renderFallbackContent
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.renderFallbackContent = function() {
    var params_ = new RemoteFrame_RenderFallbackContent_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_RenderFallbackContent_Name,
        codec.align(RemoteFrame_RenderFallbackContent_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_RenderFallbackContent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.addResourceTimingFromChild = function() {
    return RemoteFrameProxy.prototype.addResourceTimingFromChild
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.addResourceTimingFromChild = function(timing) {
    var params_ = new RemoteFrame_AddResourceTimingFromChild_Params();
    params_.timing = timing;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_AddResourceTimingFromChild_Name,
        codec.align(RemoteFrame_AddResourceTimingFromChild_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_AddResourceTimingFromChild_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.scrollRectToVisible = function() {
    return RemoteFrameProxy.prototype.scrollRectToVisible
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.scrollRectToVisible = function(rect, params) {
    var params_ = new RemoteFrame_ScrollRectToVisible_Params();
    params_.rect = rect;
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_ScrollRectToVisible_Name,
        codec.align(RemoteFrame_ScrollRectToVisible_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_ScrollRectToVisible_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.didStartLoading = function() {
    return RemoteFrameProxy.prototype.didStartLoading
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.didStartLoading = function() {
    var params_ = new RemoteFrame_DidStartLoading_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_DidStartLoading_Name,
        codec.align(RemoteFrame_DidStartLoading_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_DidStartLoading_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.didStopLoading = function() {
    return RemoteFrameProxy.prototype.didStopLoading
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.didStopLoading = function() {
    var params_ = new RemoteFrame_DidStopLoading_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_DidStopLoading_Name,
        codec.align(RemoteFrame_DidStopLoading_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_DidStopLoading_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.intrinsicSizingInfoOfChildChanged = function() {
    return RemoteFrameProxy.prototype.intrinsicSizingInfoOfChildChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.intrinsicSizingInfoOfChildChanged = function(sizingInfo) {
    var params_ = new RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params();
    params_.sizingInfo = sizingInfo;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name,
        codec.align(RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.didSetFramePolicyHeaders = function() {
    return RemoteFrameProxy.prototype.didSetFramePolicyHeaders
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.didSetFramePolicyHeaders = function(sandboxFlags, parsedPermissionsPolicy) {
    var params_ = new RemoteFrame_DidSetFramePolicyHeaders_Params();
    params_.sandboxFlags = sandboxFlags;
    params_.parsedPermissionsPolicy = parsedPermissionsPolicy;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_DidSetFramePolicyHeaders_Name,
        codec.align(RemoteFrame_DidSetFramePolicyHeaders_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_DidSetFramePolicyHeaders_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.didUpdateFramePolicy = function() {
    return RemoteFrameProxy.prototype.didUpdateFramePolicy
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.didUpdateFramePolicy = function(framePolicy) {
    var params_ = new RemoteFrame_DidUpdateFramePolicy_Params();
    params_.framePolicy = framePolicy;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_DidUpdateFramePolicy_Name,
        codec.align(RemoteFrame_DidUpdateFramePolicy_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_DidUpdateFramePolicy_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.updateOpener = function() {
    return RemoteFrameProxy.prototype.updateOpener
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.updateOpener = function(openerFrameToken) {
    var params_ = new RemoteFrame_UpdateOpener_Params();
    params_.openerFrameToken = openerFrameToken;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_UpdateOpener_Name,
        codec.align(RemoteFrame_UpdateOpener_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_UpdateOpener_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.detachAndDispose = function() {
    return RemoteFrameProxy.prototype.detachAndDispose
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.detachAndDispose = function() {
    var params_ = new RemoteFrame_DetachAndDispose_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_DetachAndDispose_Name,
        codec.align(RemoteFrame_DetachAndDispose_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_DetachAndDispose_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.enableAutoResize = function() {
    return RemoteFrameProxy.prototype.enableAutoResize
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.enableAutoResize = function(minSize, maxSize) {
    var params_ = new RemoteFrame_EnableAutoResize_Params();
    params_.minSize = minSize;
    params_.maxSize = maxSize;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_EnableAutoResize_Name,
        codec.align(RemoteFrame_EnableAutoResize_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_EnableAutoResize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.disableAutoResize = function() {
    return RemoteFrameProxy.prototype.disableAutoResize
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.disableAutoResize = function() {
    var params_ = new RemoteFrame_DisableAutoResize_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_DisableAutoResize_Name,
        codec.align(RemoteFrame_DisableAutoResize_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_DisableAutoResize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.didUpdateVisualProperties = function() {
    return RemoteFrameProxy.prototype.didUpdateVisualProperties
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.didUpdateVisualProperties = function(metadata) {
    var params_ = new RemoteFrame_DidUpdateVisualProperties_Params();
    params_.metadata = metadata;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_DidUpdateVisualProperties_Name,
        codec.align(RemoteFrame_DidUpdateVisualProperties_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_DidUpdateVisualProperties_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.setFrameSinkId = function() {
    return RemoteFrameProxy.prototype.setFrameSinkId
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.setFrameSinkId = function(frameSinkId, allowPaintHolding) {
    var params_ = new RemoteFrame_SetFrameSinkId_Params();
    params_.frameSinkId = frameSinkId;
    params_.allowPaintHolding = allowPaintHolding;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_SetFrameSinkId_Name,
        codec.align(RemoteFrame_SetFrameSinkId_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_SetFrameSinkId_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.childProcessGone = function() {
    return RemoteFrameProxy.prototype.childProcessGone
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.childProcessGone = function() {
    var params_ = new RemoteFrame_ChildProcessGone_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_ChildProcessGone_Name,
        codec.align(RemoteFrame_ChildProcessGone_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_ChildProcessGone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.createRemoteChild = function() {
    return RemoteFrameProxy.prototype.createRemoteChild
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.createRemoteChild = function(token, openerFrameToken, treeScopeType, replicationState, ownerProperties, isLoading, devtoolsFrameToken, remoteFrameInterfaces) {
    var params_ = new RemoteFrame_CreateRemoteChild_Params();
    params_.token = token;
    params_.openerFrameToken = openerFrameToken;
    params_.treeScopeType = treeScopeType;
    params_.replicationState = replicationState;
    params_.ownerProperties = ownerProperties;
    params_.isLoading = isLoading;
    params_.devtoolsFrameToken = devtoolsFrameToken;
    params_.remoteFrameInterfaces = remoteFrameInterfaces;
    var builder = new codec.MessageV2Builder(
        kRemoteFrame_CreateRemoteChild_Name,
        codec.align(RemoteFrame_CreateRemoteChild_Params.encodedSize));
    builder.setPayload(RemoteFrame_CreateRemoteChild_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.createRemoteChildren = function() {
    return RemoteFrameProxy.prototype.createRemoteChildren
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.createRemoteChildren = function(params, navigationMetricsToken) {
    var params_ = new RemoteFrame_CreateRemoteChildren_Params();
    params_.params = params;
    params_.navigationMetricsToken = navigationMetricsToken;
    var builder = new codec.MessageV2Builder(
        kRemoteFrame_CreateRemoteChildren_Name,
        codec.align(RemoteFrame_CreateRemoteChildren_Params.encodedSize));
    builder.setPayload(RemoteFrame_CreateRemoteChildren_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteFramePtr.prototype.forwardFencedFrameEventToEmbedder = function() {
    return RemoteFrameProxy.prototype.forwardFencedFrameEventToEmbedder
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteFrameProxy.prototype.forwardFencedFrameEventToEmbedder = function(eventType) {
    var params_ = new RemoteFrame_ForwardFencedFrameEventToEmbedder_Params();
    params_.eventType = eventType;
    var builder = new codec.MessageV0Builder(
        kRemoteFrame_ForwardFencedFrameEventToEmbedder_Name,
        codec.align(RemoteFrame_ForwardFencedFrameEventToEmbedder_Params.encodedSize));
    builder.encodeStruct(RemoteFrame_ForwardFencedFrameEventToEmbedder_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RemoteFrameStub(delegate) {
    this.delegate_ = delegate;
  }
  RemoteFrameStub.prototype.willEnterFullscreen = function(options) {
    return this.delegate_ && this.delegate_.willEnterFullscreen && this.delegate_.willEnterFullscreen(options);
  }
  RemoteFrameStub.prototype.enforceInsecureNavigationsSet = function(set) {
    return this.delegate_ && this.delegate_.enforceInsecureNavigationsSet && this.delegate_.enforceInsecureNavigationsSet(set);
  }
  RemoteFrameStub.prototype.setFrameOwnerProperties = function(properties) {
    return this.delegate_ && this.delegate_.setFrameOwnerProperties && this.delegate_.setFrameOwnerProperties(properties);
  }
  RemoteFrameStub.prototype.enforceInsecureRequestPolicy = function(policy) {
    return this.delegate_ && this.delegate_.enforceInsecureRequestPolicy && this.delegate_.enforceInsecureRequestPolicy(policy);
  }
  RemoteFrameStub.prototype.setReplicatedOrigin = function(origin, isPotentiallyTrustworthyUniqueOrigin) {
    return this.delegate_ && this.delegate_.setReplicatedOrigin && this.delegate_.setReplicatedOrigin(origin, isPotentiallyTrustworthyUniqueOrigin);
  }
  RemoteFrameStub.prototype.setReplicatedIsAdFrame = function(isAdFrame) {
    return this.delegate_ && this.delegate_.setReplicatedIsAdFrame && this.delegate_.setReplicatedIsAdFrame(isAdFrame);
  }
  RemoteFrameStub.prototype.setReplicatedName = function(name, uniqueName) {
    return this.delegate_ && this.delegate_.setReplicatedName && this.delegate_.setReplicatedName(name, uniqueName);
  }
  RemoteFrameStub.prototype.dispatchLoadEventForFrameOwner = function() {
    return this.delegate_ && this.delegate_.dispatchLoadEventForFrameOwner && this.delegate_.dispatchLoadEventForFrameOwner();
  }
  RemoteFrameStub.prototype.setNeedsOcclusionTracking = function(needsTracking) {
    return this.delegate_ && this.delegate_.setNeedsOcclusionTracking && this.delegate_.setNeedsOcclusionTracking(needsTracking);
  }
  RemoteFrameStub.prototype.collapse = function(collapsed) {
    return this.delegate_ && this.delegate_.collapse && this.delegate_.collapse(collapsed);
  }
  RemoteFrameStub.prototype.focus = function() {
    return this.delegate_ && this.delegate_.focus && this.delegate_.focus();
  }
  RemoteFrameStub.prototype.setHadStickyUserActivationBeforeNavigation = function(hasGesture) {
    return this.delegate_ && this.delegate_.setHadStickyUserActivationBeforeNavigation && this.delegate_.setHadStickyUserActivationBeforeNavigation(hasGesture);
  }
  RemoteFrameStub.prototype.bubbleLogicalScroll = function(direction, granularity) {
    return this.delegate_ && this.delegate_.bubbleLogicalScroll && this.delegate_.bubbleLogicalScroll(direction, granularity);
  }
  RemoteFrameStub.prototype.updateUserActivationState = function(stateUpdateType, notificationType) {
    return this.delegate_ && this.delegate_.updateUserActivationState && this.delegate_.updateUserActivationState(stateUpdateType, notificationType);
  }
  RemoteFrameStub.prototype.setEmbeddingToken = function(embeddingToken) {
    return this.delegate_ && this.delegate_.setEmbeddingToken && this.delegate_.setEmbeddingToken(embeddingToken);
  }
  RemoteFrameStub.prototype.setPageFocus = function(isFocused) {
    return this.delegate_ && this.delegate_.setPageFocus && this.delegate_.setPageFocus(isFocused);
  }
  RemoteFrameStub.prototype.renderFallbackContent = function() {
    return this.delegate_ && this.delegate_.renderFallbackContent && this.delegate_.renderFallbackContent();
  }
  RemoteFrameStub.prototype.addResourceTimingFromChild = function(timing) {
    return this.delegate_ && this.delegate_.addResourceTimingFromChild && this.delegate_.addResourceTimingFromChild(timing);
  }
  RemoteFrameStub.prototype.scrollRectToVisible = function(rect, params) {
    return this.delegate_ && this.delegate_.scrollRectToVisible && this.delegate_.scrollRectToVisible(rect, params);
  }
  RemoteFrameStub.prototype.didStartLoading = function() {
    return this.delegate_ && this.delegate_.didStartLoading && this.delegate_.didStartLoading();
  }
  RemoteFrameStub.prototype.didStopLoading = function() {
    return this.delegate_ && this.delegate_.didStopLoading && this.delegate_.didStopLoading();
  }
  RemoteFrameStub.prototype.intrinsicSizingInfoOfChildChanged = function(sizingInfo) {
    return this.delegate_ && this.delegate_.intrinsicSizingInfoOfChildChanged && this.delegate_.intrinsicSizingInfoOfChildChanged(sizingInfo);
  }
  RemoteFrameStub.prototype.didSetFramePolicyHeaders = function(sandboxFlags, parsedPermissionsPolicy) {
    return this.delegate_ && this.delegate_.didSetFramePolicyHeaders && this.delegate_.didSetFramePolicyHeaders(sandboxFlags, parsedPermissionsPolicy);
  }
  RemoteFrameStub.prototype.didUpdateFramePolicy = function(framePolicy) {
    return this.delegate_ && this.delegate_.didUpdateFramePolicy && this.delegate_.didUpdateFramePolicy(framePolicy);
  }
  RemoteFrameStub.prototype.updateOpener = function(openerFrameToken) {
    return this.delegate_ && this.delegate_.updateOpener && this.delegate_.updateOpener(openerFrameToken);
  }
  RemoteFrameStub.prototype.detachAndDispose = function() {
    return this.delegate_ && this.delegate_.detachAndDispose && this.delegate_.detachAndDispose();
  }
  RemoteFrameStub.prototype.enableAutoResize = function(minSize, maxSize) {
    return this.delegate_ && this.delegate_.enableAutoResize && this.delegate_.enableAutoResize(minSize, maxSize);
  }
  RemoteFrameStub.prototype.disableAutoResize = function() {
    return this.delegate_ && this.delegate_.disableAutoResize && this.delegate_.disableAutoResize();
  }
  RemoteFrameStub.prototype.didUpdateVisualProperties = function(metadata) {
    return this.delegate_ && this.delegate_.didUpdateVisualProperties && this.delegate_.didUpdateVisualProperties(metadata);
  }
  RemoteFrameStub.prototype.setFrameSinkId = function(frameSinkId, allowPaintHolding) {
    return this.delegate_ && this.delegate_.setFrameSinkId && this.delegate_.setFrameSinkId(frameSinkId, allowPaintHolding);
  }
  RemoteFrameStub.prototype.childProcessGone = function() {
    return this.delegate_ && this.delegate_.childProcessGone && this.delegate_.childProcessGone();
  }
  RemoteFrameStub.prototype.createRemoteChild = function(token, openerFrameToken, treeScopeType, replicationState, ownerProperties, isLoading, devtoolsFrameToken, remoteFrameInterfaces) {
    return this.delegate_ && this.delegate_.createRemoteChild && this.delegate_.createRemoteChild(token, openerFrameToken, treeScopeType, replicationState, ownerProperties, isLoading, devtoolsFrameToken, remoteFrameInterfaces);
  }
  RemoteFrameStub.prototype.createRemoteChildren = function(params, navigationMetricsToken) {
    return this.delegate_ && this.delegate_.createRemoteChildren && this.delegate_.createRemoteChildren(params, navigationMetricsToken);
  }
  RemoteFrameStub.prototype.forwardFencedFrameEventToEmbedder = function(eventType) {
    return this.delegate_ && this.delegate_.forwardFencedFrameEventToEmbedder && this.delegate_.forwardFencedFrameEventToEmbedder(eventType);
  }

  RemoteFrameStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteFrame_WillEnterFullscreen_Name:
      var params = reader.decodeStruct(RemoteFrame_WillEnterFullscreen_Params);
      this.willEnterFullscreen(params.options);
      return true;
    case kRemoteFrame_EnforceInsecureNavigationsSet_Name:
      var params = reader.decodeStruct(RemoteFrame_EnforceInsecureNavigationsSet_Params);
      this.enforceInsecureNavigationsSet(params.set);
      return true;
    case kRemoteFrame_SetFrameOwnerProperties_Name:
      var params = reader.decodeStruct(RemoteFrame_SetFrameOwnerProperties_Params);
      this.setFrameOwnerProperties(params.properties);
      return true;
    case kRemoteFrame_EnforceInsecureRequestPolicy_Name:
      var params = reader.decodeStruct(RemoteFrame_EnforceInsecureRequestPolicy_Params);
      this.enforceInsecureRequestPolicy(params.policy);
      return true;
    case kRemoteFrame_SetReplicatedOrigin_Name:
      var params = reader.decodeStruct(RemoteFrame_SetReplicatedOrigin_Params);
      this.setReplicatedOrigin(params.origin, params.isPotentiallyTrustworthyUniqueOrigin);
      return true;
    case kRemoteFrame_SetReplicatedIsAdFrame_Name:
      var params = reader.decodeStruct(RemoteFrame_SetReplicatedIsAdFrame_Params);
      this.setReplicatedIsAdFrame(params.isAdFrame);
      return true;
    case kRemoteFrame_SetReplicatedName_Name:
      var params = reader.decodeStruct(RemoteFrame_SetReplicatedName_Params);
      this.setReplicatedName(params.name, params.uniqueName);
      return true;
    case kRemoteFrame_DispatchLoadEventForFrameOwner_Name:
      var params = reader.decodeStruct(RemoteFrame_DispatchLoadEventForFrameOwner_Params);
      this.dispatchLoadEventForFrameOwner();
      return true;
    case kRemoteFrame_SetNeedsOcclusionTracking_Name:
      var params = reader.decodeStruct(RemoteFrame_SetNeedsOcclusionTracking_Params);
      this.setNeedsOcclusionTracking(params.needsTracking);
      return true;
    case kRemoteFrame_Collapse_Name:
      var params = reader.decodeStruct(RemoteFrame_Collapse_Params);
      this.collapse(params.collapsed);
      return true;
    case kRemoteFrame_Focus_Name:
      var params = reader.decodeStruct(RemoteFrame_Focus_Params);
      this.focus();
      return true;
    case kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name:
      var params = reader.decodeStruct(RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params);
      this.setHadStickyUserActivationBeforeNavigation(params.hasGesture);
      return true;
    case kRemoteFrame_BubbleLogicalScroll_Name:
      var params = reader.decodeStruct(RemoteFrame_BubbleLogicalScroll_Params);
      this.bubbleLogicalScroll(params.direction, params.granularity);
      return true;
    case kRemoteFrame_UpdateUserActivationState_Name:
      var params = reader.decodeStruct(RemoteFrame_UpdateUserActivationState_Params);
      this.updateUserActivationState(params.stateUpdateType, params.notificationType);
      return true;
    case kRemoteFrame_SetEmbeddingToken_Name:
      var params = reader.decodeStruct(RemoteFrame_SetEmbeddingToken_Params);
      this.setEmbeddingToken(params.embeddingToken);
      return true;
    case kRemoteFrame_SetPageFocus_Name:
      var params = reader.decodeStruct(RemoteFrame_SetPageFocus_Params);
      this.setPageFocus(params.isFocused);
      return true;
    case kRemoteFrame_RenderFallbackContent_Name:
      var params = reader.decodeStruct(RemoteFrame_RenderFallbackContent_Params);
      this.renderFallbackContent();
      return true;
    case kRemoteFrame_AddResourceTimingFromChild_Name:
      var params = reader.decodeStruct(RemoteFrame_AddResourceTimingFromChild_Params);
      this.addResourceTimingFromChild(params.timing);
      return true;
    case kRemoteFrame_ScrollRectToVisible_Name:
      var params = reader.decodeStruct(RemoteFrame_ScrollRectToVisible_Params);
      this.scrollRectToVisible(params.rect, params.params);
      return true;
    case kRemoteFrame_DidStartLoading_Name:
      var params = reader.decodeStruct(RemoteFrame_DidStartLoading_Params);
      this.didStartLoading();
      return true;
    case kRemoteFrame_DidStopLoading_Name:
      var params = reader.decodeStruct(RemoteFrame_DidStopLoading_Params);
      this.didStopLoading();
      return true;
    case kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name:
      var params = reader.decodeStruct(RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params);
      this.intrinsicSizingInfoOfChildChanged(params.sizingInfo);
      return true;
    case kRemoteFrame_DidSetFramePolicyHeaders_Name:
      var params = reader.decodeStruct(RemoteFrame_DidSetFramePolicyHeaders_Params);
      this.didSetFramePolicyHeaders(params.sandboxFlags, params.parsedPermissionsPolicy);
      return true;
    case kRemoteFrame_DidUpdateFramePolicy_Name:
      var params = reader.decodeStruct(RemoteFrame_DidUpdateFramePolicy_Params);
      this.didUpdateFramePolicy(params.framePolicy);
      return true;
    case kRemoteFrame_UpdateOpener_Name:
      var params = reader.decodeStruct(RemoteFrame_UpdateOpener_Params);
      this.updateOpener(params.openerFrameToken);
      return true;
    case kRemoteFrame_DetachAndDispose_Name:
      var params = reader.decodeStruct(RemoteFrame_DetachAndDispose_Params);
      this.detachAndDispose();
      return true;
    case kRemoteFrame_EnableAutoResize_Name:
      var params = reader.decodeStruct(RemoteFrame_EnableAutoResize_Params);
      this.enableAutoResize(params.minSize, params.maxSize);
      return true;
    case kRemoteFrame_DisableAutoResize_Name:
      var params = reader.decodeStruct(RemoteFrame_DisableAutoResize_Params);
      this.disableAutoResize();
      return true;
    case kRemoteFrame_DidUpdateVisualProperties_Name:
      var params = reader.decodeStruct(RemoteFrame_DidUpdateVisualProperties_Params);
      this.didUpdateVisualProperties(params.metadata);
      return true;
    case kRemoteFrame_SetFrameSinkId_Name:
      var params = reader.decodeStruct(RemoteFrame_SetFrameSinkId_Params);
      this.setFrameSinkId(params.frameSinkId, params.allowPaintHolding);
      return true;
    case kRemoteFrame_ChildProcessGone_Name:
      var params = reader.decodeStruct(RemoteFrame_ChildProcessGone_Params);
      this.childProcessGone();
      return true;
    case kRemoteFrame_CreateRemoteChild_Name:
      var params = reader.decodeStruct(RemoteFrame_CreateRemoteChild_Params);
      this.createRemoteChild(params.token, params.openerFrameToken, params.treeScopeType, params.replicationState, params.ownerProperties, params.isLoading, params.devtoolsFrameToken, params.remoteFrameInterfaces);
      return true;
    case kRemoteFrame_CreateRemoteChildren_Name:
      var params = reader.decodeStruct(RemoteFrame_CreateRemoteChildren_Params);
      this.createRemoteChildren(params.params, params.navigationMetricsToken);
      return true;
    case kRemoteFrame_ForwardFencedFrameEventToEmbedder_Name:
      var params = reader.decodeStruct(RemoteFrame_ForwardFencedFrameEventToEmbedder_Params);
      this.forwardFencedFrameEventToEmbedder(params.eventType);
      return true;
    default:
      return false;
    }
  };

  RemoteFrameStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateRemoteFrameRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRemoteFrame_WillEnterFullscreen_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_WillEnterFullscreen_Params;
      break;
      case kRemoteFrame_EnforceInsecureNavigationsSet_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_EnforceInsecureNavigationsSet_Params;
      break;
      case kRemoteFrame_SetFrameOwnerProperties_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetFrameOwnerProperties_Params;
      break;
      case kRemoteFrame_EnforceInsecureRequestPolicy_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_EnforceInsecureRequestPolicy_Params;
      break;
      case kRemoteFrame_SetReplicatedOrigin_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetReplicatedOrigin_Params;
      break;
      case kRemoteFrame_SetReplicatedIsAdFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetReplicatedIsAdFrame_Params;
      break;
      case kRemoteFrame_SetReplicatedName_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetReplicatedName_Params;
      break;
      case kRemoteFrame_DispatchLoadEventForFrameOwner_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_DispatchLoadEventForFrameOwner_Params;
      break;
      case kRemoteFrame_SetNeedsOcclusionTracking_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetNeedsOcclusionTracking_Params;
      break;
      case kRemoteFrame_Collapse_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_Collapse_Params;
      break;
      case kRemoteFrame_Focus_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_Focus_Params;
      break;
      case kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params;
      break;
      case kRemoteFrame_BubbleLogicalScroll_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_BubbleLogicalScroll_Params;
      break;
      case kRemoteFrame_UpdateUserActivationState_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_UpdateUserActivationState_Params;
      break;
      case kRemoteFrame_SetEmbeddingToken_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetEmbeddingToken_Params;
      break;
      case kRemoteFrame_SetPageFocus_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetPageFocus_Params;
      break;
      case kRemoteFrame_RenderFallbackContent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_RenderFallbackContent_Params;
      break;
      case kRemoteFrame_AddResourceTimingFromChild_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_AddResourceTimingFromChild_Params;
      break;
      case kRemoteFrame_ScrollRectToVisible_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_ScrollRectToVisible_Params;
      break;
      case kRemoteFrame_DidStartLoading_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_DidStartLoading_Params;
      break;
      case kRemoteFrame_DidStopLoading_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_DidStopLoading_Params;
      break;
      case kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params;
      break;
      case kRemoteFrame_DidSetFramePolicyHeaders_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_DidSetFramePolicyHeaders_Params;
      break;
      case kRemoteFrame_DidUpdateFramePolicy_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_DidUpdateFramePolicy_Params;
      break;
      case kRemoteFrame_UpdateOpener_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_UpdateOpener_Params;
      break;
      case kRemoteFrame_DetachAndDispose_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_DetachAndDispose_Params;
      break;
      case kRemoteFrame_EnableAutoResize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_EnableAutoResize_Params;
      break;
      case kRemoteFrame_DisableAutoResize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_DisableAutoResize_Params;
      break;
      case kRemoteFrame_DidUpdateVisualProperties_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_DidUpdateVisualProperties_Params;
      break;
      case kRemoteFrame_SetFrameSinkId_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_SetFrameSinkId_Params;
      break;
      case kRemoteFrame_ChildProcessGone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_ChildProcessGone_Params;
      break;
      case kRemoteFrame_CreateRemoteChild_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_CreateRemoteChild_Params;
      break;
      case kRemoteFrame_CreateRemoteChildren_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_CreateRemoteChildren_Params;
      break;
      case kRemoteFrame_ForwardFencedFrameEventToEmbedder_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteFrame_ForwardFencedFrameEventToEmbedder_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRemoteFrameResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var RemoteFrame = {
    name: 'blink.mojom.RemoteFrame',
    kVersion: 0,
    ptrClass: RemoteFramePtr,
    proxyClass: RemoteFrameProxy,
    stubClass: RemoteFrameStub,
    validateRequest: validateRemoteFrameRequest,
    validateResponse: null,
  };
  RemoteFrameStub.prototype.validator = validateRemoteFrameRequest;
  RemoteFrameProxy.prototype.validator = null;
  var kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name = 0;

  function RemoteMainFramePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RemoteMainFrame,
                                                   handleOrPtrInfo);
  }

  function RemoteMainFrameAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RemoteMainFrame, associatedInterfacePtrInfo);
  }

  RemoteMainFrameAssociatedPtr.prototype =
      Object.create(RemoteMainFramePtr.prototype);
  RemoteMainFrameAssociatedPtr.prototype.constructor =
      RemoteMainFrameAssociatedPtr;

  function RemoteMainFrameProxy(receiver) {
    this.receiver_ = receiver;
  }
  RemoteMainFramePtr.prototype.updateTextAutosizerPageInfo = function() {
    return RemoteMainFrameProxy.prototype.updateTextAutosizerPageInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteMainFrameProxy.prototype.updateTextAutosizerPageInfo = function(pageInfo) {
    var params_ = new RemoteMainFrame_UpdateTextAutosizerPageInfo_Params();
    params_.pageInfo = pageInfo;
    var builder = new codec.MessageV0Builder(
        kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name,
        codec.align(RemoteMainFrame_UpdateTextAutosizerPageInfo_Params.encodedSize));
    builder.encodeStruct(RemoteMainFrame_UpdateTextAutosizerPageInfo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RemoteMainFrameStub(delegate) {
    this.delegate_ = delegate;
  }
  RemoteMainFrameStub.prototype.updateTextAutosizerPageInfo = function(pageInfo) {
    return this.delegate_ && this.delegate_.updateTextAutosizerPageInfo && this.delegate_.updateTextAutosizerPageInfo(pageInfo);
  }

  RemoteMainFrameStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name:
      var params = reader.decodeStruct(RemoteMainFrame_UpdateTextAutosizerPageInfo_Params);
      this.updateTextAutosizerPageInfo(params.pageInfo);
      return true;
    default:
      return false;
    }
  };

  RemoteMainFrameStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateRemoteMainFrameRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteMainFrame_UpdateTextAutosizerPageInfo_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRemoteMainFrameResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var RemoteMainFrame = {
    name: 'blink.mojom.RemoteMainFrame',
    kVersion: 0,
    ptrClass: RemoteMainFramePtr,
    proxyClass: RemoteMainFrameProxy,
    stubClass: RemoteMainFrameStub,
    validateRequest: validateRemoteMainFrameRequest,
    validateResponse: null,
  };
  RemoteMainFrameStub.prototype.validator = validateRemoteMainFrameRequest;
  RemoteMainFrameProxy.prototype.validator = null;
  var kRemoteMainFrameHost_FocusPage_Name = 0;
  var kRemoteMainFrameHost_TakeFocus_Name = 1;
  var kRemoteMainFrameHost_UpdateTargetURL_Name = 2;
  var kRemoteMainFrameHost_RouteCloseEvent_Name = 3;

  function RemoteMainFrameHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RemoteMainFrameHost,
                                                   handleOrPtrInfo);
  }

  function RemoteMainFrameHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RemoteMainFrameHost, associatedInterfacePtrInfo);
  }

  RemoteMainFrameHostAssociatedPtr.prototype =
      Object.create(RemoteMainFrameHostPtr.prototype);
  RemoteMainFrameHostAssociatedPtr.prototype.constructor =
      RemoteMainFrameHostAssociatedPtr;

  function RemoteMainFrameHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  RemoteMainFrameHostPtr.prototype.focusPage = function() {
    return RemoteMainFrameHostProxy.prototype.focusPage
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteMainFrameHostProxy.prototype.focusPage = function() {
    var params_ = new RemoteMainFrameHost_FocusPage_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteMainFrameHost_FocusPage_Name,
        codec.align(RemoteMainFrameHost_FocusPage_Params.encodedSize));
    builder.encodeStruct(RemoteMainFrameHost_FocusPage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteMainFrameHostPtr.prototype.takeFocus = function() {
    return RemoteMainFrameHostProxy.prototype.takeFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteMainFrameHostProxy.prototype.takeFocus = function(reverse) {
    var params_ = new RemoteMainFrameHost_TakeFocus_Params();
    params_.reverse = reverse;
    var builder = new codec.MessageV0Builder(
        kRemoteMainFrameHost_TakeFocus_Name,
        codec.align(RemoteMainFrameHost_TakeFocus_Params.encodedSize));
    builder.encodeStruct(RemoteMainFrameHost_TakeFocus_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RemoteMainFrameHostPtr.prototype.updateTargetURL = function() {
    return RemoteMainFrameHostProxy.prototype.updateTargetURL
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteMainFrameHostProxy.prototype.updateTargetURL = function(url) {
    var params_ = new RemoteMainFrameHost_UpdateTargetURL_Params();
    params_.url = url;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRemoteMainFrameHost_UpdateTargetURL_Name,
          codec.align(RemoteMainFrameHost_UpdateTargetURL_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RemoteMainFrameHost_UpdateTargetURL_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RemoteMainFrameHost_UpdateTargetURL_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RemoteMainFrameHostPtr.prototype.routeCloseEvent = function() {
    return RemoteMainFrameHostProxy.prototype.routeCloseEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteMainFrameHostProxy.prototype.routeCloseEvent = function() {
    var params_ = new RemoteMainFrameHost_RouteCloseEvent_Params();
    var builder = new codec.MessageV0Builder(
        kRemoteMainFrameHost_RouteCloseEvent_Name,
        codec.align(RemoteMainFrameHost_RouteCloseEvent_Params.encodedSize));
    builder.encodeStruct(RemoteMainFrameHost_RouteCloseEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RemoteMainFrameHostStub(delegate) {
    this.delegate_ = delegate;
  }
  RemoteMainFrameHostStub.prototype.focusPage = function() {
    return this.delegate_ && this.delegate_.focusPage && this.delegate_.focusPage();
  }
  RemoteMainFrameHostStub.prototype.takeFocus = function(reverse) {
    return this.delegate_ && this.delegate_.takeFocus && this.delegate_.takeFocus(reverse);
  }
  RemoteMainFrameHostStub.prototype.updateTargetURL = function(url) {
    return this.delegate_ && this.delegate_.updateTargetURL && this.delegate_.updateTargetURL(url);
  }
  RemoteMainFrameHostStub.prototype.routeCloseEvent = function() {
    return this.delegate_ && this.delegate_.routeCloseEvent && this.delegate_.routeCloseEvent();
  }

  RemoteMainFrameHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteMainFrameHost_FocusPage_Name:
      var params = reader.decodeStruct(RemoteMainFrameHost_FocusPage_Params);
      this.focusPage();
      return true;
    case kRemoteMainFrameHost_TakeFocus_Name:
      var params = reader.decodeStruct(RemoteMainFrameHost_TakeFocus_Params);
      this.takeFocus(params.reverse);
      return true;
    case kRemoteMainFrameHost_RouteCloseEvent_Name:
      var params = reader.decodeStruct(RemoteMainFrameHost_RouteCloseEvent_Params);
      this.routeCloseEvent();
      return true;
    default:
      return false;
    }
  };

  RemoteMainFrameHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteMainFrameHost_UpdateTargetURL_Name:
      var params = reader.decodeStruct(RemoteMainFrameHost_UpdateTargetURL_Params);
      this.updateTargetURL(params.url).then(function(response) {
        var responseParams =
            new RemoteMainFrameHost_UpdateTargetURL_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kRemoteMainFrameHost_UpdateTargetURL_Name,
            codec.align(RemoteMainFrameHost_UpdateTargetURL_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RemoteMainFrameHost_UpdateTargetURL_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateRemoteMainFrameHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRemoteMainFrameHost_FocusPage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteMainFrameHost_FocusPage_Params;
      break;
      case kRemoteMainFrameHost_TakeFocus_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteMainFrameHost_TakeFocus_Params;
      break;
      case kRemoteMainFrameHost_UpdateTargetURL_Name:
        if (message.expectsResponse())
          paramsClass = RemoteMainFrameHost_UpdateTargetURL_Params;
      break;
      case kRemoteMainFrameHost_RouteCloseEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteMainFrameHost_RouteCloseEvent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRemoteMainFrameHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kRemoteMainFrameHost_UpdateTargetURL_Name:
        if (message.isResponse())
          paramsClass = RemoteMainFrameHost_UpdateTargetURL_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var RemoteMainFrameHost = {
    name: 'blink.mojom.RemoteMainFrameHost',
    kVersion: 0,
    ptrClass: RemoteMainFrameHostPtr,
    proxyClass: RemoteMainFrameHostProxy,
    stubClass: RemoteMainFrameHostStub,
    validateRequest: validateRemoteMainFrameHostRequest,
    validateResponse: validateRemoteMainFrameHostResponse,
  };
  RemoteMainFrameHostStub.prototype.validator = validateRemoteMainFrameHostRequest;
  RemoteMainFrameHostProxy.prototype.validator = validateRemoteMainFrameHostResponse;
  exports.RemoteMainFrameInterfaces = RemoteMainFrameInterfaces;
  exports.RemoteFrameInterfacesFromRenderer = RemoteFrameInterfacesFromRenderer;
  exports.RemoteFrameInterfacesFromBrowser = RemoteFrameInterfacesFromBrowser;
  exports.CreateRemoteChildParams = CreateRemoteChildParams;
  exports.OpenURLParams = OpenURLParams;
  exports.NavigationStateKeepAliveHandle = NavigationStateKeepAliveHandle;
  exports.NavigationStateKeepAliveHandlePtr = NavigationStateKeepAliveHandlePtr;
  exports.NavigationStateKeepAliveHandleAssociatedPtr = NavigationStateKeepAliveHandleAssociatedPtr;
  exports.RemoteFrameHost = RemoteFrameHost;
  exports.RemoteFrameHostPtr = RemoteFrameHostPtr;
  exports.RemoteFrameHostAssociatedPtr = RemoteFrameHostAssociatedPtr;
  exports.RemoteFrame = RemoteFrame;
  exports.RemoteFramePtr = RemoteFramePtr;
  exports.RemoteFrameAssociatedPtr = RemoteFrameAssociatedPtr;
  exports.RemoteMainFrame = RemoteMainFrame;
  exports.RemoteMainFramePtr = RemoteMainFramePtr;
  exports.RemoteMainFrameAssociatedPtr = RemoteMainFrameAssociatedPtr;
  exports.RemoteMainFrameHost = RemoteMainFrameHost;
  exports.RemoteMainFrameHostPtr = RemoteMainFrameHostPtr;
  exports.RemoteMainFrameHostAssociatedPtr = RemoteMainFrameHostAssociatedPtr;
})();