// third_party/blink/public/mojom/frame/remote_frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/remote_frame.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-forward.h"  // IWYU pragma: export
#include "cc/mojom/render_frame_metadata.mojom.h"
#include "cc/mojom/touch_action.mojom.h"
#include "mojo/public/mojom/base/string16.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/source_location.mojom.h"
#include "services/network/public/mojom/storage_access_api.mojom.h"
#include "services/network/public/mojom/url_request.mojom.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-forward.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/triggering_event_info.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-forward.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom-forward.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-forward.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-forward.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/events/mojom/scroll_granularity.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class NavigationStateKeepAliveHandleProxy;

template <typename ImplRefTraits>
class NavigationStateKeepAliveHandleStub;

class NavigationStateKeepAliveHandleRequestValidator;


class BLINK_COMMON_EXPORT NavigationStateKeepAliveHandle
    : public NavigationStateKeepAliveHandleInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.NavigationStateKeepAliveHandle";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NavigationStateKeepAliveHandleInterfaceBase;
  using Proxy_ = NavigationStateKeepAliveHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = NavigationStateKeepAliveHandleStub<ImplRefTraits>;

  using RequestValidator_ = NavigationStateKeepAliveHandleRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NavigationStateKeepAliveHandle() = default;
};

class RemoteFrameHostProxy;

template <typename ImplRefTraits>
class RemoteFrameHostStub;

class RemoteFrameHostRequestValidator;


class BLINK_COMMON_EXPORT RemoteFrameHost
    : public RemoteFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RemoteFrameHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RemoteFrameHostInterfaceBase;
  using Proxy_ = RemoteFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemoteFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = RemoteFrameHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetInheritedEffectiveTouchActionMinVersion = 0,
    kUpdateRenderThrottlingStatusMinVersion = 0,
    kVisibilityChangedMinVersion = 0,
    kDidFocusFrameMinVersion = 0,
    kCheckCompletedMinVersion = 0,
    kCapturePaintPreviewOfCrossProcessSubframeMinVersion = 0,
    kSetIsInertMinVersion = 0,
    kDidChangeOpenerMinVersion = 0,
    kAdvanceFocusMinVersion = 0,
    kRouteMessageEventMinVersion = 0,
    kPrintCrossProcessSubframeMinVersion = 0,
    kDetachMinVersion = 0,
    kUpdateViewportIntersectionMinVersion = 0,
    kSynchronizeVisualPropertiesMinVersion = 0,
    kOpenURLMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetInheritedEffectiveTouchAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateRenderThrottlingStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct VisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFocusFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CapturePaintPreviewOfCrossProcessSubframe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsInert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeOpener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AdvanceFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RouteMessageEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintCrossProcessSubframe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Detach_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateViewportIntersection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SynchronizeVisualProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RemoteFrameHost() = default;

  virtual void SetInheritedEffectiveTouchAction(::cc::TouchAction touch_action) = 0;

  virtual void UpdateRenderThrottlingStatus(bool is_throttled, bool subtree_throttled, bool display_locked) = 0;

  virtual void VisibilityChanged(::blink::mojom::FrameVisibility visibility) = 0;

  virtual void DidFocusFrame() = 0;

  virtual void CheckCompleted() = 0;

  virtual void CapturePaintPreviewOfCrossProcessSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) = 0;

  virtual void SetIsInert(bool inert) = 0;

  virtual void DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) = 0;

  virtual void AdvanceFocus(::blink::mojom::FocusType focus_type, const ::blink::LocalFrameToken& source_frame_token) = 0;

  virtual void RouteMessageEvent(const std::optional<::blink::LocalFrameToken>& source_frame_token, const ::url::Origin& source_origin, const std::optional<::url::Origin>& target_origin, ::blink::TransferableMessage message) = 0;

  virtual void PrintCrossProcessSubframe(const ::gfx::Rect& frame_content_rect, int32_t document_cookie) = 0;

  virtual void Detach() = 0;

  virtual void UpdateViewportIntersection(::blink::mojom::ViewportIntersectionStatePtr intersection_state, const std::optional<::blink::FrameVisualProperties>& visual_properties) = 0;

  virtual void SynchronizeVisualProperties(const ::blink::FrameVisualProperties& properties) = 0;

  virtual void OpenURL(OpenURLParamsPtr params) = 0;
};

class RemoteFrameProxy;

template <typename ImplRefTraits>
class RemoteFrameStub;

class RemoteFrameRequestValidator;


class BLINK_COMMON_EXPORT RemoteFrame
    : public RemoteFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RemoteFrame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RemoteFrameInterfaceBase;
  using Proxy_ = RemoteFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemoteFrameStub<ImplRefTraits>;

  using RequestValidator_ = RemoteFrameRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kWillEnterFullscreenMinVersion = 0,
    kEnforceInsecureNavigationsSetMinVersion = 0,
    kSetFrameOwnerPropertiesMinVersion = 0,
    kEnforceInsecureRequestPolicyMinVersion = 0,
    kSetReplicatedOriginMinVersion = 0,
    kSetReplicatedIsAdFrameMinVersion = 0,
    kSetReplicatedNameMinVersion = 0,
    kDispatchLoadEventForFrameOwnerMinVersion = 0,
    kSetNeedsOcclusionTrackingMinVersion = 0,
    kCollapseMinVersion = 0,
    kFocusMinVersion = 0,
    kSetHadStickyUserActivationBeforeNavigationMinVersion = 0,
    kBubbleLogicalScrollMinVersion = 0,
    kUpdateUserActivationStateMinVersion = 0,
    kSetEmbeddingTokenMinVersion = 0,
    kSetPageFocusMinVersion = 0,
    kRenderFallbackContentMinVersion = 0,
    kAddResourceTimingFromChildMinVersion = 0,
    kScrollRectToVisibleMinVersion = 0,
    kDidStartLoadingMinVersion = 0,
    kDidStopLoadingMinVersion = 0,
    kIntrinsicSizingInfoOfChildChangedMinVersion = 0,
    kDidSetFramePolicyHeadersMinVersion = 0,
    kDidUpdateFramePolicyMinVersion = 0,
    kUpdateOpenerMinVersion = 0,
    kDetachAndDisposeMinVersion = 0,
    kEnableAutoResizeMinVersion = 0,
    kDisableAutoResizeMinVersion = 0,
    kDidUpdateVisualPropertiesMinVersion = 0,
    kSetFrameSinkIdMinVersion = 0,
    kChildProcessGoneMinVersion = 0,
    kCreateRemoteChildMinVersion = 0,
    kCreateRemoteChildrenMinVersion = 0,
    kForwardFencedFrameEventToEmbedderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct WillEnterFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnforceInsecureNavigationsSet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFrameOwnerProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnforceInsecureRequestPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetReplicatedOrigin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetReplicatedIsAdFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetReplicatedName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchLoadEventForFrameOwner_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNeedsOcclusionTracking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Collapse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Focus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHadStickyUserActivationBeforeNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BubbleLogicalScroll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateUserActivationState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEmbeddingToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPageFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenderFallbackContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddResourceTimingFromChild_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScrollRectToVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStartLoading_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStopLoading_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IntrinsicSizingInfoOfChildChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidSetFramePolicyHeaders_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidUpdateFramePolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateOpener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetachAndDispose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableAutoResize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableAutoResize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidUpdateVisualProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFrameSinkId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ChildProcessGone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateRemoteChild_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateRemoteChildren_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForwardFencedFrameEventToEmbedder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RemoteFrame() = default;

  virtual void WillEnterFullscreen(::blink::mojom::FullscreenOptionsPtr options) = 0;

  virtual void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) = 0;

  virtual void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) = 0;

  virtual void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy) = 0;

  virtual void SetReplicatedOrigin(const ::url::Origin& origin, bool is_potentially_trustworthy_unique_origin) = 0;

  virtual void SetReplicatedIsAdFrame(bool is_ad_frame) = 0;

  virtual void SetReplicatedName(const std::string& name, const std::string& unique_name) = 0;

  virtual void DispatchLoadEventForFrameOwner() = 0;

  virtual void SetNeedsOcclusionTracking(bool needs_tracking) = 0;

  virtual void Collapse(bool collapsed) = 0;

  virtual void Focus() = 0;

  virtual void SetHadStickyUserActivationBeforeNavigation(bool has_gesture) = 0;

  virtual void BubbleLogicalScroll(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) = 0;

  virtual void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType state_update_type, ::blink::mojom::UserActivationNotificationType notification_type) = 0;

  virtual void SetEmbeddingToken(const ::base::UnguessableToken& embedding_token) = 0;

  virtual void SetPageFocus(bool is_focused) = 0;

  virtual void RenderFallbackContent() = 0;

  virtual void AddResourceTimingFromChild(::blink::mojom::ResourceTimingInfoPtr timing) = 0;

  virtual void ScrollRectToVisible(const ::gfx::RectF& rect, ::blink::mojom::ScrollIntoViewParamsPtr params) = 0;

  virtual void DidStartLoading() = 0;

  virtual void DidStopLoading() = 0;

  virtual void IntrinsicSizingInfoOfChildChanged(::blink::mojom::IntrinsicSizingInfoPtr sizing_info) = 0;

  virtual void DidSetFramePolicyHeaders(::network::mojom::WebSandboxFlags sandbox_flags, const std::vector<::network::ParsedPermissionsPolicyDeclaration>& parsed_permissions_policy) = 0;

  virtual void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) = 0;

  virtual void UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) = 0;

  virtual void DetachAndDispose() = 0;

  virtual void EnableAutoResize(const ::gfx::Size& min_size, const ::gfx::Size& max_size) = 0;

  virtual void DisableAutoResize() = 0;

  virtual void DidUpdateVisualProperties(const ::cc::RenderFrameMetadata& metadata) = 0;

  virtual void SetFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool allow_paint_holding) = 0;

  virtual void ChildProcessGone() = 0;

  virtual void CreateRemoteChild(const ::blink::RemoteFrameToken& token, const std::optional<::blink::FrameToken>& opener_frame_token, ::blink::mojom::TreeScopeType tree_scope_type, ::blink::mojom::FrameReplicationStatePtr replication_state, ::blink::mojom::FrameOwnerPropertiesPtr owner_properties, bool is_loading, const ::base::UnguessableToken& devtools_frame_token, RemoteFrameInterfacesFromBrowserPtr remote_frame_interfaces) = 0;

  virtual void CreateRemoteChildren(std::vector<CreateRemoteChildParamsPtr> params, const std::optional<::base::UnguessableToken>& navigation_metrics_token) = 0;

  virtual void ForwardFencedFrameEventToEmbedder(const std::string& event_type) = 0;
};

class RemoteMainFrameProxy;

template <typename ImplRefTraits>
class RemoteMainFrameStub;

class RemoteMainFrameRequestValidator;


class BLINK_COMMON_EXPORT RemoteMainFrame
    : public RemoteMainFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RemoteMainFrame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RemoteMainFrameInterfaceBase;
  using Proxy_ = RemoteMainFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemoteMainFrameStub<ImplRefTraits>;

  using RequestValidator_ = RemoteMainFrameRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateTextAutosizerPageInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateTextAutosizerPageInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RemoteMainFrame() = default;

  virtual void UpdateTextAutosizerPageInfo(::blink::mojom::TextAutosizerPageInfoPtr page_info) = 0;
};

class RemoteMainFrameHostProxy;

template <typename ImplRefTraits>
class RemoteMainFrameHostStub;

class RemoteMainFrameHostRequestValidator;
class RemoteMainFrameHostResponseValidator;


class BLINK_COMMON_EXPORT RemoteMainFrameHost
    : public RemoteMainFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RemoteMainFrameHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RemoteMainFrameHostInterfaceBase;
  using Proxy_ = RemoteMainFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemoteMainFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = RemoteMainFrameHostRequestValidator;
  using ResponseValidator_ = RemoteMainFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFocusPageMinVersion = 0,
    kTakeFocusMinVersion = 0,
    kUpdateTargetURLMinVersion = 0,
    kRouteCloseEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FocusPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakeFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTargetURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RouteCloseEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RemoteMainFrameHost() = default;

  virtual void FocusPage() = 0;

  virtual void TakeFocus(bool reverse) = 0;

  using UpdateTargetURLCallback = base::OnceCallback<void()>;
  using UpdateTargetURLMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) = 0;

  virtual void RouteCloseEvent() = 0;
};



class BLINK_COMMON_EXPORT NavigationStateKeepAliveHandleProxy
    : public NavigationStateKeepAliveHandle {
 public:
  using InterfaceType = NavigationStateKeepAliveHandle;

  explicit NavigationStateKeepAliveHandleProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RemoteFrameHostProxy
    : public RemoteFrameHost {
 public:
  using InterfaceType = RemoteFrameHost;

  explicit RemoteFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetInheritedEffectiveTouchAction(::cc::TouchAction touch_action) final;
  
  void UpdateRenderThrottlingStatus(bool is_throttled, bool subtree_throttled, bool display_locked) final;
  
  void VisibilityChanged(::blink::mojom::FrameVisibility visibility) final;
  
  void DidFocusFrame() final;
  
  void CheckCompleted() final;
  
  void CapturePaintPreviewOfCrossProcessSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) final;
  
  void SetIsInert(bool inert) final;
  
  void DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) final;
  
  void AdvanceFocus(::blink::mojom::FocusType focus_type, const ::blink::LocalFrameToken& source_frame_token) final;
  
  void RouteMessageEvent(const std::optional<::blink::LocalFrameToken>& source_frame_token, const ::url::Origin& source_origin, const std::optional<::url::Origin>& target_origin, ::blink::TransferableMessage message) final;
  
  void PrintCrossProcessSubframe(const ::gfx::Rect& frame_content_rect, int32_t document_cookie) final;
  
  void Detach() final;
  
  void UpdateViewportIntersection(::blink::mojom::ViewportIntersectionStatePtr intersection_state, const std::optional<::blink::FrameVisualProperties>& visual_properties) final;
  
  void SynchronizeVisualProperties(const ::blink::FrameVisualProperties& properties) final;
  
  void OpenURL(OpenURLParamsPtr params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RemoteFrameProxy
    : public RemoteFrame {
 public:
  using InterfaceType = RemoteFrame;

  explicit RemoteFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WillEnterFullscreen(::blink::mojom::FullscreenOptionsPtr options) final;
  
  void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) final;
  
  void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) final;
  
  void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy) final;
  
  void SetReplicatedOrigin(const ::url::Origin& origin, bool is_potentially_trustworthy_unique_origin) final;
  
  void SetReplicatedIsAdFrame(bool is_ad_frame) final;
  
  void SetReplicatedName(const std::string& name, const std::string& unique_name) final;
  
  void DispatchLoadEventForFrameOwner() final;
  
  void SetNeedsOcclusionTracking(bool needs_tracking) final;
  
  void Collapse(bool collapsed) final;
  
  void Focus() final;
  
  void SetHadStickyUserActivationBeforeNavigation(bool has_gesture) final;
  
  void BubbleLogicalScroll(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) final;
  
  void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType state_update_type, ::blink::mojom::UserActivationNotificationType notification_type) final;
  
  void SetEmbeddingToken(const ::base::UnguessableToken& embedding_token) final;
  
  void SetPageFocus(bool is_focused) final;
  
  void RenderFallbackContent() final;
  
  void AddResourceTimingFromChild(::blink::mojom::ResourceTimingInfoPtr timing) final;
  
  void ScrollRectToVisible(const ::gfx::RectF& rect, ::blink::mojom::ScrollIntoViewParamsPtr params) final;
  
  void DidStartLoading() final;
  
  void DidStopLoading() final;
  
  void IntrinsicSizingInfoOfChildChanged(::blink::mojom::IntrinsicSizingInfoPtr sizing_info) final;
  
  void DidSetFramePolicyHeaders(::network::mojom::WebSandboxFlags sandbox_flags, const std::vector<::network::ParsedPermissionsPolicyDeclaration>& parsed_permissions_policy) final;
  
  void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) final;
  
  void UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) final;
  
  void DetachAndDispose() final;
  
  void EnableAutoResize(const ::gfx::Size& min_size, const ::gfx::Size& max_size) final;
  
  void DisableAutoResize() final;
  
  void DidUpdateVisualProperties(const ::cc::RenderFrameMetadata& metadata) final;
  
  void SetFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool allow_paint_holding) final;
  
  void ChildProcessGone() final;
  
  void CreateRemoteChild(const ::blink::RemoteFrameToken& token, const std::optional<::blink::FrameToken>& opener_frame_token, ::blink::mojom::TreeScopeType tree_scope_type, ::blink::mojom::FrameReplicationStatePtr replication_state, ::blink::mojom::FrameOwnerPropertiesPtr owner_properties, bool is_loading, const ::base::UnguessableToken& devtools_frame_token, RemoteFrameInterfacesFromBrowserPtr remote_frame_interfaces) final;
  
  void CreateRemoteChildren(std::vector<CreateRemoteChildParamsPtr> params, const std::optional<::base::UnguessableToken>& navigation_metrics_token) final;
  
  void ForwardFencedFrameEventToEmbedder(const std::string& event_type) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RemoteMainFrameProxy
    : public RemoteMainFrame {
 public:
  using InterfaceType = RemoteMainFrame;

  explicit RemoteMainFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateTextAutosizerPageInfo(::blink::mojom::TextAutosizerPageInfoPtr page_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RemoteMainFrameHostProxy
    : public RemoteMainFrameHost {
 public:
  using InterfaceType = RemoteMainFrameHost;

  explicit RemoteMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FocusPage() final;
  
  void TakeFocus(bool reverse) final;
  
  void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) final;
  
  void RouteCloseEvent() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT NavigationStateKeepAliveHandleStubDispatch {
 public:
  static bool Accept(NavigationStateKeepAliveHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NavigationStateKeepAliveHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NavigationStateKeepAliveHandle>>
class NavigationStateKeepAliveHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NavigationStateKeepAliveHandleStub() = default;
  ~NavigationStateKeepAliveHandleStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigationStateKeepAliveHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigationStateKeepAliveHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RemoteFrameHostStubDispatch {
 public:
  static bool Accept(RemoteFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemoteFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemoteFrameHost>>
class RemoteFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemoteFrameHostStub() = default;
  ~RemoteFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RemoteFrameStubDispatch {
 public:
  static bool Accept(RemoteFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemoteFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemoteFrame>>
class RemoteFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemoteFrameStub() = default;
  ~RemoteFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RemoteMainFrameStubDispatch {
 public:
  static bool Accept(RemoteMainFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemoteMainFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemoteMainFrame>>
class RemoteMainFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemoteMainFrameStub() = default;
  ~RemoteMainFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteMainFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteMainFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RemoteMainFrameHostStubDispatch {
 public:
  static bool Accept(RemoteMainFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemoteMainFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemoteMainFrameHost>>
class RemoteMainFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemoteMainFrameHostStub() = default;
  ~RemoteMainFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteMainFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteMainFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT NavigationStateKeepAliveHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteMainFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteMainFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteMainFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};












class BLINK_COMMON_EXPORT RemoteMainFrameInterfaces {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RemoteMainFrameInterfaces, T>::value>;
  using DataView = RemoteMainFrameInterfacesDataView;
  using Data_ = internal::RemoteMainFrameInterfaces_Data;

  template <typename... Args>
  static RemoteMainFrameInterfacesPtr New(Args&&... args) {
    return RemoteMainFrameInterfacesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RemoteMainFrameInterfacesPtr From(const U& u) {
    return mojo::TypeConverter<RemoteMainFrameInterfacesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RemoteMainFrameInterfaces>::Convert(*this);
  }


  RemoteMainFrameInterfaces();

  RemoteMainFrameInterfaces(
      ::mojo::PendingAssociatedRemote<RemoteMainFrameHost> main_frame_host,
      ::mojo::PendingAssociatedReceiver<RemoteMainFrame> main_frame);

RemoteMainFrameInterfaces(const RemoteMainFrameInterfaces&) = delete;
RemoteMainFrameInterfaces& operator=(const RemoteMainFrameInterfaces&) = delete;

  ~RemoteMainFrameInterfaces();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RemoteMainFrameInterfacesPtr>
  RemoteMainFrameInterfacesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RemoteMainFrameInterfaces::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RemoteMainFrameInterfaces_UnserializedMessageContext<
            UserType, RemoteMainFrameInterfaces::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RemoteMainFrameInterfaces::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RemoteMainFrameInterfaces::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RemoteMainFrameInterfaces_UnserializedMessageContext<
            UserType, RemoteMainFrameInterfaces::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RemoteMainFrameInterfaces::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedRemote<RemoteMainFrameHost> main_frame_host;
  
  ::mojo::PendingAssociatedReceiver<RemoteMainFrame> main_frame;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT RemoteFrameInterfacesFromRenderer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RemoteFrameInterfacesFromRenderer, T>::value>;
  using DataView = RemoteFrameInterfacesFromRendererDataView;
  using Data_ = internal::RemoteFrameInterfacesFromRenderer_Data;

  template <typename... Args>
  static RemoteFrameInterfacesFromRendererPtr New(Args&&... args) {
    return RemoteFrameInterfacesFromRendererPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RemoteFrameInterfacesFromRendererPtr From(const U& u) {
    return mojo::TypeConverter<RemoteFrameInterfacesFromRendererPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RemoteFrameInterfacesFromRenderer>::Convert(*this);
  }


  RemoteFrameInterfacesFromRenderer();

  RemoteFrameInterfacesFromRenderer(
      ::mojo::PendingAssociatedRemote<RemoteFrame> frame,
      ::mojo::PendingAssociatedReceiver<RemoteFrameHost> frame_host_receiver);

RemoteFrameInterfacesFromRenderer(const RemoteFrameInterfacesFromRenderer&) = delete;
RemoteFrameInterfacesFromRenderer& operator=(const RemoteFrameInterfacesFromRenderer&) = delete;

  ~RemoteFrameInterfacesFromRenderer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RemoteFrameInterfacesFromRendererPtr>
  RemoteFrameInterfacesFromRendererPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RemoteFrameInterfacesFromRenderer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RemoteFrameInterfacesFromRenderer_UnserializedMessageContext<
            UserType, RemoteFrameInterfacesFromRenderer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RemoteFrameInterfacesFromRenderer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RemoteFrameInterfacesFromRenderer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RemoteFrameInterfacesFromRenderer_UnserializedMessageContext<
            UserType, RemoteFrameInterfacesFromRenderer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RemoteFrameInterfacesFromRenderer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedRemote<RemoteFrame> frame;
  
  ::mojo::PendingAssociatedReceiver<RemoteFrameHost> frame_host_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT RemoteFrameInterfacesFromBrowser {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RemoteFrameInterfacesFromBrowser, T>::value>;
  using DataView = RemoteFrameInterfacesFromBrowserDataView;
  using Data_ = internal::RemoteFrameInterfacesFromBrowser_Data;

  template <typename... Args>
  static RemoteFrameInterfacesFromBrowserPtr New(Args&&... args) {
    return RemoteFrameInterfacesFromBrowserPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RemoteFrameInterfacesFromBrowserPtr From(const U& u) {
    return mojo::TypeConverter<RemoteFrameInterfacesFromBrowserPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RemoteFrameInterfacesFromBrowser>::Convert(*this);
  }


  RemoteFrameInterfacesFromBrowser();

  RemoteFrameInterfacesFromBrowser(
      ::mojo::PendingAssociatedReceiver<RemoteFrame> frame_receiver,
      ::mojo::PendingAssociatedRemote<RemoteFrameHost> frame_host);

RemoteFrameInterfacesFromBrowser(const RemoteFrameInterfacesFromBrowser&) = delete;
RemoteFrameInterfacesFromBrowser& operator=(const RemoteFrameInterfacesFromBrowser&) = delete;

  ~RemoteFrameInterfacesFromBrowser();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RemoteFrameInterfacesFromBrowserPtr>
  RemoteFrameInterfacesFromBrowserPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RemoteFrameInterfacesFromBrowser::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RemoteFrameInterfacesFromBrowser_UnserializedMessageContext<
            UserType, RemoteFrameInterfacesFromBrowser::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RemoteFrameInterfacesFromBrowser::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RemoteFrameInterfacesFromBrowser::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RemoteFrameInterfacesFromBrowser_UnserializedMessageContext<
            UserType, RemoteFrameInterfacesFromBrowser::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RemoteFrameInterfacesFromBrowser::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedReceiver<RemoteFrame> frame_receiver;
  
  ::mojo::PendingAssociatedRemote<RemoteFrameHost> frame_host;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT CreateRemoteChildParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateRemoteChildParams, T>::value>;
  using DataView = CreateRemoteChildParamsDataView;
  using Data_ = internal::CreateRemoteChildParams_Data;

  template <typename... Args>
  static CreateRemoteChildParamsPtr New(Args&&... args) {
    return CreateRemoteChildParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateRemoteChildParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateRemoteChildParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateRemoteChildParams>::Convert(*this);
  }


  CreateRemoteChildParams();

  CreateRemoteChildParams(
      const ::blink::RemoteFrameToken& token,
      const std::optional<::blink::FrameToken>& opener_frame_token,
      ::blink::mojom::TreeScopeType tree_scope_type,
      ::blink::mojom::FrameReplicationStatePtr replication_state,
      ::blink::mojom::FrameOwnerPropertiesPtr owner_properties,
      bool is_loading,
      const ::base::UnguessableToken& devtools_frame_token,
      RemoteFrameInterfacesFromBrowserPtr frame_interfaces,
      std::vector<CreateRemoteChildParamsPtr> child_params);

CreateRemoteChildParams(const CreateRemoteChildParams&) = delete;
CreateRemoteChildParams& operator=(const CreateRemoteChildParams&) = delete;

  ~CreateRemoteChildParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateRemoteChildParamsPtr>
  CreateRemoteChildParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateRemoteChildParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateRemoteChildParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateRemoteChildParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateRemoteChildParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateRemoteChildParams_UnserializedMessageContext<
            UserType, CreateRemoteChildParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateRemoteChildParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateRemoteChildParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateRemoteChildParams_UnserializedMessageContext<
            UserType, CreateRemoteChildParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateRemoteChildParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::RemoteFrameToken token;
  
  std::optional<::blink::FrameToken> opener_frame_token;
  
  ::blink::mojom::TreeScopeType tree_scope_type;
  
  ::blink::mojom::FrameReplicationStatePtr replication_state;
  
  ::blink::mojom::FrameOwnerPropertiesPtr owner_properties;
  
  bool is_loading;
  
  ::base::UnguessableToken devtools_frame_token;
  
  RemoteFrameInterfacesFromBrowserPtr frame_interfaces;
  
  std::vector<CreateRemoteChildParamsPtr> child_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateRemoteChildParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateRemoteChildParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateRemoteChildParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateRemoteChildParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT OpenURLParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpenURLParams, T>::value>;
  using DataView = OpenURLParamsDataView;
  using Data_ = internal::OpenURLParams_Data;

  template <typename... Args>
  static OpenURLParamsPtr New(Args&&... args) {
    return OpenURLParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpenURLParamsPtr From(const U& u) {
    return mojo::TypeConverter<OpenURLParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpenURLParams>::Convert(*this);
  }


  OpenURLParams();

  OpenURLParams(
      const ::GURL& url,
      const ::url::Origin& initiator_origin,
      const std::optional<::GURL>& initiator_base_url,
      ::base::TimeTicks actual_navigation_start,
      const std::optional<::blink::LocalFrameToken>& initiator_frame_token,
      ::scoped_refptr<::network::ResourceRequestBody> post_body,
      const std::string& extra_headers,
      ::blink::mojom::ReferrerPtr referrer,
      bool is_form_submission,
      ::WindowOpenDisposition disposition,
      bool should_replace_current_entry,
      bool user_gesture,
      bool is_unfenced_top_navigation,
      ::blink::mojom::TriggeringEventInfo triggering_event_info,
      ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token,
      const std::string& href_translate,
      const std::optional<::blink::Impression>& impression,
      const ::blink::NavigationDownloadPolicy& download_policy,
      ::network::mojom::SourceLocationPtr source_location,
      ::mojo::PendingRemote<NavigationStateKeepAliveHandle> initiator_navigation_state_keep_alive_handle,
      ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status,
      bool is_container_initiated,
      bool has_rel_opener,
      ::net::StorageAccessApiStatus storage_access_api_status);

OpenURLParams(const OpenURLParams&) = delete;
OpenURLParams& operator=(const OpenURLParams&) = delete;

  ~OpenURLParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpenURLParamsPtr>
  OpenURLParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpenURLParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpenURLParams_UnserializedMessageContext<
            UserType, OpenURLParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OpenURLParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OpenURLParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpenURLParams_UnserializedMessageContext<
            UserType, OpenURLParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpenURLParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::url::Origin initiator_origin;
  
  std::optional<::GURL> initiator_base_url;
  
  ::base::TimeTicks actual_navigation_start;
  
  std::optional<::blink::LocalFrameToken> initiator_frame_token;
  
  ::scoped_refptr<::network::ResourceRequestBody> post_body;
  
  std::string extra_headers;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  bool is_form_submission;
  
  ::WindowOpenDisposition disposition;
  
  bool should_replace_current_entry;
  
  bool user_gesture;
  
  bool is_unfenced_top_navigation;
  
  ::blink::mojom::TriggeringEventInfo triggering_event_info;
  
  ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token;
  
  std::string href_translate;
  
  std::optional<::blink::Impression> impression;
  
  ::blink::NavigationDownloadPolicy download_policy;
  
  ::network::mojom::SourceLocationPtr source_location;
  
  ::mojo::PendingRemote<NavigationStateKeepAliveHandle> initiator_navigation_state_keep_alive_handle;
  
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status;
  
  bool is_container_initiated;
  
  bool has_rel_opener;
  
  ::net::StorageAccessApiStatus storage_access_api_status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RemoteMainFrameInterfacesPtr RemoteMainFrameInterfaces::Clone() const {
  return New(
      mojo::Clone(main_frame_host),
      mojo::Clone(main_frame)
  );
}

template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>*>
bool RemoteMainFrameInterfaces::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->main_frame_host, other_struct.main_frame_host))
    return false;
  if (!mojo::Equals(this->main_frame, other_struct.main_frame))
    return false;
  return true;
}

template <typename T, RemoteMainFrameInterfaces::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.main_frame_host < rhs.main_frame_host)
    return true;
  if (rhs.main_frame_host < lhs.main_frame_host)
    return false;
  if (lhs.main_frame < rhs.main_frame)
    return true;
  if (rhs.main_frame < lhs.main_frame)
    return false;
  return false;
}
template <typename StructPtrType>
RemoteFrameInterfacesFromRendererPtr RemoteFrameInterfacesFromRenderer::Clone() const {
  return New(
      mojo::Clone(frame),
      mojo::Clone(frame_host_receiver)
  );
}

template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>*>
bool RemoteFrameInterfacesFromRenderer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame, other_struct.frame))
    return false;
  if (!mojo::Equals(this->frame_host_receiver, other_struct.frame_host_receiver))
    return false;
  return true;
}

template <typename T, RemoteFrameInterfacesFromRenderer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame < rhs.frame)
    return true;
  if (rhs.frame < lhs.frame)
    return false;
  if (lhs.frame_host_receiver < rhs.frame_host_receiver)
    return true;
  if (rhs.frame_host_receiver < lhs.frame_host_receiver)
    return false;
  return false;
}
template <typename StructPtrType>
RemoteFrameInterfacesFromBrowserPtr RemoteFrameInterfacesFromBrowser::Clone() const {
  return New(
      mojo::Clone(frame_receiver),
      mojo::Clone(frame_host)
  );
}

template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>*>
bool RemoteFrameInterfacesFromBrowser::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_receiver, other_struct.frame_receiver))
    return false;
  if (!mojo::Equals(this->frame_host, other_struct.frame_host))
    return false;
  return true;
}

template <typename T, RemoteFrameInterfacesFromBrowser::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_receiver < rhs.frame_receiver)
    return true;
  if (rhs.frame_receiver < lhs.frame_receiver)
    return false;
  if (lhs.frame_host < rhs.frame_host)
    return true;
  if (rhs.frame_host < lhs.frame_host)
    return false;
  return false;
}
template <typename StructPtrType>
CreateRemoteChildParamsPtr CreateRemoteChildParams::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(opener_frame_token),
      mojo::Clone(tree_scope_type),
      mojo::Clone(replication_state),
      mojo::Clone(owner_properties),
      mojo::Clone(is_loading),
      mojo::Clone(devtools_frame_token),
      mojo::Clone(frame_interfaces),
      mojo::Clone(child_params)
  );
}

template <typename T, CreateRemoteChildParams::EnableIfSame<T>*>
bool CreateRemoteChildParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->opener_frame_token, other_struct.opener_frame_token))
    return false;
  if (!mojo::Equals(this->tree_scope_type, other_struct.tree_scope_type))
    return false;
  if (!mojo::Equals(this->replication_state, other_struct.replication_state))
    return false;
  if (!mojo::Equals(this->owner_properties, other_struct.owner_properties))
    return false;
  if (!mojo::Equals(this->is_loading, other_struct.is_loading))
    return false;
  if (!mojo::Equals(this->devtools_frame_token, other_struct.devtools_frame_token))
    return false;
  if (!mojo::Equals(this->frame_interfaces, other_struct.frame_interfaces))
    return false;
  if (!mojo::Equals(this->child_params, other_struct.child_params))
    return false;
  return true;
}

template <typename T, CreateRemoteChildParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.opener_frame_token < rhs.opener_frame_token)
    return true;
  if (rhs.opener_frame_token < lhs.opener_frame_token)
    return false;
  if (lhs.tree_scope_type < rhs.tree_scope_type)
    return true;
  if (rhs.tree_scope_type < lhs.tree_scope_type)
    return false;
  if (lhs.replication_state < rhs.replication_state)
    return true;
  if (rhs.replication_state < lhs.replication_state)
    return false;
  if (lhs.owner_properties < rhs.owner_properties)
    return true;
  if (rhs.owner_properties < lhs.owner_properties)
    return false;
  if (lhs.is_loading < rhs.is_loading)
    return true;
  if (rhs.is_loading < lhs.is_loading)
    return false;
  if (lhs.devtools_frame_token < rhs.devtools_frame_token)
    return true;
  if (rhs.devtools_frame_token < lhs.devtools_frame_token)
    return false;
  if (lhs.frame_interfaces < rhs.frame_interfaces)
    return true;
  if (rhs.frame_interfaces < lhs.frame_interfaces)
    return false;
  if (lhs.child_params < rhs.child_params)
    return true;
  if (rhs.child_params < lhs.child_params)
    return false;
  return false;
}
template <typename StructPtrType>
OpenURLParamsPtr OpenURLParams::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(initiator_origin),
      mojo::Clone(initiator_base_url),
      mojo::Clone(actual_navigation_start),
      mojo::Clone(initiator_frame_token),
      mojo::Clone(post_body),
      mojo::Clone(extra_headers),
      mojo::Clone(referrer),
      mojo::Clone(is_form_submission),
      mojo::Clone(disposition),
      mojo::Clone(should_replace_current_entry),
      mojo::Clone(user_gesture),
      mojo::Clone(is_unfenced_top_navigation),
      mojo::Clone(triggering_event_info),
      mojo::Clone(blob_url_token),
      mojo::Clone(href_translate),
      mojo::Clone(impression),
      mojo::Clone(download_policy),
      mojo::Clone(source_location),
      mojo::Clone(initiator_navigation_state_keep_alive_handle),
      mojo::Clone(initiator_activation_and_ad_status),
      mojo::Clone(is_container_initiated),
      mojo::Clone(has_rel_opener),
      mojo::Clone(storage_access_api_status)
  );
}

template <typename T, OpenURLParams::EnableIfSame<T>*>
bool OpenURLParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  if (!mojo::Equals(this->initiator_base_url, other_struct.initiator_base_url))
    return false;
  if (!mojo::Equals(this->actual_navigation_start, other_struct.actual_navigation_start))
    return false;
  if (!mojo::Equals(this->initiator_frame_token, other_struct.initiator_frame_token))
    return false;
  if (!mojo::Equals(this->post_body, other_struct.post_body))
    return false;
  if (!mojo::Equals(this->extra_headers, other_struct.extra_headers))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->is_form_submission, other_struct.is_form_submission))
    return false;
  if (!mojo::Equals(this->disposition, other_struct.disposition))
    return false;
  if (!mojo::Equals(this->should_replace_current_entry, other_struct.should_replace_current_entry))
    return false;
  if (!mojo::Equals(this->user_gesture, other_struct.user_gesture))
    return false;
  if (!mojo::Equals(this->is_unfenced_top_navigation, other_struct.is_unfenced_top_navigation))
    return false;
  if (!mojo::Equals(this->triggering_event_info, other_struct.triggering_event_info))
    return false;
  if (!mojo::Equals(this->blob_url_token, other_struct.blob_url_token))
    return false;
  if (!mojo::Equals(this->href_translate, other_struct.href_translate))
    return false;
  if (!mojo::Equals(this->impression, other_struct.impression))
    return false;
  if (!mojo::Equals(this->download_policy, other_struct.download_policy))
    return false;
  if (!mojo::Equals(this->source_location, other_struct.source_location))
    return false;
  if (!mojo::Equals(this->initiator_navigation_state_keep_alive_handle, other_struct.initiator_navigation_state_keep_alive_handle))
    return false;
  if (!mojo::Equals(this->initiator_activation_and_ad_status, other_struct.initiator_activation_and_ad_status))
    return false;
  if (!mojo::Equals(this->is_container_initiated, other_struct.is_container_initiated))
    return false;
  if (!mojo::Equals(this->has_rel_opener, other_struct.has_rel_opener))
    return false;
  if (!mojo::Equals(this->storage_access_api_status, other_struct.storage_access_api_status))
    return false;
  return true;
}

template <typename T, OpenURLParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.initiator_origin < rhs.initiator_origin)
    return true;
  if (rhs.initiator_origin < lhs.initiator_origin)
    return false;
  if (lhs.initiator_base_url < rhs.initiator_base_url)
    return true;
  if (rhs.initiator_base_url < lhs.initiator_base_url)
    return false;
  if (lhs.actual_navigation_start < rhs.actual_navigation_start)
    return true;
  if (rhs.actual_navigation_start < lhs.actual_navigation_start)
    return false;
  if (lhs.initiator_frame_token < rhs.initiator_frame_token)
    return true;
  if (rhs.initiator_frame_token < lhs.initiator_frame_token)
    return false;
  if (lhs.post_body < rhs.post_body)
    return true;
  if (rhs.post_body < lhs.post_body)
    return false;
  if (lhs.extra_headers < rhs.extra_headers)
    return true;
  if (rhs.extra_headers < lhs.extra_headers)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.is_form_submission < rhs.is_form_submission)
    return true;
  if (rhs.is_form_submission < lhs.is_form_submission)
    return false;
  if (lhs.disposition < rhs.disposition)
    return true;
  if (rhs.disposition < lhs.disposition)
    return false;
  if (lhs.should_replace_current_entry < rhs.should_replace_current_entry)
    return true;
  if (rhs.should_replace_current_entry < lhs.should_replace_current_entry)
    return false;
  if (lhs.user_gesture < rhs.user_gesture)
    return true;
  if (rhs.user_gesture < lhs.user_gesture)
    return false;
  if (lhs.is_unfenced_top_navigation < rhs.is_unfenced_top_navigation)
    return true;
  if (rhs.is_unfenced_top_navigation < lhs.is_unfenced_top_navigation)
    return false;
  if (lhs.triggering_event_info < rhs.triggering_event_info)
    return true;
  if (rhs.triggering_event_info < lhs.triggering_event_info)
    return false;
  if (lhs.blob_url_token < rhs.blob_url_token)
    return true;
  if (rhs.blob_url_token < lhs.blob_url_token)
    return false;
  if (lhs.href_translate < rhs.href_translate)
    return true;
  if (rhs.href_translate < lhs.href_translate)
    return false;
  if (lhs.impression < rhs.impression)
    return true;
  if (rhs.impression < lhs.impression)
    return false;
  if (lhs.download_policy < rhs.download_policy)
    return true;
  if (rhs.download_policy < lhs.download_policy)
    return false;
  if (lhs.source_location < rhs.source_location)
    return true;
  if (rhs.source_location < lhs.source_location)
    return false;
  if (lhs.initiator_navigation_state_keep_alive_handle < rhs.initiator_navigation_state_keep_alive_handle)
    return true;
  if (rhs.initiator_navigation_state_keep_alive_handle < lhs.initiator_navigation_state_keep_alive_handle)
    return false;
  if (lhs.initiator_activation_and_ad_status < rhs.initiator_activation_and_ad_status)
    return true;
  if (rhs.initiator_activation_and_ad_status < lhs.initiator_activation_and_ad_status)
    return false;
  if (lhs.is_container_initiated < rhs.is_container_initiated)
    return true;
  if (rhs.is_container_initiated < lhs.is_container_initiated)
    return false;
  if (lhs.has_rel_opener < rhs.has_rel_opener)
    return true;
  if (rhs.has_rel_opener < lhs.has_rel_opener)
    return false;
  if (lhs.storage_access_api_status < rhs.storage_access_api_status)
    return true;
  if (rhs.storage_access_api_status < lhs.storage_access_api_status)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RemoteMainFrameInterfaces::DataView,
                                         ::blink::mojom::RemoteMainFrameInterfacesPtr> {
  static bool IsNull(const ::blink::mojom::RemoteMainFrameInterfacesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RemoteMainFrameInterfacesPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::RemoteMainFrameInterfaces::main_frame_host)& main_frame_host(
       ::blink::mojom::RemoteMainFrameInterfacesPtr& input) {
    return input->main_frame_host;
  }

  static  decltype(::blink::mojom::RemoteMainFrameInterfaces::main_frame)& main_frame(
       ::blink::mojom::RemoteMainFrameInterfacesPtr& input) {
    return input->main_frame;
  }

  static bool Read(::blink::mojom::RemoteMainFrameInterfaces::DataView input, ::blink::mojom::RemoteMainFrameInterfacesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RemoteFrameInterfacesFromRenderer::DataView,
                                         ::blink::mojom::RemoteFrameInterfacesFromRendererPtr> {
  static bool IsNull(const ::blink::mojom::RemoteFrameInterfacesFromRendererPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RemoteFrameInterfacesFromRendererPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::RemoteFrameInterfacesFromRenderer::frame)& frame(
       ::blink::mojom::RemoteFrameInterfacesFromRendererPtr& input) {
    return input->frame;
  }

  static  decltype(::blink::mojom::RemoteFrameInterfacesFromRenderer::frame_host_receiver)& frame_host_receiver(
       ::blink::mojom::RemoteFrameInterfacesFromRendererPtr& input) {
    return input->frame_host_receiver;
  }

  static bool Read(::blink::mojom::RemoteFrameInterfacesFromRenderer::DataView input, ::blink::mojom::RemoteFrameInterfacesFromRendererPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RemoteFrameInterfacesFromBrowser::DataView,
                                         ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr> {
  static bool IsNull(const ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RemoteFrameInterfacesFromBrowserPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::RemoteFrameInterfacesFromBrowser::frame_receiver)& frame_receiver(
       ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr& input) {
    return input->frame_receiver;
  }

  static  decltype(::blink::mojom::RemoteFrameInterfacesFromBrowser::frame_host)& frame_host(
       ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr& input) {
    return input->frame_host;
  }

  static bool Read(::blink::mojom::RemoteFrameInterfacesFromBrowser::DataView input, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CreateRemoteChildParams::DataView,
                                         ::blink::mojom::CreateRemoteChildParamsPtr> {
  static bool IsNull(const ::blink::mojom::CreateRemoteChildParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CreateRemoteChildParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::CreateRemoteChildParams::token)& token(
      const ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->token;
  }

  static const decltype(::blink::mojom::CreateRemoteChildParams::opener_frame_token)& opener_frame_token(
      const ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->opener_frame_token;
  }

  static decltype(::blink::mojom::CreateRemoteChildParams::tree_scope_type) tree_scope_type(
      const ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->tree_scope_type;
  }

  static const decltype(::blink::mojom::CreateRemoteChildParams::replication_state)& replication_state(
      const ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->replication_state;
  }

  static const decltype(::blink::mojom::CreateRemoteChildParams::owner_properties)& owner_properties(
      const ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->owner_properties;
  }

  static decltype(::blink::mojom::CreateRemoteChildParams::is_loading) is_loading(
      const ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->is_loading;
  }

  static const decltype(::blink::mojom::CreateRemoteChildParams::devtools_frame_token)& devtools_frame_token(
      const ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->devtools_frame_token;
  }

  static  decltype(::blink::mojom::CreateRemoteChildParams::frame_interfaces)& frame_interfaces(
       ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->frame_interfaces;
  }

  static  decltype(::blink::mojom::CreateRemoteChildParams::child_params)& child_params(
       ::blink::mojom::CreateRemoteChildParamsPtr& input) {
    return input->child_params;
  }

  static bool Read(::blink::mojom::CreateRemoteChildParams::DataView input, ::blink::mojom::CreateRemoteChildParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::OpenURLParams::DataView,
                                         ::blink::mojom::OpenURLParamsPtr> {
  static bool IsNull(const ::blink::mojom::OpenURLParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::OpenURLParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::OpenURLParams::url)& url(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::OpenURLParams::initiator_origin)& initiator_origin(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->initiator_origin;
  }

  static const decltype(::blink::mojom::OpenURLParams::initiator_base_url)& initiator_base_url(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->initiator_base_url;
  }

  static const decltype(::blink::mojom::OpenURLParams::actual_navigation_start)& actual_navigation_start(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->actual_navigation_start;
  }

  static const decltype(::blink::mojom::OpenURLParams::initiator_frame_token)& initiator_frame_token(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->initiator_frame_token;
  }

  static  decltype(::blink::mojom::OpenURLParams::post_body)& post_body(
       ::blink::mojom::OpenURLParamsPtr& input) {
    return input->post_body;
  }

  static const decltype(::blink::mojom::OpenURLParams::extra_headers)& extra_headers(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->extra_headers;
  }

  static const decltype(::blink::mojom::OpenURLParams::referrer)& referrer(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->referrer;
  }

  static decltype(::blink::mojom::OpenURLParams::is_form_submission) is_form_submission(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->is_form_submission;
  }

  static decltype(::blink::mojom::OpenURLParams::disposition) disposition(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->disposition;
  }

  static decltype(::blink::mojom::OpenURLParams::should_replace_current_entry) should_replace_current_entry(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->should_replace_current_entry;
  }

  static decltype(::blink::mojom::OpenURLParams::user_gesture) user_gesture(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->user_gesture;
  }

  static decltype(::blink::mojom::OpenURLParams::is_unfenced_top_navigation) is_unfenced_top_navigation(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->is_unfenced_top_navigation;
  }

  static decltype(::blink::mojom::OpenURLParams::triggering_event_info) triggering_event_info(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->triggering_event_info;
  }

  static  decltype(::blink::mojom::OpenURLParams::blob_url_token)& blob_url_token(
       ::blink::mojom::OpenURLParamsPtr& input) {
    return input->blob_url_token;
  }

  static const decltype(::blink::mojom::OpenURLParams::href_translate)& href_translate(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->href_translate;
  }

  static const decltype(::blink::mojom::OpenURLParams::impression)& impression(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->impression;
  }

  static const decltype(::blink::mojom::OpenURLParams::download_policy)& download_policy(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->download_policy;
  }

  static const decltype(::blink::mojom::OpenURLParams::source_location)& source_location(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->source_location;
  }

  static  decltype(::blink::mojom::OpenURLParams::initiator_navigation_state_keep_alive_handle)& initiator_navigation_state_keep_alive_handle(
       ::blink::mojom::OpenURLParamsPtr& input) {
    return input->initiator_navigation_state_keep_alive_handle;
  }

  static decltype(::blink::mojom::OpenURLParams::initiator_activation_and_ad_status) initiator_activation_and_ad_status(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->initiator_activation_and_ad_status;
  }

  static decltype(::blink::mojom::OpenURLParams::is_container_initiated) is_container_initiated(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->is_container_initiated;
  }

  static decltype(::blink::mojom::OpenURLParams::has_rel_opener) has_rel_opener(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->has_rel_opener;
  }

  static decltype(::blink::mojom::OpenURLParams::storage_access_api_status) storage_access_api_status(
      const ::blink::mojom::OpenURLParamsPtr& input) {
    return input->storage_access_api_status;
  }

  static bool Read(::blink::mojom::OpenURLParams::DataView input, ::blink::mojom::OpenURLParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_H_