// third_party/blink/public/mojom/frame/policy_container.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.IPAddressSpace');
goog.require('network.mojom.ReferrerPolicy');
goog.require('network.mojom.WebSandboxFlags');
goog.require('network.mojom.ConnectionAllowlists');
goog.require('network.mojom.ContentSecurityPolicy');
goog.require('network.mojom.CrossOriginEmbedderPolicy');
goog.require('network.mojom.IntegrityPolicy');






goog.provide('blink.mojom.PolicyContainerHost');
goog.provide('blink.mojom.PolicyContainerHostReceiver');
goog.provide('blink.mojom.PolicyContainerHostCallbackRouter');
goog.provide('blink.mojom.PolicyContainerHostInterface');
goog.provide('blink.mojom.PolicyContainerHostRemote');
goog.provide('blink.mojom.PolicyContainerHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PolicyContainerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PolicyContainerHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.PolicyContainerHostInterface = class {
  
  /**
   * @param { !network.mojom.ReferrerPolicy } referrerPolicy
   */

  setReferrerPolicy(referrerPolicy) {}
  
  /**
   * @param { !Array<!network.mojom.ContentSecurityPolicy> } contentSecurityPolicies
   */

  addContentSecurityPolicies(contentSecurityPolicies) {}
};

/**
 * @export
 * @implements { blink.mojom.PolicyContainerHostInterface }
 */
blink.mojom.PolicyContainerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PolicyContainerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PolicyContainerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PolicyContainerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.ReferrerPolicy } referrerPolicy
   */

  setReferrerPolicy(
      referrerPolicy) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PolicyContainerHost_SetReferrerPolicy_ParamsSpec.$,
        null,
        [
          referrerPolicy
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.ContentSecurityPolicy> } contentSecurityPolicies
   */

  addContentSecurityPolicies(
      contentSecurityPolicies) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec.$,
        null,
        [
          contentSecurityPolicies
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PolicyContainerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PolicyContainerHostReceiver = class {
  /**
   * @param {!blink.mojom.PolicyContainerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PolicyContainerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PolicyContainerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PolicyContainerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PolicyContainerHost_SetReferrerPolicy_ParamsSpec.$,
        null,
        impl.setReferrerPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec.$,
        null,
        impl.addContentSecurityPolicies.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PolicyContainerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PolicyContainerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PolicyContainerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PolicyContainerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PolicyContainerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PolicyContainerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PolicyContainerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PolicyContainerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReferrerPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PolicyContainerHost_SetReferrerPolicy_ParamsSpec.$,
        null,
        this.setReferrerPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addContentSecurityPolicies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec.$,
        null,
        this.addContentSecurityPolicies.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PolicyContainerPoliciesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PolicyContainerPoliciesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PolicyContainerSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PolicyContainerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PolicyContainerBindParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PolicyContainerBindParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PolicyContainerHost_SetReferrerPolicy_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PolicyContainerHost_SetReferrerPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PolicyContainerPoliciesSpec.$,
    'PolicyContainerPolicies',
    [
      mojo.internal.StructField(
        'connectionAllowlists', 0,
        0,
        network.mojom.ConnectionAllowlistsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'crossOriginEmbedderPolicy', 8,
        0,
        network.mojom.CrossOriginEmbedderPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'integrityPolicy', 16,
        0,
        network.mojom.IntegrityPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'integrityPolicyReportOnly', 24,
        0,
        network.mojom.IntegrityPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrerPolicy', 32,
        0,
        network.mojom.ReferrerPolicySpec.$,
        network.mojom.ReferrerPolicy.kDefault,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentSecurityPolicies', 40,
        0,
        mojo.internal.Array(network.mojom.ContentSecurityPolicySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isCredentialless', 36,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sandboxFlags', 48,
        0,
        network.mojom.WebSandboxFlagsSpec.$,
        network.mojom.WebSandboxFlags.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipAddressSpace', 52,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        network.mojom.IPAddressSpace.kUnknown,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canNavigateTopWithoutUserGesture', 36,
        1,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'crossOriginIsolationEnabledByDip', 36,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('blink.mojom.PolicyContainerPolicies');

/** @record */
blink.mojom.PolicyContainerPolicies = class {
  constructor() {
    /** @export { !network.mojom.ConnectionAllowlists } */
    this.connectionAllowlists;
    /** @export { !network.mojom.CrossOriginEmbedderPolicy } */
    this.crossOriginEmbedderPolicy;
    /** @export { !network.mojom.IntegrityPolicy } */
    this.integrityPolicy;
    /** @export { !network.mojom.IntegrityPolicy } */
    this.integrityPolicyReportOnly;
    /** @export { !network.mojom.ReferrerPolicy } */
    this.referrerPolicy;
    /** @export { !Array<!network.mojom.ContentSecurityPolicy> } */
    this.contentSecurityPolicies;
    /** @export { !boolean } */
    this.isCredentialless;
    /** @export { !network.mojom.WebSandboxFlags } */
    this.sandboxFlags;
    /** @export { !network.mojom.IPAddressSpace } */
    this.ipAddressSpace;
    /** @export { !boolean } */
    this.canNavigateTopWithoutUserGesture;
    /** @export { !boolean } */
    this.crossOriginIsolationEnabledByDip;
  }
};



mojo.internal.Struct(
    blink.mojom.PolicyContainerSpec.$,
    'PolicyContainer',
    [
      mojo.internal.StructField(
        'policies', 0,
        0,
        blink.mojom.PolicyContainerPoliciesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remote', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.PolicyContainerHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PolicyContainer');

/** @record */
blink.mojom.PolicyContainer = class {
  constructor() {
    /** @export { !blink.mojom.PolicyContainerPolicies } */
    this.policies;
    /** @export { !Object } */
    this.remote;
  }
};



mojo.internal.Struct(
    blink.mojom.PolicyContainerBindParamsSpec.$,
    'PolicyContainerBindParams',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.PolicyContainerHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PolicyContainerBindParams');

/** @record */
blink.mojom.PolicyContainerBindParams = class {
  constructor() {
    /** @export { !Object } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.PolicyContainerHost_SetReferrerPolicy_ParamsSpec.$,
    'PolicyContainerHost_SetReferrerPolicy_Params',
    [
      mojo.internal.StructField(
        'referrerPolicy', 0,
        0,
        network.mojom.ReferrerPolicySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PolicyContainerHost_SetReferrerPolicy_Params');

/** @record */
blink.mojom.PolicyContainerHost_SetReferrerPolicy_Params = class {
  constructor() {
    /** @export { !network.mojom.ReferrerPolicy } */
    this.referrerPolicy;
  }
};



mojo.internal.Struct(
    blink.mojom.PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec.$,
    'PolicyContainerHost_AddContentSecurityPolicies_Params',
    [
      mojo.internal.StructField(
        'contentSecurityPolicies', 0,
        0,
        mojo.internal.Array(network.mojom.ContentSecurityPolicySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PolicyContainerHost_AddContentSecurityPolicies_Params');

/** @record */
blink.mojom.PolicyContainerHost_AddContentSecurityPolicies_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.ContentSecurityPolicy> } */
    this.contentSecurityPolicies;
  }
};

