// third_party/blink/public/mojom/frame/media_player_action.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/media_player_action.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var MediaPlayerActionType = {};
  MediaPlayerActionType.kLoop = 0;
  MediaPlayerActionType.kControls = 1;
  MediaPlayerActionType.kSaveVideoFrameAs = 2;
  MediaPlayerActionType.kCopyVideoFrame = 3;
  MediaPlayerActionType.kPictureInPicture = 4;
  MediaPlayerActionType.kDefaultActionType = 4;
  MediaPlayerActionType.MIN_VALUE = 0;
  MediaPlayerActionType.MAX_VALUE = 4;

  MediaPlayerActionType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  MediaPlayerActionType.toKnownEnumValue = function(value) {
    return value;
  };

  MediaPlayerActionType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function MediaPlayerAction(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerAction.prototype.initDefaults_ = function() {
    this.type = MediaPlayerActionType.kDefaultActionType;
    this.enable = false;
  };
  MediaPlayerAction.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerAction.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayerAction.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaPlayerActionType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayerAction.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerAction.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerAction();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(MediaPlayerActionType));
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayerAction.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerAction.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.MediaPlayerActionType = MediaPlayerActionType;
  exports.MediaPlayerAction = MediaPlayerAction;
})();