// third_party/blink/public/mojom/frame/fullscreen.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FULLSCREEN_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FULLSCREEN_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/fullscreen.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class CORE_EXPORT FullscreenOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FullscreenOptions, T>::value>;
  using DataView = FullscreenOptionsDataView;
  using Data_ = internal::FullscreenOptions_Data;

  template <typename... Args>
  static FullscreenOptionsPtr New(Args&&... args) {
    return FullscreenOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FullscreenOptionsPtr From(const U& u) {
    return mojo::TypeConverter<FullscreenOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FullscreenOptions>::Convert(*this);
  }


  FullscreenOptions();

  FullscreenOptions(
      bool prefers_navigation_bar,
      bool prefers_status_bar,
      int64_t display_id,
      bool is_prefixed,
      bool is_xr_overlay);


  ~FullscreenOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FullscreenOptionsPtr>
  FullscreenOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FullscreenOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FullscreenOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FullscreenOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FullscreenOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FullscreenOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FullscreenOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FullscreenOptions_UnserializedMessageContext<
            UserType, FullscreenOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FullscreenOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FullscreenOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FullscreenOptions_UnserializedMessageContext<
            UserType, FullscreenOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FullscreenOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool prefers_navigation_bar;
  
  bool prefers_status_bar;
  
  int64_t display_id;
  
  bool is_prefixed;
  
  bool is_xr_overlay;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FullscreenOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FullscreenOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FullscreenOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FullscreenOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FullscreenOptionsPtr FullscreenOptions::Clone() const {
  return New(
      mojo::Clone(prefers_navigation_bar),
      mojo::Clone(prefers_status_bar),
      mojo::Clone(display_id),
      mojo::Clone(is_prefixed),
      mojo::Clone(is_xr_overlay)
  );
}

template <typename T, FullscreenOptions::EnableIfSame<T>*>
bool FullscreenOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->prefers_navigation_bar, other_struct.prefers_navigation_bar))
    return false;
  if (!mojo::Equals(this->prefers_status_bar, other_struct.prefers_status_bar))
    return false;
  if (!mojo::Equals(this->display_id, other_struct.display_id))
    return false;
  if (!mojo::Equals(this->is_prefixed, other_struct.is_prefixed))
    return false;
  if (!mojo::Equals(this->is_xr_overlay, other_struct.is_xr_overlay))
    return false;
  return true;
}

template <typename T, FullscreenOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.prefers_navigation_bar < rhs.prefers_navigation_bar)
    return true;
  if (rhs.prefers_navigation_bar < lhs.prefers_navigation_bar)
    return false;
  if (lhs.prefers_status_bar < rhs.prefers_status_bar)
    return true;
  if (rhs.prefers_status_bar < lhs.prefers_status_bar)
    return false;
  if (lhs.display_id < rhs.display_id)
    return true;
  if (rhs.display_id < lhs.display_id)
    return false;
  if (lhs.is_prefixed < rhs.is_prefixed)
    return true;
  if (rhs.is_prefixed < lhs.is_prefixed)
    return false;
  if (lhs.is_xr_overlay < rhs.is_xr_overlay)
    return true;
  if (rhs.is_xr_overlay < lhs.is_xr_overlay)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::FullscreenOptions::DataView,
                                         ::blink::mojom::blink::FullscreenOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::FullscreenOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FullscreenOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FullscreenOptions::prefers_navigation_bar) prefers_navigation_bar(
      const ::blink::mojom::blink::FullscreenOptionsPtr& input) {
    return input->prefers_navigation_bar;
  }

  static decltype(::blink::mojom::blink::FullscreenOptions::prefers_status_bar) prefers_status_bar(
      const ::blink::mojom::blink::FullscreenOptionsPtr& input) {
    return input->prefers_status_bar;
  }

  static decltype(::blink::mojom::blink::FullscreenOptions::display_id) display_id(
      const ::blink::mojom::blink::FullscreenOptionsPtr& input) {
    return input->display_id;
  }

  static decltype(::blink::mojom::blink::FullscreenOptions::is_prefixed) is_prefixed(
      const ::blink::mojom::blink::FullscreenOptionsPtr& input) {
    return input->is_prefixed;
  }

  static decltype(::blink::mojom::blink::FullscreenOptions::is_xr_overlay) is_xr_overlay(
      const ::blink::mojom::blink::FullscreenOptionsPtr& input) {
    return input->is_xr_overlay;
  }

  static bool Read(::blink::mojom::blink::FullscreenOptions::DataView input, ::blink::mojom::blink::FullscreenOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FULLSCREEN_MOJOM_BLINK_H_