// third_party/blink/public/mojom/frame/frame_visual_properties.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_VISUAL_PROPERTIES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_VISUAL_PROPERTIES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-blink-forward.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_params.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-blink.h"
#include "ui/display/mojom/screen_infos.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/common/frame/frame_visual_properties_mojom_traits.h"
#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class CORE_EXPORT FrameVisualProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameVisualProperties, T>::value>;
  using DataView = FrameVisualPropertiesDataView;
  using Data_ = internal::FrameVisualProperties_Data;

  template <typename... Args>
  static FrameVisualPropertiesPtr New(Args&&... args) {
    return FrameVisualPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameVisualPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<FrameVisualPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameVisualProperties>::Convert(*this);
  }


  FrameVisualProperties();

  FrameVisualProperties(
      const ::display::ScreenInfos& screen_infos,
      bool auto_resize_enabled,
      bool is_pinch_gesture_active,
      uint32_t capture_sequence_number,
      double zoom_level,
      double css_zoom_factor,
      float page_scale_factor,
      float compositing_scale_factor,
      float cursor_accessibility_scale_factor,
      const ::gfx::Size& visible_viewport_size,
      const ::gfx::Size& min_size_for_auto_resize,
      const ::gfx::Size& max_size_for_auto_resize,
      ::blink::Vector<::gfx::Rect> root_widget_viewport_segments,
      const ::gfx::Rect& compositor_viewport,
      const ::gfx::Rect& rect_in_local_root,
      const ::gfx::Size& local_frame_size,
      const ::viz::LocalSurfaceId& local_surface_id);


  ~FrameVisualProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameVisualPropertiesPtr>
  FrameVisualPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameVisualProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameVisualProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameVisualProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameVisualProperties::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameVisualProperties::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameVisualProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameVisualProperties_UnserializedMessageContext<
            UserType, FrameVisualProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameVisualProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameVisualProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameVisualProperties_UnserializedMessageContext<
            UserType, FrameVisualProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameVisualProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::display::ScreenInfos screen_infos;
  
  bool auto_resize_enabled;
  
  bool is_pinch_gesture_active;
  
  uint32_t capture_sequence_number;
  
  double zoom_level;
  
  double css_zoom_factor;
  
  float page_scale_factor;
  
  float compositing_scale_factor;
  
  float cursor_accessibility_scale_factor;
  
  ::gfx::Size visible_viewport_size;
  
  ::gfx::Size min_size_for_auto_resize;
  
  ::gfx::Size max_size_for_auto_resize;
  
  ::blink::Vector<::gfx::Rect> root_widget_viewport_segments;
  
  ::gfx::Rect compositor_viewport;
  
  ::gfx::Rect rect_in_local_root;
  
  ::gfx::Size local_frame_size;
  
  ::viz::LocalSurfaceId local_surface_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameVisualProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameVisualProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameVisualProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameVisualProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameVisualPropertiesPtr FrameVisualProperties::Clone() const {
  return New(
      mojo::Clone(screen_infos),
      mojo::Clone(auto_resize_enabled),
      mojo::Clone(is_pinch_gesture_active),
      mojo::Clone(capture_sequence_number),
      mojo::Clone(zoom_level),
      mojo::Clone(css_zoom_factor),
      mojo::Clone(page_scale_factor),
      mojo::Clone(compositing_scale_factor),
      mojo::Clone(cursor_accessibility_scale_factor),
      mojo::Clone(visible_viewport_size),
      mojo::Clone(min_size_for_auto_resize),
      mojo::Clone(max_size_for_auto_resize),
      mojo::Clone(root_widget_viewport_segments),
      mojo::Clone(compositor_viewport),
      mojo::Clone(rect_in_local_root),
      mojo::Clone(local_frame_size),
      mojo::Clone(local_surface_id)
  );
}

template <typename T, FrameVisualProperties::EnableIfSame<T>*>
bool FrameVisualProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->screen_infos, other_struct.screen_infos))
    return false;
  if (!mojo::Equals(this->auto_resize_enabled, other_struct.auto_resize_enabled))
    return false;
  if (!mojo::Equals(this->is_pinch_gesture_active, other_struct.is_pinch_gesture_active))
    return false;
  if (!mojo::Equals(this->capture_sequence_number, other_struct.capture_sequence_number))
    return false;
  if (!mojo::Equals(this->zoom_level, other_struct.zoom_level))
    return false;
  if (!mojo::Equals(this->css_zoom_factor, other_struct.css_zoom_factor))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->compositing_scale_factor, other_struct.compositing_scale_factor))
    return false;
  if (!mojo::Equals(this->cursor_accessibility_scale_factor, other_struct.cursor_accessibility_scale_factor))
    return false;
  if (!mojo::Equals(this->visible_viewport_size, other_struct.visible_viewport_size))
    return false;
  if (!mojo::Equals(this->min_size_for_auto_resize, other_struct.min_size_for_auto_resize))
    return false;
  if (!mojo::Equals(this->max_size_for_auto_resize, other_struct.max_size_for_auto_resize))
    return false;
  if (!mojo::Equals(this->root_widget_viewport_segments, other_struct.root_widget_viewport_segments))
    return false;
  if (!mojo::Equals(this->compositor_viewport, other_struct.compositor_viewport))
    return false;
  if (!mojo::Equals(this->rect_in_local_root, other_struct.rect_in_local_root))
    return false;
  if (!mojo::Equals(this->local_frame_size, other_struct.local_frame_size))
    return false;
  if (!mojo::Equals(this->local_surface_id, other_struct.local_surface_id))
    return false;
  return true;
}

template <typename T, FrameVisualProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.screen_infos < rhs.screen_infos)
    return true;
  if (rhs.screen_infos < lhs.screen_infos)
    return false;
  if (lhs.auto_resize_enabled < rhs.auto_resize_enabled)
    return true;
  if (rhs.auto_resize_enabled < lhs.auto_resize_enabled)
    return false;
  if (lhs.is_pinch_gesture_active < rhs.is_pinch_gesture_active)
    return true;
  if (rhs.is_pinch_gesture_active < lhs.is_pinch_gesture_active)
    return false;
  if (lhs.capture_sequence_number < rhs.capture_sequence_number)
    return true;
  if (rhs.capture_sequence_number < lhs.capture_sequence_number)
    return false;
  if (lhs.zoom_level < rhs.zoom_level)
    return true;
  if (rhs.zoom_level < lhs.zoom_level)
    return false;
  if (lhs.css_zoom_factor < rhs.css_zoom_factor)
    return true;
  if (rhs.css_zoom_factor < lhs.css_zoom_factor)
    return false;
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.compositing_scale_factor < rhs.compositing_scale_factor)
    return true;
  if (rhs.compositing_scale_factor < lhs.compositing_scale_factor)
    return false;
  if (lhs.cursor_accessibility_scale_factor < rhs.cursor_accessibility_scale_factor)
    return true;
  if (rhs.cursor_accessibility_scale_factor < lhs.cursor_accessibility_scale_factor)
    return false;
  if (lhs.visible_viewport_size < rhs.visible_viewport_size)
    return true;
  if (rhs.visible_viewport_size < lhs.visible_viewport_size)
    return false;
  if (lhs.min_size_for_auto_resize < rhs.min_size_for_auto_resize)
    return true;
  if (rhs.min_size_for_auto_resize < lhs.min_size_for_auto_resize)
    return false;
  if (lhs.max_size_for_auto_resize < rhs.max_size_for_auto_resize)
    return true;
  if (rhs.max_size_for_auto_resize < lhs.max_size_for_auto_resize)
    return false;
  if (lhs.root_widget_viewport_segments < rhs.root_widget_viewport_segments)
    return true;
  if (rhs.root_widget_viewport_segments < lhs.root_widget_viewport_segments)
    return false;
  if (lhs.compositor_viewport < rhs.compositor_viewport)
    return true;
  if (rhs.compositor_viewport < lhs.compositor_viewport)
    return false;
  if (lhs.rect_in_local_root < rhs.rect_in_local_root)
    return true;
  if (rhs.rect_in_local_root < lhs.rect_in_local_root)
    return false;
  if (lhs.local_frame_size < rhs.local_frame_size)
    return true;
  if (rhs.local_frame_size < lhs.local_frame_size)
    return false;
  if (lhs.local_surface_id < rhs.local_surface_id)
    return true;
  if (rhs.local_surface_id < lhs.local_surface_id)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::FrameVisualProperties::DataView,
                                         ::blink::mojom::blink::FrameVisualPropertiesPtr> {
  static bool IsNull(const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FrameVisualPropertiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::screen_infos)& screen_infos(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->screen_infos;
  }

  static decltype(::blink::mojom::blink::FrameVisualProperties::auto_resize_enabled) auto_resize_enabled(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->auto_resize_enabled;
  }

  static decltype(::blink::mojom::blink::FrameVisualProperties::is_pinch_gesture_active) is_pinch_gesture_active(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->is_pinch_gesture_active;
  }

  static decltype(::blink::mojom::blink::FrameVisualProperties::capture_sequence_number) capture_sequence_number(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->capture_sequence_number;
  }

  static decltype(::blink::mojom::blink::FrameVisualProperties::zoom_level) zoom_level(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->zoom_level;
  }

  static decltype(::blink::mojom::blink::FrameVisualProperties::css_zoom_factor) css_zoom_factor(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->css_zoom_factor;
  }

  static decltype(::blink::mojom::blink::FrameVisualProperties::page_scale_factor) page_scale_factor(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::blink::mojom::blink::FrameVisualProperties::compositing_scale_factor) compositing_scale_factor(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->compositing_scale_factor;
  }

  static decltype(::blink::mojom::blink::FrameVisualProperties::cursor_accessibility_scale_factor) cursor_accessibility_scale_factor(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->cursor_accessibility_scale_factor;
  }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::visible_viewport_size)& visible_viewport_size(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->visible_viewport_size;
  }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::min_size_for_auto_resize)& min_size_for_auto_resize(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->min_size_for_auto_resize;
  }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::max_size_for_auto_resize)& max_size_for_auto_resize(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->max_size_for_auto_resize;
  }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::root_widget_viewport_segments)& root_widget_viewport_segments(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->root_widget_viewport_segments;
  }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::compositor_viewport)& compositor_viewport(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->compositor_viewport;
  }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::rect_in_local_root)& rect_in_local_root(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->rect_in_local_root;
  }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::local_frame_size)& local_frame_size(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->local_frame_size;
  }

  static const decltype(::blink::mojom::blink::FrameVisualProperties::local_surface_id)& local_surface_id(
      const ::blink::mojom::blink::FrameVisualPropertiesPtr& input) {
    return input->local_surface_id;
  }

  static bool Read(::blink::mojom::blink::FrameVisualProperties::DataView input, ::blink::mojom::blink::FrameVisualPropertiesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_VISUAL_PROPERTIES_MOJOM_BLINK_H_