// third_party/blink/public/mojom/frame/frame_replication_state.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/frame_replication_state.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var web_sandbox_flags$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/web_sandbox_flags.mojom', '../../../../../services/network/public/mojom/web_sandbox_flags.mojom.js');
  }
  var permissions_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy.mojom', '../../../../../services/network/public/mojom/permissions_policy/permissions_policy.mojom.js');
  }
  var frame_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/frame_policy.mojom', 'frame_policy.mojom.js');
  }
  var tree_scope_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/tree_scope_type.mojom', 'tree_scope_type.mojom.js');
  }
  var insecure_request_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/security_context/insecure_request_policy.mojom', '../security_context/insecure_request_policy.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function FrameReplicationState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameReplicationState.prototype.initDefaults_ = function() {
    this.origin = null;
    this.name = null;
    this.uniqueName = null;
    this.permissionsPolicyHeader = null;
    this.activeSandboxFlags = web_sandbox_flags$.WebSandboxFlags.kNone;
    this.insecureRequestPolicy = insecure_request_policy$.InsecureRequestPolicy.kLeaveInsecureRequestsAlone;
    this.framePolicy = null;
    this.insecureNavigationsSet = null;
    this.hasPotentiallyTrustworthyUniqueOrigin = false;
    this.hasActiveUserGesture = false;
    this.hasReceivedUserGestureBeforeNav = false;
    this.isAdFrame = false;
  };
  FrameReplicationState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameReplicationState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameReplicationState.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameReplicationState.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameReplicationState.uniqueName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameReplicationState.permissionsPolicyHeader
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameReplicationState.activeSandboxFlags
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, web_sandbox_flags$.WebSandboxFlags);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameReplicationState.framePolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, frame_policy$.FramePolicy, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameReplicationState.insecureRequestPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, insecure_request_policy$.InsecureRequestPolicy);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameReplicationState.insecureNavigationsSet
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  FrameReplicationState.encodedSize = codec.kStructHeaderSize + 64;

  FrameReplicationState.decode = function(decoder) {
    var packed;
    var val = new FrameReplicationState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.name =
        decoder.decodeStruct(codec.String);
    val.uniqueName =
        decoder.decodeStruct(codec.String);
    val.permissionsPolicyHeader =
        decoder.decodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration));
    val.activeSandboxFlags =
        decoder.decodeStruct(new codec.Enum(web_sandbox_flags$.WebSandboxFlags));
    val.insecureRequestPolicy =
        decoder.decodeStruct(new codec.Enum(insecure_request_policy$.InsecureRequestPolicy));
    val.framePolicy =
        decoder.decodeStructPointer(frame_policy$.FramePolicy);
    val.insecureNavigationsSet =
        decoder.decodeArrayPointer(codec.Uint32);
    packed = decoder.readUint8();
    val.hasPotentiallyTrustworthyUniqueOrigin = (packed >> 0) & 1 ? true : false;
    val.hasActiveUserGesture = (packed >> 1) & 1 ? true : false;
    val.hasReceivedUserGestureBeforeNav = (packed >> 2) & 1 ? true : false;
    val.isAdFrame = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameReplicationState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameReplicationState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.uniqueName);
    encoder.encodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), val.permissionsPolicyHeader);
    encoder.encodeStruct(codec.Int32, val.activeSandboxFlags);
    encoder.encodeStruct(codec.Int32, val.insecureRequestPolicy);
    encoder.encodeStructPointer(frame_policy$.FramePolicy, val.framePolicy);
    encoder.encodeArrayPointer(codec.Uint32, val.insecureNavigationsSet);
    packed = 0;
    packed |= (val.hasPotentiallyTrustworthyUniqueOrigin & 1) << 0
    packed |= (val.hasActiveUserGesture & 1) << 1
    packed |= (val.hasReceivedUserGestureBeforeNav & 1) << 2
    packed |= (val.isAdFrame & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.FrameReplicationState = FrameReplicationState;
})();