// third_party/blink/public/mojom/frame/frame_policy.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame_policy.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/web_sandbox_flags.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/deferred_fetch_policy.mojom-blink-forward.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-blink.h"
#include "third_party/blink/public/mojom/permissions_policy/document_policy_feature.mojom-blink.h"
#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/common/frame/frame_policy_mojom_traits.h"
#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class CORE_EXPORT FramePolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FramePolicy, T>::value>;
  using DataView = FramePolicyDataView;
  using Data_ = internal::FramePolicy_Data;

  template <typename... Args>
  static FramePolicyPtr New(Args&&... args) {
    return FramePolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FramePolicyPtr From(const U& u) {
    return mojo::TypeConverter<FramePolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FramePolicy>::Convert(*this);
  }


  FramePolicy();

  FramePolicy(
      ::network::mojom::blink::WebSandboxFlags sandbox_flags,
      ::blink::Vector<::network::ParsedPermissionsPolicyDeclaration> container_policy,
      ::blink::HashMap<::blink::mojom::blink::DocumentPolicyFeature, ::blink::mojom::blink::PolicyValuePtr> required_document_policy,
      ::blink::mojom::blink::DeferredFetchPolicy deferred_fetch_policy);

FramePolicy(const FramePolicy&) = delete;
FramePolicy& operator=(const FramePolicy&) = delete;

  ~FramePolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FramePolicyPtr>
  FramePolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FramePolicy::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FramePolicy::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FramePolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FramePolicy_UnserializedMessageContext<
            UserType, FramePolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FramePolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FramePolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FramePolicy_UnserializedMessageContext<
            UserType, FramePolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FramePolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::blink::WebSandboxFlags sandbox_flags;
  
  ::blink::Vector<::network::ParsedPermissionsPolicyDeclaration> container_policy;
  
  ::blink::HashMap<::blink::mojom::blink::DocumentPolicyFeature, ::blink::mojom::blink::PolicyValuePtr> required_document_policy;
  
  ::blink::mojom::blink::DeferredFetchPolicy deferred_fetch_policy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FramePolicyPtr FramePolicy::Clone() const {
  return New(
      mojo::Clone(sandbox_flags),
      mojo::Clone(container_policy),
      mojo::Clone(required_document_policy),
      mojo::Clone(deferred_fetch_policy)
  );
}

template <typename T, FramePolicy::EnableIfSame<T>*>
bool FramePolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sandbox_flags, other_struct.sandbox_flags))
    return false;
  if (!mojo::Equals(this->container_policy, other_struct.container_policy))
    return false;
  if (!mojo::Equals(this->required_document_policy, other_struct.required_document_policy))
    return false;
  if (!mojo::Equals(this->deferred_fetch_policy, other_struct.deferred_fetch_policy))
    return false;
  return true;
}

template <typename T, FramePolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sandbox_flags < rhs.sandbox_flags)
    return true;
  if (rhs.sandbox_flags < lhs.sandbox_flags)
    return false;
  if (lhs.container_policy < rhs.container_policy)
    return true;
  if (rhs.container_policy < lhs.container_policy)
    return false;
  if (lhs.required_document_policy < rhs.required_document_policy)
    return true;
  if (rhs.required_document_policy < lhs.required_document_policy)
    return false;
  if (lhs.deferred_fetch_policy < rhs.deferred_fetch_policy)
    return true;
  if (rhs.deferred_fetch_policy < lhs.deferred_fetch_policy)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::FramePolicy::DataView,
                                         ::blink::mojom::blink::FramePolicyPtr> {
  static bool IsNull(const ::blink::mojom::blink::FramePolicyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FramePolicyPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FramePolicy::sandbox_flags) sandbox_flags(
      const ::blink::mojom::blink::FramePolicyPtr& input) {
    return input->sandbox_flags;
  }

  static const decltype(::blink::mojom::blink::FramePolicy::container_policy)& container_policy(
      const ::blink::mojom::blink::FramePolicyPtr& input) {
    return input->container_policy;
  }

  static const decltype(::blink::mojom::blink::FramePolicy::required_document_policy)& required_document_policy(
      const ::blink::mojom::blink::FramePolicyPtr& input) {
    return input->required_document_policy;
  }

  static decltype(::blink::mojom::blink::FramePolicy::deferred_fetch_policy) deferred_fetch_policy(
      const ::blink::mojom::blink::FramePolicyPtr& input) {
    return input->deferred_fetch_policy;
  }

  static bool Read(::blink::mojom::blink::FramePolicy::DataView input, ::blink::mojom::blink::FramePolicyPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_BLINK_H_