// third_party/blink/public/mojom/frame/frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/frame.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-import-headers.h"
#include "third_party/blink/public/mojom/frame/frame.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"
#include "third_party/blink/public/common/frame/view_transition_state_mojom_traits.h"
#include "third_party/blink/public/common/messaging/accelerated_static_bitmap_image_mojom_traits.h"
#include "third_party/blink/public/common/messaging/cloneable_message_mojom_traits.h"
#include "third_party/blink/public/common/messaging/task_attribution_id_mojom_traits.h"
#include "third_party/blink/public/common/messaging/transferable_message_mojom_traits.h"


namespace blink::mojom {
SavableSubframe::SavableSubframe()
    : original_url(),
      subframe_token() {}

SavableSubframe::SavableSubframe(
    const ::GURL& original_url_in,
    const ::blink::FrameToken& subframe_token_in)
    : original_url(std::move(original_url_in)),
      subframe_token(std::move(subframe_token_in)) {}

SavableSubframe::~SavableSubframe() = default;

void SavableSubframe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_url"), this->original_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframe_token"), this->subframe_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::FrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SavableSubframe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetSavableResourceLinksReply::GetSavableResourceLinksReply()
    : resources_list(),
      referrer(),
      subframes() {}

GetSavableResourceLinksReply::GetSavableResourceLinksReply(
    std::vector<::GURL> resources_list_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    std::vector<SavableSubframePtr> subframes_in)
    : resources_list(std::move(resources_list_in)),
      referrer(std::move(referrer_in)),
      subframes(std::move(subframes_in)) {}

GetSavableResourceLinksReply::~GetSavableResourceLinksReply() = default;

void GetSavableResourceLinksReply::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources_list"), this->resources_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframes"), this->subframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SavableSubframePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetSavableResourceLinksReply::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FindInPageResultAXParams::FindInPageResultAXParams()
    : request_id(),
      match_index(),
      start_id(),
      start_offset(),
      end_id(),
      end_offset() {}

FindInPageResultAXParams::FindInPageResultAXParams(
    int32_t request_id_in,
    int32_t match_index_in,
    int32_t start_id_in,
    int32_t start_offset_in,
    int32_t end_id_in,
    int32_t end_offset_in)
    : request_id(std::move(request_id_in)),
      match_index(std::move(match_index_in)),
      start_id(std::move(start_id_in)),
      start_offset(std::move(start_offset_in)),
      end_id(std::move(end_id_in)),
      end_offset(std::move(end_offset_in)) {}

FindInPageResultAXParams::~FindInPageResultAXParams() = default;
size_t FindInPageResultAXParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->request_id);
  seed = mojo::internal::Hash(seed, this->match_index);
  seed = mojo::internal::Hash(seed, this->start_id);
  seed = mojo::internal::Hash(seed, this->start_offset);
  seed = mojo::internal::Hash(seed, this->end_id);
  seed = mojo::internal::Hash(seed, this->end_offset);
  return seed;
}

void FindInPageResultAXParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_index"), this->match_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_id"), this->start_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_offset"), this->start_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_id"), this->end_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_offset"), this->end_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FindInPageResultAXParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerializedDomElementInfo::SerializedDomElementInfo()
    : tag(),
      selector(),
      visible_bounds(),
      click_point() {}

SerializedDomElementInfo::SerializedDomElementInfo(
    const std::string& tag_in,
    const std::string& selector_in,
    const std::optional<::gfx::Rect>& visible_bounds_in,
    const std::optional<::gfx::Point>& click_point_in)
    : tag(std::move(tag_in)),
      selector(std::move(selector_in)),
      visible_bounds(std::move(visible_bounds_in)),
      click_point(std::move(click_point_in)) {}

SerializedDomElementInfo::~SerializedDomElementInfo() = default;

void SerializedDomElementInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tag"), this->tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selector"), this->selector,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_bounds"), this->visible_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "click_point"), this->click_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Point>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SerializedDomElementInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DownloadURLParams::DownloadURLParams()
    : url(),
      referrer(),
      initiator_origin(),
      suggested_name(),
      cross_origin_redirects(),
      blob_url_token(),
      data_url_blob(),
      is_context_menu_save(false),
      has_user_gesture(false) {}

DownloadURLParams::DownloadURLParams(
    const ::GURL& url_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    const std::optional<::url::Origin>& initiator_origin_in,
    const std::optional<::std::u16string>& suggested_name_in,
    ::network::mojom::RedirectMode cross_origin_redirects_in,
    ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token_in,
    ::mojo::PendingRemote<::blink::mojom::Blob> data_url_blob_in,
    bool is_context_menu_save_in,
    bool has_user_gesture_in)
    : url(std::move(url_in)),
      referrer(std::move(referrer_in)),
      initiator_origin(std::move(initiator_origin_in)),
      suggested_name(std::move(suggested_name_in)),
      cross_origin_redirects(std::move(cross_origin_redirects_in)),
      blob_url_token(std::move(blob_url_token_in)),
      data_url_blob(std::move(data_url_blob_in)),
      is_context_menu_save(std::move(is_context_menu_save_in)),
      has_user_gesture(std::move(has_user_gesture_in)) {}

DownloadURLParams::~DownloadURLParams() = default;

void DownloadURLParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_origin"), this->initiator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggested_name"), this->suggested_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_redirects"), this->cross_origin_redirects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RedirectMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob_url_token"), this->blob_url_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_url_blob"), this->data_url_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_context_menu_save"), this->is_context_menu_save,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_gesture"), this->has_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DownloadURLParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IframeAttributes::IframeAttributes()
    : parsed_csp_attribute(),
      credentialless(),
      browsing_topics(),
      ad_auction_headers(),
      shared_storage_writable_opted_in(),
      id(),
      name(),
      src() {}

IframeAttributes::IframeAttributes(
    ::network::mojom::ContentSecurityPolicyPtr parsed_csp_attribute_in,
    bool credentialless_in,
    bool browsing_topics_in,
    bool ad_auction_headers_in,
    bool shared_storage_writable_opted_in_in,
    const std::optional<std::string>& id_in,
    const std::optional<std::string>& name_in,
    const std::optional<std::string>& src_in)
    : parsed_csp_attribute(std::move(parsed_csp_attribute_in)),
      credentialless(std::move(credentialless_in)),
      browsing_topics(std::move(browsing_topics_in)),
      ad_auction_headers(std::move(ad_auction_headers_in)),
      shared_storage_writable_opted_in(std::move(shared_storage_writable_opted_in_in)),
      id(std::move(id_in)),
      name(std::move(name_in)),
      src(std::move(src_in)) {}

IframeAttributes::~IframeAttributes() = default;

void IframeAttributes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parsed_csp_attribute"), this->parsed_csp_attribute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ContentSecurityPolicyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentialless"), this->credentialless,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_topics"), this->browsing_topics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_auction_headers"), this->ad_auction_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_storage_writable_opted_in"), this->shared_storage_writable_opted_in,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "src"), this->src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IframeAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LegacyTechEventCodeLocation::LegacyTechEventCodeLocation()
    : filename(),
      line(),
      column() {}

LegacyTechEventCodeLocation::LegacyTechEventCodeLocation(
    const std::string& filename_in,
    uint64_t line_in,
    uint64_t column_in)
    : filename(std::move(filename_in)),
      line(std::move(line_in)),
      column(std::move(column_in)) {}

LegacyTechEventCodeLocation::~LegacyTechEventCodeLocation() = default;
size_t LegacyTechEventCodeLocation::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->filename);
  seed = mojo::internal::Hash(seed, this->line);
  seed = mojo::internal::Hash(seed, this->column);
  return seed;
}

void LegacyTechEventCodeLocation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filename"), this->filename,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "line"), this->line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "column"), this->column,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LegacyTechEventCodeLocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

LocalFrameHost::IPCStableHashFunction LocalFrameHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LocalFrameHost>(message.name())) {
    case messages::LocalFrameHost::kEnterFullscreen: {
      return &LocalFrameHost::EnterFullscreen_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kExitFullscreen: {
      return &LocalFrameHost::ExitFullscreen_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kFullscreenStateChanged: {
      return &LocalFrameHost::FullscreenStateChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kRegisterProtocolHandler: {
      return &LocalFrameHost::RegisterProtocolHandler_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kUnregisterProtocolHandler: {
      return &LocalFrameHost::UnregisterProtocolHandler_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidDisplayInsecureContent: {
      return &LocalFrameHost::DidDisplayInsecureContent_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidContainInsecureFormAction: {
      return &LocalFrameHost::DidContainInsecureFormAction_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kMainDocumentElementAvailable: {
      return &LocalFrameHost::MainDocumentElementAvailable_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSetNeedsOcclusionTracking: {
      return &LocalFrameHost::SetNeedsOcclusionTracking_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSetVirtualKeyboardMode: {
      return &LocalFrameHost::SetVirtualKeyboardMode_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kVisibilityChanged: {
      return &LocalFrameHost::VisibilityChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidChangeThemeColor: {
      return &LocalFrameHost::DidChangeThemeColor_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidChangeBackgroundColor: {
      return &LocalFrameHost::DidChangeBackgroundColor_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidFailLoadWithError: {
      return &LocalFrameHost::DidFailLoadWithError_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidFocusFrame: {
      return &LocalFrameHost::DidFocusFrame_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidCallFocus: {
      return &LocalFrameHost::DidCallFocus_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kEnforceInsecureRequestPolicy: {
      return &LocalFrameHost::EnforceInsecureRequestPolicy_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kEnforceInsecureNavigationsSet: {
      return &LocalFrameHost::EnforceInsecureNavigationsSet_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSuddenTerminationDisablerChanged: {
      return &LocalFrameHost::SuddenTerminationDisablerChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kHadStickyUserActivationBeforeNavigationChanged: {
      return &LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kScrollRectToVisibleInParentFrame: {
      return &LocalFrameHost::ScrollRectToVisibleInParentFrame_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kBubbleLogicalScrollInParentFrame: {
      return &LocalFrameHost::BubbleLogicalScrollInParentFrame_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kStartLoadingForAsyncNavigationApiCommit: {
      return &LocalFrameHost::StartLoadingForAsyncNavigationApiCommit_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidBlockNavigation: {
      return &LocalFrameHost::DidBlockNavigation_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidChangeLoadProgress: {
      return &LocalFrameHost::DidChangeLoadProgress_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidFinishLoad: {
      return &LocalFrameHost::DidFinishLoad_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDispatchLoad: {
      return &LocalFrameHost::DispatchLoad_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kGoToEntryAtOffset: {
      return &LocalFrameHost::GoToEntryAtOffset_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kNavigateToNavigationApiKey: {
      return &LocalFrameHost::NavigateToNavigationApiKey_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kNavigateEventHandlerPresenceChanged: {
      return &LocalFrameHost::NavigateEventHandlerPresenceChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kUpdateTitle: {
      return &LocalFrameHost::UpdateTitle_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kUpdateApplicationTitle: {
      return &LocalFrameHost::UpdateApplicationTitle_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kUpdateUserActivationState: {
      return &LocalFrameHost::UpdateUserActivationState_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidConsumeHistoryUserActivation: {
      return &LocalFrameHost::DidConsumeHistoryUserActivation_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kHandleAccessibilityFindInPageResult: {
      return &LocalFrameHost::HandleAccessibilityFindInPageResult_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kHandleAccessibilityFindInPageTermination: {
      return &LocalFrameHost::HandleAccessibilityFindInPageTermination_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDocumentOnLoadCompleted: {
      return &LocalFrameHost::DocumentOnLoadCompleted_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kForwardResourceTimingToParent: {
      return &LocalFrameHost::ForwardResourceTimingToParent_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidDispatchDOMContentLoadedEvent: {
      return &LocalFrameHost::DidDispatchDOMContentLoadedEvent_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kRunModalAlertDialog: {
      return &LocalFrameHost::RunModalAlertDialog_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kRunModalConfirmDialog: {
      return &LocalFrameHost::RunModalConfirmDialog_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kRunModalPromptDialog: {
      return &LocalFrameHost::RunModalPromptDialog_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kRunBeforeUnloadConfirm: {
      return &LocalFrameHost::RunBeforeUnloadConfirm_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kUpdateFaviconURL: {
      return &LocalFrameHost::UpdateFaviconURL_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDownloadURL: {
      return &LocalFrameHost::DownloadURL_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kFocusedElementChanged: {
      return &LocalFrameHost::FocusedElementChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kTextSelectionChanged: {
      return &LocalFrameHost::TextSelectionChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kShowPopupMenu: {
      return &LocalFrameHost::ShowPopupMenu_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kCreateNewPopupWidget: {
      return &LocalFrameHost::CreateNewPopupWidget_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kShowContextMenu: {
      return &LocalFrameHost::ShowContextMenu_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidLoadResourceFromMemoryCache: {
      return &LocalFrameHost::DidLoadResourceFromMemoryCache_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidChangeFrameOwnerProperties: {
      return &LocalFrameHost::DidChangeFrameOwnerProperties_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidChangeOpener: {
      return &LocalFrameHost::DidChangeOpener_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidChangeFramePolicy: {
      return &LocalFrameHost::DidChangeFramePolicy_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidChangeIframeAttributes: {
      return &LocalFrameHost::DidChangeIframeAttributes_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kCapturePaintPreviewOfSubframe: {
      return &LocalFrameHost::CapturePaintPreviewOfSubframe_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSetCloseListener: {
      return &LocalFrameHost::SetCloseListener_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDetach: {
      return &LocalFrameHost::Detach_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kGetKeepAliveHandleFactory: {
      return &LocalFrameHost::GetKeepAliveHandleFactory_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidAddMessageToConsole: {
      return &LocalFrameHost::DidAddMessageToConsole_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kFrameSizeChanged: {
      return &LocalFrameHost::FrameSizeChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidInferColorScheme: {
      return &LocalFrameHost::DidInferColorScheme_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDidChangeSrcDoc: {
      return &LocalFrameHost::DidChangeSrcDoc_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kReceivedDelegatedCapability: {
      return &LocalFrameHost::ReceivedDelegatedCapability_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSendFencedFrameReportingBeacon: {
      return &LocalFrameHost::SendFencedFrameReportingBeacon_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSendFencedFrameReportingBeaconToCustomURL: {
      return &LocalFrameHost::SendFencedFrameReportingBeaconToCustomURL_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDisableUntrustedNetworkInFencedFrame: {
      return &LocalFrameHost::DisableUntrustedNetworkInFencedFrame_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kExemptUrlFromNetworkRevocationForTesting: {
      return &LocalFrameHost::ExemptUrlFromNetworkRevocationForTesting_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSendLegacyTechEvent: {
      return &LocalFrameHost::SendLegacyTechEvent_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSetFencedFrameAutomaticBeaconReportEventData: {
      return &LocalFrameHost::SetFencedFrameAutomaticBeaconReportEventData_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSendPrivateAggregationRequestsForFencedFrameEvent: {
      return &LocalFrameHost::SendPrivateAggregationRequestsForFencedFrameEvent_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kCreateFencedFrame: {
      return &LocalFrameHost::CreateFencedFrame_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kForwardFencedFrameEventAndUserActivationToEmbedder: {
      return &LocalFrameHost::ForwardFencedFrameEventAndUserActivationToEmbedder_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kOnViewTransitionOptInChanged: {
      return &LocalFrameHost::OnViewTransitionOptInChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kStartDragging: {
      return &LocalFrameHost::StartDragging_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kIssueKeepAliveHandle: {
      return &LocalFrameHost::IssueKeepAliveHandle_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kNotifyStorageAccessed: {
      return &LocalFrameHost::NotifyStorageAccessed_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kRecordWindowProxyUsageMetrics: {
      return &LocalFrameHost::RecordWindowProxyUsageMetrics_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kNotifyDocumentInteractive: {
      return &LocalFrameHost::NotifyDocumentInteractive_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSetStorageAccessApiStatus: {
      return &LocalFrameHost::SetStorageAccessApiStatus_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kInitializeCrashReportStorage: {
      return &LocalFrameHost::InitializeCrashReportStorage_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kSetCrashReportStorageKey: {
      return &LocalFrameHost::SetCrashReportStorageKey_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kRemoveCrashReportStorageKey: {
      return &LocalFrameHost::RemoveCrashReportStorageKey_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LocalFrameHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LocalFrameHost>(message.name())) {
      case messages::LocalFrameHost::kEnterFullscreen:
            return "Receive blink::mojom::LocalFrameHost::EnterFullscreen";
      case messages::LocalFrameHost::kExitFullscreen:
            return "Receive blink::mojom::LocalFrameHost::ExitFullscreen";
      case messages::LocalFrameHost::kFullscreenStateChanged:
            return "Receive blink::mojom::LocalFrameHost::FullscreenStateChanged";
      case messages::LocalFrameHost::kRegisterProtocolHandler:
            return "Receive blink::mojom::LocalFrameHost::RegisterProtocolHandler";
      case messages::LocalFrameHost::kUnregisterProtocolHandler:
            return "Receive blink::mojom::LocalFrameHost::UnregisterProtocolHandler";
      case messages::LocalFrameHost::kDidDisplayInsecureContent:
            return "Receive blink::mojom::LocalFrameHost::DidDisplayInsecureContent";
      case messages::LocalFrameHost::kDidContainInsecureFormAction:
            return "Receive blink::mojom::LocalFrameHost::DidContainInsecureFormAction";
      case messages::LocalFrameHost::kMainDocumentElementAvailable:
            return "Receive blink::mojom::LocalFrameHost::MainDocumentElementAvailable";
      case messages::LocalFrameHost::kSetNeedsOcclusionTracking:
            return "Receive blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking";
      case messages::LocalFrameHost::kSetVirtualKeyboardMode:
            return "Receive blink::mojom::LocalFrameHost::SetVirtualKeyboardMode";
      case messages::LocalFrameHost::kVisibilityChanged:
            return "Receive blink::mojom::LocalFrameHost::VisibilityChanged";
      case messages::LocalFrameHost::kDidChangeThemeColor:
            return "Receive blink::mojom::LocalFrameHost::DidChangeThemeColor";
      case messages::LocalFrameHost::kDidChangeBackgroundColor:
            return "Receive blink::mojom::LocalFrameHost::DidChangeBackgroundColor";
      case messages::LocalFrameHost::kDidFailLoadWithError:
            return "Receive blink::mojom::LocalFrameHost::DidFailLoadWithError";
      case messages::LocalFrameHost::kDidFocusFrame:
            return "Receive blink::mojom::LocalFrameHost::DidFocusFrame";
      case messages::LocalFrameHost::kDidCallFocus:
            return "Receive blink::mojom::LocalFrameHost::DidCallFocus";
      case messages::LocalFrameHost::kEnforceInsecureRequestPolicy:
            return "Receive blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy";
      case messages::LocalFrameHost::kEnforceInsecureNavigationsSet:
            return "Receive blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet";
      case messages::LocalFrameHost::kSuddenTerminationDisablerChanged:
            return "Receive blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged";
      case messages::LocalFrameHost::kHadStickyUserActivationBeforeNavigationChanged:
            return "Receive blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged";
      case messages::LocalFrameHost::kScrollRectToVisibleInParentFrame:
            return "Receive blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame";
      case messages::LocalFrameHost::kBubbleLogicalScrollInParentFrame:
            return "Receive blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame";
      case messages::LocalFrameHost::kStartLoadingForAsyncNavigationApiCommit:
            return "Receive blink::mojom::LocalFrameHost::StartLoadingForAsyncNavigationApiCommit";
      case messages::LocalFrameHost::kDidBlockNavigation:
            return "Receive blink::mojom::LocalFrameHost::DidBlockNavigation";
      case messages::LocalFrameHost::kDidChangeLoadProgress:
            return "Receive blink::mojom::LocalFrameHost::DidChangeLoadProgress";
      case messages::LocalFrameHost::kDidFinishLoad:
            return "Receive blink::mojom::LocalFrameHost::DidFinishLoad";
      case messages::LocalFrameHost::kDispatchLoad:
            return "Receive blink::mojom::LocalFrameHost::DispatchLoad";
      case messages::LocalFrameHost::kGoToEntryAtOffset:
            return "Receive blink::mojom::LocalFrameHost::GoToEntryAtOffset";
      case messages::LocalFrameHost::kNavigateToNavigationApiKey:
            return "Receive blink::mojom::LocalFrameHost::NavigateToNavigationApiKey";
      case messages::LocalFrameHost::kNavigateEventHandlerPresenceChanged:
            return "Receive blink::mojom::LocalFrameHost::NavigateEventHandlerPresenceChanged";
      case messages::LocalFrameHost::kUpdateTitle:
            return "Receive blink::mojom::LocalFrameHost::UpdateTitle";
      case messages::LocalFrameHost::kUpdateApplicationTitle:
            return "Receive blink::mojom::LocalFrameHost::UpdateApplicationTitle";
      case messages::LocalFrameHost::kUpdateUserActivationState:
            return "Receive blink::mojom::LocalFrameHost::UpdateUserActivationState";
      case messages::LocalFrameHost::kDidConsumeHistoryUserActivation:
            return "Receive blink::mojom::LocalFrameHost::DidConsumeHistoryUserActivation";
      case messages::LocalFrameHost::kHandleAccessibilityFindInPageResult:
            return "Receive blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult";
      case messages::LocalFrameHost::kHandleAccessibilityFindInPageTermination:
            return "Receive blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination";
      case messages::LocalFrameHost::kDocumentOnLoadCompleted:
            return "Receive blink::mojom::LocalFrameHost::DocumentOnLoadCompleted";
      case messages::LocalFrameHost::kForwardResourceTimingToParent:
            return "Receive blink::mojom::LocalFrameHost::ForwardResourceTimingToParent";
      case messages::LocalFrameHost::kDidDispatchDOMContentLoadedEvent:
            return "Receive blink::mojom::LocalFrameHost::DidDispatchDOMContentLoadedEvent";
      case messages::LocalFrameHost::kRunModalAlertDialog:
            return "Receive blink::mojom::LocalFrameHost::RunModalAlertDialog";
      case messages::LocalFrameHost::kRunModalConfirmDialog:
            return "Receive blink::mojom::LocalFrameHost::RunModalConfirmDialog";
      case messages::LocalFrameHost::kRunModalPromptDialog:
            return "Receive blink::mojom::LocalFrameHost::RunModalPromptDialog";
      case messages::LocalFrameHost::kRunBeforeUnloadConfirm:
            return "Receive blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm";
      case messages::LocalFrameHost::kUpdateFaviconURL:
            return "Receive blink::mojom::LocalFrameHost::UpdateFaviconURL";
      case messages::LocalFrameHost::kDownloadURL:
            return "Receive blink::mojom::LocalFrameHost::DownloadURL";
      case messages::LocalFrameHost::kFocusedElementChanged:
            return "Receive blink::mojom::LocalFrameHost::FocusedElementChanged";
      case messages::LocalFrameHost::kTextSelectionChanged:
            return "Receive blink::mojom::LocalFrameHost::TextSelectionChanged";
      case messages::LocalFrameHost::kShowPopupMenu:
            return "Receive blink::mojom::LocalFrameHost::ShowPopupMenu";
      case messages::LocalFrameHost::kCreateNewPopupWidget:
            return "Receive blink::mojom::LocalFrameHost::CreateNewPopupWidget";
      case messages::LocalFrameHost::kShowContextMenu:
            return "Receive blink::mojom::LocalFrameHost::ShowContextMenu";
      case messages::LocalFrameHost::kDidLoadResourceFromMemoryCache:
            return "Receive blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache";
      case messages::LocalFrameHost::kDidChangeFrameOwnerProperties:
            return "Receive blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties";
      case messages::LocalFrameHost::kDidChangeOpener:
            return "Receive blink::mojom::LocalFrameHost::DidChangeOpener";
      case messages::LocalFrameHost::kDidChangeFramePolicy:
            return "Receive blink::mojom::LocalFrameHost::DidChangeFramePolicy";
      case messages::LocalFrameHost::kDidChangeIframeAttributes:
            return "Receive blink::mojom::LocalFrameHost::DidChangeIframeAttributes";
      case messages::LocalFrameHost::kCapturePaintPreviewOfSubframe:
            return "Receive blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe";
      case messages::LocalFrameHost::kSetCloseListener:
            return "Receive blink::mojom::LocalFrameHost::SetCloseListener";
      case messages::LocalFrameHost::kDetach:
            return "Receive blink::mojom::LocalFrameHost::Detach";
      case messages::LocalFrameHost::kGetKeepAliveHandleFactory:
            return "Receive blink::mojom::LocalFrameHost::GetKeepAliveHandleFactory";
      case messages::LocalFrameHost::kDidAddMessageToConsole:
            return "Receive blink::mojom::LocalFrameHost::DidAddMessageToConsole";
      case messages::LocalFrameHost::kFrameSizeChanged:
            return "Receive blink::mojom::LocalFrameHost::FrameSizeChanged";
      case messages::LocalFrameHost::kDidInferColorScheme:
            return "Receive blink::mojom::LocalFrameHost::DidInferColorScheme";
      case messages::LocalFrameHost::kDidChangeSrcDoc:
            return "Receive blink::mojom::LocalFrameHost::DidChangeSrcDoc";
      case messages::LocalFrameHost::kReceivedDelegatedCapability:
            return "Receive blink::mojom::LocalFrameHost::ReceivedDelegatedCapability";
      case messages::LocalFrameHost::kSendFencedFrameReportingBeacon:
            return "Receive blink::mojom::LocalFrameHost::SendFencedFrameReportingBeacon";
      case messages::LocalFrameHost::kSendFencedFrameReportingBeaconToCustomURL:
            return "Receive blink::mojom::LocalFrameHost::SendFencedFrameReportingBeaconToCustomURL";
      case messages::LocalFrameHost::kDisableUntrustedNetworkInFencedFrame:
            return "Receive blink::mojom::LocalFrameHost::DisableUntrustedNetworkInFencedFrame";
      case messages::LocalFrameHost::kExemptUrlFromNetworkRevocationForTesting:
            return "Receive blink::mojom::LocalFrameHost::ExemptUrlFromNetworkRevocationForTesting";
      case messages::LocalFrameHost::kSendLegacyTechEvent:
            return "Receive blink::mojom::LocalFrameHost::SendLegacyTechEvent";
      case messages::LocalFrameHost::kSetFencedFrameAutomaticBeaconReportEventData:
            return "Receive blink::mojom::LocalFrameHost::SetFencedFrameAutomaticBeaconReportEventData";
      case messages::LocalFrameHost::kSendPrivateAggregationRequestsForFencedFrameEvent:
            return "Receive blink::mojom::LocalFrameHost::SendPrivateAggregationRequestsForFencedFrameEvent";
      case messages::LocalFrameHost::kCreateFencedFrame:
            return "Receive blink::mojom::LocalFrameHost::CreateFencedFrame";
      case messages::LocalFrameHost::kForwardFencedFrameEventAndUserActivationToEmbedder:
            return "Receive blink::mojom::LocalFrameHost::ForwardFencedFrameEventAndUserActivationToEmbedder";
      case messages::LocalFrameHost::kOnViewTransitionOptInChanged:
            return "Receive blink::mojom::LocalFrameHost::OnViewTransitionOptInChanged";
      case messages::LocalFrameHost::kStartDragging:
            return "Receive blink::mojom::LocalFrameHost::StartDragging";
      case messages::LocalFrameHost::kIssueKeepAliveHandle:
            return "Receive blink::mojom::LocalFrameHost::IssueKeepAliveHandle";
      case messages::LocalFrameHost::kNotifyStorageAccessed:
            return "Receive blink::mojom::LocalFrameHost::NotifyStorageAccessed";
      case messages::LocalFrameHost::kRecordWindowProxyUsageMetrics:
            return "Receive blink::mojom::LocalFrameHost::RecordWindowProxyUsageMetrics";
      case messages::LocalFrameHost::kNotifyDocumentInteractive:
            return "Receive blink::mojom::LocalFrameHost::NotifyDocumentInteractive";
      case messages::LocalFrameHost::kSetStorageAccessApiStatus:
            return "Receive blink::mojom::LocalFrameHost::SetStorageAccessApiStatus";
      case messages::LocalFrameHost::kInitializeCrashReportStorage:
            return "Receive blink::mojom::LocalFrameHost::InitializeCrashReportStorage";
      case messages::LocalFrameHost::kSetCrashReportStorageKey:
            return "Receive blink::mojom::LocalFrameHost::SetCrashReportStorageKey";
      case messages::LocalFrameHost::kRemoveCrashReportStorageKey:
            return "Receive blink::mojom::LocalFrameHost::RemoveCrashReportStorageKey";
    }
  } else {
    switch (static_cast<messages::LocalFrameHost>(message.name())) {
      case messages::LocalFrameHost::kEnterFullscreen:
            return "Receive reply blink::mojom::LocalFrameHost::EnterFullscreen";
      case messages::LocalFrameHost::kExitFullscreen:
            return "Receive reply blink::mojom::LocalFrameHost::ExitFullscreen";
      case messages::LocalFrameHost::kFullscreenStateChanged:
            return "Receive reply blink::mojom::LocalFrameHost::FullscreenStateChanged";
      case messages::LocalFrameHost::kRegisterProtocolHandler:
            return "Receive reply blink::mojom::LocalFrameHost::RegisterProtocolHandler";
      case messages::LocalFrameHost::kUnregisterProtocolHandler:
            return "Receive reply blink::mojom::LocalFrameHost::UnregisterProtocolHandler";
      case messages::LocalFrameHost::kDidDisplayInsecureContent:
            return "Receive reply blink::mojom::LocalFrameHost::DidDisplayInsecureContent";
      case messages::LocalFrameHost::kDidContainInsecureFormAction:
            return "Receive reply blink::mojom::LocalFrameHost::DidContainInsecureFormAction";
      case messages::LocalFrameHost::kMainDocumentElementAvailable:
            return "Receive reply blink::mojom::LocalFrameHost::MainDocumentElementAvailable";
      case messages::LocalFrameHost::kSetNeedsOcclusionTracking:
            return "Receive reply blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking";
      case messages::LocalFrameHost::kSetVirtualKeyboardMode:
            return "Receive reply blink::mojom::LocalFrameHost::SetVirtualKeyboardMode";
      case messages::LocalFrameHost::kVisibilityChanged:
            return "Receive reply blink::mojom::LocalFrameHost::VisibilityChanged";
      case messages::LocalFrameHost::kDidChangeThemeColor:
            return "Receive reply blink::mojom::LocalFrameHost::DidChangeThemeColor";
      case messages::LocalFrameHost::kDidChangeBackgroundColor:
            return "Receive reply blink::mojom::LocalFrameHost::DidChangeBackgroundColor";
      case messages::LocalFrameHost::kDidFailLoadWithError:
            return "Receive reply blink::mojom::LocalFrameHost::DidFailLoadWithError";
      case messages::LocalFrameHost::kDidFocusFrame:
            return "Receive reply blink::mojom::LocalFrameHost::DidFocusFrame";
      case messages::LocalFrameHost::kDidCallFocus:
            return "Receive reply blink::mojom::LocalFrameHost::DidCallFocus";
      case messages::LocalFrameHost::kEnforceInsecureRequestPolicy:
            return "Receive reply blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy";
      case messages::LocalFrameHost::kEnforceInsecureNavigationsSet:
            return "Receive reply blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet";
      case messages::LocalFrameHost::kSuddenTerminationDisablerChanged:
            return "Receive reply blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged";
      case messages::LocalFrameHost::kHadStickyUserActivationBeforeNavigationChanged:
            return "Receive reply blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged";
      case messages::LocalFrameHost::kScrollRectToVisibleInParentFrame:
            return "Receive reply blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame";
      case messages::LocalFrameHost::kBubbleLogicalScrollInParentFrame:
            return "Receive reply blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame";
      case messages::LocalFrameHost::kStartLoadingForAsyncNavigationApiCommit:
            return "Receive reply blink::mojom::LocalFrameHost::StartLoadingForAsyncNavigationApiCommit";
      case messages::LocalFrameHost::kDidBlockNavigation:
            return "Receive reply blink::mojom::LocalFrameHost::DidBlockNavigation";
      case messages::LocalFrameHost::kDidChangeLoadProgress:
            return "Receive reply blink::mojom::LocalFrameHost::DidChangeLoadProgress";
      case messages::LocalFrameHost::kDidFinishLoad:
            return "Receive reply blink::mojom::LocalFrameHost::DidFinishLoad";
      case messages::LocalFrameHost::kDispatchLoad:
            return "Receive reply blink::mojom::LocalFrameHost::DispatchLoad";
      case messages::LocalFrameHost::kGoToEntryAtOffset:
            return "Receive reply blink::mojom::LocalFrameHost::GoToEntryAtOffset";
      case messages::LocalFrameHost::kNavigateToNavigationApiKey:
            return "Receive reply blink::mojom::LocalFrameHost::NavigateToNavigationApiKey";
      case messages::LocalFrameHost::kNavigateEventHandlerPresenceChanged:
            return "Receive reply blink::mojom::LocalFrameHost::NavigateEventHandlerPresenceChanged";
      case messages::LocalFrameHost::kUpdateTitle:
            return "Receive reply blink::mojom::LocalFrameHost::UpdateTitle";
      case messages::LocalFrameHost::kUpdateApplicationTitle:
            return "Receive reply blink::mojom::LocalFrameHost::UpdateApplicationTitle";
      case messages::LocalFrameHost::kUpdateUserActivationState:
            return "Receive reply blink::mojom::LocalFrameHost::UpdateUserActivationState";
      case messages::LocalFrameHost::kDidConsumeHistoryUserActivation:
            return "Receive reply blink::mojom::LocalFrameHost::DidConsumeHistoryUserActivation";
      case messages::LocalFrameHost::kHandleAccessibilityFindInPageResult:
            return "Receive reply blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult";
      case messages::LocalFrameHost::kHandleAccessibilityFindInPageTermination:
            return "Receive reply blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination";
      case messages::LocalFrameHost::kDocumentOnLoadCompleted:
            return "Receive reply blink::mojom::LocalFrameHost::DocumentOnLoadCompleted";
      case messages::LocalFrameHost::kForwardResourceTimingToParent:
            return "Receive reply blink::mojom::LocalFrameHost::ForwardResourceTimingToParent";
      case messages::LocalFrameHost::kDidDispatchDOMContentLoadedEvent:
            return "Receive reply blink::mojom::LocalFrameHost::DidDispatchDOMContentLoadedEvent";
      case messages::LocalFrameHost::kRunModalAlertDialog:
            return "Receive reply blink::mojom::LocalFrameHost::RunModalAlertDialog";
      case messages::LocalFrameHost::kRunModalConfirmDialog:
            return "Receive reply blink::mojom::LocalFrameHost::RunModalConfirmDialog";
      case messages::LocalFrameHost::kRunModalPromptDialog:
            return "Receive reply blink::mojom::LocalFrameHost::RunModalPromptDialog";
      case messages::LocalFrameHost::kRunBeforeUnloadConfirm:
            return "Receive reply blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm";
      case messages::LocalFrameHost::kUpdateFaviconURL:
            return "Receive reply blink::mojom::LocalFrameHost::UpdateFaviconURL";
      case messages::LocalFrameHost::kDownloadURL:
            return "Receive reply blink::mojom::LocalFrameHost::DownloadURL";
      case messages::LocalFrameHost::kFocusedElementChanged:
            return "Receive reply blink::mojom::LocalFrameHost::FocusedElementChanged";
      case messages::LocalFrameHost::kTextSelectionChanged:
            return "Receive reply blink::mojom::LocalFrameHost::TextSelectionChanged";
      case messages::LocalFrameHost::kShowPopupMenu:
            return "Receive reply blink::mojom::LocalFrameHost::ShowPopupMenu";
      case messages::LocalFrameHost::kCreateNewPopupWidget:
            return "Receive reply blink::mojom::LocalFrameHost::CreateNewPopupWidget";
      case messages::LocalFrameHost::kShowContextMenu:
            return "Receive reply blink::mojom::LocalFrameHost::ShowContextMenu";
      case messages::LocalFrameHost::kDidLoadResourceFromMemoryCache:
            return "Receive reply blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache";
      case messages::LocalFrameHost::kDidChangeFrameOwnerProperties:
            return "Receive reply blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties";
      case messages::LocalFrameHost::kDidChangeOpener:
            return "Receive reply blink::mojom::LocalFrameHost::DidChangeOpener";
      case messages::LocalFrameHost::kDidChangeFramePolicy:
            return "Receive reply blink::mojom::LocalFrameHost::DidChangeFramePolicy";
      case messages::LocalFrameHost::kDidChangeIframeAttributes:
            return "Receive reply blink::mojom::LocalFrameHost::DidChangeIframeAttributes";
      case messages::LocalFrameHost::kCapturePaintPreviewOfSubframe:
            return "Receive reply blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe";
      case messages::LocalFrameHost::kSetCloseListener:
            return "Receive reply blink::mojom::LocalFrameHost::SetCloseListener";
      case messages::LocalFrameHost::kDetach:
            return "Receive reply blink::mojom::LocalFrameHost::Detach";
      case messages::LocalFrameHost::kGetKeepAliveHandleFactory:
            return "Receive reply blink::mojom::LocalFrameHost::GetKeepAliveHandleFactory";
      case messages::LocalFrameHost::kDidAddMessageToConsole:
            return "Receive reply blink::mojom::LocalFrameHost::DidAddMessageToConsole";
      case messages::LocalFrameHost::kFrameSizeChanged:
            return "Receive reply blink::mojom::LocalFrameHost::FrameSizeChanged";
      case messages::LocalFrameHost::kDidInferColorScheme:
            return "Receive reply blink::mojom::LocalFrameHost::DidInferColorScheme";
      case messages::LocalFrameHost::kDidChangeSrcDoc:
            return "Receive reply blink::mojom::LocalFrameHost::DidChangeSrcDoc";
      case messages::LocalFrameHost::kReceivedDelegatedCapability:
            return "Receive reply blink::mojom::LocalFrameHost::ReceivedDelegatedCapability";
      case messages::LocalFrameHost::kSendFencedFrameReportingBeacon:
            return "Receive reply blink::mojom::LocalFrameHost::SendFencedFrameReportingBeacon";
      case messages::LocalFrameHost::kSendFencedFrameReportingBeaconToCustomURL:
            return "Receive reply blink::mojom::LocalFrameHost::SendFencedFrameReportingBeaconToCustomURL";
      case messages::LocalFrameHost::kDisableUntrustedNetworkInFencedFrame:
            return "Receive reply blink::mojom::LocalFrameHost::DisableUntrustedNetworkInFencedFrame";
      case messages::LocalFrameHost::kExemptUrlFromNetworkRevocationForTesting:
            return "Receive reply blink::mojom::LocalFrameHost::ExemptUrlFromNetworkRevocationForTesting";
      case messages::LocalFrameHost::kSendLegacyTechEvent:
            return "Receive reply blink::mojom::LocalFrameHost::SendLegacyTechEvent";
      case messages::LocalFrameHost::kSetFencedFrameAutomaticBeaconReportEventData:
            return "Receive reply blink::mojom::LocalFrameHost::SetFencedFrameAutomaticBeaconReportEventData";
      case messages::LocalFrameHost::kSendPrivateAggregationRequestsForFencedFrameEvent:
            return "Receive reply blink::mojom::LocalFrameHost::SendPrivateAggregationRequestsForFencedFrameEvent";
      case messages::LocalFrameHost::kCreateFencedFrame:
            return "Receive reply blink::mojom::LocalFrameHost::CreateFencedFrame";
      case messages::LocalFrameHost::kForwardFencedFrameEventAndUserActivationToEmbedder:
            return "Receive reply blink::mojom::LocalFrameHost::ForwardFencedFrameEventAndUserActivationToEmbedder";
      case messages::LocalFrameHost::kOnViewTransitionOptInChanged:
            return "Receive reply blink::mojom::LocalFrameHost::OnViewTransitionOptInChanged";
      case messages::LocalFrameHost::kStartDragging:
            return "Receive reply blink::mojom::LocalFrameHost::StartDragging";
      case messages::LocalFrameHost::kIssueKeepAliveHandle:
            return "Receive reply blink::mojom::LocalFrameHost::IssueKeepAliveHandle";
      case messages::LocalFrameHost::kNotifyStorageAccessed:
            return "Receive reply blink::mojom::LocalFrameHost::NotifyStorageAccessed";
      case messages::LocalFrameHost::kRecordWindowProxyUsageMetrics:
            return "Receive reply blink::mojom::LocalFrameHost::RecordWindowProxyUsageMetrics";
      case messages::LocalFrameHost::kNotifyDocumentInteractive:
            return "Receive reply blink::mojom::LocalFrameHost::NotifyDocumentInteractive";
      case messages::LocalFrameHost::kSetStorageAccessApiStatus:
            return "Receive reply blink::mojom::LocalFrameHost::SetStorageAccessApiStatus";
      case messages::LocalFrameHost::kInitializeCrashReportStorage:
            return "Receive reply blink::mojom::LocalFrameHost::InitializeCrashReportStorage";
      case messages::LocalFrameHost::kSetCrashReportStorageKey:
            return "Receive reply blink::mojom::LocalFrameHost::SetCrashReportStorageKey";
      case messages::LocalFrameHost::kRemoveCrashReportStorageKey:
            return "Receive reply blink::mojom::LocalFrameHost::RemoveCrashReportStorageKey";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LocalFrameHost::EnterFullscreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x215fe0fe;  // IPCStableHash for blink::mojom::LocalFrameHost::EnterFullscreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ExitFullscreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64ad1c14;  // IPCStableHash for blink::mojom::LocalFrameHost::ExitFullscreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::FullscreenStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17d2f119;  // IPCStableHash for blink::mojom::LocalFrameHost::FullscreenStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::RegisterProtocolHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b6787d9;  // IPCStableHash for blink::mojom::LocalFrameHost::RegisterProtocolHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::UnregisterProtocolHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f222d44;  // IPCStableHash for blink::mojom::LocalFrameHost::UnregisterProtocolHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidDisplayInsecureContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50d02eea;  // IPCStableHash for blink::mojom::LocalFrameHost::DidDisplayInsecureContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidContainInsecureFormAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe601747b;  // IPCStableHash for blink::mojom::LocalFrameHost::DidContainInsecureFormAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::MainDocumentElementAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c984a7d;  // IPCStableHash for blink::mojom::LocalFrameHost::MainDocumentElementAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SetNeedsOcclusionTracking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21110083;  // IPCStableHash for blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SetVirtualKeyboardMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed01bd1c;  // IPCStableHash for blink::mojom::LocalFrameHost::SetVirtualKeyboardMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::VisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa19535d7;  // IPCStableHash for blink::mojom::LocalFrameHost::VisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidChangeThemeColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e2bd906;  // IPCStableHash for blink::mojom::LocalFrameHost::DidChangeThemeColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidChangeBackgroundColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4504cd6;  // IPCStableHash for blink::mojom::LocalFrameHost::DidChangeBackgroundColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidFailLoadWithError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62d0da4c;  // IPCStableHash for blink::mojom::LocalFrameHost::DidFailLoadWithError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidFocusFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a71b83d;  // IPCStableHash for blink::mojom::LocalFrameHost::DidFocusFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidCallFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb67aa055;  // IPCStableHash for blink::mojom::LocalFrameHost::DidCallFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::EnforceInsecureRequestPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0cfe4291;  // IPCStableHash for blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::EnforceInsecureNavigationsSet_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2347f16;  // IPCStableHash for blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SuddenTerminationDisablerChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x693089e5;  // IPCStableHash for blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8c00ee5;  // IPCStableHash for blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ScrollRectToVisibleInParentFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c79fd7d;  // IPCStableHash for blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::BubbleLogicalScrollInParentFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb01e0e47;  // IPCStableHash for blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::StartLoadingForAsyncNavigationApiCommit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf369afa;  // IPCStableHash for blink::mojom::LocalFrameHost::StartLoadingForAsyncNavigationApiCommit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidBlockNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47845d63;  // IPCStableHash for blink::mojom::LocalFrameHost::DidBlockNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidChangeLoadProgress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8595e63;  // IPCStableHash for blink::mojom::LocalFrameHost::DidChangeLoadProgress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidFinishLoad_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xda3a6901;  // IPCStableHash for blink::mojom::LocalFrameHost::DidFinishLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DispatchLoad_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x059a1b9c;  // IPCStableHash for blink::mojom::LocalFrameHost::DispatchLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::GoToEntryAtOffset_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf82cf64;  // IPCStableHash for blink::mojom::LocalFrameHost::GoToEntryAtOffset
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::NavigateToNavigationApiKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03f964b2;  // IPCStableHash for blink::mojom::LocalFrameHost::NavigateToNavigationApiKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::NavigateEventHandlerPresenceChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b984da4;  // IPCStableHash for blink::mojom::LocalFrameHost::NavigateEventHandlerPresenceChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::UpdateTitle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa627559a;  // IPCStableHash for blink::mojom::LocalFrameHost::UpdateTitle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::UpdateApplicationTitle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f2ec9f3;  // IPCStableHash for blink::mojom::LocalFrameHost::UpdateApplicationTitle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::UpdateUserActivationState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca8d096a;  // IPCStableHash for blink::mojom::LocalFrameHost::UpdateUserActivationState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidConsumeHistoryUserActivation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcac2fd7a;  // IPCStableHash for blink::mojom::LocalFrameHost::DidConsumeHistoryUserActivation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::HandleAccessibilityFindInPageResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4164e6a5;  // IPCStableHash for blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::HandleAccessibilityFindInPageTermination_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6af072e2;  // IPCStableHash for blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DocumentOnLoadCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f3bc305;  // IPCStableHash for blink::mojom::LocalFrameHost::DocumentOnLoadCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ForwardResourceTimingToParent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb26cc88;  // IPCStableHash for blink::mojom::LocalFrameHost::ForwardResourceTimingToParent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidDispatchDOMContentLoadedEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x577854ef;  // IPCStableHash for blink::mojom::LocalFrameHost::DidDispatchDOMContentLoadedEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::RunModalAlertDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03a27cd1;  // IPCStableHash for blink::mojom::LocalFrameHost::RunModalAlertDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::RunModalConfirmDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x964c5035;  // IPCStableHash for blink::mojom::LocalFrameHost::RunModalConfirmDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::RunModalPromptDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb4d8de41;  // IPCStableHash for blink::mojom::LocalFrameHost::RunModalPromptDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::RunBeforeUnloadConfirm_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf0ca6a01;  // IPCStableHash for blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::UpdateFaviconURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf451b57a;  // IPCStableHash for blink::mojom::LocalFrameHost::UpdateFaviconURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DownloadURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb0c58fe;  // IPCStableHash for blink::mojom::LocalFrameHost::DownloadURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::FocusedElementChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc09cbf2c;  // IPCStableHash for blink::mojom::LocalFrameHost::FocusedElementChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::TextSelectionChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x459e64e7;  // IPCStableHash for blink::mojom::LocalFrameHost::TextSelectionChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ShowPopupMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x200016bb;  // IPCStableHash for blink::mojom::LocalFrameHost::ShowPopupMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::CreateNewPopupWidget_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb0037925;  // IPCStableHash for blink::mojom::LocalFrameHost::CreateNewPopupWidget
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ShowContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28bcf56b;  // IPCStableHash for blink::mojom::LocalFrameHost::ShowContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidLoadResourceFromMemoryCache_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac771cda;  // IPCStableHash for blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidChangeFrameOwnerProperties_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c845d0f;  // IPCStableHash for blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidChangeOpener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x415c0aeb;  // IPCStableHash for blink::mojom::LocalFrameHost::DidChangeOpener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidChangeFramePolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10967a39;  // IPCStableHash for blink::mojom::LocalFrameHost::DidChangeFramePolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidChangeIframeAttributes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41a63e04;  // IPCStableHash for blink::mojom::LocalFrameHost::DidChangeIframeAttributes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::CapturePaintPreviewOfSubframe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbefca0f8;  // IPCStableHash for blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SetCloseListener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16278125;  // IPCStableHash for blink::mojom::LocalFrameHost::SetCloseListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::Detach_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3182112;  // IPCStableHash for blink::mojom::LocalFrameHost::Detach
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::GetKeepAliveHandleFactory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6778b089;  // IPCStableHash for blink::mojom::LocalFrameHost::GetKeepAliveHandleFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidAddMessageToConsole_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf28c2b10;  // IPCStableHash for blink::mojom::LocalFrameHost::DidAddMessageToConsole
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::FrameSizeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f9a171b;  // IPCStableHash for blink::mojom::LocalFrameHost::FrameSizeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidInferColorScheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15b3ac17;  // IPCStableHash for blink::mojom::LocalFrameHost::DidInferColorScheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DidChangeSrcDoc_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa69ddaf1;  // IPCStableHash for blink::mojom::LocalFrameHost::DidChangeSrcDoc
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ReceivedDelegatedCapability_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f6a57c8;  // IPCStableHash for blink::mojom::LocalFrameHost::ReceivedDelegatedCapability
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SendFencedFrameReportingBeacon_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc149dca4;  // IPCStableHash for blink::mojom::LocalFrameHost::SendFencedFrameReportingBeacon
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SendFencedFrameReportingBeaconToCustomURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1647897e;  // IPCStableHash for blink::mojom::LocalFrameHost::SendFencedFrameReportingBeaconToCustomURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DisableUntrustedNetworkInFencedFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x749d72d9;  // IPCStableHash for blink::mojom::LocalFrameHost::DisableUntrustedNetworkInFencedFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ExemptUrlFromNetworkRevocationForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e34d131;  // IPCStableHash for blink::mojom::LocalFrameHost::ExemptUrlFromNetworkRevocationForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SendLegacyTechEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6c58d32e;  // IPCStableHash for blink::mojom::LocalFrameHost::SendLegacyTechEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SetFencedFrameAutomaticBeaconReportEventData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b67598e;  // IPCStableHash for blink::mojom::LocalFrameHost::SetFencedFrameAutomaticBeaconReportEventData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SendPrivateAggregationRequestsForFencedFrameEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5c78970;  // IPCStableHash for blink::mojom::LocalFrameHost::SendPrivateAggregationRequestsForFencedFrameEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::CreateFencedFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x324be690;  // IPCStableHash for blink::mojom::LocalFrameHost::CreateFencedFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ForwardFencedFrameEventAndUserActivationToEmbedder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b0111a0;  // IPCStableHash for blink::mojom::LocalFrameHost::ForwardFencedFrameEventAndUserActivationToEmbedder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::OnViewTransitionOptInChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64902a5f;  // IPCStableHash for blink::mojom::LocalFrameHost::OnViewTransitionOptInChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::StartDragging_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b852e8e;  // IPCStableHash for blink::mojom::LocalFrameHost::StartDragging
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::IssueKeepAliveHandle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31413bd0;  // IPCStableHash for blink::mojom::LocalFrameHost::IssueKeepAliveHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::NotifyStorageAccessed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9bab71d;  // IPCStableHash for blink::mojom::LocalFrameHost::NotifyStorageAccessed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::RecordWindowProxyUsageMetrics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41e64bc1;  // IPCStableHash for blink::mojom::LocalFrameHost::RecordWindowProxyUsageMetrics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::NotifyDocumentInteractive_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70fd2c49;  // IPCStableHash for blink::mojom::LocalFrameHost::NotifyDocumentInteractive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SetStorageAccessApiStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92d782f7;  // IPCStableHash for blink::mojom::LocalFrameHost::SetStorageAccessApiStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::InitializeCrashReportStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1054ecbb;  // IPCStableHash for blink::mojom::LocalFrameHost::InitializeCrashReportStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::SetCrashReportStorageKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6134943d;  // IPCStableHash for blink::mojom::LocalFrameHost::SetCrashReportStorageKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::RemoveCrashReportStorageKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x53444135;  // IPCStableHash for blink::mojom::LocalFrameHost::RemoveCrashReportStorageKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool LocalFrameHost::RunModalAlertDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion) {
  NOTREACHED();
}
bool LocalFrameHost::RunModalConfirmDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, bool* out_success) {
  NOTREACHED();
}
bool LocalFrameHost::RunModalPromptDialog(const ::std::u16string& alert_message, const ::std::u16string& default_value, bool disable_third_party_subframe_suppresion, bool* out_success, ::std::u16string* out_result) {
  NOTREACHED();
}
bool LocalFrameHost::RunBeforeUnloadConfirm(bool is_reload, bool* out_success) {
  NOTREACHED();
}
bool LocalFrameHost::SetCrashReportStorageKey(const std::string& key, const std::string& value) {
  NOTREACHED();
}
bool LocalFrameHost::RemoveCrashReportStorageKey(const std::string& key) {
  NOTREACHED();
}

class LocalFrameHost_EnterFullscreen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_EnterFullscreen_ForwardToCallback(
      LocalFrameHost::EnterFullscreenCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_EnterFullscreen_ForwardToCallback(const LocalFrameHost_EnterFullscreen_ForwardToCallback&) = delete;
  LocalFrameHost_EnterFullscreen_ForwardToCallback& operator=(const LocalFrameHost_EnterFullscreen_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::EnterFullscreenCallback callback_;
};
class LocalFrameHost_RunModalAlertDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalAlertDialog_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  LocalFrameHost_RunModalAlertDialog_HandleSyncResponse(const LocalFrameHost_RunModalAlertDialog_HandleSyncResponse&) = delete;
  LocalFrameHost_RunModalAlertDialog_HandleSyncResponse& operator=(const LocalFrameHost_RunModalAlertDialog_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class LocalFrameHost_RunModalAlertDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalAlertDialog_ForwardToCallback(
      LocalFrameHost::RunModalAlertDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_RunModalAlertDialog_ForwardToCallback(const LocalFrameHost_RunModalAlertDialog_ForwardToCallback&) = delete;
  LocalFrameHost_RunModalAlertDialog_ForwardToCallback& operator=(const LocalFrameHost_RunModalAlertDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalAlertDialogCallback callback_;
};
class LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }

  LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse(const LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse&) = delete;
  LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse& operator=(const LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;};

class LocalFrameHost_RunModalConfirmDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalConfirmDialog_ForwardToCallback(
      LocalFrameHost::RunModalConfirmDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_RunModalConfirmDialog_ForwardToCallback(const LocalFrameHost_RunModalConfirmDialog_ForwardToCallback&) = delete;
  LocalFrameHost_RunModalConfirmDialog_ForwardToCallback& operator=(const LocalFrameHost_RunModalConfirmDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalConfirmDialogCallback callback_;
};
class LocalFrameHost_RunModalPromptDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalPromptDialog_HandleSyncResponse(
      bool* result, bool* out_success, ::std::u16string* out_result)
      : result_(result), out_success_(out_success), out_result_(out_result) {
    DCHECK(!*result_);
  }

  LocalFrameHost_RunModalPromptDialog_HandleSyncResponse(const LocalFrameHost_RunModalPromptDialog_HandleSyncResponse&) = delete;
  LocalFrameHost_RunModalPromptDialog_HandleSyncResponse& operator=(const LocalFrameHost_RunModalPromptDialog_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  ::std::u16string* out_result_;};

class LocalFrameHost_RunModalPromptDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalPromptDialog_ForwardToCallback(
      LocalFrameHost::RunModalPromptDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_RunModalPromptDialog_ForwardToCallback(const LocalFrameHost_RunModalPromptDialog_ForwardToCallback&) = delete;
  LocalFrameHost_RunModalPromptDialog_ForwardToCallback& operator=(const LocalFrameHost_RunModalPromptDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalPromptDialogCallback callback_;
};
class LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }

  LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse(const LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse&) = delete;
  LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse& operator=(const LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;};

class LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback(
      LocalFrameHost::RunBeforeUnloadConfirmCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback(const LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback&) = delete;
  LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback& operator=(const LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunBeforeUnloadConfirmCallback callback_;
};

class LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ForwardToCallback(
      LocalFrameHost::DisableUntrustedNetworkInFencedFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ForwardToCallback(const LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ForwardToCallback&) = delete;
  LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ForwardToCallback& operator=(const LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::DisableUntrustedNetworkInFencedFrameCallback callback_;
};

class LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ForwardToCallback(
      LocalFrameHost::ExemptUrlFromNetworkRevocationForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ForwardToCallback(const LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ForwardToCallback&) = delete;
  LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ForwardToCallback& operator=(const LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::ExemptUrlFromNetworkRevocationForTestingCallback callback_;
};

class LocalFrameHost_InitializeCrashReportStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_InitializeCrashReportStorage_ForwardToCallback(
      LocalFrameHost::InitializeCrashReportStorageCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_InitializeCrashReportStorage_ForwardToCallback(const LocalFrameHost_InitializeCrashReportStorage_ForwardToCallback&) = delete;
  LocalFrameHost_InitializeCrashReportStorage_ForwardToCallback& operator=(const LocalFrameHost_InitializeCrashReportStorage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::InitializeCrashReportStorageCallback callback_;
};
class LocalFrameHost_SetCrashReportStorageKey_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_SetCrashReportStorageKey_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  LocalFrameHost_SetCrashReportStorageKey_HandleSyncResponse(const LocalFrameHost_SetCrashReportStorageKey_HandleSyncResponse&) = delete;
  LocalFrameHost_SetCrashReportStorageKey_HandleSyncResponse& operator=(const LocalFrameHost_SetCrashReportStorageKey_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class LocalFrameHost_SetCrashReportStorageKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_SetCrashReportStorageKey_ForwardToCallback(
      LocalFrameHost::SetCrashReportStorageKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_SetCrashReportStorageKey_ForwardToCallback(const LocalFrameHost_SetCrashReportStorageKey_ForwardToCallback&) = delete;
  LocalFrameHost_SetCrashReportStorageKey_ForwardToCallback& operator=(const LocalFrameHost_SetCrashReportStorageKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::SetCrashReportStorageKeyCallback callback_;
};
class LocalFrameHost_RemoveCrashReportStorageKey_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RemoveCrashReportStorageKey_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  LocalFrameHost_RemoveCrashReportStorageKey_HandleSyncResponse(const LocalFrameHost_RemoveCrashReportStorageKey_HandleSyncResponse&) = delete;
  LocalFrameHost_RemoveCrashReportStorageKey_HandleSyncResponse& operator=(const LocalFrameHost_RemoveCrashReportStorageKey_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class LocalFrameHost_RemoveCrashReportStorageKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RemoveCrashReportStorageKey_ForwardToCallback(
      LocalFrameHost::RemoveCrashReportStorageKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_RemoveCrashReportStorageKey_ForwardToCallback(const LocalFrameHost_RemoveCrashReportStorageKey_ForwardToCallback&) = delete;
  LocalFrameHost_RemoveCrashReportStorageKey_ForwardToCallback& operator=(const LocalFrameHost_RemoveCrashReportStorageKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RemoveCrashReportStorageKeyCallback callback_;
};

LocalFrameHostProxy::LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameHostProxy::EnterFullscreen(
    ::blink::mojom::FullscreenOptionsPtr in_options, EnterFullscreenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::EnterFullscreen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::FullscreenOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kEnterFullscreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_EnterFullscreen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in LocalFrameHost.EnterFullscreen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnterFullscreen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_EnterFullscreen_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameHostProxy::ExitFullscreen(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::ExitFullscreen");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kExitFullscreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ExitFullscreen_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ExitFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::FullscreenStateChanged(
    bool in_is_fullscreen, ::blink::mojom::FullscreenOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::FullscreenStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_fullscreen"), in_is_fullscreen,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::FullscreenOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kFullscreenStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_FullscreenStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_fullscreen = in_is_fullscreen;
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("FullscreenStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::RegisterProtocolHandler(
    const std::string& in_scheme, const ::GURL& in_url, bool in_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::RegisterProtocolHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scheme"), in_scheme,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRegisterProtocolHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RegisterProtocolHandler_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scheme)::BaseType> scheme_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_scheme,
    scheme_fragment);

  params->scheme.Set(
      scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->scheme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null scheme in LocalFrameHost.RegisterProtocolHandler request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LocalFrameHost.RegisterProtocolHandler request");

  params->user_gesture = in_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RegisterProtocolHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::UnregisterProtocolHandler(
    const std::string& in_scheme, const ::GURL& in_url, bool in_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::UnregisterProtocolHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scheme"), in_scheme,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kUnregisterProtocolHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scheme)::BaseType> scheme_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_scheme,
    scheme_fragment);

  params->scheme.Set(
      scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->scheme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null scheme in LocalFrameHost.UnregisterProtocolHandler request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LocalFrameHost.UnregisterProtocolHandler request");

  params->user_gesture = in_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UnregisterProtocolHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidDisplayInsecureContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DidDisplayInsecureContent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidDisplayInsecureContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidDisplayInsecureContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidContainInsecureFormAction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DidContainInsecureFormAction");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidContainInsecureFormAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidContainInsecureFormAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::MainDocumentElementAvailable(
    bool in_uses_temporary_zoom_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::MainDocumentElementAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uses_temporary_zoom_level"), in_uses_temporary_zoom_level,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kMainDocumentElementAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_MainDocumentElementAvailable_Params_Data> params(
          message);
  params.Allocate();

  params->uses_temporary_zoom_level = in_uses_temporary_zoom_level;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("MainDocumentElementAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SetNeedsOcclusionTracking(
    bool in_needs_tracking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_tracking"), in_needs_tracking,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSetNeedsOcclusionTracking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data> params(
          message);
  params.Allocate();

  params->needs_tracking = in_needs_tracking;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetNeedsOcclusionTracking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SetVirtualKeyboardMode(
    ::ui::mojom::VirtualKeyboardMode in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SetVirtualKeyboardMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::ui::mojom::VirtualKeyboardMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSetVirtualKeyboardMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetVirtualKeyboardMode_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::VirtualKeyboardMode>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetVirtualKeyboardMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::VisibilityChanged(
    ::blink::mojom::FrameVisibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::VisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility"), in_visibility,
                        "<value of type ::blink::mojom::FrameVisibility>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_VisibilityChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FrameVisibility>(
    in_visibility,
    &params->visibility);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("VisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidChangeThemeColor(
    std::optional<::SkColor> in_theme_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidChangeThemeColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme_color"), in_theme_color,
                        "<value of type std::optional<::SkColor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidChangeThemeColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeThemeColor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme_color)::BaseType> theme_color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_theme_color,
    theme_color_fragment);

  params->theme_color.Set(
      theme_color_fragment.is_null() ? nullptr : theme_color_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeThemeColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidChangeBackgroundColor(
    const ::SkColor4f& in_background_color, bool in_color_adjust) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidChangeBackgroundColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("background_color"), in_background_color,
                        "<value of type const ::SkColor4f&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_adjust"), in_color_adjust,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidChangeBackgroundColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->background_color)::BaseType> background_color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
    in_background_color,
    background_color_fragment);

  params->background_color.Set(
      background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->background_color.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null background_color in LocalFrameHost.DidChangeBackgroundColor request");

  params->color_adjust = in_color_adjust;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidFailLoadWithError(
    const ::GURL& in_url, int32_t in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidFailLoadWithError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidFailLoadWithError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidFailLoadWithError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LocalFrameHost.DidFailLoadWithError request");

  params->error_code = in_error_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFailLoadWithError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidFocusFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DidFocusFrame");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidFocusFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidFocusFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFocusFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidCallFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DidCallFocus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidCallFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidCallFocus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidCallFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::EnforceInsecureRequestPolicy(
    ::blink::mojom::InsecureRequestPolicy in_policy_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_bitmap"), in_policy_bitmap,
                        "<value of type ::blink::mojom::InsecureRequestPolicy>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kEnforceInsecureRequestPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
    in_policy_bitmap,
    &params->policy_bitmap);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnforceInsecureRequestPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::EnforceInsecureNavigationsSet(
    const std::vector<uint32_t>& in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set"), in_set,
                        "<value of type const std::vector<uint32_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kEnforceInsecureNavigationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->set)::BaseType>
      set_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& set_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
    in_set,
    set_fragment,
    &set_validate_params);

  params->set.Set(
      set_fragment.is_null() ? nullptr : set_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->set.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null set in LocalFrameHost.EnforceInsecureNavigationsSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnforceInsecureNavigationsSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SuddenTerminationDisablerChanged(
    bool in_present, ::blink::mojom::SuddenTerminationDisablerType in_disabler_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("present"), in_present,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disabler_type"), in_disabler_type,
                        "<value of type ::blink::mojom::SuddenTerminationDisablerType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSuddenTerminationDisablerChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data> params(
          message);
  params.Allocate();

  params->present = in_present;

  
  mojo::internal::Serialize<::blink::mojom::SuddenTerminationDisablerType>(
    in_disabler_type,
    &params->disabler_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SuddenTerminationDisablerChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::HadStickyUserActivationBeforeNavigationChanged(
    bool in_has_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_gesture"), in_has_gesture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kHadStickyUserActivationBeforeNavigationChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data> params(
          message);
  params.Allocate();

  params->has_gesture = in_has_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HadStickyUserActivationBeforeNavigationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::ScrollRectToVisibleInParentFrame(
    const ::gfx::RectF& in_rect_to_scroll, ::blink::mojom::ScrollIntoViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect_to_scroll"), in_rect_to_scroll,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::ScrollIntoViewParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kScrollRectToVisibleInParentFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect_to_scroll)::BaseType> rect_to_scroll_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
    in_rect_to_scroll,
    rect_to_scroll_fragment);

  params->rect_to_scroll.Set(
      rect_to_scroll_fragment.is_null() ? nullptr : rect_to_scroll_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect_to_scroll.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect_to_scroll in LocalFrameHost.ScrollRectToVisibleInParentFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ScrollIntoViewParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in LocalFrameHost.ScrollRectToVisibleInParentFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ScrollRectToVisibleInParentFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::BubbleLogicalScrollInParentFrame(
    ::blink::mojom::ScrollDirection in_direction, ::ui::ScrollGranularity in_granularity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type ::blink::mojom::ScrollDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granularity"), in_granularity,
                        "<value of type ::ui::ScrollGranularity>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kBubbleLogicalScrollInParentFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ScrollDirection>(
    in_direction,
    &params->direction);

  
  mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
    in_granularity,
    &params->granularity);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("BubbleLogicalScrollInParentFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::StartLoadingForAsyncNavigationApiCommit(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::StartLoadingForAsyncNavigationApiCommit");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kStartLoadingForAsyncNavigationApiCommit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("StartLoadingForAsyncNavigationApiCommit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidBlockNavigation(
    const ::GURL& in_blocked_url, ::blink::mojom::NavigationBlockedReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidBlockNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked_url"), in_blocked_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::blink::mojom::NavigationBlockedReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidBlockNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidBlockNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blocked_url)::BaseType> blocked_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_blocked_url,
    blocked_url_fragment);

  params->blocked_url.Set(
      blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->blocked_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null blocked_url in LocalFrameHost.DidBlockNavigation request");

  
  mojo::internal::Serialize<::blink::mojom::NavigationBlockedReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidBlockNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidChangeLoadProgress(
    double in_load_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidChangeLoadProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("load_progress"), in_load_progress,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidChangeLoadProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeLoadProgress_Params_Data> params(
          message);
  params.Allocate();

  params->load_progress = in_load_progress;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeLoadProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidFinishLoad(
    const ::GURL& in_validated_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidFinishLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("validated_url"), in_validated_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidFinishLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidFinishLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->validated_url)::BaseType> validated_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_validated_url,
    validated_url_fragment);

  params->validated_url.Set(
      validated_url_fragment.is_null() ? nullptr : validated_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->validated_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null validated_url in LocalFrameHost.DidFinishLoad request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFinishLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DispatchLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DispatchLoad");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDispatchLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DispatchLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DispatchLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::GoToEntryAtOffset(
    int32_t in_offset, bool in_has_user_gesture, ::base::TimeTicks in_actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> in_soft_navigation_heuristics_task_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::GoToEntryAtOffset", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_user_gesture"), in_has_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_navigation_start"), in_actual_navigation_start,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("soft_navigation_heuristics_task_id"), in_soft_navigation_heuristics_task_id,
                        "<value of type std::optional<::blink::scheduler::TaskAttributionId>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kGoToEntryAtOffset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_GoToEntryAtOffset_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;

  params->has_user_gesture = in_has_user_gesture;
  mojo::internal::MessageFragment<
      typename decltype(params->actual_navigation_start)::BaseType> actual_navigation_start_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_actual_navigation_start,
    actual_navigation_start_fragment);

  params->actual_navigation_start.Set(
      actual_navigation_start_fragment.is_null() ? nullptr : actual_navigation_start_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->actual_navigation_start.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null actual_navigation_start in LocalFrameHost.GoToEntryAtOffset request");
  mojo::internal::MessageFragment<
      typename decltype(params->soft_navigation_heuristics_task_id)::BaseType> soft_navigation_heuristics_task_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TaskAttributionIdDataView>(
    in_soft_navigation_heuristics_task_id,
    soft_navigation_heuristics_task_id_fragment);

  params->soft_navigation_heuristics_task_id.Set(
      soft_navigation_heuristics_task_id_fragment.is_null() ? nullptr : soft_navigation_heuristics_task_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GoToEntryAtOffset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::NavigateToNavigationApiKey(
    const std::string& in_key, bool in_has_user_gesture, ::base::TimeTicks in_actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> in_soft_navigation_heuristics_task_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::NavigateToNavigationApiKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_user_gesture"), in_has_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_navigation_start"), in_actual_navigation_start,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("soft_navigation_heuristics_task_id"), in_soft_navigation_heuristics_task_id,
                        "<value of type std::optional<::blink::scheduler::TaskAttributionId>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kNavigateToNavigationApiKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_NavigateToNavigationApiKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in LocalFrameHost.NavigateToNavigationApiKey request");

  params->has_user_gesture = in_has_user_gesture;
  mojo::internal::MessageFragment<
      typename decltype(params->actual_navigation_start)::BaseType> actual_navigation_start_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_actual_navigation_start,
    actual_navigation_start_fragment);

  params->actual_navigation_start.Set(
      actual_navigation_start_fragment.is_null() ? nullptr : actual_navigation_start_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->actual_navigation_start.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null actual_navigation_start in LocalFrameHost.NavigateToNavigationApiKey request");
  mojo::internal::MessageFragment<
      typename decltype(params->soft_navigation_heuristics_task_id)::BaseType> soft_navigation_heuristics_task_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TaskAttributionIdDataView>(
    in_soft_navigation_heuristics_task_id,
    soft_navigation_heuristics_task_id_fragment);

  params->soft_navigation_heuristics_task_id.Set(
      soft_navigation_heuristics_task_id_fragment.is_null() ? nullptr : soft_navigation_heuristics_task_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("NavigateToNavigationApiKey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::NavigateEventHandlerPresenceChanged(
    bool in_present) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::NavigateEventHandlerPresenceChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("present"), in_present,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kNavigateEventHandlerPresenceChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data> params(
          message);
  params.Allocate();

  params->present = in_present;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("NavigateEventHandlerPresenceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::UpdateTitle(
    const std::optional<::std::u16string>& in_title, ::base::i18n::TextDirection in_title_direction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::UpdateTitle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::optional<::std::u16string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title_direction"), in_title_direction,
                        "<value of type ::base::i18n::TextDirection>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kUpdateTitle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UpdateTitle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
    in_title_direction,
    &params->title_direction);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::UpdateApplicationTitle(
    const ::std::u16string& in_application_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::UpdateApplicationTitle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("application_title"), in_application_title,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kUpdateApplicationTitle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UpdateApplicationTitle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->application_title)::BaseType> application_title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_application_title,
    application_title_fragment);

  params->application_title.Set(
      application_title_fragment.is_null() ? nullptr : application_title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->application_title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null application_title in LocalFrameHost.UpdateApplicationTitle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateApplicationTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::UpdateUserActivationState(
    ::blink::mojom::UserActivationUpdateType in_update_type, ::blink::mojom::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::UpdateUserActivationState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type ::blink::mojom::UserActivationUpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_type"), in_notification_type,
                        "<value of type ::blink::mojom::UserActivationNotificationType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kUpdateUserActivationState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UpdateUserActivationState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::UserActivationUpdateType>(
    in_update_type,
    &params->update_type);

  
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
    in_notification_type,
    &params->notification_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateUserActivationState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidConsumeHistoryUserActivation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DidConsumeHistoryUserActivation");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidConsumeHistoryUserActivation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidConsumeHistoryUserActivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::HandleAccessibilityFindInPageResult(
    FindInPageResultAXParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type FindInPageResultAXParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kHandleAccessibilityFindInPageResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FindInPageResultAXParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in LocalFrameHost.HandleAccessibilityFindInPageResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HandleAccessibilityFindInPageResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::HandleAccessibilityFindInPageTermination(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kHandleAccessibilityFindInPageTermination), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HandleAccessibilityFindInPageTermination");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DocumentOnLoadCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DocumentOnLoadCompleted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDocumentOnLoadCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DocumentOnLoadCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::ForwardResourceTimingToParent(
    ::blink::mojom::ResourceTimingInfoPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::ForwardResourceTimingToParent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ::blink::mojom::ResourceTimingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kForwardResourceTimingToParent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ResourceTimingInfoDataView>(
    in_timing,
    timing_fragment);

  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timing in LocalFrameHost.ForwardResourceTimingToParent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ForwardResourceTimingToParent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidDispatchDOMContentLoadedEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DidDispatchDOMContentLoadedEvent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidDispatchDOMContentLoadedEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidDispatchDOMContentLoadedEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool LocalFrameHostProxy::RunModalAlertDialog(
    const ::std::u16string& param_alert_message, bool param_disable_third_party_subframe_suppresion) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::LocalFrameHost::RunModalAlertDialog (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), param_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), param_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "LocalFrameHost::RunModalAlertDialog");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalAlertDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    param_alert_message,
    alert_message_fragment);

  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->alert_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null alert_message in LocalFrameHost.RunModalAlertDialog request");

  params->disable_third_party_subframe_suppresion = param_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalAlertDialog_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "LocalFrameHost::RunModalAlertDialog");
#endif
  return result;
}

void LocalFrameHostProxy::RunModalAlertDialog(
    const ::std::u16string& in_alert_message, bool in_disable_third_party_subframe_suppresion, RunModalAlertDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::RunModalAlertDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), in_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), in_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalAlertDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_alert_message,
    alert_message_fragment);

  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->alert_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null alert_message in LocalFrameHost.RunModalAlertDialog request");

  params->disable_third_party_subframe_suppresion = in_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalAlertDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool LocalFrameHostProxy::RunModalConfirmDialog(
    const ::std::u16string& param_alert_message, bool param_disable_third_party_subframe_suppresion, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::LocalFrameHost::RunModalConfirmDialog (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), param_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), param_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "LocalFrameHost::RunModalConfirmDialog");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalConfirmDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    param_alert_message,
    alert_message_fragment);

  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->alert_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null alert_message in LocalFrameHost.RunModalConfirmDialog request");

  params->disable_third_party_subframe_suppresion = param_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse(
          &result, out_param_success));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "LocalFrameHost::RunModalConfirmDialog", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void LocalFrameHostProxy::RunModalConfirmDialog(
    const ::std::u16string& in_alert_message, bool in_disable_third_party_subframe_suppresion, RunModalConfirmDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::RunModalConfirmDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), in_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), in_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalConfirmDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_alert_message,
    alert_message_fragment);

  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->alert_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null alert_message in LocalFrameHost.RunModalConfirmDialog request");

  params->disable_third_party_subframe_suppresion = in_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalConfirmDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool LocalFrameHostProxy::RunModalPromptDialog(
    const ::std::u16string& param_alert_message, const ::std::u16string& param_default_value, bool param_disable_third_party_subframe_suppresion, bool* out_param_success, ::std::u16string* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::LocalFrameHost::RunModalPromptDialog (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), param_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_value"), param_default_value,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), param_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "LocalFrameHost::RunModalPromptDialog");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalPromptDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    param_alert_message,
    alert_message_fragment);

  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->alert_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null alert_message in LocalFrameHost.RunModalPromptDialog request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_value)::BaseType> default_value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    param_default_value,
    default_value_fragment);

  params->default_value.Set(
      default_value_fragment.is_null() ? nullptr : default_value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->default_value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null default_value in LocalFrameHost.RunModalPromptDialog request");

  params->disable_third_party_subframe_suppresion = param_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalPromptDialog_HandleSyncResponse(
          &result, out_param_success, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "LocalFrameHost::RunModalPromptDialog", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const ::std::u16string&>");
   });
#endif
  return result;
}

void LocalFrameHostProxy::RunModalPromptDialog(
    const ::std::u16string& in_alert_message, const ::std::u16string& in_default_value, bool in_disable_third_party_subframe_suppresion, RunModalPromptDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::RunModalPromptDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), in_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_value"), in_default_value,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), in_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalPromptDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_alert_message,
    alert_message_fragment);

  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->alert_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null alert_message in LocalFrameHost.RunModalPromptDialog request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_value)::BaseType> default_value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_default_value,
    default_value_fragment);

  params->default_value.Set(
      default_value_fragment.is_null() ? nullptr : default_value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->default_value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null default_value in LocalFrameHost.RunModalPromptDialog request");

  params->disable_third_party_subframe_suppresion = in_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalPromptDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool LocalFrameHostProxy::RunBeforeUnloadConfirm(
    bool param_is_reload, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_reload"), param_is_reload,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "LocalFrameHost::RunBeforeUnloadConfirm");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunBeforeUnloadConfirm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data> params(
          message);
  params.Allocate();

  params->is_reload = param_is_reload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse(
          &result, out_param_success));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "LocalFrameHost::RunBeforeUnloadConfirm", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void LocalFrameHostProxy::RunBeforeUnloadConfirm(
    bool in_is_reload, RunBeforeUnloadConfirmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_reload"), in_is_reload,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunBeforeUnloadConfirm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data> params(
          message);
  params.Allocate();

  params->is_reload = in_is_reload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameHostProxy::UpdateFaviconURL(
    std::vector<::blink::mojom::FaviconURLPtr> in_favicon_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::UpdateFaviconURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("favicon_urls"), in_favicon_urls,
                        "<value of type std::vector<::blink::mojom::FaviconURLPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kUpdateFaviconURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UpdateFaviconURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->favicon_urls)::BaseType>
      favicon_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& favicon_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FaviconURLDataView>>(
    in_favicon_urls,
    favicon_urls_fragment,
    &favicon_urls_validate_params);

  params->favicon_urls.Set(
      favicon_urls_fragment.is_null() ? nullptr : favicon_urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->favicon_urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null favicon_urls in LocalFrameHost.UpdateFaviconURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateFaviconURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DownloadURL(
    DownloadURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DownloadURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DownloadURLParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDownloadURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DownloadURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DownloadURLParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in LocalFrameHost.DownloadURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DownloadURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::FocusedElementChanged(
    bool in_is_editable_element, bool in_is_richly_editable_element, const ::gfx::Rect& in_bounds_in_frame_widget, ::blink::mojom::FocusType in_focus_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::FocusedElementChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_editable_element"), in_is_editable_element,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_richly_editable_element"), in_is_richly_editable_element,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds_in_frame_widget"), in_bounds_in_frame_widget,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_type"), in_focus_type,
                        "<value of type ::blink::mojom::FocusType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kFocusedElementChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_FocusedElementChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_editable_element = in_is_editable_element;

  params->is_richly_editable_element = in_is_richly_editable_element;
  mojo::internal::MessageFragment<
      typename decltype(params->bounds_in_frame_widget)::BaseType> bounds_in_frame_widget_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds_in_frame_widget,
    bounds_in_frame_widget_fragment);

  params->bounds_in_frame_widget.Set(
      bounds_in_frame_widget_fragment.is_null() ? nullptr : bounds_in_frame_widget_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds_in_frame_widget.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds_in_frame_widget in LocalFrameHost.FocusedElementChanged request");

  
  mojo::internal::Serialize<::blink::mojom::FocusType>(
    in_focus_type,
    &params->focus_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("FocusedElementChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::TextSelectionChanged(
    const ::std::u16string& in_text, uint32_t in_offset, const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::TextSelectionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kTextSelectionChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_TextSelectionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in LocalFrameHost.TextSelectionChanged request");

  params->offset = in_offset;
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in LocalFrameHost.TextSelectionChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("TextSelectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::ShowPopupMenu(
    ::mojo::PendingRemote<::blink::mojom::PopupMenuClient> in_popup_client, const ::gfx::Rect& in_bounds, double in_font_size, int32_t in_selected_item, std::vector<::blink::mojom::MenuItemPtr> in_menu_items, bool in_right_aligned, bool in_allow_multiple_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::ShowPopupMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup_client"), in_popup_client,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::PopupMenuClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_size"), in_font_size,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_item"), in_selected_item,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu_items"), in_menu_items,
                        "<value of type std::vector<::blink::mojom::MenuItemPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right_aligned"), in_right_aligned,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_multiple_selection"), in_allow_multiple_selection,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kShowPopupMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ShowPopupMenu_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PopupMenuClientInterfaceBase>>(
    in_popup_client,
    &params->popup_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->popup_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid popup_client in LocalFrameHost.ShowPopupMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in LocalFrameHost.ShowPopupMenu request");

  params->font_size = in_font_size;

  params->selected_item = in_selected_item;
  mojo::internal::MessageFragment<
      typename decltype(params->menu_items)::BaseType>
      menu_items_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& menu_items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MenuItemDataView>>(
    in_menu_items,
    menu_items_fragment,
    &menu_items_validate_params);

  params->menu_items.Set(
      menu_items_fragment.is_null() ? nullptr : menu_items_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->menu_items.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null menu_items in LocalFrameHost.ShowPopupMenu request");

  params->right_aligned = in_right_aligned;

  params->allow_multiple_selection = in_allow_multiple_selection;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ShowPopupMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::CreateNewPopupWidget(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> in_popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> in_blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> in_blink_widget) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::CreateNewPopupWidget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup_host"), in_popup_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blink_widget_host"), in_blink_widget_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blink_widget"), in_blink_widget,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::Widget>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kCreateNewPopupWidget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_CreateNewPopupWidget_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PopupWidgetHostAssociatedRequestDataView>(
    in_popup_host,
    &params->popup_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->popup_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid popup_host in LocalFrameHost.CreateNewPopupWidget request");

  
  mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
    in_blink_widget_host,
    &params->blink_widget_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blink_widget_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid blink_widget_host in LocalFrameHost.CreateNewPopupWidget request");

  
  mojo::internal::Serialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
    in_blink_widget,
    &params->blink_widget,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blink_widget)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid blink_widget in LocalFrameHost.CreateNewPopupWidget request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("CreateNewPopupWidget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::ShowContextMenu(
    ::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient> in_client, const ::blink::UntrustworthyContextMenuParams& in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::ShowContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::blink::UntrustworthyContextMenuParams&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kShowContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ShowContextMenu_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ContextMenuClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in LocalFrameHost.ShowContextMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::UntrustworthyContextMenuParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in LocalFrameHost.ShowContextMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidLoadResourceFromMemoryCache(
    const ::GURL& in_url, const std::string& in_http_method, const std::string& in_mime_type, ::network::mojom::RequestDestination in_request_destination, bool in_include_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_method"), in_http_method,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_destination"), in_request_destination,
                        "<value of type ::network::mojom::RequestDestination>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_credentials"), in_include_credentials,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidLoadResourceFromMemoryCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LocalFrameHost.DidLoadResourceFromMemoryCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->http_method)::BaseType> http_method_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_http_method,
    http_method_fragment);

  params->http_method.Set(
      http_method_fragment.is_null() ? nullptr : http_method_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->http_method.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null http_method in LocalFrameHost.DidLoadResourceFromMemoryCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_mime_type,
    mime_type_fragment);

  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mime_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mime_type in LocalFrameHost.DidLoadResourceFromMemoryCache request");

  
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
    in_request_destination,
    &params->request_destination);

  params->include_credentials = in_include_credentials;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidLoadResourceFromMemoryCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidChangeFrameOwnerProperties(
    const ::blink::FrameToken& in_child_frame_token, ::blink::mojom::FrameOwnerPropertiesPtr in_frame_owner_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_owner_properties"), in_frame_owner_properties,
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidChangeFrameOwnerProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->child_frame_token)>
      child_frame_token_fragment(params.message());
  child_frame_token_fragment.Claim(&params->child_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_child_frame_token,
    child_frame_token_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->child_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null child_frame_token in LocalFrameHost.DidChangeFrameOwnerProperties request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_owner_properties)::BaseType> frame_owner_properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
    in_frame_owner_properties,
    frame_owner_properties_fragment);

  params->frame_owner_properties.Set(
      frame_owner_properties_fragment.is_null() ? nullptr : frame_owner_properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_owner_properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_owner_properties in LocalFrameHost.DidChangeFrameOwnerProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidChangeOpener(
    const std::optional<::blink::LocalFrameToken>& in_opener_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidChangeOpener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame"), in_opener_frame,
                        "<value of type const std::optional<::blink::LocalFrameToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidChangeOpener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeOpener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->opener_frame)::BaseType> opener_frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_opener_frame,
    opener_frame_fragment);

  params->opener_frame.Set(
      opener_frame_fragment.is_null() ? nullptr : opener_frame_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidChangeFramePolicy(
    const ::blink::FrameToken& in_child_frame_token, const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidChangeFramePolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy,
                        "<value of type const ::blink::FramePolicy&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidChangeFramePolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeFramePolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->child_frame_token)>
      child_frame_token_fragment(params.message());
  child_frame_token_fragment.Claim(&params->child_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_child_frame_token,
    child_frame_token_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->child_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null child_frame_token in LocalFrameHost.DidChangeFramePolicy request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
    in_frame_policy,
    frame_policy_fragment);

  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_policy in LocalFrameHost.DidChangeFramePolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidChangeIframeAttributes(
    const ::blink::FrameToken& in_child_frame_token, IframeAttributesPtr in_attributes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidChangeIframeAttributes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attributes"), in_attributes,
                        "<value of type IframeAttributesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidChangeIframeAttributes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeIframeAttributes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->child_frame_token)>
      child_frame_token_fragment(params.message());
  child_frame_token_fragment.Claim(&params->child_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_child_frame_token,
    child_frame_token_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->child_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null child_frame_token in LocalFrameHost.DidChangeIframeAttributes request");
  mojo::internal::MessageFragment<
      typename decltype(params->attributes)::BaseType> attributes_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IframeAttributesDataView>(
    in_attributes,
    attributes_fragment);

  params->attributes.Set(
      attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attributes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attributes in LocalFrameHost.DidChangeIframeAttributes request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeIframeAttributes");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::CapturePaintPreviewOfSubframe(
    const ::gfx::Rect& in_clip_rect, const ::base::UnguessableToken& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clip_rect"), in_clip_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kCapturePaintPreviewOfSubframe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clip_rect)::BaseType> clip_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_clip_rect,
    clip_rect_fragment);

  params->clip_rect.Set(
      clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->clip_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null clip_rect in LocalFrameHost.CapturePaintPreviewOfSubframe request");
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in LocalFrameHost.CapturePaintPreviewOfSubframe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("CapturePaintPreviewOfSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SetCloseListener(
    ::mojo::PendingRemote<::blink::mojom::CloseListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SetCloseListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::CloseListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSetCloseListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetCloseListener_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::CloseListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in LocalFrameHost.SetCloseListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetCloseListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::Detach(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::Detach");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDetach), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_Detach_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("Detach");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::GetKeepAliveHandleFactory(
    ::mojo::PendingReceiver<::blink::mojom::KeepAliveHandleFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::GetKeepAliveHandleFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::KeepAliveHandleFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kGetKeepAliveHandleFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::KeepAliveHandleFactoryInterfaceBase>>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid factory in LocalFrameHost.GetKeepAliveHandleFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GetKeepAliveHandleFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidAddMessageToConsole(
    ::blink::mojom::ConsoleMessageLevel in_log_level, const ::std::u16string& in_msg, uint32_t in_line_number, const std::optional<::std::u16string>& in_source_id, const std::optional<::std::u16string>& in_untrusted_stack_trace) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidAddMessageToConsole", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_level"), in_log_level,
                        "<value of type ::blink::mojom::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("msg"), in_msg,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type const std::optional<::std::u16string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("untrusted_stack_trace"), in_untrusted_stack_trace,
                        "<value of type const std::optional<::std::u16string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidAddMessageToConsole), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidAddMessageToConsole_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
    in_log_level,
    &params->log_level);
  mojo::internal::MessageFragment<
      typename decltype(params->msg)::BaseType> msg_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_msg,
    msg_fragment);

  params->msg.Set(
      msg_fragment.is_null() ? nullptr : msg_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->msg.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null msg in LocalFrameHost.DidAddMessageToConsole request");

  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_source_id,
    source_id_fragment);

  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->untrusted_stack_trace)::BaseType> untrusted_stack_trace_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_untrusted_stack_trace,
    untrusted_stack_trace_fragment);

  params->untrusted_stack_trace.Set(
      untrusted_stack_trace_fragment.is_null() ? nullptr : untrusted_stack_trace_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidAddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::FrameSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::FrameSizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kFrameSizeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_FrameSizeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in LocalFrameHost.FrameSizeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("FrameSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidInferColorScheme(
    ::blink::mojom::PreferredColorScheme in_color_scheme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidInferColorScheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_scheme"), in_color_scheme,
                        "<value of type ::blink::mojom::PreferredColorScheme>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidInferColorScheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidInferColorScheme_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PreferredColorScheme>(
    in_color_scheme,
    &params->color_scheme);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidInferColorScheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DidChangeSrcDoc(
    const ::blink::FrameToken& in_child_frame_token, const std::string& in_srcdoc_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::DidChangeSrcDoc", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("srcdoc_value"), in_srcdoc_value,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDidChangeSrcDoc), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeSrcDoc_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->child_frame_token)>
      child_frame_token_fragment(params.message());
  child_frame_token_fragment.Claim(&params->child_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_child_frame_token,
    child_frame_token_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->child_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null child_frame_token in LocalFrameHost.DidChangeSrcDoc request");
  mojo::internal::MessageFragment<
      typename decltype(params->srcdoc_value)::BaseType> srcdoc_value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_srcdoc_value,
    srcdoc_value_fragment);

  params->srcdoc_value.Set(
      srcdoc_value_fragment.is_null() ? nullptr : srcdoc_value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->srcdoc_value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null srcdoc_value in LocalFrameHost.DidChangeSrcDoc request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeSrcDoc");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::ReceivedDelegatedCapability(
    ::blink::mojom::DelegatedCapability in_delegated_capability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::ReceivedDelegatedCapability", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delegated_capability"), in_delegated_capability,
                        "<value of type ::blink::mojom::DelegatedCapability>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kReceivedDelegatedCapability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ReceivedDelegatedCapability_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DelegatedCapability>(
    in_delegated_capability,
    &params->delegated_capability);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ReceivedDelegatedCapability");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SendFencedFrameReportingBeacon(
    const std::string& in_event_data, const std::string& in_event_type, const std::vector<::blink::FencedFrame::ReportingDestination>& in_destinations, bool in_cross_origin_exposed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SendFencedFrameReportingBeacon", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_data"), in_event_data,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_type"), in_event_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destinations"), in_destinations,
                        "<value of type const std::vector<::blink::FencedFrame::ReportingDestination>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cross_origin_exposed"), in_cross_origin_exposed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSendFencedFrameReportingBeacon), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_data)::BaseType> event_data_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_data,
    event_data_fragment);

  params->event_data.Set(
      event_data_fragment.is_null() ? nullptr : event_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_data in LocalFrameHost.SendFencedFrameReportingBeacon request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_type)::BaseType> event_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_type,
    event_type_fragment);

  params->event_type.Set(
      event_type_fragment.is_null() ? nullptr : event_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_type in LocalFrameHost.SendFencedFrameReportingBeacon request");
  mojo::internal::MessageFragment<
      typename decltype(params->destinations)::BaseType>
      destinations_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& destinations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ReportingDestination_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ReportingDestination>>(
    in_destinations,
    destinations_fragment,
    &destinations_validate_params);

  params->destinations.Set(
      destinations_fragment.is_null() ? nullptr : destinations_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destinations.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destinations in LocalFrameHost.SendFencedFrameReportingBeacon request");

  params->cross_origin_exposed = in_cross_origin_exposed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SendFencedFrameReportingBeacon");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SendFencedFrameReportingBeaconToCustomURL(
    const ::GURL& in_destination_url, bool in_cross_origin_exposed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SendFencedFrameReportingBeaconToCustomURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination_url"), in_destination_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cross_origin_exposed"), in_cross_origin_exposed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSendFencedFrameReportingBeaconToCustomURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->destination_url)::BaseType> destination_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_destination_url,
    destination_url_fragment);

  params->destination_url.Set(
      destination_url_fragment.is_null() ? nullptr : destination_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destination_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destination_url in LocalFrameHost.SendFencedFrameReportingBeaconToCustomURL request");

  params->cross_origin_exposed = in_cross_origin_exposed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SendFencedFrameReportingBeaconToCustomURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DisableUntrustedNetworkInFencedFrame(
    DisableUntrustedNetworkInFencedFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::DisableUntrustedNetworkInFencedFrame");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDisableUntrustedNetworkInFencedFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DisableUntrustedNetworkInFencedFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameHostProxy::ExemptUrlFromNetworkRevocationForTesting(
    const ::GURL& in_exempted_url, ExemptUrlFromNetworkRevocationForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::ExemptUrlFromNetworkRevocationForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exempted_url"), in_exempted_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kExemptUrlFromNetworkRevocationForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->exempted_url)::BaseType> exempted_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_exempted_url,
    exempted_url_fragment);

  params->exempted_url.Set(
      exempted_url_fragment.is_null() ? nullptr : exempted_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->exempted_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null exempted_url in LocalFrameHost.ExemptUrlFromNetworkRevocationForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ExemptUrlFromNetworkRevocationForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameHostProxy::SendLegacyTechEvent(
    const std::string& in_type, LegacyTechEventCodeLocationPtr in_code_location) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SendLegacyTechEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code_location"), in_code_location,
                        "<value of type LegacyTechEventCodeLocationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSendLegacyTechEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SendLegacyTechEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_type,
    type_fragment);

  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null type in LocalFrameHost.SendLegacyTechEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->code_location)::BaseType> code_location_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LegacyTechEventCodeLocationDataView>(
    in_code_location,
    code_location_fragment);

  params->code_location.Set(
      code_location_fragment.is_null() ? nullptr : code_location_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->code_location.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null code_location in LocalFrameHost.SendLegacyTechEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SendLegacyTechEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SetFencedFrameAutomaticBeaconReportEventData(
    ::blink::mojom::AutomaticBeaconType in_event_type, const std::string& in_event_data, const std::vector<::blink::FencedFrame::ReportingDestination>& in_destinations, bool in_once, bool in_cross_origin_exposed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SetFencedFrameAutomaticBeaconReportEventData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_type"), in_event_type,
                        "<value of type ::blink::mojom::AutomaticBeaconType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_data"), in_event_data,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destinations"), in_destinations,
                        "<value of type const std::vector<::blink::FencedFrame::ReportingDestination>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("once"), in_once,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cross_origin_exposed"), in_cross_origin_exposed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSetFencedFrameAutomaticBeaconReportEventData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AutomaticBeaconType>(
    in_event_type,
    &params->event_type);
  mojo::internal::MessageFragment<
      typename decltype(params->event_data)::BaseType> event_data_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_data,
    event_data_fragment);

  params->event_data.Set(
      event_data_fragment.is_null() ? nullptr : event_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_data in LocalFrameHost.SetFencedFrameAutomaticBeaconReportEventData request");
  mojo::internal::MessageFragment<
      typename decltype(params->destinations)::BaseType>
      destinations_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& destinations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ReportingDestination_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ReportingDestination>>(
    in_destinations,
    destinations_fragment,
    &destinations_validate_params);

  params->destinations.Set(
      destinations_fragment.is_null() ? nullptr : destinations_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destinations.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destinations in LocalFrameHost.SetFencedFrameAutomaticBeaconReportEventData request");

  params->once = in_once;

  params->cross_origin_exposed = in_cross_origin_exposed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetFencedFrameAutomaticBeaconReportEventData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SendPrivateAggregationRequestsForFencedFrameEvent(
    const std::string& in_event_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SendPrivateAggregationRequestsForFencedFrameEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_type"), in_event_type,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSendPrivateAggregationRequestsForFencedFrameEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_type)::BaseType> event_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_type,
    event_type_fragment);

  params->event_type.Set(
      event_type_fragment.is_null() ? nullptr : event_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_type in LocalFrameHost.SendPrivateAggregationRequestsForFencedFrameEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SendPrivateAggregationRequestsForFencedFrameEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::CreateFencedFrame(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::FencedFrameOwnerHost> in_fenced_frame, ::blink::mojom::RemoteFrameInterfacesFromRendererPtr in_remote_frame_interfaces, const ::blink::RemoteFrameToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::CreateFencedFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fenced_frame"), in_fenced_frame,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::FencedFrameOwnerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_frame_interfaces"), in_remote_frame_interfaces,
                        "<value of type ::blink::mojom::RemoteFrameInterfacesFromRendererPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), in_devtools_frame_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kCreateFencedFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_CreateFencedFrame_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FencedFrameOwnerHostAssociatedRequestDataView>(
    in_fenced_frame,
    &params->fenced_frame,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->fenced_frame)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid fenced_frame in LocalFrameHost.CreateFencedFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_frame_interfaces)::BaseType> remote_frame_interfaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameInterfacesFromRendererDataView>(
    in_remote_frame_interfaces,
    remote_frame_interfaces_fragment);

  params->remote_frame_interfaces.Set(
      remote_frame_interfaces_fragment.is_null() ? nullptr : remote_frame_interfaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_frame_interfaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_frame_interfaces in LocalFrameHost.CreateFencedFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_frame_token,
    frame_token_fragment);

  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_token in LocalFrameHost.CreateFencedFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_frame_token,
    devtools_frame_token_fragment);

  params->devtools_frame_token.Set(
      devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtools_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtools_frame_token in LocalFrameHost.CreateFencedFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("CreateFencedFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::ForwardFencedFrameEventAndUserActivationToEmbedder(
    const std::string& in_event_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::ForwardFencedFrameEventAndUserActivationToEmbedder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_type"), in_event_type,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kForwardFencedFrameEventAndUserActivationToEmbedder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_type)::BaseType> event_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_type,
    event_type_fragment);

  params->event_type.Set(
      event_type_fragment.is_null() ? nullptr : event_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_type in LocalFrameHost.ForwardFencedFrameEventAndUserActivationToEmbedder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ForwardFencedFrameEventAndUserActivationToEmbedder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::OnViewTransitionOptInChanged(
    ViewTransitionSameOriginOptIn in_view_transition_opt_in) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::OnViewTransitionOptInChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_transition_opt_in"), in_view_transition_opt_in,
                        "<value of type ViewTransitionSameOriginOptIn>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kOnViewTransitionOptInChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_OnViewTransitionOptInChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ViewTransitionSameOriginOptIn>(
    in_view_transition_opt_in,
    &params->view_transition_opt_in);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("OnViewTransitionOptInChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::StartDragging(
    ::blink::mojom::DragDataPtr in_drag_data, ::blink::DragOperationsMask in_operations_allowed, const ::SkBitmap& in_image, const ::gfx::Vector2d& in_cursor_offset_in_dip, const ::gfx::Rect& in_drag_obj_rect_in_dip, ::blink::mojom::DragEventSourceInfoPtr in_event_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::StartDragging", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag_data"), in_drag_data,
                        "<value of type ::blink::mojom::DragDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operations_allowed"), in_operations_allowed,
                        "<value of type ::blink::DragOperationsMask>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::SkBitmap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor_offset_in_dip"), in_cursor_offset_in_dip,
                        "<value of type const ::gfx::Vector2d&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag_obj_rect_in_dip"), in_drag_obj_rect_in_dip,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_info"), in_event_info,
                        "<value of type ::blink::mojom::DragEventSourceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kStartDragging), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_StartDragging_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drag_data)::BaseType> drag_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DragDataDataView>(
    in_drag_data,
    drag_data_fragment);

  params->drag_data.Set(
      drag_data_fragment.is_null() ? nullptr : drag_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drag_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drag_data in LocalFrameHost.StartDragging request");
  mojo::internal::MessageFragment<
      typename decltype(params->operations_allowed)::BaseType> operations_allowed_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AllowedDragOperationsDataView>(
    in_operations_allowed,
    operations_allowed_fragment);

  params->operations_allowed.Set(
      operations_allowed_fragment.is_null() ? nullptr : operations_allowed_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->operations_allowed.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null operations_allowed in LocalFrameHost.StartDragging request");
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->cursor_offset_in_dip)::BaseType> cursor_offset_in_dip_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
    in_cursor_offset_in_dip,
    cursor_offset_in_dip_fragment);

  params->cursor_offset_in_dip.Set(
      cursor_offset_in_dip_fragment.is_null() ? nullptr : cursor_offset_in_dip_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cursor_offset_in_dip.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cursor_offset_in_dip in LocalFrameHost.StartDragging request");
  mojo::internal::MessageFragment<
      typename decltype(params->drag_obj_rect_in_dip)::BaseType> drag_obj_rect_in_dip_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_drag_obj_rect_in_dip,
    drag_obj_rect_in_dip_fragment);

  params->drag_obj_rect_in_dip.Set(
      drag_obj_rect_in_dip_fragment.is_null() ? nullptr : drag_obj_rect_in_dip_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drag_obj_rect_in_dip.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drag_obj_rect_in_dip in LocalFrameHost.StartDragging request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_info)::BaseType> event_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DragEventSourceInfoDataView>(
    in_event_info,
    event_info_fragment);

  params->event_info.Set(
      event_info_fragment.is_null() ? nullptr : event_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_info in LocalFrameHost.StartDragging request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("StartDragging");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::IssueKeepAliveHandle(
    ::mojo::PendingReceiver<::blink::mojom::NavigationStateKeepAliveHandle> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::IssueKeepAliveHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::NavigationStateKeepAliveHandle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kIssueKeepAliveHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_IssueKeepAliveHandle_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NavigationStateKeepAliveHandleInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in LocalFrameHost.IssueKeepAliveHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("IssueKeepAliveHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::NotifyStorageAccessed(
    StorageTypeAccessed in_storageType, bool in_blocked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::NotifyStorageAccessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storageType"), in_storageType,
                        "<value of type StorageTypeAccessed>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked"), in_blocked,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kNotifyStorageAccessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_NotifyStorageAccessed_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::StorageTypeAccessed>(
    in_storageType,
    &params->storageType);

  params->blocked = in_blocked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("NotifyStorageAccessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::RecordWindowProxyUsageMetrics(
    const ::blink::FrameToken& in_target_frame_token, WindowProxyAccessType in_access_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::RecordWindowProxyUsageMetrics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_frame_token"), in_target_frame_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_type"), in_access_type,
                        "<value of type WindowProxyAccessType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRecordWindowProxyUsageMetrics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->target_frame_token)>
      target_frame_token_fragment(params.message());
  target_frame_token_fragment.Claim(&params->target_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_target_frame_token,
    target_frame_token_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_frame_token in LocalFrameHost.RecordWindowProxyUsageMetrics request");

  
  mojo::internal::Serialize<::blink::mojom::WindowProxyAccessType>(
    in_access_type,
    &params->access_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RecordWindowProxyUsageMetrics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::NotifyDocumentInteractive(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrameHost::NotifyDocumentInteractive");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kNotifyDocumentInteractive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_NotifyDocumentInteractive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("NotifyDocumentInteractive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::SetStorageAccessApiStatus(
    ::net::StorageAccessApiStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SetStorageAccessApiStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::net::StorageAccessApiStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSetStorageAccessApiStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetStorageAccessApiStatus_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetStorageAccessApiStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::InitializeCrashReportStorage(
    uint64_t in_length, InitializeCrashReportStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::InitializeCrashReportStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kInitializeCrashReportStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_InitializeCrashReportStorage_Params_Data> params(
          message);
  params.Allocate();

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("InitializeCrashReportStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_InitializeCrashReportStorage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool LocalFrameHostProxy::SetCrashReportStorageKey(
    const std::string& param_key, const std::string& param_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::LocalFrameHost::SetCrashReportStorageKey (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), param_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), param_value,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "LocalFrameHost::SetCrashReportStorageKey");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSetCrashReportStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetCrashReportStorageKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in LocalFrameHost.SetCrashReportStorageKey request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in LocalFrameHost.SetCrashReportStorageKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetCrashReportStorageKey");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_SetCrashReportStorageKey_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "LocalFrameHost::SetCrashReportStorageKey");
#endif
  return result;
}

void LocalFrameHostProxy::SetCrashReportStorageKey(
    const std::string& in_key, const std::string& in_value, SetCrashReportStorageKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::SetCrashReportStorageKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSetCrashReportStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetCrashReportStorageKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in LocalFrameHost.SetCrashReportStorageKey request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in LocalFrameHost.SetCrashReportStorageKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetCrashReportStorageKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_SetCrashReportStorageKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool LocalFrameHostProxy::RemoveCrashReportStorageKey(
    const std::string& param_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::LocalFrameHost::RemoveCrashReportStorageKey (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), param_key,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "LocalFrameHost::RemoveCrashReportStorageKey");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRemoveCrashReportStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RemoveCrashReportStorageKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in LocalFrameHost.RemoveCrashReportStorageKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RemoveCrashReportStorageKey");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RemoveCrashReportStorageKey_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "LocalFrameHost::RemoveCrashReportStorageKey");
#endif
  return result;
}

void LocalFrameHostProxy::RemoveCrashReportStorageKey(
    const std::string& in_key, RemoveCrashReportStorageKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrameHost::RemoveCrashReportStorageKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRemoveCrashReportStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RemoveCrashReportStorageKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in LocalFrameHost.RemoveCrashReportStorageKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RemoveCrashReportStorageKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RemoveCrashReportStorageKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LocalFrameHost_EnterFullscreen_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::EnterFullscreenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_EnterFullscreen_ProxyToResponder> proxy(
        new LocalFrameHost_EnterFullscreen_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_EnterFullscreen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_EnterFullscreen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_EnterFullscreen_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::EnterFullscreenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_granted);
};

bool LocalFrameHost_EnterFullscreen_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.0
  bool success = true;
  bool p_granted{};
  LocalFrameHost_EnterFullscreen_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_granted = input_data_view.granted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_granted));
  }
  return true;
}

void LocalFrameHost_EnterFullscreen_ProxyToResponder::Run(
    bool in_granted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrameHost::EnterFullscreen", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted"), in_granted,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kEnterFullscreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->granted = in_granted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnterFullscreen");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_RunModalAlertDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::RunModalAlertDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_RunModalAlertDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalAlertDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_RunModalAlertDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalAlertDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_RunModalAlertDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::RunModalAlertDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalFrameHost_RunModalAlertDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.39
  bool success = true;
  LocalFrameHost_RunModalAlertDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 39, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalFrameHost_RunModalAlertDialog_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalFrameHost::RunModalAlertDialog");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalAlertDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalAlertDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for LocalFrameHost.39
  bool success = true;
  LocalFrameHost_RunModalAlertDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 39, true);
    return false;
  }
  *result_ = true;
  return true;
}
class LocalFrameHost_RunModalConfirmDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::RunModalConfirmDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_RunModalConfirmDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalConfirmDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalConfirmDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_RunModalConfirmDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::RunModalConfirmDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool LocalFrameHost_RunModalConfirmDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.40
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunModalConfirmDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 40, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrameHost::RunModalConfirmDialog", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalConfirmDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for LocalFrameHost.40
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunModalConfirmDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 40, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class LocalFrameHost_RunModalPromptDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::RunModalPromptDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_RunModalPromptDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalPromptDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_RunModalPromptDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalPromptDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_RunModalPromptDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::RunModalPromptDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::std::u16string& in_result);
};

bool LocalFrameHost_RunModalPromptDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.41
  bool success = true;
  bool p_success{};
  ::std::u16string p_result{};
  LocalFrameHost_RunModalPromptDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 41, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_result));
  }
  return true;
}

void LocalFrameHost_RunModalPromptDialog_ProxyToResponder::Run(
    bool in_success, const ::std::u16string& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrameHost::RunModalPromptDialog", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunModalPromptDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalPromptDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for LocalFrameHost.41
  bool success = true;
  bool p_success{};
  ::std::u16string p_result{};
  LocalFrameHost_RunModalPromptDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 41, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::RunBeforeUnloadConfirmCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder> proxy(
        new LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::RunBeforeUnloadConfirmCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.42
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 42, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRunBeforeUnloadConfirm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for LocalFrameHost.42
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 42, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::DisableUntrustedNetworkInFencedFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ProxyToResponder> proxy(
        new LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::DisableUntrustedNetworkInFencedFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.66
  bool success = true;
  LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 66, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalFrameHost::DisableUntrustedNetworkInFencedFrame");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDisableUntrustedNetworkInFencedFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DisableUntrustedNetworkInFencedFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::ExemptUrlFromNetworkRevocationForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ProxyToResponder> proxy(
        new LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::ExemptUrlFromNetworkRevocationForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.67
  bool success = true;
  LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 67, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalFrameHost::ExemptUrlFromNetworkRevocationForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kExemptUrlFromNetworkRevocationForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ExemptUrlFromNetworkRevocationForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_InitializeCrashReportStorage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::InitializeCrashReportStorageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_InitializeCrashReportStorage_ProxyToResponder> proxy(
        new LocalFrameHost_InitializeCrashReportStorage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_InitializeCrashReportStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_InitializeCrashReportStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_InitializeCrashReportStorage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::InitializeCrashReportStorageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalFrameHost_InitializeCrashReportStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.80
  bool success = true;
  LocalFrameHost_InitializeCrashReportStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 80, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalFrameHost_InitializeCrashReportStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalFrameHost::InitializeCrashReportStorage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kInitializeCrashReportStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("InitializeCrashReportStorage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_SetCrashReportStorageKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::SetCrashReportStorageKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_SetCrashReportStorageKey_ProxyToResponder> proxy(
        new LocalFrameHost_SetCrashReportStorageKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_SetCrashReportStorageKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_SetCrashReportStorageKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_SetCrashReportStorageKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::SetCrashReportStorageKeyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalFrameHost_SetCrashReportStorageKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.81
  bool success = true;
  LocalFrameHost_SetCrashReportStorageKey_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 81, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalFrameHost_SetCrashReportStorageKey_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalFrameHost::SetCrashReportStorageKey");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kSetCrashReportStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetCrashReportStorageKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_SetCrashReportStorageKey_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for LocalFrameHost.81
  bool success = true;
  LocalFrameHost_SetCrashReportStorageKey_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 81, true);
    return false;
  }
  *result_ = true;
  return true;
}
class LocalFrameHost_RemoveCrashReportStorageKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::RemoveCrashReportStorageKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_RemoveCrashReportStorageKey_ProxyToResponder> proxy(
        new LocalFrameHost_RemoveCrashReportStorageKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_RemoveCrashReportStorageKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RemoveCrashReportStorageKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_RemoveCrashReportStorageKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::RemoveCrashReportStorageKeyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalFrameHost_RemoveCrashReportStorageKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.82
  bool success = true;
  LocalFrameHost_RemoveCrashReportStorageKey_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 82, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalFrameHost_RemoveCrashReportStorageKey_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalFrameHost::RemoveCrashReportStorageKey");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRemoveCrashReportStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RemoveCrashReportStorageKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RemoveCrashReportStorageKey_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for LocalFrameHost.82
  bool success = true;
  LocalFrameHost_RemoveCrashReportStorageKey_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 82, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool LocalFrameHostStubDispatch::Accept(
    LocalFrameHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LocalFrameHost>(message->header()->name)) {
    case messages::LocalFrameHost::kEnterFullscreen: {
      break;
    }
    case messages::LocalFrameHost::kExitFullscreen: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ExitFullscreen_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ExitFullscreen_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.1
      bool success = true;
      LocalFrameHost_ExitFullscreen_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitFullscreen(        );
      return true;
    }
    case messages::LocalFrameHost::kFullscreenStateChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_FullscreenStateChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_FullscreenStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.2
      bool success = true;
      bool p_is_fullscreen{};
      ::blink::mojom::FullscreenOptionsPtr p_options{};
      LocalFrameHost_FullscreenStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_fullscreen = input_data_view.is_fullscreen();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FullscreenStateChanged(        
        std::move(p_is_fullscreen), 
        std::move(p_options));
      return true;
    }
    case messages::LocalFrameHost::kRegisterProtocolHandler: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_RegisterProtocolHandler_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_RegisterProtocolHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.3
      bool success = true;
      std::string p_scheme{};
      ::GURL p_url{};
      bool p_user_gesture{};
      LocalFrameHost_RegisterProtocolHandler_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScheme(&p_scheme))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterProtocolHandler(        
        std::move(p_scheme), 
        std::move(p_url), 
        std::move(p_user_gesture));
      return true;
    }
    case messages::LocalFrameHost::kUnregisterProtocolHandler: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.4
      bool success = true;
      std::string p_scheme{};
      ::GURL p_url{};
      bool p_user_gesture{};
      LocalFrameHost_UnregisterProtocolHandler_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScheme(&p_scheme))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnregisterProtocolHandler(        
        std::move(p_scheme), 
        std::move(p_url), 
        std::move(p_user_gesture));
      return true;
    }
    case messages::LocalFrameHost::kDidDisplayInsecureContent: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.5
      bool success = true;
      LocalFrameHost_DidDisplayInsecureContent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDisplayInsecureContent(        );
      return true;
    }
    case messages::LocalFrameHost::kDidContainInsecureFormAction: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.6
      bool success = true;
      LocalFrameHost_DidContainInsecureFormAction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidContainInsecureFormAction(        );
      return true;
    }
    case messages::LocalFrameHost::kMainDocumentElementAvailable: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_MainDocumentElementAvailable_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_MainDocumentElementAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.7
      bool success = true;
      bool p_uses_temporary_zoom_level{};
      LocalFrameHost_MainDocumentElementAvailable_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_uses_temporary_zoom_level = input_data_view.uses_temporary_zoom_level();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MainDocumentElementAvailable(        
        std::move(p_uses_temporary_zoom_level));
      return true;
    }
    case messages::LocalFrameHost::kSetNeedsOcclusionTracking: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.8
      bool success = true;
      bool p_needs_tracking{};
      LocalFrameHost_SetNeedsOcclusionTracking_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_needs_tracking = input_data_view.needs_tracking();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsOcclusionTracking(        
        std::move(p_needs_tracking));
      return true;
    }
    case messages::LocalFrameHost::kSetVirtualKeyboardMode: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetVirtualKeyboardMode_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetVirtualKeyboardMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.9
      bool success = true;
      ::ui::mojom::VirtualKeyboardMode p_type{};
      LocalFrameHost_SetVirtualKeyboardMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVirtualKeyboardMode(        
        std::move(p_type));
      return true;
    }
    case messages::LocalFrameHost::kVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_VisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_VisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.10
      bool success = true;
      ::blink::mojom::FrameVisibility p_visibility{};
      LocalFrameHost_VisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VisibilityChanged(        
        std::move(p_visibility));
      return true;
    }
    case messages::LocalFrameHost::kDidChangeThemeColor: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeThemeColor_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeThemeColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.11
      bool success = true;
      std::optional<::SkColor> p_theme_color{};
      LocalFrameHost_DidChangeThemeColor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThemeColor(&p_theme_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeThemeColor(        
        std::move(p_theme_color));
      return true;
    }
    case messages::LocalFrameHost::kDidChangeBackgroundColor: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.12
      bool success = true;
      ::SkColor4f p_background_color{};
      bool p_color_adjust{};
      LocalFrameHost_DidChangeBackgroundColor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBackgroundColor(&p_background_color))
        success = false;
      if (success)
        p_color_adjust = input_data_view.color_adjust();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeBackgroundColor(        
        std::move(p_background_color), 
        std::move(p_color_adjust));
      return true;
    }
    case messages::LocalFrameHost::kDidFailLoadWithError: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFailLoadWithError_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFailLoadWithError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.13
      bool success = true;
      ::GURL p_url{};
      int32_t p_error_code{};
      LocalFrameHost_DidFailLoadWithError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_error_code = input_data_view.error_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFailLoadWithError(        
        std::move(p_url), 
        std::move(p_error_code));
      return true;
    }
    case messages::LocalFrameHost::kDidFocusFrame: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFocusFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFocusFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.14
      bool success = true;
      LocalFrameHost_DidFocusFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFocusFrame(        );
      return true;
    }
    case messages::LocalFrameHost::kDidCallFocus: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidCallFocus_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidCallFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.15
      bool success = true;
      LocalFrameHost_DidCallFocus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCallFocus(        );
      return true;
    }
    case messages::LocalFrameHost::kEnforceInsecureRequestPolicy: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.16
      bool success = true;
      ::blink::mojom::InsecureRequestPolicy p_policy_bitmap{};
      LocalFrameHost_EnforceInsecureRequestPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyBitmap(&p_policy_bitmap))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureRequestPolicy(        
        std::move(p_policy_bitmap));
      return true;
    }
    case messages::LocalFrameHost::kEnforceInsecureNavigationsSet: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.17
      bool success = true;
      std::vector<uint32_t> p_set{};
      LocalFrameHost_EnforceInsecureNavigationsSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSet(&p_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureNavigationsSet(        
        std::move(p_set));
      return true;
    }
    case messages::LocalFrameHost::kSuddenTerminationDisablerChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.18
      bool success = true;
      bool p_present{};
      ::blink::mojom::SuddenTerminationDisablerType p_disabler_type{};
      LocalFrameHost_SuddenTerminationDisablerChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_present = input_data_view.present();
      if (success && !input_data_view.ReadDisablerType(&p_disabler_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuddenTerminationDisablerChanged(        
        std::move(p_present), 
        std::move(p_disabler_type));
      return true;
    }
    case messages::LocalFrameHost::kHadStickyUserActivationBeforeNavigationChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.19
      bool success = true;
      bool p_has_gesture{};
      LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_gesture = input_data_view.has_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HadStickyUserActivationBeforeNavigationChanged(        
        std::move(p_has_gesture));
      return true;
    }
    case messages::LocalFrameHost::kScrollRectToVisibleInParentFrame: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.20
      bool success = true;
      ::gfx::RectF p_rect_to_scroll{};
      ::blink::mojom::ScrollIntoViewParamsPtr p_params{};
      LocalFrameHost_ScrollRectToVisibleInParentFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRectToScroll(&p_rect_to_scroll))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollRectToVisibleInParentFrame(        
        std::move(p_rect_to_scroll), 
        std::move(p_params));
      return true;
    }
    case messages::LocalFrameHost::kBubbleLogicalScrollInParentFrame: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.21
      bool success = true;
      ::blink::mojom::ScrollDirection p_direction{};
      ::ui::ScrollGranularity p_granularity{};
      LocalFrameHost_BubbleLogicalScrollInParentFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BubbleLogicalScrollInParentFrame(        
        std::move(p_direction), 
        std::move(p_granularity));
      return true;
    }
    case messages::LocalFrameHost::kStartLoadingForAsyncNavigationApiCommit: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.22
      bool success = true;
      LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartLoadingForAsyncNavigationApiCommit(        );
      return true;
    }
    case messages::LocalFrameHost::kDidBlockNavigation: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidBlockNavigation_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidBlockNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.23
      bool success = true;
      ::GURL p_blocked_url{};
      ::blink::mojom::NavigationBlockedReason p_reason{};
      LocalFrameHost_DidBlockNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidBlockNavigation(        
        std::move(p_blocked_url), 
        std::move(p_reason));
      return true;
    }
    case messages::LocalFrameHost::kDidChangeLoadProgress: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeLoadProgress_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeLoadProgress_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.24
      bool success = true;
      double p_load_progress{};
      LocalFrameHost_DidChangeLoadProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_load_progress = input_data_view.load_progress();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeLoadProgress(        
        std::move(p_load_progress));
      return true;
    }
    case messages::LocalFrameHost::kDidFinishLoad: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFinishLoad_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFinishLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.25
      bool success = true;
      ::GURL p_validated_url{};
      LocalFrameHost_DidFinishLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValidatedUrl(&p_validated_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFinishLoad(        
        std::move(p_validated_url));
      return true;
    }
    case messages::LocalFrameHost::kDispatchLoad: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DispatchLoad_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DispatchLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.26
      bool success = true;
      LocalFrameHost_DispatchLoad_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchLoad(        );
      return true;
    }
    case messages::LocalFrameHost::kGoToEntryAtOffset: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_GoToEntryAtOffset_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_GoToEntryAtOffset_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.27
      bool success = true;
      int32_t p_offset{};
      bool p_has_user_gesture{};
      ::base::TimeTicks p_actual_navigation_start{};
      std::optional<::blink::scheduler::TaskAttributionId> p_soft_navigation_heuristics_task_id{};
      LocalFrameHost_GoToEntryAtOffset_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (success && !input_data_view.ReadActualNavigationStart(&p_actual_navigation_start))
        success = false;
      if (success && !input_data_view.ReadSoftNavigationHeuristicsTaskId(&p_soft_navigation_heuristics_task_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoToEntryAtOffset(        
        std::move(p_offset), 
        std::move(p_has_user_gesture), 
        std::move(p_actual_navigation_start), 
        std::move(p_soft_navigation_heuristics_task_id));
      return true;
    }
    case messages::LocalFrameHost::kNavigateToNavigationApiKey: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_NavigateToNavigationApiKey_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_NavigateToNavigationApiKey_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.28
      bool success = true;
      std::string p_key{};
      bool p_has_user_gesture{};
      ::base::TimeTicks p_actual_navigation_start{};
      std::optional<::blink::scheduler::TaskAttributionId> p_soft_navigation_heuristics_task_id{};
      LocalFrameHost_NavigateToNavigationApiKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (success && !input_data_view.ReadActualNavigationStart(&p_actual_navigation_start))
        success = false;
      if (success && !input_data_view.ReadSoftNavigationHeuristicsTaskId(&p_soft_navigation_heuristics_task_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NavigateToNavigationApiKey(        
        std::move(p_key), 
        std::move(p_has_user_gesture), 
        std::move(p_actual_navigation_start), 
        std::move(p_soft_navigation_heuristics_task_id));
      return true;
    }
    case messages::LocalFrameHost::kNavigateEventHandlerPresenceChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.29
      bool success = true;
      bool p_present{};
      LocalFrameHost_NavigateEventHandlerPresenceChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_present = input_data_view.present();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NavigateEventHandlerPresenceChanged(        
        std::move(p_present));
      return true;
    }
    case messages::LocalFrameHost::kUpdateTitle: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateTitle_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateTitle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.30
      bool success = true;
      std::optional<::std::u16string> p_title{};
      ::base::i18n::TextDirection p_title_direction{};
      LocalFrameHost_UpdateTitle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadTitleDirection(&p_title_direction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTitle(        
        std::move(p_title), 
        std::move(p_title_direction));
      return true;
    }
    case messages::LocalFrameHost::kUpdateApplicationTitle: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateApplicationTitle_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateApplicationTitle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.31
      bool success = true;
      ::std::u16string p_application_title{};
      LocalFrameHost_UpdateApplicationTitle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadApplicationTitle(&p_application_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateApplicationTitle(        
        std::move(p_application_title));
      return true;
    }
    case messages::LocalFrameHost::kUpdateUserActivationState: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateUserActivationState_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateUserActivationState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.32
      bool success = true;
      ::blink::mojom::UserActivationUpdateType p_update_type{};
      ::blink::mojom::UserActivationNotificationType p_notification_type{};
      LocalFrameHost_UpdateUserActivationState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserActivationState(        
        std::move(p_update_type), 
        std::move(p_notification_type));
      return true;
    }
    case messages::LocalFrameHost::kDidConsumeHistoryUserActivation: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.33
      bool success = true;
      LocalFrameHost_DidConsumeHistoryUserActivation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidConsumeHistoryUserActivation(        );
      return true;
    }
    case messages::LocalFrameHost::kHandleAccessibilityFindInPageResult: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.34
      bool success = true;
      FindInPageResultAXParamsPtr p_params{};
      LocalFrameHost_HandleAccessibilityFindInPageResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAccessibilityFindInPageResult(        
        std::move(p_params));
      return true;
    }
    case messages::LocalFrameHost::kHandleAccessibilityFindInPageTermination: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.35
      bool success = true;
      LocalFrameHost_HandleAccessibilityFindInPageTermination_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAccessibilityFindInPageTermination(        );
      return true;
    }
    case messages::LocalFrameHost::kDocumentOnLoadCompleted: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.36
      bool success = true;
      LocalFrameHost_DocumentOnLoadCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DocumentOnLoadCompleted(        );
      return true;
    }
    case messages::LocalFrameHost::kForwardResourceTimingToParent: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.37
      bool success = true;
      ::blink::mojom::ResourceTimingInfoPtr p_timing{};
      LocalFrameHost_ForwardResourceTimingToParent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 37, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardResourceTimingToParent(        
        std::move(p_timing));
      return true;
    }
    case messages::LocalFrameHost::kDidDispatchDOMContentLoadedEvent: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.38
      bool success = true;
      LocalFrameHost_DidDispatchDOMContentLoadedEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDispatchDOMContentLoadedEvent(        );
      return true;
    }
    case messages::LocalFrameHost::kRunModalAlertDialog: {
      break;
    }
    case messages::LocalFrameHost::kRunModalConfirmDialog: {
      break;
    }
    case messages::LocalFrameHost::kRunModalPromptDialog: {
      break;
    }
    case messages::LocalFrameHost::kRunBeforeUnloadConfirm: {
      break;
    }
    case messages::LocalFrameHost::kUpdateFaviconURL: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateFaviconURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateFaviconURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.43
      bool success = true;
      std::vector<::blink::mojom::FaviconURLPtr> p_favicon_urls{};
      LocalFrameHost_UpdateFaviconURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFaviconUrls(&p_favicon_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 43, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateFaviconURL(        
        std::move(p_favicon_urls));
      return true;
    }
    case messages::LocalFrameHost::kDownloadURL: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DownloadURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DownloadURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.44
      bool success = true;
      DownloadURLParamsPtr p_params{};
      LocalFrameHost_DownloadURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 44, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadURL(        
        std::move(p_params));
      return true;
    }
    case messages::LocalFrameHost::kFocusedElementChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_FocusedElementChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_FocusedElementChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.45
      bool success = true;
      bool p_is_editable_element{};
      bool p_is_richly_editable_element{};
      ::gfx::Rect p_bounds_in_frame_widget{};
      ::blink::mojom::FocusType p_focus_type{};
      LocalFrameHost_FocusedElementChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_editable_element = input_data_view.is_editable_element();
      if (success)
        p_is_richly_editable_element = input_data_view.is_richly_editable_element();
      if (success && !input_data_view.ReadBoundsInFrameWidget(&p_bounds_in_frame_widget))
        success = false;
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 45, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusedElementChanged(        
        std::move(p_is_editable_element), 
        std::move(p_is_richly_editable_element), 
        std::move(p_bounds_in_frame_widget), 
        std::move(p_focus_type));
      return true;
    }
    case messages::LocalFrameHost::kTextSelectionChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_TextSelectionChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_TextSelectionChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.46
      bool success = true;
      ::std::u16string p_text{};
      uint32_t p_offset{};
      ::gfx::Range p_range{};
      LocalFrameHost_TextSelectionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 46, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextSelectionChanged(        
        std::move(p_text), 
        std::move(p_offset), 
        std::move(p_range));
      return true;
    }
    case messages::LocalFrameHost::kShowPopupMenu: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ShowPopupMenu_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ShowPopupMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.47
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::PopupMenuClient> p_popup_client{};
      ::gfx::Rect p_bounds{};
      double p_font_size{};
      int32_t p_selected_item{};
      std::vector<::blink::mojom::MenuItemPtr> p_menu_items{};
      bool p_right_aligned{};
      bool p_allow_multiple_selection{};
      LocalFrameHost_ShowPopupMenu_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_popup_client =
            input_data_view.TakePopupClient<decltype(p_popup_client)>();
      }
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (success)
        p_font_size = input_data_view.font_size();
      if (success)
        p_selected_item = input_data_view.selected_item();
      if (success && !input_data_view.ReadMenuItems(&p_menu_items))
        success = false;
      if (success)
        p_right_aligned = input_data_view.right_aligned();
      if (success)
        p_allow_multiple_selection = input_data_view.allow_multiple_selection();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 47, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowPopupMenu(        
        std::move(p_popup_client), 
        std::move(p_bounds), 
        std::move(p_font_size), 
        std::move(p_selected_item), 
        std::move(p_menu_items), 
        std::move(p_right_aligned), 
        std::move(p_allow_multiple_selection));
      return true;
    }
    case messages::LocalFrameHost::kCreateNewPopupWidget: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_CreateNewPopupWidget_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_CreateNewPopupWidget_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.48
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> p_popup_host{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> p_blink_widget_host{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> p_blink_widget{};
      LocalFrameHost_CreateNewPopupWidget_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_popup_host =
            input_data_view.TakePopupHost<decltype(p_popup_host)>();
      }
      if (success) {
        p_blink_widget_host =
            input_data_view.TakeBlinkWidgetHost<decltype(p_blink_widget_host)>();
      }
      if (success) {
        p_blink_widget =
            input_data_view.TakeBlinkWidget<decltype(p_blink_widget)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 48, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewPopupWidget(        
        std::move(p_popup_host), 
        std::move(p_blink_widget_host), 
        std::move(p_blink_widget));
      return true;
    }
    case messages::LocalFrameHost::kShowContextMenu: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.49
      bool success = true;
      ::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient> p_client{};
      ::blink::UntrustworthyContextMenuParams p_params{};
      LocalFrameHost_ShowContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 49, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(        
        std::move(p_client), 
        std::move(p_params));
      return true;
    }
    case messages::LocalFrameHost::kDidLoadResourceFromMemoryCache: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.50
      bool success = true;
      ::GURL p_url{};
      std::string p_http_method{};
      std::string p_mime_type{};
      ::network::mojom::RequestDestination p_request_destination{};
      bool p_include_credentials{};
      LocalFrameHost_DidLoadResourceFromMemoryCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHttpMethod(&p_http_method))
        success = false;
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (success && !input_data_view.ReadRequestDestination(&p_request_destination))
        success = false;
      if (success)
        p_include_credentials = input_data_view.include_credentials();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 50, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidLoadResourceFromMemoryCache(        
        std::move(p_url), 
        std::move(p_http_method), 
        std::move(p_mime_type), 
        std::move(p_request_destination), 
        std::move(p_include_credentials));
      return true;
    }
    case messages::LocalFrameHost::kDidChangeFrameOwnerProperties: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.51
      bool success = true;
      ::blink::FrameToken p_child_frame_token{};
      ::blink::mojom::FrameOwnerPropertiesPtr p_frame_owner_properties{};
      LocalFrameHost_DidChangeFrameOwnerProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadFrameOwnerProperties(&p_frame_owner_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 51, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeFrameOwnerProperties(        
        std::move(p_child_frame_token), 
        std::move(p_frame_owner_properties));
      return true;
    }
    case messages::LocalFrameHost::kDidChangeOpener: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeOpener_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeOpener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.52
      bool success = true;
      std::optional<::blink::LocalFrameToken> p_opener_frame{};
      LocalFrameHost_DidChangeOpener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrame(&p_opener_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 52, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeOpener(        
        std::move(p_opener_frame));
      return true;
    }
    case messages::LocalFrameHost::kDidChangeFramePolicy: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeFramePolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeFramePolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.53
      bool success = true;
      ::blink::FrameToken p_child_frame_token{};
      ::blink::FramePolicy p_frame_policy{};
      LocalFrameHost_DidChangeFramePolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 53, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeFramePolicy(        
        std::move(p_child_frame_token), 
        std::move(p_frame_policy));
      return true;
    }
    case messages::LocalFrameHost::kDidChangeIframeAttributes: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeIframeAttributes_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeIframeAttributes_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.54
      bool success = true;
      ::blink::FrameToken p_child_frame_token{};
      IframeAttributesPtr p_attributes{};
      LocalFrameHost_DidChangeIframeAttributes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadAttributes(&p_attributes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 54, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeIframeAttributes(        
        std::move(p_child_frame_token), 
        std::move(p_attributes));
      return true;
    }
    case messages::LocalFrameHost::kCapturePaintPreviewOfSubframe: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.55
      bool success = true;
      ::gfx::Rect p_clip_rect{};
      ::base::UnguessableToken p_guid{};
      LocalFrameHost_CapturePaintPreviewOfSubframe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClipRect(&p_clip_rect))
        success = false;
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 55, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreviewOfSubframe(        
        std::move(p_clip_rect), 
        std::move(p_guid));
      return true;
    }
    case messages::LocalFrameHost::kSetCloseListener: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetCloseListener_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetCloseListener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.56
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::CloseListener> p_listener{};
      LocalFrameHost_SetCloseListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 56, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCloseListener(        
        std::move(p_listener));
      return true;
    }
    case messages::LocalFrameHost::kDetach: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_Detach_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_Detach_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.57
      bool success = true;
      LocalFrameHost_Detach_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 57, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detach(        );
      return true;
    }
    case messages::LocalFrameHost::kGetKeepAliveHandleFactory: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.58
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::KeepAliveHandleFactory> p_factory{};
      LocalFrameHost_GetKeepAliveHandleFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 58, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetKeepAliveHandleFactory(        
        std::move(p_factory));
      return true;
    }
    case messages::LocalFrameHost::kDidAddMessageToConsole: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidAddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidAddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.59
      bool success = true;
      ::blink::mojom::ConsoleMessageLevel p_log_level{};
      ::std::u16string p_msg{};
      uint32_t p_line_number{};
      std::optional<::std::u16string> p_source_id{};
      std::optional<::std::u16string> p_untrusted_stack_trace{};
      LocalFrameHost_DidAddMessageToConsole_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLogLevel(&p_log_level))
        success = false;
      if (success && !input_data_view.ReadMsg(&p_msg))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (success && !input_data_view.ReadUntrustedStackTrace(&p_untrusted_stack_trace))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 59, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAddMessageToConsole(        
        std::move(p_log_level), 
        std::move(p_msg), 
        std::move(p_line_number), 
        std::move(p_source_id), 
        std::move(p_untrusted_stack_trace));
      return true;
    }
    case messages::LocalFrameHost::kFrameSizeChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_FrameSizeChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_FrameSizeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.60
      bool success = true;
      ::gfx::Size p_size{};
      LocalFrameHost_FrameSizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 60, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameSizeChanged(        
        std::move(p_size));
      return true;
    }
    case messages::LocalFrameHost::kDidInferColorScheme: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidInferColorScheme_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidInferColorScheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.61
      bool success = true;
      ::blink::mojom::PreferredColorScheme p_color_scheme{};
      LocalFrameHost_DidInferColorScheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColorScheme(&p_color_scheme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 61, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidInferColorScheme(        
        std::move(p_color_scheme));
      return true;
    }
    case messages::LocalFrameHost::kDidChangeSrcDoc: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeSrcDoc_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeSrcDoc_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.62
      bool success = true;
      ::blink::FrameToken p_child_frame_token{};
      std::string p_srcdoc_value{};
      LocalFrameHost_DidChangeSrcDoc_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadSrcdocValue(&p_srcdoc_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 62, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeSrcDoc(        
        std::move(p_child_frame_token), 
        std::move(p_srcdoc_value));
      return true;
    }
    case messages::LocalFrameHost::kReceivedDelegatedCapability: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ReceivedDelegatedCapability_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ReceivedDelegatedCapability_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.63
      bool success = true;
      ::blink::mojom::DelegatedCapability p_delegated_capability{};
      LocalFrameHost_ReceivedDelegatedCapability_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDelegatedCapability(&p_delegated_capability))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 63, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceivedDelegatedCapability(        
        std::move(p_delegated_capability));
      return true;
    }
    case messages::LocalFrameHost::kSendFencedFrameReportingBeacon: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.64
      bool success = true;
      std::string p_event_data{};
      std::string p_event_type{};
      std::vector<::blink::FencedFrame::ReportingDestination> p_destinations{};
      bool p_cross_origin_exposed{};
      LocalFrameHost_SendFencedFrameReportingBeacon_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventData(&p_event_data))
        success = false;
      if (success && !input_data_view.ReadEventType(&p_event_type))
        success = false;
      if (success && !input_data_view.ReadDestinations(&p_destinations))
        success = false;
      if (success)
        p_cross_origin_exposed = input_data_view.cross_origin_exposed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 64, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendFencedFrameReportingBeacon(        
        std::move(p_event_data), 
        std::move(p_event_type), 
        std::move(p_destinations), 
        std::move(p_cross_origin_exposed));
      return true;
    }
    case messages::LocalFrameHost::kSendFencedFrameReportingBeaconToCustomURL: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.65
      bool success = true;
      ::GURL p_destination_url{};
      bool p_cross_origin_exposed{};
      LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDestinationUrl(&p_destination_url))
        success = false;
      if (success)
        p_cross_origin_exposed = input_data_view.cross_origin_exposed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 65, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendFencedFrameReportingBeaconToCustomURL(        
        std::move(p_destination_url), 
        std::move(p_cross_origin_exposed));
      return true;
    }
    case messages::LocalFrameHost::kDisableUntrustedNetworkInFencedFrame: {
      break;
    }
    case messages::LocalFrameHost::kExemptUrlFromNetworkRevocationForTesting: {
      break;
    }
    case messages::LocalFrameHost::kSendLegacyTechEvent: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SendLegacyTechEvent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SendLegacyTechEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.68
      bool success = true;
      std::string p_type{};
      LegacyTechEventCodeLocationPtr p_code_location{};
      LocalFrameHost_SendLegacyTechEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadCodeLocation(&p_code_location))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 68, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendLegacyTechEvent(        
        std::move(p_type), 
        std::move(p_code_location));
      return true;
    }
    case messages::LocalFrameHost::kSetFencedFrameAutomaticBeaconReportEventData: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.69
      bool success = true;
      ::blink::mojom::AutomaticBeaconType p_event_type{};
      std::string p_event_data{};
      std::vector<::blink::FencedFrame::ReportingDestination> p_destinations{};
      bool p_once{};
      bool p_cross_origin_exposed{};
      LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventType(&p_event_type))
        success = false;
      if (success && !input_data_view.ReadEventData(&p_event_data))
        success = false;
      if (success && !input_data_view.ReadDestinations(&p_destinations))
        success = false;
      if (success)
        p_once = input_data_view.once();
      if (success)
        p_cross_origin_exposed = input_data_view.cross_origin_exposed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 69, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFencedFrameAutomaticBeaconReportEventData(        
        std::move(p_event_type), 
        std::move(p_event_data), 
        std::move(p_destinations), 
        std::move(p_once), 
        std::move(p_cross_origin_exposed));
      return true;
    }
    case messages::LocalFrameHost::kSendPrivateAggregationRequestsForFencedFrameEvent: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.70
      bool success = true;
      std::string p_event_type{};
      LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventType(&p_event_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 70, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendPrivateAggregationRequestsForFencedFrameEvent(        
        std::move(p_event_type));
      return true;
    }
    case messages::LocalFrameHost::kCreateFencedFrame: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_CreateFencedFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_CreateFencedFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.71
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::FencedFrameOwnerHost> p_fenced_frame{};
      ::blink::mojom::RemoteFrameInterfacesFromRendererPtr p_remote_frame_interfaces{};
      ::blink::RemoteFrameToken p_frame_token{};
      ::base::UnguessableToken p_devtools_frame_token{};
      LocalFrameHost_CreateFencedFrame_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_fenced_frame =
            input_data_view.TakeFencedFrame<decltype(p_fenced_frame)>();
      }
      if (success && !input_data_view.ReadRemoteFrameInterfaces(&p_remote_frame_interfaces))
        success = false;
      if (success && !input_data_view.ReadFrameToken(&p_frame_token))
        success = false;
      if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 71, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFencedFrame(        
        std::move(p_fenced_frame), 
        std::move(p_remote_frame_interfaces), 
        std::move(p_frame_token), 
        std::move(p_devtools_frame_token));
      return true;
    }
    case messages::LocalFrameHost::kForwardFencedFrameEventAndUserActivationToEmbedder: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.72
      bool success = true;
      std::string p_event_type{};
      LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventType(&p_event_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 72, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardFencedFrameEventAndUserActivationToEmbedder(        
        std::move(p_event_type));
      return true;
    }
    case messages::LocalFrameHost::kOnViewTransitionOptInChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_OnViewTransitionOptInChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_OnViewTransitionOptInChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.73
      bool success = true;
      ViewTransitionSameOriginOptIn p_view_transition_opt_in{};
      LocalFrameHost_OnViewTransitionOptInChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadViewTransitionOptIn(&p_view_transition_opt_in))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 73, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnViewTransitionOptInChanged(        
        std::move(p_view_transition_opt_in));
      return true;
    }
    case messages::LocalFrameHost::kStartDragging: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_StartDragging_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_StartDragging_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.74
      bool success = true;
      ::blink::mojom::DragDataPtr p_drag_data{};
      ::blink::DragOperationsMask p_operations_allowed{};
      ::SkBitmap p_image{};
      ::gfx::Vector2d p_cursor_offset_in_dip{};
      ::gfx::Rect p_drag_obj_rect_in_dip{};
      ::blink::mojom::DragEventSourceInfoPtr p_event_info{};
      LocalFrameHost_StartDragging_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDragData(&p_drag_data))
        success = false;
      if (success && !input_data_view.ReadOperationsAllowed(&p_operations_allowed))
        success = false;
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success && !input_data_view.ReadCursorOffsetInDip(&p_cursor_offset_in_dip))
        success = false;
      if (success && !input_data_view.ReadDragObjRectInDip(&p_drag_obj_rect_in_dip))
        success = false;
      if (success && !input_data_view.ReadEventInfo(&p_event_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 74, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDragging(        
        std::move(p_drag_data), 
        std::move(p_operations_allowed), 
        std::move(p_image), 
        std::move(p_cursor_offset_in_dip), 
        std::move(p_drag_obj_rect_in_dip), 
        std::move(p_event_info));
      return true;
    }
    case messages::LocalFrameHost::kIssueKeepAliveHandle: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_IssueKeepAliveHandle_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_IssueKeepAliveHandle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.75
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::NavigationStateKeepAliveHandle> p_receiver{};
      LocalFrameHost_IssueKeepAliveHandle_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 75, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueKeepAliveHandle(        
        std::move(p_receiver));
      return true;
    }
    case messages::LocalFrameHost::kNotifyStorageAccessed: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_NotifyStorageAccessed_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_NotifyStorageAccessed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.76
      bool success = true;
      StorageTypeAccessed p_storageType{};
      bool p_blocked{};
      LocalFrameHost_NotifyStorageAccessed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageType(&p_storageType))
        success = false;
      if (success)
        p_blocked = input_data_view.blocked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 76, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyStorageAccessed(        
        std::move(p_storageType), 
        std::move(p_blocked));
      return true;
    }
    case messages::LocalFrameHost::kRecordWindowProxyUsageMetrics: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.77
      bool success = true;
      ::blink::FrameToken p_target_frame_token{};
      WindowProxyAccessType p_access_type{};
      LocalFrameHost_RecordWindowProxyUsageMetrics_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTargetFrameToken(&p_target_frame_token))
        success = false;
      if (success && !input_data_view.ReadAccessType(&p_access_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 77, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordWindowProxyUsageMetrics(        
        std::move(p_target_frame_token), 
        std::move(p_access_type));
      return true;
    }
    case messages::LocalFrameHost::kNotifyDocumentInteractive: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_NotifyDocumentInteractive_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_NotifyDocumentInteractive_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.78
      bool success = true;
      LocalFrameHost_NotifyDocumentInteractive_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 78, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyDocumentInteractive(        );
      return true;
    }
    case messages::LocalFrameHost::kSetStorageAccessApiStatus: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetStorageAccessApiStatus_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetStorageAccessApiStatus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.79
      bool success = true;
      ::net::StorageAccessApiStatus p_status{};
      LocalFrameHost_SetStorageAccessApiStatus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 79, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetStorageAccessApiStatus(        
        std::move(p_status));
      return true;
    }
    case messages::LocalFrameHost::kInitializeCrashReportStorage: {
      break;
    }
    case messages::LocalFrameHost::kSetCrashReportStorageKey: {
      break;
    }
    case messages::LocalFrameHost::kRemoveCrashReportStorageKey: {
      break;
    }
  }
  return false;
}

// static
bool LocalFrameHostStubDispatch::AcceptWithResponder(
    LocalFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LocalFrameHost>(message->header()->name)) {
    case messages::LocalFrameHost::kEnterFullscreen: {
      internal::LocalFrameHost_EnterFullscreen_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_EnterFullscreen_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.0
      bool success = true;
      ::blink::mojom::FullscreenOptionsPtr p_options{};
      LocalFrameHost_EnterFullscreen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 0, false);
        return false;
      }
      auto callback =
          LocalFrameHost_EnterFullscreen_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterFullscreen(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kExitFullscreen: {
      break;
    }
    case messages::LocalFrameHost::kFullscreenStateChanged: {
      break;
    }
    case messages::LocalFrameHost::kRegisterProtocolHandler: {
      break;
    }
    case messages::LocalFrameHost::kUnregisterProtocolHandler: {
      break;
    }
    case messages::LocalFrameHost::kDidDisplayInsecureContent: {
      break;
    }
    case messages::LocalFrameHost::kDidContainInsecureFormAction: {
      break;
    }
    case messages::LocalFrameHost::kMainDocumentElementAvailable: {
      break;
    }
    case messages::LocalFrameHost::kSetNeedsOcclusionTracking: {
      break;
    }
    case messages::LocalFrameHost::kSetVirtualKeyboardMode: {
      break;
    }
    case messages::LocalFrameHost::kVisibilityChanged: {
      break;
    }
    case messages::LocalFrameHost::kDidChangeThemeColor: {
      break;
    }
    case messages::LocalFrameHost::kDidChangeBackgroundColor: {
      break;
    }
    case messages::LocalFrameHost::kDidFailLoadWithError: {
      break;
    }
    case messages::LocalFrameHost::kDidFocusFrame: {
      break;
    }
    case messages::LocalFrameHost::kDidCallFocus: {
      break;
    }
    case messages::LocalFrameHost::kEnforceInsecureRequestPolicy: {
      break;
    }
    case messages::LocalFrameHost::kEnforceInsecureNavigationsSet: {
      break;
    }
    case messages::LocalFrameHost::kSuddenTerminationDisablerChanged: {
      break;
    }
    case messages::LocalFrameHost::kHadStickyUserActivationBeforeNavigationChanged: {
      break;
    }
    case messages::LocalFrameHost::kScrollRectToVisibleInParentFrame: {
      break;
    }
    case messages::LocalFrameHost::kBubbleLogicalScrollInParentFrame: {
      break;
    }
    case messages::LocalFrameHost::kStartLoadingForAsyncNavigationApiCommit: {
      break;
    }
    case messages::LocalFrameHost::kDidBlockNavigation: {
      break;
    }
    case messages::LocalFrameHost::kDidChangeLoadProgress: {
      break;
    }
    case messages::LocalFrameHost::kDidFinishLoad: {
      break;
    }
    case messages::LocalFrameHost::kDispatchLoad: {
      break;
    }
    case messages::LocalFrameHost::kGoToEntryAtOffset: {
      break;
    }
    case messages::LocalFrameHost::kNavigateToNavigationApiKey: {
      break;
    }
    case messages::LocalFrameHost::kNavigateEventHandlerPresenceChanged: {
      break;
    }
    case messages::LocalFrameHost::kUpdateTitle: {
      break;
    }
    case messages::LocalFrameHost::kUpdateApplicationTitle: {
      break;
    }
    case messages::LocalFrameHost::kUpdateUserActivationState: {
      break;
    }
    case messages::LocalFrameHost::kDidConsumeHistoryUserActivation: {
      break;
    }
    case messages::LocalFrameHost::kHandleAccessibilityFindInPageResult: {
      break;
    }
    case messages::LocalFrameHost::kHandleAccessibilityFindInPageTermination: {
      break;
    }
    case messages::LocalFrameHost::kDocumentOnLoadCompleted: {
      break;
    }
    case messages::LocalFrameHost::kForwardResourceTimingToParent: {
      break;
    }
    case messages::LocalFrameHost::kDidDispatchDOMContentLoadedEvent: {
      break;
    }
    case messages::LocalFrameHost::kRunModalAlertDialog: {
      internal::LocalFrameHost_RunModalAlertDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalAlertDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.39
      bool success = true;
      ::std::u16string p_alert_message{};
      bool p_disable_third_party_subframe_suppresion{};
      LocalFrameHost_RunModalAlertDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (success)
        p_disable_third_party_subframe_suppresion = input_data_view.disable_third_party_subframe_suppresion();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 39, false);
        return false;
      }
      auto callback =
          LocalFrameHost_RunModalAlertDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalAlertDialog(        
        std::move(p_alert_message), 
        std::move(p_disable_third_party_subframe_suppresion), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kRunModalConfirmDialog: {
      internal::LocalFrameHost_RunModalConfirmDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalConfirmDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.40
      bool success = true;
      ::std::u16string p_alert_message{};
      bool p_disable_third_party_subframe_suppresion{};
      LocalFrameHost_RunModalConfirmDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (success)
        p_disable_third_party_subframe_suppresion = input_data_view.disable_third_party_subframe_suppresion();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 40, false);
        return false;
      }
      auto callback =
          LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalConfirmDialog(        
        std::move(p_alert_message), 
        std::move(p_disable_third_party_subframe_suppresion), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kRunModalPromptDialog: {
      internal::LocalFrameHost_RunModalPromptDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalPromptDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.41
      bool success = true;
      ::std::u16string p_alert_message{};
      ::std::u16string p_default_value{};
      bool p_disable_third_party_subframe_suppresion{};
      LocalFrameHost_RunModalPromptDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (success && !input_data_view.ReadDefaultValue(&p_default_value))
        success = false;
      if (success)
        p_disable_third_party_subframe_suppresion = input_data_view.disable_third_party_subframe_suppresion();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 41, false);
        return false;
      }
      auto callback =
          LocalFrameHost_RunModalPromptDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalPromptDialog(        
        std::move(p_alert_message), 
        std::move(p_default_value), 
        std::move(p_disable_third_party_subframe_suppresion), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kRunBeforeUnloadConfirm: {
      internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.42
      bool success = true;
      bool p_is_reload{};
      LocalFrameHost_RunBeforeUnloadConfirm_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 42, false);
        return false;
      }
      auto callback =
          LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunBeforeUnloadConfirm(        
        std::move(p_is_reload), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kUpdateFaviconURL: {
      break;
    }
    case messages::LocalFrameHost::kDownloadURL: {
      break;
    }
    case messages::LocalFrameHost::kFocusedElementChanged: {
      break;
    }
    case messages::LocalFrameHost::kTextSelectionChanged: {
      break;
    }
    case messages::LocalFrameHost::kShowPopupMenu: {
      break;
    }
    case messages::LocalFrameHost::kCreateNewPopupWidget: {
      break;
    }
    case messages::LocalFrameHost::kShowContextMenu: {
      break;
    }
    case messages::LocalFrameHost::kDidLoadResourceFromMemoryCache: {
      break;
    }
    case messages::LocalFrameHost::kDidChangeFrameOwnerProperties: {
      break;
    }
    case messages::LocalFrameHost::kDidChangeOpener: {
      break;
    }
    case messages::LocalFrameHost::kDidChangeFramePolicy: {
      break;
    }
    case messages::LocalFrameHost::kDidChangeIframeAttributes: {
      break;
    }
    case messages::LocalFrameHost::kCapturePaintPreviewOfSubframe: {
      break;
    }
    case messages::LocalFrameHost::kSetCloseListener: {
      break;
    }
    case messages::LocalFrameHost::kDetach: {
      break;
    }
    case messages::LocalFrameHost::kGetKeepAliveHandleFactory: {
      break;
    }
    case messages::LocalFrameHost::kDidAddMessageToConsole: {
      break;
    }
    case messages::LocalFrameHost::kFrameSizeChanged: {
      break;
    }
    case messages::LocalFrameHost::kDidInferColorScheme: {
      break;
    }
    case messages::LocalFrameHost::kDidChangeSrcDoc: {
      break;
    }
    case messages::LocalFrameHost::kReceivedDelegatedCapability: {
      break;
    }
    case messages::LocalFrameHost::kSendFencedFrameReportingBeacon: {
      break;
    }
    case messages::LocalFrameHost::kSendFencedFrameReportingBeaconToCustomURL: {
      break;
    }
    case messages::LocalFrameHost::kDisableUntrustedNetworkInFencedFrame: {
      internal::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.66
      bool success = true;
      LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 66, false);
        return false;
      }
      auto callback =
          LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableUntrustedNetworkInFencedFrame(std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kExemptUrlFromNetworkRevocationForTesting: {
      internal::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.67
      bool success = true;
      ::GURL p_exempted_url{};
      LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExemptedUrl(&p_exempted_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 67, false);
        return false;
      }
      auto callback =
          LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExemptUrlFromNetworkRevocationForTesting(        
        std::move(p_exempted_url), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kSendLegacyTechEvent: {
      break;
    }
    case messages::LocalFrameHost::kSetFencedFrameAutomaticBeaconReportEventData: {
      break;
    }
    case messages::LocalFrameHost::kSendPrivateAggregationRequestsForFencedFrameEvent: {
      break;
    }
    case messages::LocalFrameHost::kCreateFencedFrame: {
      break;
    }
    case messages::LocalFrameHost::kForwardFencedFrameEventAndUserActivationToEmbedder: {
      break;
    }
    case messages::LocalFrameHost::kOnViewTransitionOptInChanged: {
      break;
    }
    case messages::LocalFrameHost::kStartDragging: {
      break;
    }
    case messages::LocalFrameHost::kIssueKeepAliveHandle: {
      break;
    }
    case messages::LocalFrameHost::kNotifyStorageAccessed: {
      break;
    }
    case messages::LocalFrameHost::kRecordWindowProxyUsageMetrics: {
      break;
    }
    case messages::LocalFrameHost::kNotifyDocumentInteractive: {
      break;
    }
    case messages::LocalFrameHost::kSetStorageAccessApiStatus: {
      break;
    }
    case messages::LocalFrameHost::kInitializeCrashReportStorage: {
      internal::LocalFrameHost_InitializeCrashReportStorage_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_InitializeCrashReportStorage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.80
      bool success = true;
      uint64_t p_length{};
      LocalFrameHost_InitializeCrashReportStorage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 80, false);
        return false;
      }
      auto callback =
          LocalFrameHost_InitializeCrashReportStorage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeCrashReportStorage(        
        std::move(p_length), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kSetCrashReportStorageKey: {
      internal::LocalFrameHost_SetCrashReportStorageKey_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_SetCrashReportStorageKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.81
      bool success = true;
      std::string p_key{};
      std::string p_value{};
      LocalFrameHost_SetCrashReportStorageKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 81, false);
        return false;
      }
      auto callback =
          LocalFrameHost_SetCrashReportStorageKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCrashReportStorageKey(        
        std::move(p_key), 
        std::move(p_value), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kRemoveCrashReportStorageKey: {
      internal::LocalFrameHost_RemoveCrashReportStorageKey_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RemoveCrashReportStorageKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.82
      bool success = true;
      std::string p_key{};
      LocalFrameHost_RemoveCrashReportStorageKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 82, false);
        return false;
      }
      auto callback =
          LocalFrameHost_RemoveCrashReportStorageKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveCrashReportStorageKey(        
        std::move(p_key), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLocalFrameHostValidationInfo[] = {
    { &internal::LocalFrameHost_EnterFullscreen_Params_Data::Validate,
     &internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_ExitFullscreen_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_FullscreenStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_RegisterProtocolHandler_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_MainDocumentElementAvailable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SetVirtualKeyboardMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_VisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidChangeThemeColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidFailLoadWithError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidFocusFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidCallFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidBlockNavigation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidChangeLoadProgress_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidFinishLoad_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DispatchLoad_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_GoToEntryAtOffset_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_NavigateToNavigationApiKey_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_UpdateTitle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_UpdateApplicationTitle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_UpdateUserActivationState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_RunModalAlertDialog_Params_Data::Validate,
     &internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_RunModalConfirmDialog_Params_Data::Validate,
     &internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_RunModalPromptDialog_Params_Data::Validate,
     &internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::Validate,
     &internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_UpdateFaviconURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DownloadURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_FocusedElementChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_TextSelectionChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_ShowPopupMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_CreateNewPopupWidget_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_ShowContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidChangeOpener_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidChangeFramePolicy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidChangeIframeAttributes_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SetCloseListener_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_Detach_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidAddMessageToConsole_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_FrameSizeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidInferColorScheme_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DidChangeSrcDoc_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_ReceivedDelegatedCapability_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data::Validate,
     &internal::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data::Validate,
     &internal::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_SendLegacyTechEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_CreateFencedFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_OnViewTransitionOptInChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_StartDragging_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_IssueKeepAliveHandle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_NotifyStorageAccessed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_NotifyDocumentInteractive_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_SetStorageAccessApiStatus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_InitializeCrashReportStorage_Params_Data::Validate,
     &internal::LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_SetCrashReportStorageKey_Params_Data::Validate,
     &internal::LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_RemoveCrashReportStorageKey_Params_Data::Validate,
     &internal::LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data::Validate},
};

bool LocalFrameHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::LocalFrameHost::Name_,
    kLocalFrameHostValidationInfo);
}

bool LocalFrameHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::LocalFrameHost::Name_,
    kLocalFrameHostValidationInfo);
}
// The declaration includes the definition on other builds.

NonAssociatedLocalFrameHost::IPCStableHashFunction NonAssociatedLocalFrameHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NonAssociatedLocalFrameHost>(message.name())) {
    case messages::NonAssociatedLocalFrameHost::kMaybeStartOutermostMainFrameNavigation: {
      return &NonAssociatedLocalFrameHost::MaybeStartOutermostMainFrameNavigation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NonAssociatedLocalFrameHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NonAssociatedLocalFrameHost>(message.name())) {
      case messages::NonAssociatedLocalFrameHost::kMaybeStartOutermostMainFrameNavigation:
            return "Receive blink::mojom::NonAssociatedLocalFrameHost::MaybeStartOutermostMainFrameNavigation";
    }
  } else {
    switch (static_cast<messages::NonAssociatedLocalFrameHost>(message.name())) {
      case messages::NonAssociatedLocalFrameHost::kMaybeStartOutermostMainFrameNavigation:
            return "Receive reply blink::mojom::NonAssociatedLocalFrameHost::MaybeStartOutermostMainFrameNavigation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NonAssociatedLocalFrameHost::MaybeStartOutermostMainFrameNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x994304bf;  // IPCStableHash for blink::mojom::NonAssociatedLocalFrameHost::MaybeStartOutermostMainFrameNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NonAssociatedLocalFrameHostProxy::NonAssociatedLocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NonAssociatedLocalFrameHostProxy::MaybeStartOutermostMainFrameNavigation(
    const std::vector<::GURL>& in_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::NonAssociatedLocalFrameHost::MaybeStartOutermostMainFrameNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NonAssociatedLocalFrameHost::kMaybeStartOutermostMainFrameNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in NonAssociatedLocalFrameHost.MaybeStartOutermostMainFrameNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NonAssociatedLocalFrameHost::Name_);
  message.set_method_name("MaybeStartOutermostMainFrameNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NonAssociatedLocalFrameHostStubDispatch::Accept(
    NonAssociatedLocalFrameHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NonAssociatedLocalFrameHost>(message->header()->name)) {
    case messages::NonAssociatedLocalFrameHost::kMaybeStartOutermostMainFrameNavigation: {
      DCHECK(message->is_serialized());
      internal::NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data* params =
          reinterpret_cast<internal::NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NonAssociatedLocalFrameHost.0
      bool success = true;
      std::vector<::GURL> p_urls{};
      NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NonAssociatedLocalFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeStartOutermostMainFrameNavigation(        
        std::move(p_urls));
      return true;
    }
  }
  return false;
}

// static
bool NonAssociatedLocalFrameHostStubDispatch::AcceptWithResponder(
    NonAssociatedLocalFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NonAssociatedLocalFrameHost>(message->header()->name)) {
    case messages::NonAssociatedLocalFrameHost::kMaybeStartOutermostMainFrameNavigation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNonAssociatedLocalFrameHostValidationInfo[] = {
    { &internal::NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data::Validate,
     nullptr /* no response */},
};

bool NonAssociatedLocalFrameHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::NonAssociatedLocalFrameHost::Name_,
    kNonAssociatedLocalFrameHostValidationInfo);
}

// The declaration includes the definition on other builds.

LocalFrame::IPCStableHashFunction LocalFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LocalFrame>(message.name())) {
    case messages::LocalFrame::kGetTextSurroundingSelection: {
      return &LocalFrame::GetTextSurroundingSelection_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kSendInterventionReport: {
      return &LocalFrame::SendInterventionReport_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kSetFrameOwnerProperties: {
      return &LocalFrame::SetFrameOwnerProperties_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kNotifyUserActivation: {
      return &LocalFrame::NotifyUserActivation_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kNotifyVirtualKeyboardOverlayRect: {
      return &LocalFrame::NotifyVirtualKeyboardOverlayRect_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kShowInterestInElement: {
      return &LocalFrame::ShowInterestInElement_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kAddMessageToConsole: {
      return &LocalFrame::AddMessageToConsole_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kSwapInImmediately: {
      return &LocalFrame::SwapInImmediately_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kCheckCompleted: {
      return &LocalFrame::CheckCompleted_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kStopLoading: {
      return &LocalFrame::StopLoading_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kCollapse: {
      return &LocalFrame::Collapse_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kEnableViewSourceMode: {
      return &LocalFrame::EnableViewSourceMode_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kFocus: {
      return &LocalFrame::Focus_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kClearFocusedElement: {
      return &LocalFrame::ClearFocusedElement_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kCopyImageAt: {
      return &LocalFrame::CopyImageAt_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kSaveImageAt: {
      return &LocalFrame::SaveImageAt_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kReportBlinkFeatureUsage: {
      return &LocalFrame::ReportBlinkFeatureUsage_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kRenderFallbackContent: {
      return &LocalFrame::RenderFallbackContent_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kBeforeUnload: {
      return &LocalFrame::BeforeUnload_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kMediaPlayerActionAt: {
      return &LocalFrame::MediaPlayerActionAt_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kRequestVideoFrameAtWithBoundsHint: {
      return &LocalFrame::RequestVideoFrameAtWithBoundsHint_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kPluginActionAt: {
      return &LocalFrame::PluginActionAt_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kAdvanceFocusInFrame: {
      return &LocalFrame::AdvanceFocusInFrame_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kAdvanceFocusForIME: {
      return &LocalFrame::AdvanceFocusForIME_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kReportContentSecurityPolicyViolation: {
      return &LocalFrame::ReportContentSecurityPolicyViolation_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kDidUpdateFramePolicy: {
      return &LocalFrame::DidUpdateFramePolicy_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kOnFrameVisibilityChanged: {
      return &LocalFrame::OnFrameVisibilityChanged_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kPostMessageEvent: {
      return &LocalFrame::PostMessageEvent_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kJavaScriptMethodExecuteRequest: {
      return &LocalFrame::JavaScriptMethodExecuteRequest_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequest: {
      return &LocalFrame::JavaScriptExecuteRequest_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequestForTests: {
      return &LocalFrame::JavaScriptExecuteRequestForTests_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequestInIsolatedWorld: {
      return &LocalFrame::JavaScriptExecuteRequestInIsolatedWorld_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kJavaScriptAwaitPromise: {
      return &LocalFrame::JavaScriptAwaitPromise_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kGetCharacterIndexAtPoint: {
      return &LocalFrame::GetCharacterIndexAtPoint_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kGetFirstRectForRange: {
      return &LocalFrame::GetFirstRectForRange_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kGetStringForRange: {
      return &LocalFrame::GetStringForRange_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kBindReportingObserver: {
      return &LocalFrame::BindReportingObserver_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kUpdateOpener: {
      return &LocalFrame::UpdateOpener_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kGetSavableResourceLinks: {
      return &LocalFrame::GetSavableResourceLinks_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kMixedContentFound: {
      return &LocalFrame::MixedContentFound_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kBindDevToolsAgent: {
      return &LocalFrame::BindDevToolsAgent_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kExtractAnnotatedText: {
      return &LocalFrame::ExtractAnnotatedText_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kExtractSerializedDom: {
      return &LocalFrame::ExtractSerializedDom_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kExtractSerializedDomElementInfo: {
      return &LocalFrame::ExtractSerializedDomElementInfo_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kHandleRendererDebugURL: {
      return &LocalFrame::HandleRendererDebugURL_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kGetCanonicalUrlForSharing: {
      return &LocalFrame::GetCanonicalUrlForSharing_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kGetOpenGraphMetadata: {
      return &LocalFrame::GetOpenGraphMetadata_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kSetNavigationApiHistoryEntriesForRestore: {
      return &LocalFrame::SetNavigationApiHistoryEntriesForRestore_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kUpdatePrerenderURL: {
      return &LocalFrame::UpdatePrerenderURL_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kNotifyNavigationApiOfDisposedEntries: {
      return &LocalFrame::NotifyNavigationApiOfDisposedEntries_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kTraverseCancelled: {
      return &LocalFrame::TraverseCancelled_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kDispatchNavigateEventForCrossDocumentTraversal: {
      return &LocalFrame::DispatchNavigateEventForCrossDocumentTraversal_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kSnapshotDocumentForViewTransition: {
      return &LocalFrame::SnapshotDocumentForViewTransition_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kNotifyViewTransitionAbortedToOldDocument: {
      return &LocalFrame::NotifyViewTransitionAbortedToOldDocument_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kDispatchPageSwap: {
      return &LocalFrame::DispatchPageSwap_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kAddResourceTimingEntryForFailedSubframeNavigation: {
      return &LocalFrame::AddResourceTimingEntryForFailedSubframeNavigation_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kGetScrollPosition: {
      return &LocalFrame::GetScrollPosition_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LocalFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LocalFrame>(message.name())) {
      case messages::LocalFrame::kGetTextSurroundingSelection:
            return "Receive blink::mojom::LocalFrame::GetTextSurroundingSelection";
      case messages::LocalFrame::kSendInterventionReport:
            return "Receive blink::mojom::LocalFrame::SendInterventionReport";
      case messages::LocalFrame::kSetFrameOwnerProperties:
            return "Receive blink::mojom::LocalFrame::SetFrameOwnerProperties";
      case messages::LocalFrame::kNotifyUserActivation:
            return "Receive blink::mojom::LocalFrame::NotifyUserActivation";
      case messages::LocalFrame::kNotifyVirtualKeyboardOverlayRect:
            return "Receive blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect";
      case messages::LocalFrame::kShowInterestInElement:
            return "Receive blink::mojom::LocalFrame::ShowInterestInElement";
      case messages::LocalFrame::kAddMessageToConsole:
            return "Receive blink::mojom::LocalFrame::AddMessageToConsole";
      case messages::LocalFrame::kSwapInImmediately:
            return "Receive blink::mojom::LocalFrame::SwapInImmediately";
      case messages::LocalFrame::kCheckCompleted:
            return "Receive blink::mojom::LocalFrame::CheckCompleted";
      case messages::LocalFrame::kStopLoading:
            return "Receive blink::mojom::LocalFrame::StopLoading";
      case messages::LocalFrame::kCollapse:
            return "Receive blink::mojom::LocalFrame::Collapse";
      case messages::LocalFrame::kEnableViewSourceMode:
            return "Receive blink::mojom::LocalFrame::EnableViewSourceMode";
      case messages::LocalFrame::kFocus:
            return "Receive blink::mojom::LocalFrame::Focus";
      case messages::LocalFrame::kClearFocusedElement:
            return "Receive blink::mojom::LocalFrame::ClearFocusedElement";
      case messages::LocalFrame::kCopyImageAt:
            return "Receive blink::mojom::LocalFrame::CopyImageAt";
      case messages::LocalFrame::kSaveImageAt:
            return "Receive blink::mojom::LocalFrame::SaveImageAt";
      case messages::LocalFrame::kReportBlinkFeatureUsage:
            return "Receive blink::mojom::LocalFrame::ReportBlinkFeatureUsage";
      case messages::LocalFrame::kRenderFallbackContent:
            return "Receive blink::mojom::LocalFrame::RenderFallbackContent";
      case messages::LocalFrame::kBeforeUnload:
            return "Receive blink::mojom::LocalFrame::BeforeUnload";
      case messages::LocalFrame::kMediaPlayerActionAt:
            return "Receive blink::mojom::LocalFrame::MediaPlayerActionAt";
      case messages::LocalFrame::kRequestVideoFrameAtWithBoundsHint:
            return "Receive blink::mojom::LocalFrame::RequestVideoFrameAtWithBoundsHint";
      case messages::LocalFrame::kPluginActionAt:
            return "Receive blink::mojom::LocalFrame::PluginActionAt";
      case messages::LocalFrame::kAdvanceFocusInFrame:
            return "Receive blink::mojom::LocalFrame::AdvanceFocusInFrame";
      case messages::LocalFrame::kAdvanceFocusForIME:
            return "Receive blink::mojom::LocalFrame::AdvanceFocusForIME";
      case messages::LocalFrame::kReportContentSecurityPolicyViolation:
            return "Receive blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation";
      case messages::LocalFrame::kDidUpdateFramePolicy:
            return "Receive blink::mojom::LocalFrame::DidUpdateFramePolicy";
      case messages::LocalFrame::kOnFrameVisibilityChanged:
            return "Receive blink::mojom::LocalFrame::OnFrameVisibilityChanged";
      case messages::LocalFrame::kPostMessageEvent:
            return "Receive blink::mojom::LocalFrame::PostMessageEvent";
      case messages::LocalFrame::kJavaScriptMethodExecuteRequest:
            return "Receive blink::mojom::LocalFrame::JavaScriptMethodExecuteRequest";
      case messages::LocalFrame::kJavaScriptExecuteRequest:
            return "Receive blink::mojom::LocalFrame::JavaScriptExecuteRequest";
      case messages::LocalFrame::kJavaScriptExecuteRequestForTests:
            return "Receive blink::mojom::LocalFrame::JavaScriptExecuteRequestForTests";
      case messages::LocalFrame::kJavaScriptExecuteRequestInIsolatedWorld:
            return "Receive blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorld";
      case messages::LocalFrame::kJavaScriptAwaitPromise:
            return "Receive blink::mojom::LocalFrame::JavaScriptAwaitPromise";
      case messages::LocalFrame::kGetCharacterIndexAtPoint:
            return "Receive blink::mojom::LocalFrame::GetCharacterIndexAtPoint";
      case messages::LocalFrame::kGetFirstRectForRange:
            return "Receive blink::mojom::LocalFrame::GetFirstRectForRange";
      case messages::LocalFrame::kGetStringForRange:
            return "Receive blink::mojom::LocalFrame::GetStringForRange";
      case messages::LocalFrame::kBindReportingObserver:
            return "Receive blink::mojom::LocalFrame::BindReportingObserver";
      case messages::LocalFrame::kUpdateOpener:
            return "Receive blink::mojom::LocalFrame::UpdateOpener";
      case messages::LocalFrame::kGetSavableResourceLinks:
            return "Receive blink::mojom::LocalFrame::GetSavableResourceLinks";
      case messages::LocalFrame::kMixedContentFound:
            return "Receive blink::mojom::LocalFrame::MixedContentFound";
      case messages::LocalFrame::kBindDevToolsAgent:
            return "Receive blink::mojom::LocalFrame::BindDevToolsAgent";
      case messages::LocalFrame::kExtractAnnotatedText:
            return "Receive blink::mojom::LocalFrame::ExtractAnnotatedText";
      case messages::LocalFrame::kExtractSerializedDom:
            return "Receive blink::mojom::LocalFrame::ExtractSerializedDom";
      case messages::LocalFrame::kExtractSerializedDomElementInfo:
            return "Receive blink::mojom::LocalFrame::ExtractSerializedDomElementInfo";
      case messages::LocalFrame::kHandleRendererDebugURL:
            return "Receive blink::mojom::LocalFrame::HandleRendererDebugURL";
      case messages::LocalFrame::kGetCanonicalUrlForSharing:
            return "Receive blink::mojom::LocalFrame::GetCanonicalUrlForSharing";
      case messages::LocalFrame::kGetOpenGraphMetadata:
            return "Receive blink::mojom::LocalFrame::GetOpenGraphMetadata";
      case messages::LocalFrame::kSetNavigationApiHistoryEntriesForRestore:
            return "Receive blink::mojom::LocalFrame::SetNavigationApiHistoryEntriesForRestore";
      case messages::LocalFrame::kUpdatePrerenderURL:
            return "Receive blink::mojom::LocalFrame::UpdatePrerenderURL";
      case messages::LocalFrame::kNotifyNavigationApiOfDisposedEntries:
            return "Receive blink::mojom::LocalFrame::NotifyNavigationApiOfDisposedEntries";
      case messages::LocalFrame::kTraverseCancelled:
            return "Receive blink::mojom::LocalFrame::TraverseCancelled";
      case messages::LocalFrame::kDispatchNavigateEventForCrossDocumentTraversal:
            return "Receive blink::mojom::LocalFrame::DispatchNavigateEventForCrossDocumentTraversal";
      case messages::LocalFrame::kSnapshotDocumentForViewTransition:
            return "Receive blink::mojom::LocalFrame::SnapshotDocumentForViewTransition";
      case messages::LocalFrame::kNotifyViewTransitionAbortedToOldDocument:
            return "Receive blink::mojom::LocalFrame::NotifyViewTransitionAbortedToOldDocument";
      case messages::LocalFrame::kDispatchPageSwap:
            return "Receive blink::mojom::LocalFrame::DispatchPageSwap";
      case messages::LocalFrame::kAddResourceTimingEntryForFailedSubframeNavigation:
            return "Receive blink::mojom::LocalFrame::AddResourceTimingEntryForFailedSubframeNavigation";
      case messages::LocalFrame::kGetScrollPosition:
            return "Receive blink::mojom::LocalFrame::GetScrollPosition";
    }
  } else {
    switch (static_cast<messages::LocalFrame>(message.name())) {
      case messages::LocalFrame::kGetTextSurroundingSelection:
            return "Receive reply blink::mojom::LocalFrame::GetTextSurroundingSelection";
      case messages::LocalFrame::kSendInterventionReport:
            return "Receive reply blink::mojom::LocalFrame::SendInterventionReport";
      case messages::LocalFrame::kSetFrameOwnerProperties:
            return "Receive reply blink::mojom::LocalFrame::SetFrameOwnerProperties";
      case messages::LocalFrame::kNotifyUserActivation:
            return "Receive reply blink::mojom::LocalFrame::NotifyUserActivation";
      case messages::LocalFrame::kNotifyVirtualKeyboardOverlayRect:
            return "Receive reply blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect";
      case messages::LocalFrame::kShowInterestInElement:
            return "Receive reply blink::mojom::LocalFrame::ShowInterestInElement";
      case messages::LocalFrame::kAddMessageToConsole:
            return "Receive reply blink::mojom::LocalFrame::AddMessageToConsole";
      case messages::LocalFrame::kSwapInImmediately:
            return "Receive reply blink::mojom::LocalFrame::SwapInImmediately";
      case messages::LocalFrame::kCheckCompleted:
            return "Receive reply blink::mojom::LocalFrame::CheckCompleted";
      case messages::LocalFrame::kStopLoading:
            return "Receive reply blink::mojom::LocalFrame::StopLoading";
      case messages::LocalFrame::kCollapse:
            return "Receive reply blink::mojom::LocalFrame::Collapse";
      case messages::LocalFrame::kEnableViewSourceMode:
            return "Receive reply blink::mojom::LocalFrame::EnableViewSourceMode";
      case messages::LocalFrame::kFocus:
            return "Receive reply blink::mojom::LocalFrame::Focus";
      case messages::LocalFrame::kClearFocusedElement:
            return "Receive reply blink::mojom::LocalFrame::ClearFocusedElement";
      case messages::LocalFrame::kCopyImageAt:
            return "Receive reply blink::mojom::LocalFrame::CopyImageAt";
      case messages::LocalFrame::kSaveImageAt:
            return "Receive reply blink::mojom::LocalFrame::SaveImageAt";
      case messages::LocalFrame::kReportBlinkFeatureUsage:
            return "Receive reply blink::mojom::LocalFrame::ReportBlinkFeatureUsage";
      case messages::LocalFrame::kRenderFallbackContent:
            return "Receive reply blink::mojom::LocalFrame::RenderFallbackContent";
      case messages::LocalFrame::kBeforeUnload:
            return "Receive reply blink::mojom::LocalFrame::BeforeUnload";
      case messages::LocalFrame::kMediaPlayerActionAt:
            return "Receive reply blink::mojom::LocalFrame::MediaPlayerActionAt";
      case messages::LocalFrame::kRequestVideoFrameAtWithBoundsHint:
            return "Receive reply blink::mojom::LocalFrame::RequestVideoFrameAtWithBoundsHint";
      case messages::LocalFrame::kPluginActionAt:
            return "Receive reply blink::mojom::LocalFrame::PluginActionAt";
      case messages::LocalFrame::kAdvanceFocusInFrame:
            return "Receive reply blink::mojom::LocalFrame::AdvanceFocusInFrame";
      case messages::LocalFrame::kAdvanceFocusForIME:
            return "Receive reply blink::mojom::LocalFrame::AdvanceFocusForIME";
      case messages::LocalFrame::kReportContentSecurityPolicyViolation:
            return "Receive reply blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation";
      case messages::LocalFrame::kDidUpdateFramePolicy:
            return "Receive reply blink::mojom::LocalFrame::DidUpdateFramePolicy";
      case messages::LocalFrame::kOnFrameVisibilityChanged:
            return "Receive reply blink::mojom::LocalFrame::OnFrameVisibilityChanged";
      case messages::LocalFrame::kPostMessageEvent:
            return "Receive reply blink::mojom::LocalFrame::PostMessageEvent";
      case messages::LocalFrame::kJavaScriptMethodExecuteRequest:
            return "Receive reply blink::mojom::LocalFrame::JavaScriptMethodExecuteRequest";
      case messages::LocalFrame::kJavaScriptExecuteRequest:
            return "Receive reply blink::mojom::LocalFrame::JavaScriptExecuteRequest";
      case messages::LocalFrame::kJavaScriptExecuteRequestForTests:
            return "Receive reply blink::mojom::LocalFrame::JavaScriptExecuteRequestForTests";
      case messages::LocalFrame::kJavaScriptExecuteRequestInIsolatedWorld:
            return "Receive reply blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorld";
      case messages::LocalFrame::kJavaScriptAwaitPromise:
            return "Receive reply blink::mojom::LocalFrame::JavaScriptAwaitPromise";
      case messages::LocalFrame::kGetCharacterIndexAtPoint:
            return "Receive reply blink::mojom::LocalFrame::GetCharacterIndexAtPoint";
      case messages::LocalFrame::kGetFirstRectForRange:
            return "Receive reply blink::mojom::LocalFrame::GetFirstRectForRange";
      case messages::LocalFrame::kGetStringForRange:
            return "Receive reply blink::mojom::LocalFrame::GetStringForRange";
      case messages::LocalFrame::kBindReportingObserver:
            return "Receive reply blink::mojom::LocalFrame::BindReportingObserver";
      case messages::LocalFrame::kUpdateOpener:
            return "Receive reply blink::mojom::LocalFrame::UpdateOpener";
      case messages::LocalFrame::kGetSavableResourceLinks:
            return "Receive reply blink::mojom::LocalFrame::GetSavableResourceLinks";
      case messages::LocalFrame::kMixedContentFound:
            return "Receive reply blink::mojom::LocalFrame::MixedContentFound";
      case messages::LocalFrame::kBindDevToolsAgent:
            return "Receive reply blink::mojom::LocalFrame::BindDevToolsAgent";
      case messages::LocalFrame::kExtractAnnotatedText:
            return "Receive reply blink::mojom::LocalFrame::ExtractAnnotatedText";
      case messages::LocalFrame::kExtractSerializedDom:
            return "Receive reply blink::mojom::LocalFrame::ExtractSerializedDom";
      case messages::LocalFrame::kExtractSerializedDomElementInfo:
            return "Receive reply blink::mojom::LocalFrame::ExtractSerializedDomElementInfo";
      case messages::LocalFrame::kHandleRendererDebugURL:
            return "Receive reply blink::mojom::LocalFrame::HandleRendererDebugURL";
      case messages::LocalFrame::kGetCanonicalUrlForSharing:
            return "Receive reply blink::mojom::LocalFrame::GetCanonicalUrlForSharing";
      case messages::LocalFrame::kGetOpenGraphMetadata:
            return "Receive reply blink::mojom::LocalFrame::GetOpenGraphMetadata";
      case messages::LocalFrame::kSetNavigationApiHistoryEntriesForRestore:
            return "Receive reply blink::mojom::LocalFrame::SetNavigationApiHistoryEntriesForRestore";
      case messages::LocalFrame::kUpdatePrerenderURL:
            return "Receive reply blink::mojom::LocalFrame::UpdatePrerenderURL";
      case messages::LocalFrame::kNotifyNavigationApiOfDisposedEntries:
            return "Receive reply blink::mojom::LocalFrame::NotifyNavigationApiOfDisposedEntries";
      case messages::LocalFrame::kTraverseCancelled:
            return "Receive reply blink::mojom::LocalFrame::TraverseCancelled";
      case messages::LocalFrame::kDispatchNavigateEventForCrossDocumentTraversal:
            return "Receive reply blink::mojom::LocalFrame::DispatchNavigateEventForCrossDocumentTraversal";
      case messages::LocalFrame::kSnapshotDocumentForViewTransition:
            return "Receive reply blink::mojom::LocalFrame::SnapshotDocumentForViewTransition";
      case messages::LocalFrame::kNotifyViewTransitionAbortedToOldDocument:
            return "Receive reply blink::mojom::LocalFrame::NotifyViewTransitionAbortedToOldDocument";
      case messages::LocalFrame::kDispatchPageSwap:
            return "Receive reply blink::mojom::LocalFrame::DispatchPageSwap";
      case messages::LocalFrame::kAddResourceTimingEntryForFailedSubframeNavigation:
            return "Receive reply blink::mojom::LocalFrame::AddResourceTimingEntryForFailedSubframeNavigation";
      case messages::LocalFrame::kGetScrollPosition:
            return "Receive reply blink::mojom::LocalFrame::GetScrollPosition";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LocalFrame::GetTextSurroundingSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc36faeba;  // IPCStableHash for blink::mojom::LocalFrame::GetTextSurroundingSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::SendInterventionReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x56868a63;  // IPCStableHash for blink::mojom::LocalFrame::SendInterventionReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::SetFrameOwnerProperties_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeaa0f7c9;  // IPCStableHash for blink::mojom::LocalFrame::SetFrameOwnerProperties
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::NotifyUserActivation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4dd1603b;  // IPCStableHash for blink::mojom::LocalFrame::NotifyUserActivation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::NotifyVirtualKeyboardOverlayRect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6df0e708;  // IPCStableHash for blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ShowInterestInElement_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a2b5888;  // IPCStableHash for blink::mojom::LocalFrame::ShowInterestInElement
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::AddMessageToConsole_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb54874a3;  // IPCStableHash for blink::mojom::LocalFrame::AddMessageToConsole
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::SwapInImmediately_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52a85bd9;  // IPCStableHash for blink::mojom::LocalFrame::SwapInImmediately
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::CheckCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71736320;  // IPCStableHash for blink::mojom::LocalFrame::CheckCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::StopLoading_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x59b47239;  // IPCStableHash for blink::mojom::LocalFrame::StopLoading
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::Collapse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa855029e;  // IPCStableHash for blink::mojom::LocalFrame::Collapse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::EnableViewSourceMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7fc3f21c;  // IPCStableHash for blink::mojom::LocalFrame::EnableViewSourceMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::Focus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f7b6187;  // IPCStableHash for blink::mojom::LocalFrame::Focus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ClearFocusedElement_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe37189a5;  // IPCStableHash for blink::mojom::LocalFrame::ClearFocusedElement
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::CopyImageAt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc77a3914;  // IPCStableHash for blink::mojom::LocalFrame::CopyImageAt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::SaveImageAt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6b46206;  // IPCStableHash for blink::mojom::LocalFrame::SaveImageAt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ReportBlinkFeatureUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa40ae238;  // IPCStableHash for blink::mojom::LocalFrame::ReportBlinkFeatureUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::RenderFallbackContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23168199;  // IPCStableHash for blink::mojom::LocalFrame::RenderFallbackContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::BeforeUnload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81038cc8;  // IPCStableHash for blink::mojom::LocalFrame::BeforeUnload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::MediaPlayerActionAt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa93b0f63;  // IPCStableHash for blink::mojom::LocalFrame::MediaPlayerActionAt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::RequestVideoFrameAtWithBoundsHint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b57872b;  // IPCStableHash for blink::mojom::LocalFrame::RequestVideoFrameAtWithBoundsHint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::PluginActionAt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b719349;  // IPCStableHash for blink::mojom::LocalFrame::PluginActionAt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::AdvanceFocusInFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54663684;  // IPCStableHash for blink::mojom::LocalFrame::AdvanceFocusInFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::AdvanceFocusForIME_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f241d8e;  // IPCStableHash for blink::mojom::LocalFrame::AdvanceFocusForIME
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ReportContentSecurityPolicyViolation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4593d00c;  // IPCStableHash for blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::DidUpdateFramePolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5053641d;  // IPCStableHash for blink::mojom::LocalFrame::DidUpdateFramePolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::OnFrameVisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x68bd22c0;  // IPCStableHash for blink::mojom::LocalFrame::OnFrameVisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::PostMessageEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e5ba8cf;  // IPCStableHash for blink::mojom::LocalFrame::PostMessageEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::JavaScriptMethodExecuteRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b98e11c;  // IPCStableHash for blink::mojom::LocalFrame::JavaScriptMethodExecuteRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::JavaScriptExecuteRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6567b226;  // IPCStableHash for blink::mojom::LocalFrame::JavaScriptExecuteRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::JavaScriptExecuteRequestForTests_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16509ed5;  // IPCStableHash for blink::mojom::LocalFrame::JavaScriptExecuteRequestForTests
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::JavaScriptExecuteRequestInIsolatedWorld_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc21d3e95;  // IPCStableHash for blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorld
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::JavaScriptAwaitPromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca00f1ff;  // IPCStableHash for blink::mojom::LocalFrame::JavaScriptAwaitPromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::GetCharacterIndexAtPoint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6be3eee0;  // IPCStableHash for blink::mojom::LocalFrame::GetCharacterIndexAtPoint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::GetFirstRectForRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b195aaa;  // IPCStableHash for blink::mojom::LocalFrame::GetFirstRectForRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::GetStringForRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e14db95;  // IPCStableHash for blink::mojom::LocalFrame::GetStringForRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::BindReportingObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67f59f39;  // IPCStableHash for blink::mojom::LocalFrame::BindReportingObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::UpdateOpener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab577bfd;  // IPCStableHash for blink::mojom::LocalFrame::UpdateOpener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::GetSavableResourceLinks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74cded7f;  // IPCStableHash for blink::mojom::LocalFrame::GetSavableResourceLinks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::MixedContentFound_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbacc4bcd;  // IPCStableHash for blink::mojom::LocalFrame::MixedContentFound
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::BindDevToolsAgent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb371c1aa;  // IPCStableHash for blink::mojom::LocalFrame::BindDevToolsAgent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ExtractAnnotatedText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e04001f;  // IPCStableHash for blink::mojom::LocalFrame::ExtractAnnotatedText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ExtractSerializedDom_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd6fb7254;  // IPCStableHash for blink::mojom::LocalFrame::ExtractSerializedDom
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ExtractSerializedDomElementInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c83a93d;  // IPCStableHash for blink::mojom::LocalFrame::ExtractSerializedDomElementInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::HandleRendererDebugURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b68d3e3;  // IPCStableHash for blink::mojom::LocalFrame::HandleRendererDebugURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::GetCanonicalUrlForSharing_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7eb6d4be;  // IPCStableHash for blink::mojom::LocalFrame::GetCanonicalUrlForSharing
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::GetOpenGraphMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x94d8fc71;  // IPCStableHash for blink::mojom::LocalFrame::GetOpenGraphMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::SetNavigationApiHistoryEntriesForRestore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2edae9fa;  // IPCStableHash for blink::mojom::LocalFrame::SetNavigationApiHistoryEntriesForRestore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::UpdatePrerenderURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a24dfa3;  // IPCStableHash for blink::mojom::LocalFrame::UpdatePrerenderURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::NotifyNavigationApiOfDisposedEntries_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x709facf3;  // IPCStableHash for blink::mojom::LocalFrame::NotifyNavigationApiOfDisposedEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::TraverseCancelled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7c15f9c;  // IPCStableHash for blink::mojom::LocalFrame::TraverseCancelled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::DispatchNavigateEventForCrossDocumentTraversal_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x338abab3;  // IPCStableHash for blink::mojom::LocalFrame::DispatchNavigateEventForCrossDocumentTraversal
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::SnapshotDocumentForViewTransition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x681cf98f;  // IPCStableHash for blink::mojom::LocalFrame::SnapshotDocumentForViewTransition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::NotifyViewTransitionAbortedToOldDocument_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17d4a549;  // IPCStableHash for blink::mojom::LocalFrame::NotifyViewTransitionAbortedToOldDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::DispatchPageSwap_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03eb34f4;  // IPCStableHash for blink::mojom::LocalFrame::DispatchPageSwap
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::AddResourceTimingEntryForFailedSubframeNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff544236;  // IPCStableHash for blink::mojom::LocalFrame::AddResourceTimingEntryForFailedSubframeNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::GetScrollPosition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd87be8d2;  // IPCStableHash for blink::mojom::LocalFrame::GetScrollPosition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LocalFrame_GetTextSurroundingSelection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetTextSurroundingSelection_ForwardToCallback(
      LocalFrame::GetTextSurroundingSelectionCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_GetTextSurroundingSelection_ForwardToCallback(const LocalFrame_GetTextSurroundingSelection_ForwardToCallback&) = delete;
  LocalFrame_GetTextSurroundingSelection_ForwardToCallback& operator=(const LocalFrame_GetTextSurroundingSelection_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetTextSurroundingSelectionCallback callback_;
};

class LocalFrame_BeforeUnload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_BeforeUnload_ForwardToCallback(
      LocalFrame::BeforeUnloadCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_BeforeUnload_ForwardToCallback(const LocalFrame_BeforeUnload_ForwardToCallback&) = delete;
  LocalFrame_BeforeUnload_ForwardToCallback& operator=(const LocalFrame_BeforeUnload_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::BeforeUnloadCallback callback_;
};

class LocalFrame_RequestVideoFrameAtWithBoundsHint_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_RequestVideoFrameAtWithBoundsHint_ForwardToCallback(
      LocalFrame::RequestVideoFrameAtWithBoundsHintCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_RequestVideoFrameAtWithBoundsHint_ForwardToCallback(const LocalFrame_RequestVideoFrameAtWithBoundsHint_ForwardToCallback&) = delete;
  LocalFrame_RequestVideoFrameAtWithBoundsHint_ForwardToCallback& operator=(const LocalFrame_RequestVideoFrameAtWithBoundsHint_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::RequestVideoFrameAtWithBoundsHintCallback callback_;
};

class LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback(
      LocalFrame::JavaScriptMethodExecuteRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback(const LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback&) = delete;
  LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback& operator=(const LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptMethodExecuteRequestCallback callback_;
};

class LocalFrame_JavaScriptExecuteRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptExecuteRequest_ForwardToCallback(
      LocalFrame::JavaScriptExecuteRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_JavaScriptExecuteRequest_ForwardToCallback(const LocalFrame_JavaScriptExecuteRequest_ForwardToCallback&) = delete;
  LocalFrame_JavaScriptExecuteRequest_ForwardToCallback& operator=(const LocalFrame_JavaScriptExecuteRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptExecuteRequestCallback callback_;
};

class LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback(
      LocalFrame::JavaScriptExecuteRequestForTestsCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback(const LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback&) = delete;
  LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback& operator=(const LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptExecuteRequestForTestsCallback callback_;
};

class LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(
      LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback&) = delete;
  LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback& operator=(const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback callback_;
};

class LocalFrame_JavaScriptAwaitPromise_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptAwaitPromise_ForwardToCallback(
      LocalFrame::JavaScriptAwaitPromiseCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_JavaScriptAwaitPromise_ForwardToCallback(const LocalFrame_JavaScriptAwaitPromise_ForwardToCallback&) = delete;
  LocalFrame_JavaScriptAwaitPromise_ForwardToCallback& operator=(const LocalFrame_JavaScriptAwaitPromise_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptAwaitPromiseCallback callback_;
};

class LocalFrame_GetStringForRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetStringForRange_ForwardToCallback(
      LocalFrame::GetStringForRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_GetStringForRange_ForwardToCallback(const LocalFrame_GetStringForRange_ForwardToCallback&) = delete;
  LocalFrame_GetStringForRange_ForwardToCallback& operator=(const LocalFrame_GetStringForRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetStringForRangeCallback callback_;
};

class LocalFrame_GetSavableResourceLinks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetSavableResourceLinks_ForwardToCallback(
      LocalFrame::GetSavableResourceLinksCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_GetSavableResourceLinks_ForwardToCallback(const LocalFrame_GetSavableResourceLinks_ForwardToCallback&) = delete;
  LocalFrame_GetSavableResourceLinks_ForwardToCallback& operator=(const LocalFrame_GetSavableResourceLinks_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetSavableResourceLinksCallback callback_;
};

class LocalFrame_ExtractAnnotatedText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_ExtractAnnotatedText_ForwardToCallback(
      LocalFrame::ExtractAnnotatedTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_ExtractAnnotatedText_ForwardToCallback(const LocalFrame_ExtractAnnotatedText_ForwardToCallback&) = delete;
  LocalFrame_ExtractAnnotatedText_ForwardToCallback& operator=(const LocalFrame_ExtractAnnotatedText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::ExtractAnnotatedTextCallback callback_;
};

class LocalFrame_ExtractSerializedDom_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_ExtractSerializedDom_ForwardToCallback(
      LocalFrame::ExtractSerializedDomCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_ExtractSerializedDom_ForwardToCallback(const LocalFrame_ExtractSerializedDom_ForwardToCallback&) = delete;
  LocalFrame_ExtractSerializedDom_ForwardToCallback& operator=(const LocalFrame_ExtractSerializedDom_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::ExtractSerializedDomCallback callback_;
};

class LocalFrame_ExtractSerializedDomElementInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_ExtractSerializedDomElementInfo_ForwardToCallback(
      LocalFrame::ExtractSerializedDomElementInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_ExtractSerializedDomElementInfo_ForwardToCallback(const LocalFrame_ExtractSerializedDomElementInfo_ForwardToCallback&) = delete;
  LocalFrame_ExtractSerializedDomElementInfo_ForwardToCallback& operator=(const LocalFrame_ExtractSerializedDomElementInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::ExtractSerializedDomElementInfoCallback callback_;
};

class LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback(
      LocalFrame::GetCanonicalUrlForSharingCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback(const LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback&) = delete;
  LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback& operator=(const LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetCanonicalUrlForSharingCallback callback_;
};

class LocalFrame_GetOpenGraphMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetOpenGraphMetadata_ForwardToCallback(
      LocalFrame::GetOpenGraphMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_GetOpenGraphMetadata_ForwardToCallback(const LocalFrame_GetOpenGraphMetadata_ForwardToCallback&) = delete;
  LocalFrame_GetOpenGraphMetadata_ForwardToCallback& operator=(const LocalFrame_GetOpenGraphMetadata_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetOpenGraphMetadataCallback callback_;
};

class LocalFrame_UpdatePrerenderURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_UpdatePrerenderURL_ForwardToCallback(
      LocalFrame::UpdatePrerenderURLCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_UpdatePrerenderURL_ForwardToCallback(const LocalFrame_UpdatePrerenderURL_ForwardToCallback&) = delete;
  LocalFrame_UpdatePrerenderURL_ForwardToCallback& operator=(const LocalFrame_UpdatePrerenderURL_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::UpdatePrerenderURLCallback callback_;
};

class LocalFrame_SnapshotDocumentForViewTransition_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_SnapshotDocumentForViewTransition_ForwardToCallback(
      LocalFrame::SnapshotDocumentForViewTransitionCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_SnapshotDocumentForViewTransition_ForwardToCallback(const LocalFrame_SnapshotDocumentForViewTransition_ForwardToCallback&) = delete;
  LocalFrame_SnapshotDocumentForViewTransition_ForwardToCallback& operator=(const LocalFrame_SnapshotDocumentForViewTransition_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::SnapshotDocumentForViewTransitionCallback callback_;
};

class LocalFrame_GetScrollPosition_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetScrollPosition_ForwardToCallback(
      LocalFrame::GetScrollPositionCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_GetScrollPosition_ForwardToCallback(const LocalFrame_GetScrollPosition_ForwardToCallback&) = delete;
  LocalFrame_GetScrollPosition_ForwardToCallback& operator=(const LocalFrame_GetScrollPosition_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetScrollPositionCallback callback_;
};

LocalFrameProxy::LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameProxy::GetTextSurroundingSelection(
    uint32_t in_max_length, GetTextSurroundingSelectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::GetTextSurroundingSelection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_length"), in_max_length,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetTextSurroundingSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetTextSurroundingSelection_Params_Data> params(
          message);
  params.Allocate();

  params->max_length = in_max_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetTextSurroundingSelection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetTextSurroundingSelection_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::SendInterventionReport(
    const std::string& in_id, const std::string& in_message, const std::optional<::blink::FrameToken>& in_child_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::SendInterventionReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const std::optional<::blink::FrameToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSendInterventionReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SendInterventionReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in LocalFrame.SendInterventionReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in LocalFrame.SendInterventionReport request");
  mojo::internal::MessageFragment<decltype(params->child_frame_token)>
      child_frame_token_fragment(params.message());
  child_frame_token_fragment.Claim(&params->child_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_child_frame_token,
    child_frame_token_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SendInterventionReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::SetFrameOwnerProperties(
    ::blink::mojom::FrameOwnerPropertiesPtr in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::SetFrameOwnerProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSetFrameOwnerProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SetFrameOwnerProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
    in_properties,
    properties_fragment);

  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null properties in LocalFrame.SetFrameOwnerProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::NotifyUserActivation(
    ::blink::mojom::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::NotifyUserActivation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_type"), in_notification_type,
                        "<value of type ::blink::mojom::UserActivationNotificationType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kNotifyUserActivation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_NotifyUserActivation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
    in_notification_type,
    &params->notification_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyUserActivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::NotifyVirtualKeyboardOverlayRect(
    const ::gfx::Rect& in_keyboard_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keyboard_rect"), in_keyboard_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kNotifyVirtualKeyboardOverlayRect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keyboard_rect)::BaseType> keyboard_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_keyboard_rect,
    keyboard_rect_fragment);

  params->keyboard_rect.Set(
      keyboard_rect_fragment.is_null() ? nullptr : keyboard_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keyboard_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keyboard_rect in LocalFrame.NotifyVirtualKeyboardOverlayRect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyVirtualKeyboardOverlayRect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::ShowInterestInElement(
    int32_t in_nodeID) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::ShowInterestInElement", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("nodeID"), in_nodeID,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kShowInterestInElement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ShowInterestInElement_Params_Data> params(
          message);
  params.Allocate();

  params->nodeID = in_nodeID;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ShowInterestInElement");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::AddMessageToConsole(
    ::blink::mojom::ConsoleMessageLevel in_level, const std::string& in_message, bool in_discard_duplicates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::AddMessageToConsole", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level"), in_level,
                        "<value of type ::blink::mojom::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("discard_duplicates"), in_discard_duplicates,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kAddMessageToConsole), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_AddMessageToConsole_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
    in_level,
    &params->level);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in LocalFrame.AddMessageToConsole request");

  params->discard_duplicates = in_discard_duplicates;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::SwapInImmediately(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::SwapInImmediately");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSwapInImmediately), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SwapInImmediately_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SwapInImmediately");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::CheckCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::CheckCompleted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kCheckCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_CheckCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("CheckCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::StopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::StopLoading");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kStopLoading), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_StopLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("StopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::Collapse(
    bool in_collapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::Collapse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collapsed"), in_collapsed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kCollapse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_Collapse_Params_Data> params(
          message);
  params.Allocate();

  params->collapsed = in_collapsed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("Collapse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::EnableViewSourceMode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::EnableViewSourceMode");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kEnableViewSourceMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_EnableViewSourceMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("EnableViewSourceMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::Focus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::Focus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_Focus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("Focus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::ClearFocusedElement(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::ClearFocusedElement");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kClearFocusedElement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ClearFocusedElement_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ClearFocusedElement");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::CopyImageAt(
    const ::gfx::Point& in_window_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::CopyImageAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_point"), in_window_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kCopyImageAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_CopyImageAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_point)::BaseType> window_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_window_point,
    window_point_fragment);

  params->window_point.Set(
      window_point_fragment.is_null() ? nullptr : window_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->window_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null window_point in LocalFrame.CopyImageAt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("CopyImageAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::SaveImageAt(
    const ::gfx::Point& in_window_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::SaveImageAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_point"), in_window_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSaveImageAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SaveImageAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_point)::BaseType> window_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_window_point,
    window_point_fragment);

  params->window_point.Set(
      window_point_fragment.is_null() ? nullptr : window_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->window_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null window_point in LocalFrame.SaveImageAt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SaveImageAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::ReportBlinkFeatureUsage(
    const std::vector<::blink::mojom::WebFeature>& in_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::ReportBlinkFeatureUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type const std::vector<::blink::mojom::WebFeature>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kReportBlinkFeatureUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType>
      features_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
    in_features,
    features_fragment,
    &features_validate_params);

  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->features.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null features in LocalFrame.ReportBlinkFeatureUsage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ReportBlinkFeatureUsage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::RenderFallbackContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::RenderFallbackContent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kRenderFallbackContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_RenderFallbackContent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("RenderFallbackContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::BeforeUnload(
    bool in_is_reload, BeforeUnloadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::BeforeUnload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_reload"), in_is_reload,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = mojo::UrgentMessageScope::IsInUrgentScope();


  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kBeforeUnload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_BeforeUnload_Params_Data> params(
          message);
  params.Allocate();

  params->is_reload = in_is_reload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BeforeUnload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_BeforeUnload_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::MediaPlayerActionAt(
    const ::gfx::Point& in_location, ::blink::mojom::MediaPlayerActionPtr in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::MediaPlayerActionAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location"), in_location,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ::blink::mojom::MediaPlayerActionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kMediaPlayerActionAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_MediaPlayerActionAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->location)::BaseType> location_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_location,
    location_fragment);

  params->location.Set(
      location_fragment.is_null() ? nullptr : location_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->location.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null location in LocalFrame.MediaPlayerActionAt request");
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType> action_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaPlayerActionDataView>(
    in_action,
    action_fragment);

  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->action.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null action in LocalFrame.MediaPlayerActionAt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("MediaPlayerActionAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::RequestVideoFrameAtWithBoundsHint(
    const ::gfx::Point& in_location, const ::gfx::Size& in_max_size, int32_t in_max_area, RequestVideoFrameAtWithBoundsHintCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::RequestVideoFrameAtWithBoundsHint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location"), in_location,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size"), in_max_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_area"), in_max_area,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kRequestVideoFrameAtWithBoundsHint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->location)::BaseType> location_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_location,
    location_fragment);

  params->location.Set(
      location_fragment.is_null() ? nullptr : location_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->location.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null location in LocalFrame.RequestVideoFrameAtWithBoundsHint request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_size)::BaseType> max_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_max_size,
    max_size_fragment);

  params->max_size.Set(
      max_size_fragment.is_null() ? nullptr : max_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->max_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null max_size in LocalFrame.RequestVideoFrameAtWithBoundsHint request");

  params->max_area = in_max_area;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("RequestVideoFrameAtWithBoundsHint");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_RequestVideoFrameAtWithBoundsHint_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::PluginActionAt(
    const ::gfx::Point& in_location, PluginActionType in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::PluginActionAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location"), in_location,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type PluginActionType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kPluginActionAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_PluginActionAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->location)::BaseType> location_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_location,
    location_fragment);

  params->location.Set(
      location_fragment.is_null() ? nullptr : location_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->location.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null location in LocalFrame.PluginActionAt request");

  
  mojo::internal::Serialize<::blink::mojom::PluginActionType>(
    in_action,
    &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("PluginActionAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::AdvanceFocusInFrame(
    ::blink::mojom::FocusType in_focus_type, const std::optional<::blink::RemoteFrameToken>& in_source_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::AdvanceFocusInFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_type"), in_focus_type,
                        "<value of type ::blink::mojom::FocusType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_frame_token"), in_source_frame_token,
                        "<value of type const std::optional<::blink::RemoteFrameToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kAdvanceFocusInFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_AdvanceFocusInFrame_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FocusType>(
    in_focus_type,
    &params->focus_type);
  mojo::internal::MessageFragment<
      typename decltype(params->source_frame_token)::BaseType> source_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_source_frame_token,
    source_frame_token_fragment);

  params->source_frame_token.Set(
      source_frame_token_fragment.is_null() ? nullptr : source_frame_token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AdvanceFocusInFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::AdvanceFocusForIME(
    ::blink::mojom::FocusType in_focus_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::AdvanceFocusForIME", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_type"), in_focus_type,
                        "<value of type ::blink::mojom::FocusType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kAdvanceFocusForIME), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_AdvanceFocusForIME_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FocusType>(
    in_focus_type,
    &params->focus_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AdvanceFocusForIME");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::ReportContentSecurityPolicyViolation(
    ::network::mojom::CSPViolationPtr in_violation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("violation"), in_violation,
                        "<value of type ::network::mojom::CSPViolationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kReportContentSecurityPolicyViolation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->violation)::BaseType> violation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CSPViolationDataView>(
    in_violation,
    violation_fragment);

  params->violation.Set(
      violation_fragment.is_null() ? nullptr : violation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->violation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null violation in LocalFrame.ReportContentSecurityPolicyViolation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ReportContentSecurityPolicyViolation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::DidUpdateFramePolicy(
    const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::DidUpdateFramePolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy,
                        "<value of type const ::blink::FramePolicy&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kDidUpdateFramePolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_DidUpdateFramePolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
    in_frame_policy,
    frame_policy_fragment);

  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_policy in LocalFrame.DidUpdateFramePolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("DidUpdateFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::OnFrameVisibilityChanged(
    ::blink::mojom::FrameVisibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::OnFrameVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility"), in_visibility,
                        "<value of type ::blink::mojom::FrameVisibility>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kOnFrameVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_OnFrameVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FrameVisibility>(
    in_visibility,
    &params->visibility);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("OnFrameVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::PostMessageEvent(
    const std::optional<::blink::RemoteFrameToken>& in_source_frame_token, const std::optional<::url::Origin>& in_source_origin, const std::optional<::url::Origin>& in_target_origin, ::blink::TransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::PostMessageEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_frame_token"), in_source_frame_token,
                        "<value of type const std::optional<::blink::RemoteFrameToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const std::optional<::url::Origin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_origin"), in_target_origin,
                        "<value of type const std::optional<::url::Origin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::TransferableMessage>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kPostMessageEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_PostMessageEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_frame_token)::BaseType> source_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_source_frame_token,
    source_frame_token_fragment);

  params->source_frame_token.Set(
      source_frame_token_fragment.is_null() ? nullptr : source_frame_token_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_source_origin,
    source_origin_fragment);

  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->target_origin)::BaseType> target_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_target_origin,
    target_origin_fragment);

  params->target_origin.Set(
      target_origin_fragment.is_null() ? nullptr : target_origin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in LocalFrame.PostMessageEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("PostMessageEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::JavaScriptMethodExecuteRequest(
    const ::std::u16string& in_object_name, const ::std::u16string& in_method_name, ::base::Value::List in_arguments, bool in_wants_result, JavaScriptMethodExecuteRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::JavaScriptMethodExecuteRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_name"), in_object_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_name"), in_method_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("arguments"), in_arguments,
                        "<value of type ::base::Value::List>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptMethodExecuteRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->object_name)::BaseType> object_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_object_name,
    object_name_fragment);

  params->object_name.Set(
      object_name_fragment.is_null() ? nullptr : object_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->object_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null object_name in LocalFrame.JavaScriptMethodExecuteRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->method_name)::BaseType> method_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_method_name,
    method_name_fragment);

  params->method_name.Set(
      method_name_fragment.is_null() ? nullptr : method_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->method_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null method_name in LocalFrame.JavaScriptMethodExecuteRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->arguments)::BaseType> arguments_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
    in_arguments,
    arguments_fragment);

  params->arguments.Set(
      arguments_fragment.is_null() ? nullptr : arguments_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->arguments.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null arguments in LocalFrame.JavaScriptMethodExecuteRequest request");

  params->wants_result = in_wants_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptMethodExecuteRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::JavaScriptExecuteRequest(
    const ::std::u16string& in_javascript, bool in_wants_result, JavaScriptExecuteRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::JavaScriptExecuteRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptExecuteRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_javascript,
    javascript_fragment);

  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->javascript.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null javascript in LocalFrame.JavaScriptExecuteRequest request");

  params->wants_result = in_wants_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptExecuteRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::JavaScriptExecuteRequestForTests(
    const ::std::u16string& in_javascript, bool in_has_user_gesture, bool in_resolve_promises, bool in_honor_js_content_settings, int32_t in_world_id, JavaScriptExecuteRequestForTestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::JavaScriptExecuteRequestForTests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_user_gesture"), in_has_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolve_promises"), in_resolve_promises,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("honor_js_content_settings"), in_honor_js_content_settings,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("world_id"), in_world_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptExecuteRequestForTests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_javascript,
    javascript_fragment);

  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->javascript.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null javascript in LocalFrame.JavaScriptExecuteRequestForTests request");

  params->has_user_gesture = in_has_user_gesture;

  params->resolve_promises = in_resolve_promises;

  params->honor_js_content_settings = in_honor_js_content_settings;

  params->world_id = in_world_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequestForTests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::JavaScriptExecuteRequestInIsolatedWorld(
    const ::std::u16string& in_javascript, bool in_wants_result, int32_t in_world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorld", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("world_id"), in_world_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptExecuteRequestInIsolatedWorld), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_javascript,
    javascript_fragment);

  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->javascript.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null javascript in LocalFrame.JavaScriptExecuteRequestInIsolatedWorld request");

  params->wants_result = in_wants_result;

  params->world_id = in_world_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequestInIsolatedWorld");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::JavaScriptAwaitPromise(
    const ::std::u16string& in_javascript, int32_t in_world_id, JavaScriptAwaitPromiseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::JavaScriptAwaitPromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("world_id"), in_world_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptAwaitPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptAwaitPromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_javascript,
    javascript_fragment);

  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->javascript.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null javascript in LocalFrame.JavaScriptAwaitPromise request");

  params->world_id = in_world_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptAwaitPromise");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptAwaitPromise_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::GetCharacterIndexAtPoint(
    const ::gfx::Point& in_location) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::GetCharacterIndexAtPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location"), in_location,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetCharacterIndexAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetCharacterIndexAtPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->location)::BaseType> location_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_location,
    location_fragment);

  params->location.Set(
      location_fragment.is_null() ? nullptr : location_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->location.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null location in LocalFrame.GetCharacterIndexAtPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetCharacterIndexAtPoint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::GetFirstRectForRange(
    const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::GetFirstRectForRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetFirstRectForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in LocalFrame.GetFirstRectForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetFirstRectForRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::GetStringForRange(
    const ::gfx::Range& in_range, GetStringForRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::GetStringForRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetStringForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetStringForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in LocalFrame.GetStringForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetStringForRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetStringForRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::BindReportingObserver(
    ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::BindReportingObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::ReportingObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kBindReportingObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_BindReportingObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in LocalFrame.BindReportingObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BindReportingObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::UpdateOpener(
    const std::optional<::blink::FrameToken>& in_opener_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::UpdateOpener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame_token"), in_opener_frame_token,
                        "<value of type const std::optional<::blink::FrameToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kUpdateOpener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_UpdateOpener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->opener_frame_token)>
      opener_frame_token_fragment(params.message());
  opener_frame_token_fragment.Claim(&params->opener_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_opener_frame_token,
    opener_frame_token_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("UpdateOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::GetSavableResourceLinks(
    GetSavableResourceLinksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::GetSavableResourceLinks");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetSavableResourceLinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetSavableResourceLinks_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetSavableResourceLinks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetSavableResourceLinks_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::MixedContentFound(
    const ::GURL& in_main_resource_url, const ::GURL& in_mixed_content_url, ::blink::mojom::RequestContextType in_request_context, bool in_was_allowed, const ::GURL& in_url_before_redirects, bool in_had_redirect, ::network::mojom::SourceLocationPtr in_source_location) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::MixedContentFound", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_resource_url"), in_main_resource_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mixed_content_url"), in_mixed_content_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_context"), in_request_context,
                        "<value of type ::blink::mojom::RequestContextType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_allowed"), in_was_allowed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_before_redirects"), in_url_before_redirects,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("had_redirect"), in_had_redirect,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_location"), in_source_location,
                        "<value of type ::network::mojom::SourceLocationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kMixedContentFound), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_MixedContentFound_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->main_resource_url)::BaseType> main_resource_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_main_resource_url,
    main_resource_url_fragment);

  params->main_resource_url.Set(
      main_resource_url_fragment.is_null() ? nullptr : main_resource_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->main_resource_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null main_resource_url in LocalFrame.MixedContentFound request");
  mojo::internal::MessageFragment<
      typename decltype(params->mixed_content_url)::BaseType> mixed_content_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_mixed_content_url,
    mixed_content_url_fragment);

  params->mixed_content_url.Set(
      mixed_content_url_fragment.is_null() ? nullptr : mixed_content_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mixed_content_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mixed_content_url in LocalFrame.MixedContentFound request");

  
  mojo::internal::Serialize<::blink::mojom::RequestContextType>(
    in_request_context,
    &params->request_context);

  params->was_allowed = in_was_allowed;
  mojo::internal::MessageFragment<
      typename decltype(params->url_before_redirects)::BaseType> url_before_redirects_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url_before_redirects,
    url_before_redirects_fragment);

  params->url_before_redirects.Set(
      url_before_redirects_fragment.is_null() ? nullptr : url_before_redirects_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url_before_redirects.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url_before_redirects in LocalFrame.MixedContentFound request");

  params->had_redirect = in_had_redirect;
  mojo::internal::MessageFragment<
      typename decltype(params->source_location)::BaseType> source_location_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
    in_source_location,
    source_location_fragment);

  params->source_location.Set(
      source_location_fragment.is_null() ? nullptr : source_location_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("MixedContentFound");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::BindDevToolsAgent(
    ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> in_agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> in_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::BindDevToolsAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_host"), in_agent_host,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kBindDevToolsAgent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_BindDevToolsAgent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentHostAssociatedPtrInfoDataView>(
    in_agent_host,
    &params->agent_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid agent_host in LocalFrame.BindDevToolsAgent request");

  
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentAssociatedRequestDataView>(
    in_agent,
    &params->agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid agent in LocalFrame.BindDevToolsAgent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BindDevToolsAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::ExtractAnnotatedText(
    uint64_t in_char_count_goal, ExtractAnnotatedTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::ExtractAnnotatedText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_count_goal"), in_char_count_goal,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExtractAnnotatedText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ExtractAnnotatedText_Params_Data> params(
          message);
  params.Allocate();

  params->char_count_goal = in_char_count_goal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExtractAnnotatedText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_ExtractAnnotatedText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::ExtractSerializedDom(
    ExtractSerializedDomCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::ExtractSerializedDom");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExtractSerializedDom), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ExtractSerializedDom_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExtractSerializedDom");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_ExtractSerializedDom_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::ExtractSerializedDomElementInfo(
    const std::string& in_id, ExtractSerializedDomElementInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::ExtractSerializedDomElementInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExtractSerializedDomElementInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ExtractSerializedDomElementInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in LocalFrame.ExtractSerializedDomElementInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExtractSerializedDomElementInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_ExtractSerializedDomElementInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::HandleRendererDebugURL(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::HandleRendererDebugURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kHandleRendererDebugURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_HandleRendererDebugURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LocalFrame.HandleRendererDebugURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("HandleRendererDebugURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::GetCanonicalUrlForSharing(
    GetCanonicalUrlForSharingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::GetCanonicalUrlForSharing");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetCanonicalUrlForSharing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetCanonicalUrlForSharing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetCanonicalUrlForSharing");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::GetOpenGraphMetadata(
    GetOpenGraphMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::GetOpenGraphMetadata");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetOpenGraphMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetOpenGraphMetadata_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetOpenGraphMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetOpenGraphMetadata_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::SetNavigationApiHistoryEntriesForRestore(
    ::blink::mojom::NavigationApiHistoryEntryArraysPtr in_entry_arrays, NavigationApiEntryRestoreReason in_restore_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::SetNavigationApiHistoryEntriesForRestore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry_arrays"), in_entry_arrays,
                        "<value of type ::blink::mojom::NavigationApiHistoryEntryArraysPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("restore_reason"), in_restore_reason,
                        "<value of type NavigationApiEntryRestoreReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSetNavigationApiHistoryEntriesForRestore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entry_arrays)::BaseType> entry_arrays_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NavigationApiHistoryEntryArraysDataView>(
    in_entry_arrays,
    entry_arrays_fragment);

  params->entry_arrays.Set(
      entry_arrays_fragment.is_null() ? nullptr : entry_arrays_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entry_arrays.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entry_arrays in LocalFrame.SetNavigationApiHistoryEntriesForRestore request");

  
  mojo::internal::Serialize<::blink::mojom::NavigationApiEntryRestoreReason>(
    in_restore_reason,
    &params->restore_reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetNavigationApiHistoryEntriesForRestore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::UpdatePrerenderURL(
    const ::GURL& in_matched_url, UpdatePrerenderURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::UpdatePrerenderURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("matched_url"), in_matched_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kUpdatePrerenderURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_UpdatePrerenderURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->matched_url)::BaseType> matched_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_matched_url,
    matched_url_fragment);

  params->matched_url.Set(
      matched_url_fragment.is_null() ? nullptr : matched_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->matched_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null matched_url in LocalFrame.UpdatePrerenderURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("UpdatePrerenderURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_UpdatePrerenderURL_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::NotifyNavigationApiOfDisposedEntries(
    const std::vector<std::string>& in_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::NotifyNavigationApiOfDisposedEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kNotifyNavigationApiOfDisposedEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_keys,
    keys_fragment,
    &keys_validate_params);

  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keys in LocalFrame.NotifyNavigationApiOfDisposedEntries request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyNavigationApiOfDisposedEntries");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::TraverseCancelled(
    const std::string& in_navigation_api_key, TraverseCancelledReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::TraverseCancelled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_api_key"), in_navigation_api_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type TraverseCancelledReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kTraverseCancelled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_TraverseCancelled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->navigation_api_key)::BaseType> navigation_api_key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_navigation_api_key,
    navigation_api_key_fragment);

  params->navigation_api_key.Set(
      navigation_api_key_fragment.is_null() ? nullptr : navigation_api_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->navigation_api_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null navigation_api_key in LocalFrame.TraverseCancelled request");

  
  mojo::internal::Serialize<::blink::mojom::TraverseCancelledReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("TraverseCancelled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::DispatchNavigateEventForCrossDocumentTraversal(
    const ::GURL& in_url, const std::string& in_page_state, bool in_is_browser_initiated) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::DispatchNavigateEventForCrossDocumentTraversal", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_state"), in_page_state,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_browser_initiated"), in_is_browser_initiated,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kDispatchNavigateEventForCrossDocumentTraversal), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LocalFrame.DispatchNavigateEventForCrossDocumentTraversal request");
  mojo::internal::MessageFragment<
      typename decltype(params->page_state)::BaseType> page_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
    in_page_state,
    page_state_fragment);

  params->page_state.Set(
      page_state_fragment.is_null() ? nullptr : page_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_state in LocalFrame.DispatchNavigateEventForCrossDocumentTraversal request");

  params->is_browser_initiated = in_is_browser_initiated;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("DispatchNavigateEventForCrossDocumentTraversal");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::SnapshotDocumentForViewTransition(
    const ::blink::ViewTransitionToken& in_transition_token, ::blink::mojom::PageSwapEventParamsPtr in_page_swap_event_params, SnapshotDocumentForViewTransitionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::SnapshotDocumentForViewTransition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transition_token"), in_transition_token,
                        "<value of type const ::blink::ViewTransitionToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_swap_event_params"), in_page_swap_event_params,
                        "<value of type ::blink::mojom::PageSwapEventParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSnapshotDocumentForViewTransition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SnapshotDocumentForViewTransition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->transition_token)::BaseType> transition_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ViewTransitionTokenDataView>(
    in_transition_token,
    transition_token_fragment);

  params->transition_token.Set(
      transition_token_fragment.is_null() ? nullptr : transition_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->transition_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null transition_token in LocalFrame.SnapshotDocumentForViewTransition request");
  mojo::internal::MessageFragment<
      typename decltype(params->page_swap_event_params)::BaseType> page_swap_event_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PageSwapEventParamsDataView>(
    in_page_swap_event_params,
    page_swap_event_params_fragment);

  params->page_swap_event_params.Set(
      page_swap_event_params_fragment.is_null() ? nullptr : page_swap_event_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_swap_event_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_swap_event_params in LocalFrame.SnapshotDocumentForViewTransition request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SnapshotDocumentForViewTransition");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_SnapshotDocumentForViewTransition_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::NotifyViewTransitionAbortedToOldDocument(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::NotifyViewTransitionAbortedToOldDocument");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kNotifyViewTransitionAbortedToOldDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyViewTransitionAbortedToOldDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::DispatchPageSwap(
    ::blink::mojom::PageSwapEventParamsPtr in_page_swap_event_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::DispatchPageSwap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_swap_event_params"), in_page_swap_event_params,
                        "<value of type ::blink::mojom::PageSwapEventParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kDispatchPageSwap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_DispatchPageSwap_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_swap_event_params)::BaseType> page_swap_event_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PageSwapEventParamsDataView>(
    in_page_swap_event_params,
    page_swap_event_params_fragment);

  params->page_swap_event_params.Set(
      page_swap_event_params_fragment.is_null() ? nullptr : page_swap_event_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("DispatchPageSwap");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::AddResourceTimingEntryForFailedSubframeNavigation(
    const ::blink::FrameToken& in_subframe_token, const ::GURL& in_initial_url, ::base::TimeTicks in_start_time, ::base::TimeTicks in_redirect_time, ::base::TimeTicks in_request_start, ::base::TimeTicks in_response_start, uint32_t in_response_code, const std::string& in_mime_type, const ::net::LoadTimingInfo& in_load_timing_info, ::net::HttpConnectionInfo in_connection_info, const std::string& in_alpn_negotiated_protocol, bool in_is_secure_transport, bool in_is_validated, const std::string& in_normalized_server_timing, const ::network::URLLoaderCompletionStatus& in_completion_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalFrame::AddResourceTimingEntryForFailedSubframeNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subframe_token"), in_subframe_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_url"), in_initial_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_time"), in_start_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("redirect_time"), in_redirect_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_start"), in_request_start,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_start"), in_response_start,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_code"), in_response_code,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("load_timing_info"), in_load_timing_info,
                        "<value of type const ::net::LoadTimingInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_info"), in_connection_info,
                        "<value of type ::net::HttpConnectionInfo>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alpn_negotiated_protocol"), in_alpn_negotiated_protocol,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_secure_transport"), in_is_secure_transport,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_validated"), in_is_validated,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("normalized_server_timing"), in_normalized_server_timing,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completion_status"), in_completion_status,
                        "<value of type const ::network::URLLoaderCompletionStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kAddResourceTimingEntryForFailedSubframeNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->subframe_token)>
      subframe_token_fragment(params.message());
  subframe_token_fragment.Claim(&params->subframe_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_subframe_token,
    subframe_token_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subframe_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subframe_token in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->initial_url)::BaseType> initial_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_initial_url,
    initial_url_fragment);

  params->initial_url.Set(
      initial_url_fragment.is_null() ? nullptr : initial_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->initial_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null initial_url in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->start_time)::BaseType> start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_start_time,
    start_time_fragment);

  params->start_time.Set(
      start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_time in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->redirect_time)::BaseType> redirect_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_redirect_time,
    redirect_time_fragment);

  params->redirect_time.Set(
      redirect_time_fragment.is_null() ? nullptr : redirect_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->redirect_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null redirect_time in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_start)::BaseType> request_start_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_request_start,
    request_start_fragment);

  params->request_start.Set(
      request_start_fragment.is_null() ? nullptr : request_start_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_start.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_start in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->response_start)::BaseType> response_start_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_response_start,
    response_start_fragment);

  params->response_start.Set(
      response_start_fragment.is_null() ? nullptr : response_start_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_start.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_start in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");

  params->response_code = in_response_code;
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_mime_type,
    mime_type_fragment);

  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mime_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mime_type in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->load_timing_info)::BaseType> load_timing_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView>(
    in_load_timing_info,
    load_timing_info_fragment);

  params->load_timing_info.Set(
      load_timing_info_fragment.is_null() ? nullptr : load_timing_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->load_timing_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null load_timing_info in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");

  
  mojo::internal::Serialize<::network::mojom::ConnectionInfo>(
    in_connection_info,
    &params->connection_info);
  mojo::internal::MessageFragment<
      typename decltype(params->alpn_negotiated_protocol)::BaseType> alpn_negotiated_protocol_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_alpn_negotiated_protocol,
    alpn_negotiated_protocol_fragment);

  params->alpn_negotiated_protocol.Set(
      alpn_negotiated_protocol_fragment.is_null() ? nullptr : alpn_negotiated_protocol_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->alpn_negotiated_protocol.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null alpn_negotiated_protocol in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");

  params->is_secure_transport = in_is_secure_transport;

  params->is_validated = in_is_validated;
  mojo::internal::MessageFragment<
      typename decltype(params->normalized_server_timing)::BaseType> normalized_server_timing_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_normalized_server_timing,
    normalized_server_timing_fragment);

  params->normalized_server_timing.Set(
      normalized_server_timing_fragment.is_null() ? nullptr : normalized_server_timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->normalized_server_timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null normalized_server_timing in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->completion_status)::BaseType> completion_status_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
    in_completion_status,
    completion_status_fragment);

  params->completion_status.Set(
      completion_status_fragment.is_null() ? nullptr : completion_status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->completion_status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null completion_status in LocalFrame.AddResourceTimingEntryForFailedSubframeNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AddResourceTimingEntryForFailedSubframeNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::GetScrollPosition(
    GetScrollPositionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalFrame::GetScrollPosition");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetScrollPosition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetScrollPosition_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetScrollPosition");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetScrollPosition_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LocalFrame_GetTextSurroundingSelection_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::GetTextSurroundingSelectionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_GetTextSurroundingSelection_ProxyToResponder> proxy(
        new LocalFrame_GetTextSurroundingSelection_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_GetTextSurroundingSelection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetTextSurroundingSelection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_GetTextSurroundingSelection_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::GetTextSurroundingSelectionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::std::u16string& in_content, uint32_t in_start_offset, uint32_t in_end_offset);
};

bool LocalFrame_GetTextSurroundingSelection_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.0
  bool success = true;
  ::std::u16string p_content{};
  uint32_t p_start_offset{};
  uint32_t p_end_offset{};
  LocalFrame_GetTextSurroundingSelection_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadContent(&p_content))
    success = false;
  if (success)
    p_start_offset = input_data_view.start_offset();
  if (success)
    p_end_offset = input_data_view.end_offset();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_content), 
std::move(p_start_offset), 
std::move(p_end_offset));
  }
  return true;
}

void LocalFrame_GetTextSurroundingSelection_ProxyToResponder::Run(
    const ::std::u16string& in_content, uint32_t in_start_offset, uint32_t in_end_offset) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::GetTextSurroundingSelection", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content"), in_content,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_offset"), in_start_offset,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end_offset"), in_end_offset,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetTextSurroundingSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content)::BaseType> content_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_content,
    content_fragment);

  params->content.Set(
      content_fragment.is_null() ? nullptr : content_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content in ");

  params->start_offset = in_start_offset;

  params->end_offset = in_end_offset;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetTextSurroundingSelection");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_BeforeUnload_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::BeforeUnloadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_BeforeUnload_ProxyToResponder> proxy(
        new LocalFrame_BeforeUnload_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_BeforeUnload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_BeforeUnload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_BeforeUnload_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::BeforeUnloadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time);
};

bool LocalFrame_BeforeUnload_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_BeforeUnload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_BeforeUnload_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.18
  bool success = true;
  bool p_proceed{};
  ::base::TimeTicks p_before_unload_start_time{};
  ::base::TimeTicks p_before_unload_end_time{};
  LocalFrame_BeforeUnload_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proceed = input_data_view.proceed();
  if (success && !input_data_view.ReadBeforeUnloadStartTime(&p_before_unload_start_time))
    success = false;
  if (success && !input_data_view.ReadBeforeUnloadEndTime(&p_before_unload_end_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_proceed), 
std::move(p_before_unload_start_time), 
std::move(p_before_unload_end_time));
  }
  return true;
}

void LocalFrame_BeforeUnload_ProxyToResponder::Run(
    bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::BeforeUnload", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proceed"), in_proceed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before_unload_start_time"), in_before_unload_start_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before_unload_end_time"), in_before_unload_end_time,
                        "<value of type ::base::TimeTicks>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kBeforeUnload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_BeforeUnload_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->proceed = in_proceed;
  mojo::internal::MessageFragment<
      typename decltype(params->before_unload_start_time)::BaseType> before_unload_start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_before_unload_start_time,
    before_unload_start_time_fragment);

  params->before_unload_start_time.Set(
      before_unload_start_time_fragment.is_null() ? nullptr : before_unload_start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->before_unload_start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null before_unload_start_time in ");
  mojo::internal::MessageFragment<
      typename decltype(params->before_unload_end_time)::BaseType> before_unload_end_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_before_unload_end_time,
    before_unload_end_time_fragment);

  params->before_unload_end_time.Set(
      before_unload_end_time_fragment.is_null() ? nullptr : before_unload_end_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->before_unload_end_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null before_unload_end_time in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BeforeUnload");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_RequestVideoFrameAtWithBoundsHint_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::RequestVideoFrameAtWithBoundsHintCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_RequestVideoFrameAtWithBoundsHint_ProxyToResponder> proxy(
        new LocalFrame_RequestVideoFrameAtWithBoundsHint_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_RequestVideoFrameAtWithBoundsHint_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_RequestVideoFrameAtWithBoundsHint_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_RequestVideoFrameAtWithBoundsHint_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::RequestVideoFrameAtWithBoundsHintCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::SkBitmap& in_bitmap, const ::gfx::Rect& in_bounds);
};

bool LocalFrame_RequestVideoFrameAtWithBoundsHint_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.20
  bool success = true;
  ::SkBitmap p_bitmap{};
  ::gfx::Rect p_bounds{};
  LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBitmap(&p_bitmap))
    success = false;
  if (success && !input_data_view.ReadBounds(&p_bounds))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bitmap), 
std::move(p_bounds));
  }
  return true;
}

void LocalFrame_RequestVideoFrameAtWithBoundsHint_ProxyToResponder::Run(
    const ::SkBitmap& in_bitmap, const ::gfx::Rect& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::RequestVideoFrameAtWithBoundsHint", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type const ::SkBitmap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kRequestVideoFrameAtWithBoundsHint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_bitmap,
    bitmap_fragment);

  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("RequestVideoFrameAtWithBoundsHint");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::JavaScriptMethodExecuteRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::JavaScriptMethodExecuteRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);
};

bool LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.28
  bool success = true;
  ::base::Value p_result{};
  LocalFrame_JavaScriptMethodExecuteRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 28, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::JavaScriptMethodExecuteRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptMethodExecuteRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptMethodExecuteRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptExecuteRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::JavaScriptExecuteRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_JavaScriptExecuteRequest_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptExecuteRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_JavaScriptExecuteRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptExecuteRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_JavaScriptExecuteRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::JavaScriptExecuteRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);
};

bool LocalFrame_JavaScriptExecuteRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.29
  bool success = true;
  ::base::Value p_result{};
  LocalFrame_JavaScriptExecuteRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 29, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void LocalFrame_JavaScriptExecuteRequest_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::JavaScriptExecuteRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptExecuteRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::JavaScriptExecuteRequestForTestsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::JavaScriptExecuteRequestForTestsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      JavaScriptExecutionResultType in_result_type, ::base::Value in_result);
};

bool LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.30
  bool success = true;
  JavaScriptExecutionResultType p_result_type{};
  ::base::Value p_result{};
  LocalFrame_JavaScriptExecuteRequestForTests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResultType(&p_result_type))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 30, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result_type), 
std::move(p_result));
  }
  return true;
}

void LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder::Run(
    JavaScriptExecutionResultType in_result_type, ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::JavaScriptExecuteRequestForTests", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_type"), in_result_type,
                        "<value of type JavaScriptExecutionResultType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptExecuteRequestForTests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::JavaScriptExecutionResultType>(
    in_result_type,
    &params->result_type);
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequestForTests");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);
};

bool LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.31
  bool success = true;
  ::base::Value p_result{};
  LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 31, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorld", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptExecuteRequestInIsolatedWorld), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequestInIsolatedWorld");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptAwaitPromise_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::JavaScriptAwaitPromiseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_JavaScriptAwaitPromise_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptAwaitPromise_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_JavaScriptAwaitPromise_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptAwaitPromise_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_JavaScriptAwaitPromise_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::JavaScriptAwaitPromiseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);
};

bool LocalFrame_JavaScriptAwaitPromise_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptAwaitPromise_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptAwaitPromise_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.32
  bool success = true;
  ::base::Value p_result{};
  LocalFrame_JavaScriptAwaitPromise_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 32, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void LocalFrame_JavaScriptAwaitPromise_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::JavaScriptAwaitPromise", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kJavaScriptAwaitPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptAwaitPromise_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptAwaitPromise");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_GetStringForRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::GetStringForRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_GetStringForRange_ProxyToResponder> proxy(
        new LocalFrame_GetStringForRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_GetStringForRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetStringForRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_GetStringForRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::GetStringForRangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::ui::mojom::AttributedStringPtr in_string, const ::gfx::Point& in_baseline_point);
};

bool LocalFrame_GetStringForRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_GetStringForRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetStringForRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.35
  bool success = true;
  ::ui::mojom::AttributedStringPtr p_string{};
  ::gfx::Point p_baseline_point{};
  LocalFrame_GetStringForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadString(&p_string))
    success = false;
  if (success && !input_data_view.ReadBaselinePoint(&p_baseline_point))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 35, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_string), 
std::move(p_baseline_point));
  }
  return true;
}

void LocalFrame_GetStringForRange_ProxyToResponder::Run(
    ::ui::mojom::AttributedStringPtr in_string, const ::gfx::Point& in_baseline_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::GetStringForRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("string"), in_string,
                        "<value of type ::ui::mojom::AttributedStringPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("baseline_point"), in_baseline_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetStringForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetStringForRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->string)::BaseType> string_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::AttributedStringDataView>(
    in_string,
    string_fragment);

  params->string.Set(
      string_fragment.is_null() ? nullptr : string_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->baseline_point)::BaseType> baseline_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_baseline_point,
    baseline_point_fragment);

  params->baseline_point.Set(
      baseline_point_fragment.is_null() ? nullptr : baseline_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->baseline_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null baseline_point in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetStringForRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_GetSavableResourceLinks_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::GetSavableResourceLinksCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_GetSavableResourceLinks_ProxyToResponder> proxy(
        new LocalFrame_GetSavableResourceLinks_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_GetSavableResourceLinks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetSavableResourceLinks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_GetSavableResourceLinks_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::GetSavableResourceLinksCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetSavableResourceLinksReplyPtr in_reply);
};

bool LocalFrame_GetSavableResourceLinks_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.38
  bool success = true;
  GetSavableResourceLinksReplyPtr p_reply{};
  LocalFrame_GetSavableResourceLinks_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 38, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_reply));
  }
  return true;
}

void LocalFrame_GetSavableResourceLinks_ProxyToResponder::Run(
    GetSavableResourceLinksReplyPtr in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::GetSavableResourceLinks", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply,
                        "<value of type GetSavableResourceLinksReplyPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetSavableResourceLinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reply)::BaseType> reply_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::GetSavableResourceLinksReplyDataView>(
    in_reply,
    reply_fragment);

  params->reply.Set(
      reply_fragment.is_null() ? nullptr : reply_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetSavableResourceLinks");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_ExtractAnnotatedText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::ExtractAnnotatedTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_ExtractAnnotatedText_ProxyToResponder> proxy(
        new LocalFrame_ExtractAnnotatedText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_ExtractAnnotatedText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_ExtractAnnotatedText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_ExtractAnnotatedText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::ExtractAnnotatedTextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::std::u16string& in_annotated_text);
};

bool LocalFrame_ExtractAnnotatedText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_ExtractAnnotatedText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_ExtractAnnotatedText_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.41
  bool success = true;
  ::std::u16string p_annotated_text{};
  LocalFrame_ExtractAnnotatedText_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAnnotatedText(&p_annotated_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 41, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_annotated_text));
  }
  return true;
}

void LocalFrame_ExtractAnnotatedText_ProxyToResponder::Run(
    const ::std::u16string& in_annotated_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::ExtractAnnotatedText", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("annotated_text"), in_annotated_text,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExtractAnnotatedText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ExtractAnnotatedText_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->annotated_text)::BaseType> annotated_text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_annotated_text,
    annotated_text_fragment);

  params->annotated_text.Set(
      annotated_text_fragment.is_null() ? nullptr : annotated_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->annotated_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null annotated_text in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExtractAnnotatedText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_ExtractSerializedDom_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::ExtractSerializedDomCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_ExtractSerializedDom_ProxyToResponder> proxy(
        new LocalFrame_ExtractSerializedDom_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_ExtractSerializedDom_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_ExtractSerializedDom_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_ExtractSerializedDom_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::ExtractSerializedDomCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::std::u16string& in_serialized_dom);
};

bool LocalFrame_ExtractSerializedDom_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_ExtractSerializedDom_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_ExtractSerializedDom_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.42
  bool success = true;
  ::std::u16string p_serialized_dom{};
  LocalFrame_ExtractSerializedDom_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSerializedDom(&p_serialized_dom))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 42, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_serialized_dom));
  }
  return true;
}

void LocalFrame_ExtractSerializedDom_ProxyToResponder::Run(
    const ::std::u16string& in_serialized_dom) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::ExtractSerializedDom", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_dom"), in_serialized_dom,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExtractSerializedDom), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ExtractSerializedDom_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_dom)::BaseType> serialized_dom_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_serialized_dom,
    serialized_dom_fragment);

  params->serialized_dom.Set(
      serialized_dom_fragment.is_null() ? nullptr : serialized_dom_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->serialized_dom.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null serialized_dom in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExtractSerializedDom");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_ExtractSerializedDomElementInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::ExtractSerializedDomElementInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_ExtractSerializedDomElementInfo_ProxyToResponder> proxy(
        new LocalFrame_ExtractSerializedDomElementInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_ExtractSerializedDomElementInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_ExtractSerializedDomElementInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_ExtractSerializedDomElementInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::ExtractSerializedDomElementInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SerializedDomElementInfoPtr in_info);
};

bool LocalFrame_ExtractSerializedDomElementInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.43
  bool success = true;
  SerializedDomElementInfoPtr p_info{};
  LocalFrame_ExtractSerializedDomElementInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 43, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void LocalFrame_ExtractSerializedDomElementInfo_ProxyToResponder::Run(
    SerializedDomElementInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::ExtractSerializedDomElementInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type SerializedDomElementInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExtractSerializedDomElementInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SerializedDomElementInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExtractSerializedDomElementInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::GetCanonicalUrlForSharingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder> proxy(
        new LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::GetCanonicalUrlForSharingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::GURL>& in_canonical_url);
};

bool LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.45
  bool success = true;
  std::optional<::GURL> p_canonical_url{};
  LocalFrame_GetCanonicalUrlForSharing_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCanonicalUrl(&p_canonical_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 45, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_canonical_url));
  }
  return true;
}

void LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder::Run(
    const std::optional<::GURL>& in_canonical_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::GetCanonicalUrlForSharing", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("canonical_url"), in_canonical_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetCanonicalUrlForSharing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->canonical_url)::BaseType> canonical_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_canonical_url,
    canonical_url_fragment);

  params->canonical_url.Set(
      canonical_url_fragment.is_null() ? nullptr : canonical_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetCanonicalUrlForSharing");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_GetOpenGraphMetadata_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::GetOpenGraphMetadataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_GetOpenGraphMetadata_ProxyToResponder> proxy(
        new LocalFrame_GetOpenGraphMetadata_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_GetOpenGraphMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetOpenGraphMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_GetOpenGraphMetadata_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::GetOpenGraphMetadataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::OpenGraphMetadataPtr in_metadata);
};

bool LocalFrame_GetOpenGraphMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_GetOpenGraphMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetOpenGraphMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.46
  bool success = true;
  ::blink::mojom::OpenGraphMetadataPtr p_metadata{};
  LocalFrame_GetOpenGraphMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMetadata(&p_metadata))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 46, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_metadata));
  }
  return true;
}

void LocalFrame_GetOpenGraphMetadata_ProxyToResponder::Run(
    ::blink::mojom::OpenGraphMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::GetOpenGraphMetadata", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type ::blink::mojom::OpenGraphMetadataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetOpenGraphMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetOpenGraphMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::OpenGraphMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetOpenGraphMetadata");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_UpdatePrerenderURL_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::UpdatePrerenderURLCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_UpdatePrerenderURL_ProxyToResponder> proxy(
        new LocalFrame_UpdatePrerenderURL_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_UpdatePrerenderURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_UpdatePrerenderURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_UpdatePrerenderURL_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::UpdatePrerenderURLCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalFrame_UpdatePrerenderURL_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_UpdatePrerenderURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_UpdatePrerenderURL_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.48
  bool success = true;
  LocalFrame_UpdatePrerenderURL_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 48, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalFrame_UpdatePrerenderURL_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalFrame::UpdatePrerenderURL");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kUpdatePrerenderURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_UpdatePrerenderURL_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("UpdatePrerenderURL");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_SnapshotDocumentForViewTransition_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::SnapshotDocumentForViewTransitionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_SnapshotDocumentForViewTransition_ProxyToResponder> proxy(
        new LocalFrame_SnapshotDocumentForViewTransition_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_SnapshotDocumentForViewTransition_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_SnapshotDocumentForViewTransition_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_SnapshotDocumentForViewTransition_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::SnapshotDocumentForViewTransitionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::ViewTransitionState& in_view_transition_state);
};

bool LocalFrame_SnapshotDocumentForViewTransition_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.52
  bool success = true;
  ::blink::ViewTransitionState p_view_transition_state{};
  LocalFrame_SnapshotDocumentForViewTransition_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadViewTransitionState(&p_view_transition_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 52, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_view_transition_state));
  }
  return true;
}

void LocalFrame_SnapshotDocumentForViewTransition_ProxyToResponder::Run(
    const ::blink::ViewTransitionState& in_view_transition_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::SnapshotDocumentForViewTransition", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_transition_state"), in_view_transition_state,
                        "<value of type const ::blink::ViewTransitionState&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSnapshotDocumentForViewTransition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->view_transition_state)::BaseType> view_transition_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ViewTransitionStateDataView>(
    in_view_transition_state,
    view_transition_state_fragment);

  params->view_transition_state.Set(
      view_transition_state_fragment.is_null() ? nullptr : view_transition_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->view_transition_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null view_transition_state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SnapshotDocumentForViewTransition");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_GetScrollPosition_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::GetScrollPositionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_GetScrollPosition_ProxyToResponder> proxy(
        new LocalFrame_GetScrollPosition_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_GetScrollPosition_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetScrollPosition_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_GetScrollPosition_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::GetScrollPositionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Point& in_scroll_position);
};

bool LocalFrame_GetScrollPosition_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_GetScrollPosition_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetScrollPosition_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.56
  bool success = true;
  ::gfx::Point p_scroll_position{};
  LocalFrame_GetScrollPosition_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadScrollPosition(&p_scroll_position))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 56, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_scroll_position));
  }
  return true;
}

void LocalFrame_GetScrollPosition_ProxyToResponder::Run(
    const ::gfx::Point& in_scroll_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalFrame::GetScrollPosition", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scroll_position"), in_scroll_position,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kGetScrollPosition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetScrollPosition_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scroll_position)::BaseType> scroll_position_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_scroll_position,
    scroll_position_fragment);

  params->scroll_position.Set(
      scroll_position_fragment.is_null() ? nullptr : scroll_position_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->scroll_position.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null scroll_position in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetScrollPosition");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalFrameStubDispatch::Accept(
    LocalFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LocalFrame>(message->header()->name)) {
    case messages::LocalFrame::kGetTextSurroundingSelection: {
      break;
    }
    case messages::LocalFrame::kSendInterventionReport: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_SendInterventionReport_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SendInterventionReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.1
      bool success = true;
      std::string p_id{};
      std::string p_message{};
      std::optional<::blink::FrameToken> p_child_frame_token{};
      LocalFrame_SendInterventionReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendInterventionReport(        
        std::move(p_id), 
        std::move(p_message), 
        std::move(p_child_frame_token));
      return true;
    }
    case messages::LocalFrame::kSetFrameOwnerProperties: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_SetFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.2
      bool success = true;
      ::blink::mojom::FrameOwnerPropertiesPtr p_properties{};
      LocalFrame_SetFrameOwnerProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameOwnerProperties(        
        std::move(p_properties));
      return true;
    }
    case messages::LocalFrame::kNotifyUserActivation: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyUserActivation_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyUserActivation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.3
      bool success = true;
      ::blink::mojom::UserActivationNotificationType p_notification_type{};
      LocalFrame_NotifyUserActivation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyUserActivation(        
        std::move(p_notification_type));
      return true;
    }
    case messages::LocalFrame::kNotifyVirtualKeyboardOverlayRect: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.4
      bool success = true;
      ::gfx::Rect p_keyboard_rect{};
      LocalFrame_NotifyVirtualKeyboardOverlayRect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyboardRect(&p_keyboard_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyVirtualKeyboardOverlayRect(        
        std::move(p_keyboard_rect));
      return true;
    }
    case messages::LocalFrame::kShowInterestInElement: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_ShowInterestInElement_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ShowInterestInElement_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.5
      bool success = true;
      int32_t p_nodeID{};
      LocalFrame_ShowInterestInElement_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_nodeID = input_data_view.nodeID();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowInterestInElement(        
        std::move(p_nodeID));
      return true;
    }
    case messages::LocalFrame::kAddMessageToConsole: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_AddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.6
      bool success = true;
      ::blink::mojom::ConsoleMessageLevel p_level{};
      std::string p_message{};
      bool p_discard_duplicates{};
      LocalFrame_AddMessageToConsole_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success)
        p_discard_duplicates = input_data_view.discard_duplicates();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMessageToConsole(        
        std::move(p_level), 
        std::move(p_message), 
        std::move(p_discard_duplicates));
      return true;
    }
    case messages::LocalFrame::kSwapInImmediately: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_SwapInImmediately_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SwapInImmediately_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.7
      bool success = true;
      LocalFrame_SwapInImmediately_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwapInImmediately(        );
      return true;
    }
    case messages::LocalFrame::kCheckCompleted: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_CheckCompleted_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_CheckCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.8
      bool success = true;
      LocalFrame_CheckCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckCompleted(        );
      return true;
    }
    case messages::LocalFrame::kStopLoading: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_StopLoading_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_StopLoading_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.9
      bool success = true;
      LocalFrame_StopLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopLoading(        );
      return true;
    }
    case messages::LocalFrame::kCollapse: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_Collapse_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_Collapse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.10
      bool success = true;
      bool p_collapsed{};
      LocalFrame_Collapse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_collapsed = input_data_view.collapsed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Collapse(        
        std::move(p_collapsed));
      return true;
    }
    case messages::LocalFrame::kEnableViewSourceMode: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_EnableViewSourceMode_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_EnableViewSourceMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.11
      bool success = true;
      LocalFrame_EnableViewSourceMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableViewSourceMode(        );
      return true;
    }
    case messages::LocalFrame::kFocus: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_Focus_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_Focus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.12
      bool success = true;
      LocalFrame_Focus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Focus(        );
      return true;
    }
    case messages::LocalFrame::kClearFocusedElement: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_ClearFocusedElement_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ClearFocusedElement_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.13
      bool success = true;
      LocalFrame_ClearFocusedElement_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearFocusedElement(        );
      return true;
    }
    case messages::LocalFrame::kCopyImageAt: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_CopyImageAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_CopyImageAt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.14
      bool success = true;
      ::gfx::Point p_window_point{};
      LocalFrame_CopyImageAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowPoint(&p_window_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyImageAt(        
        std::move(p_window_point));
      return true;
    }
    case messages::LocalFrame::kSaveImageAt: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_SaveImageAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SaveImageAt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.15
      bool success = true;
      ::gfx::Point p_window_point{};
      LocalFrame_SaveImageAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowPoint(&p_window_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveImageAt(        
        std::move(p_window_point));
      return true;
    }
    case messages::LocalFrame::kReportBlinkFeatureUsage: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.16
      bool success = true;
      std::vector<::blink::mojom::WebFeature> p_features{};
      LocalFrame_ReportBlinkFeatureUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportBlinkFeatureUsage(        
        std::move(p_features));
      return true;
    }
    case messages::LocalFrame::kRenderFallbackContent: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_RenderFallbackContent_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_RenderFallbackContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.17
      bool success = true;
      LocalFrame_RenderFallbackContent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContent(        );
      return true;
    }
    case messages::LocalFrame::kBeforeUnload: {
      break;
    }
    case messages::LocalFrame::kMediaPlayerActionAt: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_MediaPlayerActionAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_MediaPlayerActionAt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.19
      bool success = true;
      ::gfx::Point p_location{};
      ::blink::mojom::MediaPlayerActionPtr p_action{};
      LocalFrame_MediaPlayerActionAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaPlayerActionAt(        
        std::move(p_location), 
        std::move(p_action));
      return true;
    }
    case messages::LocalFrame::kRequestVideoFrameAtWithBoundsHint: {
      break;
    }
    case messages::LocalFrame::kPluginActionAt: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_PluginActionAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_PluginActionAt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.21
      bool success = true;
      ::gfx::Point p_location{};
      PluginActionType p_action{};
      LocalFrame_PluginActionAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PluginActionAt(        
        std::move(p_location), 
        std::move(p_action));
      return true;
    }
    case messages::LocalFrame::kAdvanceFocusInFrame: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_AdvanceFocusInFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AdvanceFocusInFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.22
      bool success = true;
      ::blink::mojom::FocusType p_focus_type{};
      std::optional<::blink::RemoteFrameToken> p_source_frame_token{};
      LocalFrame_AdvanceFocusInFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocusInFrame(        
        std::move(p_focus_type), 
        std::move(p_source_frame_token));
      return true;
    }
    case messages::LocalFrame::kAdvanceFocusForIME: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_AdvanceFocusForIME_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AdvanceFocusForIME_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.23
      bool success = true;
      ::blink::mojom::FocusType p_focus_type{};
      LocalFrame_AdvanceFocusForIME_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocusForIME(        
        std::move(p_focus_type));
      return true;
    }
    case messages::LocalFrame::kReportContentSecurityPolicyViolation: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.24
      bool success = true;
      ::network::mojom::CSPViolationPtr p_violation{};
      LocalFrame_ReportContentSecurityPolicyViolation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadViolation(&p_violation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportContentSecurityPolicyViolation(        
        std::move(p_violation));
      return true;
    }
    case messages::LocalFrame::kDidUpdateFramePolicy: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_DidUpdateFramePolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_DidUpdateFramePolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.25
      bool success = true;
      ::blink::FramePolicy p_frame_policy{};
      LocalFrame_DidUpdateFramePolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateFramePolicy(        
        std::move(p_frame_policy));
      return true;
    }
    case messages::LocalFrame::kOnFrameVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_OnFrameVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_OnFrameVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.26
      bool success = true;
      ::blink::mojom::FrameVisibility p_visibility{};
      LocalFrame_OnFrameVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameVisibilityChanged(        
        std::move(p_visibility));
      return true;
    }
    case messages::LocalFrame::kPostMessageEvent: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_PostMessageEvent_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_PostMessageEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.27
      bool success = true;
      std::optional<::blink::RemoteFrameToken> p_source_frame_token{};
      std::optional<::url::Origin> p_source_origin{};
      std::optional<::url::Origin> p_target_origin{};
      ::blink::TransferableMessage p_message{};
      LocalFrame_PostMessageEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success && !input_data_view.ReadTargetOrigin(&p_target_origin))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageEvent(        
        std::move(p_source_frame_token), 
        std::move(p_source_origin), 
        std::move(p_target_origin), 
        std::move(p_message));
      return true;
    }
    case messages::LocalFrame::kJavaScriptMethodExecuteRequest: {
      break;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequest: {
      break;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequestForTests: {
      break;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequestInIsolatedWorld: {
      break;
    }
    case messages::LocalFrame::kJavaScriptAwaitPromise: {
      break;
    }
    case messages::LocalFrame::kGetCharacterIndexAtPoint: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_GetCharacterIndexAtPoint_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_GetCharacterIndexAtPoint_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.33
      bool success = true;
      ::gfx::Point p_location{};
      LocalFrame_GetCharacterIndexAtPoint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCharacterIndexAtPoint(        
        std::move(p_location));
      return true;
    }
    case messages::LocalFrame::kGetFirstRectForRange: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_GetFirstRectForRange_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_GetFirstRectForRange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.34
      bool success = true;
      ::gfx::Range p_range{};
      LocalFrame_GetFirstRectForRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFirstRectForRange(        
        std::move(p_range));
      return true;
    }
    case messages::LocalFrame::kGetStringForRange: {
      break;
    }
    case messages::LocalFrame::kBindReportingObserver: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_BindReportingObserver_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_BindReportingObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.36
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> p_receiver{};
      LocalFrame_BindReportingObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReportingObserver(        
        std::move(p_receiver));
      return true;
    }
    case messages::LocalFrame::kUpdateOpener: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_UpdateOpener_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_UpdateOpener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.37
      bool success = true;
      std::optional<::blink::FrameToken> p_opener_frame_token{};
      LocalFrame_UpdateOpener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 37, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateOpener(        
        std::move(p_opener_frame_token));
      return true;
    }
    case messages::LocalFrame::kGetSavableResourceLinks: {
      break;
    }
    case messages::LocalFrame::kMixedContentFound: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_MixedContentFound_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_MixedContentFound_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.39
      bool success = true;
      ::GURL p_main_resource_url{};
      ::GURL p_mixed_content_url{};
      ::blink::mojom::RequestContextType p_request_context{};
      bool p_was_allowed{};
      ::GURL p_url_before_redirects{};
      bool p_had_redirect{};
      ::network::mojom::SourceLocationPtr p_source_location{};
      LocalFrame_MixedContentFound_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMainResourceUrl(&p_main_resource_url))
        success = false;
      if (success && !input_data_view.ReadMixedContentUrl(&p_mixed_content_url))
        success = false;
      if (success && !input_data_view.ReadRequestContext(&p_request_context))
        success = false;
      if (success)
        p_was_allowed = input_data_view.was_allowed();
      if (success && !input_data_view.ReadUrlBeforeRedirects(&p_url_before_redirects))
        success = false;
      if (success)
        p_had_redirect = input_data_view.had_redirect();
      if (success && !input_data_view.ReadSourceLocation(&p_source_location))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 39, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MixedContentFound(        
        std::move(p_main_resource_url), 
        std::move(p_mixed_content_url), 
        std::move(p_request_context), 
        std::move(p_was_allowed), 
        std::move(p_url_before_redirects), 
        std::move(p_had_redirect), 
        std::move(p_source_location));
      return true;
    }
    case messages::LocalFrame::kBindDevToolsAgent: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_BindDevToolsAgent_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_BindDevToolsAgent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.40
      bool success = true;
      ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> p_agent_host{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> p_agent{};
      LocalFrame_BindDevToolsAgent_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 40, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindDevToolsAgent(        
        std::move(p_agent_host), 
        std::move(p_agent));
      return true;
    }
    case messages::LocalFrame::kExtractAnnotatedText: {
      break;
    }
    case messages::LocalFrame::kExtractSerializedDom: {
      break;
    }
    case messages::LocalFrame::kExtractSerializedDomElementInfo: {
      break;
    }
    case messages::LocalFrame::kHandleRendererDebugURL: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_HandleRendererDebugURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_HandleRendererDebugURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.44
      bool success = true;
      ::GURL p_url{};
      LocalFrame_HandleRendererDebugURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 44, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleRendererDebugURL(        
        std::move(p_url));
      return true;
    }
    case messages::LocalFrame::kGetCanonicalUrlForSharing: {
      break;
    }
    case messages::LocalFrame::kGetOpenGraphMetadata: {
      break;
    }
    case messages::LocalFrame::kSetNavigationApiHistoryEntriesForRestore: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.47
      bool success = true;
      ::blink::mojom::NavigationApiHistoryEntryArraysPtr p_entry_arrays{};
      NavigationApiEntryRestoreReason p_restore_reason{};
      LocalFrame_SetNavigationApiHistoryEntriesForRestore_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntryArrays(&p_entry_arrays))
        success = false;
      if (success && !input_data_view.ReadRestoreReason(&p_restore_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 47, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNavigationApiHistoryEntriesForRestore(        
        std::move(p_entry_arrays), 
        std::move(p_restore_reason));
      return true;
    }
    case messages::LocalFrame::kUpdatePrerenderURL: {
      break;
    }
    case messages::LocalFrame::kNotifyNavigationApiOfDisposedEntries: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.49
      bool success = true;
      std::vector<std::string> p_keys{};
      LocalFrame_NotifyNavigationApiOfDisposedEntries_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeys(&p_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 49, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyNavigationApiOfDisposedEntries(        
        std::move(p_keys));
      return true;
    }
    case messages::LocalFrame::kTraverseCancelled: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_TraverseCancelled_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_TraverseCancelled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.50
      bool success = true;
      std::string p_navigation_api_key{};
      TraverseCancelledReason p_reason{};
      LocalFrame_TraverseCancelled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNavigationApiKey(&p_navigation_api_key))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 50, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TraverseCancelled(        
        std::move(p_navigation_api_key), 
        std::move(p_reason));
      return true;
    }
    case messages::LocalFrame::kDispatchNavigateEventForCrossDocumentTraversal: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.51
      bool success = true;
      ::GURL p_url{};
      std::string p_page_state{};
      bool p_is_browser_initiated{};
      LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadPageState(&p_page_state))
        success = false;
      if (success)
        p_is_browser_initiated = input_data_view.is_browser_initiated();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 51, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchNavigateEventForCrossDocumentTraversal(        
        std::move(p_url), 
        std::move(p_page_state), 
        std::move(p_is_browser_initiated));
      return true;
    }
    case messages::LocalFrame::kSnapshotDocumentForViewTransition: {
      break;
    }
    case messages::LocalFrame::kNotifyViewTransitionAbortedToOldDocument: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.53
      bool success = true;
      LocalFrame_NotifyViewTransitionAbortedToOldDocument_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 53, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyViewTransitionAbortedToOldDocument(        );
      return true;
    }
    case messages::LocalFrame::kDispatchPageSwap: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_DispatchPageSwap_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_DispatchPageSwap_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.54
      bool success = true;
      ::blink::mojom::PageSwapEventParamsPtr p_page_swap_event_params{};
      LocalFrame_DispatchPageSwap_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageSwapEventParams(&p_page_swap_event_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 54, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPageSwap(        
        std::move(p_page_swap_event_params));
      return true;
    }
    case messages::LocalFrame::kAddResourceTimingEntryForFailedSubframeNavigation: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.55
      bool success = true;
      ::blink::FrameToken p_subframe_token{};
      ::GURL p_initial_url{};
      ::base::TimeTicks p_start_time{};
      ::base::TimeTicks p_redirect_time{};
      ::base::TimeTicks p_request_start{};
      ::base::TimeTicks p_response_start{};
      uint32_t p_response_code{};
      std::string p_mime_type{};
      ::net::LoadTimingInfo p_load_timing_info{};
      ::net::HttpConnectionInfo p_connection_info{};
      std::string p_alpn_negotiated_protocol{};
      bool p_is_secure_transport{};
      bool p_is_validated{};
      std::string p_normalized_server_timing{};
      ::network::URLLoaderCompletionStatus p_completion_status{};
      LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubframeToken(&p_subframe_token))
        success = false;
      if (success && !input_data_view.ReadInitialUrl(&p_initial_url))
        success = false;
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadRedirectTime(&p_redirect_time))
        success = false;
      if (success && !input_data_view.ReadRequestStart(&p_request_start))
        success = false;
      if (success && !input_data_view.ReadResponseStart(&p_response_start))
        success = false;
      if (success)
        p_response_code = input_data_view.response_code();
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (success && !input_data_view.ReadLoadTimingInfo(&p_load_timing_info))
        success = false;
      if (success && !input_data_view.ReadConnectionInfo(&p_connection_info))
        success = false;
      if (success && !input_data_view.ReadAlpnNegotiatedProtocol(&p_alpn_negotiated_protocol))
        success = false;
      if (success)
        p_is_secure_transport = input_data_view.is_secure_transport();
      if (success)
        p_is_validated = input_data_view.is_validated();
      if (success && !input_data_view.ReadNormalizedServerTiming(&p_normalized_server_timing))
        success = false;
      if (success && !input_data_view.ReadCompletionStatus(&p_completion_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 55, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddResourceTimingEntryForFailedSubframeNavigation(        
        std::move(p_subframe_token), 
        std::move(p_initial_url), 
        std::move(p_start_time), 
        std::move(p_redirect_time), 
        std::move(p_request_start), 
        std::move(p_response_start), 
        std::move(p_response_code), 
        std::move(p_mime_type), 
        std::move(p_load_timing_info), 
        std::move(p_connection_info), 
        std::move(p_alpn_negotiated_protocol), 
        std::move(p_is_secure_transport), 
        std::move(p_is_validated), 
        std::move(p_normalized_server_timing), 
        std::move(p_completion_status));
      return true;
    }
    case messages::LocalFrame::kGetScrollPosition: {
      break;
    }
  }
  return false;
}

// static
bool LocalFrameStubDispatch::AcceptWithResponder(
    LocalFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LocalFrame>(message->header()->name)) {
    case messages::LocalFrame::kGetTextSurroundingSelection: {
      internal::LocalFrame_GetTextSurroundingSelection_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetTextSurroundingSelection_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.0
      bool success = true;
      uint32_t p_max_length{};
      LocalFrame_GetTextSurroundingSelection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_max_length = input_data_view.max_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 0, false);
        return false;
      }
      auto callback =
          LocalFrame_GetTextSurroundingSelection_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTextSurroundingSelection(        
        std::move(p_max_length), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kSendInterventionReport: {
      break;
    }
    case messages::LocalFrame::kSetFrameOwnerProperties: {
      break;
    }
    case messages::LocalFrame::kNotifyUserActivation: {
      break;
    }
    case messages::LocalFrame::kNotifyVirtualKeyboardOverlayRect: {
      break;
    }
    case messages::LocalFrame::kShowInterestInElement: {
      break;
    }
    case messages::LocalFrame::kAddMessageToConsole: {
      break;
    }
    case messages::LocalFrame::kSwapInImmediately: {
      break;
    }
    case messages::LocalFrame::kCheckCompleted: {
      break;
    }
    case messages::LocalFrame::kStopLoading: {
      break;
    }
    case messages::LocalFrame::kCollapse: {
      break;
    }
    case messages::LocalFrame::kEnableViewSourceMode: {
      break;
    }
    case messages::LocalFrame::kFocus: {
      break;
    }
    case messages::LocalFrame::kClearFocusedElement: {
      break;
    }
    case messages::LocalFrame::kCopyImageAt: {
      break;
    }
    case messages::LocalFrame::kSaveImageAt: {
      break;
    }
    case messages::LocalFrame::kReportBlinkFeatureUsage: {
      break;
    }
    case messages::LocalFrame::kRenderFallbackContent: {
      break;
    }
    case messages::LocalFrame::kBeforeUnload: {
      internal::LocalFrame_BeforeUnload_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_BeforeUnload_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.18
      bool success = true;
      bool p_is_reload{};
      LocalFrame_BeforeUnload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 18, false);
        return false;
      }
      auto callback =
          LocalFrame_BeforeUnload_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeforeUnload(        
        std::move(p_is_reload), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kMediaPlayerActionAt: {
      break;
    }
    case messages::LocalFrame::kRequestVideoFrameAtWithBoundsHint: {
      internal::LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.20
      bool success = true;
      ::gfx::Point p_location{};
      ::gfx::Size p_max_size{};
      int32_t p_max_area{};
      LocalFrame_RequestVideoFrameAtWithBoundsHint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (success && !input_data_view.ReadMaxSize(&p_max_size))
        success = false;
      if (success)
        p_max_area = input_data_view.max_area();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 20, false);
        return false;
      }
      auto callback =
          LocalFrame_RequestVideoFrameAtWithBoundsHint_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestVideoFrameAtWithBoundsHint(        
        std::move(p_location), 
        std::move(p_max_size), 
        std::move(p_max_area), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kPluginActionAt: {
      break;
    }
    case messages::LocalFrame::kAdvanceFocusInFrame: {
      break;
    }
    case messages::LocalFrame::kAdvanceFocusForIME: {
      break;
    }
    case messages::LocalFrame::kReportContentSecurityPolicyViolation: {
      break;
    }
    case messages::LocalFrame::kDidUpdateFramePolicy: {
      break;
    }
    case messages::LocalFrame::kOnFrameVisibilityChanged: {
      break;
    }
    case messages::LocalFrame::kPostMessageEvent: {
      break;
    }
    case messages::LocalFrame::kJavaScriptMethodExecuteRequest: {
      internal::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.28
      bool success = true;
      ::std::u16string p_object_name{};
      ::std::u16string p_method_name{};
      ::base::Value::List p_arguments{};
      bool p_wants_result{};
      LocalFrame_JavaScriptMethodExecuteRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadObjectName(&p_object_name))
        success = false;
      if (success && !input_data_view.ReadMethodName(&p_method_name))
        success = false;
      if (success && !input_data_view.ReadArguments(&p_arguments))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 28, false);
        return false;
      }
      auto callback =
          LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptMethodExecuteRequest(        
        std::move(p_object_name), 
        std::move(p_method_name), 
        std::move(p_arguments), 
        std::move(p_wants_result), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequest: {
      internal::LocalFrame_JavaScriptExecuteRequest_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptExecuteRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.29
      bool success = true;
      ::std::u16string p_javascript{};
      bool p_wants_result{};
      LocalFrame_JavaScriptExecuteRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 29, false);
        return false;
      }
      auto callback =
          LocalFrame_JavaScriptExecuteRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequest(        
        std::move(p_javascript), 
        std::move(p_wants_result), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequestForTests: {
      internal::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.30
      bool success = true;
      ::std::u16string p_javascript{};
      bool p_has_user_gesture{};
      bool p_resolve_promises{};
      bool p_honor_js_content_settings{};
      int32_t p_world_id{};
      LocalFrame_JavaScriptExecuteRequestForTests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (success)
        p_resolve_promises = input_data_view.resolve_promises();
      if (success)
        p_honor_js_content_settings = input_data_view.honor_js_content_settings();
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 30, false);
        return false;
      }
      auto callback =
          LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequestForTests(        
        std::move(p_javascript), 
        std::move(p_has_user_gesture), 
        std::move(p_resolve_promises), 
        std::move(p_honor_js_content_settings), 
        std::move(p_world_id), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kJavaScriptExecuteRequestInIsolatedWorld: {
      internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.31
      bool success = true;
      ::std::u16string p_javascript{};
      bool p_wants_result{};
      int32_t p_world_id{};
      LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 31, false);
        return false;
      }
      auto callback =
          LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequestInIsolatedWorld(        
        std::move(p_javascript), 
        std::move(p_wants_result), 
        std::move(p_world_id), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kJavaScriptAwaitPromise: {
      internal::LocalFrame_JavaScriptAwaitPromise_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptAwaitPromise_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.32
      bool success = true;
      ::std::u16string p_javascript{};
      int32_t p_world_id{};
      LocalFrame_JavaScriptAwaitPromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 32, false);
        return false;
      }
      auto callback =
          LocalFrame_JavaScriptAwaitPromise_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptAwaitPromise(        
        std::move(p_javascript), 
        std::move(p_world_id), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kGetCharacterIndexAtPoint: {
      break;
    }
    case messages::LocalFrame::kGetFirstRectForRange: {
      break;
    }
    case messages::LocalFrame::kGetStringForRange: {
      internal::LocalFrame_GetStringForRange_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetStringForRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.35
      bool success = true;
      ::gfx::Range p_range{};
      LocalFrame_GetStringForRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 35, false);
        return false;
      }
      auto callback =
          LocalFrame_GetStringForRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStringForRange(        
        std::move(p_range), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kBindReportingObserver: {
      break;
    }
    case messages::LocalFrame::kUpdateOpener: {
      break;
    }
    case messages::LocalFrame::kGetSavableResourceLinks: {
      internal::LocalFrame_GetSavableResourceLinks_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetSavableResourceLinks_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.38
      bool success = true;
      LocalFrame_GetSavableResourceLinks_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 38, false);
        return false;
      }
      auto callback =
          LocalFrame_GetSavableResourceLinks_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSavableResourceLinks(std::move(callback));
      return true;
    }
    case messages::LocalFrame::kMixedContentFound: {
      break;
    }
    case messages::LocalFrame::kBindDevToolsAgent: {
      break;
    }
    case messages::LocalFrame::kExtractAnnotatedText: {
      internal::LocalFrame_ExtractAnnotatedText_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_ExtractAnnotatedText_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.41
      bool success = true;
      uint64_t p_char_count_goal{};
      LocalFrame_ExtractAnnotatedText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_char_count_goal = input_data_view.char_count_goal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 41, false);
        return false;
      }
      auto callback =
          LocalFrame_ExtractAnnotatedText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractAnnotatedText(        
        std::move(p_char_count_goal), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kExtractSerializedDom: {
      internal::LocalFrame_ExtractSerializedDom_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_ExtractSerializedDom_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.42
      bool success = true;
      LocalFrame_ExtractSerializedDom_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 42, false);
        return false;
      }
      auto callback =
          LocalFrame_ExtractSerializedDom_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractSerializedDom(std::move(callback));
      return true;
    }
    case messages::LocalFrame::kExtractSerializedDomElementInfo: {
      internal::LocalFrame_ExtractSerializedDomElementInfo_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_ExtractSerializedDomElementInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.43
      bool success = true;
      std::string p_id{};
      LocalFrame_ExtractSerializedDomElementInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 43, false);
        return false;
      }
      auto callback =
          LocalFrame_ExtractSerializedDomElementInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractSerializedDomElementInfo(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kHandleRendererDebugURL: {
      break;
    }
    case messages::LocalFrame::kGetCanonicalUrlForSharing: {
      internal::LocalFrame_GetCanonicalUrlForSharing_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetCanonicalUrlForSharing_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.45
      bool success = true;
      LocalFrame_GetCanonicalUrlForSharing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 45, false);
        return false;
      }
      auto callback =
          LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCanonicalUrlForSharing(std::move(callback));
      return true;
    }
    case messages::LocalFrame::kGetOpenGraphMetadata: {
      internal::LocalFrame_GetOpenGraphMetadata_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetOpenGraphMetadata_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.46
      bool success = true;
      LocalFrame_GetOpenGraphMetadata_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 46, false);
        return false;
      }
      auto callback =
          LocalFrame_GetOpenGraphMetadata_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOpenGraphMetadata(std::move(callback));
      return true;
    }
    case messages::LocalFrame::kSetNavigationApiHistoryEntriesForRestore: {
      break;
    }
    case messages::LocalFrame::kUpdatePrerenderURL: {
      internal::LocalFrame_UpdatePrerenderURL_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_UpdatePrerenderURL_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.48
      bool success = true;
      ::GURL p_matched_url{};
      LocalFrame_UpdatePrerenderURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMatchedUrl(&p_matched_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 48, false);
        return false;
      }
      auto callback =
          LocalFrame_UpdatePrerenderURL_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePrerenderURL(        
        std::move(p_matched_url), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kNotifyNavigationApiOfDisposedEntries: {
      break;
    }
    case messages::LocalFrame::kTraverseCancelled: {
      break;
    }
    case messages::LocalFrame::kDispatchNavigateEventForCrossDocumentTraversal: {
      break;
    }
    case messages::LocalFrame::kSnapshotDocumentForViewTransition: {
      internal::LocalFrame_SnapshotDocumentForViewTransition_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_SnapshotDocumentForViewTransition_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.52
      bool success = true;
      ::blink::ViewTransitionToken p_transition_token{};
      ::blink::mojom::PageSwapEventParamsPtr p_page_swap_event_params{};
      LocalFrame_SnapshotDocumentForViewTransition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTransitionToken(&p_transition_token))
        success = false;
      if (success && !input_data_view.ReadPageSwapEventParams(&p_page_swap_event_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 52, false);
        return false;
      }
      auto callback =
          LocalFrame_SnapshotDocumentForViewTransition_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SnapshotDocumentForViewTransition(        
        std::move(p_transition_token), 
        std::move(p_page_swap_event_params), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kNotifyViewTransitionAbortedToOldDocument: {
      break;
    }
    case messages::LocalFrame::kDispatchPageSwap: {
      break;
    }
    case messages::LocalFrame::kAddResourceTimingEntryForFailedSubframeNavigation: {
      break;
    }
    case messages::LocalFrame::kGetScrollPosition: {
      internal::LocalFrame_GetScrollPosition_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetScrollPosition_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.56
      bool success = true;
      LocalFrame_GetScrollPosition_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 56, false);
        return false;
      }
      auto callback =
          LocalFrame_GetScrollPosition_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetScrollPosition(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLocalFrameValidationInfo[] = {
    { &internal::LocalFrame_GetTextSurroundingSelection_Params_Data::Validate,
     &internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data::Validate},
    { &internal::LocalFrame_SendInterventionReport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_SetFrameOwnerProperties_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_NotifyUserActivation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_ShowInterestInElement_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_AddMessageToConsole_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_SwapInImmediately_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_CheckCompleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_StopLoading_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_Collapse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_EnableViewSourceMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_Focus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_ClearFocusedElement_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_CopyImageAt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_SaveImageAt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_RenderFallbackContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_BeforeUnload_Params_Data::Validate,
     &internal::LocalFrame_BeforeUnload_ResponseParams_Data::Validate},
    { &internal::LocalFrame_MediaPlayerActionAt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data::Validate,
     &internal::LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data::Validate},
    { &internal::LocalFrame_PluginActionAt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_AdvanceFocusInFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_AdvanceFocusForIME_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_DidUpdateFramePolicy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_OnFrameVisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_PostMessageEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data::Validate,
     &internal::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data::Validate},
    { &internal::LocalFrame_JavaScriptExecuteRequest_Params_Data::Validate,
     &internal::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data::Validate},
    { &internal::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data::Validate,
     &internal::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data::Validate},
    { &internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::Validate,
     &internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::Validate},
    { &internal::LocalFrame_JavaScriptAwaitPromise_Params_Data::Validate,
     &internal::LocalFrame_JavaScriptAwaitPromise_ResponseParams_Data::Validate},
    { &internal::LocalFrame_GetCharacterIndexAtPoint_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_GetFirstRectForRange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_GetStringForRange_Params_Data::Validate,
     &internal::LocalFrame_GetStringForRange_ResponseParams_Data::Validate},
    { &internal::LocalFrame_BindReportingObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_UpdateOpener_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_GetSavableResourceLinks_Params_Data::Validate,
     &internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data::Validate},
    { &internal::LocalFrame_MixedContentFound_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_BindDevToolsAgent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_ExtractAnnotatedText_Params_Data::Validate,
     &internal::LocalFrame_ExtractAnnotatedText_ResponseParams_Data::Validate},
    { &internal::LocalFrame_ExtractSerializedDom_Params_Data::Validate,
     &internal::LocalFrame_ExtractSerializedDom_ResponseParams_Data::Validate},
    { &internal::LocalFrame_ExtractSerializedDomElementInfo_Params_Data::Validate,
     &internal::LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data::Validate},
    { &internal::LocalFrame_HandleRendererDebugURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_GetCanonicalUrlForSharing_Params_Data::Validate,
     &internal::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data::Validate},
    { &internal::LocalFrame_GetOpenGraphMetadata_Params_Data::Validate,
     &internal::LocalFrame_GetOpenGraphMetadata_ResponseParams_Data::Validate},
    { &internal::LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_UpdatePrerenderURL_Params_Data::Validate,
     &internal::LocalFrame_UpdatePrerenderURL_ResponseParams_Data::Validate},
    { &internal::LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_TraverseCancelled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_SnapshotDocumentForViewTransition_Params_Data::Validate,
     &internal::LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data::Validate},
    { &internal::LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_DispatchPageSwap_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_GetScrollPosition_Params_Data::Validate,
     &internal::LocalFrame_GetScrollPosition_ResponseParams_Data::Validate},
};

bool LocalFrameRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::LocalFrame::Name_,
    kLocalFrameValidationInfo);
}

bool LocalFrameResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::LocalFrame::Name_,
    kLocalFrameValidationInfo);
}
// The declaration includes the definition on other builds.

LocalMainFrame::IPCStableHashFunction LocalMainFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LocalMainFrame>(message.name())) {
    case messages::LocalMainFrame::kAnimateDoubleTapZoom: {
      return &LocalMainFrame::AnimateDoubleTapZoom_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kSetScaleFactor: {
      return &LocalMainFrame::SetScaleFactor_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kClosePage: {
      return &LocalMainFrame::ClosePage_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kGetFullPageSize: {
      return &LocalMainFrame::GetFullPageSize_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kSetInitialFocus: {
      return &LocalMainFrame::SetInitialFocus_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kEnablePreferredSizeChangedMode: {
      return &LocalMainFrame::EnablePreferredSizeChangedMode_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kZoomToFindInPageRect: {
      return &LocalMainFrame::ZoomToFindInPageRect_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kInstallCoopAccessMonitor: {
      return &LocalMainFrame::InstallCoopAccessMonitor_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kUpdateBrowserControlsState: {
      return &LocalMainFrame::UpdateBrowserControlsState_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kSetV8CompileHints: {
      return &LocalMainFrame::SetV8CompileHints_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kDiscard: {
      return &LocalMainFrame::Discard_Sym::IPCStableHash;
    }
    case messages::LocalMainFrame::kFinalizeNavigationConfidence: {
      return &LocalMainFrame::FinalizeNavigationConfidence_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LocalMainFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LocalMainFrame>(message.name())) {
      case messages::LocalMainFrame::kAnimateDoubleTapZoom:
            return "Receive blink::mojom::LocalMainFrame::AnimateDoubleTapZoom";
      case messages::LocalMainFrame::kSetScaleFactor:
            return "Receive blink::mojom::LocalMainFrame::SetScaleFactor";
      case messages::LocalMainFrame::kClosePage:
            return "Receive blink::mojom::LocalMainFrame::ClosePage";
      case messages::LocalMainFrame::kGetFullPageSize:
            return "Receive blink::mojom::LocalMainFrame::GetFullPageSize";
      case messages::LocalMainFrame::kSetInitialFocus:
            return "Receive blink::mojom::LocalMainFrame::SetInitialFocus";
      case messages::LocalMainFrame::kEnablePreferredSizeChangedMode:
            return "Receive blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode";
      case messages::LocalMainFrame::kZoomToFindInPageRect:
            return "Receive blink::mojom::LocalMainFrame::ZoomToFindInPageRect";
      case messages::LocalMainFrame::kInstallCoopAccessMonitor:
            return "Receive blink::mojom::LocalMainFrame::InstallCoopAccessMonitor";
      case messages::LocalMainFrame::kUpdateBrowserControlsState:
            return "Receive blink::mojom::LocalMainFrame::UpdateBrowserControlsState";
      case messages::LocalMainFrame::kSetV8CompileHints:
            return "Receive blink::mojom::LocalMainFrame::SetV8CompileHints";
      case messages::LocalMainFrame::kDiscard:
            return "Receive blink::mojom::LocalMainFrame::Discard";
      case messages::LocalMainFrame::kFinalizeNavigationConfidence:
            return "Receive blink::mojom::LocalMainFrame::FinalizeNavigationConfidence";
    }
  } else {
    switch (static_cast<messages::LocalMainFrame>(message.name())) {
      case messages::LocalMainFrame::kAnimateDoubleTapZoom:
            return "Receive reply blink::mojom::LocalMainFrame::AnimateDoubleTapZoom";
      case messages::LocalMainFrame::kSetScaleFactor:
            return "Receive reply blink::mojom::LocalMainFrame::SetScaleFactor";
      case messages::LocalMainFrame::kClosePage:
            return "Receive reply blink::mojom::LocalMainFrame::ClosePage";
      case messages::LocalMainFrame::kGetFullPageSize:
            return "Receive reply blink::mojom::LocalMainFrame::GetFullPageSize";
      case messages::LocalMainFrame::kSetInitialFocus:
            return "Receive reply blink::mojom::LocalMainFrame::SetInitialFocus";
      case messages::LocalMainFrame::kEnablePreferredSizeChangedMode:
            return "Receive reply blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode";
      case messages::LocalMainFrame::kZoomToFindInPageRect:
            return "Receive reply blink::mojom::LocalMainFrame::ZoomToFindInPageRect";
      case messages::LocalMainFrame::kInstallCoopAccessMonitor:
            return "Receive reply blink::mojom::LocalMainFrame::InstallCoopAccessMonitor";
      case messages::LocalMainFrame::kUpdateBrowserControlsState:
            return "Receive reply blink::mojom::LocalMainFrame::UpdateBrowserControlsState";
      case messages::LocalMainFrame::kSetV8CompileHints:
            return "Receive reply blink::mojom::LocalMainFrame::SetV8CompileHints";
      case messages::LocalMainFrame::kDiscard:
            return "Receive reply blink::mojom::LocalMainFrame::Discard";
      case messages::LocalMainFrame::kFinalizeNavigationConfidence:
            return "Receive reply blink::mojom::LocalMainFrame::FinalizeNavigationConfidence";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LocalMainFrame::AnimateDoubleTapZoom_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6abc3ac6;  // IPCStableHash for blink::mojom::LocalMainFrame::AnimateDoubleTapZoom
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::SetScaleFactor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x36acd654;  // IPCStableHash for blink::mojom::LocalMainFrame::SetScaleFactor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::ClosePage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1dfa5805;  // IPCStableHash for blink::mojom::LocalMainFrame::ClosePage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::GetFullPageSize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6c7a4ab;  // IPCStableHash for blink::mojom::LocalMainFrame::GetFullPageSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::SetInitialFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x041bdfa2;  // IPCStableHash for blink::mojom::LocalMainFrame::SetInitialFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::EnablePreferredSizeChangedMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29c5f7d8;  // IPCStableHash for blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::ZoomToFindInPageRect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x959e3a4b;  // IPCStableHash for blink::mojom::LocalMainFrame::ZoomToFindInPageRect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::InstallCoopAccessMonitor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21c9a2d5;  // IPCStableHash for blink::mojom::LocalMainFrame::InstallCoopAccessMonitor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::UpdateBrowserControlsState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc237f55f;  // IPCStableHash for blink::mojom::LocalMainFrame::UpdateBrowserControlsState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::SetV8CompileHints_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8dcf5d1;  // IPCStableHash for blink::mojom::LocalMainFrame::SetV8CompileHints
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::Discard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x06e4cac3;  // IPCStableHash for blink::mojom::LocalMainFrame::Discard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrame::FinalizeNavigationConfidence_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03566886;  // IPCStableHash for blink::mojom::LocalMainFrame::FinalizeNavigationConfidence
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LocalMainFrame_ClosePage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrame_ClosePage_ForwardToCallback(
      LocalMainFrame::ClosePageCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalMainFrame_ClosePage_ForwardToCallback(const LocalMainFrame_ClosePage_ForwardToCallback&) = delete;
  LocalMainFrame_ClosePage_ForwardToCallback& operator=(const LocalMainFrame_ClosePage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrame::ClosePageCallback callback_;
};

class LocalMainFrame_GetFullPageSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrame_GetFullPageSize_ForwardToCallback(
      LocalMainFrame::GetFullPageSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalMainFrame_GetFullPageSize_ForwardToCallback(const LocalMainFrame_GetFullPageSize_ForwardToCallback&) = delete;
  LocalMainFrame_GetFullPageSize_ForwardToCallback& operator=(const LocalMainFrame_GetFullPageSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrame::GetFullPageSizeCallback callback_;
};

class LocalMainFrame_Discard_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrame_Discard_ForwardToCallback(
      LocalMainFrame::DiscardCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalMainFrame_Discard_ForwardToCallback(const LocalMainFrame_Discard_ForwardToCallback&) = delete;
  LocalMainFrame_Discard_ForwardToCallback& operator=(const LocalMainFrame_Discard_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrame::DiscardCallback callback_;
};

LocalMainFrameProxy::LocalMainFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalMainFrameProxy::AnimateDoubleTapZoom(
    const ::gfx::Point& in_point, const ::gfx::Rect& in_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalMainFrame::AnimateDoubleTapZoom", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kAnimateDoubleTapZoom), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in LocalMainFrame.AnimateDoubleTapZoom request");
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_rect,
    rect_fragment);

  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect in LocalMainFrame.AnimateDoubleTapZoom request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("AnimateDoubleTapZoom");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalMainFrameProxy::SetScaleFactor(
    float in_scale) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalMainFrame::SetScaleFactor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scale"), in_scale,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kSetScaleFactor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_SetScaleFactor_Params_Data> params(
          message);
  params.Allocate();

  params->scale = in_scale;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("SetScaleFactor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalMainFrameProxy::ClosePage(
    ClosePageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalMainFrame::ClosePage");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kClosePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_ClosePage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ClosePage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrame_ClosePage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalMainFrameProxy::GetFullPageSize(
    GetFullPageSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalMainFrame::GetFullPageSize");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kGetFullPageSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_GetFullPageSize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("GetFullPageSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrame_GetFullPageSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalMainFrameProxy::SetInitialFocus(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalMainFrame::SetInitialFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reverse"), in_reverse,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kSetInitialFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_SetInitialFocus_Params_Data> params(
          message);
  params.Allocate();

  params->reverse = in_reverse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("SetInitialFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalMainFrameProxy::EnablePreferredSizeChangedMode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kEnablePreferredSizeChangedMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("EnablePreferredSizeChangedMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalMainFrameProxy::ZoomToFindInPageRect(
    const ::gfx::Rect& in_rect_in_root_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalMainFrame::ZoomToFindInPageRect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect_in_root_frame"), in_rect_in_root_frame,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kZoomToFindInPageRect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect_in_root_frame)::BaseType> rect_in_root_frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_rect_in_root_frame,
    rect_in_root_frame_fragment);

  params->rect_in_root_frame.Set(
      rect_in_root_frame_fragment.is_null() ? nullptr : rect_in_root_frame_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect_in_root_frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect_in_root_frame in LocalMainFrame.ZoomToFindInPageRect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ZoomToFindInPageRect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalMainFrameProxy::InstallCoopAccessMonitor(
    const ::blink::FrameToken& in_accessed_window, ::network::mojom::CrossOriginOpenerPolicyReporterParamsPtr in_coop_reporter_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalMainFrame::InstallCoopAccessMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accessed_window"), in_accessed_window,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("coop_reporter_info"), in_coop_reporter_info,
                        "<value of type ::network::mojom::CrossOriginOpenerPolicyReporterParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kInstallCoopAccessMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->accessed_window)>
      accessed_window_fragment(params.message());
  accessed_window_fragment.Claim(&params->accessed_window);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_accessed_window,
    accessed_window_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->accessed_window.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null accessed_window in LocalMainFrame.InstallCoopAccessMonitor request");
  mojo::internal::MessageFragment<
      typename decltype(params->coop_reporter_info)::BaseType> coop_reporter_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyReporterParamsDataView>(
    in_coop_reporter_info,
    coop_reporter_info_fragment);

  params->coop_reporter_info.Set(
      coop_reporter_info_fragment.is_null() ? nullptr : coop_reporter_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->coop_reporter_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null coop_reporter_info in LocalMainFrame.InstallCoopAccessMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("InstallCoopAccessMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalMainFrameProxy::UpdateBrowserControlsState(
    ::cc::BrowserControlsState in_constraints, ::cc::BrowserControlsState in_current, bool in_animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& in_offset_tag_modifications) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalMainFrame::UpdateBrowserControlsState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constraints"), in_constraints,
                        "<value of type ::cc::BrowserControlsState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current"), in_current,
                        "<value of type ::cc::BrowserControlsState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("animate"), in_animate,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset_tag_modifications"), in_offset_tag_modifications,
                        "<value of type const std::optional<::cc::BrowserControlsOffsetTagModifications>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kUpdateBrowserControlsState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_UpdateBrowserControlsState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::cc::mojom::BrowserControlsState>(
    in_constraints,
    &params->constraints);

  
  mojo::internal::Serialize<::cc::mojom::BrowserControlsState>(
    in_current,
    &params->current);

  params->animate = in_animate;
  mojo::internal::MessageFragment<
      typename decltype(params->offset_tag_modifications)::BaseType> offset_tag_modifications_fragment(
          params.message());
  
  mojo::internal::Serialize<::cc::mojom::BrowserControlsOffsetTagModificationsDataView>(
    in_offset_tag_modifications,
    offset_tag_modifications_fragment);

  params->offset_tag_modifications.Set(
      offset_tag_modifications_fragment.is_null() ? nullptr : offset_tag_modifications_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("UpdateBrowserControlsState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalMainFrameProxy::SetV8CompileHints(
    ::base::ReadOnlySharedMemoryRegion in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalMainFrame::SetV8CompileHints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kSetV8CompileHints), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_SetV8CompileHints_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in LocalMainFrame.SetV8CompileHints request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("SetV8CompileHints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalMainFrameProxy::Discard(
    DiscardCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LocalMainFrame::Discard");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kDiscard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_Discard_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("Discard");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrame_Discard_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalMainFrameProxy::FinalizeNavigationConfidence(
    double in_randomized_trigger_rate, ::blink::mojom::ConfidenceLevel in_confidence) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LocalMainFrame::FinalizeNavigationConfidence", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("randomized_trigger_rate"), in_randomized_trigger_rate,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("confidence"), in_confidence,
                        "<value of type ::blink::mojom::ConfidenceLevel>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kFinalizeNavigationConfidence), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_FinalizeNavigationConfidence_Params_Data> params(
          message);
  params.Allocate();

  params->randomized_trigger_rate = in_randomized_trigger_rate;

  
  mojo::internal::Serialize<::blink::mojom::ConfidenceLevel>(
    in_confidence,
    &params->confidence);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("FinalizeNavigationConfidence");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class LocalMainFrame_ClosePage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalMainFrame::ClosePageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalMainFrame_ClosePage_ProxyToResponder> proxy(
        new LocalMainFrame_ClosePage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalMainFrame_ClosePage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrame_ClosePage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalMainFrame_ClosePage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalMainFrame::ClosePageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalMainFrame_ClosePage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalMainFrame_ClosePage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrame_ClosePage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalMainFrame.2
  bool success = true;
  LocalMainFrame_ClosePage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrame::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalMainFrame_ClosePage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalMainFrame::ClosePage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kClosePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_ClosePage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ClosePage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalMainFrame_GetFullPageSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalMainFrame::GetFullPageSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalMainFrame_GetFullPageSize_ProxyToResponder> proxy(
        new LocalMainFrame_GetFullPageSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalMainFrame_GetFullPageSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrame_GetFullPageSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalMainFrame_GetFullPageSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalMainFrame::GetFullPageSizeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Size& in_full_page_size);
};

bool LocalMainFrame_GetFullPageSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalMainFrame_GetFullPageSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrame_GetFullPageSize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalMainFrame.3
  bool success = true;
  ::gfx::Size p_full_page_size{};
  LocalMainFrame_GetFullPageSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFullPageSize(&p_full_page_size))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrame::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_full_page_size));
  }
  return true;
}

void LocalMainFrame_GetFullPageSize_ProxyToResponder::Run(
    const ::gfx::Size& in_full_page_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LocalMainFrame::GetFullPageSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("full_page_size"), in_full_page_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kGetFullPageSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_GetFullPageSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->full_page_size)::BaseType> full_page_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_full_page_size,
    full_page_size_fragment);

  params->full_page_size.Set(
      full_page_size_fragment.is_null() ? nullptr : full_page_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->full_page_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null full_page_size in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("GetFullPageSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalMainFrame_Discard_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalMainFrame::DiscardCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalMainFrame_Discard_ProxyToResponder> proxy(
        new LocalMainFrame_Discard_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalMainFrame_Discard_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrame_Discard_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalMainFrame_Discard_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalMainFrame::DiscardCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalMainFrame_Discard_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalMainFrame_Discard_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrame_Discard_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalMainFrame.10
  bool success = true;
  LocalMainFrame_Discard_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrame::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalMainFrame_Discard_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::LocalMainFrame::Discard");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalMainFrame::kDiscard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_Discard_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("Discard");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalMainFrameStubDispatch::Accept(
    LocalMainFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LocalMainFrame>(message->header()->name)) {
    case messages::LocalMainFrame::kAnimateDoubleTapZoom: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.0
      bool success = true;
      ::gfx::Point p_point{};
      ::gfx::Rect p_rect{};
      LocalMainFrame_AnimateDoubleTapZoom_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnimateDoubleTapZoom(        
        std::move(p_point), 
        std::move(p_rect));
      return true;
    }
    case messages::LocalMainFrame::kSetScaleFactor: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_SetScaleFactor_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_SetScaleFactor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.1
      bool success = true;
      float p_scale{};
      LocalMainFrame_SetScaleFactor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_scale = input_data_view.scale();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScaleFactor(        
        std::move(p_scale));
      return true;
    }
    case messages::LocalMainFrame::kClosePage: {
      break;
    }
    case messages::LocalMainFrame::kGetFullPageSize: {
      break;
    }
    case messages::LocalMainFrame::kSetInitialFocus: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_SetInitialFocus_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_SetInitialFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.4
      bool success = true;
      bool p_reverse{};
      LocalMainFrame_SetInitialFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInitialFocus(        
        std::move(p_reverse));
      return true;
    }
    case messages::LocalMainFrame::kEnablePreferredSizeChangedMode: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.5
      bool success = true;
      LocalMainFrame_EnablePreferredSizeChangedMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnablePreferredSizeChangedMode(        );
      return true;
    }
    case messages::LocalMainFrame::kZoomToFindInPageRect: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.6
      bool success = true;
      ::gfx::Rect p_rect_in_root_frame{};
      LocalMainFrame_ZoomToFindInPageRect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRectInRootFrame(&p_rect_in_root_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomToFindInPageRect(        
        std::move(p_rect_in_root_frame));
      return true;
    }
    case messages::LocalMainFrame::kInstallCoopAccessMonitor: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.7
      bool success = true;
      ::blink::FrameToken p_accessed_window{};
      ::network::mojom::CrossOriginOpenerPolicyReporterParamsPtr p_coop_reporter_info{};
      LocalMainFrame_InstallCoopAccessMonitor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccessedWindow(&p_accessed_window))
        success = false;
      if (success && !input_data_view.ReadCoopReporterInfo(&p_coop_reporter_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallCoopAccessMonitor(        
        std::move(p_accessed_window), 
        std::move(p_coop_reporter_info));
      return true;
    }
    case messages::LocalMainFrame::kUpdateBrowserControlsState: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_UpdateBrowserControlsState_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_UpdateBrowserControlsState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.8
      bool success = true;
      ::cc::BrowserControlsState p_constraints{};
      ::cc::BrowserControlsState p_current{};
      bool p_animate{};
      std::optional<::cc::BrowserControlsOffsetTagModifications> p_offset_tag_modifications{};
      LocalMainFrame_UpdateBrowserControlsState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConstraints(&p_constraints))
        success = false;
      if (success && !input_data_view.ReadCurrent(&p_current))
        success = false;
      if (success)
        p_animate = input_data_view.animate();
      if (success && !input_data_view.ReadOffsetTagModifications(&p_offset_tag_modifications))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateBrowserControlsState(        
        std::move(p_constraints), 
        std::move(p_current), 
        std::move(p_animate), 
        std::move(p_offset_tag_modifications));
      return true;
    }
    case messages::LocalMainFrame::kSetV8CompileHints: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_SetV8CompileHints_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_SetV8CompileHints_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.9
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_data{};
      LocalMainFrame_SetV8CompileHints_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetV8CompileHints(        
        std::move(p_data));
      return true;
    }
    case messages::LocalMainFrame::kDiscard: {
      break;
    }
    case messages::LocalMainFrame::kFinalizeNavigationConfidence: {
      DCHECK(message->is_serialized());
      internal::LocalMainFrame_FinalizeNavigationConfidence_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_FinalizeNavigationConfidence_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalMainFrame.11
      bool success = true;
      double p_randomized_trigger_rate{};
      ::blink::mojom::ConfidenceLevel p_confidence{};
      LocalMainFrame_FinalizeNavigationConfidence_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_randomized_trigger_rate = input_data_view.randomized_trigger_rate();
      if (success && !input_data_view.ReadConfidence(&p_confidence))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FinalizeNavigationConfidence(        
        std::move(p_randomized_trigger_rate), 
        std::move(p_confidence));
      return true;
    }
  }
  return false;
}

// static
bool LocalMainFrameStubDispatch::AcceptWithResponder(
    LocalMainFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LocalMainFrame>(message->header()->name)) {
    case messages::LocalMainFrame::kAnimateDoubleTapZoom: {
      break;
    }
    case messages::LocalMainFrame::kSetScaleFactor: {
      break;
    }
    case messages::LocalMainFrame::kClosePage: {
      internal::LocalMainFrame_ClosePage_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrame_ClosePage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalMainFrame.2
      bool success = true;
      LocalMainFrame_ClosePage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 2, false);
        return false;
      }
      auto callback =
          LocalMainFrame_ClosePage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClosePage(std::move(callback));
      return true;
    }
    case messages::LocalMainFrame::kGetFullPageSize: {
      internal::LocalMainFrame_GetFullPageSize_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrame_GetFullPageSize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalMainFrame.3
      bool success = true;
      LocalMainFrame_GetFullPageSize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 3, false);
        return false;
      }
      auto callback =
          LocalMainFrame_GetFullPageSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFullPageSize(std::move(callback));
      return true;
    }
    case messages::LocalMainFrame::kSetInitialFocus: {
      break;
    }
    case messages::LocalMainFrame::kEnablePreferredSizeChangedMode: {
      break;
    }
    case messages::LocalMainFrame::kZoomToFindInPageRect: {
      break;
    }
    case messages::LocalMainFrame::kInstallCoopAccessMonitor: {
      break;
    }
    case messages::LocalMainFrame::kUpdateBrowserControlsState: {
      break;
    }
    case messages::LocalMainFrame::kSetV8CompileHints: {
      break;
    }
    case messages::LocalMainFrame::kDiscard: {
      internal::LocalMainFrame_Discard_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrame_Discard_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalMainFrame.10
      bool success = true;
      LocalMainFrame_Discard_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 10, false);
        return false;
      }
      auto callback =
          LocalMainFrame_Discard_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Discard(std::move(callback));
      return true;
    }
    case messages::LocalMainFrame::kFinalizeNavigationConfidence: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLocalMainFrameValidationInfo[] = {
    { &internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalMainFrame_SetScaleFactor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalMainFrame_ClosePage_Params_Data::Validate,
     &internal::LocalMainFrame_ClosePage_ResponseParams_Data::Validate},
    { &internal::LocalMainFrame_GetFullPageSize_Params_Data::Validate,
     &internal::LocalMainFrame_GetFullPageSize_ResponseParams_Data::Validate},
    { &internal::LocalMainFrame_SetInitialFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalMainFrame_UpdateBrowserControlsState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalMainFrame_SetV8CompileHints_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalMainFrame_Discard_Params_Data::Validate,
     &internal::LocalMainFrame_Discard_ResponseParams_Data::Validate},
    { &internal::LocalMainFrame_FinalizeNavigationConfidence_Params_Data::Validate,
     nullptr /* no response */},
};

bool LocalMainFrameRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::LocalMainFrame::Name_,
    kLocalMainFrameValidationInfo);
}

bool LocalMainFrameResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::LocalMainFrame::Name_,
    kLocalMainFrameValidationInfo);
}
// The declaration includes the definition on other builds.

LocalMainFrameHost::IPCStableHashFunction LocalMainFrameHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LocalMainFrameHost>(message.name())) {
    case messages::LocalMainFrameHost::kScaleFactorChanged: {
      return &LocalMainFrameHost::ScaleFactorChanged_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kContentsPreferredSizeChanged: {
      return &LocalMainFrameHost::ContentsPreferredSizeChanged_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kTextAutosizerPageInfoChanged: {
      return &LocalMainFrameHost::TextAutosizerPageInfoChanged_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kFocusPage: {
      return &LocalMainFrameHost::FocusPage_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kTakeFocus: {
      return &LocalMainFrameHost::TakeFocus_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kUpdateTargetURL: {
      return &LocalMainFrameHost::UpdateTargetURL_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kRequestClose: {
      return &LocalMainFrameHost::RequestClose_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kShowCreatedWindow: {
      return &LocalMainFrameHost::ShowCreatedWindow_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kSetWindowRect: {
      return &LocalMainFrameHost::SetWindowRect_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kDidFirstVisuallyNonEmptyPaint: {
      return &LocalMainFrameHost::DidFirstVisuallyNonEmptyPaint_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kDidAccessInitialMainDocument: {
      return &LocalMainFrameHost::DidAccessInitialMainDocument_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kMaximize: {
      return &LocalMainFrameHost::Maximize_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kMinimize: {
      return &LocalMainFrameHost::Minimize_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kRestore: {
      return &LocalMainFrameHost::Restore_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kSetResizable: {
      return &LocalMainFrameHost::SetResizable_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kDraggableRegionsChanged: {
      return &LocalMainFrameHost::DraggableRegionsChanged_Sym::IPCStableHash;
    }
    case messages::LocalMainFrameHost::kOnFirstContentfulPaint: {
      return &LocalMainFrameHost::OnFirstContentfulPaint_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LocalMainFrameHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LocalMainFrameHost>(message.name())) {
      case messages::LocalMainFrameHost::kScaleFactorChanged:
            return "Receive blink::mojom::LocalMainFrameHost::ScaleFactorChanged";
      case messages::LocalMainFrameHost::kContentsPreferredSizeChanged:
            return "Receive blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged";
      case messages::LocalMainFrameHost::kTextAutosizerPageInfoChanged:
            return "Receive blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged";
      case messages::LocalMainFrameHost::kFocusPage:
            return "Receive blink::mojom::LocalMainFrameHost::FocusPage";
      case messages::LocalMainFrameHost::kTakeFocus:
            return "Receive blink::mojom::LocalMainFrameHost::TakeFocus";
      case messages::LocalMainFrameHost::kUpdateTargetURL:
            return "Receive blink::mojom::LocalMainFrameHost::UpdateTargetURL";
      case messages::LocalMainFrameHost::kRequestClose:
            return "Receive blink::mojom::LocalMainFrameHost::RequestClose";
      case messages::LocalMainFrameHost::kShowCreatedWindow:
            return "Receive blink::mojom::LocalMainFrameHost::ShowCreatedWindow";
      case messages::LocalMainFrameHost::kSetWindowRect:
            return "Receive blink::mojom::LocalMainFrameHost::SetWindowRect";
      case messages::LocalMainFrameHost::kDidFirstVisuallyNonEmptyPaint:
            return "Receive blink::mojom::LocalMainFrameHost::DidFirstVisuallyNonEmptyPaint";
      case messages::LocalMainFrameHost::kDidAccessInitialMainDocument:
            return "Receive blink::mojom::LocalMainFrameHost::DidAccessInitialMainDocument";
      case messages::LocalMainFrameHost::kMaximize:
            return "Receive blink::mojom::LocalMainFrameHost::Maximize";
      case messages::LocalMainFrameHost::kMinimize:
            return "Receive blink::mojom::LocalMainFrameHost::Minimize";
      case messages::LocalMainFrameHost::kRestore:
            return "Receive blink::mojom::LocalMainFrameHost::Restore";
      case messages::LocalMainFrameHost::kSetResizable:
            return "Receive blink::mojom::LocalMainFrameHost::SetResizable";
      case messages::LocalMainFrameHost::kDraggableRegionsChanged:
            return "Receive blink::mojom::LocalMainFrameHost::DraggableRegionsChanged";
      case messages::LocalMainFrameHost::kOnFirstContentfulPaint:
            return "Receive blink::mojom::LocalMainFrameHost::OnFirstContentfulPaint";
    }
  } else {
    switch (static_cast<messages::LocalMainFrameHost>(message.name())) {
      case messages::LocalMainFrameHost::kScaleFactorChanged:
            return "Receive reply blink::mojom::LocalMainFrameHost::ScaleFactorChanged";
      case messages::LocalMainFrameHost::kContentsPreferredSizeChanged:
            return "Receive reply blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged";
      case messages::LocalMainFrameHost::kTextAutosizerPageInfoChanged:
            return "Receive reply blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged";
      case messages::LocalMainFrameHost::kFocusPage:
            return "Receive reply blink::mojom::LocalMainFrameHost::FocusPage";
      case messages::LocalMainFrameHost::kTakeFocus:
            return "Receive reply blink::mojom::LocalMainFrameHost::TakeFocus";
      case messages::LocalMainFrameHost::kUpdateTargetURL:
            return "Receive reply blink::mojom::LocalMainFrameHost::UpdateTargetURL";
      case messages::LocalMainFrameHost::kRequestClose:
            return "Receive reply blink::mojom::LocalMainFrameHost::RequestClose";
      case messages::LocalMainFrameHost::kShowCreatedWindow:
            return "Receive reply blink::mojom::LocalMainFrameHost::ShowCreatedWindow";
      case messages::LocalMainFrameHost::kSetWindowRect:
            return "Receive reply blink::mojom::LocalMainFrameHost::SetWindowRect";
      case messages::LocalMainFrameHost::kDidFirstVisuallyNonEmptyPaint:
            return "Receive reply blink::mojom::LocalMainFrameHost::DidFirstVisuallyNonEmptyPaint";
      case messages::LocalMainFrameHost::kDidAccessInitialMainDocument:
            return "Receive reply blink::mojom::LocalMainFrameHost::DidAccessInitialMainDocument";
      case messages::LocalMainFrameHost::kMaximize:
            return "Receive reply blink::mojom::LocalMainFrameHost::Maximize";
      case messages::LocalMainFrameHost::kMinimize:
            return "Receive reply blink::mojom::LocalMainFrameHost::Minimize";
      case messages::LocalMainFrameHost::kRestore:
            return "Receive reply blink::mojom::LocalMainFrameHost::Restore";
      case messages::LocalMainFrameHost::kSetResizable:
            return "Receive reply blink::mojom::LocalMainFrameHost::SetResizable";
      case messages::LocalMainFrameHost::kDraggableRegionsChanged:
            return "Receive reply blink::mojom::LocalMainFrameHost::DraggableRegionsChanged";
      case messages::LocalMainFrameHost::kOnFirstContentfulPaint:
            return "Receive reply blink::mojom::LocalMainFrameHost::OnFirstContentfulPaint";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LocalMainFrameHost::ScaleFactorChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8e79dc7;  // IPCStableHash for blink::mojom::LocalMainFrameHost::ScaleFactorChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::ContentsPreferredSizeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1829fe7;  // IPCStableHash for blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::TextAutosizerPageInfoChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41452bd9;  // IPCStableHash for blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::FocusPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a074438;  // IPCStableHash for blink::mojom::LocalMainFrameHost::FocusPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::TakeFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x075c93df;  // IPCStableHash for blink::mojom::LocalMainFrameHost::TakeFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::UpdateTargetURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50272ab3;  // IPCStableHash for blink::mojom::LocalMainFrameHost::UpdateTargetURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::RequestClose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x768e72fb;  // IPCStableHash for blink::mojom::LocalMainFrameHost::RequestClose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::ShowCreatedWindow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97a7064e;  // IPCStableHash for blink::mojom::LocalMainFrameHost::ShowCreatedWindow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::SetWindowRect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e51fb83;  // IPCStableHash for blink::mojom::LocalMainFrameHost::SetWindowRect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalMainFrameHost::DidFirstVisuallyNonEmptyPaint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x880639cd;  // IPCStableHash for blink::mojom::LocalMainFrameHost::DidFirstVisuallyNonEmptyPaint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
