// third_party/blink/public/mojom/frame/frame.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_state.mojom-shared.h"
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h"
#include "third_party/blink/public/mojom/close_watcher/close_listener.mojom-shared.h"
#include "third_party/blink/public/mojom/confidence_level.mojom-shared.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"
#include "third_party/blink/public/mojom/drag/drag.mojom-shared.h"
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/blocked_navigation_types.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/media_player_action.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/sudden_termination_disabler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom-shared.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/keep_alive_handle_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/delegated_capability.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-shared.h"
#include "third_party/blink/public/mojom/opengraph/metadata.mojom-shared.h"
#include "third_party/blink/public/mojom/page/draggable_region.mojom-shared.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/base/mojom/attributed_string.mojom-shared.h"


namespace blink::mojom {
class SavableSubframeDataView;

class GetSavableResourceLinksReplyDataView;

class FindInPageResultAXParamsDataView;

class SerializedDomElementInfoDataView;

class DownloadURLParamsDataView;

class IframeAttributesDataView;

class LegacyTechEventCodeLocationDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SavableSubframeDataView> {
  using Data = ::blink::mojom::internal::SavableSubframe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetSavableResourceLinksReplyDataView> {
  using Data = ::blink::mojom::internal::GetSavableResourceLinksReply_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FindInPageResultAXParamsDataView> {
  using Data = ::blink::mojom::internal::FindInPageResultAXParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SerializedDomElementInfoDataView> {
  using Data = ::blink::mojom::internal::SerializedDomElementInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DownloadURLParamsDataView> {
  using Data = ::blink::mojom::internal::DownloadURLParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IframeAttributesDataView> {
  using Data = ::blink::mojom::internal::IframeAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LegacyTechEventCodeLocationDataView> {
  using Data = ::blink::mojom::internal::LegacyTechEventCodeLocation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PluginActionType : int32_t {
  
  kRotate90Clockwise = 0,
  
  kRotate90Counterclockwise = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PluginActionType value);
inline bool IsKnownEnumValue(PluginActionType value) {
  return internal::PluginActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class JavaScriptExecutionResultType : int32_t {
  
  kSuccess = 0,
  
  kException = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, JavaScriptExecutionResultType value);
inline bool IsKnownEnumValue(JavaScriptExecutionResultType value) {
  return internal::JavaScriptExecutionResultType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TraverseCancelledReason : int32_t {
  
  kNotFound = 0,
  
  kSandboxViolation = 1,
  
  kAbortedBeforeCommit = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, TraverseCancelledReason value);
inline bool IsKnownEnumValue(TraverseCancelledReason value) {
  return internal::TraverseCancelledReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ViewTransitionSameOriginOptIn : int32_t {
  
  kDisabled = 0,
  
  kEnabled = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ViewTransitionSameOriginOptIn value);
inline bool IsKnownEnumValue(ViewTransitionSameOriginOptIn value) {
  return internal::ViewTransitionSameOriginOptIn_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FrameOwnerElementType : int32_t {
  
  kNone = 0,
  
  kIframe = 1,
  
  kObject = 2,
  
  kEmbed = 3,
  
  kFrame = 4,
  
  kFencedframe = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FrameOwnerElementType value);
inline bool IsKnownEnumValue(FrameOwnerElementType value) {
  return internal::FrameOwnerElementType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NavigationApiEntryRestoreReason : int32_t {
  
  kBFCache = 0,
  
  kPrerenderActivationPush = 1,
  
  kPrerenderActivationReplace = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NavigationApiEntryRestoreReason value);
inline bool IsKnownEnumValue(NavigationApiEntryRestoreReason value) {
  return internal::NavigationApiEntryRestoreReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class StorageTypeAccessed : int32_t {
  
  kCacheStorage = 0,
  
  kIndexedDB = 1,
  
  kFileSystem = 2,
  
  kWebLocks = 3,
  
  kLocalStorage = 4,
  
  kSessionStorage = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, StorageTypeAccessed value);
inline bool IsKnownEnumValue(StorageTypeAccessed value) {
  return internal::StorageTypeAccessed_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WindowProxyAccessType : int32_t {
  
  kLocation = 0,
  
  kClosed = 1,
  
  kLength = 2,
  
  kSelf = 3,
  
  kWindow = 4,
  
  kFrames = 5,
  
  kOpener = 6,
  
  kParent = 7,
  
  kTop = 8,
  
  kPostMessage = 9,
  
  kAnonymousIndexedGetter = 10,
  
  kClose = 11,
  
  kFocus = 12,
  
  kBlur = 13,
  
  kAnonymousNamedGetter = 14,
  kMinValue = 0,
  kMaxValue = 14,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WindowProxyAccessType value);
inline bool IsKnownEnumValue(WindowProxyAccessType value) {
  return internal::WindowProxyAccessType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class LocalFrameHostInterfaceBase {};

using LocalFrameHostPtrDataView =
    mojo::InterfacePtrDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalFrameHostInterfaceBase>;
class NonAssociatedLocalFrameHostInterfaceBase {};

using NonAssociatedLocalFrameHostPtrDataView =
    mojo::InterfacePtrDataView<NonAssociatedLocalFrameHostInterfaceBase>;
using NonAssociatedLocalFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<NonAssociatedLocalFrameHostInterfaceBase>;
using NonAssociatedLocalFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NonAssociatedLocalFrameHostInterfaceBase>;
using NonAssociatedLocalFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NonAssociatedLocalFrameHostInterfaceBase>;
class LocalFrameInterfaceBase {};

using LocalFramePtrDataView =
    mojo::InterfacePtrDataView<LocalFrameInterfaceBase>;
using LocalFrameRequestDataView =
    mojo::InterfaceRequestDataView<LocalFrameInterfaceBase>;
using LocalFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalFrameInterfaceBase>;
using LocalFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalFrameInterfaceBase>;
class LocalMainFrameInterfaceBase {};

using LocalMainFramePtrDataView =
    mojo::InterfacePtrDataView<LocalMainFrameInterfaceBase>;
using LocalMainFrameRequestDataView =
    mojo::InterfaceRequestDataView<LocalMainFrameInterfaceBase>;
using LocalMainFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalMainFrameInterfaceBase>;
using LocalMainFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalMainFrameInterfaceBase>;
class LocalMainFrameHostInterfaceBase {};

using LocalMainFrameHostPtrDataView =
    mojo::InterfacePtrDataView<LocalMainFrameHostInterfaceBase>;
using LocalMainFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<LocalMainFrameHostInterfaceBase>;
using LocalMainFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalMainFrameHostInterfaceBase>;
using LocalMainFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalMainFrameHostInterfaceBase>;


class SavableSubframeDataView {
 public:
  SavableSubframeDataView() = default;

  SavableSubframeDataView(
      internal::SavableSubframe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSubframeTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframeToken(UserType* output) {
    
    auto* pointer = !data_->subframe_token.is_null() ? &data_->subframe_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::SavableSubframe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetSavableResourceLinksReplyDataView {
 public:
  GetSavableResourceLinksReplyDataView() = default;

  GetSavableResourceLinksReplyDataView(
      internal::GetSavableResourceLinksReply_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResourcesListDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResourcesList(UserType* output) {
    
    auto* pointer = data_->resources_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  inline void GetSubframesDataView(
      mojo::ArrayDataView<SavableSubframeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframes(UserType* output) {
    
    auto* pointer = data_->subframes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SavableSubframeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GetSavableResourceLinksReply_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FindInPageResultAXParamsDataView {
 public:
  FindInPageResultAXParamsDataView() = default;

  FindInPageResultAXParamsDataView(
      internal::FindInPageResultAXParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  int32_t match_index() const {
    return data_->match_index;
  }
  int32_t start_id() const {
    return data_->start_id;
  }
  int32_t start_offset() const {
    return data_->start_offset;
  }
  int32_t end_id() const {
    return data_->end_id;
  }
  int32_t end_offset() const {
    return data_->end_offset;
  }
 private:
  internal::FindInPageResultAXParams_Data* data_ = nullptr;
};


class SerializedDomElementInfoDataView {
 public:
  SerializedDomElementInfoDataView() = default;

  SerializedDomElementInfoDataView(
      internal::SerializedDomElementInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelector(UserType* output) {
    
    auto* pointer = data_->selector.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `visible_bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVisibleBounds` instead "
    "of `ReadVisibleBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->visible_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetClickPointDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClickPoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointDataView, UserType>(),
    "Attempting to read the optional `click_point` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClickPoint` instead "
    "of `ReadClickPoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->click_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
 private:
  internal::SerializedDomElementInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DownloadURLParamsDataView {
 public:
  DownloadURLParamsDataView() = default;

  DownloadURLParamsDataView(
      internal::DownloadURLParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ReferrerDataView, UserType>(),
    "Attempting to read the optional `referrer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReferrer` instead "
    "of `ReadReferrer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `initiator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorOrigin` instead "
    "of `ReadInitiatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetSuggestedNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestedName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `suggested_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSuggestedName` instead "
    "of `ReadSuggestedName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->suggested_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCrossOriginRedirects(UserType* output) const {
    auto data_value = data_->cross_origin_redirects;
    return mojo::internal::Deserialize<::network::mojom::RedirectMode>(
        data_value, output);
  }
  ::network::mojom::RedirectMode cross_origin_redirects() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RedirectMode>(data_->cross_origin_redirects));
  }
  template <typename UserType>
  UserType TakeBlobUrlToken() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
            &data_->blob_url_token, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDataUrlBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->data_url_blob, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool is_context_menu_save() const {
    return data_->is_context_menu_save;
  }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
 private:
  internal::DownloadURLParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IframeAttributesDataView {
 public:
  IframeAttributesDataView() = default;

  IframeAttributesDataView(
      internal::IframeAttributes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParsedCspAttributeDataView(
      ::network::mojom::ContentSecurityPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsedCspAttribute(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ContentSecurityPolicyDataView, UserType>(),
    "Attempting to read the optional `parsed_csp_attribute` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParsedCspAttribute` instead "
    "of `ReadParsedCspAttribute if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parsed_csp_attribute.Get();
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicyDataView>(
        pointer, output, message_);
  }
  bool credentialless() const {
    return data_->credentialless;
  }
  bool browsing_topics() const {
    return data_->browsing_topics;
  }
  bool ad_auction_headers() const {
    return data_->ad_auction_headers;
  }
  bool shared_storage_writable_opted_in() const {
    return data_->shared_storage_writable_opted_in;
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSrcDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `src` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSrc` instead "
    "of `ReadSrc if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::IframeAttributes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LegacyTechEventCodeLocationDataView {
 public:
  LegacyTechEventCodeLocationDataView() = default;

  LegacyTechEventCodeLocationDataView(
      internal::LegacyTechEventCodeLocation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilenameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilename(UserType* output) {
    
    auto* pointer = data_->filename.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t line() const {
    return data_->line;
  }
  uint64_t column() const {
    return data_->column;
  }
 private:
  internal::LegacyTechEventCodeLocation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_DATA_VIEW_H_