// third_party/blink/public/mojom/frame/find_in_page.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const StopFindActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const StopFindAction = {
  
  kStopFindActionClearSelection: 0,
  kStopFindActionKeepSelection: 1,
  kStopFindActionActivateSelection: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FindMatchUpdateTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FindMatchUpdateType = {
  
  kFinalUpdate: 0,
  kMoreUpdatesComing: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FindInPagePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FindInPage', scope);
  }
}

/** @interface */
export class FindInPageInterface {
  
  /**
   * @param { !number } requestId
   * @param { !string } searchText
   * @param { !FindOptions } options
   */

  find(requestId, searchText, options) {}
  
  /**
   * @param { !StopFindAction } action
   */

  stopFinding(action) {}
  
  /**
   */

  clearActiveFindMatch() {}
  
  /**
   * @param { !FindInPageClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @param { !string } searchText
   * @param { !FindOptions } options
   * @return {!Promise<{
        count: !number,
   *  }>}
   */

  countMatches(searchText, options) {}
}

/**
 * @implements { FindInPageInterface }
 */
export class FindInPageRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FindInPagePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FindInPagePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FindInPagePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } searchText
   * @param { !FindOptions } options
   */

  find(
      requestId,
      searchText,
      options) {
    this.proxy.sendMessage(
        0,
        FindInPage_Find_ParamsSpec.$,
        null,
        [
          requestId,
          searchText,
          options
        ],
        false);
  }

  
  /**
   * @param { !StopFindAction } action
   */

  stopFinding(
      action) {
    this.proxy.sendMessage(
        1,
        FindInPage_StopFinding_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   */

  clearActiveFindMatch() {
    this.proxy.sendMessage(
        2,
        FindInPage_ClearActiveFindMatch_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !FindInPageClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        3,
        FindInPage_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !string } searchText
   * @param { !FindOptions } options
   * @return {!Promise<{
        count: !number,
   *  }>}
   */

  countMatches(
      searchText,
      options) {
    return this.proxy.sendMessage(
        4,
        FindInPage_CountMatches_ParamsSpec.$,
        FindInPage_CountMatches_ResponseParamsSpec.$,
        [
          searchText,
          options
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FindInPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FindInPageReceiver {
  /**
   * @param {!FindInPageInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FindInPageRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FindInPageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FindInPageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FindInPage_Find_ParamsSpec.$,
        null,
        impl.find.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FindInPage_StopFinding_ParamsSpec.$,
        null,
        impl.stopFinding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FindInPage_ClearActiveFindMatch_ParamsSpec.$,
        null,
        impl.clearActiveFindMatch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FindInPage_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FindInPage_CountMatches_ParamsSpec.$,
        FindInPage_CountMatches_ResponseParamsSpec.$,
        impl.countMatches.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FindInPage {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FindInPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FindInPageRemote}
   */
  static getRemote() {
    let remote = new FindInPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FindInPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FindInPageCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FindInPageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FindInPageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.find =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FindInPage_Find_ParamsSpec.$,
        null,
        this.find.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopFinding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FindInPage_StopFinding_ParamsSpec.$,
        null,
        this.stopFinding.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearActiveFindMatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FindInPage_ClearActiveFindMatch_ParamsSpec.$,
        null,
        this.clearActiveFindMatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FindInPage_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.countMatches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FindInPage_CountMatches_ParamsSpec.$,
        FindInPage_CountMatches_ResponseParamsSpec.$,
        this.countMatches.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FindInPageClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FindInPageClient', scope);
  }
}

/** @interface */
export class FindInPageClientInterface {
  
  /**
   * @param { !number } requestId
   * @param { !number } numberOfMatches
   * @param { !FindMatchUpdateType } updateType
   */

  setNumberOfMatches(requestId, numberOfMatches, updateType) {}
  
  /**
   * @param { !number } requestId
   * @param { !gfx_mojom_Rect } activeMatchRect
   * @param { !number } activeMatchOrdinal
   * @param { !FindMatchUpdateType } updateType
   */

  setActiveMatch(requestId, activeMatchRect, activeMatchOrdinal, updateType) {}
}

/**
 * @implements { FindInPageClientInterface }
 */
export class FindInPageClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FindInPageClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FindInPageClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FindInPageClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } requestId
   * @param { !number } numberOfMatches
   * @param { !FindMatchUpdateType } updateType
   */

  setNumberOfMatches(
      requestId,
      numberOfMatches,
      updateType) {
    this.proxy.sendMessage(
        0,
        FindInPageClient_SetNumberOfMatches_ParamsSpec.$,
        null,
        [
          requestId,
          numberOfMatches,
          updateType
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !gfx_mojom_Rect } activeMatchRect
   * @param { !number } activeMatchOrdinal
   * @param { !FindMatchUpdateType } updateType
   */

  setActiveMatch(
      requestId,
      activeMatchRect,
      activeMatchOrdinal,
      updateType) {
    this.proxy.sendMessage(
        1,
        FindInPageClient_SetActiveMatch_ParamsSpec.$,
        null,
        [
          requestId,
          activeMatchRect,
          activeMatchOrdinal,
          updateType
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FindInPageClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FindInPageClientReceiver {
  /**
   * @param {!FindInPageClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FindInPageClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FindInPageClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FindInPageClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FindInPageClient_SetNumberOfMatches_ParamsSpec.$,
        null,
        impl.setNumberOfMatches.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FindInPageClient_SetActiveMatch_ParamsSpec.$,
        null,
        impl.setActiveMatch.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FindInPageClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FindInPageClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FindInPageClientRemote}
   */
  static getRemote() {
    let remote = new FindInPageClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FindInPageClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FindInPageClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FindInPageClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FindInPageClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNumberOfMatches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FindInPageClient_SetNumberOfMatches_ParamsSpec.$,
        null,
        this.setNumberOfMatches.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setActiveMatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FindInPageClient_SetActiveMatch_ParamsSpec.$,
        null,
        this.setActiveMatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindInPage_Find_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindInPage_StopFinding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindInPage_ClearActiveFindMatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindInPage_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindInPage_CountMatches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindInPage_CountMatches_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindInPageClient_SetNumberOfMatches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FindInPageClient_SetActiveMatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FindOptionsSpec.$,
    'FindOptions',
    [
      mojo.internal.StructField(
        'forward', 0,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchCase', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newSession', 0,
        2,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'findMatch', 0,
        3,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'force', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'runSynchronouslyForTesting', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FindOptions {
  constructor() {
    /** @type { !boolean } */
    this.forward;
    /** @type { !boolean } */
    this.matchCase;
    /** @type { !boolean } */
    this.newSession;
    /** @type { !boolean } */
    this.findMatch;
    /** @type { !boolean } */
    this.force;
    /** @type { !boolean } */
    this.runSynchronouslyForTesting;
  }
}



mojo.internal.Struct(
    FindInPage_Find_ParamsSpec.$,
    'FindInPage_Find_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'searchText', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        FindOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FindInPage_Find_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !string } */
    this.searchText;
    /** @type { !FindOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    FindInPage_StopFinding_ParamsSpec.$,
    'FindInPage_StopFinding_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        StopFindActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FindInPage_StopFinding_Params {
  constructor() {
    /** @type { !StopFindAction } */
    this.action;
  }
}



mojo.internal.Struct(
    FindInPage_ClearActiveFindMatch_ParamsSpec.$,
    'FindInPage_ClearActiveFindMatch_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FindInPage_ClearActiveFindMatch_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FindInPage_SetClient_ParamsSpec.$,
    'FindInPage_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(FindInPageClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FindInPage_SetClient_Params {
  constructor() {
    /** @type { !FindInPageClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    FindInPage_CountMatches_ParamsSpec.$,
    'FindInPage_CountMatches_Params',
    [
      mojo.internal.StructField(
        'searchText', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        FindOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FindInPage_CountMatches_Params {
  constructor() {
    /** @type { !string } */
    this.searchText;
    /** @type { !FindOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    FindInPage_CountMatches_ResponseParamsSpec.$,
    'FindInPage_CountMatches_ResponseParams',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FindInPage_CountMatches_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    FindInPageClient_SetNumberOfMatches_ParamsSpec.$,
    'FindInPageClient_SetNumberOfMatches_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfMatches', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateType', 8,
        0,
        FindMatchUpdateTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FindInPageClient_SetNumberOfMatches_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !number } */
    this.numberOfMatches;
    /** @type { !FindMatchUpdateType } */
    this.updateType;
  }
}



mojo.internal.Struct(
    FindInPageClient_SetActiveMatch_ParamsSpec.$,
    'FindInPageClient_SetActiveMatch_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activeMatchRect', 8,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activeMatchOrdinal', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateType', 16,
        0,
        FindMatchUpdateTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FindInPageClient_SetActiveMatch_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !gfx_mojom_Rect } */
    this.activeMatchRect;
    /** @type { !number } */
    this.activeMatchOrdinal;
    /** @type { !FindMatchUpdateType } */
    this.updateType;
  }
}

