// third_party/blink/public/mojom/font_access/font_access.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ReadOnlySharedMemoryRegion as mojoBase_mojom_ReadOnlySharedMemoryRegion,
  ReadOnlySharedMemoryRegionSpec as mojoBase_mojom_ReadOnlySharedMemoryRegionSpec
} from '../../../../../mojo/public/mojom/base/shared_memory.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FontEnumerationStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FontEnumerationStatus = {
  
  kOk: 0,
  kUnimplemented: 1,
  kUnexpectedError: 2,
  kNeedsUserActivation: 3,
  kNotVisible: 4,
  kPermissionDenied: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FontAccessManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FontAccessManager', scope);
  }
}

/** @interface */
export class FontAccessManagerInterface {
  
  /**
   * @return {!Promise<{
        enumerationStatus: !FontEnumerationStatus,
        enumerationTable: ?mojoBase_mojom_ReadOnlySharedMemoryRegion,
   *  }>}
   */

  enumerateLocalFonts() {}
}

/**
 * @implements { FontAccessManagerInterface }
 */
export class FontAccessManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FontAccessManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FontAccessManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FontAccessManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        enumerationStatus: !FontEnumerationStatus,
        enumerationTable: ?mojoBase_mojom_ReadOnlySharedMemoryRegion,
   *  }>}
   */

  enumerateLocalFonts() {
    return this.proxy.sendMessage(
        0,
        FontAccessManager_EnumerateLocalFonts_ParamsSpec.$,
        FontAccessManager_EnumerateLocalFonts_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FontAccessManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FontAccessManagerReceiver {
  /**
   * @param {!FontAccessManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FontAccessManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FontAccessManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FontAccessManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FontAccessManager_EnumerateLocalFonts_ParamsSpec.$,
        FontAccessManager_EnumerateLocalFonts_ResponseParamsSpec.$,
        impl.enumerateLocalFonts.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FontAccessManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FontAccessManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FontAccessManagerRemote}
   */
  static getRemote() {
    let remote = new FontAccessManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FontAccessManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FontAccessManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FontAccessManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FontAccessManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateLocalFonts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FontAccessManager_EnumerateLocalFonts_ParamsSpec.$,
        FontAccessManager_EnumerateLocalFonts_ResponseParamsSpec.$,
        this.enumerateLocalFonts.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FontDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FontAccessManager_EnumerateLocalFonts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FontAccessManager_EnumerateLocalFonts_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FontDataSpec.$,
    'FontData',
    [
      mojo.internal.StructField(
        'postscriptName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fullName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'family', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'style', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FontData {
  constructor() {
    /** @type { !string } */
    this.postscriptName;
    /** @type { !string } */
    this.fullName;
    /** @type { !string } */
    this.family;
    /** @type { !string } */
    this.style;
  }
}



mojo.internal.Struct(
    FontAccessManager_EnumerateLocalFonts_ParamsSpec.$,
    'FontAccessManager_EnumerateLocalFonts_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FontAccessManager_EnumerateLocalFonts_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FontAccessManager_EnumerateLocalFonts_ResponseParamsSpec.$,
    'FontAccessManager_EnumerateLocalFonts_ResponseParams',
    [
      mojo.internal.StructField(
        'enumerationStatus', 0,
        0,
        FontEnumerationStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enumerationTable', 8,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FontAccessManager_EnumerateLocalFonts_ResponseParams {
  constructor() {
    /** @type { !FontEnumerationStatus } */
    this.enumerationStatus;
    /** @type { (mojoBase_mojom_ReadOnlySharedMemoryRegion|undefined) } */
    this.enumerationTable;
  }
}

