// third_party/blink/public/mojom/font_access/font_access.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/font_access/font_access.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::FontEnumerationStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FontEnumerationStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FontEnumerationStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FontEnumerationStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FontEnumerationStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FontDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FontDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FontData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::postscript_name(input)) in_postscript_name = Traits::postscript_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->postscript_name)::BaseType> postscript_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_postscript_name,
      postscript_name_fragment);

    fragment->postscript_name.Set(
        postscript_name_fragment.is_null() ? nullptr : postscript_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->postscript_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null postscript_name in FontData struct");

    decltype(Traits::full_name(input)) in_full_name = Traits::full_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->full_name)::BaseType> full_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_full_name,
      full_name_fragment);

    fragment->full_name.Set(
        full_name_fragment.is_null() ? nullptr : full_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->full_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null full_name in FontData struct");

    decltype(Traits::family(input)) in_family = Traits::family(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->family)::BaseType> family_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_family,
      family_fragment);

    fragment->family.Set(
        family_fragment.is_null() ? nullptr : family_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->family.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null family in FontData struct");

    decltype(Traits::style(input)) in_style = Traits::style(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->style)::BaseType> style_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_style,
      style_fragment);

    fragment->style.Set(
        style_fragment.is_null() ? nullptr : style_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->style.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null style in FontData struct");
  }

  static bool Deserialize(::blink::mojom::internal::FontData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FontDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FontDataDataView::GetPostscriptNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->postscript_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FontDataDataView::GetFullNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->full_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FontDataDataView::GetFamilyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->family.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FontDataDataView::GetStyleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->style.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FontEnumerationStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FontEnumerationStatus value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_SHARED_H_