// third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var noise_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom', 'noise_token.mojom.js');
  }



  function CanvasNoiseTokenUpdater_OnTokenReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CanvasNoiseTokenUpdater_OnTokenReceived_Params.prototype.initDefaults_ = function() {
    this.token = null;
  };
  CanvasNoiseTokenUpdater_OnTokenReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CanvasNoiseTokenUpdater_OnTokenReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanvasNoiseTokenUpdater_OnTokenReceived_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, noise_token$.NoiseToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CanvasNoiseTokenUpdater_OnTokenReceived_Params.encodedSize = codec.kStructHeaderSize + 8;

  CanvasNoiseTokenUpdater_OnTokenReceived_Params.decode = function(decoder) {
    var packed;
    var val = new CanvasNoiseTokenUpdater_OnTokenReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(noise_token$.NoiseToken);
    return val;
  };

  CanvasNoiseTokenUpdater_OnTokenReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CanvasNoiseTokenUpdater_OnTokenReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(noise_token$.NoiseToken, val.token);
  };
  var kCanvasNoiseTokenUpdater_OnTokenReceived_Name = 0;

  function CanvasNoiseTokenUpdaterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CanvasNoiseTokenUpdater,
                                                   handleOrPtrInfo);
  }

  function CanvasNoiseTokenUpdaterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CanvasNoiseTokenUpdater, associatedInterfacePtrInfo);
  }

  CanvasNoiseTokenUpdaterAssociatedPtr.prototype =
      Object.create(CanvasNoiseTokenUpdaterPtr.prototype);
  CanvasNoiseTokenUpdaterAssociatedPtr.prototype.constructor =
      CanvasNoiseTokenUpdaterAssociatedPtr;

  function CanvasNoiseTokenUpdaterProxy(receiver) {
    this.receiver_ = receiver;
  }
  CanvasNoiseTokenUpdaterPtr.prototype.onTokenReceived = function() {
    return CanvasNoiseTokenUpdaterProxy.prototype.onTokenReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  CanvasNoiseTokenUpdaterProxy.prototype.onTokenReceived = function(token) {
    var params_ = new CanvasNoiseTokenUpdater_OnTokenReceived_Params();
    params_.token = token;
    var builder = new codec.MessageV0Builder(
        kCanvasNoiseTokenUpdater_OnTokenReceived_Name,
        codec.align(CanvasNoiseTokenUpdater_OnTokenReceived_Params.encodedSize));
    builder.encodeStruct(CanvasNoiseTokenUpdater_OnTokenReceived_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CanvasNoiseTokenUpdaterStub(delegate) {
    this.delegate_ = delegate;
  }
  CanvasNoiseTokenUpdaterStub.prototype.onTokenReceived = function(token) {
    return this.delegate_ && this.delegate_.onTokenReceived && this.delegate_.onTokenReceived(token);
  }

  CanvasNoiseTokenUpdaterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCanvasNoiseTokenUpdater_OnTokenReceived_Name:
      var params = reader.decodeStruct(CanvasNoiseTokenUpdater_OnTokenReceived_Params);
      this.onTokenReceived(params.token);
      return true;
    default:
      return false;
    }
  };

  CanvasNoiseTokenUpdaterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCanvasNoiseTokenUpdaterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCanvasNoiseTokenUpdater_OnTokenReceived_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CanvasNoiseTokenUpdater_OnTokenReceived_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCanvasNoiseTokenUpdaterResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CanvasNoiseTokenUpdater = {
    name: 'blink.mojom.CanvasNoiseTokenUpdater',
    kVersion: 0,
    ptrClass: CanvasNoiseTokenUpdaterPtr,
    proxyClass: CanvasNoiseTokenUpdaterProxy,
    stubClass: CanvasNoiseTokenUpdaterStub,
    validateRequest: validateCanvasNoiseTokenUpdaterRequest,
    validateResponse: null,
  };
  CanvasNoiseTokenUpdaterStub.prototype.validator = validateCanvasNoiseTokenUpdaterRequest;
  CanvasNoiseTokenUpdaterProxy.prototype.validator = null;
  exports.CanvasNoiseTokenUpdater = CanvasNoiseTokenUpdater;
  exports.CanvasNoiseTokenUpdaterPtr = CanvasNoiseTokenUpdaterPtr;
  exports.CanvasNoiseTokenUpdaterAssociatedPtr = CanvasNoiseTokenUpdaterAssociatedPtr;
})();