// third_party/blink/public/mojom/filesystem/file_system.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace blink::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemCancellableOperation_Cancel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<FileSystemCancellableOperation_Cancel_Params_Data>;

  FileSystemCancellableOperation_Cancel_Params_Data();
  ~FileSystemCancellableOperation_Cancel_Params_Data() = delete;
};
static_assert(sizeof(FileSystemCancellableOperation_Cancel_Params_Data) == 8,
              "Bad sizeof(FileSystemCancellableOperation_Cancel_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemCancellableOperation_Cancel_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemCancellableOperation_Cancel_ResponseParams_Data>;

  FileSystemCancellableOperation_Cancel_ResponseParams_Data();
  ~FileSystemCancellableOperation_Cancel_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemCancellableOperation_Cancel_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemCancellableOperation_Cancel_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemOperationListener_ResultsRetrieved_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::filesystem::mojom::internal::DirectoryEntry_Data>>> entries;
  uint8_t has_more : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<FileSystemOperationListener_ResultsRetrieved_Params_Data>;

  FileSystemOperationListener_ResultsRetrieved_Params_Data();
  ~FileSystemOperationListener_ResultsRetrieved_Params_Data() = delete;
};
static_assert(sizeof(FileSystemOperationListener_ResultsRetrieved_Params_Data) == 24,
              "Bad sizeof(FileSystemOperationListener_ResultsRetrieved_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemOperationListener_DidWrite_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t byte_count;
  uint8_t complete : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<FileSystemOperationListener_DidWrite_Params_Data>;

  FileSystemOperationListener_DidWrite_Params_Data();
  ~FileSystemOperationListener_DidWrite_Params_Data() = delete;
};
static_assert(sizeof(FileSystemOperationListener_DidWrite_Params_Data) == 24,
              "Bad sizeof(FileSystemOperationListener_DidWrite_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemOperationListener_ErrorOccurred_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemOperationListener_ErrorOccurred_Params_Data>;

  FileSystemOperationListener_ErrorOccurred_Params_Data();
  ~FileSystemOperationListener_ErrorOccurred_Params_Data() = delete;
};
static_assert(sizeof(FileSystemOperationListener_ErrorOccurred_Params_Data) == 16,
              "Bad sizeof(FileSystemOperationListener_ErrorOccurred_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data>;

  ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data();
  ~ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data() = delete;
};
static_assert(sizeof(ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data) == 8,
              "Bad sizeof(ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Open_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin;
  int32_t file_system_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Open_Params_Data>;

  FileSystemManager_Open_Params_Data();
  ~FileSystemManager_Open_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Open_Params_Data) == 24,
              "Bad sizeof(FileSystemManager_Open_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Open_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> root_url;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Open_ResponseParams_Data>;

  FileSystemManager_Open_ResponseParams_Data();
  ~FileSystemManager_Open_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Open_ResponseParams_Data) == 32,
              "Bad sizeof(FileSystemManager_Open_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_ResolveURL_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> filesystem_url;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_ResolveURL_Params_Data>;

  FileSystemManager_ResolveURL_Params_Data();
  ~FileSystemManager_ResolveURL_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_ResolveURL_Params_Data) == 16,
              "Bad sizeof(FileSystemManager_ResolveURL_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_ResolveURL_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::FileSystemInfo_Data> info;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> file_path;
  uint8_t is_directory : 1;
  uint8_t pad2_[3];
  int32_t error_code;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_ResolveURL_ResponseParams_Data>;

  FileSystemManager_ResolveURL_ResponseParams_Data();
  ~FileSystemManager_ResolveURL_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_ResolveURL_ResponseParams_Data) == 32,
              "Bad sizeof(FileSystemManager_ResolveURL_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Move_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> src_path;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> dest_path;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Move_Params_Data>;

  FileSystemManager_Move_Params_Data();
  ~FileSystemManager_Move_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Move_Params_Data) == 24,
              "Bad sizeof(FileSystemManager_Move_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Move_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Move_ResponseParams_Data>;

  FileSystemManager_Move_ResponseParams_Data();
  ~FileSystemManager_Move_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Move_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_Move_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Copy_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> src_path;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> dest_path;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Copy_Params_Data>;

  FileSystemManager_Copy_Params_Data();
  ~FileSystemManager_Copy_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Copy_Params_Data) == 24,
              "Bad sizeof(FileSystemManager_Copy_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Copy_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Copy_ResponseParams_Data>;

  FileSystemManager_Copy_ResponseParams_Data();
  ~FileSystemManager_Copy_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Copy_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_Copy_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Remove_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> path;
  uint8_t recursive : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Remove_Params_Data>;

  FileSystemManager_Remove_Params_Data();
  ~FileSystemManager_Remove_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Remove_Params_Data) == 24,
              "Bad sizeof(FileSystemManager_Remove_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Remove_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Remove_ResponseParams_Data>;

  FileSystemManager_Remove_ResponseParams_Data();
  ~FileSystemManager_Remove_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Remove_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_Remove_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_ReadMetadata_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> path;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_ReadMetadata_Params_Data>;

  FileSystemManager_ReadMetadata_Params_Data();
  ~FileSystemManager_ReadMetadata_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_ReadMetadata_Params_Data) == 16,
              "Bad sizeof(FileSystemManager_ReadMetadata_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_ReadMetadata_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FileInfo_Data> file_info;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_ReadMetadata_ResponseParams_Data>;

  FileSystemManager_ReadMetadata_ResponseParams_Data();
  ~FileSystemManager_ReadMetadata_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_ReadMetadata_ResponseParams_Data) == 24,
              "Bad sizeof(FileSystemManager_ReadMetadata_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Create_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> path;
  uint8_t exclusive : 1;
  uint8_t is_directory : 1;
  uint8_t recursive : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Create_Params_Data>;

  FileSystemManager_Create_Params_Data();
  ~FileSystemManager_Create_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Create_Params_Data) == 24,
              "Bad sizeof(FileSystemManager_Create_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Create_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Create_ResponseParams_Data>;

  FileSystemManager_Create_ResponseParams_Data();
  ~FileSystemManager_Create_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Create_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_Create_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Exists_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> path;
  uint8_t is_directory : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Exists_Params_Data>;

  FileSystemManager_Exists_Params_Data();
  ~FileSystemManager_Exists_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Exists_Params_Data) == 24,
              "Bad sizeof(FileSystemManager_Exists_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Exists_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Exists_ResponseParams_Data>;

  FileSystemManager_Exists_ResponseParams_Data();
  ~FileSystemManager_Exists_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Exists_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_Exists_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_ReadDirectory_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> path;
  mojo::internal::Interface_Data listener;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_ReadDirectory_Params_Data>;

  FileSystemManager_ReadDirectory_Params_Data();
  ~FileSystemManager_ReadDirectory_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_ReadDirectory_Params_Data) == 24,
              "Bad sizeof(FileSystemManager_ReadDirectory_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_ReadDirectorySync_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> path;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_ReadDirectorySync_Params_Data>;

  FileSystemManager_ReadDirectorySync_Params_Data();
  ~FileSystemManager_ReadDirectorySync_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_ReadDirectorySync_Params_Data) == 16,
              "Bad sizeof(FileSystemManager_ReadDirectorySync_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_ReadDirectorySync_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::filesystem::mojom::internal::DirectoryEntry_Data>>> entries;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_ReadDirectorySync_ResponseParams_Data>;

  FileSystemManager_ReadDirectorySync_ResponseParams_Data();
  ~FileSystemManager_ReadDirectorySync_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_ReadDirectorySync_ResponseParams_Data) == 24,
              "Bad sizeof(FileSystemManager_ReadDirectorySync_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Write_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> file_path;
  mojo::internal::Interface_Data blob;
  int64_t position;
  mojo::internal::Handle_Data op_receiver;
  mojo::internal::Interface_Data listener;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Write_Params_Data>;

  FileSystemManager_Write_Params_Data();
  ~FileSystemManager_Write_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Write_Params_Data) == 48,
              "Bad sizeof(FileSystemManager_Write_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_WriteSync_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> file_path;
  mojo::internal::Interface_Data blob;
  int64_t position;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_WriteSync_Params_Data>;

  FileSystemManager_WriteSync_Params_Data();
  ~FileSystemManager_WriteSync_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_WriteSync_Params_Data) == 32,
              "Bad sizeof(FileSystemManager_WriteSync_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_WriteSync_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t byte_count;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_WriteSync_ResponseParams_Data>;

  FileSystemManager_WriteSync_ResponseParams_Data();
  ~FileSystemManager_WriteSync_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_WriteSync_ResponseParams_Data) == 24,
              "Bad sizeof(FileSystemManager_WriteSync_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Truncate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> file_path;
  int64_t length;
  mojo::internal::Handle_Data op_receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Truncate_Params_Data>;

  FileSystemManager_Truncate_Params_Data();
  ~FileSystemManager_Truncate_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Truncate_Params_Data) == 32,
              "Bad sizeof(FileSystemManager_Truncate_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_Truncate_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_Truncate_ResponseParams_Data>;

  FileSystemManager_Truncate_ResponseParams_Data();
  ~FileSystemManager_Truncate_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_Truncate_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_Truncate_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_TruncateSync_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> file_path;
  int64_t length;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_TruncateSync_Params_Data>;

  FileSystemManager_TruncateSync_Params_Data();
  ~FileSystemManager_TruncateSync_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_TruncateSync_Params_Data) == 24,
              "Bad sizeof(FileSystemManager_TruncateSync_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_TruncateSync_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_TruncateSync_ResponseParams_Data>;

  FileSystemManager_TruncateSync_ResponseParams_Data();
  ~FileSystemManager_TruncateSync_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_TruncateSync_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_TruncateSync_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_CreateSnapshotFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> file_path;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_CreateSnapshotFile_Params_Data>;

  FileSystemManager_CreateSnapshotFile_Params_Data();
  ~FileSystemManager_CreateSnapshotFile_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_CreateSnapshotFile_Params_Data) == 16,
              "Bad sizeof(FileSystemManager_CreateSnapshotFile_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_CreateSnapshotFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FileInfo_Data> file_info;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> platform_path;
  int32_t error_code;
  mojo::internal::Interface_Data snapshot_listener;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_CreateSnapshotFile_ResponseParams_Data>;

  FileSystemManager_CreateSnapshotFile_ResponseParams_Data();
  ~FileSystemManager_CreateSnapshotFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_CreateSnapshotFile_ResponseParams_Data) == 40,
              "Bad sizeof(FileSystemManager_CreateSnapshotFile_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_GetPlatformPath_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> file_path;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_GetPlatformPath_Params_Data>;

  FileSystemManager_GetPlatformPath_Params_Data();
  ~FileSystemManager_GetPlatformPath_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_GetPlatformPath_Params_Data) == 16,
              "Bad sizeof(FileSystemManager_GetPlatformPath_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_GetPlatformPath_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> platform_path;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_GetPlatformPath_ResponseParams_Data>;

  FileSystemManager_GetPlatformPath_ResponseParams_Data();
  ~FileSystemManager_GetPlatformPath_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_GetPlatformPath_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_GetPlatformPath_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_RegisterBlob_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> content_type;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  uint64_t length;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> expected_modification_time;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_RegisterBlob_Params_Data>;

  FileSystemManager_RegisterBlob_Params_Data();
  ~FileSystemManager_RegisterBlob_Params_Data() = delete;
};
static_assert(sizeof(FileSystemManager_RegisterBlob_Params_Data) == 40,
              "Bad sizeof(FileSystemManager_RegisterBlob_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FileSystemManager_RegisterBlob_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::SerializedBlob_Data> blob;

 private:
  friend class mojo::internal::MessageFragment<FileSystemManager_RegisterBlob_ResponseParams_Data>;

  FileSystemManager_RegisterBlob_ResponseParams_Data();
  ~FileSystemManager_RegisterBlob_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileSystemManager_RegisterBlob_ResponseParams_Data) == 16,
              "Bad sizeof(FileSystemManager_RegisterBlob_ResponseParams_Data)");

}  // namespace internal


class FileSystemCancellableOperation_Cancel_ParamsDataView {
 public:
  FileSystemCancellableOperation_Cancel_ParamsDataView() = default;

  FileSystemCancellableOperation_Cancel_ParamsDataView(
      internal::FileSystemCancellableOperation_Cancel_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::FileSystemCancellableOperation_Cancel_Params_Data* data_ = nullptr;
};


class FileSystemCancellableOperation_Cancel_ResponseParamsDataView {
 public:
  FileSystemCancellableOperation_Cancel_ResponseParamsDataView() = default;

  FileSystemCancellableOperation_Cancel_ResponseParamsDataView(
      internal::FileSystemCancellableOperation_Cancel_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemCancellableOperation_Cancel_ResponseParams_Data* data_ = nullptr;
};


class FileSystemOperationListener_ResultsRetrieved_ParamsDataView {
 public:
  FileSystemOperationListener_ResultsRetrieved_ParamsDataView() = default;

  FileSystemOperationListener_ResultsRetrieved_ParamsDataView(
      internal::FileSystemOperationListener_ResultsRetrieved_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEntriesDataView(
      mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntries(UserType* output) {
    
    auto* pointer = data_->entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>>(
        pointer, output, message_);
  }
  bool has_more() const {
    return data_->has_more;
  }
 private:
  internal::FileSystemOperationListener_ResultsRetrieved_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemOperationListener_DidWrite_ParamsDataView {
 public:
  FileSystemOperationListener_DidWrite_ParamsDataView() = default;

  FileSystemOperationListener_DidWrite_ParamsDataView(
      internal::FileSystemOperationListener_DidWrite_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t byte_count() const {
    return data_->byte_count;
  }
  bool complete() const {
    return data_->complete;
  }
 private:
  internal::FileSystemOperationListener_DidWrite_Params_Data* data_ = nullptr;
};


class FileSystemOperationListener_ErrorOccurred_ParamsDataView {
 public:
  FileSystemOperationListener_ErrorOccurred_ParamsDataView() = default;

  FileSystemOperationListener_ErrorOccurred_ParamsDataView(
      internal::FileSystemOperationListener_ErrorOccurred_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemOperationListener_ErrorOccurred_Params_Data* data_ = nullptr;
};


class ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsDataView {
 public:
  ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsDataView() = default;

  ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsDataView(
      internal::ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data* data_ = nullptr;
};


class FileSystemManager_Open_ParamsDataView {
 public:
  FileSystemManager_Open_ParamsDataView() = default;

  FileSystemManager_Open_ParamsDataView(
      internal::FileSystemManager_Open_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemType(UserType* output) const {
    auto data_value = data_->file_system_type;
    return mojo::internal::Deserialize<::blink::mojom::FileSystemType>(
        data_value, output);
  }
  FileSystemType file_system_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FileSystemType>(data_->file_system_type));
  }
 private:
  internal::FileSystemManager_Open_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Open_ResponseParamsDataView {
 public:
  FileSystemManager_Open_ResponseParamsDataView() = default;

  FileSystemManager_Open_ResponseParamsDataView(
      internal::FileSystemManager_Open_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRootUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootUrl(UserType* output) {
    
    auto* pointer = data_->root_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_Open_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_ResolveURL_ParamsDataView {
 public:
  FileSystemManager_ResolveURL_ParamsDataView() = default;

  FileSystemManager_ResolveURL_ParamsDataView(
      internal::FileSystemManager_ResolveURL_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilesystemUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilesystemUrl(UserType* output) {
    
    auto* pointer = data_->filesystem_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_ResolveURL_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_ResolveURL_ResponseParamsDataView {
 public:
  FileSystemManager_ResolveURL_ResponseParamsDataView() = default;

  FileSystemManager_ResolveURL_ResponseParamsDataView(
      internal::FileSystemManager_ResolveURL_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      FileSystemInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::blink::mojom::FileSystemInfoDataView>(
        pointer, output, message_);
  }
  inline void GetFilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  bool is_directory() const {
    return data_->is_directory;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_ResolveURL_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Move_ParamsDataView {
 public:
  FileSystemManager_Move_ParamsDataView() = default;

  FileSystemManager_Move_ParamsDataView(
      internal::FileSystemManager_Move_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrcPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcPath(UserType* output) {
    
    auto* pointer = data_->src_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDestPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestPath(UserType* output) {
    
    auto* pointer = data_->dest_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_Move_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Move_ResponseParamsDataView {
 public:
  FileSystemManager_Move_ResponseParamsDataView() = default;

  FileSystemManager_Move_ResponseParamsDataView(
      internal::FileSystemManager_Move_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_Move_ResponseParams_Data* data_ = nullptr;
};


class FileSystemManager_Copy_ParamsDataView {
 public:
  FileSystemManager_Copy_ParamsDataView() = default;

  FileSystemManager_Copy_ParamsDataView(
      internal::FileSystemManager_Copy_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrcPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcPath(UserType* output) {
    
    auto* pointer = data_->src_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDestPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestPath(UserType* output) {
    
    auto* pointer = data_->dest_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_Copy_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Copy_ResponseParamsDataView {
 public:
  FileSystemManager_Copy_ResponseParamsDataView() = default;

  FileSystemManager_Copy_ResponseParamsDataView(
      internal::FileSystemManager_Copy_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_Copy_ResponseParams_Data* data_ = nullptr;
};


class FileSystemManager_Remove_ParamsDataView {
 public:
  FileSystemManager_Remove_ParamsDataView() = default;

  FileSystemManager_Remove_ParamsDataView(
      internal::FileSystemManager_Remove_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool recursive() const {
    return data_->recursive;
  }
 private:
  internal::FileSystemManager_Remove_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Remove_ResponseParamsDataView {
 public:
  FileSystemManager_Remove_ResponseParamsDataView() = default;

  FileSystemManager_Remove_ResponseParamsDataView(
      internal::FileSystemManager_Remove_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_Remove_ResponseParams_Data* data_ = nullptr;
};


class FileSystemManager_ReadMetadata_ParamsDataView {
 public:
  FileSystemManager_ReadMetadata_ParamsDataView() = default;

  FileSystemManager_ReadMetadata_ParamsDataView(
      internal::FileSystemManager_ReadMetadata_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_ReadMetadata_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_ReadMetadata_ResponseParamsDataView {
 public:
  FileSystemManager_ReadMetadata_ResponseParamsDataView() = default;

  FileSystemManager_ReadMetadata_ResponseParamsDataView(
      internal::FileSystemManager_ReadMetadata_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileInfoDataView(
      ::mojo_base::mojom::FileInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileInfo(UserType* output) {
    
    auto* pointer = data_->file_info.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_ReadMetadata_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Create_ParamsDataView {
 public:
  FileSystemManager_Create_ParamsDataView() = default;

  FileSystemManager_Create_ParamsDataView(
      internal::FileSystemManager_Create_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool exclusive() const {
    return data_->exclusive;
  }
  bool is_directory() const {
    return data_->is_directory;
  }
  bool recursive() const {
    return data_->recursive;
  }
 private:
  internal::FileSystemManager_Create_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Create_ResponseParamsDataView {
 public:
  FileSystemManager_Create_ResponseParamsDataView() = default;

  FileSystemManager_Create_ResponseParamsDataView(
      internal::FileSystemManager_Create_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_Create_ResponseParams_Data* data_ = nullptr;
};


class FileSystemManager_Exists_ParamsDataView {
 public:
  FileSystemManager_Exists_ParamsDataView() = default;

  FileSystemManager_Exists_ParamsDataView(
      internal::FileSystemManager_Exists_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool is_directory() const {
    return data_->is_directory;
  }
 private:
  internal::FileSystemManager_Exists_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Exists_ResponseParamsDataView {
 public:
  FileSystemManager_Exists_ResponseParamsDataView() = default;

  FileSystemManager_Exists_ResponseParamsDataView(
      internal::FileSystemManager_Exists_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_Exists_ResponseParams_Data* data_ = nullptr;
};


class FileSystemManager_ReadDirectory_ParamsDataView {
 public:
  FileSystemManager_ReadDirectory_ParamsDataView() = default;

  FileSystemManager_ReadDirectory_ParamsDataView(
      internal::FileSystemManager_ReadDirectory_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemOperationListenerInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FileSystemManager_ReadDirectory_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_ReadDirectorySync_ParamsDataView {
 public:
  FileSystemManager_ReadDirectorySync_ParamsDataView() = default;

  FileSystemManager_ReadDirectorySync_ParamsDataView(
      internal::FileSystemManager_ReadDirectorySync_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_ReadDirectorySync_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_ReadDirectorySync_ResponseParamsDataView {
 public:
  FileSystemManager_ReadDirectorySync_ResponseParamsDataView() = default;

  FileSystemManager_ReadDirectorySync_ResponseParamsDataView(
      internal::FileSystemManager_ReadDirectorySync_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEntriesDataView(
      mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntries(UserType* output) {
    
    auto* pointer = data_->entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_ReadDirectorySync_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Write_ParamsDataView {
 public:
  FileSystemManager_Write_ParamsDataView() = default;

  FileSystemManager_Write_ParamsDataView(
      internal::FileSystemManager_Write_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, message_);
    DCHECK(ret);
    return result;
  }
  int64_t position() const {
    return data_->position;
  }
  template <typename UserType>
  UserType TakeOpReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemCancellableOperationInterfaceBase>>(
            &data_->op_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemOperationListenerInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FileSystemManager_Write_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_WriteSync_ParamsDataView {
 public:
  FileSystemManager_WriteSync_ParamsDataView() = default;

  FileSystemManager_WriteSync_ParamsDataView(
      internal::FileSystemManager_WriteSync_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, message_);
    DCHECK(ret);
    return result;
  }
  int64_t position() const {
    return data_->position;
  }
 private:
  internal::FileSystemManager_WriteSync_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_WriteSync_ResponseParamsDataView {
 public:
  FileSystemManager_WriteSync_ResponseParamsDataView() = default;

  FileSystemManager_WriteSync_ResponseParamsDataView(
      internal::FileSystemManager_WriteSync_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t byte_count() const {
    return data_->byte_count;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_WriteSync_ResponseParams_Data* data_ = nullptr;
};


class FileSystemManager_Truncate_ParamsDataView {
 public:
  FileSystemManager_Truncate_ParamsDataView() = default;

  FileSystemManager_Truncate_ParamsDataView(
      internal::FileSystemManager_Truncate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t length() const {
    return data_->length;
  }
  template <typename UserType>
  UserType TakeOpReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemCancellableOperationInterfaceBase>>(
            &data_->op_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FileSystemManager_Truncate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_Truncate_ResponseParamsDataView {
 public:
  FileSystemManager_Truncate_ResponseParamsDataView() = default;

  FileSystemManager_Truncate_ResponseParamsDataView(
      internal::FileSystemManager_Truncate_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_Truncate_ResponseParams_Data* data_ = nullptr;
};


class FileSystemManager_TruncateSync_ParamsDataView {
 public:
  FileSystemManager_TruncateSync_ParamsDataView() = default;

  FileSystemManager_TruncateSync_ParamsDataView(
      internal::FileSystemManager_TruncateSync_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t length() const {
    return data_->length;
  }
 private:
  internal::FileSystemManager_TruncateSync_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_TruncateSync_ResponseParamsDataView {
 public:
  FileSystemManager_TruncateSync_ResponseParamsDataView() = default;

  FileSystemManager_TruncateSync_ResponseParamsDataView(
      internal::FileSystemManager_TruncateSync_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
 private:
  internal::FileSystemManager_TruncateSync_ResponseParams_Data* data_ = nullptr;
};


class FileSystemManager_CreateSnapshotFile_ParamsDataView {
 public:
  FileSystemManager_CreateSnapshotFile_ParamsDataView() = default;

  FileSystemManager_CreateSnapshotFile_ParamsDataView(
      internal::FileSystemManager_CreateSnapshotFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_CreateSnapshotFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_CreateSnapshotFile_ResponseParamsDataView {
 public:
  FileSystemManager_CreateSnapshotFile_ResponseParamsDataView() = default;

  FileSystemManager_CreateSnapshotFile_ResponseParamsDataView(
      internal::FileSystemManager_CreateSnapshotFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileInfoDataView(
      ::mojo_base::mojom::FileInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileInfo(UserType* output) {
    
    auto* pointer = data_->file_info.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileInfoDataView>(
        pointer, output, message_);
  }
  inline void GetPlatformPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlatformPath(UserType* output) {
    
    auto* pointer = data_->platform_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error_code));
  }
  template <typename UserType>
  UserType TakeSnapshotListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::ReceivedSnapshotListenerInterfaceBase>>(
            &data_->snapshot_listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FileSystemManager_CreateSnapshotFile_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_GetPlatformPath_ParamsDataView {
 public:
  FileSystemManager_GetPlatformPath_ParamsDataView() = default;

  FileSystemManager_GetPlatformPath_ParamsDataView(
      internal::FileSystemManager_GetPlatformPath_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_GetPlatformPath_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_GetPlatformPath_ResponseParamsDataView {
 public:
  FileSystemManager_GetPlatformPath_ResponseParamsDataView() = default;

  FileSystemManager_GetPlatformPath_ResponseParamsDataView(
      internal::FileSystemManager_GetPlatformPath_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPlatformPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlatformPath(UserType* output) {
    
    auto* pointer = data_->platform_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_GetPlatformPath_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_RegisterBlob_ParamsDataView {
 public:
  FileSystemManager_RegisterBlob_ParamsDataView() = default;

  FileSystemManager_RegisterBlob_ParamsDataView(
      internal::FileSystemManager_RegisterBlob_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentType(UserType* output) {
    
    auto* pointer = data_->content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetExpectedModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedModificationTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `expected_modification_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpectedModificationTime` instead "
    "of `ReadExpectedModificationTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expected_modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_RegisterBlob_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemManager_RegisterBlob_ResponseParamsDataView {
 public:
  FileSystemManager_RegisterBlob_ResponseParamsDataView() = default;

  FileSystemManager_RegisterBlob_ResponseParamsDataView(
      internal::FileSystemManager_RegisterBlob_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBlobDataView(
      ::blink::mojom::SerializedBlobDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlob(UserType* output) {
    
    auto* pointer = data_->blob.Get();
    return mojo::internal::Deserialize<::blink::mojom::SerializedBlobDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemManager_RegisterBlob_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};





inline void FileSystemOperationListener_ResultsRetrieved_ParamsDataView::GetEntriesDataView(
    mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>* output) {
  auto pointer = data_->entries.Get();
  *output = mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>(pointer, message_);
}








inline void FileSystemManager_Open_ParamsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void FileSystemManager_Open_ResponseParamsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FileSystemManager_Open_ResponseParamsDataView::GetRootUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->root_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void FileSystemManager_ResolveURL_ParamsDataView::GetFilesystemUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->filesystem_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void FileSystemManager_ResolveURL_ResponseParamsDataView::GetInfoDataView(
    FileSystemInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = FileSystemInfoDataView(pointer, message_);
}
inline void FileSystemManager_ResolveURL_ResponseParamsDataView::GetFilePathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}


inline void FileSystemManager_Move_ParamsDataView::GetSrcPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->src_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FileSystemManager_Move_ParamsDataView::GetDestPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->dest_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void FileSystemManager_Copy_ParamsDataView::GetSrcPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->src_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FileSystemManager_Copy_ParamsDataView::GetDestPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->dest_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void FileSystemManager_Remove_ParamsDataView::GetPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void FileSystemManager_ReadMetadata_ParamsDataView::GetPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void FileSystemManager_ReadMetadata_ResponseParamsDataView::GetFileInfoDataView(
    ::mojo_base::mojom::FileInfoDataView* output) {
  auto pointer = data_->file_info.Get();
  *output = ::mojo_base::mojom::FileInfoDataView(pointer, message_);
}


inline void FileSystemManager_Create_ParamsDataView::GetPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void FileSystemManager_Exists_ParamsDataView::GetPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void FileSystemManager_ReadDirectory_ParamsDataView::GetPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void FileSystemManager_ReadDirectorySync_ParamsDataView::GetPathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void FileSystemManager_ReadDirectorySync_ResponseParamsDataView::GetEntriesDataView(
    mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>* output) {
  auto pointer = data_->entries.Get();
  *output = mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>(pointer, message_);
}


inline void FileSystemManager_Write_ParamsDataView::GetFilePathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void FileSystemManager_WriteSync_ParamsDataView::GetFilePathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void FileSystemManager_Truncate_ParamsDataView::GetFilePathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void FileSystemManager_TruncateSync_ParamsDataView::GetFilePathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void FileSystemManager_CreateSnapshotFile_ParamsDataView::GetFilePathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void FileSystemManager_CreateSnapshotFile_ResponseParamsDataView::GetFileInfoDataView(
    ::mojo_base::mojom::FileInfoDataView* output) {
  auto pointer = data_->file_info.Get();
  *output = ::mojo_base::mojom::FileInfoDataView(pointer, message_);
}
inline void FileSystemManager_CreateSnapshotFile_ResponseParamsDataView::GetPlatformPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->platform_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}


inline void FileSystemManager_GetPlatformPath_ParamsDataView::GetFilePathDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void FileSystemManager_GetPlatformPath_ResponseParamsDataView::GetPlatformPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->platform_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}


inline void FileSystemManager_RegisterBlob_ParamsDataView::GetContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FileSystemManager_RegisterBlob_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FileSystemManager_RegisterBlob_ParamsDataView::GetExpectedModificationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expected_modification_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void FileSystemManager_RegisterBlob_ResponseParamsDataView::GetBlobDataView(
    ::blink::mojom::SerializedBlobDataView* output) {
  auto pointer = data_->blob.Get();
  *output = ::blink::mojom::SerializedBlobDataView(pointer, message_);
}



}  // blink::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_PARAMS_DATA_H_