// third_party/blink/public/mojom/filesystem/file_system.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/filesystem/file_system.mojom-shared-internal.h"
#include "components/services/filesystem/public/mojom/types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"


namespace blink::mojom {
class FileSystemInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FileSystemInfoDataView> {
  using Data = ::blink::mojom::internal::FileSystemInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FileSystemType : int32_t {
  
  kTemporary = 0,
  
  kPersistent = 1,
  
  kIsolated = 2,
  
  kExternal = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FileSystemType value);
inline bool IsKnownEnumValue(FileSystemType value) {
  return internal::FileSystemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileSystemCancellableOperationInterfaceBase {};

using FileSystemCancellableOperationPtrDataView =
    mojo::InterfacePtrDataView<FileSystemCancellableOperationInterfaceBase>;
using FileSystemCancellableOperationRequestDataView =
    mojo::InterfaceRequestDataView<FileSystemCancellableOperationInterfaceBase>;
using FileSystemCancellableOperationAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileSystemCancellableOperationInterfaceBase>;
using FileSystemCancellableOperationAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileSystemCancellableOperationInterfaceBase>;
class FileSystemOperationListenerInterfaceBase {};

using FileSystemOperationListenerPtrDataView =
    mojo::InterfacePtrDataView<FileSystemOperationListenerInterfaceBase>;
using FileSystemOperationListenerRequestDataView =
    mojo::InterfaceRequestDataView<FileSystemOperationListenerInterfaceBase>;
using FileSystemOperationListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileSystemOperationListenerInterfaceBase>;
using FileSystemOperationListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileSystemOperationListenerInterfaceBase>;
class ReceivedSnapshotListenerInterfaceBase {};

using ReceivedSnapshotListenerPtrDataView =
    mojo::InterfacePtrDataView<ReceivedSnapshotListenerInterfaceBase>;
using ReceivedSnapshotListenerRequestDataView =
    mojo::InterfaceRequestDataView<ReceivedSnapshotListenerInterfaceBase>;
using ReceivedSnapshotListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ReceivedSnapshotListenerInterfaceBase>;
using ReceivedSnapshotListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ReceivedSnapshotListenerInterfaceBase>;
class FileSystemManagerInterfaceBase {};

using FileSystemManagerPtrDataView =
    mojo::InterfacePtrDataView<FileSystemManagerInterfaceBase>;
using FileSystemManagerRequestDataView =
    mojo::InterfaceRequestDataView<FileSystemManagerInterfaceBase>;
using FileSystemManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileSystemManagerInterfaceBase>;
using FileSystemManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileSystemManagerInterfaceBase>;


class FileSystemInfoDataView {
 public:
  FileSystemInfoDataView() = default;

  FileSystemInfoDataView(
      internal::FileSystemInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRootUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootUrl(UserType* output) {
    
    auto* pointer = data_->root_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMountType(UserType* output) const {
    auto data_value = data_->mount_type;
    return mojo::internal::Deserialize<::blink::mojom::FileSystemType>(
        data_value, output);
  }
  FileSystemType mount_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FileSystemType>(data_->mount_type));
  }
 private:
  internal::FileSystemInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_DATA_VIEW_H_