// third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  FileSystemAccessError as blink_mojom_FileSystemAccessError,
  FileSystemAccessErrorSpec as blink_mojom_FileSystemAccessErrorSpec
} from './file_system_access_error.mojom.m.js';

import {
  FileSystemAccessObserverRemote as blink_mojom_FileSystemAccessObserverRemote,
  FileSystemAccessObserverPendingReceiver as blink_mojom_FileSystemAccessObserverPendingReceiver
} from './file_system_access_observer.mojom.m.js';

import {
  FileSystemAccessTransferTokenRemote as blink_mojom_FileSystemAccessTransferTokenRemote,
  FileSystemAccessTransferTokenPendingReceiver as blink_mojom_FileSystemAccessTransferTokenPendingReceiver
} from './file_system_access_transfer_token.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessObserverHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessObserverHost', scope);
  }
}

/** @interface */
export class FileSystemAccessObserverHostInterface {
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @param { !boolean } isRecursive
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        observerReceiver: ?blink_mojom_FileSystemAccessObserverPendingReceiver,
   *  }>}
   */

  observe(token, isRecursive) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   */

  unobserve(token) {}
}

/**
 * @implements { FileSystemAccessObserverHostInterface }
 */
export class FileSystemAccessObserverHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessObserverHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessObserverHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessObserverHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @param { !boolean } isRecursive
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        observerReceiver: ?blink_mojom_FileSystemAccessObserverPendingReceiver,
   *  }>}
   */

  observe(
      token,
      isRecursive) {
    return this.proxy.sendMessage(
        0,
        FileSystemAccessObserverHost_Observe_ParamsSpec.$,
        FileSystemAccessObserverHost_Observe_ResponseParamsSpec.$,
        [
          token,
          isRecursive
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   */

  unobserve(
      token) {
    this.proxy.sendMessage(
        1,
        FileSystemAccessObserverHost_Unobserve_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessObserverHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessObserverHostReceiver {
  /**
   * @param {!FileSystemAccessObserverHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessObserverHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessObserverHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessObserverHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessObserverHost_Observe_ParamsSpec.$,
        FileSystemAccessObserverHost_Observe_ResponseParamsSpec.$,
        impl.observe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessObserverHost_Unobserve_ParamsSpec.$,
        null,
        impl.unobserve.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessObserverHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessObserverHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessObserverHostRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessObserverHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessObserverHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessObserverHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessObserverHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessObserverHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.observe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessObserverHost_Observe_ParamsSpec.$,
        FileSystemAccessObserverHost_Observe_ResponseParamsSpec.$,
        this.observe.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unobserve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessObserverHost_Unobserve_ParamsSpec.$,
        null,
        this.unobserve.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessObserverHost_Observe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessObserverHost_Observe_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessObserverHost_Unobserve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileSystemAccessObserverHost_Observe_ParamsSpec.$,
    'FileSystemAccessObserverHost_Observe_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isRecursive', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessObserverHost_Observe_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @type { !boolean } */
    this.isRecursive;
  }
}



mojo.internal.Struct(
    FileSystemAccessObserverHost_Observe_ResponseParamsSpec.$,
    'FileSystemAccessObserverHost_Observe_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observerReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_FileSystemAccessObserverPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessObserverHost_Observe_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessObserverPendingReceiver|undefined) } */
    this.observerReceiver;
  }
}



mojo.internal.Struct(
    FileSystemAccessObserverHost_Unobserve_ParamsSpec.$,
    'FileSystemAccessObserverHost_Unobserve_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessObserverHost_Unobserve_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.token;
  }
}

