// third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.FileSystemAccessEntry');






goog.provide('blink.mojom.FileSystemAccessObserver');
goog.provide('blink.mojom.FileSystemAccessObserverReceiver');
goog.provide('blink.mojom.FileSystemAccessObserverCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessObserverInterface');
goog.provide('blink.mojom.FileSystemAccessObserverRemote');
goog.provide('blink.mojom.FileSystemAccessObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessObserver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessObserverInterface = class {
  
  /**
   * @param { !Array<!blink.mojom.FileSystemAccessChange> } changes
   */

  onFileChanges(changes) {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessObserverInterface }
 */
blink.mojom.FileSystemAccessObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.FileSystemAccessChange> } changes
   */

  onFileChanges(
      changes) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessObserver_OnFileChanges_ParamsSpec.$,
        null,
        [
          changes
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessObserverReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessObserver_OnFileChanges_ParamsSpec.$,
        null,
        impl.onFileChanges.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFileChanges =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessObserver_OnFileChanges_ParamsSpec.$,
        null,
        this.onFileChanges.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessChangeTypeAppearedSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessChangeTypeAppearedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessChangeTypeDisappearedSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessChangeTypeDisappearedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessChangeTypeErroredSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessChangeTypeErroredSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessChangeTypeModifiedSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessChangeTypeModifiedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessChangeTypeMovedSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessChangeTypeMovedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessChangeTypeUnknownSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessChangeTypeUnknownSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessChangeMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessChangeMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessChangeSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessChangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessObserver_OnFileChanges_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessObserver_OnFileChanges_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessChangeTypeSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FileSystemAccessChangeTypeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessChangeTypeAppearedSpec.$,
    'FileSystemAccessChangeTypeAppeared',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessChangeTypeAppeared');

/** @record */
blink.mojom.FileSystemAccessChangeTypeAppeared = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessChangeTypeDisappearedSpec.$,
    'FileSystemAccessChangeTypeDisappeared',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessChangeTypeDisappeared');

/** @record */
blink.mojom.FileSystemAccessChangeTypeDisappeared = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessChangeTypeErroredSpec.$,
    'FileSystemAccessChangeTypeErrored',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessChangeTypeErrored');

/** @record */
blink.mojom.FileSystemAccessChangeTypeErrored = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessChangeTypeModifiedSpec.$,
    'FileSystemAccessChangeTypeModified',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessChangeTypeModified');

/** @record */
blink.mojom.FileSystemAccessChangeTypeModified = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessChangeTypeMovedSpec.$,
    'FileSystemAccessChangeTypeMoved',
    [
      mojo.internal.StructField(
        'formerRelativePath', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessChangeTypeMoved');

/** @record */
blink.mojom.FileSystemAccessChangeTypeMoved = class {
  constructor() {
    /** @export { (Array<!string>|undefined) } */
    this.formerRelativePath;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessChangeTypeUnknownSpec.$,
    'FileSystemAccessChangeTypeUnknown',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessChangeTypeUnknown');

/** @record */
blink.mojom.FileSystemAccessChangeTypeUnknown = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessChangeMetadataSpec.$,
    'FileSystemAccessChangeMetadata',
    [
      mojo.internal.StructField(
        'root', 0,
        0,
        blink.mojom.FileSystemAccessEntrySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'changedEntry', 8,
        0,
        blink.mojom.FileSystemAccessEntrySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'relativePath', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.FileSystemAccessChangeMetadata');

/** @record */
blink.mojom.FileSystemAccessChangeMetadata = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessEntry } */
    this.root;
    /** @export { !blink.mojom.FileSystemAccessEntry } */
    this.changedEntry;
    /** @export { !Array<!string> } */
    this.relativePath;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessChangeSpec.$,
    'FileSystemAccessChange',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        blink.mojom.FileSystemAccessChangeMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        blink.mojom.FileSystemAccessChangeTypeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.FileSystemAccessChange');

/** @record */
blink.mojom.FileSystemAccessChange = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessChangeMetadata } */
    this.metadata;
    /** @export { !blink.mojom.FileSystemAccessChangeType } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessObserver_OnFileChanges_ParamsSpec.$,
    'FileSystemAccessObserver_OnFileChanges_Params',
    [
      mojo.internal.StructField(
        'changes', 0,
        0,
        mojo.internal.Array(blink.mojom.FileSystemAccessChangeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessObserver_OnFileChanges_Params');

/** @record */
blink.mojom.FileSystemAccessObserver_OnFileChanges_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.FileSystemAccessChange> } */
    this.changes;
  }
};

goog.provide('blink.mojom.FileSystemAccessChangeType');


mojo.internal.Union(
    blink.mojom.FileSystemAccessChangeTypeSpec.$, 'FileSystemAccessChangeType',
    {
      'appeared': {
        'ordinal': 0,
        'type': blink.mojom.FileSystemAccessChangeTypeAppearedSpec.$,
      },
      'disappeared': {
        'ordinal': 1,
        'type': blink.mojom.FileSystemAccessChangeTypeDisappearedSpec.$,
      },
      'errored': {
        'ordinal': 2,
        'type': blink.mojom.FileSystemAccessChangeTypeErroredSpec.$,
      },
      'modified': {
        'ordinal': 3,
        'type': blink.mojom.FileSystemAccessChangeTypeModifiedSpec.$,
      },
      'moved': {
        'ordinal': 4,
        'type': blink.mojom.FileSystemAccessChangeTypeMovedSpec.$,
      },
      'unknown': {
        'ordinal': 5,
        'type': blink.mojom.FileSystemAccessChangeTypeUnknownSpec.$,
      },
    });

/**
 * @typedef { {
 *   appeared: (!blink.mojom.FileSystemAccessChangeTypeAppeared|undefined),
 *   disappeared: (!blink.mojom.FileSystemAccessChangeTypeDisappeared|undefined),
 *   errored: (!blink.mojom.FileSystemAccessChangeTypeErrored|undefined),
 *   modified: (!blink.mojom.FileSystemAccessChangeTypeModified|undefined),
 *   moved: (!blink.mojom.FileSystemAccessChangeTypeMoved|undefined),
 *   unknown: (!blink.mojom.FileSystemAccessChangeTypeUnknown|undefined),
 * } }
 */
blink.mojom.FileSystemAccessChangeType;
