// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-test-utils.h"


namespace blink::mojom {
ChooseFileSystemEntryAcceptsOption::ChooseFileSystemEntryAcceptsOption()
    : description(),
      mime_types(),
      extensions() {}

ChooseFileSystemEntryAcceptsOption::ChooseFileSystemEntryAcceptsOption(
    const ::std::u16string& description_in,
    std::vector<std::string> mime_types_in,
    std::vector<std::string> extensions_in)
    : description(std::move(description_in)),
      mime_types(std::move(mime_types_in)),
      extensions(std::move(extensions_in)) {}

ChooseFileSystemEntryAcceptsOption::~ChooseFileSystemEntryAcceptsOption() = default;

void ChooseFileSystemEntryAcceptsOption::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_types"), this->mime_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChooseFileSystemEntryAcceptsOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AcceptsTypesInfo::AcceptsTypesInfo()
    : accepts(),
      include_accepts_all() {}

AcceptsTypesInfo::AcceptsTypesInfo(
    std::vector<ChooseFileSystemEntryAcceptsOptionPtr> accepts_in,
    bool include_accepts_all_in)
    : accepts(std::move(accepts_in)),
      include_accepts_all(std::move(include_accepts_all_in)) {}

AcceptsTypesInfo::~AcceptsTypesInfo() = default;

void AcceptsTypesInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accepts"), this->accepts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ChooseFileSystemEntryAcceptsOptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_accepts_all"), this->include_accepts_all,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AcceptsTypesInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenFilePickerOptions::OpenFilePickerOptions()
    : accepts_types_info(),
      can_select_multiple_files() {}

OpenFilePickerOptions::OpenFilePickerOptions(
    AcceptsTypesInfoPtr accepts_types_info_in,
    bool can_select_multiple_files_in)
    : accepts_types_info(std::move(accepts_types_info_in)),
      can_select_multiple_files(std::move(can_select_multiple_files_in)) {}

OpenFilePickerOptions::~OpenFilePickerOptions() = default;

void OpenFilePickerOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accepts_types_info"), this->accepts_types_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AcceptsTypesInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_select_multiple_files"), this->can_select_multiple_files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OpenFilePickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SaveFilePickerOptions::SaveFilePickerOptions()
    : accepts_types_info(),
      suggested_name() {}

SaveFilePickerOptions::SaveFilePickerOptions(
    AcceptsTypesInfoPtr accepts_types_info_in,
    const std::string& suggested_name_in)
    : accepts_types_info(std::move(accepts_types_info_in)),
      suggested_name(std::move(suggested_name_in)) {}

SaveFilePickerOptions::~SaveFilePickerOptions() = default;

void SaveFilePickerOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accepts_types_info"), this->accepts_types_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AcceptsTypesInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggested_name"), this->suggested_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SaveFilePickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectoryPickerOptions::DirectoryPickerOptions()
    : permission_mode() {}

DirectoryPickerOptions::DirectoryPickerOptions(
    ::blink::mojom::FileSystemAccessPermissionMode permission_mode_in)
    : permission_mode(std::move(permission_mode_in)) {}

DirectoryPickerOptions::~DirectoryPickerOptions() = default;
size_t DirectoryPickerOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->permission_mode);
  return seed;
}

void DirectoryPickerOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permission_mode"), this->permission_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FileSystemAccessPermissionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DirectoryPickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FilePickerOptions::FilePickerOptions()
    : type_specific_options(),
      starting_directory_id(),
      start_in_options() {}

FilePickerOptions::FilePickerOptions(
    TypeSpecificFilePickerOptionsUnionPtr type_specific_options_in,
    const std::string& starting_directory_id_in,
    FilePickerStartInOptionsUnionPtr start_in_options_in)
    : type_specific_options(std::move(type_specific_options_in)),
      starting_directory_id(std::move(starting_directory_id_in)),
      start_in_options(std::move(start_in_options_in)) {}

FilePickerOptions::~FilePickerOptions() = default;

void FilePickerOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type_specific_options"), this->type_specific_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TypeSpecificFilePickerOptionsUnionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "starting_directory_id"), this->starting_directory_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_in_options"), this->start_in_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FilePickerStartInOptionsUnionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FilePickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TypeSpecificFilePickerOptionsUnionPtr
TypeSpecificFilePickerOptionsUnion::NewOpenFilePickerOptions(
    OpenFilePickerOptionsPtr value) {
  return TypeSpecificFilePickerOptionsUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kOpenFilePickerOptions)>,
      std::move(value));
}

TypeSpecificFilePickerOptionsUnionPtr
TypeSpecificFilePickerOptionsUnion::NewSaveFilePickerOptions(
    SaveFilePickerOptionsPtr value) {
  return TypeSpecificFilePickerOptionsUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSaveFilePickerOptions)>,
      std::move(value));
}

TypeSpecificFilePickerOptionsUnionPtr
TypeSpecificFilePickerOptionsUnion::NewDirectoryPickerOptions(
    DirectoryPickerOptionsPtr value) {
  return TypeSpecificFilePickerOptionsUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDirectoryPickerOptions)>,
      std::move(value));
}

TypeSpecificFilePickerOptionsUnion::TypeSpecificFilePickerOptionsUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kOpenFilePickerOptions)>,
    OpenFilePickerOptionsPtr value)
    : tag_(Tag::kOpenFilePickerOptions),
      data_(std::in_place_index<static_cast<size_t>(Tag::kOpenFilePickerOptions)>,
            std::move(value)) {}

TypeSpecificFilePickerOptionsUnion::TypeSpecificFilePickerOptionsUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kSaveFilePickerOptions)>,
    SaveFilePickerOptionsPtr value)
    : tag_(Tag::kSaveFilePickerOptions),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSaveFilePickerOptions)>,
            std::move(value)) {}

TypeSpecificFilePickerOptionsUnion::TypeSpecificFilePickerOptionsUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kDirectoryPickerOptions)>,
    DirectoryPickerOptionsPtr value)
    : tag_(Tag::kDirectoryPickerOptions),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDirectoryPickerOptions)>,
            std::move(value)) {}
TypeSpecificFilePickerOptionsUnion::~TypeSpecificFilePickerOptionsUnion() {
  DestroyActive();
}

void TypeSpecificFilePickerOptionsUnion::set_open_file_picker_options(OpenFilePickerOptionsPtr open_file_picker_options) {
  if (tag_ == Tag::kOpenFilePickerOptions) {
    data_.open_file_picker_options = std::move(open_file_picker_options);
  } else {
    DestroyActive();
    tag_ = Tag::kOpenFilePickerOptions;
    new (&data_.open_file_picker_options) OpenFilePickerOptionsPtr(
        std::move(open_file_picker_options));
  }
}

void TypeSpecificFilePickerOptionsUnion::set_save_file_picker_options(SaveFilePickerOptionsPtr save_file_picker_options) {
  if (tag_ == Tag::kSaveFilePickerOptions) {
    data_.save_file_picker_options = std::move(save_file_picker_options);
  } else {
    DestroyActive();
    tag_ = Tag::kSaveFilePickerOptions;
    new (&data_.save_file_picker_options) SaveFilePickerOptionsPtr(
        std::move(save_file_picker_options));
  }
}

void TypeSpecificFilePickerOptionsUnion::set_directory_picker_options(DirectoryPickerOptionsPtr directory_picker_options) {
  if (tag_ == Tag::kDirectoryPickerOptions) {
    data_.directory_picker_options = std::move(directory_picker_options);
  } else {
    DestroyActive();
    tag_ = Tag::kDirectoryPickerOptions;
    new (&data_.directory_picker_options) DirectoryPickerOptionsPtr(
        std::move(directory_picker_options));
  }
}


TypeSpecificFilePickerOptionsUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kOpenFilePickerOptions)>,
    OpenFilePickerOptionsPtr value)
    : open_file_picker_options(std::move(value)) {}

TypeSpecificFilePickerOptionsUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSaveFilePickerOptions)>,
    SaveFilePickerOptionsPtr value)
    : save_file_picker_options(std::move(value)) {}

TypeSpecificFilePickerOptionsUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDirectoryPickerOptions)>,
    DirectoryPickerOptionsPtr value)
    : directory_picker_options(std::move(value)) {}

void TypeSpecificFilePickerOptionsUnion::DestroyActive() {
  switch (tag_) {

    case Tag::kOpenFilePickerOptions:
      std::destroy_at(&data_.open_file_picker_options);
      break;
    case Tag::kSaveFilePickerOptions:
      std::destroy_at(&data_.save_file_picker_options);
      break;
    case Tag::kDirectoryPickerOptions:
      std::destroy_at(&data_.directory_picker_options);
      break;
  }
}

bool TypeSpecificFilePickerOptionsUnion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
FilePickerStartInOptionsUnionPtr
FilePickerStartInOptionsUnion::NewWellKnownDirectory(
    WellKnownDirectory value) {
  return FilePickerStartInOptionsUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kWellKnownDirectory)>,
      std::move(value));
}

FilePickerStartInOptionsUnionPtr
FilePickerStartInOptionsUnion::NewDirectoryToken(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> value) {
  return FilePickerStartInOptionsUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDirectoryToken)>,
      std::move(value));
}

FilePickerStartInOptionsUnion::FilePickerStartInOptionsUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kWellKnownDirectory)>,
    WellKnownDirectory value)
    : tag_(Tag::kWellKnownDirectory),
      data_(std::in_place_index<static_cast<size_t>(Tag::kWellKnownDirectory)>,
            std::move(value)) {}

FilePickerStartInOptionsUnion::FilePickerStartInOptionsUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kDirectoryToken)>,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> value)
    : tag_(Tag::kDirectoryToken),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDirectoryToken)>,
            std::move(value)) {}
FilePickerStartInOptionsUnion::~FilePickerStartInOptionsUnion() {
  DestroyActive();
}

void FilePickerStartInOptionsUnion::set_well_known_directory(WellKnownDirectory well_known_directory) {
  if (tag_ != Tag::kWellKnownDirectory) {
    DestroyActive();
    tag_ = Tag::kWellKnownDirectory;
  }
  data_.well_known_directory = well_known_directory;
}

void FilePickerStartInOptionsUnion::set_directory_token(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> directory_token) {
  if (tag_ == Tag::kDirectoryToken) {
    data_.directory_token = std::move(directory_token);
  } else {
    DestroyActive();
    tag_ = Tag::kDirectoryToken;
    new (&data_.directory_token) ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>(
        std::move(directory_token));
  }
}


FilePickerStartInOptionsUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kWellKnownDirectory)>,
    WellKnownDirectory value)
    : well_known_directory(std::move(value)) {}

FilePickerStartInOptionsUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDirectoryToken)>,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> value)
    : directory_token(std::move(value)) {}

void FilePickerStartInOptionsUnion::DestroyActive() {
  switch (tag_) {

    case Tag::kWellKnownDirectory:
      std::destroy_at(&data_.well_known_directory);
      break;
    case Tag::kDirectoryToken:
      std::destroy_at(&data_.directory_token);
      break;
  }
}

bool FilePickerStartInOptionsUnion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FileSystemAccessManager::IPCStableHashFunction FileSystemAccessManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessManager>(message.name())) {
    case messages::FileSystemAccessManager::kGetSandboxedFileSystem: {
      return &FileSystemAccessManager::GetSandboxedFileSystem_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessManager::kGetSandboxedFileSystemForDevtools: {
      return &FileSystemAccessManager::GetSandboxedFileSystemForDevtools_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessManager::kChooseEntries: {
      return &FileSystemAccessManager::ChooseEntries_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessManager::kGetFileHandleFromToken: {
      return &FileSystemAccessManager::GetFileHandleFromToken_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessManager::kGetDirectoryHandleFromToken: {
      return &FileSystemAccessManager::GetDirectoryHandleFromToken_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessManager::kGetEntryFromDataTransferToken: {
      return &FileSystemAccessManager::GetEntryFromDataTransferToken_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessManager::kBindObserverHost: {
      return &FileSystemAccessManager::BindObserverHost_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessManager>(message.name())) {
      case messages::FileSystemAccessManager::kGetSandboxedFileSystem:
            return "Receive blink::mojom::FileSystemAccessManager::GetSandboxedFileSystem";
      case messages::FileSystemAccessManager::kGetSandboxedFileSystemForDevtools:
            return "Receive blink::mojom::FileSystemAccessManager::GetSandboxedFileSystemForDevtools";
      case messages::FileSystemAccessManager::kChooseEntries:
            return "Receive blink::mojom::FileSystemAccessManager::ChooseEntries";
      case messages::FileSystemAccessManager::kGetFileHandleFromToken:
            return "Receive blink::mojom::FileSystemAccessManager::GetFileHandleFromToken";
      case messages::FileSystemAccessManager::kGetDirectoryHandleFromToken:
            return "Receive blink::mojom::FileSystemAccessManager::GetDirectoryHandleFromToken";
      case messages::FileSystemAccessManager::kGetEntryFromDataTransferToken:
            return "Receive blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferToken";
      case messages::FileSystemAccessManager::kBindObserverHost:
            return "Receive blink::mojom::FileSystemAccessManager::BindObserverHost";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessManager>(message.name())) {
      case messages::FileSystemAccessManager::kGetSandboxedFileSystem:
            return "Receive reply blink::mojom::FileSystemAccessManager::GetSandboxedFileSystem";
      case messages::FileSystemAccessManager::kGetSandboxedFileSystemForDevtools:
            return "Receive reply blink::mojom::FileSystemAccessManager::GetSandboxedFileSystemForDevtools";
      case messages::FileSystemAccessManager::kChooseEntries:
            return "Receive reply blink::mojom::FileSystemAccessManager::ChooseEntries";
      case messages::FileSystemAccessManager::kGetFileHandleFromToken:
            return "Receive reply blink::mojom::FileSystemAccessManager::GetFileHandleFromToken";
      case messages::FileSystemAccessManager::kGetDirectoryHandleFromToken:
            return "Receive reply blink::mojom::FileSystemAccessManager::GetDirectoryHandleFromToken";
      case messages::FileSystemAccessManager::kGetEntryFromDataTransferToken:
            return "Receive reply blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferToken";
      case messages::FileSystemAccessManager::kBindObserverHost:
            return "Receive reply blink::mojom::FileSystemAccessManager::BindObserverHost";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessManager::GetSandboxedFileSystem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x48fc93b6;  // IPCStableHash for blink::mojom::FileSystemAccessManager::GetSandboxedFileSystem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessManager::GetSandboxedFileSystemForDevtools_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x82487a2f;  // IPCStableHash for blink::mojom::FileSystemAccessManager::GetSandboxedFileSystemForDevtools
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessManager::ChooseEntries_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10d9e283;  // IPCStableHash for blink::mojom::FileSystemAccessManager::ChooseEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessManager::GetFileHandleFromToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x777c2080;  // IPCStableHash for blink::mojom::FileSystemAccessManager::GetFileHandleFromToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessManager::GetDirectoryHandleFromToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb22198a8;  // IPCStableHash for blink::mojom::FileSystemAccessManager::GetDirectoryHandleFromToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessManager::GetEntryFromDataTransferToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f4eb76b;  // IPCStableHash for blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessManager::BindObserverHost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac7acbd8;  // IPCStableHash for blink::mojom::FileSystemAccessManager::BindObserverHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback(
      FileSystemAccessManager::GetSandboxedFileSystemCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback(const FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback&) = delete;
  FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback& operator=(const FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessManager::GetSandboxedFileSystemCallback callback_;
};

class FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ForwardToCallback(
      FileSystemAccessManager::GetSandboxedFileSystemForDevtoolsCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ForwardToCallback(const FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ForwardToCallback&) = delete;
  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ForwardToCallback& operator=(const FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessManager::GetSandboxedFileSystemForDevtoolsCallback callback_;
};

class FileSystemAccessManager_ChooseEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessManager_ChooseEntries_ForwardToCallback(
      FileSystemAccessManager::ChooseEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessManager_ChooseEntries_ForwardToCallback(const FileSystemAccessManager_ChooseEntries_ForwardToCallback&) = delete;
  FileSystemAccessManager_ChooseEntries_ForwardToCallback& operator=(const FileSystemAccessManager_ChooseEntries_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessManager::ChooseEntriesCallback callback_;
};

class FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback(
      FileSystemAccessManager::GetEntryFromDataTransferTokenCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback(const FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback&) = delete;
  FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback& operator=(const FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessManager::GetEntryFromDataTransferTokenCallback callback_;
};

FileSystemAccessManagerProxy::FileSystemAccessManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessManagerProxy::GetSandboxedFileSystem(
    GetSandboxedFileSystemCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessManager::GetSandboxedFileSystem");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kGetSandboxedFileSystem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetSandboxedFileSystem");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessManagerProxy::GetSandboxedFileSystemForDevtools(
    const std::vector<std::string>& in_directory_path_components, GetSandboxedFileSystemForDevtoolsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessManager::GetSandboxedFileSystemForDevtools", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_path_components"), in_directory_path_components,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kGetSandboxedFileSystemForDevtools), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->directory_path_components)::BaseType>
      directory_path_components_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& directory_path_components_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_directory_path_components,
    directory_path_components_fragment,
    &directory_path_components_validate_params);

  params->directory_path_components.Set(
      directory_path_components_fragment.is_null() ? nullptr : directory_path_components_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->directory_path_components.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null directory_path_components in FileSystemAccessManager.GetSandboxedFileSystemForDevtools request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetSandboxedFileSystemForDevtools");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessManagerProxy::ChooseEntries(
    FilePickerOptionsPtr in_options, ChooseEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessManager::ChooseEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type FilePickerOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kChooseEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_ChooseEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FilePickerOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in FileSystemAccessManager.ChooseEntries request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("ChooseEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessManager_ChooseEntries_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessManagerProxy::GetFileHandleFromToken(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_token, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessFileHandle> in_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessManager::GetFileHandleFromToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_handle"), in_file_handle,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessFileHandle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kGetFileHandleFromToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetFileHandleFromToken_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessManager.GetFileHandleFromToken request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessFileHandleInterfaceBase>>(
    in_file_handle,
    &params->file_handle,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->file_handle)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid file_handle in FileSystemAccessManager.GetFileHandleFromToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetFileHandleFromToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileSystemAccessManagerProxy::GetDirectoryHandleFromToken(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_token, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessManager::GetDirectoryHandleFromToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_handle"), in_directory_handle,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessDirectoryHandle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kGetDirectoryHandleFromToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessManager.GetDirectoryHandleFromToken request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
    in_directory_handle,
    &params->directory_handle,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->directory_handle)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid directory_handle in FileSystemAccessManager.GetDirectoryHandleFromToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetDirectoryHandleFromToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileSystemAccessManagerProxy::GetEntryFromDataTransferToken(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> in_token, GetEntryFromDataTransferTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kGetEntryFromDataTransferToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDataTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessManager.GetEntryFromDataTransferToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetEntryFromDataTransferToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessManagerProxy::BindObserverHost(
    ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessObserverHost> in_observer_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessManager::BindObserverHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer_host"), in_observer_host,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessObserverHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kBindObserverHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_BindObserverHost_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessObserverHostInterfaceBase>>(
    in_observer_host,
    &params->observer_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer_host in FileSystemAccessManager.BindObserverHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("BindObserverHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessManager::GetSandboxedFileSystemCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder> proxy(
        new FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessManager::GetSandboxedFileSystemCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory);
};

bool FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessManager.0
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> p_directory{};
  FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  }
  return true;
}

void FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessManager::GetSandboxedFileSystem", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kGetSandboxedFileSystem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
    in_directory,
    &params->directory,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetSandboxedFileSystem");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessManager::GetSandboxedFileSystemForDevtoolsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ProxyToResponder> proxy(
        new FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessManager::GetSandboxedFileSystemForDevtoolsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory);
};

bool FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessManager.1
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> p_directory{};
  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  }
  return true;
}

void FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessManager::GetSandboxedFileSystemForDevtools", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kGetSandboxedFileSystemForDevtools), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
    in_directory,
    &params->directory,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetSandboxedFileSystemForDevtools");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessManager_ChooseEntries_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessManager::ChooseEntriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessManager_ChooseEntries_ProxyToResponder> proxy(
        new FileSystemAccessManager_ChooseEntries_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessManager_ChooseEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessManager_ChooseEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessManager_ChooseEntries_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessManager::ChooseEntriesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<::blink::mojom::FileSystemAccessEntryPtr> in_entries);
};

bool FileSystemAccessManager_ChooseEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessManager_ChooseEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessManager_ChooseEntries_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessManager.2
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  std::vector<::blink::mojom::FileSystemAccessEntryPtr> p_entries{};
  FileSystemAccessManager_ChooseEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_entries));
  }
  return true;
}

void FileSystemAccessManager_ChooseEntries_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<::blink::mojom::FileSystemAccessEntryPtr> in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessManager::ChooseEntries", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type std::vector<::blink::mojom::FileSystemAccessEntryPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kChooseEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_ChooseEntries_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileSystemAccessEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("ChooseEntries");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessManager::GetEntryFromDataTransferTokenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder> proxy(
        new FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessManager::GetEntryFromDataTransferTokenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::FileSystemAccessEntryPtr in_entry);
};

bool FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessManager.5
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::blink::mojom::FileSystemAccessEntryPtr p_entry{};
  FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadEntry(&p_entry))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_entry));
  }
  return true;
}

void FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::FileSystemAccessEntryPtr in_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferToken", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry,
                        "<value of type ::blink::mojom::FileSystemAccessEntryPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessManager::kGetEntryFromDataTransferToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->entry)::BaseType> entry_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessEntryDataView>(
    in_entry,
    entry_fragment);

  params->entry.Set(
      entry_fragment.is_null() ? nullptr : entry_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetEntryFromDataTransferToken");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessManagerStubDispatch::Accept(
    FileSystemAccessManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessManager>(message->header()->name)) {
    case messages::FileSystemAccessManager::kGetSandboxedFileSystem: {
      break;
    }
    case messages::FileSystemAccessManager::kGetSandboxedFileSystemForDevtools: {
      break;
    }
    case messages::FileSystemAccessManager::kChooseEntries: {
      break;
    }
    case messages::FileSystemAccessManager::kGetFileHandleFromToken: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessManager_GetFileHandleFromToken_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessManager_GetFileHandleFromToken_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessManager.3
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessFileHandle> p_file_handle{};
      FileSystemAccessManager_GetFileHandleFromToken_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (success) {
        p_file_handle =
            input_data_view.TakeFileHandle<decltype(p_file_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileHandleFromToken(        
        std::move(p_token), 
        std::move(p_file_handle));
      return true;
    }
    case messages::FileSystemAccessManager::kGetDirectoryHandleFromToken: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessManager.4
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessDirectoryHandle> p_directory_handle{};
      FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (success) {
        p_directory_handle =
            input_data_view.TakeDirectoryHandle<decltype(p_directory_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectoryHandleFromToken(        
        std::move(p_token), 
        std::move(p_directory_handle));
      return true;
    }
    case messages::FileSystemAccessManager::kGetEntryFromDataTransferToken: {
      break;
    }
    case messages::FileSystemAccessManager::kBindObserverHost: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessManager_BindObserverHost_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessManager_BindObserverHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessManager.6
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessObserverHost> p_observer_host{};
      FileSystemAccessManager_BindObserverHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer_host =
            input_data_view.TakeObserverHost<decltype(p_observer_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindObserverHost(        
        std::move(p_observer_host));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessManagerStubDispatch::AcceptWithResponder(
    FileSystemAccessManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessManager>(message->header()->name)) {
    case messages::FileSystemAccessManager::kGetSandboxedFileSystem: {
      internal::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessManager.0
      bool success = true;
      FileSystemAccessManager_GetSandboxedFileSystem_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSandboxedFileSystem(std::move(callback));
      return true;
    }
    case messages::FileSystemAccessManager::kGetSandboxedFileSystemForDevtools: {
      internal::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessManager.1
      bool success = true;
      std::vector<std::string> p_directory_path_components{};
      FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirectoryPathComponents(&p_directory_path_components))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 1, false);
        return false;
      }
      auto callback =
          FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSandboxedFileSystemForDevtools(        
        std::move(p_directory_path_components), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessManager::kChooseEntries: {
      internal::FileSystemAccessManager_ChooseEntries_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessManager_ChooseEntries_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessManager.2
      bool success = true;
      FilePickerOptionsPtr p_options{};
      FileSystemAccessManager_ChooseEntries_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 2, false);
        return false;
      }
      auto callback =
          FileSystemAccessManager_ChooseEntries_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChooseEntries(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessManager::kGetFileHandleFromToken: {
      break;
    }
    case messages::FileSystemAccessManager::kGetDirectoryHandleFromToken: {
      break;
    }
    case messages::FileSystemAccessManager::kGetEntryFromDataTransferToken: {
      internal::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessManager.5
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> p_token{};
      FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 5, false);
        return false;
      }
      auto callback =
          FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntryFromDataTransferToken(        
        std::move(p_token), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessManager::kBindObserverHost: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessManagerValidationInfo[] = {
    { &internal::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data::Validate,
     &internal::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data::Validate,
     &internal::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessManager_ChooseEntries_Params_Data::Validate,
     &internal::FileSystemAccessManager_ChooseEntries_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessManager_GetFileHandleFromToken_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data::Validate,
     &internal::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessManager_BindObserverHost_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessManager::Name_,
    kFileSystemAccessManagerValidationInfo);
}

bool FileSystemAccessManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessManager::Name_,
    kFileSystemAccessManagerValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ChooseFileSystemEntryAcceptsOption::DataView, ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr>::Read(
    ::blink::mojom::ChooseFileSystemEntryAcceptsOption::DataView input,
    ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr* output) {
  bool success = true;
  ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr result(::blink::mojom::ChooseFileSystemEntryAcceptsOption::New());
  
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadMimeTypes(&result->mime_types))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AcceptsTypesInfo::DataView, ::blink::mojom::AcceptsTypesInfoPtr>::Read(
    ::blink::mojom::AcceptsTypesInfo::DataView input,
    ::blink::mojom::AcceptsTypesInfoPtr* output) {
  bool success = true;
  ::blink::mojom::AcceptsTypesInfoPtr result(::blink::mojom::AcceptsTypesInfo::New());
  
      if (success && !input.ReadAccepts(&result->accepts))
        success = false;
      if (success)
        result->include_accepts_all = input.include_accepts_all();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::OpenFilePickerOptions::DataView, ::blink::mojom::OpenFilePickerOptionsPtr>::Read(
    ::blink::mojom::OpenFilePickerOptions::DataView input,
    ::blink::mojom::OpenFilePickerOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::OpenFilePickerOptionsPtr result(::blink::mojom::OpenFilePickerOptions::New());
  
      if (success && !input.ReadAcceptsTypesInfo(&result->accepts_types_info))
        success = false;
      if (success)
        result->can_select_multiple_files = input.can_select_multiple_files();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SaveFilePickerOptions::DataView, ::blink::mojom::SaveFilePickerOptionsPtr>::Read(
    ::blink::mojom::SaveFilePickerOptions::DataView input,
    ::blink::mojom::SaveFilePickerOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::SaveFilePickerOptionsPtr result(::blink::mojom::SaveFilePickerOptions::New());
  
      if (success && !input.ReadAcceptsTypesInfo(&result->accepts_types_info))
        success = false;
      if (success && !input.ReadSuggestedName(&result->suggested_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DirectoryPickerOptions::DataView, ::blink::mojom::DirectoryPickerOptionsPtr>::Read(
    ::blink::mojom::DirectoryPickerOptions::DataView input,
    ::blink::mojom::DirectoryPickerOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::DirectoryPickerOptionsPtr result(::blink::mojom::DirectoryPickerOptions::New());
  
      if (success && !input.ReadPermissionMode(&result->permission_mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FilePickerOptions::DataView, ::blink::mojom::FilePickerOptionsPtr>::Read(
    ::blink::mojom::FilePickerOptions::DataView input,
    ::blink::mojom::FilePickerOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::FilePickerOptionsPtr result(::blink::mojom::FilePickerOptions::New());
  
      if (success && !input.ReadTypeSpecificOptions(&result->type_specific_options))
        success = false;
      if (success && !input.ReadStartingDirectoryId(&result->starting_directory_id))
        success = false;
      if (success && !input.ReadStartInOptions(&result->start_in_options))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::TypeSpecificFilePickerOptionsUnion::DataView, ::blink::mojom::TypeSpecificFilePickerOptionsUnionPtr>::Read(
    ::blink::mojom::TypeSpecificFilePickerOptionsUnion::DataView input,
    ::blink::mojom::TypeSpecificFilePickerOptionsUnionPtr* output) {
  using UnionType = ::blink::mojom::TypeSpecificFilePickerOptionsUnion;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kOpenFilePickerOptions: {
      ::blink::mojom::OpenFilePickerOptionsPtr result_open_file_picker_options{};
      if (!input.ReadOpenFilePickerOptions(&result_open_file_picker_options))
        return false;

      *output = UnionType::NewOpenFilePickerOptions(
          std::move(result_open_file_picker_options));
      break;
    }
    case Tag::kSaveFilePickerOptions: {
      ::blink::mojom::SaveFilePickerOptionsPtr result_save_file_picker_options{};
      if (!input.ReadSaveFilePickerOptions(&result_save_file_picker_options))
        return false;

      *output = UnionType::NewSaveFilePickerOptions(
          std::move(result_save_file_picker_options));
      break;
    }
    case Tag::kDirectoryPickerOptions: {
      ::blink::mojom::DirectoryPickerOptionsPtr result_directory_picker_options{};
      if (!input.ReadDirectoryPickerOptions(&result_directory_picker_options))
        return false;

      *output = UnionType::NewDirectoryPickerOptions(
          std::move(result_directory_picker_options));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::FilePickerStartInOptionsUnion::DataView, ::blink::mojom::FilePickerStartInOptionsUnionPtr>::Read(
    ::blink::mojom::FilePickerStartInOptionsUnion::DataView input,
    ::blink::mojom::FilePickerStartInOptionsUnionPtr* output) {
  using UnionType = ::blink::mojom::FilePickerStartInOptionsUnion;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kWellKnownDirectory: {
      ::blink::mojom::WellKnownDirectory result_well_known_directory;
      if (!input.ReadWellKnownDirectory(&result_well_known_directory))
        return false;

      *output = UnionType::NewWellKnownDirectory(result_well_known_directory);
      break;
    }
    case Tag::kDirectoryToken: {
      *output = UnionType::NewDirectoryToken(
          input.TakeDirectoryToken<::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FileSystemAccessManagerInterceptorForTesting::GetSandboxedFileSystem(GetSandboxedFileSystemCallback callback) {
  GetForwardingInterface()->GetSandboxedFileSystem(std::move(callback));
}
void FileSystemAccessManagerInterceptorForTesting::GetSandboxedFileSystemForDevtools(const std::vector<std::string>& directory_path_components, GetSandboxedFileSystemForDevtoolsCallback callback) {
  GetForwardingInterface()->GetSandboxedFileSystemForDevtools(
    std::move(directory_path_components)
    , std::move(callback));
}
void FileSystemAccessManagerInterceptorForTesting::ChooseEntries(FilePickerOptionsPtr options, ChooseEntriesCallback callback) {
  GetForwardingInterface()->ChooseEntries(
    std::move(options)
    , std::move(callback));
}
void FileSystemAccessManagerInterceptorForTesting::GetFileHandleFromToken(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessFileHandle> file_handle) {
  GetForwardingInterface()->GetFileHandleFromToken(
    std::move(token)
    , 
    std::move(file_handle)
    );
}
void FileSystemAccessManagerInterceptorForTesting::GetDirectoryHandleFromToken(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessDirectoryHandle> directory_handle) {
  GetForwardingInterface()->GetDirectoryHandleFromToken(
    std::move(token)
    , 
    std::move(directory_handle)
    );
}
void FileSystemAccessManagerInterceptorForTesting::GetEntryFromDataTransferToken(::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> token, GetEntryFromDataTransferTokenCallback callback) {
  GetForwardingInterface()->GetEntryFromDataTransferToken(
    std::move(token)
    , std::move(callback));
}
void FileSystemAccessManagerInterceptorForTesting::BindObserverHost(::mojo::PendingReceiver<::blink::mojom::FileSystemAccessObserverHost> observer_host) {
  GetForwardingInterface()->BindObserverHost(
    std::move(observer_host)
    );
}
FileSystemAccessManagerAsyncWaiter::FileSystemAccessManagerAsyncWaiter(
    FileSystemAccessManager* proxy) : proxy_(proxy) {}

FileSystemAccessManagerAsyncWaiter::~FileSystemAccessManagerAsyncWaiter() = default;


void FileSystemAccessManagerAsyncWaiter::GetSandboxedFileSystem(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory) {
  base::RunLoop loop;
  proxy_->GetSandboxedFileSystem(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> directory) {*out_result = std::move(result);*out_directory = std::move(directory);
            loop->Quit();
          },
          &loop,
          out_result,
          out_directory));
  loop.Run();
}



void FileSystemAccessManagerAsyncWaiter::GetSandboxedFileSystemForDevtools(
    const std::vector<std::string>& directory_path_components, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory) {
  base::RunLoop loop;
  proxy_->GetSandboxedFileSystemForDevtools(
      std::move(directory_path_components),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> directory) {*out_result = std::move(result);*out_directory = std::move(directory);
            loop->Quit();
          },
          &loop,
          out_result,
          out_directory));
  loop.Run();
}



void FileSystemAccessManagerAsyncWaiter::ChooseEntries(
    FilePickerOptionsPtr options, ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::vector<::blink::mojom::FileSystemAccessEntryPtr>* out_entries) {
  base::RunLoop loop;
  proxy_->ChooseEntries(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             std::vector<::blink::mojom::FileSystemAccessEntryPtr>* out_entries
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             std::vector<::blink::mojom::FileSystemAccessEntryPtr> entries) {*out_result = std::move(result);*out_entries = std::move(entries);
            loop->Quit();
          },
          &loop,
          out_result,
          out_entries));
  loop.Run();
}



void FileSystemAccessManagerAsyncWaiter::GetEntryFromDataTransferToken(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> token, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::blink::mojom::FileSystemAccessEntryPtr* out_entry) {
  base::RunLoop loop;
  proxy_->GetEntryFromDataTransferToken(
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessEntryPtr* out_entry
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::blink::mojom::FileSystemAccessEntryPtr entry) {*out_result = std::move(result);*out_entry = std::move(entry);
            loop->Quit();
          },
          &loop,
          out_result,
          out_entry));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif