// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::WellKnownDirectory>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WellKnownDirectory> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WellKnownDirectory, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WellKnownDirectory, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WellKnownDirectory>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ChooseFileSystemEntryAcceptsOptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ChooseFileSystemEntryAcceptsOptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ChooseFileSystemEntryAcceptsOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in ChooseFileSystemEntryAcceptsOption struct");

    decltype(Traits::mime_types(input)) in_mime_types = Traits::mime_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_types)::BaseType>
        mime_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& mime_types_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_mime_types,
      mime_types_fragment,
      &mime_types_validate_params);

    fragment->mime_types.Set(
        mime_types_fragment.is_null() ? nullptr : mime_types_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mime_types.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_types in ChooseFileSystemEntryAcceptsOption struct");

    decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensions)::BaseType>
        extensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& extensions_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_extensions,
      extensions_fragment,
      &extensions_validate_params);

    fragment->extensions.Set(
        extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extensions in ChooseFileSystemEntryAcceptsOption struct");
  }

  static bool Deserialize(::blink::mojom::internal::ChooseFileSystemEntryAcceptsOption_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ChooseFileSystemEntryAcceptsOptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AcceptsTypesInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AcceptsTypesInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AcceptsTypesInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::accepts(input)) in_accepts = Traits::accepts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accepts)::BaseType>
        accepts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& accepts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ChooseFileSystemEntryAcceptsOptionDataView>>(
      in_accepts,
      accepts_fragment,
      &accepts_validate_params);

    fragment->accepts.Set(
        accepts_fragment.is_null() ? nullptr : accepts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accepts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accepts in AcceptsTypesInfo struct");

    fragment->include_accepts_all = Traits::include_accepts_all(input);
  }

  static bool Deserialize(::blink::mojom::internal::AcceptsTypesInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AcceptsTypesInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::OpenFilePickerOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::OpenFilePickerOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::OpenFilePickerOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::accepts_types_info(input)) in_accepts_types_info = Traits::accepts_types_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accepts_types_info)::BaseType> accepts_types_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AcceptsTypesInfoDataView>(
      in_accepts_types_info,
      accepts_types_info_fragment);

    fragment->accepts_types_info.Set(
        accepts_types_info_fragment.is_null() ? nullptr : accepts_types_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accepts_types_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accepts_types_info in OpenFilePickerOptions struct");

    fragment->can_select_multiple_files = Traits::can_select_multiple_files(input);
  }

  static bool Deserialize(::blink::mojom::internal::OpenFilePickerOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::OpenFilePickerOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SaveFilePickerOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SaveFilePickerOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SaveFilePickerOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::accepts_types_info(input)) in_accepts_types_info = Traits::accepts_types_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accepts_types_info)::BaseType> accepts_types_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AcceptsTypesInfoDataView>(
      in_accepts_types_info,
      accepts_types_info_fragment);

    fragment->accepts_types_info.Set(
        accepts_types_info_fragment.is_null() ? nullptr : accepts_types_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accepts_types_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accepts_types_info in SaveFilePickerOptions struct");

    decltype(Traits::suggested_name(input)) in_suggested_name = Traits::suggested_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggested_name)::BaseType> suggested_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_suggested_name,
      suggested_name_fragment);

    fragment->suggested_name.Set(
        suggested_name_fragment.is_null() ? nullptr : suggested_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggested_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggested_name in SaveFilePickerOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::SaveFilePickerOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SaveFilePickerOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DirectoryPickerOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DirectoryPickerOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DirectoryPickerOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::FileSystemAccessPermissionMode>(
      Traits::permission_mode(input),
      &fragment->permission_mode);
  }

  static bool Deserialize(::blink::mojom::internal::DirectoryPickerOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DirectoryPickerOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FilePickerOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FilePickerOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FilePickerOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::type_specific_options(input)) in_type_specific_options = Traits::type_specific_options(input);
    mojo::internal::MessageFragment<decltype(fragment->type_specific_options)>
        type_specific_options_fragment(fragment.message());
    type_specific_options_fragment.Claim(&fragment->type_specific_options);
    
    mojo::internal::Serialize<::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView>(
      in_type_specific_options,
      type_specific_options_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->type_specific_options.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type_specific_options in FilePickerOptions struct");

    decltype(Traits::starting_directory_id(input)) in_starting_directory_id = Traits::starting_directory_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->starting_directory_id)::BaseType> starting_directory_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_starting_directory_id,
      starting_directory_id_fragment);

    fragment->starting_directory_id.Set(
        starting_directory_id_fragment.is_null() ? nullptr : starting_directory_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->starting_directory_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null starting_directory_id in FilePickerOptions struct");

    decltype(Traits::start_in_options(input)) in_start_in_options = Traits::start_in_options(input);
    mojo::internal::MessageFragment<decltype(fragment->start_in_options)>
        start_in_options_fragment(fragment.message());
    start_in_options_fragment.Claim(&fragment->start_in_options);
    
    mojo::internal::Serialize<::blink::mojom::FilePickerStartInOptionsUnionDataView>(
      in_start_in_options,
      start_in_options_fragment,
      true);
  }

  static bool Deserialize(::blink::mojom::internal::FilePickerOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FilePickerOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::TypeSpecificFilePickerOptionsUnion_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView::Tag::kOpenFilePickerOptions: {
    decltype(Traits::open_file_picker_options(input))
    in_open_file_picker_options = Traits::open_file_picker_options(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_open_file_picker_options)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::OpenFilePickerOptionsDataView>(
  in_open_file_picker_options,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null open_file_picker_options in TypeSpecificFilePickerOptionsUnion union");
    fragment->data.f_open_file_picker_options.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView::Tag::kSaveFilePickerOptions: {
    decltype(Traits::save_file_picker_options(input))
    in_save_file_picker_options = Traits::save_file_picker_options(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_save_file_picker_options)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::SaveFilePickerOptionsDataView>(
  in_save_file_picker_options,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null save_file_picker_options in TypeSpecificFilePickerOptionsUnion union");
    fragment->data.f_save_file_picker_options.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView::Tag::kDirectoryPickerOptions: {
    decltype(Traits::directory_picker_options(input))
    in_directory_picker_options = Traits::directory_picker_options(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_directory_picker_options)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DirectoryPickerOptionsDataView>(
  in_directory_picker_options,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null directory_picker_options in TypeSpecificFilePickerOptionsUnion union");
    fragment->data.f_directory_picker_options.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::TypeSpecificFilePickerOptionsUnion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FilePickerStartInOptionsUnionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::FilePickerStartInOptionsUnionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::FilePickerStartInOptionsUnion_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::FilePickerStartInOptionsUnionDataView::Tag::kWellKnownDirectory: {
    decltype(Traits::well_known_directory(input))
    in_well_known_directory = Traits::well_known_directory(input);
        
mojo::internal::Serialize<::blink::mojom::WellKnownDirectory>(
  in_well_known_directory,
  &fragment->data.f_well_known_directory);
    break;
  }
  case ::blink::mojom::FilePickerStartInOptionsUnionDataView::Tag::kDirectoryToken: {
    decltype(Traits::directory_token(input))
    in_directory_token = Traits::directory_token(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
  in_directory_token,
  &fragment->data.f_directory_token,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_directory_token)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null directory_token in FilePickerStartInOptionsUnion union");
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::FilePickerStartInOptionsUnion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FilePickerStartInOptionsUnionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ChooseFileSystemEntryAcceptsOptionDataView::GetDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ChooseFileSystemEntryAcceptsOptionDataView::GetMimeTypesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->mime_types.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ChooseFileSystemEntryAcceptsOptionDataView::GetExtensionsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->extensions.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void AcceptsTypesInfoDataView::GetAcceptsDataView(
    mojo::ArrayDataView<ChooseFileSystemEntryAcceptsOptionDataView>* output) {
  auto pointer = data_->accepts.Get();
  *output = mojo::ArrayDataView<ChooseFileSystemEntryAcceptsOptionDataView>(pointer, message_);
}


inline void OpenFilePickerOptionsDataView::GetAcceptsTypesInfoDataView(
    AcceptsTypesInfoDataView* output) {
  auto pointer = data_->accepts_types_info.Get();
  *output = AcceptsTypesInfoDataView(pointer, message_);
}


inline void SaveFilePickerOptionsDataView::GetAcceptsTypesInfoDataView(
    AcceptsTypesInfoDataView* output) {
  auto pointer = data_->accepts_types_info.Get();
  *output = AcceptsTypesInfoDataView(pointer, message_);
}
inline void SaveFilePickerOptionsDataView::GetSuggestedNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->suggested_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void FilePickerOptionsDataView::GetTypeSpecificOptionsDataView(
    TypeSpecificFilePickerOptionsUnionDataView* output) {
  auto pointer = &data_->type_specific_options;
  *output = TypeSpecificFilePickerOptionsUnionDataView(pointer, message_);
}
inline void FilePickerOptionsDataView::GetStartingDirectoryIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->starting_directory_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FilePickerOptionsDataView::GetStartInOptionsDataView(
    FilePickerStartInOptionsUnionDataView* output) {
  auto pointer = &data_->start_in_options;
  *output = FilePickerStartInOptionsUnionDataView(pointer, message_);
}


inline void TypeSpecificFilePickerOptionsUnionDataView::GetOpenFilePickerOptionsDataView(
    OpenFilePickerOptionsDataView* output) const {
  CHECK(is_open_file_picker_options());
  *output = OpenFilePickerOptionsDataView(data_->data.f_open_file_picker_options.Get(), message_);
}
inline void TypeSpecificFilePickerOptionsUnionDataView::GetSaveFilePickerOptionsDataView(
    SaveFilePickerOptionsDataView* output) const {
  CHECK(is_save_file_picker_options());
  *output = SaveFilePickerOptionsDataView(data_->data.f_save_file_picker_options.Get(), message_);
}
inline void TypeSpecificFilePickerOptionsUnionDataView::GetDirectoryPickerOptionsDataView(
    DirectoryPickerOptionsDataView* output) const {
  CHECK(is_directory_picker_options());
  *output = DirectoryPickerOptionsDataView(data_->data.f_directory_picker_options.Get(), message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WellKnownDirectory> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WellKnownDirectory value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_SHARED_H_