// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"


namespace blink::mojom {
class ChooseFileSystemEntryAcceptsOptionDataView;

class AcceptsTypesInfoDataView;

class OpenFilePickerOptionsDataView;

class SaveFilePickerOptionsDataView;

class DirectoryPickerOptionsDataView;

class FilePickerOptionsDataView;

class TypeSpecificFilePickerOptionsUnionDataView;
class FilePickerStartInOptionsUnionDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ChooseFileSystemEntryAcceptsOptionDataView> {
  using Data = ::blink::mojom::internal::ChooseFileSystemEntryAcceptsOption_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AcceptsTypesInfoDataView> {
  using Data = ::blink::mojom::internal::AcceptsTypesInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::OpenFilePickerOptionsDataView> {
  using Data = ::blink::mojom::internal::OpenFilePickerOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SaveFilePickerOptionsDataView> {
  using Data = ::blink::mojom::internal::SaveFilePickerOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DirectoryPickerOptionsDataView> {
  using Data = ::blink::mojom::internal::DirectoryPickerOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FilePickerOptionsDataView> {
  using Data = ::blink::mojom::internal::FilePickerOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView> {
  using Data = ::blink::mojom::internal::TypeSpecificFilePickerOptionsUnion_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::FilePickerStartInOptionsUnionDataView> {
  using Data = ::blink::mojom::internal::FilePickerStartInOptionsUnion_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class WellKnownDirectory : int32_t {
  
  kDirDesktop = 0,
  
  kDirDocuments = 1,
  
  kDirDownloads = 2,
  
  kDirMusic = 3,
  
  kDirPictures = 4,
  
  kDirVideos = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WellKnownDirectory value);
inline bool IsKnownEnumValue(WellKnownDirectory value) {
  return internal::WellKnownDirectory_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileSystemAccessManagerInterfaceBase {};

using FileSystemAccessManagerPtrDataView =
    mojo::InterfacePtrDataView<FileSystemAccessManagerInterfaceBase>;
using FileSystemAccessManagerRequestDataView =
    mojo::InterfaceRequestDataView<FileSystemAccessManagerInterfaceBase>;
using FileSystemAccessManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileSystemAccessManagerInterfaceBase>;
using FileSystemAccessManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileSystemAccessManagerInterfaceBase>;


class ChooseFileSystemEntryAcceptsOptionDataView {
 public:
  ChooseFileSystemEntryAcceptsOptionDataView() = default;

  ChooseFileSystemEntryAcceptsOptionDataView(
      internal::ChooseFileSystemEntryAcceptsOption_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetMimeTypesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeTypes(UserType* output) {
    
    auto* pointer = data_->mime_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetExtensionsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ChooseFileSystemEntryAcceptsOption_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AcceptsTypesInfoDataView {
 public:
  AcceptsTypesInfoDataView() = default;

  AcceptsTypesInfoDataView(
      internal::AcceptsTypesInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAcceptsDataView(
      mojo::ArrayDataView<ChooseFileSystemEntryAcceptsOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccepts(UserType* output) {
    
    auto* pointer = data_->accepts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ChooseFileSystemEntryAcceptsOptionDataView>>(
        pointer, output, message_);
  }
  bool include_accepts_all() const {
    return data_->include_accepts_all;
  }
 private:
  internal::AcceptsTypesInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OpenFilePickerOptionsDataView {
 public:
  OpenFilePickerOptionsDataView() = default;

  OpenFilePickerOptionsDataView(
      internal::OpenFilePickerOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAcceptsTypesInfoDataView(
      AcceptsTypesInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAcceptsTypesInfo(UserType* output) {
    
    auto* pointer = data_->accepts_types_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::AcceptsTypesInfoDataView>(
        pointer, output, message_);
  }
  bool can_select_multiple_files() const {
    return data_->can_select_multiple_files;
  }
 private:
  internal::OpenFilePickerOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SaveFilePickerOptionsDataView {
 public:
  SaveFilePickerOptionsDataView() = default;

  SaveFilePickerOptionsDataView(
      internal::SaveFilePickerOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAcceptsTypesInfoDataView(
      AcceptsTypesInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAcceptsTypesInfo(UserType* output) {
    
    auto* pointer = data_->accepts_types_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::AcceptsTypesInfoDataView>(
        pointer, output, message_);
  }
  inline void GetSuggestedNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestedName(UserType* output) {
    
    auto* pointer = data_->suggested_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SaveFilePickerOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DirectoryPickerOptionsDataView {
 public:
  DirectoryPickerOptionsDataView() = default;

  DirectoryPickerOptionsDataView(
      internal::DirectoryPickerOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPermissionMode(UserType* output) const {
    auto data_value = data_->permission_mode;
    return mojo::internal::Deserialize<::blink::mojom::FileSystemAccessPermissionMode>(
        data_value, output);
  }
  ::blink::mojom::FileSystemAccessPermissionMode permission_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FileSystemAccessPermissionMode>(data_->permission_mode));
  }
 private:
  internal::DirectoryPickerOptions_Data* data_ = nullptr;
};


class FilePickerOptionsDataView {
 public:
  FilePickerOptionsDataView() = default;

  FilePickerOptionsDataView(
      internal::FilePickerOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTypeSpecificOptionsDataView(
      TypeSpecificFilePickerOptionsUnionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTypeSpecificOptions(UserType* output) {
    
    auto* pointer = !data_->type_specific_options.is_null() ? &data_->type_specific_options : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::TypeSpecificFilePickerOptionsUnionDataView>(
        pointer, output, message_);
  }
  inline void GetStartingDirectoryIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartingDirectoryId(UserType* output) {
    
    auto* pointer = data_->starting_directory_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStartInOptionsDataView(
      FilePickerStartInOptionsUnionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartInOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FilePickerStartInOptionsUnionDataView, UserType>(),
    "Attempting to read the optional `start_in_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStartInOptions` instead "
    "of `ReadStartInOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->start_in_options.is_null() ? &data_->start_in_options : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FilePickerStartInOptionsUnionDataView>(
        pointer, output, message_);
  }
 private:
  internal::FilePickerOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TypeSpecificFilePickerOptionsUnionDataView {
 public:
  using Tag = internal::TypeSpecificFilePickerOptionsUnion_Data::TypeSpecificFilePickerOptionsUnion_Tag;

  TypeSpecificFilePickerOptionsUnionDataView() = default;

  TypeSpecificFilePickerOptionsUnionDataView(
      internal::TypeSpecificFilePickerOptionsUnion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_open_file_picker_options() const { return data_->tag == Tag::kOpenFilePickerOptions; }
  inline void GetOpenFilePickerOptionsDataView(
      OpenFilePickerOptionsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadOpenFilePickerOptions(UserType* output) const {
    
    CHECK(is_open_file_picker_options());
    return mojo::internal::Deserialize<::blink::mojom::OpenFilePickerOptionsDataView>(
        data_->data.f_open_file_picker_options.Get(), output, message_);
  }
  bool is_save_file_picker_options() const { return data_->tag == Tag::kSaveFilePickerOptions; }
  inline void GetSaveFilePickerOptionsDataView(
      SaveFilePickerOptionsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSaveFilePickerOptions(UserType* output) const {
    
    CHECK(is_save_file_picker_options());
    return mojo::internal::Deserialize<::blink::mojom::SaveFilePickerOptionsDataView>(
        data_->data.f_save_file_picker_options.Get(), output, message_);
  }
  bool is_directory_picker_options() const { return data_->tag == Tag::kDirectoryPickerOptions; }
  inline void GetDirectoryPickerOptionsDataView(
      DirectoryPickerOptionsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDirectoryPickerOptions(UserType* output) const {
    
    CHECK(is_directory_picker_options());
    return mojo::internal::Deserialize<::blink::mojom::DirectoryPickerOptionsDataView>(
        data_->data.f_directory_picker_options.Get(), output, message_);
  }

 private:
  internal::TypeSpecificFilePickerOptionsUnion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class FilePickerStartInOptionsUnionDataView {
 public:
  using Tag = internal::FilePickerStartInOptionsUnion_Data::FilePickerStartInOptionsUnion_Tag;

  FilePickerStartInOptionsUnionDataView() = default;

  FilePickerStartInOptionsUnionDataView(
      internal::FilePickerStartInOptionsUnion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_well_known_directory() const { return data_->tag == Tag::kWellKnownDirectory; }
  template <typename UserType>
  [[nodiscard]] bool ReadWellKnownDirectory(UserType* output) const {
    CHECK(is_well_known_directory());
    return mojo::internal::Deserialize<::blink::mojom::WellKnownDirectory>(
        data_->data.f_well_known_directory, output);
  }
  WellKnownDirectory well_known_directory() const {
    CHECK(is_well_known_directory());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WellKnownDirectory>(data_->data.f_well_known_directory));
  }
  bool is_directory_token() const { return data_->tag == Tag::kDirectoryToken; }
  template <typename UserType>
  UserType TakeDirectoryToken() {
    CHECK(is_directory_token());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
            &data_->data.f_directory_token, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::FilePickerStartInOptionsUnion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_DATA_VIEW_H_