// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class FileSystemAccessManagerProxy;

template <typename ImplRefTraits>
class FileSystemAccessManagerStub;

class FileSystemAccessManagerRequestValidator;
class FileSystemAccessManagerResponseValidator;


class PLATFORM_EXPORT FileSystemAccessManager
    : public FileSystemAccessManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FileSystemAccessManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileSystemAccessManagerInterfaceBase;
  using Proxy_ = FileSystemAccessManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileSystemAccessManagerStub<ImplRefTraits>;

  using RequestValidator_ = FileSystemAccessManagerRequestValidator;
  using ResponseValidator_ = FileSystemAccessManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSandboxedFileSystemMinVersion = 0,
    kGetSandboxedFileSystemForDevtoolsMinVersion = 0,
    kChooseEntriesMinVersion = 0,
    kGetFileHandleFromTokenMinVersion = 0,
    kGetDirectoryHandleFromTokenMinVersion = 0,
    kGetEntryFromDataTransferTokenMinVersion = 0,
    kBindObserverHostMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSandboxedFileSystem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSandboxedFileSystemForDevtools_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ChooseEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFileHandleFromToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDirectoryHandleFromToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetEntryFromDataTransferToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindObserverHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileSystemAccessManager() = default;

  using GetSandboxedFileSystemCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle>)>;
  using GetSandboxedFileSystemMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle>)>;

  virtual void GetSandboxedFileSystem(GetSandboxedFileSystemCallback callback) = 0;

  using GetSandboxedFileSystemForDevtoolsCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle>)>;
  using GetSandboxedFileSystemForDevtoolsMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle>)>;

  virtual void GetSandboxedFileSystemForDevtools(const ::blink::Vector<::blink::String>& directory_path_components, GetSandboxedFileSystemForDevtoolsCallback callback) = 0;

  using ChooseEntriesCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::blink::Vector<::blink::mojom::blink::FileSystemAccessEntryPtr>)>;
  using ChooseEntriesMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::blink::Vector<::blink::mojom::blink::FileSystemAccessEntryPtr>)>;

  virtual void ChooseEntries(FilePickerOptionsPtr options, ChooseEntriesCallback callback) = 0;

  virtual void GetFileHandleFromToken(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessFileHandle> file_handle) = 0;

  virtual void GetDirectoryHandleFromToken(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessDirectoryHandle> directory_handle) = 0;

  using GetEntryFromDataTransferTokenCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::blink::mojom::blink::FileSystemAccessEntryPtr)>;
  using GetEntryFromDataTransferTokenMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::blink::mojom::blink::FileSystemAccessEntryPtr)>;

  virtual void GetEntryFromDataTransferToken(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDataTransferToken> token, GetEntryFromDataTransferTokenCallback callback) = 0;

  virtual void BindObserverHost(::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserverHost> observer_host) = 0;
};



class PLATFORM_EXPORT FileSystemAccessManagerProxy
    : public FileSystemAccessManager {
 public:
  using InterfaceType = FileSystemAccessManager;

  explicit FileSystemAccessManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetSandboxedFileSystem(GetSandboxedFileSystemCallback callback) final;
  
  void GetSandboxedFileSystemForDevtools(const ::blink::Vector<::blink::String>& directory_path_components, GetSandboxedFileSystemForDevtoolsCallback callback) final;
  
  void ChooseEntries(FilePickerOptionsPtr options, ChooseEntriesCallback callback) final;
  
  void GetFileHandleFromToken(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessFileHandle> file_handle) final;
  
  void GetDirectoryHandleFromToken(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessDirectoryHandle> directory_handle) final;
  
  void GetEntryFromDataTransferToken(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDataTransferToken> token, GetEntryFromDataTransferTokenCallback callback) final;
  
  void BindObserverHost(::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserverHost> observer_host) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT FileSystemAccessManagerStubDispatch {
 public:
  static bool Accept(FileSystemAccessManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileSystemAccessManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileSystemAccessManager>>
class FileSystemAccessManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileSystemAccessManagerStub() = default;
  ~FileSystemAccessManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FileSystemAccessManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FileSystemAccessManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class PLATFORM_EXPORT DirectoryPickerOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectoryPickerOptions, T>::value>;
  using DataView = DirectoryPickerOptionsDataView;
  using Data_ = internal::DirectoryPickerOptions_Data;

  template <typename... Args>
  static DirectoryPickerOptionsPtr New(Args&&... args) {
    return DirectoryPickerOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectoryPickerOptionsPtr From(const U& u) {
    return mojo::TypeConverter<DirectoryPickerOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectoryPickerOptions>::Convert(*this);
  }


  DirectoryPickerOptions();

  explicit DirectoryPickerOptions(
      ::blink::mojom::blink::FileSystemAccessPermissionMode permission_mode);


  ~DirectoryPickerOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectoryPickerOptionsPtr>
  DirectoryPickerOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectoryPickerOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DirectoryPickerOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DirectoryPickerOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectoryPickerOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectoryPickerOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectoryPickerOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectoryPickerOptions_UnserializedMessageContext<
            UserType, DirectoryPickerOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DirectoryPickerOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DirectoryPickerOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectoryPickerOptions_UnserializedMessageContext<
            UserType, DirectoryPickerOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectoryPickerOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::blink::FileSystemAccessPermissionMode permission_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectoryPickerOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectoryPickerOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectoryPickerOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectoryPickerOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT TypeSpecificFilePickerOptionsUnion {
 public:
  using DataView = TypeSpecificFilePickerOptionsUnionDataView;
  using Data_ = internal::TypeSpecificFilePickerOptionsUnion_Data;
  using Tag = Data_::TypeSpecificFilePickerOptionsUnion_Tag;

  template <typename... Args>
  static TypeSpecificFilePickerOptionsUnionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |open_file_picker_options|.
  static TypeSpecificFilePickerOptionsUnionPtr NewOpenFilePickerOptions(
      OpenFilePickerOptionsPtr value);
  // Construct an instance holding |save_file_picker_options|.
  static TypeSpecificFilePickerOptionsUnionPtr NewSaveFilePickerOptions(
      SaveFilePickerOptionsPtr value);
  // Construct an instance holding |directory_picker_options|.
  static TypeSpecificFilePickerOptionsUnionPtr NewDirectoryPickerOptions(
      DirectoryPickerOptionsPtr value);

  template <typename U>
  static TypeSpecificFilePickerOptionsUnionPtr From(const U& u) {
    return mojo::TypeConverter<TypeSpecificFilePickerOptionsUnionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TypeSpecificFilePickerOptionsUnion>::Convert(*this);
  }
  ~TypeSpecificFilePickerOptionsUnion();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TypeSpecificFilePickerOptionsUnion(const TypeSpecificFilePickerOptionsUnion& other) = delete;
  TypeSpecificFilePickerOptionsUnion& operator=(const TypeSpecificFilePickerOptionsUnion& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TypeSpecificFilePickerOptionsUnionPtr>
  TypeSpecificFilePickerOptionsUnionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TypeSpecificFilePickerOptionsUnion>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TypeSpecificFilePickerOptionsUnion>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_open_file_picker_options() const { return tag_ == Tag::kOpenFilePickerOptions; }
  const OpenFilePickerOptionsPtr& get_open_file_picker_options() const {
    CHECK(tag_ == Tag::kOpenFilePickerOptions);
    return data_.open_file_picker_options;
  }
  OpenFilePickerOptionsPtr& get_open_file_picker_options() {
    CHECK(tag_ == Tag::kOpenFilePickerOptions);
    return data_.open_file_picker_options;
  }
  void set_open_file_picker_options(OpenFilePickerOptionsPtr open_file_picker_options);

  bool is_save_file_picker_options() const { return tag_ == Tag::kSaveFilePickerOptions; }
  const SaveFilePickerOptionsPtr& get_save_file_picker_options() const {
    CHECK(tag_ == Tag::kSaveFilePickerOptions);
    return data_.save_file_picker_options;
  }
  SaveFilePickerOptionsPtr& get_save_file_picker_options() {
    CHECK(tag_ == Tag::kSaveFilePickerOptions);
    return data_.save_file_picker_options;
  }
  void set_save_file_picker_options(SaveFilePickerOptionsPtr save_file_picker_options);

  bool is_directory_picker_options() const { return tag_ == Tag::kDirectoryPickerOptions; }
  const DirectoryPickerOptionsPtr& get_directory_picker_options() const {
    CHECK(tag_ == Tag::kDirectoryPickerOptions);
    return data_.directory_picker_options;
  }
  DirectoryPickerOptionsPtr& get_directory_picker_options() {
    CHECK(tag_ == Tag::kDirectoryPickerOptions);
    return data_.directory_picker_options;
  }
  void set_directory_picker_options(DirectoryPickerOptionsPtr directory_picker_options);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TypeSpecificFilePickerOptionsUnion::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TypeSpecificFilePickerOptionsUnion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpenFilePickerOptions)>,
        OpenFilePickerOptionsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSaveFilePickerOptions)>,
        SaveFilePickerOptionsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDirectoryPickerOptions)>,
        DirectoryPickerOptionsPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    OpenFilePickerOptionsPtr open_file_picker_options;
    SaveFilePickerOptionsPtr save_file_picker_options;
    DirectoryPickerOptionsPtr directory_picker_options;
  };

  TypeSpecificFilePickerOptionsUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpenFilePickerOptions)>,
      OpenFilePickerOptionsPtr value);
  TypeSpecificFilePickerOptionsUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kSaveFilePickerOptions)>,
      SaveFilePickerOptionsPtr value);
  TypeSpecificFilePickerOptionsUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kDirectoryPickerOptions)>,
      DirectoryPickerOptionsPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT FilePickerStartInOptionsUnion {
 public:
  using DataView = FilePickerStartInOptionsUnionDataView;
  using Data_ = internal::FilePickerStartInOptionsUnion_Data;
  using Tag = Data_::FilePickerStartInOptionsUnion_Tag;

  template <typename... Args>
  static FilePickerStartInOptionsUnionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |well_known_directory|.
  static FilePickerStartInOptionsUnionPtr NewWellKnownDirectory(
      WellKnownDirectory value);
  // Construct an instance holding |directory_token|.
  static FilePickerStartInOptionsUnionPtr NewDirectoryToken(
      ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> value);

  template <typename U>
  static FilePickerStartInOptionsUnionPtr From(const U& u) {
    return mojo::TypeConverter<FilePickerStartInOptionsUnionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FilePickerStartInOptionsUnion>::Convert(*this);
  }
  ~FilePickerStartInOptionsUnion();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FilePickerStartInOptionsUnion(const FilePickerStartInOptionsUnion& other) = delete;
  FilePickerStartInOptionsUnion& operator=(const FilePickerStartInOptionsUnion& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FilePickerStartInOptionsUnionPtr>
  FilePickerStartInOptionsUnionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FilePickerStartInOptionsUnion>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FilePickerStartInOptionsUnion>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_well_known_directory() const { return tag_ == Tag::kWellKnownDirectory; }
  WellKnownDirectory get_well_known_directory() const {
    CHECK(tag_ == Tag::kWellKnownDirectory);
    return data_.well_known_directory;
  }
  void set_well_known_directory(WellKnownDirectory well_known_directory);

  bool is_directory_token() const { return tag_ == Tag::kDirectoryToken; }
  const ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken>& get_directory_token() const {
    CHECK(tag_ == Tag::kDirectoryToken);
    return data_.directory_token;
  }
  ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken>& get_directory_token() {
    CHECK(tag_ == Tag::kDirectoryToken);
    return data_.directory_token;
  }
  void set_directory_token(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> directory_token);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FilePickerStartInOptionsUnion::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FilePickerStartInOptionsUnion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kWellKnownDirectory)>,
        WellKnownDirectory value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDirectoryToken)>,
        ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    WellKnownDirectory well_known_directory;
    ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> directory_token;
  };

  FilePickerStartInOptionsUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kWellKnownDirectory)>,
      WellKnownDirectory value);
  FilePickerStartInOptionsUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kDirectoryToken)>,
      ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT ChooseFileSystemEntryAcceptsOption {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChooseFileSystemEntryAcceptsOption, T>::value>;
  using DataView = ChooseFileSystemEntryAcceptsOptionDataView;
  using Data_ = internal::ChooseFileSystemEntryAcceptsOption_Data;

  template <typename... Args>
  static ChooseFileSystemEntryAcceptsOptionPtr New(Args&&... args) {
    return ChooseFileSystemEntryAcceptsOptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChooseFileSystemEntryAcceptsOptionPtr From(const U& u) {
    return mojo::TypeConverter<ChooseFileSystemEntryAcceptsOptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChooseFileSystemEntryAcceptsOption>::Convert(*this);
  }


  ChooseFileSystemEntryAcceptsOption();

  ChooseFileSystemEntryAcceptsOption(
      const ::blink::String& description,
      ::blink::Vector<::blink::String> mime_types,
      ::blink::Vector<::blink::String> extensions);


  ~ChooseFileSystemEntryAcceptsOption();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChooseFileSystemEntryAcceptsOptionPtr>
  ChooseFileSystemEntryAcceptsOptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChooseFileSystemEntryAcceptsOption::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChooseFileSystemEntryAcceptsOption::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChooseFileSystemEntryAcceptsOption::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChooseFileSystemEntryAcceptsOption_UnserializedMessageContext<
            UserType, ChooseFileSystemEntryAcceptsOption::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChooseFileSystemEntryAcceptsOption::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChooseFileSystemEntryAcceptsOption::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChooseFileSystemEntryAcceptsOption_UnserializedMessageContext<
            UserType, ChooseFileSystemEntryAcceptsOption::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChooseFileSystemEntryAcceptsOption::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String description;
  
  ::blink::Vector<::blink::String> mime_types;
  
  ::blink::Vector<::blink::String> extensions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AcceptsTypesInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AcceptsTypesInfo, T>::value>;
  using DataView = AcceptsTypesInfoDataView;
  using Data_ = internal::AcceptsTypesInfo_Data;

  template <typename... Args>
  static AcceptsTypesInfoPtr New(Args&&... args) {
    return AcceptsTypesInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AcceptsTypesInfoPtr From(const U& u) {
    return mojo::TypeConverter<AcceptsTypesInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AcceptsTypesInfo>::Convert(*this);
  }


  AcceptsTypesInfo();

  AcceptsTypesInfo(
      ::blink::Vector<ChooseFileSystemEntryAcceptsOptionPtr> accepts,
      bool include_accepts_all);

AcceptsTypesInfo(const AcceptsTypesInfo&) = delete;
AcceptsTypesInfo& operator=(const AcceptsTypesInfo&) = delete;

  ~AcceptsTypesInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AcceptsTypesInfoPtr>
  AcceptsTypesInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AcceptsTypesInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AcceptsTypesInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AcceptsTypesInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AcceptsTypesInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AcceptsTypesInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AcceptsTypesInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AcceptsTypesInfo_UnserializedMessageContext<
            UserType, AcceptsTypesInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AcceptsTypesInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AcceptsTypesInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AcceptsTypesInfo_UnserializedMessageContext<
            UserType, AcceptsTypesInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AcceptsTypesInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<ChooseFileSystemEntryAcceptsOptionPtr> accepts;
  
  bool include_accepts_all;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AcceptsTypesInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AcceptsTypesInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AcceptsTypesInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AcceptsTypesInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT OpenFilePickerOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpenFilePickerOptions, T>::value>;
  using DataView = OpenFilePickerOptionsDataView;
  using Data_ = internal::OpenFilePickerOptions_Data;

  template <typename... Args>
  static OpenFilePickerOptionsPtr New(Args&&... args) {
    return OpenFilePickerOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpenFilePickerOptionsPtr From(const U& u) {
    return mojo::TypeConverter<OpenFilePickerOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpenFilePickerOptions>::Convert(*this);
  }


  OpenFilePickerOptions();

  OpenFilePickerOptions(
      AcceptsTypesInfoPtr accepts_types_info,
      bool can_select_multiple_files);

OpenFilePickerOptions(const OpenFilePickerOptions&) = delete;
OpenFilePickerOptions& operator=(const OpenFilePickerOptions&) = delete;

  ~OpenFilePickerOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpenFilePickerOptionsPtr>
  OpenFilePickerOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpenFilePickerOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OpenFilePickerOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OpenFilePickerOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenFilePickerOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenFilePickerOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpenFilePickerOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpenFilePickerOptions_UnserializedMessageContext<
            UserType, OpenFilePickerOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OpenFilePickerOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OpenFilePickerOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpenFilePickerOptions_UnserializedMessageContext<
            UserType, OpenFilePickerOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpenFilePickerOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AcceptsTypesInfoPtr accepts_types_info;
  
  bool can_select_multiple_files;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpenFilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpenFilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpenFilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpenFilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SaveFilePickerOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SaveFilePickerOptions, T>::value>;
  using DataView = SaveFilePickerOptionsDataView;
  using Data_ = internal::SaveFilePickerOptions_Data;

  template <typename... Args>
  static SaveFilePickerOptionsPtr New(Args&&... args) {
    return SaveFilePickerOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SaveFilePickerOptionsPtr From(const U& u) {
    return mojo::TypeConverter<SaveFilePickerOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SaveFilePickerOptions>::Convert(*this);
  }


  SaveFilePickerOptions();

  SaveFilePickerOptions(
      AcceptsTypesInfoPtr accepts_types_info,
      const ::blink::String& suggested_name);

SaveFilePickerOptions(const SaveFilePickerOptions&) = delete;
SaveFilePickerOptions& operator=(const SaveFilePickerOptions&) = delete;

  ~SaveFilePickerOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SaveFilePickerOptionsPtr>
  SaveFilePickerOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SaveFilePickerOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SaveFilePickerOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SaveFilePickerOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SaveFilePickerOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SaveFilePickerOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SaveFilePickerOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SaveFilePickerOptions_UnserializedMessageContext<
            UserType, SaveFilePickerOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SaveFilePickerOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SaveFilePickerOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SaveFilePickerOptions_UnserializedMessageContext<
            UserType, SaveFilePickerOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SaveFilePickerOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AcceptsTypesInfoPtr accepts_types_info;
  
  ::blink::String suggested_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SaveFilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SaveFilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SaveFilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SaveFilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT FilePickerOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FilePickerOptions, T>::value>;
  using DataView = FilePickerOptionsDataView;
  using Data_ = internal::FilePickerOptions_Data;

  template <typename... Args>
  static FilePickerOptionsPtr New(Args&&... args) {
    return FilePickerOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilePickerOptionsPtr From(const U& u) {
    return mojo::TypeConverter<FilePickerOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FilePickerOptions>::Convert(*this);
  }


  FilePickerOptions();

  FilePickerOptions(
      TypeSpecificFilePickerOptionsUnionPtr type_specific_options,
      const ::blink::String& starting_directory_id,
      FilePickerStartInOptionsUnionPtr start_in_options);

FilePickerOptions(const FilePickerOptions&) = delete;
FilePickerOptions& operator=(const FilePickerOptions&) = delete;

  ~FilePickerOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilePickerOptionsPtr>
  FilePickerOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FilePickerOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FilePickerOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FilePickerOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FilePickerOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FilePickerOptions_UnserializedMessageContext<
            UserType, FilePickerOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FilePickerOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FilePickerOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FilePickerOptions_UnserializedMessageContext<
            UserType, FilePickerOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FilePickerOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TypeSpecificFilePickerOptionsUnionPtr type_specific_options;
  
  ::blink::String starting_directory_id;
  
  FilePickerStartInOptionsUnionPtr start_in_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FilePickerOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
TypeSpecificFilePickerOptionsUnionPtr TypeSpecificFilePickerOptionsUnion::Clone() const {
  switch (tag_) {
    case Tag::kOpenFilePickerOptions:
      return NewOpenFilePickerOptions(
          mojo::Clone(data_.open_file_picker_options));
    case Tag::kSaveFilePickerOptions:
      return NewSaveFilePickerOptions(
          mojo::Clone(data_.save_file_picker_options));
    case Tag::kDirectoryPickerOptions:
      return NewDirectoryPickerOptions(
          mojo::Clone(data_.directory_picker_options));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TypeSpecificFilePickerOptionsUnion>::value>::type*>
bool TypeSpecificFilePickerOptionsUnion::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kOpenFilePickerOptions:
      return mojo::Equals(data_.open_file_picker_options, other.data_.open_file_picker_options);
    case Tag::kSaveFilePickerOptions:
      return mojo::Equals(data_.save_file_picker_options, other.data_.save_file_picker_options);
    case Tag::kDirectoryPickerOptions:
      return mojo::Equals(data_.directory_picker_options, other.data_.directory_picker_options);
  }

  return false;
}
template <typename UnionPtrType>
FilePickerStartInOptionsUnionPtr FilePickerStartInOptionsUnion::Clone() const {
  switch (tag_) {
    case Tag::kWellKnownDirectory:
      return NewWellKnownDirectory(
          mojo::Clone(data_.well_known_directory));
    case Tag::kDirectoryToken:
      return NewDirectoryToken(
          mojo::Clone(data_.directory_token));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FilePickerStartInOptionsUnion>::value>::type*>
bool FilePickerStartInOptionsUnion::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kWellKnownDirectory:
      return mojo::Equals(data_.well_known_directory, other.data_.well_known_directory);
    case Tag::kDirectoryToken:
      return mojo::Equals(data_.directory_token, other.data_.directory_token);
  }

  return false;
}
template <typename StructPtrType>
ChooseFileSystemEntryAcceptsOptionPtr ChooseFileSystemEntryAcceptsOption::Clone() const {
  return New(
      mojo::Clone(description),
      mojo::Clone(mime_types),
      mojo::Clone(extensions)
  );
}

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>*>
bool ChooseFileSystemEntryAcceptsOption::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->mime_types, other_struct.mime_types))
    return false;
  if (!mojo::Equals(this->extensions, other_struct.extensions))
    return false;
  return true;
}

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.mime_types < rhs.mime_types)
    return true;
  if (rhs.mime_types < lhs.mime_types)
    return false;
  if (lhs.extensions < rhs.extensions)
    return true;
  if (rhs.extensions < lhs.extensions)
    return false;
  return false;
}
template <typename StructPtrType>
AcceptsTypesInfoPtr AcceptsTypesInfo::Clone() const {
  return New(
      mojo::Clone(accepts),
      mojo::Clone(include_accepts_all)
  );
}

template <typename T, AcceptsTypesInfo::EnableIfSame<T>*>
bool AcceptsTypesInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->accepts, other_struct.accepts))
    return false;
  if (!mojo::Equals(this->include_accepts_all, other_struct.include_accepts_all))
    return false;
  return true;
}

template <typename T, AcceptsTypesInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.accepts < rhs.accepts)
    return true;
  if (rhs.accepts < lhs.accepts)
    return false;
  if (lhs.include_accepts_all < rhs.include_accepts_all)
    return true;
  if (rhs.include_accepts_all < lhs.include_accepts_all)
    return false;
  return false;
}
template <typename StructPtrType>
OpenFilePickerOptionsPtr OpenFilePickerOptions::Clone() const {
  return New(
      mojo::Clone(accepts_types_info),
      mojo::Clone(can_select_multiple_files)
  );
}

template <typename T, OpenFilePickerOptions::EnableIfSame<T>*>
bool OpenFilePickerOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->accepts_types_info, other_struct.accepts_types_info))
    return false;
  if (!mojo::Equals(this->can_select_multiple_files, other_struct.can_select_multiple_files))
    return false;
  return true;
}

template <typename T, OpenFilePickerOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.accepts_types_info < rhs.accepts_types_info)
    return true;
  if (rhs.accepts_types_info < lhs.accepts_types_info)
    return false;
  if (lhs.can_select_multiple_files < rhs.can_select_multiple_files)
    return true;
  if (rhs.can_select_multiple_files < lhs.can_select_multiple_files)
    return false;
  return false;
}
template <typename StructPtrType>
SaveFilePickerOptionsPtr SaveFilePickerOptions::Clone() const {
  return New(
      mojo::Clone(accepts_types_info),
      mojo::Clone(suggested_name)
  );
}

template <typename T, SaveFilePickerOptions::EnableIfSame<T>*>
bool SaveFilePickerOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->accepts_types_info, other_struct.accepts_types_info))
    return false;
  if (!mojo::Equals(this->suggested_name, other_struct.suggested_name))
    return false;
  return true;
}

template <typename T, SaveFilePickerOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.accepts_types_info < rhs.accepts_types_info)
    return true;
  if (rhs.accepts_types_info < lhs.accepts_types_info)
    return false;
  if (lhs.suggested_name < rhs.suggested_name)
    return true;
  if (rhs.suggested_name < lhs.suggested_name)
    return false;
  return false;
}
template <typename StructPtrType>
DirectoryPickerOptionsPtr DirectoryPickerOptions::Clone() const {
  return New(
      mojo::Clone(permission_mode)
  );
}

template <typename T, DirectoryPickerOptions::EnableIfSame<T>*>
bool DirectoryPickerOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->permission_mode, other_struct.permission_mode))
    return false;
  return true;
}

template <typename T, DirectoryPickerOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.permission_mode < rhs.permission_mode)
    return true;
  if (rhs.permission_mode < lhs.permission_mode)
    return false;
  return false;
}
template <typename StructPtrType>
FilePickerOptionsPtr FilePickerOptions::Clone() const {
  return New(
      mojo::Clone(type_specific_options),
      mojo::Clone(starting_directory_id),
      mojo::Clone(start_in_options)
  );
}

template <typename T, FilePickerOptions::EnableIfSame<T>*>
bool FilePickerOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type_specific_options, other_struct.type_specific_options))
    return false;
  if (!mojo::Equals(this->starting_directory_id, other_struct.starting_directory_id))
    return false;
  if (!mojo::Equals(this->start_in_options, other_struct.start_in_options))
    return false;
  return true;
}

template <typename T, FilePickerOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type_specific_options < rhs.type_specific_options)
    return true;
  if (rhs.type_specific_options < lhs.type_specific_options)
    return false;
  if (lhs.starting_directory_id < rhs.starting_directory_id)
    return true;
  if (rhs.starting_directory_id < lhs.starting_directory_id)
    return false;
  if (lhs.start_in_options < rhs.start_in_options)
    return true;
  if (rhs.start_in_options < lhs.start_in_options)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ChooseFileSystemEntryAcceptsOption::DataView,
                                         ::blink::mojom::blink::ChooseFileSystemEntryAcceptsOptionPtr> {
  static bool IsNull(const ::blink::mojom::blink::ChooseFileSystemEntryAcceptsOptionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ChooseFileSystemEntryAcceptsOptionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ChooseFileSystemEntryAcceptsOption::description)& description(
      const ::blink::mojom::blink::ChooseFileSystemEntryAcceptsOptionPtr& input) {
    return input->description;
  }

  static const decltype(::blink::mojom::blink::ChooseFileSystemEntryAcceptsOption::mime_types)& mime_types(
      const ::blink::mojom::blink::ChooseFileSystemEntryAcceptsOptionPtr& input) {
    return input->mime_types;
  }

  static const decltype(::blink::mojom::blink::ChooseFileSystemEntryAcceptsOption::extensions)& extensions(
      const ::blink::mojom::blink::ChooseFileSystemEntryAcceptsOptionPtr& input) {
    return input->extensions;
  }

  static bool Read(::blink::mojom::blink::ChooseFileSystemEntryAcceptsOption::DataView input, ::blink::mojom::blink::ChooseFileSystemEntryAcceptsOptionPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AcceptsTypesInfo::DataView,
                                         ::blink::mojom::blink::AcceptsTypesInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::AcceptsTypesInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AcceptsTypesInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AcceptsTypesInfo::accepts)& accepts(
      const ::blink::mojom::blink::AcceptsTypesInfoPtr& input) {
    return input->accepts;
  }

  static decltype(::blink::mojom::blink::AcceptsTypesInfo::include_accepts_all) include_accepts_all(
      const ::blink::mojom::blink::AcceptsTypesInfoPtr& input) {
    return input->include_accepts_all;
  }

  static bool Read(::blink::mojom::blink::AcceptsTypesInfo::DataView input, ::blink::mojom::blink::AcceptsTypesInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::OpenFilePickerOptions::DataView,
                                         ::blink::mojom::blink::OpenFilePickerOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::OpenFilePickerOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::OpenFilePickerOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::OpenFilePickerOptions::accepts_types_info)& accepts_types_info(
      const ::blink::mojom::blink::OpenFilePickerOptionsPtr& input) {
    return input->accepts_types_info;
  }

  static decltype(::blink::mojom::blink::OpenFilePickerOptions::can_select_multiple_files) can_select_multiple_files(
      const ::blink::mojom::blink::OpenFilePickerOptionsPtr& input) {
    return input->can_select_multiple_files;
  }

  static bool Read(::blink::mojom::blink::OpenFilePickerOptions::DataView input, ::blink::mojom::blink::OpenFilePickerOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SaveFilePickerOptions::DataView,
                                         ::blink::mojom::blink::SaveFilePickerOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::SaveFilePickerOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SaveFilePickerOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SaveFilePickerOptions::accepts_types_info)& accepts_types_info(
      const ::blink::mojom::blink::SaveFilePickerOptionsPtr& input) {
    return input->accepts_types_info;
  }

  static const decltype(::blink::mojom::blink::SaveFilePickerOptions::suggested_name)& suggested_name(
      const ::blink::mojom::blink::SaveFilePickerOptionsPtr& input) {
    return input->suggested_name;
  }

  static bool Read(::blink::mojom::blink::SaveFilePickerOptions::DataView input, ::blink::mojom::blink::SaveFilePickerOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DirectoryPickerOptions::DataView,
                                         ::blink::mojom::blink::DirectoryPickerOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DirectoryPickerOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DirectoryPickerOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::DirectoryPickerOptions::permission_mode) permission_mode(
      const ::blink::mojom::blink::DirectoryPickerOptionsPtr& input) {
    return input->permission_mode;
  }

  static bool Read(::blink::mojom::blink::DirectoryPickerOptions::DataView input, ::blink::mojom::blink::DirectoryPickerOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FilePickerOptions::DataView,
                                         ::blink::mojom::blink::FilePickerOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::FilePickerOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FilePickerOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FilePickerOptions::type_specific_options)& type_specific_options(
      const ::blink::mojom::blink::FilePickerOptionsPtr& input) {
    return input->type_specific_options;
  }

  static const decltype(::blink::mojom::blink::FilePickerOptions::starting_directory_id)& starting_directory_id(
      const ::blink::mojom::blink::FilePickerOptionsPtr& input) {
    return input->starting_directory_id;
  }

  static  decltype(::blink::mojom::blink::FilePickerOptions::start_in_options)& start_in_options(
       ::blink::mojom::blink::FilePickerOptionsPtr& input) {
    return input->start_in_options;
  }

  static bool Read(::blink::mojom::blink::FilePickerOptions::DataView input, ::blink::mojom::blink::FilePickerOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::TypeSpecificFilePickerOptionsUnion::DataView,
                                        ::blink::mojom::blink::TypeSpecificFilePickerOptionsUnionPtr> {
  static bool IsNull(const ::blink::mojom::blink::TypeSpecificFilePickerOptionsUnionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TypeSpecificFilePickerOptionsUnionPtr* output) { output->reset(); }

  static ::blink::mojom::blink::TypeSpecificFilePickerOptionsUnion::Tag GetTag(const ::blink::mojom::blink::TypeSpecificFilePickerOptionsUnionPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::blink::OpenFilePickerOptionsPtr& open_file_picker_options(const ::blink::mojom::blink::TypeSpecificFilePickerOptionsUnionPtr& input) {
    return input->get_open_file_picker_options();
  }

  static const ::blink::mojom::blink::SaveFilePickerOptionsPtr& save_file_picker_options(const ::blink::mojom::blink::TypeSpecificFilePickerOptionsUnionPtr& input) {
    return input->get_save_file_picker_options();
  }

  static const ::blink::mojom::blink::DirectoryPickerOptionsPtr& directory_picker_options(const ::blink::mojom::blink::TypeSpecificFilePickerOptionsUnionPtr& input) {
    return input->get_directory_picker_options();
  }

  static bool Read(::blink::mojom::blink::TypeSpecificFilePickerOptionsUnion::DataView input, ::blink::mojom::blink::TypeSpecificFilePickerOptionsUnionPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::FilePickerStartInOptionsUnion::DataView,
                                        ::blink::mojom::blink::FilePickerStartInOptionsUnionPtr> {
  static bool IsNull(const ::blink::mojom::blink::FilePickerStartInOptionsUnionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FilePickerStartInOptionsUnionPtr* output) { output->reset(); }

  static ::blink::mojom::blink::FilePickerStartInOptionsUnion::Tag GetTag(const ::blink::mojom::blink::FilePickerStartInOptionsUnionPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::blink::WellKnownDirectory well_known_directory(const ::blink::mojom::blink::FilePickerStartInOptionsUnionPtr& input) {
    return input->get_well_known_directory();
  }

  static  ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken>& directory_token( ::blink::mojom::blink::FilePickerStartInOptionsUnionPtr& input) {
    return input->get_directory_token();
  }

  static bool Read(::blink::mojom::blink::FilePickerStartInOptionsUnion::DataView input, ::blink::mojom::blink::FilePickerStartInOptionsUnionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_BLINK_H_