// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::FileSystemAccessAccessHandleLockMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FileSystemAccessAccessHandleLockMode> {};

template <>
struct hash<::blink::mojom::FileSystemAccessWritableFileStreamLockMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FileSystemAccessWritableFileStreamLockMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileSystemAccessAccessHandleLockMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FileSystemAccessAccessHandleLockMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FileSystemAccessAccessHandleLockMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileSystemAccessWritableFileStreamLockMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FileSystemAccessWritableFileStreamLockMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FileSystemAccessWritableFileStreamLockMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileSystemAccessRegularFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileSystemAccessRegularFileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileSystemAccessRegularFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::os_file(input)) in_os_file = Traits::os_file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->os_file)::BaseType> os_file_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_os_file,
      os_file_fragment);

    fragment->os_file.Set(
        os_file_fragment.is_null() ? nullptr : os_file_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->os_file.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null os_file in FileSystemAccessRegularFile struct");

    fragment->file_size = Traits::file_size(input);

    decltype(Traits::file_modification_host(input)) in_file_modification_host = Traits::file_modification_host(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileModificationHostInterfaceBase>>(
      in_file_modification_host,
      &fragment->file_modification_host,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->file_modification_host)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_modification_host in FileSystemAccessRegularFile struct");
  }

  static bool Deserialize(::blink::mojom::internal::FileSystemAccessRegularFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FileSystemAccessRegularFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileSystemAccessAccessHandleFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::FileSystemAccessAccessHandleFileDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::FileSystemAccessAccessHandleFile_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::FileSystemAccessAccessHandleFileDataView::Tag::kRegularFile: {
    decltype(Traits::regular_file(input))
    in_regular_file = Traits::regular_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_regular_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::FileSystemAccessRegularFileDataView>(
  in_regular_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null regular_file in FileSystemAccessAccessHandleFile union");
    fragment->data.f_regular_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::FileSystemAccessAccessHandleFileDataView::Tag::kIncognitoFileDelegate: {
    decltype(Traits::incognito_file_delegate(input))
    in_incognito_file_delegate = Traits::incognito_file_delegate(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileDelegateHostInterfaceBase>>(
  in_incognito_file_delegate,
  &fragment->data.f_incognito_file_delegate,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_incognito_file_delegate)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null incognito_file_delegate in FileSystemAccessAccessHandleFile union");
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::FileSystemAccessAccessHandleFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FileSystemAccessAccessHandleFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FileSystemAccessRegularFileDataView::GetOsFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->os_file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}


inline void FileSystemAccessAccessHandleFileDataView::GetRegularFileDataView(
    FileSystemAccessRegularFileDataView* output) const {
  CHECK(is_regular_file());
  *output = FileSystemAccessRegularFileDataView(data_->data.f_regular_file.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FileSystemAccessAccessHandleLockMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FileSystemAccessAccessHandleLockMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FileSystemAccessWritableFileStreamLockMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FileSystemAccessWritableFileStreamLockMode value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_SHARED_H_