// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"


namespace blink::mojom {
class FileSystemAccessRegularFileDataView;

class FileSystemAccessAccessHandleFileDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FileSystemAccessRegularFileDataView> {
  using Data = ::blink::mojom::internal::FileSystemAccessRegularFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FileSystemAccessAccessHandleFileDataView> {
  using Data = ::blink::mojom::internal::FileSystemAccessAccessHandleFile_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FileSystemAccessAccessHandleLockMode : int32_t {
  
  kReadwrite = 0,
  
  kReadOnly = 1,
  
  kReadwriteUnsafe = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FileSystemAccessAccessHandleLockMode value);
inline bool IsKnownEnumValue(FileSystemAccessAccessHandleLockMode value) {
  return internal::FileSystemAccessAccessHandleLockMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileSystemAccessWritableFileStreamLockMode : int32_t {
  
  kExclusive = 0,
  
  kSiloed = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FileSystemAccessWritableFileStreamLockMode value);
inline bool IsKnownEnumValue(FileSystemAccessWritableFileStreamLockMode value) {
  return internal::FileSystemAccessWritableFileStreamLockMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileSystemAccessFileHandleInterfaceBase {};

using FileSystemAccessFileHandlePtrDataView =
    mojo::InterfacePtrDataView<FileSystemAccessFileHandleInterfaceBase>;
using FileSystemAccessFileHandleRequestDataView =
    mojo::InterfaceRequestDataView<FileSystemAccessFileHandleInterfaceBase>;
using FileSystemAccessFileHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileSystemAccessFileHandleInterfaceBase>;
using FileSystemAccessFileHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileSystemAccessFileHandleInterfaceBase>;


class FileSystemAccessRegularFileDataView {
 public:
  FileSystemAccessRegularFileDataView() = default;

  FileSystemAccessRegularFileDataView(
      internal::FileSystemAccessRegularFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOsFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOsFile(UserType* output) {
    
    auto* pointer = data_->os_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  int64_t file_size() const {
    return data_->file_size;
  }
  template <typename UserType>
  UserType TakeFileModificationHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileModificationHostInterfaceBase>>(
            &data_->file_modification_host, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FileSystemAccessRegularFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemAccessAccessHandleFileDataView {
 public:
  using Tag = internal::FileSystemAccessAccessHandleFile_Data::FileSystemAccessAccessHandleFile_Tag;

  FileSystemAccessAccessHandleFileDataView() = default;

  FileSystemAccessAccessHandleFileDataView(
      internal::FileSystemAccessAccessHandleFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_regular_file() const { return data_->tag == Tag::kRegularFile; }
  inline void GetRegularFileDataView(
      FileSystemAccessRegularFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegularFile(UserType* output) const {
    
    CHECK(is_regular_file());
    return mojo::internal::Deserialize<::blink::mojom::FileSystemAccessRegularFileDataView>(
        data_->data.f_regular_file.Get(), output, message_);
  }
  bool is_incognito_file_delegate() const { return data_->tag == Tag::kIncognitoFileDelegate; }
  template <typename UserType>
  UserType TakeIncognitoFileDelegate() {
    CHECK(is_incognito_file_delegate());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileDelegateHostInterfaceBase>>(
            &data_->data.f_incognito_file_delegate, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::FileSystemAccessAccessHandleFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_DATA_VIEW_H_